// test TASK and EVENT in Linux

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <stdio.h>
#include <unistd.h>
#include "perr.h"	// for compatible with P1400 code


/* ====================================================================================
 *     P T H R E A D 
 * ====================================================================================
 */
#include <pthread.h>
#include <sys/time.h>
#include <errno.h>


/* ====================================================================================
 *     P S O S +    H E A D E R S
 * ====================================================================================
 */

#include "phile.h"

//#define TEST_REENTRANCE	1

#define MAX_EVENTS	16

static unsigned long thread_flag;

#ifdef TEST_REENTRANCE
  pthread_cond_t evThrdead_cv[MAX_EVENTS];
#else
  pthread_cond_t thread_flag_cv;
#endif
pthread_mutex_t thread_flag_mutex;
pthread_t DDNS_thread_id;

#define err_abort(code, text)

void initialize_flag(void)
{
//	int i;
	
	pthread_mutex_init(&thread_flag_mutex, NULL);
#ifdef TEST_REENTRANCE
	for (i=0; i<MAX_EVENTS; i++) {
		pthread_cond_init(&evThrdead_cv[i], NULL);
	}
#else
	pthread_cond_init(&thread_flag_cv, NULL);
#endif
	
	thread_flag=0;
	
}


void destroy_flag(void)
{	
#ifdef TEST_REENTRANCE
	for (i=0; i<MAX_EVENTS; i++) {
		pthread_cond_destroy(&evThrdead_cv[i]);
	}
#else
	pthread_cond_destroy(&thread_flag_cv);
#endif

	pthread_mutex_destroy(&thread_flag_mutex);
	
	//thread_flag=0;
	
}

/* ====================================================================================
 *     P S O S +     I N T E R N A L 
 * ====================================================================================
 */


#define MAX_TASKS	20

struct PSOS_task_t {
	char pst_name[4];
	unsigned long pst_tid;
	pthread_t thread_id;
};

static struct PSOS_task_t g_Task[MAX_TASKS];
static int g_nTasks=0;

#define TID_BASE_IDX	3000



/* ====================================================================================
 *     P S O S +     A P I
 * ====================================================================================
 */

#define SUCCESS		0x0
#define ERR_TSTART	0x1001
#define ERR_OBJID	0x1006
#define ERR_NOTCB	0x100E

unsigned long t_create(char name[4], unsigned long prio, unsigned long sstack, unsigned long ustack, unsigned long flags, unsigned long *tid)
{
	int i;
	int n;
	struct PSOS_task_t *pTask;
	
	n = g_nTasks++;
	if (n >= MAX_TASKS) return ERR_NOTCB;
	
	pTask = &g_Task[n];
	for (i=0; i<4; i++) {
		pTask->pst_name[i] = name[i];
	}

	*tid = pTask->pst_tid = n + TID_BASE_IDX;

	initialize_flag();

	return SUCCESS;
}

static struct PSOS_task_t *get_task(unsigned long tid)
{
	int i;
	
	i = tid - TID_BASE_IDX;
	if (i >=  MAX_TASKS) return NULL;
	
	return &g_Task[i];
}

unsigned long t_start(unsigned long tid, unsigned long mode, void *(*start_addr)(void *), unsigned long targs[4])
{
	int status;
	struct PSOS_task_t *pTask;
//	int i;

#if 0
	i = tid - TID_BASE_IDX;
	if (i >=  MAX_TASKS) return ERR_OBJID;
	
	pTask = &g_Task[i];
#endif
	pTask = get_task(tid);
	if (pTask == NULL) return ERR_OBJID;
	
	//status =  pthread_create(&DDNS_thread_id, NULL, DDNS_task, NULL);
	status =  pthread_create(&(pTask->thread_id), NULL, start_addr, NULL);
	//jpr("create thread id=%ld\n", pTask->thread_id); // debug
	if (status != 0) {
		printf("ERROR on creating pthread\n");
		return ERR_TSTART;
	}

	return SUCCESS;
}


unsigned long t_delete(unsigned long tid)
{
        unsigned long rc =0;
	struct PSOS_task_t *pTask;
	
	pTask = get_task(tid);
	if (pTask == NULL) return ERR_OBJID;

	// remove this task structure
	//jpr("destroy thread id=%ld\n", pTask->thread_id); // debug
	if (pthread_join(pTask->thread_id, NULL) != 0) {
		printf("Error to join pthread!!\n");
		rc=0x123; // just test
	}

	destroy_flag();

        return rc;
}


unsigned long t_ident(char name[4], unsigned long node, unsigned long *tid)
{
        unsigned long rc =0;

        return rc;
}


/*
 * NOTE: partially implement pSOS+ system call
 *
 * Now there may be problem of re-entrance
 *
 * Reference:
 *	pp.123-127 from Butenhof's Book
 *
 */ 
unsigned long ev_send(unsigned long tid, unsigned long events)
{
	unsigned long rc=0;
	int status;
#ifdef TEST_REENTRANCE
	int i;
	unsigned long bitmask=0x0001;
#endif

	//jpr("EVsend=0x%04X\n", events);  // debug

	status = pthread_mutex_lock(&thread_flag_mutex);
	if (status != 0) err_abort(status, "Lock server mutex");
	
	thread_flag = events;

#ifdef TEST_REENTRANCE
	// send signals sequentially
	for (i=0; i<MAX_EVENTS; i++) {
		if ((bitmask << i) & events) {
			status = pthread_cond_signal(&evThrdead_cv[i]);
			if (status != 0) err_abort(status, "pthread cond signal");
		}
	} // END for-loop
#else
	status = pthread_cond_signal(&thread_flag_cv);
	if (status != 0) err_abort(status, "pthread cond signal");
#endif
	
	status = pthread_mutex_unlock(&thread_flag_mutex);
	if (status != 0) err_abort(status, "Unlock server mutex");

	return rc;

}


// NOTE: partially implement pSOS+ system call
// timeout is no use on ucLinux!
unsigned long ev_receive(unsigned long events, unsigned long flags, unsigned long timeout, unsigned long *events_r)
{
	unsigned long rc=0;
	int status;
//	int i;
	struct timeval now;

	//jpr_msg(JPR_DEBUG, "EVrecv=0x%04X, timeout=%d\n", events, timeout); // debug
	jpr("EVrecv=0x%04X, timeout=%d\n", events, timeout); // debug

	status = pthread_mutex_lock(&thread_flag_mutex);
	if (status != 0) err_abort(status, "Lock server mutex");

	if (timeout) gettimeofday(&now, NULL);
	
	// Jsn NOTE: it seems not block the thread, the printf inside while-loop still active!!
	while (1) {
		//printf("EVwait=0x%08X, thread_flag=0x%08X\n", events, thread_flag);
		if (thread_flag & events) break; // EV_ANY
		
		//status = pthread_cond_wait(&thread_flag_cv, &thread_flag_mutex);
		if (timeout) {
			struct timespec tmout;
			tmout.tv_sec = now.tv_sec + timeout/100;
			//tmout.tv_nsec = (timeout%100)*10*1000*1000; // from unit of 10ms to nano-seconds
			tmout.tv_nsec = now.tv_usec*1000 + (timeout%100)*10*1000*1000;
			status = pthread_cond_timedwait(&thread_flag_cv, &thread_flag_mutex, &tmout);
			if (status == ETIMEDOUT) {
				printf("Condition Wait Timeout!\n");
				break;
			}
		}
		else {
			status = pthread_cond_wait(&thread_flag_cv, &thread_flag_mutex);
			//status = pthread_cond_wait(&evThrdead_cv[i], &thread_flag_mutex);
		}
		if (status != 0) err_abort(status, "pthread cond wait");
	}
	*events_r = thread_flag;
	//printf("events_r=0x%08X\n", *events_r); // debug
	
	status = pthread_mutex_unlock(&thread_flag_mutex);
	if (status != 0) err_abort(status, "Unlock server mutex");
	
	
	//set_thread_flag(0); // if flag is not reset, this while-loop will not terminate!
	//ev_send(0, 0);
	thread_flag=0;
	


	return rc;

}

//static unsigned long thread_flag;
static unsigned long ddns_done;
pthread_cond_t DdnsDone_cv;


unsigned long ev_psnd(unsigned long tid, unsigned long events)
{
	unsigned long rc=0;
	int status;

	//jpr("psnd=0x%04X\n", events);  // debug

	status = pthread_mutex_lock(&thread_flag_mutex);
	if (status != 0) err_abort(status, "Lock server mutex");
	
	//thread_flag = events;
	ddns_done = events;

	//status = pthread_cond_signal(&thread_flag_cv);
	status = pthread_cond_signal(&DdnsDone_cv);
	if (status != 0) err_abort(status, "pthread cond signal");
	
	status = pthread_mutex_unlock(&thread_flag_mutex);
	if (status != 0) err_abort(status, "Unlock server mutex");

	return rc;

}




// NOTE: partially implement pSOS+ system call
// timeout is no use on ucLinux!
unsigned long ev_pwait(unsigned long events, unsigned long flags, unsigned long timeout, unsigned long *events_r)
{
	unsigned long rc=0;
	int status;
//	int i;
	struct timeval now;

	//jpr("EVrecv=0x%04X, timeout=%d\n", events, timeout); // debug

	status = pthread_mutex_lock(&thread_flag_mutex);
	if (status != 0) err_abort(status, "Lock server mutex");

	if (timeout) gettimeofday(&now, NULL);
	
	// Jsn NOTE: it seems not block the thread, the printf inside while-loop still active!!
	while (1) {
		//printf("EVwait=0x%08X, thread_flag=0x%08X\n", events, thread_flag);
		if (ddns_done & events) break; // EV_ANY
		
		//status = pthread_cond_wait(&thread_flag_cv, &thread_flag_mutex);
		if (timeout) {
			struct timespec tmout;
			tmout.tv_sec = now.tv_sec + timeout/100;
			//tmout.tv_nsec = (timeout%100)*10*1000*1000; // from unit of 10ms to nano-seconds
			tmout.tv_nsec = now.tv_usec*1000 + (timeout%100)*10*1000*1000;
			status = pthread_cond_timedwait(&DdnsDone_cv, &thread_flag_mutex, &tmout);
			if (status == ETIMEDOUT) {
				printf("Condition Wait Timeout!\n");
				break;
			}
		}
		else {
			status = pthread_cond_wait(&DdnsDone_cv, &thread_flag_mutex);
			//status = pthread_cond_wait(&evThrdead_cv[i], &thread_flag_mutex);
		}
		if (status != 0) err_abort(status, "pthread cond wait");
	}
	*events_r = ddns_done;
	//printf("events_r=0x%08X\n", *events_r); // debug
	
	status = pthread_mutex_unlock(&thread_flag_mutex);
	if (status != 0) err_abort(status, "Unlock server mutex");
	
	
	//set_thread_flag(0); // if flag is not reset, this while-loop will not terminate!
	//ev_send(0, 0);
	ddns_done=0;

	return rc;

}





//////////////////////////////////////////
/*
 *	Other pSOS+ system calls
 *
 *
 *
 */

#include <time.h>

unsigned long tm_get(unsigned long *pdate, unsigned long *ptime, unsigned long *pticks)
{
        unsigned long rc =0;
	time_t t;
	struct tm st;

	if (time(&t) < 0) {
		rc = 0x48; goto err;
	}

	if (localtime_r(&t, &st) == NULL) {
		rc = 0x48; goto err;
	}

	*pdate = (st.tm_year+1900) << 16;
	*pdate += (st.tm_mon+1) << 8;
	*pdate += st.tm_mday;

	*ptime = st.tm_hour << 16;
	*ptime += st.tm_min << 8; 
	*ptime += st.tm_sec;

	*pticks = 0;

	//printf("date=0x%08lX\n", *pdate);
	//printf("time=0x%08lX\n", *ptime);


err:
        return rc;
}



unsigned long tm_cancel(unsigned long tmid)
{
        unsigned long rc =0;

        return rc;
}


unsigned long tm_evevery(unsigned long ticks, unsigned long events, unsigned long *tmid)
{
        unsigned long rc =0;

        return rc;
}



// <ticks> is in unit of <10ms>
unsigned long tm_wkafter(unsigned long ticks)
{
	usleep(ticks*10*1000);
	return 0;
}



unsigned long sm_create(char name[4], unsigned long count, unsigned long flags, unsigned long *smid)
{
        unsigned long rc =0;

        return rc;
}



/* jsn: Aug 29, 2006 
 *
 *	pSOS+ system call implemented by Linux
 *	
 *	Goal: A Simple FTP Client
 *
 */


unsigned long open_f(unsigned long *fid, const char *name, unsigned long mode)
{
	int fd;

	fd = open(name, O_RDWR);
	if (fd < 0) {
		return E_GENERICERR;
	}

	*fid = fd;
	
	//return E_NOIMPLEMENT;
	return 0; // Success
}


unsigned long close_f(unsigned long fid)
{
	if (close(fid) != 0) {
		return E_GENERICERR;
	}
		
	return 0; // Success
}

#if 0
// Definition may be conflict with stat call of Linux
unsigned long stat_f(char *name, struct stat *buf)
{
	return E_NOIMPLEMENT;
}
#endif


unsigned long change_dir(char *name)
{
	return E_NOIMPLEMENT;
}
	

unsigned long read_f(unsigned long fid, void *buffer, unsigned long bcount, unsigned long *tcount)
{
	ssize_t n;
	
	n = read(fid, buffer, bcount);
	if (n < 0) {
		return E_GENERICERR;
	}
	
	*tcount = n;
//	if (n != bcount) {}

	return 0; // Success
}



