/*
 *  jsnutils/ixp_porting.h
 *
 *  Copyright (C) 2005  Jason Chang, 
 *  Email: jasonchang@pixord
 *
 *  2005/10/08  -  create this file for porting from P1400 to IXP
 *
 */


#ifndef	__IXP_PORTING_H__
#define	__IXP_PORTING_H__


#define MAXLEN_IPSTR		16

// from pSOS+/wconfigs.h
#define MIN_NUM			64


#ifndef ULONG
  #define ULONG unsigned long
#endif

#ifndef USHORT
  #define USHORT unsigned short 
#endif

#ifndef U32
  #define U32 unsigned long
#endif

#ifndef U16
  #define U16 unsigned short 
#endif

#ifndef U8
//  #define U8 unsigned char
  #define U8 char  
#endif

#ifndef uchar
typedef unsigned char uchar;
#endif

#ifndef uint32
  #define uint32 unsigned int
#endif

typedef unsigned short uint16;


// Now MTD3 may be read-only, so we use MTD7 to test
#define NVRAM_MTDNAME	"/dev/mtd7"


/*
 * define the offset of network parameters
 * should check with bootloader
 * DO NOT use hardcode forever
 */
#define REDBOOT_ETH0_DEFGW	0x0291
#define REDBOOT_ETH0_IPADDR	0x02AB
#define REDBOOT_ETH0_NETMASK	0x02CA
#define REDBOOT_ETH0_TFTPSVR	0x02E8


struct netcfg_t {
	uchar ip[4];
	uchar netmask[4];
	uchar defgw[4];
};



// from pSOS+/event/event.h
//Error Code
#define dEvNull 	0

typedef enum  {
	dEvParseFail	=-2,
	dEvNoEvent	=-1,
	dEvOK		=0,
	dEvPhrasingErr,
	dEvRunErr,
	dEvStartActErr,
	dEvStopActErr,
	dEvHandArgErr,
	dEvMiscErr,
	dEvBufferTaskErr,
	dEvCompareNotSame,
	dEvBuffInitErr,
	dEvBuffStartErr,
	dEvBuffBlocked,
	dEvFtpErr,
	dEvMotionErr,
	dEvSmtpErr,
	dEvSendDone,
	dEvMotionDetected,
	dEvServerPushOut,
	dEvParseErr,
	dEvDiagFail,
} dEvResult;

// from pSOS+ system calls
  #define SM_WAIT       1
  #define SM_LOCAL      2
  #define SM_FIFO	3

  #define EV_WAIT       3
  #define EV_ANY        4

#define TCP_MSL		0


// pSOS+, pixord code	

  #define CGI_OK        5


// from pSOS+/iSmtp.h
#define		SCKT_ATTR_LEN		16

// from pSOS+/stdinc.h
  #define EvErrPrt(s)			{printf s;}
  #define EvPRT(s)			{printf s;}


// other utilities


// FUNCTION PROTOTYPES
// to compatible with WIS
extern char *nvram_safe_get(const char *src);

extern int Read_MTDname(const char *dev, void *buff, int mem_size);
extern int Prog_MTD(int dst_fd, size_t start, size_t len, const char *src_buf);
extern int Prog_MTDname(const char *dev, uint32 start, uint32 len, const char *src_buf);

#endif // __IXP_PORTING_H__
