
#define	AP_NAME					"IP_INSTALLER_SERVER:"
#define	HTTPD_CONF_FILE				"/etc/httpd/conf/httpd.conf"
#define	DNS_FNAME				"/etc/resolv.conf"

#define	SEPARATOR_COLON				':'
#define	MAXLEN_ETHERMAC				6

#define	WBC_VERSION_MAJOR       		99
#define	WBC_VERSION_MINOR       		88
#define	WBC_VERSION_SUFFIX      		"ab"

#define	FINDSVR_IDENTIFIER			"96c363be-b894-43b5-8501-ae5c00e779b3"
#define	BOOTP_STATUS_NORMAL			1
#define	BOOTP_STATUS_SETTING			2

#define	IPINST_OPCODE_FINDSVR			0
#define	IPINST_OPCODE_SETSVR			1

#define	IPINST_OPCODE_OK			6

#define	IPINST_OPCODE_FAIL			3
#define	IPINST_OPCODE_NOPERM			4

#define	BPMACADDR_NOMATCH			0
#define	BPMACADDR_MYSELF			1
#define	BPMACADDR_BROADCAST			2

#define	IPINST_PORT_SERVER			58797
#define	IPINST_PORT_CLIENT			58798

#define	SZ_PKT_IDENTIFIER			40
#define	BSP_LAN1_HWALEN				6
#define	MAXLEN_PKT_USER				48
#define	MAXLEN_PKT_PASS				48

#define	SZ_RECV_BUFF				1500
#define	SZ_SEND_BUFF				32

#define	IPN_VERSION_MAXLEN			32
#define	IF0_NAME				"rausb0"

#define	DEFGW_DEL				1
#define	DEFGW_FIND				2
#define DEFAULT_SETTING "1: root: Login: a32479b5f82b8c6ba5f45d5996fb0667"

#ifndef	ULONG
#define	ULONG	uint32_t
#endif

#include "debug.h"
#include "inf_func.h"

typedef struct {
	char guid[SZ_PKT_IDENTIFIER];
	char comm_id[SZ_PKT_IDENTIFIER];
	short len;
	char must_know;
	char op_code;
	char mac_addr[BSP_LAN1_HWALEN];
	char ipn_flag;
	char reserved;
	ULONG ip_addr;
	ULONG subnet_msk;
	ULONG def_gateway;
	ULONG dns1;
	ULONG dns2;
	ULONG dns3;
	ushort httpPort;
	char rsved2[2];
	char username[MAXLEN_PKT_USER];
	char password[MAXLEN_PKT_PASS];
	char info[40];

	char version[IPN_VERSION_MAXLEN];
	char model[16];
	char brand[16];
	char username_pppoe[48];
	char password_pppoe[48];
} FindSvrPkt_t;

static int Cmp_Macaddr(int mac_len, char *mac_addr, char *interface);
static int GetHwAddr(const char *ifname, char *hwaddr);
static int Do_DefGw(int skfd, int op, unsigned long *gw_addr);

static int FillReplyPacket(struct SHM_INFO_STRUCT *shm, FindSvrPkt_t * pkt, char *interface);
static int UDP_Broadcast(int sckt, int port, char *buf, int len, char *interface);
static int IPN_AddRoute(int skfd, unsigned long dest_ip, unsigned long gw_ip, int flags);
static int RandomDelay(ULONG max_ms);
static int MAC_Byte(char *hwaddr, int iByte);
static int GetMacPos(const char *str, int pos);
static int RandomInit();
//static void PRINT_PKG(FindSvrPkt_t * pkg);
static int Linux_SetParams(struct SHM_INFO_STRUCT *shm, FindSvrPkt_t * recvPkt);
static int Linux_SetParams_W(struct SHM_INFO_STRUCT *shm, FindSvrPkt_t * recvPkt);
static ULONG jsnet_aton(char *str);
void jsnet_ntoa2(ULONG address, char *val);

//static int Do_DefGw(int skfd, int op, unsigned long *gw_addr);
//static int Del_Gw_00(int skfd, char *ifname);
//static int CheckPermission(FindSvrPkt_t *pkt);
//static int GetHttpsStatus(char *info, int n);
