#include <unistd.h>	//for truncate

#include "filebufferQueue.h"
#include "bcommon.h"

filebufferQueue::
filebufferQueue ( unsigned long size, char *filename) :bufferQueue (){
	this->arraySize = size;	
	makeEmpty();
	
	snprintf (buffer_filename, sizeof(buffer_filename), "%s", filename);
	allocBuffer();
	m_DEBUG ("filebufferQueue constructor \n");		

	return;	
}

filebufferQueue::
filebufferQueue ( unsigned long size ) :bufferQueue (){	
	this->arraySize = size;	
	makeEmpty();
	
	snprintf (buffer_filename, sizeof(buffer_filename), "%s", "/var/tmp/filebufferQueue.tmp");	
	allocBuffer();

	m_DEBUG ("filebufferQueue constructor\n");
	return;	
}

filebufferQueue::
~filebufferQueue ()  {
	
	if ( this->theArray != 0 )
		releaseBuffer ();

	m_DEBUG ("[filebufferQueue::~filebufferQueue]: destructor\n");
}

void filebufferQueue::
NormalDataAppend (void *d, unsigned long offset, unsigned char *src, unsigned long length) {

	FILE 	*fp = (FILE*) d;

	if ( fseek ( fp, offset, SEEK_SET) ) {
		printf ("[filebufferQueue:NormalDataAppend] fseek fail !\n");	
		return;
	}
	
	if  (  fwrite ( src, sizeof(unsigned char), length, fp)  != length )
		printf ("filebufferQueue::NormalDataAppend] fwrite fail\n");
	
	fflush(fp);
	m_DEBUG ("[filebufferQueue:NormalDataAppend] ftell = %ld\n", ftell ( fp));	
	
}

void filebufferQueue::
MultiPartDataAppend (void *d, unsigned long offset, unsigned char *src, unsigned long length1, unsigned long length2) {
	FILE 	*fp = (FILE*) d;
	
	if ( fseek ( fp, offset, SEEK_SET) ) {
		printf ("[filebufferQueue:MultiPartDataAppend] fseek fail !\n");	
		return;
	}
	if ( fwrite ( src, sizeof(unsigned char), length1, fp)  != length1 )
		printf ("filebufferQueue::MultiPartDataAppend] length1 fwrite fail\n");
	
	if ( fseek ( fp, 0, SEEK_SET) ) {
		printf ("[filebufferQueue:MultiPartDataAppend] fseek fail !\n");	
		return;
	}
	if ( fwrite ( src+length1, sizeof(unsigned char), length2, fp) != length2 )
		printf ("filebufferQueue::MultiPartDataAppend] length2 fwrite fail\n");
	fflush(fp);
	m_DEBUG ("[filebufferQueue:MultiPartDataAppend] ftell = %ld\n", ftell ( fp));	
		
}


bool filebufferQueue::
getFront (void *x)  {
	FILE	*fp;
	bufferObject *obj = (bufferObject *) x;
	unsigned long front_to_bottom_size;
	unsigned long size = obj->packet_size;

	if ( obj->packet == NULL ) {
		 if  ( quSpaceType == 1 ) {
			front_to_bottom_size = (arraySize-1) - front + 1;
			if ( size > front_to_bottom_size ) 
				quSpaceType = 2;
		}
		return true;			
	}
	
	fp = (FILE*) this->theArray;
	
	if ( quSpaceType == 2 ) {
		//memcpy (obj->packet, ((unsigned char*)theArray) + front, size );
		 fseek ( fp, front, SEEK_SET) ;
		if ( fread (obj->packet, sizeof(unsigned char), size, fp ) != size ) {
			if ( ferror(fp) )
				printf ("[filebufferQueue::getFront] fread fail\n");			
		}
	} else if  ( quSpaceType == 1 ) {
		front_to_bottom_size = (arraySize-1) - front + 1;
		if ( size > front_to_bottom_size ) {
			//memcpy (obj->packet, ((unsigned char*)theArray) + front, front_to_bottom_size );
			//memcpy ( obj->packet + front_to_bottom_size, (unsigned char*)theArray , size - front_to_bottom_size );

			 fseek ( fp, front, SEEK_SET) ;
			if ( fread (obj->packet, sizeof(unsigned char), front_to_bottom_size, fp ) != front_to_bottom_size ) {
				if ( ferror(fp) )
					printf ("[filebufferQueue::getFront]fread fail\n");			
			}

			size = size - front_to_bottom_size;
			 fseek ( fp, 0, SEEK_SET) ;
			if ( fread (obj->packet + front_to_bottom_size, sizeof(unsigned char), size, fp ) != size ) {
				if ( ferror(fp) )
					printf ("[filebufferQueue::getFront]fread fail\n");			
			}
		
			quSpaceType = 2;
		} else {
			//memcpy (obj->packet, ((unsigned char*)theArray) + front, size );
			 fseek ( fp, front, SEEK_SET) ;
			if ( fread (obj->packet, sizeof(unsigned char), size, fp ) != size ) {
				if ( ferror(fp) )
					printf ("[filebufferQueue::getFront]fread fail\n");			
			}
		}
	}
		
	 fseek ( fp, 0, SEEK_SET) ;	
	 
	return true;	
	
}


bool filebufferQueue::
allocBuffer () {
	FILE	*fp;
	
	m_DEBUG ("[filebufferQueue::allocBuffer]: start to allocBuffer\n");
	
	if ( (fp = fopen (buffer_filename, "w+b" )) == NULL ) {
		m_DEBUG ("[filebufferQueue::filebufferQueue]: malloc is null\n");
		return false;
	}
	fclose(fp);
	
	truncate(buffer_filename, arraySize);
	
	if ( (fp = fopen (buffer_filename, "r+b" )) == NULL ) {
		m_DEBUG ("[filebufferQueue::filebufferQueue]: malloc is null\n");
		return false;
	}
		
	this->theArray = (void *) fp;
	
	return true;
}

bool filebufferQueue::
releaseBuffer () {
	FILE 	*fp = (FILE*) (this->theArray);
	
	m_DEBUG ("[filebufferQueue::releaseBuffer]: start to releaseBuffer\n");

	m_DEBUG ("fp=%d\n", (int)fp);
	
	fclose( fp);

	this->theArray =0;
	return true;
}





