#include <string.h>

#include "bcommon.h"
#include "bufferQueue.h"

bufferQueue::
bufferQueue ( unsigned long size) :QueueAr (size){

	m_DEBUG ("bufferQueue constructor \n");
	
	this->arraySize = size;
	
	makeEmpty();
	allocBuffer();
	return;	
}

bufferQueue::
bufferQueue ( ) :QueueAr (0){
	m_DEBUG ("bufferQueue constructor do nothing \n");

	return;	
}

bufferQueue::
~bufferQueue ()  {
	if ( this->theArray != 0 )
		releaseBuffer ();
	m_DEBUG ("bufferQueue destructor \n");
}


bool bufferQueue::
isEmpty() {
	return ( currentSize == 0 );
}

bool bufferQueue::
isFull() {
		return true;
}

bool bufferQueue::
isFull (unsigned long size) {	
	if  ( (currentSize+size) >= arraySize) {
		m_DEBUG ("[bufferQueue::isFull] Queue is full\n");
		return true;
	}

	return false;
}


void bufferQueue::
makeEmpty() {	
	this->currentSize = 0;
	this->front = 1;
	this->end = 1;
	quSpaceType = 2;
	m_DEBUG("bufferQueue makeEmpty\n");
}

bool bufferQueue::
getFront (void *x, void *y)  {
	bufferObject *obj1 = (bufferObject *) x;
	bufferObject *obj2 = (bufferObject *) y;
	unsigned long front_to_bottom_size;
	
	unsigned long size = obj1->packet_size;
	
	if ( quSpaceType == 2 ) {
		obj1->packet = ((unsigned char*)theArray) + front;		
	} else if  ( quSpaceType == 1 ) {
		front_to_bottom_size = (arraySize-1) - front + 1;
		if ( size > front_to_bottom_size ) {
			obj1->packet = ((unsigned char*)theArray) + front;	
			obj1->packet_size = front_to_bottom_size;
			
			obj2->packet = (unsigned char*)theArray;	
			obj2->packet_size = size - front_to_bottom_size;
			quSpaceType = 2;
		} else
			obj1->packet = ((unsigned char*)theArray) + front;	
	}
			
	return true;	
	
}


bool bufferQueue::
getFront (void *x)  {
	bufferObject *obj = (bufferObject *) x;
	unsigned long front_to_bottom_size;
	unsigned long size = obj->packet_size;

	if ( obj->packet == NULL ) {
		 if  ( quSpaceType == 1 ) {
			front_to_bottom_size = (arraySize-1) - front + 1;
			if ( size > front_to_bottom_size ) 
				quSpaceType = 2;
		}
		return true;			
	}

	
	if ( quSpaceType == 2 ) {
		memcpy (obj->packet, ((unsigned char*)theArray) + front, size );
	} else if  ( quSpaceType == 1 ) {
		front_to_bottom_size = (arraySize-1) - front + 1;
		if ( size > front_to_bottom_size ) {
			memcpy (obj->packet, ((unsigned char*)theArray) + front, front_to_bottom_size );
			memcpy ( obj->packet + front_to_bottom_size, (unsigned char*)theArray , size - front_to_bottom_size );
			quSpaceType = 2;
		} else
			memcpy (obj->packet, ((unsigned char*)theArray) + front, size );
	}
		
	
	return true;	
}


bool bufferQueue::
dequeue ( void *x, void*y) {	

	bufferObject * obj = (bufferObject *) x;
	unsigned long size = obj->packet_size;

	if ( isEmpty( ) ) {
		m_DEBUG ("[bufferQueue::dequeue] Queue is isEmpty\n");
		return false;
	}
	
	if  (currentSize < size) {
		m_DEBUG ("[bufferQueue::dequeue] deQueue size is not enough\n");
		return false;
	}
	
	
	getFront (x, y );
		
	currentSize-= size;

	increment ( &front, size );


	return true;
		
}


bool bufferQueue::
dequeue ( void *x) {	
	bufferObject * obj = (bufferObject *) x;
	unsigned long size = obj->packet_size;
		
	if ( isEmpty( ) ) {
		m_DEBUG ("[bufferQueue::dequeue] Queue is isEmpty\n");
		return false;
	}
	if  (currentSize < size) {
		m_DEBUG ("[bufferQueue::dequeue] deQueue size is not enough\n");
		return false;
	}

#ifdef buffer_debug
	m_DEBUG ("[deque] front=%d, end=%d, currentSize=%ld, going to de_size=%ld\n", front ,end, currentSize, size);
#endif

	getFront (x );
		
	currentSize-= size;

	increment ( &front, size );


	return true;
}


void bufferQueue::
NormalDataAppend (void *d, unsigned long offset, unsigned char *src, unsigned long length) {
	unsigned char * dest = (unsigned char *) d;

#ifdef buffer_debug
	if ( (offset+length) > arraySize ) {
		printf ("bufferQueue: offset out of region\n");
		exit(0);
	}		
	m_DEBUG ("[bufferQueue::NormalDataAppend] 0x%lx (0x%x,0x%x), src=0x%x\n", 
		dest+offset, dest, dest+arraySize, src);
#endif

	memcpy ( dest+offset, src, length);
}

void bufferQueue::
MultiPartDataAppend (void *d, unsigned long offset, unsigned char *src, unsigned long length1, unsigned long length2) {
	unsigned char * dest = (unsigned char *) d;

	m_DEBUG ("[bufferQueue::MultiPartDataAppend] \n");
	memcpy ( dest+offset, src, length1);
	memcpy ( dest, src+length1, length2);
	
}


	
void bufferQueue::
copyPacket (unsigned char *packet, unsigned long packet_size ) {

	unsigned long 	remain_to_write;
	unsigned long 	next_free_space_block;


	if ( quSpaceType == 2 ) {
		next_free_space_block = arraySize - end ;
	} else {
		next_free_space_block = front - end ;
	}

	
	if ( packet_size > next_free_space_block ) {
		remain_to_write = packet_size - next_free_space_block;
		MultiPartDataAppend ( this->theArray, end, 
			packet, next_free_space_block, remain_to_write );
		quSpaceType = 1;
	} else {
		remain_to_write = 0;
		NormalDataAppend (  this->theArray, end, 
			packet, packet_size );
	}
	
}

bool bufferQueue::
enqueue(void *x) {
	
	bufferObject	*obj;	
	unsigned long 	packet_size;
	

	obj = (bufferObject*) x;
	packet_size = obj->packet_size;

	if ( this->theArray == NULL ){
		printf ("[bufferQueue::enqueue] theArray is NULL and exit.  Please call allocBuffer() first\n");
		exit(0);
	}
		
	if (  isFull (packet_size) ) {
		return false;
	}


	copyPacket(obj->packet, packet_size);
	
	increment ( &end, packet_size );
	
	currentSize += packet_size;


#ifdef buffer_debug
	m_DEBUG ("front=%d, end=%d, currentSize=%ld,\n", front ,end, currentSize);
#endif

	return true;
}


void bufferQueue::
increment(unsigned long *x) {

	*x = (*x + 1)  % arraySize;	
}


void bufferQueue::
increment (unsigned long *x, unsigned long size) {

	*x = (*x + size)  % arraySize;	
}

bool bufferQueue::
allocBuffer () {

	//this->theArray = (void *) calloc(1, arraySize * sizeof(unsigned char) );
	this->theArray = (void *) malloc(arraySize * sizeof(unsigned char) );

	m_DEBUG ("[bufferQueue::allocBuffer]: theArray=0x%x, size=%d\n", theArray, arraySize * sizeof(unsigned char));
	
	if ( this->theArray == NULL ){
		m_DEBUG ("[bufferQueue::bufferQueue]: malloc is null\n");
		return false;
	} 

	return false;
}


bool bufferQueue::
releaseBuffer () {
	
	m_DEBUG ("[bufferQueue::releaseBuffer]: free buffer\n");
	
	if (this->theArray == NULL)
		return false;
	
	free (this->theArray);
	this->theArray = 0;
	return true;
}

