#include "avStorage.h"
#include "bcommon.h"
#include <string.h>


// for MG3500
avStorage::
avStorage (int buffering_frames, int recording_frames, int storage_size, char *output_filename)
	: fstatus(BUFFERING), fBuffering_frames(buffering_frames), fRecording_frames(recording_frames)
{
	strncpy (foutput_filename, output_filename, sizeof(foutput_filename));
	favTmp1 = new  avBuffering (  buffering_frames + recording_frames ,  storage_size, OVERWRITE ) ;
}


avStorage::
avStorage (int buffering_frames, int recording_frames, int buffering_size,  int recording_size, char *output_filename)
{
	strncpy (foutput_filename, output_filename, sizeof(foutput_filename));
	fstatus = BUFFERING;

	if (buffering_frames > 0) 
	{
		favTmp1 = new  avBuffering (  buffering_frames,  buffering_size, OVERWRITE );
	} 
	else {
		favTmp1 = NULL;
		fstatus = RECORDING;
	}
					
	if (recording_frames > 0) 
	{
		favTmp2 = new  avBuffering (  recording_frames,   recording_size, NOT_OVERWRITE );

	} else
		favTmp2 = NULL;
}

avStorage::
avStorage (int buffering_frames, int recording_frames, int frame_size, char *output_filename)
{
	strncpy (foutput_filename, output_filename, sizeof(foutput_filename));
	fstatus = BUFFERING;

	if (buffering_frames > 0) 
	{
		favTmp1 = new  avBuffering (  buffering_frames,  frame_size*buffering_frames, OVERWRITE );
	} 
	else {
		favTmp1 = NULL;
		fstatus = RECORDING;
	}
					
	if (recording_frames > 0) 
	{
		favTmp2 = new  avBuffering (  recording_frames,   frame_size*recording_frames, NOT_OVERWRITE );

	} else
		favTmp2 = NULL;
}


avStorage::
avStorage (int buffering_time, int recording_time, int fps, int avg_bitrate, 
			int audio_bitrate, char *buffering_filename1, char *buffering_filename2,
			char *output_filename)
{
	strncpy (foutput_filename, output_filename, sizeof(foutput_filename));
	fstatus = BUFFERING;

	if (buffering_time > 0) {
		if ( buffering_filename1)
			favTmp1 = new avBuffering (buffering_time, fps, avg_bitrate+audio_bitrate,
							OVERWRITE, buffering_filename1);
		else	
			favTmp1 = new avBuffering (buffering_time, fps, avg_bitrate+audio_bitrate,
							OVERWRITE);
	} else {
		favTmp1 = NULL;
		fstatus = RECORDING;
	}
					
	if (recording_time > 0) {
		if ( buffering_filename2)
			favTmp2 = new avBuffering (recording_time, fps, avg_bitrate+audio_bitrate,
							NOT_OVERWRITE, buffering_filename2);
		else
			favTmp2 = new avBuffering (recording_time, fps, avg_bitrate+audio_bitrate,
							NOT_OVERWRITE);
	} else
		favTmp2 = NULL;

}

avStorage::
~avStorage () {
	if (favTmp1)
		delete (favTmp1);
	if (favTmp2)
		delete (favTmp2);
	m_DEBUG ("~avStorage destroied\n");
}

enStorageStatus avStorage::
getStatus () {
	return fstatus;
}

void avStorage::
setStatus (enStorageStatus st ) {
	fstatus = st;
}

void	avStorage::
stopBuffering () {
	fstatus = RECORDING;
}

bool avStorage::
isJobDone () {
	return (fstatus == JOBDONE ? true: false );
}

void	avStorage::
outputPackets (unsigned char* packet) {
	if (favTmp1)
		favTmp1->toFile (foutput_filename, FILE_TRUNCATE, packet);
	if (favTmp2)
		favTmp2->toFile (foutput_filename, FILE_APPEND, packet);
}

/// unsigned char* packet	destination for copy to
void	avStorage::
outputPacketsWithNALHeader (unsigned char* packet) {
	if (packet==NULL)
		return;
	
	if (favTmp1)
		favTmp1->toFileWithNALHeader (foutput_filename, FILE_TRUNCATE, packet);
}


bool	avStorage::
appendPreAlarmPacket (unsigned char* packet, unsigned long length) {
	if ( ! favTmp1->enqueueDataWithLimit ( packet,  length, VIDEO_PACKET_TYPE, fBuffering_frames) ) {	
		m_DEBUG("\nfavTmp1->enqueueData failed. \n" );
	}	
	return true;
}

bool	avStorage::
appendPostAlarmPacket (unsigned char* packet, unsigned long length) {
	if ( ! favTmp1->enqueueData ( packet,  length, VIDEO_PACKET_TYPE) ) {	
		m_DEBUG("\n AaappendPostAlarmPacket finished\n" );
		return false;
	}
	return true;
}


bool	avStorage::
appendPacket (unsigned char* packet, unsigned long length) {
	switch (fstatus) {
		case BUFFERING:
			if ( ! favTmp1 )
				fstatus = RECORDING;
			else {
				if ( ! favTmp1->enqueueData (packet, length) ) {	
					m_DEBUG("\nfavTmp1->enqueueData failed. \n" );
				}
			}
			break;
		case RECORDING:
			if ( ! favTmp2) {
				outputPackets (packet);
				fstatus = JOBDONE;
			} else {
				if ( ! favTmp2->enqueueData (packet, length) ) {
					outputPackets (packet);
					fstatus = JOBDONE;
					m_DEBUG("\nfavTmp2->enqueueData JOBDONE. \n" );
				}
			}
			break;
		case JOBDONE:
			return false;
	}

	return true;
}

bool	avStorage::
appendPacket2 (unsigned char* packet, unsigned long length) {
	
	switch (fstatus) {
		case BUFFERING:
			m_DEBUG("jimdebug: BUFFERING\n");
			if ( ! favTmp1 )
				fstatus = RECORDING;
			else {
				if ( ! favTmp1->enqueueData (packet, length) ) {	
					m_DEBUG("\nfavTmp1->enqueueData failed. \n" );
				}
			}
			break;
		case RECORDING:
			m_DEBUG("jimdebug: RECOR \n");			
			if ( ! favTmp2) {
				outputPacketsWithNALHeader (packet);
				fstatus = JOBDONE;
			} else {
				if ( ! favTmp2->enqueueData (packet, length) ) {	
					m_DEBUG("\nfavTmp2->enqueueData JOBDONE. \n" );
					outputPacketsWithNALHeader (packet);
					fstatus = JOBDONE;
				}
			}
			break;		
		case JOBDONE:
			return false;
	}

	return true;
}


void	avStorage::
setOutputFilename ( char *filename) {
	strncpy (foutput_filename, filename, sizeof(foutput_filename));
}


void	avStorage::
restart ( char *filename)
{
	strncpy (foutput_filename, filename, sizeof(foutput_filename));
	favTmp1->restart ();
	favTmp2->restart ();
	fstatus = BUFFERING;
}

