#include <unistd.h>
#include <stdio.h>
#include <string.h>

#include "avBuffering.h"
#include "bcommon.h"



avBuffering::
avBuffering ( int sec, int fps, int avg_bitrate, enBUFFERING_TYPE btype, char *buffer_filename )  {
	initBuffer	(  sec,  fps,  avg_bitrate,  btype, buffer_filename );
}

avBuffering::
avBuffering ( int sec, int fps, int avg_bitrate, enBUFFERING_TYPE btype )  {
	initBuffer	(  sec,  fps,  avg_bitrate,  btype, NULL );

}

/// for DM355 / MG3500 case
avBuffering::
avBuffering ( int frame_num, int storage_size, enBUFFERING_TYPE btype )  {
	initBuffer	(  frame_num,  storage_size,  btype, NULL );

}


void avBuffering::
initBuffer ( int num, int size, enBUFFERING_TYPE btype, char *buffer_filename )  {

	storage_size =  size;
	frame_num = num;

	if ( storage_size <= 0 || frame_num <= 0 ) {
		printf ("[avBuffering::] initBuffer fail. storage size=%ld, frame numbers=%ld\n", storage_size, frame_num);
		exit(0);
	}
	
	buffering_type = btype;


	memset ( &frame_Obj, 0, sizeof(frameObject) );
	memset ( &buffer_Obj, 0, sizeof(bufferObject) );

	if (buffer_filename != NULL) {
		data_queue = new filebufferQueue (storage_size, buffer_filename);
	} else {
		data_queue = new bufferQueue (storage_size);
	}
	
	frame_queue = new frameQueue	(frame_num);

	m_DEBUG ("[avBuffering:avBuffering]  memory=%d , frames = %d\n", storage_size, frame_num);

}


void avBuffering::
initBuffer ( int sec, int fps, int avg_bitrate, enBUFFERING_TYPE btype, char *buffer_filename )  {

	float		tolerance_rate = 4;
	
	//storage_size =  (unsigned long) (sec * 60  * ((avg_bitrate * 1000) /8) * tolerance_rate);
	storage_size =  (unsigned long) (sec *   (avg_bitrate * 1000 + 96000) / 8 );

	
	frame_num = (unsigned long)  (sec * fps *2 * tolerance_rate + 1);

	if ( storage_size <= 0 || frame_num <= 0 ) {
		printf ("[avBuffering::] initBuffer fail. storage size=%ld, frame numbers=%ld\n", storage_size, frame_num);
		exit(0);
	}
	
	buffering_type = btype;


	memset ( &frame_Obj, 0, sizeof(frameObject) );
	memset ( &buffer_Obj, 0, sizeof(bufferObject) );

	if (buffer_filename != NULL) {
		data_queue = new filebufferQueue (storage_size, buffer_filename);
	} else {
		data_queue = new bufferQueue (storage_size);
	}
	
	frame_queue = new frameQueue	(frame_num);

	m_DEBUG ("[avBuffering:avBuffering]  memory=%d , frames = %d\n", storage_size, frame_num);

}


avBuffering::
~avBuffering () {
	if ( data_queue )
		delete (data_queue);

	if ( frame_queue )
		delete (frame_queue);
}


bool avBuffering::
toFile (char *filename, enFILE_OPEN_TYPE file_out_type, unsigned char *packet_buffer) {
	FILE 	*fp;

	buffer_Obj.packet = packet_buffer; //bbb;	

	if ( file_out_type == FILE_TRUNCATE ) 
		fp = fopen (filename, "wb");
	else
		fp = fopen (filename, "ab+");

	if ( fp == NULL)
		return false;

	while ( !frame_queue->isEmpty() ) {
		if ( dequeueData ( &frame_Obj, &buffer_Obj ) ) {
			//usleep(10);
			fwrite (buffer_Obj.packet, sizeof(unsigned char), buffer_Obj.packet_size, fp );		
		}
	}
	fclose(fp);
	
	m_DEBUG ( "close file=%s\n", filename);
	
	return true;
}

bool avBuffering::
toFileWithNALHeader (char *filename, enFILE_OPEN_TYPE file_out_type, unsigned char *packet_buffer, int needIstart) {
	FILE 	*fp;
	int foundSPS;
	char nalhdr[4] = {0x00, 0x00, 0x00, 0x01};
	buffer_Obj.packet = packet_buffer; //bbb;	


	if ( file_out_type == FILE_TRUNCATE ) 
		fp = fopen (filename, "wb");
	else
		fp = fopen (filename, "ab+");

	if ( fp == NULL)
		return false;

	if ( needIstart )
		foundSPS = 0;
	else
		foundSPS = 1;
	
	while ( !frame_queue->isEmpty() ) {
		if ( dequeueData ( &frame_Obj, &buffer_Obj ) ) {
			m_DEBUG ("jimdebug: dequeue size(NAL) = %d, type=%d\n", buffer_Obj.packet_size, *(buffer_Obj.packet) & 0x1f);
			//usleep(10);
			if ( (*(buffer_Obj.packet) & 0x1f) == 7) {
				m_DEBUG ("\njimdebug: found SPS\n");
				foundSPS = 1;
			}
			if (foundSPS) {
				fwrite( nalhdr, sizeof(unsigned char), 4, fp);
				fwrite (buffer_Obj.packet, sizeof(unsigned char), buffer_Obj.packet_size, fp );
				fflush (fp);
			}
		}
	}
	fclose(fp);
	
	m_DEBUG ( "\nclose file=%s\n", filename);
	
	return true;
}


bool avBuffering::
dequeueData ( frameObject *frame_Obj, bufferObject *buffer_Obj ) {

	if ( frame_queue->isEmpty () || data_queue->isEmpty () ) {		
		m_DEBUG ("It is empty\n"); 
		return false;
	}
	
	frame_queue->dequeue ( (void*) frame_Obj);
	m_DEBUG ( "size=%d type=%d\n", frame_Obj->frame_size, frame_Obj->frame_type);
		
	if ( frame_Obj != false ) {	
		
		buffer_Obj->packet_size = frame_Obj->frame_size;	
		
		if ( ! data_queue->dequeue ((void*) buffer_Obj) ) {
			m_DEBUG ("[avBuffering::inputData] queue->dequeue faile\n");
			return false;
		}
		else	 {
			m_DEBUG ("buffer_Obj->packet_size=%d\n", buffer_Obj->packet_size);
		}
	}

	return true;
	
}


bool avBuffering::
dequeueDataPtr ( frameObject *frame_Obj, bufferObject *buffer_Obj1, bufferObject *buffer_Obj2 ) {

	if ( frame_queue->isEmpty () || data_queue->isEmpty () ) {		
		m_DEBUG ("It is empty\n"); 
		return false;
	}
	
	frame_queue->dequeue ( (void*) frame_Obj);
	m_DEBUG ( "size=%d type=%d\n", frame_Obj->frame_size, frame_Obj->frame_type);
		
	if ( frame_Obj != false ) {	
		
		buffer_Obj1->packet_size = frame_Obj->frame_size;	/// Jim: set size that we are going to get, according to the frame_obj
		buffer_Obj2->packet_size = 0;
		
		if ( ! data_queue->dequeue ( (void*) buffer_Obj1, (void*) buffer_Obj2) ) {
			m_DEBUG ("[avBuffering::inputData] queue->dequeue faile\n");
			return false;
		}
		else	 {
			m_DEBUG ("frameSize=%d, buffer packet_size=%d+%d=%d\n", frame_Obj->frame_size, buffer_Obj1->packet_size, buffer_Obj2->packet_size, buffer_Obj1->packet_size+ buffer_Obj2->packet_size);
		}
	}

	return true;
	
}


bool avBuffering::
enqueueData ( unsigned char* packet, unsigned long length, enPACKET_TYPE packet_type) {

	
	frame_Obj.frame_type = packet_type;
	frame_Obj.frame_size = length;

	buffer_Obj.packet = packet;
	buffer_Obj.packet_size = length;

	while (  data_queue->isFull (length) || frame_queue->isFull() ) {
		m_DEBUG("[avBuffering::enqueueData] it is Full\n");
		if (this->buffering_type == OVERWRITE ) {
			buffer_Obj.packet = NULL;
			dequeueData ( &frame_Obj, &buffer_Obj );
		} else
			return false;
		
	}
	
	frame_Obj.frame_type = packet_type;
	frame_Obj.frame_size = length;

	buffer_Obj.packet = packet;
	buffer_Obj.packet_size = length;

//m_DEBUG("frame_type=%d frame_size=%d \n",frame_Obj.frame_type, frame_Obj.frame_size );
	frame_queue->enqueue ( (void *) &frame_Obj);
	
//m_DEBUG("frame_queue complete\n");
	data_queue->enqueue ( (void *) &buffer_Obj);	
	
	return true;
}





bool avBuffering::
enqueueData ( unsigned char* packet, unsigned long length) {
	return enqueueData ( packet, length, UN_KNOWN_PACKET_TYPE);	
}


void avBuffering::
restart (void) 
{
	
	m_DEBUG("Let's  restart\n");
	
	data_queue->makeEmpty();

	//Jim@2009_0311:
	frame_queue->makeEmpty();
}
