/*  nonroot.h: Header file for nonroot.c
    Copyright (C) 1999-2000 Steinar H. Gunderson

    This program is is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2 if the
    License as published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _NONROOT_H
#define _NONROOT_H 1

int nr_userinfo(const char * const username, int * const uid,
                char * const homedir, char * const rootdir,
                const char * const password);
int nr_check_permission(const uid_t uid, const char * const object,
	                const int perm, const int is_dir,
	                char * const ret_rights);
int nr_intperm(const uid_t uid, const char * const rightfile,
	       const char * const entry, const int perm,
	       char * const ret_rights);
int member_of_group(const uid_t uid, const gid_t gid);
char *nr_get_uname(const uid_t uid);
char *nr_get_gname(const gid_t gid);

#endif
