/*  dcache.h: BetaFTPD directory cache prototypes
    Copyright (C) 2000 Steinar H. Gunderson

    This program is is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2 if the
    License as published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _DCACHE_H
#define _DCACHE_H 1

#if HAVE_TIME_H
#include <time.h>
#endif

#if HAVE_SYS_TIME_H
#include <sys/time.h>
#endif

#include <ftpd.h>

/* doubly linked list of cached directory listings */
struct dcache {
        struct dcache *prev_dcache;
        struct dcache *next_dcache;

        int use_count;
        time_t last_used;
        time_t generated;

        char dir_name[256];
        char pattern[256];
        struct list_options lo;

        char *dir_data;
        int dir_size;
};

struct dcache *alloc_new_dcache();
void destroy_dcache(struct dcache * const d);

void time_out_dcache();
void populate_dcache(struct ftran * const f, const char * const cwd,
 		     const char * const pattern, const struct list_options * const lo);
struct dcache *find_dcache(const char * const cwd, const char * const pattern, 
	 	           const struct list_options * const lo);

#endif
