/*  cmds.c: BetaFTPD command handler prototypes
    Copyright (C) 1999-2000 Steinar H. Gunderson

    This program is is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2 if the
    License as published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _CMDS_H
#define _CMDS_H 1

#include <ftpd.h>

/*
 * TRAP_ERROR:	This is a quick way of doing a test for an error condition.
 *		if an error occurs (or more precisely, if the value supplied is
 *		true), an error message is sent back to the client. This is _not_
 *		a debugging macro. The condition is allowed to have side effects,
 *		and is only evaluated once.
 *
 *		The second argument is the FTP error code to send back, in case
 *		of an error (the error message itself will be supplied by the
 *		system). The third argument is code to execute after the FTP error
 *		has been sent (typically `return' or `return -1').
 *
 *		If TRAP_ERROR_DEBUG is defined, some extra debugging info is
 *		sent. Don't enable this for a normal server, it could be a
 *		security risk.
 */
#undef TRAP_ERROR_DEBUG
/* #define TRAP_ERROR_DEBUG 1 */

#ifdef TRAP_ERROR_DEBUG
#define TRAP_ERROR(x, num, y) TRAP_ERROR_INTERNAL(x, num, y, __FILE__, __LINE__)
#define TRAP_ERROR_INTERNAL(x, num, y, fl, ln) \
	if (x) { \
		numeric(c, num, "%s (%s:%d)", strerror(errno), fl, ln); \
		y; \
	}
#else
#define TRAP_ERROR(x, num, y) \
	if (x) { \
		numeric(c, num, strerror(errno)); \
		y; \
	}
#endif

#define CMD_PROTO(cmd) int cmd_##cmd (struct conn * const c)

int do_chdir(struct conn * const c, const char * const newd);
CMD_PROTO(user);
CMD_PROTO(pass);
CMD_PROTO(acct);
CMD_PROTO(port);
CMD_PROTO(pasv);
CMD_PROTO(pwd);
CMD_PROTO(cwd);
CMD_PROTO(cdup);
CMD_PROTO(rest);
CMD_PROTO(retr);
CMD_PROTO(size);
CMD_PROTO(mdtm);
CMD_PROTO(abor);
CMD_PROTO(dele);
CMD_PROTO(rnfr);
CMD_PROTO(rnto);
CMD_PROTO(mkd);
CMD_PROTO(rmd);
CMD_PROTO(allo);
CMD_PROTO(stat);
CMD_PROTO(list);
CMD_PROTO(nlst);
CMD_PROTO(syst);
CMD_PROTO(noop);
CMD_PROTO(type);
CMD_PROTO(mode);
CMD_PROTO(stru);
CMD_PROTO(help);
CMD_PROTO(quit);
CMD_PROTO(rein);

#if WANT_UPLOAD
CMD_PROTO(stor);
CMD_PROTO(appe);
#endif

#if DOING_PROFILING
CMD_PROTO(exit);	
#endif

void cmd_cwd_internal(struct conn * const c, const char * const newd);
void parse_command(struct conn *c);
void prepare_for_transfer(struct ftran *f);
char decode_mode(mode_t mode);
char *translate_path(struct conn * const c, char * const path);
int do_openfile(struct conn * const c, char * const path,
		char * const filename, const int flags
#if WANT_NONROOT
	        , const int check_permission
#endif
);
int prepare_for_listing(struct conn * const c, char ** const ptr,
			struct list_options * const lo);
void do_listing(struct conn * const c, struct list_options * const lo);
int get_num_files(struct conn * const c, const char * const pathname,
                   struct list_options * const lo);
int list_core(struct conn * const c, const char * const pathname,
   		   char * const disp_pathname, struct list_options * const lo
#if HAVE_MMAP
		, const int size, int pos
#endif
);
char classify(const mode_t mode);
void do_store(struct conn * const c, int append);
char *do_pwd(struct conn * const c, char * const retbuf, const char * const dir);

#ifndef HAVE_POLL
/*
 * Even on select()-only systems, we use some poll() constants, so
 * we'll have to make them up if we don't already have them. These
 * are taken from my glibc 2.1 system.
 */
#define POLLIN		0x001
#define POLLOUT		0x004
#endif

#endif
