#ifndef __I2C_TOOL_H__
#define __I2C_TOOL_H__

#define m_DEBUG(format, args...)  printf(format, ## args) 
#define m_ERROR(format, args...)  printf(format, ## args)

#define I2C_SLAVE_FORCE	0x0706

struct i2c_device_addr {
	int		fd;
	unsigned char 	slaveAddr;
};
int i2c_open( struct i2c_device_addr *i2c_dev, char *dev, unsigned char slaveAddr);
void i2c_close( struct i2c_device_addr *i2c_dev);
int i2c_read_data( struct i2c_device_addr *i2c_dev, unsigned char sub_adr,unsigned char *data, int length);
int i2c_write_data( struct i2c_device_addr *i2c_dev, unsigned char sub_adr,unsigned char *data, int length);


#endif
