#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include "i2c_tool.h"

int i2c_open( struct i2c_device_addr *i2c_dev, char *dev, unsigned char slaveAddr){
	if ( ( i2c_dev->fd = open( dev, O_RDWR)) < 0 ) {
		m_DEBUG("%s: %s driver open failed\n", __FUNCTION__, dev);
		return EXIT_FAILURE;
	}
	i2c_dev->slaveAddr = slaveAddr;
	return EXIT_SUCCESS;
}

void i2c_close( struct i2c_device_addr *i2c_dev){
	close( i2c_dev->fd );
}

int i2c_read_data( struct i2c_device_addr *i2c_dev, unsigned char sub_adr,unsigned char *data, int length){
	int ret;
	if ( i2c_dev->fd < 2) {
		m_ERROR("%s: FD[%d] error\n", __FUNCTION__, i2c_dev->fd);
		return EXIT_FAILURE;
	}

	if( (ret=ioctl( i2c_dev->fd, I2C_SLAVE_FORCE, i2c_dev->slaveAddr)) < 0){
		m_ERROR("%s: set slave addr(%x) error ret=%d\n", __FUNCTION__, i2c_dev->slaveAddr, ret);
		return EXIT_FAILURE;
	}
	if((ret=write( i2c_dev->fd, &sub_adr, 1)) != 1){
		m_ERROR("%s: write subaddr(%x) error:%x\n", __FUNCTION__, sub_adr, ret);
		return EXIT_FAILURE;
	}
	if ((ret=read( i2c_dev->fd, data, length)) != length) {
		m_ERROR("%s: read data from subaddr(%x) error\n", __FUNCTION__, sub_adr);
		return EXIT_FAILURE;
	}
	usleep(0);
//	printf("read slaveaddr=%x addr%x=%x\n",slave_adr, sub_adr,*data);
	return EXIT_SUCCESS;
}
int i2c_write_data( struct i2c_device_addr *i2c_dev, unsigned char sub_adr,unsigned char *data, int length){
	unsigned char	buf[ length+1 ], *p;
	int		ret;

	buf[0] = sub_adr;

	if ( i2c_dev->fd < 2) {
		m_ERROR("%s: FD[%d] error\n", __FUNCTION__, i2c_dev->fd);
		return EXIT_FAILURE;
	}
	if( ( ret = ioctl( i2c_dev->fd, I2C_SLAVE_FORCE, i2c_dev->slaveAddr)) < 0){
		m_ERROR("I2CRead: set slave addr(%x) error ret=%d\n", i2c_dev->slaveAddr, ret);
		return EXIT_FAILURE;
	}
	p = &buf[1];
	memcpy( p, data, length );

	if(( ret = write( i2c_dev->fd, buf, length+1)) != length+1){
		m_ERROR("%s: write subaddr(%x) error:%x\n", __FUNCTION__, sub_adr, ret);
		return EXIT_FAILURE;
	}
	usleep(0);
	return EXIT_SUCCESS;
}
