/*
 * Watchdog Driver Test Program
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/types.h>
#include <linux/watchdog.h>

int fd;

/*
 * This function simply sends an IOCTL to the driver, which in turn ticks
 * the PC Watchdog card to reset its internal timer so it doesn't trigger
 * a computer reset.
 */
void keep_alive(void)
{
    int dummy;

    ioctl(fd, WDIOC_KEEPALIVE, &dummy);
}

/*
 * The main program.  Run the program with "-d" to disable the card,
 * or "-e" to enable the card.
 */
int main(int argc, char *argv[])
{
	int ii = 1;
	int stime;

    fd = open("/dev/watchdog", O_WRONLY);

    if (fd == -1) {
		fprintf(stderr, "Watchdog device not enabled.\n");
		fflush(stderr);
		exit(-1);
    }

	ioctl(fd, WDIOC_GETTIMEOUT, &ii);
	printf ("Current WDT timeout is %d second\n", ii);

    if (argc > 1) {
		if (argv[1][0] < '0' || argv[1][0] > '9') {
			if (!strncasecmp(argv[1], "-d", 2)) {
			    ioctl(fd, WDIOC_SETOPTIONS, WDIOS_DISABLECARD);
			    fprintf(stderr, "Watchdog card disabled.\n");
			    fflush(stderr);
			    exit(0);
			} else if (!strncasecmp(argv[1], "-e", 2)) {
			    ioctl(fd, WDIOC_SETOPTIONS, WDIOS_ENABLECARD);
			    fprintf(stderr, "Watchdog card enabled.\n");
			    fflush(stderr);
			    exit(0);
			} else {
			    fprintf(stderr, "-d to disable, -e to enable.\n");
			    fprintf(stderr, "run by itself to tick the card.\n");
			    fflush(stderr);
			    exit(0);
			}
		}
		else {
			ii = strtol (argv[1], NULL, 10);
			printf ("Set WDT timeout to %d second\n", ii);
			ioctl (fd, WDIOC_SETTIMEOUT, &ii);
		}
    } else {
		fprintf(stderr, "Watchdog Ticking Away!\n");
		fflush(stderr);
    }

	if (ii <= 1)
		ii = 2;
	stime = ii / 3;
	if (stime == 0)
		stime = 1;
    while(1) {
		keep_alive();
		//printf ("sleep %d second\n", ii);
		sleep (stime);
    }
}
