#include <linux/errno.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/platform_device.h>
#include <linux/types.h>
#include <linux/version.h>
#include <linux/proc_fs.h>
//#include <asm/arch/platform.h>
#include <asm/uaccess.h>
#include <linux/kthread.h>
#include <linux/wait.h>
#include <linux/sched.h>
#include <linux/net.h>
#include <linux/socket.h>
#include <linux/in.h>
#include <linux/fs.h>
#include <linux/file.h>
#include <linux/mm.h>
#include <asm/fcntl.h>
#include <linux/delay.h>
#include <linux/jiffies.h>
#include "kluanet.h"
/*=======================================================================================================*/
static struct platform_device kluanet_thread_device = {
        .name   = KLUANET_NAME,
        .id     = 11,
        .dev    = {
                .platform_data  = NULL,
                .release = NULL,
        },
        .num_resources = 0,
};
/*-------------------------------------------------------------------------------------------------------*/
lua_action_t	luafunc;
/*=======================================================================================================*/
void lua_client_release(void)
{	
	if(luafunc.sock != NULL)
	{
		sock_release(luafunc.sock);
		luafunc.sock = NULL;
	}

	luafunc.connected = 0;
}

int lua_client_connection(void)
{
	struct  sockaddr_in sin;
	int	error;

	lua_client_release();

	error = sock_create(PF_INET, SOCK_STREAM,IPPROTO_TCP, &(luafunc.sock));
	if (error < 0)
	{
		DBG(LUATHREAD, "Error during creation of the other socket; terminating\n");
		return error;
	}

	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = htonl(0x7f000001);
	sin.sin_port = htons(9600);

	error = luafunc.sock->ops->connect(luafunc.sock, (struct sockaddr*)&sin, sizeof(sin), 0);
	if (error < 0)
	{
		/* must add release the socket code here */
		lua_client_release();
		DBG(LUATHREAD, "Error connecting socket\n");
		return error;
	}

	//luafunc.fd = sock_map_fd(luafunc.sock, (O_CLOEXEC | O_NONBLOCK));
	luafunc.connected = 1;

	return 0;
}

void do_lua_action(char *luastr)
{
	struct msghdr  msg;
	struct iovec  iov;
	int    ret = -1;

	luafunc.runflag = 1;

	if(luafunc.connected == 1)
	{
#ifdef CHK_MGAPP
		if(luafunc.mgapp == 0) 
		{  
			DBG(LUATHREAD, "===mgapp is not ok.\n");
			return; 
		}
#endif
		msg.msg_name = 0;
		msg.msg_namelen = 0;
		msg.msg_iov = &iov;
		msg.msg_iovlen = 1;
		msg.msg_control = NULL;
		msg.msg_controllen = 0;
		msg.msg_flags = MSG_NOSIGNAL;
		iov.iov_base = luastr;
		iov.iov_len = (__kernel_size_t)strlen(luastr);   
		ret = sock_sendmsg(luafunc.sock, &msg, strlen(luastr));
	}

	if(ret < 0)
		kill_pid(task_pid(luafunc.thread), SIGPIPE, 1);
	
	luafunc.runflag = 0;
}
/*-------------------------------------------------------------------------------------------------------*/
static int LUA_kthd_func(void *param)
{
	unsigned long	sig;
	siginfo_t	info;

	lua_client_connection();

	DBG(LUATHREAD, "LUA kthread enter\n");

	//siginitsetinv(&current->blocked, sigmask(SIGKILL)|sigmask(SIGINT)|sigmask(SIGTERM));
	allow_signal(SIGPIPE);
	
	while(1)
	{
		if(signal_pending(current))
		{
			sig = dequeue_signal(current, &current->blocked, &info);
			if(sig == SIGPIPE)
			{
				DBG(LUATHREAD, "sigpipe happen, try to reconnect: ");
				if(lua_client_connection() >= 0)
				{
					DBG(LUATHREAD, "success\n");
					//down_interruptible(&(luafunc._semMutex));
					do_lua_action(luafunc.action);
					//up(&(luafunc._semMutex));
				}
				else
					DBG(LUATHREAD, "fail\n");
			}
		}

		interruptible_sleep_on(&(luafunc.queue));

		if(kthread_should_stop())
		{
			lua_client_release();
			break;
		}

		//down_interruptible(&(luafunc._semMutex)); 
		do_lua_action(luafunc.action); 
		//up(&(luafunc._semMutex)); 
	}
	
	DBG(LUATHREAD, "LUA kthread exit\n");

	return 0;
}

static int proc_read(char *page, char **start, off_t off, int count, int *eof, void *data)
{
	int	len = 0;

	len = sprintf(page, "127.0.0.1/9600 connect: %d mgapp: %d mounting: %d\n", luafunc.connected, luafunc.mgapp, luafunc.fed.mount_view_switch);

	return len;
}
/*-------------------------------------------------------------------------------------------------------*/
static void proc_alloc(void)
{
	create_proc_read_entry(CFG_PROC_LUAFD, 0, 0, proc_read, NULL);
}

static void proc_free(void)
{
	remove_proc_entry(CFG_PROC_LUAFD, NULL);
}

static void setup_kthd_area(void)
{
	luafunc.sock = NULL;
	memset(luafunc.action, 0, sizeof(luafunc.action));
	luafunc.fd = 0;
	luafunc.connected = 0;
	luafunc.mgapp = 0;
	luafunc.runflag = 0;
	luafunc.fed.mount_view_switch = 0;
	init_waitqueue_head(&(luafunc.queue));
	init_MUTEX(&(luafunc._semMutex));

	luafunc.thread = kthread_create(LUA_kthd_func, (void *)NULL, "LUA_kthread");

	wake_up_process(luafunc.thread);
}

static void release_kthd_area(void)
{
	if(luafunc.thread != NULL)
	{
		wake_up_process(luafunc.thread);
		kthread_stop(luafunc.thread);
	}
}
/*-------------------------------------------------------------------------------------------------------*/
static int kluanet_ioctl(struct inode *inode, struct file *filp, unsigned int cmd, unsigned long arg)
{ 
	int rc = 0;

	if (_IOC_TYPE(cmd) != KLUANET_LUA_IOCTL_MAGIC) 
		return (-ENOTTY);
	
	switch (cmd) {
		case KLUANET_IOCTL_LUA_CMD : {
   		      if (copy_from_user(luafunc.action, (char *)arg,  sizeof(luafunc.action)))
				return (-EINVAL);
		      wake_up_interruptible(&(luafunc.queue));
   		      break;
     		}
		case KLUANET_IOCTL_LUA_Y : {
		      sprintf(luafunc.action, "%s",  "LUA_JPEG_SNAPSHOT( '/tmp/initsnap' )##");
		      luafunc.mgapp = 1; 
		      wake_up_interruptible(&(luafunc.queue));
		      break;
		}
		case KLUANET_IOCTL_LUA_N : {  
		      luafunc.mgapp = 0;  
		      break;
		}
		case KLUANET_IOCTL_LUA_V : { 
		      if (copy_to_user((int *)arg, &(luafunc.mgapp), sizeof(int)))	    	
		      		return (-EINVAL); 
		      break;
		}
		case KLUANET_IOCTL_LUA_JIFFIES : { 
                      if (copy_to_user((unsigned long *)arg, &jiffies, sizeof(unsigned long)))          
                                return (-EINVAL); 
                      break;
                }
		case KLUANET_IOCTL_FE_OFF : { 
		      luafunc.fed.mount_view_switch = 0;    
		      break;
		}
		case KLUANET_IOCTL_FE_ON : { 
		      luafunc.fed.mount_view_switch = 1;   
		      break;
		}
		case KLUANET_IOCTL_FE_V : { 
		      if (copy_to_user((int *)arg, &(luafunc.fed.mount_view_switch), sizeof(int)))	    	
		      		return (-EINVAL); 
		      break;
		}
		default:
   	              rc = -ENOTTY;
      	              break;
	}

	return rc;
}

static int kluanet_open(struct inode * inode, struct file * filp)
{
	return 0;
}

static int kluanet_release(struct inode *inode, struct file *filp)
{
	return 0;
}

static ssize_t kluanet_write(struct file *filp, const char *buf, size_t count, loff_t *ppos)
{
#ifdef CHK_MGAPP
	if(luafunc.mgapp == 0) 
	{  
		DBG(LUATHREAD, "===mgapp is not ok.\n");
		return	0; 
	}
#endif
	memset(luafunc.action, 0, sizeof(luafunc.action));
	memcpy(luafunc.action, buf, count);
	wake_up_interruptible(&(luafunc.queue));

	return	count;
}
/*=======================================================================================================*/
static struct file_operations kluanet_fops = 
{
	open:           kluanet_open,
	release:        kluanet_release,
	ioctl:          kluanet_ioctl,
	write:          kluanet_write,
};

static int __init kluanet_init(void)
{
	int rc;

	rc = register_chrdev(KLUANET_NUM, KLUANET_NAME, &kluanet_fops);
	if (rc < 0) {
		DBG(INIT, "%s can't get major %d\n", KLUANET_NAME, KLUANET_NUM);
		return rc;
	}

	setup_kthd_area();
	proc_alloc();

	DBG(INIT, "kernel lua connect init\n");

	return 0;
}

static void __exit kluanet_exit(void) 
{
	unregister_chrdev(KLUANET_NUM, KLUANET_NAME);

	release_kthd_area();
	proc_free();

	DBG(INIT, "kernel lua connect exit\n");
}

module_init(kluanet_init);
module_exit(kluanet_exit);

MODULE_AUTHOR("C.Y.Chen");
MODULE_DESCRIPTION("Driver for Pixord lua connect");
MODULE_LICENSE("GPL");
