#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>


/// Jim@200_1005: Move defines to the below header file
#include <eeprom_api.h>




void help(){
		printf("usage:\n\t./eeprom write addr str  ( str < %d bytes )\n", MAXBYTE);
		printf("\t./eeprom read  addr size ( size < %d bytes )\n", MAXBYTE);
		printf("\t./eeprom test be care will clean out all data!! \n");
		printf("\t./eeprom macw 00 40 10 20 30 40\n");
		printf("\t./eeprom modelw P1600\n");
		printf("\t./eeprom versionw 1.1.0.18\n");
		printf("\t./eeprom ipw 192.168.1.1\n");
		printf("\t./eeprom httpportw 80\n");
		printf("\t./eeprom rtspportw 554\n");
		printf("\t./eeprom modelnamew P600_IPCam\n");
		printf("\t./eeprom yoicsdisplayw yes/no\n");
		printf("\t./eeprom notew It_is_IP-cam (no space)\n");
		printf("\t./eeprom noteclear (will clean note)\n");
		printf("\t./eeprom [brandr, modelnamer, modelr, macr, ipr, maskr, gater, dns1r, dns2r, httpportr, rtspportr, yoicsdisplayr, noter, list]\n");

}
int main(int argc, char **argv){
	struct i2c_device_addr	eeprom;
	unsigned char		str[256], mac[10];
	int			ret = 0;
	char count;

	memset( str, 0, 256 );

	i2c_open( &eeprom, I2C_DEV_DEVICE, 0xa0>>1 );  //16kbit
	//i2c_open( &eeprom, I2C_DEV_DEVICE, 0xa8>>1 );    //8kbit

	if( argc < 2 ) help();

	else if( !strcmp( argv[1], "write" )){
		printf("write %s len=%d\n", argv[3], strlen( argv[3] ) );
		ret = eeprom_write( &eeprom, atoi(argv[2]), (unsigned char*) argv[3], strlen( argv[3] ) );
	}
	else if( !strcmp( argv[1], "read" )){
		if( eeprom_read( &eeprom, atoi( argv[2]), str, atoi( argv[3] ) ) == EXIT_SUCCESS ){
			str[ atoi( argv[3] ) ] = '\0';
			printf("Read: Str=%s Len=%d\n", str, strlen( (char*)str) );
			ret = 0;
		}
		else ret = 1;
	}
	else if( !strcmp( argv[1], "macw" )){
		mac[0] = strtol( argv[2], NULL, 16 );
		mac[1] = strtol( argv[3], NULL, 16 );
		mac[2] = strtol( argv[4], NULL, 16 );
		mac[3] = strtol( argv[5], NULL, 16 );
		mac[4] = strtol( argv[6], NULL, 16 );
		mac[5] = strtol( argv[7], NULL, 16 );
		printf("Write MAC: %.2x:%.2x:%.2x:%.2x:%.2x:%.2x\n", mac[0], mac[1],mac[2],mac[3],mac[4],mac[5]);
		ret = eeprom_write( &eeprom, POS_MAC, mac, 6 );
	}
	else if( !strcmp( argv[1], "test" )){
		ret = EEPROM_Test( &eeprom );
	}
	else if( !strcmp( argv[1], "macr" )){
		ret = eeprom_read( &eeprom, POS_MAC, mac, 6 );
		if( ret == EXIT_SUCCESS )
			printf("%.2x:%.2x:%.2x:%.2x:%.2x:%.2x\n", mac[0], mac[1],mac[2],mac[3],mac[4],mac[5]);
	}
	else if( !strcmp( argv[1], "modelw" )){
		if( strlen( argv[2] ) > MAXBYTE ){
			printf("%s:%s)Write fail Input length > %d!!\n", __FILE__,  __FUNCTION__, MAXBYTE);
			return -1;
		}
		sprintf( (char*) str, "%s", argv[2] );
		ret = eeprom_write( &eeprom, POS_MODEL, str, MAXBYTE);
	}
	else if( !strcmp( argv[1], "modelr" )){
		ret = eeprom_read( &eeprom, POS_MODEL, str, MAXBYTE);
		if( ret == EXIT_SUCCESS )	printf("%s\n", str);
	}
	else if( !strcmp( argv[1], "versionw" )){
		if( strlen( argv[2] ) > MAXBYTE){
			printf("%s:%s)Write fail Input length > %d!!\n", __FILE__,  __FUNCTION__, MAXBYTE);
			return -1;
		}
		sprintf( (char*) str, "%s", argv[2] );
		ret = eeprom_write( &eeprom, POS_VERSION, str, MAXBYTE);
	}
	else if( !strcmp( argv[1], "versionr" )){
		ret = eeprom_read( &eeprom, POS_VERSION, str, MAXBYTE);
		if( ret == EXIT_SUCCESS ) printf("%s\n", str);
	}
	else if( !strcmp( argv[1], "ipw" )){
		if( strlen( argv[2] ) > MAXBYTE){
			printf("%s:%s)Write fail Input length > %d!!\n", __FILE__,  __FUNCTION__, MAXBYTE);
			return -1;
		}
		sprintf( (char*) str, "%s", argv[2] );
		ret = eeprom_write( &eeprom, POS_IP, str, MAXBYTE);
	}
	else if( !strcmp( argv[1], "ipr" )){
		ret = eeprom_read( &eeprom, POS_IP, str, MAXBYTE);
		str[ MAXBYTE ] = 0;
		if( ret == EXIT_SUCCESS ) printf("%s\n", str);
	}
	else if( !strcmp( argv[1], "maskw" )){
		if( strlen( argv[2] ) > MAXBYTE){
			printf("%s:%s)Write fail Input length > %d!!\n", __FILE__,  __FUNCTION__, MAXBYTE);
			return -1;
		}
		sprintf( (char*) str, "%s", argv[2] );
		ret = eeprom_write( &eeprom, POS_MASK, str, MAXBYTE);
	}
	else if( !strcmp( argv[1], "maskr" )){
		ret = eeprom_read( &eeprom, POS_MASK, str, MAXBYTE);
		str[ MAXBYTE ] = 0;
		if( ret == EXIT_SUCCESS ) printf("%s\n", str);
	}
	else if( !strcmp( argv[1], "gatew" )){
		if( strlen( argv[2] ) > MAXBYTE){
			printf("%s:%s)Write fail Input length > %d!!\n", __FILE__,  __FUNCTION__, MAXBYTE);
			return -1;
		}
		sprintf( (char*) str, "%s", argv[2] );
		ret = eeprom_write( &eeprom, POS_GATE, str, MAXBYTE);
	}
	else if( !strcmp( argv[1], "gater" )){
		ret = eeprom_read( &eeprom, POS_GATE, str, MAXBYTE);
		str[ MAXBYTE ] = 0;
		if( ret == EXIT_SUCCESS ) printf("%s\n", str);
	}
	else if( !strcmp( argv[1], "dns1w" )){
		if( strlen( argv[2] ) > MAXBYTE){
			printf("%s:%s)Write fail Input length > %d!!\n", __FILE__,  __FUNCTION__, MAXBYTE);
			return -1;
		}
		sprintf( (char*) str, "%s", argv[2] );
		ret = eeprom_write( &eeprom, POS_DNS1, str, MAXBYTE);
	}
	else if( !strcmp( argv[1], "dns1r" )){
		ret = eeprom_read( &eeprom, POS_DNS1, str, MAXBYTE);
		str[ MAXBYTE ] = 0;
		if( ret == EXIT_SUCCESS ) printf("%s\n", str);
	}
	else if( !strcmp( argv[1], "dns2w" )){
		if( strlen( argv[2] ) > MAXBYTE){
			printf("%s:%s)Write fail Input length > %d!!\n", __FILE__,  __FUNCTION__, MAXBYTE);
			return -1;
		}
		sprintf( (char*) str, "%s", argv[2] );
		ret = eeprom_write( &eeprom, POS_DNS2, str, MAXBYTE);
	}
	else if( !strcmp( argv[1], "dns2r" )){
		ret = eeprom_read( &eeprom, POS_DNS2, str, MAXBYTE);
		str[ MAXBYTE ] = 0;
		if( ret == EXIT_SUCCESS ) printf("%s\n", str);
	}
	else if( !strcmp( argv[1], "brandw" )){
		if( strlen( argv[2] ) > MAXBYTE){
			printf("%s:%s)Write fail Input length > %d!!\n", __FILE__,  __FUNCTION__, MAXBYTE);
			return -1;
		}
		sprintf( (char*) str, "%s", argv[2] );
		ret = eeprom_write( &eeprom, POS_BRAND, str, MAXBYTE);
	}
	else if( !strcmp( argv[1], "brandr" )){
		ret = eeprom_read( &eeprom, POS_BRAND, str, MAXBYTE);
		str[ MAXBYTE ] = 0;
		if( ret == EXIT_SUCCESS ) printf("%s\n", str);
	}
	else if( !strcmp( argv[1], "httpportw" )){
		if( strlen( argv[2] ) > MAXBYTE){
			printf("%s:%s)Write fail Input length > %d!!\n", __FILE__,  __FUNCTION__, MAXBYTE);
			return -1;
		}
		sprintf( (char*) str, "%s", argv[2] );
		ret = eeprom_write( &eeprom, POS_HTTPPORT, str, MAXBYTE);
	}
	else if( !strcmp( argv[1], "httpportr" )){
		ret = eeprom_read( &eeprom, POS_HTTPPORT, str, MAXBYTE);
		str[ MAXBYTE ] = 0;
		if( ret == EXIT_SUCCESS )	printf("%s\n", str);
		else				printf("80\n");
	}
	else if( !strcmp( argv[1], "rtspportw" )){
		if( strlen( argv[2] ) > MAXBYTE){
			printf("%s:%s)Write fail Input length > %d!!\n", __FILE__,  __FUNCTION__, MAXBYTE);
			return -1;
		}
		sprintf( (char*) str, "%s", argv[2] );
		ret = eeprom_write( &eeprom, POS_RTSPPORT, str, MAXBYTE);
	}
	else if( !strcmp( argv[1], "rtspportr" )){
		ret = eeprom_read( &eeprom, POS_RTSPPORT, str, MAXBYTE);
		str[ MAXBYTE ] = 0;
		if( ret == EXIT_SUCCESS )	printf("%s\n", str);
		else				printf("554\n");
	}
	else if( !strcmp( argv[1], "modelnamew" )){
		if( strlen( argv[2] ) > MAXBYTE ){
			printf("%s:%s)Write fail Input length > %d!!\n", __FILE__,  __FUNCTION__, MAXBYTE);
			return -1;
		}
		sprintf( (char*) str, "%s", argv[2] );
		ret = eeprom_write( &eeprom, POS_MODEL_FRIENDLY_NAME, str, MAXBYTE);
	}
	else if( !strcmp( argv[1], "modelnamer" )){
		ret = eeprom_read( &eeprom, POS_MODEL_FRIENDLY_NAME, str, MAXBYTE);
		if( ret == EXIT_SUCCESS )	printf("%s\n", str);
	}
	else if( !strcmp( argv[1], "yoicsdisplayw" )){
		if( strlen( argv[2] ) > MAXBYTE ){
			printf("%s:%s)Write fail Input length > %d!!\n", __FILE__,  __FUNCTION__, MAXBYTE);
			return -1;
		}
		sprintf( (char*) str, "%s", argv[2] );
		ret = eeprom_write( &eeprom, POS_YOICS, str, MAXBYTE);
	}
	else if( !strcmp( argv[1], "yoicsdisplayr" )){
		ret = eeprom_read( &eeprom, POS_YOICS, str, MAXBYTE);
		if( ret == EXIT_SUCCESS )	printf("%s\n", str);
	}
	else if( !strcmp( argv[1], "notew" )){
		if( strlen( argv[2] ) > NOTE_MAXBYTE ){
			printf("%s:%s)Write fail Input length > %d!!\n", __FILE__,  __FUNCTION__, NOTE_MAXBYTE);
			return -1;
		}
		sprintf( (char*) str, "%s", argv[2] );
		printf("%s\n",str);
		for (count=0;NOTE_MAXBYTE-count*MAXBYTE > 0;count++)
		ret = eeprom_write( &eeprom, POS_NOTE+count*(MAXBYTE+1), str+count*MAXBYTE, MAXBYTE);
	}
	else if( !strcmp( argv[1], "noter" )){
		
		for (count=0;NOTE_MAXBYTE-count*MAXBYTE > 0;count++)
		ret = eeprom_read( &eeprom, POS_NOTE+count*(MAXBYTE+1), str+count*MAXBYTE, MAXBYTE);
		
		//ret = eeprom_read( &eeprom, POS_NOTE, str, MAXBYTE);
		str[NOTE_MAXBYTE]=0xff;
		if( ret == EXIT_SUCCESS )	printf("%s\n", str);
	}
	else if( !strcmp( argv[1], "noteclear" )){
		memset( str, 0, 256 );
		for (count=0;NOTE_MAXBYTE-count*MAXBYTE > 0;count++)
		ret = eeprom_write( &eeprom, POS_NOTE+count*(MAXBYTE+1), str+count*MAXBYTE, MAXBYTE);
	}
	else if( !strcmp( argv[1], "list" )){
		printf("It should be display 8 attribute!\n");
		//brand
		ret = eeprom_read( &eeprom, POS_BRAND, str, MAXBYTE);
		if( ret == EXIT_SUCCESS )	printf("Brand:%s\n", str);
		//model
		ret = eeprom_read( &eeprom, POS_MODEL, str, MAXBYTE);
		if( ret == EXIT_SUCCESS )	printf("Model:%s\n", str);
		//mac
		ret = eeprom_read( &eeprom, POS_MAC, mac, 6 );
		if( ret == EXIT_SUCCESS )
			printf("MAC:%.2x:%.2x:%.2x:%.2x:%.2x:%.2x\n", mac[0], mac[1],mac[2],mac[3],mac[4],mac[5]);
		//ip
		ret = eeprom_read( &eeprom, POS_IP, str, MAXBYTE);
		str[ MAXBYTE ] = 0;
		if( ret == EXIT_SUCCESS ) printf("IP:%s\n", str);
		//mask
		ret = eeprom_read( &eeprom, POS_MASK, str, MAXBYTE);
		str[ MAXBYTE ] = 0;
		if( ret == EXIT_SUCCESS ) printf("MASK:%s\n", str);
		//gateway
		ret = eeprom_read( &eeprom, POS_GATE, str, MAXBYTE);
		str[ MAXBYTE ] = 0;
		if( ret == EXIT_SUCCESS ) printf("GateWay:%s\n", str);
		//dns1
		ret = eeprom_read( &eeprom, POS_DNS1, str, MAXBYTE);
		str[ MAXBYTE ] = 0;
		if( ret == EXIT_SUCCESS ) printf("DNS1:%s\n", str);
		//dns2
		ret = eeprom_read( &eeprom, POS_DNS2, str, MAXBYTE);
		str[ MAXBYTE ] = 0;
		if( ret == EXIT_SUCCESS ) printf("DNS2:%s\n", str);
		//http port
		ret = eeprom_read( &eeprom, POS_HTTPPORT, str, MAXBYTE);
		str[ MAXBYTE ] = 0;
		if( ret == EXIT_SUCCESS ) printf("HTTP Port:%s\n", str);
		//rtsp port
		ret = eeprom_read( &eeprom, POS_RTSPPORT, str, MAXBYTE);
		str[ MAXBYTE ] = 0;
		if( ret == EXIT_SUCCESS ) printf("RTSP Port:%s\n", str);
		//model friendly name
		ret = eeprom_read( &eeprom, POS_MODEL_FRIENDLY_NAME, str, MAXBYTE);
		if( ret == EXIT_SUCCESS )	printf("Model Name:%s\n", str);
		//yoics
		ret = eeprom_read( &eeprom, POS_YOICS, str, MAXBYTE);
		if( ret == EXIT_SUCCESS )	printf("YoicsDisplay:%s\n", str);
		//note
		for (count=0;NOTE_MAXBYTE-count*MAXBYTE > 0;count++)
		ret = eeprom_read( &eeprom, POS_NOTE+count*(MAXBYTE+1), str+count*MAXBYTE, MAXBYTE);
		
		//ret = eeprom_read( &eeprom, POS_NOTE, str, MAXBYTE);
		str[NOTE_MAXBYTE]=0xff;
		//ret = eeprom_read( &eeprom, POS_NOTE, str, NOTE_MAXBYTE);
		if( ret == EXIT_SUCCESS )	printf("Notes:%s\n", str);	

	}

	i2c_close( &eeprom );
	return ret;
}
