#ifndef __EEPROM_API_H__
#define  __EEPROM_API_H__

#include <i2c_tool.h>

#define I2C_DEV_DEVICE "/dev/i2c-0"

#define POS_BASE	0
#define POS_MAC		POS_BASE 
#define POS_MODEL	POS_BASE + 16
#define POS_VERSION	POS_BASE + 32
#define POS_IP		POS_BASE + 48
#define POS_MASK	POS_BASE + 64
#define POS_GATE	POS_BASE + 80
#define POS_DNS1	POS_BASE + 96
#define POS_DNS2	POS_BASE + 112
#define POS_BRAND	POS_BASE + 128
#define POS_HTTPPORT	POS_BASE + 144
#define POS_RTSPPORT	POS_BASE + 160
#define POS_MODEL_FRIENDLY_NAME	POS_BASE + 176
#define POS_YOICS	POS_BASE + 192
#define POS_NOTE	POS_BASE + 256

#define SUM( data, num, sum)	for( i = 0, sum=0; i < num; ++i ) sum += data[i]
#define MAXBYTE		15
#define NOTE_MAXBYTE		240


int eeprom_write( struct i2c_device_addr *eeprom,  int addr, unsigned char *str, unsigned int len );
int eeprom_read( struct i2c_device_addr *eeprom, int addr, unsigned char *str, unsigned int len );
int EEPROM_Test(struct i2c_device_addr *eeprom);


#endif

