
#include <stdio.h>
#include <string.h>
#include <stdlib.h>


#include <eeprom_api.h>


int eeprom_write( struct i2c_device_addr *eeprom, int addr, unsigned char *str, unsigned int len ){
	int	i;
	unsigned char str_tmp[16];
	
	memset( str_tmp, 255, 16 );
	
	for (i=0;i<len;i++)
		str_tmp[i]=str[i];
	SUM( str_tmp, len, str_tmp[ len ] );
	if ( i2c_write_data( eeprom, addr, str_tmp, len + 1) != EXIT_SUCCESS ){
		printf("Write [%s] Length=[%d] error\n", str, len + 1 );
		return EXIT_FAILURE;
	}
	return EXIT_SUCCESS;
}

int eeprom_read( struct i2c_device_addr *eeprom, int addr, unsigned char *str, unsigned int len ){
	int	i;
	char	ch;
	
	if ( i2c_read_data( eeprom, addr, str, len+1 ) != EXIT_SUCCESS  ){
//		printf("%s)Read eeprom error!\n", __FUNCTION__);
		return EXIT_FAILURE;
	}
	SUM( str, len, ch );
	if( str[ 0 ] == 0xff ) return EXIT_FAILURE;
	if( ch != str[ len ] ){
//		printf("j=%s\n", str );
//		printf("%s) Address[%d] CRC [%x]:[%x] error!\n", __FUNCTION__, addr, ch, str[ len ]);
		
		return EXIT_FAILURE;
	}
	return EXIT_SUCCESS;
}

int EEPROM_Test(struct i2c_device_addr *eeprom){
	unsigned char	buf[16]="0123456789abcdef", rbuf[16];
	
	int i;
	for( i = 0; i < 64; i += 16){
		if ( eeprom_write( eeprom, i, buf, 15) != EXIT_SUCCESS ){
			printf("Write Address=[%d] error\n", i);
			return EXIT_FAILURE;
		}
		memset( rbuf, 0, 16 );
		if( ( eeprom_read( eeprom, i, rbuf, 15) != EXIT_SUCCESS) && ( memcmp( buf, rbuf, 15 ) != 0 )){
			printf("Read Addres=[%d]eeprom error!\n", i);
			return EXIT_FAILURE;
		}
	}
	printf("%s) Test EEProm 1k bytes R/W okay!\n", __FUNCTION__);
	return EXIT_SUCCESS;
}


