
#define	AP_NAME					"IP_INSTALLER_SERVER:"
#define	FINDSVR_IDENTIFIER			"AvCm1"

#define	IPINST_PORT_SERVER			4416


#define	SZ_PKT_IDENTIFIER			5

#define	BSP_LAN1_HWALEN				6


#define	SZ_RECV_BUFF				8
#define	SZ_SEND_BUFF				450

#define	IF0_NAME				"rausb0"

#ifndef	ULONG
#define	ULONG	uint32_t
#endif

#include "debug.h"
#include "inf_func.h"


typedef struct {
	char guid[SZ_PKT_IDENTIFIER];
	ushort op_code;
}RequestPkt_t;


#pragma pack(push) /* push current alignment to stack */
#pragma pack(1) /* set alignment to 1 byte boundary */

typedef struct {
        char  session1[16];
	ushort  rtspport;
	char  session2[4];
        char  mac_addr[6];
        char  model[16];
        char  hostname[16];
        char  session3[16];
        char  networkmode;
        int   ip_addr;
        ushort  httpPort;
        int   subnet_msk;
        int   def_gateway;
        char  session4[202];
        int   dns1;
        int   dns2;
        char  session5[5];
        char  vendor[25];
        char  session6[7];
        char  title[30];
        char  session7[31];
} FindSvrPkt_t;
#pragma pack(pop)


static int FillReplyPacket(struct SHM_INFO_STRUCT *shm, FindSvrPkt_t * pkt, char *interface);
static int UDP_Broadcast(int sckt, int port, char *buf, int len, char *interface);
static int IPN_AddRoute(int skfd, unsigned long dest_ip, unsigned long gw_ip, int flags);
static int RandomDelay(ULONG max_ms);
static int jsnet_aton(char *str);
void jsnet_ntoa2(ULONG address, char *val);
static int FillSendPacket_Session();
unsigned short endian_swapshort(unsigned short x);
unsigned int endian_swapint(unsigned int x);
