
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <sys/ioctl.h>
#include <linux/if.h>
#include <linux/sockios.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>
#include <linux/route.h>
#include "airlive_ipinst.h"
#include "function_sys.h"


char recv_data[SZ_RECV_BUFF];
char send_data[SZ_SEND_BUFF];
int ret;
struct sockaddr_in myaddr_in, peeraddr_in;
int ls;				// local socket
int on = 1;
socklen_t peerLen;
RequestPkt_t *recvPkt;
FindSvrPkt_t *sendPkt;
int restart = 1;

static int SET_SOCKET()
{

	memset((char *)&myaddr_in, 0, sizeof(struct sockaddr_in));
	myaddr_in.sin_family = AF_INET;
	myaddr_in.sin_addr.s_addr = htonl(INADDR_ANY);
	myaddr_in.sin_port = htons(IPINST_PORT_SERVER);

	close(ls);

	ls = socket(AF_INET, SOCK_DGRAM, 0);

	if (ls == -1) {
		printf("socket error ..\n");
	}

	ret = setsockopt(ls, SOL_SOCKET, SO_DONTROUTE, (char *)&on, sizeof(on));
	ret = setsockopt(ls, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof(on));
	
	if (ret == -1) {
		DPRINTF(LOG_ERR, AP_NAME "setsockopt error 1 \n");
		printf("socket error .. 1\n");
	}
	ret = setsockopt(ls, SOL_SOCKET, SO_BROADCAST, (char *)&on, sizeof(on));
	if (ret == -1) {
		DPRINTF(LOG_ERR, AP_NAME "setsockopt error 2 \n");
		printf("setsockopt error 2 \n");
	}
	ret = bind(ls, (struct sockaddr *)&myaddr_in, sizeof(struct sockaddr_in));

	if (ret == -1) {
		DPRINTF(LOG_ERR, AP_NAME "bind error \n");
		printf("bind error \n");
	}
	
	recvPkt = (RequestPkt_t *) recv_data;
        sendPkt = (FindSvrPkt_t *) send_data; 
	restart = 0;
	return 0;
}

char host[20];
/*	Airlive packet 
static const char szSendPktData[399] = 
		{0x36, 0x42, 0x20, 0x20, 0x30, 0x32, 0x8f, 0x01, 0x43, 0x46, 0x33, 0x31, 0x01, 0x00, 0x01, 0x00\
		, 0x2a, 0x02, 0x01, 0x00, 0x35, 0x30, 0x00, 0x0e, 0xae, 0xa1, 0xd6, 0x53, 0x49, 0x50, 0x2d, 0x32\
		, 0x30, 0x30, 0x50, 0x48, 0x44, 0x2d, 0x32, 0x34, 0x00, 0x00, 0x00, 0x00, 0x49, 0x50, 0x2d, 0x32\
		, 0x30, 0x30, 0x50, 0x48, 0x44, 0x2d, 0x32, 0x34, 0x00, 0x95, 0x00, 0x40, 0x18, 0x00, 0x00, 0x00\
		, 0x48, 0x00, 0x00, 0x00, 0xee, 0x05, 0x00, 0x40, 0xac, 0x7a, 0xbb, 0xbe, 0x00, 0xb7, 0x01, 0xa8\
		, 0xc0, 0x50, 0x00, 0x00, 0xff, 0xff, 0xff, 0xfe, 0x01, 0xa8, 0xc0, 0x40, 0x98, 0x58, 0x02, 0x40\
		, 0xc4, 0xba, 0x0e, 0x40, 0x01, 0x00, 0x00, 0x00, 0x40, 0x59, 0x02, 0x40, 0x00, 0x00, 0x00, 0x00\
		, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0xe4, 0x04, 0x00, 0x00, 0x00, 0xdf, 0x01, 0x40\
		, 0x70, 0xd6, 0x01, 0x40, 0x64, 0x87, 0x00, 0x00, 0xa4, 0x40, 0x0f, 0x40, 0xdc, 0x85, 0x00, 0x00\
		, 0x00, 0x00, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x00, 0x00, 0x00, 0x69, 0xf2, 0x3d, 0xff\
		, 0xf8, 0x5a, 0x02, 0x40, 0x80, 0x7b, 0xbb, 0xbe, 0xcc, 0x7b, 0xbb, 0xbe, 0x8c, 0x7b, 0xbb, 0xbe\
		, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x40, 0x80, 0x7b, 0xbb, 0xbe\
		, 0x9c, 0x5a, 0x02, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0xdf, 0x01, 0x40, 0x01, 0x00, 0x00, 0x00\
		, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x59, 0x02, 0x40, 0x00, 0x00, 0x00, 0x00\
		, 0x44, 0x7b, 0xbb, 0xbe, 0x74, 0xfe, 0x0e, 0x40, 0xac, 0x13, 0x6c, 0x00, 0x24, 0x7c, 0xbb, 0x00\
		, 0xf4, 0xa8, 0x01, 0x40, 0x98, 0x58, 0x02, 0x40, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00\
		, 0xf8, 0x5a, 0x02, 0x40, 0x00, 0x50, 0x02, 0x40, 0x40, 0x59, 0x00, 0x40, 0x64, 0x87, 0x00, 0x00\
		, 0x3b, 0x04, 0x00, 0x00, 0x80, 0xe0, 0x01, 0x40, 0x70, 0xd6, 0x01, 0x40, 0xdd, 0x6a, 0x21, 0x40\
		, 0xa4, 0x40, 0x0f, 0x40, 0x78, 0x0b, 0x00, 0xa8, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x84, 0xfe\
		, 0xa9, 0x00, 0x41, 0x69, 0x72, 0x6c, 0x69, 0x76, 0x65, 0x00, 0x01, 0x40, 0x04, 0x09, 0x0f, 0x40\
		, 0x70, 0xd6, 0x01, 0x40, 0x24, 0x7c, 0xbb, 0xbe, 0xdd, 0xe0, 0xac, 0x0b, 0x4c, 0x7c, 0xbb, 0xbe\
		, 0x00, 0xdf, 0x49, 0x50, 0x2d, 0x32, 0x30, 0x30, 0x50, 0x48, 0x44, 0x2d, 0x32, 0x34, 0x00, 0x40\
		, 0x3c, 0x86, 0x00, 0x00, 0x44, 0x33, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x7d, 0xbb, 0xbe\
		, 0xc0, 0xdc, 0x01, 0x31, 0x30, 0x36, 0x30, 0x39, 0x39, 0x32, 0x31, 0x30, 0x00, 0x79, 0x65, 0x73\
		, 0x00, 0x6e, 0x6f, 0x00, 0x00, 0x62, 0x6f, 0x74, 0x68, 0x00, 0x00, 0x00, 0x00, 0xbb, 0x01};
*/
int main(int argc, char **argv)
{
	
        int hostport;
        memset(host, 0, 20);
	printf("airlive_ipinst start ... \n");

	if (sys_connect_mgapp() != EXIT_SUCCESS) {
		printf("Connect Failure!!!\n");
		return EXIT_SUCCESS;
	}
	struct SHM_INFO_STRUCT shm;

	if (INF_attach(&shm, "/etc/system.conf") != EXIT_SUCCESS)
		printf("Inf_Attach fail!\n");

        while (1) 
     	{
		
		if (restart == 1) 
		{
			SET_SOCKET();
		}
		peerLen = sizeof(peeraddr_in);
		ret = recvfrom(ls, recv_data, SZ_RECV_BUFF, 0, (struct sockaddr *)&peeraddr_in, &peerLen);
                if (ret <= 0) {
			DPRINTF(LOG_DEBUG, AP_NAME "recvfrom error \n");
		}
                
		if (strncmp(recv_data, FINDSVR_IDENTIFIER, SZ_PKT_IDENTIFIER) &&
		    strncmp(recv_data, "AvCm01", SZ_PKT_IDENTIFIER+1))
                	continue;

		hostport =ntohs(peeraddr_in.sin_port);

               	switch (recvPkt->op_code) 
		{
                	case 0x14:
               			FillSendPacket_Session();
                		if (FillReplyPacket(&shm, sendPkt, "eth0") >= 0)
                		ret = UDP_Broadcast(ls,hostport, send_data, sizeof(FindSvrPkt_t), "eth0");
                                if (ret < 0) {
						DPRINTF(LOG_ERR, AP_NAME "UDP1 error [ ret=%d ErrCode=0x%04x ]\n", ret, errno);
						printf("UDP1 error [ ret=%d ErrCode=0x%04x ]\n", ret, errno);
			        }
                                if (FillReplyPacket(&shm, sendPkt, "rausb0") >= 0)
                		ret = UDP_Broadcast(ls,hostport, send_data, sizeof(FindSvrPkt_t), "eth0");
                                if (ret < 0) {
						DPRINTF(LOG_ERR, AP_NAME "UDP1 error [ ret=%d ErrCode=0x%04x ]\n", ret, errno);
						printf("UDP1 error [ ret=%d ErrCode=0x%04x ]\n", ret, errno);
			        }
		                break;
                        default:
				break;

		}
		
	}
        close(ls);
}

static int FillReplyPacket(struct SHM_INFO_STRUCT *shm, FindSvrPkt_t * pkt, char *interface)
{
	struct ifreq ifr;
	struct sockaddr_in *saddr;
	int skfd;
	skfd = socket(AF_INET, SOCK_DGRAM, 0);
	if (skfd < 0) 
	{
		return -1;
	}

	strcpy(ifr.ifr_name, interface);
	if (ioctl(skfd, SIOCGIFHWADDR, &ifr) < 0) 
	{
		goto err_label;
	}

	memcpy(pkt->mac_addr, ifr.ifr_hwaddr.sa_data, BSP_LAN1_HWALEN);

	// Get IP Address
	if (ioctl(skfd, SIOCGIFADDR, &ifr) < 0) {
		goto err_label;
	}
	saddr = (struct sockaddr_in *)&ifr.ifr_addr;
	pkt->ip_addr = endian_swapint((saddr->sin_addr).s_addr);

	// Get Subnet Mask
	if (ioctl(skfd, SIOCGIFNETMASK, &ifr) < 0) {
		goto err_label;
	}
	saddr = (struct sockaddr_in *)&ifr.ifr_addr;
	pkt->subnet_msk = endian_swapint((saddr->sin_addr).s_addr);

        char *ret;

        if (!strcmp(interface, "eth0"))
        {
             ret = INF_get(shm, "Network.DefaultRouter", NULL );
              pkt->def_gateway =  endian_swapint(jsnet_aton(ret));
              ret = INF_get(shm, "Network.BootProto", NULL );
              if (!strcasecmp(ret, "dhcp"))
        		pkt->networkmode =0x01;
	      else
                        pkt->networkmode =0x00;


        }
        else if (!strcmp(interface, "rausb0"))
        {
             ret = INF_get(shm, "Wireless.DefaultRouter", NULL );
             pkt->def_gateway = endian_swapint(jsnet_aton(ret));
               
               ret = INF_get(shm, "Wireless.BootProto", NULL );
               if (!strcasecmp(ret, "dhcp"))
        		pkt->networkmode =0x01;
	       else
                        pkt->networkmode =0x00;

        }


	ret = INF_get(shm, "Network.DNSServer1", NULL);
	pkt->dns1 = endian_swapint(jsnet_aton(ret));

	ret = INF_get(shm, "Network.DNSServer2", NULL);
	pkt->dns2 = endian_swapint(jsnet_aton(ret));


	ret = INF_get(shm, "System.WebPort", NULL);
	pkt->httpPort = endian_swapshort(htons(atoi(ret)));

	ret = INF_get(shm, "Network.RTSP.Port", NULL);
	pkt->rtspport = endian_swapshort(htons(atoi(ret)));


	ret = INF_get(shm, "Brand.ProdModel", NULL);
	sprintf(pkt->model, "%s", ret);	//also update model name
	sprintf(pkt->hostname, "%s", ret);
	
	ret = INF_get(shm, "Image.I00.Text.String", NULL);
	sprintf(pkt->title, "%s", ret);

	ret="Airlive";
	sprintf(pkt->vendor, "%s", ret);

        ret = INF_get(shm, "Network.DIPS", NULL);
        pkt->session7[3]=ret[0];
        pkt->session7[4]=ret[1];  
        pkt->session7[5]=ret[2];
        pkt->session7[6]=ret[3];
        pkt->session7[7]=ret[4];
        pkt->session7[8]=ret[5];  
        pkt->session7[9]=ret[6];
        pkt->session7[10]=ret[7];
        pkt->session7[11]=ret[8];
        pkt->session7[12]=ret[9];
 
        close(skfd);
	return EXIT_SUCCESS;

    err_label:
	close(skfd);
	return -1;

}




//send data ---follow process
int UDP_Broadcast(int sckt, int port, char *buf, int len, char *interface)
{
	struct sockaddr_in peeraddr_in1;
	struct sockaddr_in *myintf;
	struct ifreq if_ppp0;
	struct hostent *he;

	int ret = 0;
	const int hold = 1;
	int sckt1;

	RandomDelay(1000);

	if ((sckt1 = socket(AF_INET, SOCK_DGRAM, 0)) == -1) {
		perror("socket");
		exit(1);
	}

	he = gethostbyname("255.255.255.255");
	memset((char *)&peeraddr_in1, 0, sizeof(struct sockaddr_in));
	peeraddr_in1.sin_family = AF_INET;
	peeraddr_in1.sin_addr.s_addr = htonl(INADDR_BROADCAST);
	peeraddr_in1.sin_port = htons(port);

	myintf = &peeraddr_in1;
	memset(peeraddr_in1.sin_zero, '\0', sizeof peeraddr_in1.sin_zero);
	strncpy(if_ppp0.ifr_name, interface, IFNAMSIZ);
	ret = setsockopt(sckt1, SOL_SOCKET, SO_BINDTODEVICE, (char *)&if_ppp0, sizeof(if_ppp0));

	ret = setsockopt(sckt1, SOL_SOCKET, SO_BROADCAST, (char *)&hold, sizeof(hold));

	if (ret == -1) {
		DPRINTF(LOG_ERR, AP_NAME "setsockopt error 3 \n");
	}

	
	ret = sendto(sckt1, buf, len, 0, (struct sockaddr *)&peeraddr_in1, sizeof(peeraddr_in1));

	if (ret < 0) {
		DPRINTF(LOG_ERR, AP_NAME "ERRNO=%d, const=%d\n", errno, ENETUNREACH);
		if (errno == ENETUNREACH) {
			IPN_AddRoute(sckt1, INADDR_BROADCAST, 0, RTF_UP | RTF_HOST);
			ret = sendto(sckt1, buf, len, 0, (struct sockaddr *)&peeraddr_in1, sizeof(peeraddr_in1));
		} else {
			DPRINTF(LOG_ERR, AP_NAME "UDP4 error [ ret=%d ErrCode=0x%04x ]\n", ret, errno);
			ret = errno;
		}
	}

	else {
		                                               
	}

	close(sckt1);
	return ret;
}



int RandomDelay(ULONG max_ms)
{
	unsigned int dd;
        dd = (int)(((double)max_ms) * rand() / (RAND_MAX + 1.0));
	DPRINTF(LOG_DEBUG, AP_NAME "ipinst=%d\n", dd);
	usleep(dd * 1000);
	return EXIT_SUCCESS;
}




static int IPN_AddRoute(int skfd, unsigned long dest_ip, unsigned long gw_ip, int flags)
{
	struct rtentry rt;
	struct sockaddr_in *dst, *gw;

	memset((char *)&rt, 0, sizeof(struct rtentry));
	rt.rt_dev = (char *)IF0_NAME;
	dst = (struct sockaddr_in *)&(rt.rt_dst);
	gw = (struct sockaddr_in *)&(rt.rt_gateway);
	dst->sin_family = AF_INET;
	dst->sin_addr.s_addr = htonl(dest_ip);

	rt.rt_flags = flags;

	if (ioctl(skfd, SIOCADDRT, &rt) < 0) {
		DPRINTF(LOG_DEBUG, AP_NAME "SIOCADDRT error \n");
		return EXIT_FAILURE;
	}

	return EXIT_SUCCESS;
}




static int FillSendPacket_Session()
{
     char session1[16]=
     {
       	0x20, 0x20, 0x20, 0x20,
	0x30, 0x32, 0x8f, 0x01,
	0x43, 0x46, 0x33, 0x31,
	0x01, 0x00, 0x01, 0x00
     };

     char session2[4]=
     { 
       0x01, 0x00, 0x35, 0x30
       
     };
     
     char session3[16]=
     { 
       0x00, 0x00, 0x00, 0x00,
       0x00, 0x00, 0x00, 0x00,
       0x00, 0x00, 0x00, 0x00,
       0x00, 0x00, 0x00, 0x00,
     };

      char session4[202];
 
     char session5[5]=
     { 
    	0x5f, 0x98, 0xfe, 0xa9,
	0x01
     };  

     char session6[7]=
     { 
 	0x40, 0x00, 0x00, 0x00,
	0x00, 0x50, 0xcf
     };   
     
     char session7[31]=
     { 
 	0x38, 0x86, 0x01, 0x32,
	0x31, 0x32, 0x34, 0x35,
	0x36, 0x31, 0x35, 0x00,
	0x00, 0x79, 0x65, 0x73,
	0x00, 0x6e, 0x6f, 0x00,
	0x00, 0x62, 0x6f, 0x74,
	0x68, 0x00, 0x00, 0x00,
	0x00, 0xbb, 0x01
     };   
    memset(session4, 0, sizeof(session4));
    memcpy(sendPkt->session1,session1,16);
    memcpy(sendPkt->session2,session2,4);
    memcpy(sendPkt->session3,session3,11);
    memcpy(sendPkt->session4,session4,202);
    memcpy(sendPkt->session5,session5,5);
    memcpy(sendPkt->session6,session6,7);
    memcpy(sendPkt->session7,session7,31);
    return 0;
}


//---------------------



static int jsnet_aton(char *str)
{
	struct in_addr addr;

	return inet_aton(str, &addr) ? addr.s_addr : 0;
}

void jsnet_ntoa2(ULONG address, char *val)
{
	struct in_addr addr;
   	addr.s_addr = address;
	sprintf(val, "%s", inet_ntoa(addr));
}


unsigned short endian_swapshort(unsigned short x)
{
 	x = (x>>8) | (x<<8);
        return x;
}

unsigned int endian_swapint(unsigned int x)
{
       x = (x>>24) |((x<<8) & 0x00FF0000) |((x>>8) & 0x0000FF00) | (x<<24);

       return x;

} 



