#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include "NVP7000.h"


enum config_e {
    NO_CONFIG,
    NTSC,
    PAL,
    NTSCCB,
    PALCB
};



#define VERBOSE(arg...) do { if(verbose) { printf(arg); printf("\n"); }; } while(0)
#define ERROR(arg...) do { if(!quiet) { fprintf(stderr, "ERROR: ");fprintf(stderr,arg); fprintf(stderr,"\n"); } } while(0)
#define DISPLAY(arg...) do { if(!quiet) { printf(arg); printf("\n"); } } while(0)



static int verbose=0, quiet=0;

void help(char *prog)
{
    printf("Syntax is: %s [ <nvp7000_dev> <nvp7000_params> [ --verbose ] | --help ]\n",prog);    
    printf("with:\n");
    printf("\t  --verbose or -v: Set to make program more verbose.\n");
    printf("\t  --help or -h: Display this help.\n");
    printf("\t  --bus <i2c_bus> : Specify I2C bus to open(default /dev/i2c).\n");
    printf("\t  --dev <0xNN> : Specify device address on I2C bus.\n");
    printf("\t  --ntsc : Set to default NTSC config.\n");
    printf("\t  --pal  : Set to default PAL config.\n");
    printf("\t  --colorbars : Enable color bar\n");
    printf("\t  --nocolorbars : Disable color bar\n");
    printf("\t  --brightness : Set brightness value -128 ~ 127 \n");
    printf("\t  --contrast : Set contrast value 0 ~ 255 \n");
    printf("\t  --hue : Set hue value 0 ~ 255 \n");
    printf("\t  --saturation : Set saturation value 0 ~ 255 \n");
    
//    printf("\t  --writeaddr <0xNN>  : Defines subaddress for data write.\n");
//    printf("\t  --writedata <0xNN> [<0xNN>...<0xNN>] : Write data, range specifies multi-btye.\n");
//    printf("\t  --readaddr  <0xNN>  : Defines subaddress for data read(one byte read by default).\n");
//    printf("\t  --readsize  <NN>    : Define to read more than one byte.\n");
//    printf("\n");
    return;
}


int main(int argc, char * argv[] ) {
	
	NVP7000 * nvp7000;
	nvp7000 = new NVP7000();
	
	char i2c_bus[128] = "/dev/i2c";
	int i2c_dev = 0x88;
	int c_help = 0;	
	int c_init = 0;
	int c_format = 2;
	int c_colorbar = 99;	
	
	int c_brightness = 0;
	int c_brightness_val = 0;	
	int c_contrast = 0;
	int c_contrast_val = 0;	
	int c_hue = 0;
	int c_hue_val = 0;	
	int c_saturation = 0;
	int c_saturation_val = 0;	
	int go_arg = 0;


	for( int count=1; count < argc; count++ ) {  
	 	if((strcmp(argv[count],"-v")==0) || (strcmp(argv[count],"--verbose")==0)) {
        	        verbose=1;
		} 
		else if((strcmp(argv[count],"-h")==0) || (strcmp(argv[count],"--help")==0)) {
        	        help( argv[0] );
        	        exit(1);
		}
	        else if(strcmp(argv[count],"--bus")==0) {
			if ( argc > (count + 1) ) {			
	    			sprintf(i2c_bus, "%s", argv[++count] );
				VERBOSE("Set i2c_bus = [%s].\n", i2c_bus);	    			
            		}
		}   
	        else if(strcmp(argv[count],"--dev")==0) {
			if ( argc > (count + 1) ) {			
	    			//i2c_dev = atoi(argv[++count] );
				i2c_dev = strtol(argv[++count], NULL, 16);	    			
				VERBOSE("Set i2c_dev = [0x%2x].\n", i2c_dev);	    			
            		}
		}   				
	        else if(strcmp(argv[count],"--ntsc")==0) {
        	        go_arg = 1;	        	
	        	c_init = 1;
			c_format = 0;
		}    
	        else if(strcmp(argv[count],"--pal")==0) {
        	        go_arg = 1;	        	
			c_init = 1;
			c_format = 1;
		}    
	        else if(strcmp(argv[count],"--colorbars")==0) {
        	        go_arg = 1;	        	
			c_colorbar = 1;
		}    
	        else if(strcmp(argv[count],"--nocolorbars")==0) {
        	        go_arg = 1;	        	
			c_colorbar = 0;
		}
	        else if(strcmp(argv[count],"--brightness")==0) {
        	        go_arg = 1;	        	
			c_brightness = 1;
			if ( argc > (count + 1) ) {			
            			c_brightness_val = atoi(argv[++count] );
            		}	
		}    
	        else if(strcmp(argv[count],"--contrast")==0) {
        	        go_arg = 1;	        	
			c_contrast = 1;
			if ( argc > (count + 1) ) {
            			c_contrast_val = atoi(argv[++count] );
            		} 
		}    
	
	        else if(strcmp(argv[count],"--hue")==0) {
        	        go_arg = 1;	        	
			c_hue = 1;	
			if ( argc > (count + 1) ) {	
            			c_hue_val = atoi(argv[++count] );			
            		}	
		}    
	        else if(strcmp(argv[count],"--saturation")==0) {
        	        go_arg = 1;	        	
			c_saturation = 1;
			if ( argc > (count + 1) ) {						
				c_saturation_val = atoi(argv[++count] );
			}	
		}    
	}
	

	if ( go_arg == 0 ) {
		help(argv[0]);
		exit(1);
	}
	


	if ( c_init == 1 ) {
		if ( nvp7000->Init( (char*)i2c_bus, i2c_dev, c_format ) == EXIT_SUCCESS ) {
			VERBOSE("NVP7000 [%s] 0x[%2x] initial success.\n", i2c_bus, i2c_dev);
		} else {
			VERBOSE("NVP7000 [%s] 0x[%2x] initial fail.\n", i2c_bus, i2c_dev);
		}
	} else {
		if ( nvp7000->Open( (char*)i2c_bus, i2c_dev, c_format ) == EXIT_SUCCESS ) {
			VERBOSE("Open i2c_bus [%s] i2c_dev [0x%2x] success.\n", i2c_bus, i2c_dev);
		} else {
			VERBOSE("Open i2c_bus [%s] i2c_dev [0x%2x] fail.\n", i2c_bus, i2c_dev);			
			exit(1);
		}	
	}

	if ( c_brightness == 1 ) {
		if ( nvp7000->SetBrightness( c_brightness_val ) == EXIT_SUCCESS ) {
			VERBOSE("Set brightness value [%d] success.\n", c_brightness_val );
		} else {
			VERBOSE("Set brightness value [%d] fail.\n", c_brightness_val );
		}		
	}

	if ( c_contrast == 1 ) {
		if ( nvp7000->SetContrast( c_contrast_val ) == EXIT_SUCCESS ) {
			VERBOSE("Set contrast value [%d] success.\n", c_contrast_val );
		} else {
			VERBOSE("Set contrast value [%d] fail.\n", c_contrast_val );
		}		
	}

	if ( c_hue == 1 ) {
		if ( nvp7000->SetHue( c_hue_val ) == EXIT_SUCCESS ) {
			VERBOSE("Set hue value [%d] success.\n", c_hue_val );
		} else {
			VERBOSE("Set hue value [%d] fail.\n", c_hue_val );
		}		
		
	}

	if ( c_saturation == 1 ) {
		if ( nvp7000->SetSaturation( c_saturation_val ) == EXIT_SUCCESS ) {
			VERBOSE("Set saturation value [%d] success.\n", c_saturation_val );
		} else {
			VERBOSE("Set saturation value [%d] fail.\n", c_saturation_val );
		}		
	}
	
	if ( c_colorbar == 1 ) {
		if ( nvp7000->StartColorBar() == EXIT_SUCCESS ) {
			VERBOSE("Enable colorbars success.\n");
		} else {
			VERBOSE("Enable colorbars fail.\n");
		}			
	}
	
	if ( c_colorbar == 0 ) {	
		if ( nvp7000->StopColorBar() == EXIT_SUCCESS ) {
			VERBOSE("Disable colorbars success.\n");
		} else {
			VERBOSE("Disable colorbars fail.\n");
		}		
	}

	delete nvp7000;
	return EXIT_SUCCESS;
}
