/* pipe system call for Linux/MIPS */

/*see uClibc's sh/pipe.c and glibc-2.2.4's mips/pipe.S */

#include <errno.h>
#include <unistd.h>
#include <syscall.h>
/* #include <asm/asm.h> */

int pipe(int *fd)
{
    register long res __asm__ ("$2");	/* v0 */
    register long res2 __asm__ ("$3");	/* v1 */

    __asm__ volatile ("move $4,%2;"	/* a0 */
        "li $2,%1;"   
        "syscall;"
        : "=r" (res)
        : "i" (__NR_pipe), "r" (fd)
        : "$2", "$3", "$4", "$7", "$8","$9","$10","$11","$12","$13","$14","$15","$24");

       fd[0] = res;
       fd[1] = res2;
       return(0);
}
