#ifndef _BITS_SYSCALLS_H
#define _BITS_SYSCALLS_H
#ifndef _SYSCALL_H
# error "Never use <bits/syscalls.h> directly; include <sys/syscall.h> instead."
#endif

/* This includes the `__NR_<name>' syscall numbers taken from the Linux kernel
 * header files.  It also defines the traditional `SYS_<name>' macros for older
 * programs.  */
#include <bits/sysnum.h>

#ifndef __set_errno
# define __set_errno(val) (*__errno_location ()) = (val)
#endif
#ifndef SYS_ify
# define SYS_ify(syscall_name)  (__NR_##syscall_name)
#endif

#ifndef __ASSEMBLER__
#ifndef __UCLIBC_USE_UNIFIED_SYSCALL__
/* XXX - _foo needs to be __foo, while __NR_bar could be _NR_bar. */
#define _syscall0(type,name) \
type name(void) \
{ \
long __res, __err; \
__asm__ volatile ("li\t$2,%2\n\t" \
		  "syscall\n\t" \
		  "move\t%0, $2\n\t" \
		  "move\t%1, $7" \
                  : "=r" (__res), "=r" (__err) \
                  : "i" (__NR_##name) \
                  : "$2","$7","$8","$9","$10","$11","$12","$13","$14","$15", \
		    "$24"); \
if (__err == 0) \
	return (type) __res; \
__set_errno(__res); \
return (type)-1; \
}

/*
 * DANGER: This macro isn't usable for the pipe(2) call
 * which has a unusual return convention.
 */
#define _syscall1(type,name,atype,a) \
type name(atype a) \
{ \
long __res, __err; \
__asm__ volatile ("move\t$4,%3\n\t" \
		  "li\t$2,%2\n\t" \
		  "syscall\n\t" \
		  "move\t%0, $2\n\t" \
		  "move\t%1, $7" \
		  : "=r" (__res), "=r" (__err) \
		  : "i" (__NR_##name),"r" ((long)(a)) \
		  : "$2","$4","$7","$8","$9","$10","$11","$12","$13","$14","$15","$24"); \
if (__err == 0) \
	return (type) __res; \
__set_errno(__res); \
return (type)-1; \
}

#define _syscall2(type,name,atype,a,btype,b) \
type name(atype a,btype b) \
{ \
long __res, __err; \
__asm__ volatile ("move\t$4,%3\n\t" \
                  "move\t$5,%4\n\t" \
		  "li\t$2,%2\n\t" \
		  "syscall\n\t" \
		  "move\t%0, $2\n\t" \
		  "move\t%1, $7" \
                  : "=r" (__res), "=r" (__err) \
                  : "i" (__NR_##name),"r" ((long)(a)), \
                                      "r" ((long)(b)) \
                  : "$2","$4","$5","$7","$8","$9","$10","$11","$12","$13", \
		    "$14","$15", "$24"); \
if (__err == 0) \
	return (type) __res; \
__set_errno(__res); \
return (type)-1; \
}

#define _syscall3(type,name,atype,a,btype,b,ctype,c) \
type name (atype a, btype b, ctype c) \
{ \
long __res, __err; \
__asm__ volatile ("move\t$4,%3\n\t" \
                  "move\t$5,%4\n\t" \
                  "move\t$6,%5\n\t" \
		  "li\t$2,%2\n\t" \
		  "syscall\n\t" \
		  "move\t%0, $2\n\t" \
		  "move\t%1, $7" \
                  : "=r" (__res), "=r" (__err) \
                  : "i" (__NR_##name),"r" ((long)(a)), \
                                      "r" ((long)(b)), \
                                      "r" ((long)(c)) \
                  : "$2","$4","$5","$6","$7","$8","$9","$10","$11","$12", \
		    "$13","$14","$15","$24"); \
if (__err == 0) \
	return (type) __res; \
__set_errno(__res); \
return (type)-1; \
}

#define _syscall4(type,name,atype,a,btype,b,ctype,c,dtype,d) \
type name (atype a, btype b, ctype c, dtype d) \
{ \
long __res, __err; \
__asm__ volatile ("move\t$4,%3\n\t" \
                  "move\t$5,%4\n\t" \
                  "move\t$6,%5\n\t" \
                  "move\t$7,%6\n\t" \
		  "li\t$2,%2\n\t" \
		  "syscall\n\t" \
		  "move\t%0, $2\n\t" \
		  "move\t%1, $7" \
                  : "=r" (__res), "=r" (__err) \
                  : "i" (__NR_##name),"r" ((long)(a)), \
                                      "r" ((long)(b)), \
                                      "r" ((long)(c)), \
                                      "r" ((long)(d)) \
                  : "$2","$4","$5","$6","$7","$8","$9","$10","$11","$12", \
		    "$13","$14","$15","$24"); \
if (__err == 0) \
	return (type) __res; \
__set_errno(__res); \
return (type)-1; \
}

#define _syscall5(type,name,atype,a,btype,b,ctype,c,dtype,d,etype,e) \
type name (atype a,btype b,ctype c,dtype d,etype e) \
{ \
long __res, __err; \
__asm__ volatile ("move\t$4,%3\n\t" \
                  "move\t$5,%4\n\t" \
                  "move\t$6,%5\n\t" \
		  "lw\t$2,%7\n\t" \
                  "move\t$7,%6\n\t" \
		  "subu\t$29,24\n\t" \
		  "sw\t$2,16($29)\n\t" \
		  "li\t$2,%2\n\t" \
		  "syscall\n\t" \
		  "move\t%0, $2\n\t" \
		  "move\t%1, $7\n\t" \
		  "addiu\t$29,24" \
                  : "=r" (__res), "=r" (__err) \
                  : "i" (__NR_##name),"r" ((long)(a)), \
                                      "r" ((long)(b)), \
                                      "r" ((long)(c)), \
                                      "r" ((long)(d)), \
                                      "m" ((long)(e)) \
                  : "$2","$4","$5","$6","$7","$8","$9","$10","$11","$12", \
                    "$13","$14","$15","$24"); \
if (__err == 0) \
	return (type) __res; \
__set_errno(__res); \
return (type)-1; \
}

#define _syscall6(type,name,atype,a,btype,b,ctype,c,dtype,d,etype,e,ftype,f) \
type name (atype a,btype b,ctype c,dtype d,etype e,ftype f) \
{ \
long __res, __err; \
__asm__ volatile ("move\t$4,%3\n\t" \
                  "move\t$5,%4\n\t" \
                  "move\t$6,%5\n\t" \
		  "lw\t$2,%7\n\t" \
		  "lw\t$3,%8\n\t" \
                  "move\t$7,%6\n\t" \
		  "subu\t$29,24\n\t" \
		  "sw\t$2,16($29)\n\t" \
		  "sw\t$3,20($29)\n\t" \
		  "li\t$2,%2\n\t" \
		  "syscall\n\t" \
		  "move\t%0, $2\n\t" \
		  "move\t%1, $7\n\t" \
		  "addiu\t$29,24" \
                  : "=r" (__res), "=r" (__err) \
                  : "i" (__NR_##name),"r" ((long)(a)), \
                                      "r" ((long)(b)), \
                                      "r" ((long)(c)), \
                                      "r" ((long)(d)), \
                                      "m" ((long)(e)), \
                                      "m" ((long)(f)) \
                  : "$2","$3","$4","$5","$6","$7","$8","$9","$10","$11", \
                    "$12","$13","$14","$15","$24"); \
if (__err == 0) \
	return (type) __res; \
__set_errno(__res); \
return (type)-1; \
}

#define _syscall7(type,name,atype,a,btype,b,ctype,c,dtype,d,etype,e,ftype,f,gtype,g) \
type name (atype a,btype b,ctype c,dtype d,etype e,ftype f,gtype g) \
{ \
long __res, __err; \
__asm__ volatile ("move\t$4,%3\n\t" \
                  "move\t$5,%4\n\t" \
                  "move\t$6,%5\n\t" \
		  "lw\t$2,%7\n\t" \
		  "lw\t$3,%8\n\t" \
                  "move\t$7,%6\n\t" \
		  "subu\t$29,32\n\t" \
		  "sw\t$2,16($29)\n\t" \
		  "lw\t$2,%9\n\t" \
		  "sw\t$3,20($29)\n\t" \
		  "sw\t$2,24($29)\n\t" \
		  "li\t$2,%2\n\t" \
		  "syscall\n\t" \
		  "move\t%0, $2\n\t" \
		  "move\t%1, $7\n\t" \
		  "addiu\t$29,32" \
                  : "=r" (__res), "=r" (__err) \
                  : "i" (__NR_##name),"r" ((long)(a)), \
                                      "r" ((long)(b)), \
                                      "r" ((long)(c)), \
                                      "r" ((long)(d)), \
                                      "m" ((long)(e)), \
                                      "m" ((long)(f)), \
                                      "m" ((long)(g)) \
                  : "$2","$3","$4","$5","$6","$7","$8","$9","$10","$11", \
                    "$12","$13","$14","$15","$24"); \
if (__err == 0) \
	return (type) __res; \
__set_errno(__res); \
return (type)-1; \
}
#else	/* if __UCLIBC_USE_UNIFIED_SYSCALL__ */
#define _stringify1_(s) #s
#define _stringify0_(s) _stringify1_(s)
#ifdef PROF
#define	PROFSTRING \
	".set           noat;"          \
	"move           $1,$31;"        \
	"jal            _mcount;"       \
	"subu           $29,$29,8;"     \
	".set           at;"
#else
#define	PROFSTRING
#endif

/* #define CHECKSYSCALLREGISTERS */
#ifdef	CHECKSYSCALLREGISTERS
/* Registers to save and restore: */
/* v1, a0, a1, a2,  s0,  s1,  s2,  s3,  s4,  s5,  s6,  s7,  t9,  gp,  sp,  s8,  ra */
/* $3, $4, $5, $6, $16, $17, $18, $19, $20, $21, $22, $23, $25, $28, $29, $30, $31 */
#define	SAVE_ALL_REGS \
	".set	noat;" \
	"lui	$8, %hi(SAVE_ALL_REGS_HERE);" \
	"addiu	$8, $8, %lo(SAVE_ALL_REGS_HERE);" \
	"sw	$3, 4($8);" \
	"sw	$4, 8($8);" \
	"sw	$5, 12($8);" \
	"sw	$6, 16($8);" \
	"sw	$16, 24($8);" \
	"sw	$17, 28($8);" \
	"sw	$18, 32($8);" \
	"sw	$19, 36($8);" \
	"sw	$20, 40($8);" \
	"sw	$21, 44($8);" \
	"sw	$22, 48($8);" \
	"sw	$23, 52($8);" \
	"sw	$25, 56($8);" \
	"sw	$28, 60($8);" \
	"sw	$29, 64($8);" \
	"sw	$30, 68($8);" \
	"sw	$31, 72($8);" \
	"lui	$8,%hi(SAVE_STACK_HERE);" \
	"addiu	$8,$8,%lo(SAVE_STACK_HERE);" \
	"addiu	$9,$29,-512;" \
	"addiu	$10,$29,512;" \
    "1:" \
	"lw	$11,0($9);" \
	"addiu	$9,$9,4;" \
	"sw	$11,0($8);" \
	"bne	$9,$10,1b;" \
	"addiu	$8,$8,4;"

#define	CHECK_ALL_REGS \
	"lui	$8, %hi(SAVE_ALL_REGS_HERE);" \
	"addiu	$8, $8, %lo(SAVE_ALL_REGS_HERE);" \
	"sw	$7, 20($8);" \
	"sw	$2, 0($8);" \
	"lw	$9, 4($8);" \
	"move	$11, $3;" \
	"bne	$3, $9, 1f;" \
	"li	$10, 3;" \
	"lw	$9, 8($8);" \
	"move	$11, $4;" \
	"bne	$4, $9, 1f;" \
	"li	$10, 4;" \
	"lw	$9, 12($8);" \
	"move	$11, $5;" \
	"bne	$5, $9, 1f;" \
	"li	$10, 5;" \
	"lw	$9, 16($8);" \
	"move	$11, $6;" \
	"bne	$6, $9, 1f;" \
	"li	$10, 6;" \
	"lw	$9, 24($8);" \
	"move	$11, $16;" \
	"bne	$16, $9, 1f;" \
	"li	$10, 16;" \
	"lw	$9, 28($8);" \
	"move	$11, $17;" \
	"bne	$17, $9, 1f;" \
	"li	$10, 17;" \
	"lw	$9, 32($8);" \
	"move	$11, $18;" \
	"bne	$18, $9, 1f;" \
	"li	$10, 18;" \
	"lw	$9, 36($8);" \
	"move	$11, $19;" \
	"bne	$19, $9, 1f;" \
	"li	$10, 19;" \
	"lw	$9, 40($8);" \
	"move	$11, $20;" \
	"bne	$20, $9, 1f;" \
	"li	$10, 20;" \
	"lw	$9, 44($8);" \
	"move	$11, $21;" \
	"bne	$21, $9, 1f;" \
	"li	$10, 21;" \
	"lw	$9, 48($8);" \
	"move	$11, $22;" \
	"bne	$22, $9, 1f;" \
	"li	$10, 22;" \
	"lw	$9, 52($8);" \
	"move	$11, $23;" \
	"bne	$23, $9, 1f;" \
	"li	$10, 23;" \
	"lw	$9, 56($8);" \
	"move	$11, $25;" \
	"bne	$25, $9, 1f;" \
	"li	$10, 25;" \
	"lw	$9, 60($8);" \
	"move	$11, $28;" \
	"bne	$28, $9, 1f;" \
	"li	$10, 28;" \
	"lw	$9, 64($8);" \
	"move	$11, $29;" \
	"bne	$29, $9, 1f;" \
	"li	$10, 29;" \
	"lw	$9, 68($8);" \
	"move	$11, $30;" \
	"bne	$30, $9, 1f;" \
	"li	$10, 30;" \
	"lw	$9, 72($8);" \
	"move	$11, $31;" \
	"bne	$31, $9, 1f;" \
	"li	$10, 31;" \
	"lui	$8,%hi(SAVE_STACK_HERE);" \
	"addiu	$8,$8,%lo(SAVE_STACK_HERE);" \
	"addiu	$9,$29,-512;" \
	"addiu	$10,$29,512;" \
    "0:" \
	"lw	$11,0($9);" \
	"lw	$12,0($8);" \
	"beq	$11,$12,2f;" \
	"nop;" \
	"move	$4, $8;" \
	"jal	CHECK_STACK_FAIL;" \
	"move	$5, $9;" \
    "4:" \
	"lui	$8, %hi(SAVE_ALL_REGS_HERE);" \
	"addiu	$8, $8, %lo(SAVE_ALL_REGS_HERE);" \
	"lw	$7, 20($8);" \
	"lw	$2, 0($8);" \
	"lw	$31, 72($8);" \
	"lw	$3, 4($8);" \
	"b	3f;" \
	"nop;" \
    "1:	" \
	"jal CHECK_ALL_REGS_FAIL;" \
	"nop;" \
	"b	4b;" \
	"nop;" \
    "2:" \
	"addiu	$9,$9,4;" \
	"bne	$9,$10,0b;" \
	"addiu	$8,$8,4;" \
    "3:" \
	".set	at;"
#else
#define	SAVE_ALL_REGS
#define	CHECK_ALL_REGS
#endif

/* COMMENTS ABOUT PRINTING ERROR MESSAGE */
/* FOR STACK_FAILING, need to save v0, v1, a3, ra. */
/* Then can call printing routine. */
/* Then restore these registers. */
/* $31 (ra) is already saved, as is $3 (v1) */
/* $7 (a3) saved and $2 (v0) saved in CHECK_ALL_REGS start. */
#define _syscall0(type,name) 		\
__asm__(				\
	".globl " #name ";"		\
	".ent " #name ", 0;"		\
#name ": ;"				\
	".frame $29, 0, $31;"		\
	".set push;"			\
	".set noreorder;"		\
	PROFSTRING 			\
	SAVE_ALL_REGS			\
	"li	$2, " _stringify0_(__NR_##name) ";"	\
	"syscall;"			\
	CHECK_ALL_REGS			\
	".set reorder;"			\
	"j       __uClibc_syscall;"	\
	".set pop;"			\
	".end	" #name ";"		\
	".size	" #name ",.-" #name ";"	\
	)

#define _syscall1(type,name,atype,a) 	\
	_syscall0(type,name)
#define _syscall2(type,name,atype,a,btype,b) \
	_syscall0(type,name)
#define _syscall3(type,name,atype,a,btype,b,ctype,c) \
	_syscall0(type,name)
#define _syscall4(type,name,atype,a,btype,b,ctype,c,dtype,d) \
	_syscall0(type,name)
#define _syscall5(type,name,atype,a,btype,b,ctype,c,dtype,d,etype,e) \
	_syscall0(type,name)
#define _syscall6(type,name,atype,a,btype,b,ctype,c,dtype,d,etype,e,ftype,f) \
	_syscall0(type,name)
#define _syscall7(type,name,atype,a,btype,b,ctype,c,dtype,d,etype,e,ftype,f,gtype,g) \
	_syscall0(type,name)

#undef weak_alias
#define weak_alias(A,B) \
        __asm__(".weak " #B "; " #B "=" #A );

#endif	/* if __UCLIBC_USE_UNIFIED_SYSCALL__ */

#endif /* __ASSEMBLER__ */
#endif /* _BITS_SYSCALLS_H */
