#include <stdio.h>
#include <stddef.h>
#include <signal.h>
#include <unistd.h>
#include <sys/wait.h>

/* uClinux-2.0 has vfork, but Linux 2.0 doesn't */
#include <sys/syscall.h>
/* #if ! defined __NR_vfork */ // mark by hook 20030812
#define vfork fork	
//#endif

// add by hook 20030812
// for httpd FIN close problem
#include <dirent.h>
#include <sys/wait.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>

void CloseAllfd(void)
{
	DIR *dir;
	struct dirent *next;
	char TmpPath[128];
	int TmpPid;
	int TmpFd=0;
	
	TmpPid = getpid();
	sprintf(TmpPath,"/proc/%d/fd",TmpPid);
	dir = opendir(TmpPath);
				
	while ((next = readdir(dir)) != NULL)
	{
		/* Must skip ".." since that is not a fd */
		if (strcmp(next->d_name, "..") == 0)
			continue;

		/* If it isn't a number, we don't want it */
		if (!isdigit(*next->d_name))
			continue;
		if((TmpFd = atoi(next->d_name)) > 2)
			close(atoi(next->d_name));
	}
}
// end of add by hook 20030812

//change by hook 20030812
int __libc_system(char *command)
{
	int wait_val, pid;
	__sighandler_t save_quit, save_int, save_chld;

	if (command == 0)
		return 1;

	save_quit = signal(SIGQUIT, SIG_IGN);
	save_int = signal(SIGINT, SIG_IGN);
	save_chld = signal(SIGCHLD, SIG_DFL);

	if ((pid = vfork()) < 0) {
		signal(SIGQUIT, save_quit);
		signal(SIGINT, save_int);
		signal(SIGCHLD, save_chld);
		return -1;
	}
	if (pid == 0) {
		CloseAllfd();	// add by hook 20030812
		signal(SIGQUIT, SIG_DFL);
		signal(SIGINT, SIG_DFL);
		signal(SIGCHLD, SIG_DFL);

		execl("/bin/sh", "sh", "-c", command, (char *) 0);
		_exit(127);
	}
	/* Signals are not absolutly guarenteed with vfork */
	signal(SIGQUIT, SIG_IGN);
	signal(SIGINT, SIG_IGN);

#if 0
	printf("Waiting for child %d\n", pid);
#endif

	if (wait4(pid, &wait_val, 0, 0) == -1)
		wait_val = -1;

	signal(SIGQUIT, save_quit);
	signal(SIGINT, save_int);
	signal(SIGCHLD, save_chld);
	return wait_val;
}
weak_alias(__libc_system, system)
