/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

/* #ifndef lint */
/* char copyright[] = */
/* "@(#) Copyright (c) 1983 Regents of the University of California.\n\ */
/*  All rights reserved.\n"; */
/* #endif */ /* not lint */

/* #ifndef lint */
/* static char sccsid[] = "@(#)main.c	5.8 (Berkeley) 10/11/88"; */
/* #endif */ /* not lint */

/* Many bug fixes are from Jim Guyton <guyton@rand-unix> */

/*
 * TFTP User Program -- Command Interface.
 */
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/file.h>

#include <netinet/in.h>

#include <signal.h>
#include <stdio.h>
#include <errno.h>
#include <setjmp.h>
#include <ctype.h>
#include <netdb.h>
#include <string.h>
#include <arpa/inet.h>

#ifndef SOCK_DGRAM
#define SOCK_DGRAM       1
#endif

/*
 * Remap herror to perror for uClinux.
 */
#ifdef EMBED
#undef herror
#define herror perror
#endif

#define	TIMEOUT		5		/* secs between rexmt's */

struct	sockaddr_in t_sin;
int	f;
short   port;
int	trace;
int	verbose;
int	connected;
char	mode[32];
#define LINESIZE 200
char	line[LINESIZE];
int	margc;
char	*margv[20];
char	*prompt = "tftp";
jmp_buf	toplevel;
int	intr();
#ifndef EMBED
struct	servent *sp;
#else
struct	servent t_sp;
struct	servent *sp = &t_sp;
#endif

int	quit(), help(), setverbose(), settrace(), status();
int     get(), put(), setpeer(), modecmd(), setrexmt(), settimeout();
int     setbinary(), setascii();

#define HELPINDENT (sizeof("connect"))

struct cmd {
	char	*name;
	char	*help;
	int	(*handler)();
};

char	vhelp[] = "toggle verbose mode";
char	thelp[] = "toggle packet tracing";
char	chelp[] = "connect to remote tftp";
char	qhelp[] = "exit tftp";
char	hhelp[] = "print help information";
char	shelp[] = "send file";
char	rhelp[] = "receive file";
char	mhelp[] = "set file transfer mode";
char	sthelp[] = "show current status";
char	xhelp[] = "set per-packet retransmission timeout";
char	ihelp[] = "set total retransmission timeout";
char    ashelp[] = "set mode to netascii";
char    bnhelp[] = "set mode to octet";

struct cmd cmdtab[] = {
	{ "connect",	chelp,		setpeer },
	{ "mode",       mhelp,          modecmd },
	{ "put",	shelp,		put },
	{ "get",	rhelp,		get },
	{ "quit",	qhelp,		quit },
	{ "verbose",	vhelp,		setverbose },
	{ "trace",	thelp,		settrace },
	{ "status",	sthelp,		status },
	{ "binary",     bnhelp,         setbinary },
	{ "ascii",      ashelp,         setascii },
	{ "rexmt",	xhelp,		setrexmt },
	{ "timeout",	ihelp,		settimeout },
	{ "?",		hhelp,		help },
	{0,0,0}
};

struct	cmd *getcmd();
char	*tail();
char	*index();
char	*rindex();
void command(int);
void makeargv(void);
int setmode(char *);
void putusage(char *);
void sendfile(int, char *, char *);
void getusage(char *);
void recvfile(int, char *, char *);

/* ------------------------------------------------------------------------ */

int main(argc, argv)
	char *argv[];
{
	struct sockaddr_in Mt_sin;
	int top;

#ifndef EMBED
	sp = getservbyname("tftp", "udp");
#else
	sp->s_port = 69;
#endif
	if (sp == 0) {
		fprintf(stderr, "tftp: udp/tftp: unknown service\n");
		exit(1);
	}
	f = socket(AF_INET, SOCK_DGRAM, 0);
	if (f < 0) {
		perror("tftp: socket");
		exit(3);
	}
	bzero((char *)&Mt_sin, sizeof (Mt_sin));
	Mt_sin.sin_family = AF_INET;
	if (bind(f, (const struct sockaddr *)&Mt_sin, sizeof (Mt_sin)) < 0) {
		perror("tftp: bind");
		exit(1);
	}
	strcpy(mode, "netascii");
	signal(SIGINT, (__sighandler_t)intr);
	if (argc > 1) {
		if (setjmp(toplevel) != 0)
			exit(0);
		setpeer(argc, argv);
	}
	top = setjmp(toplevel) == 0;
	for (;;)
		command(top);
	exit(0);
}

char    hostname[100];

int setpeer(argc, argv)
	int argc;
	char *argv[];
{
	struct hostent *host;
	int i;

	if (argc < 2) {
		strcpy(line, "Connect ");
		printf("(to) ");
		fflush(stdout);
		fgets(&line[strlen(line)], LINESIZE-strlen(line), stdin);
		i = strlen(line);
		if (i > 0 && line[i-1] == '\n') {
			line[i-1] = '\0';
		}
		makeargv();
		argc = margc;
		argv = margv;
	}
	if (argc > 3) {
		printf("usage: %s host-name [port]\n", argv[0]);
		fflush(stdout);
		return 0;
	}
	host = gethostbyname(argv[1]);
	if (host) {
		t_sin.sin_family = host->h_addrtype;
		bcopy(host->h_addr, &t_sin.sin_addr, host->h_length);
		strcpy(hostname, host->h_name);
	} else {
		t_sin.sin_family = AF_INET;
		t_sin.sin_addr.s_addr = inet_addr(argv[1]);
		if (t_sin.sin_addr.s_addr == -1) {
			connected = 0;
			printf("%s: unknown host\n", argv[1]);
			fflush(stdout);
			return 0;
		}
		strcpy(hostname, argv[1]);
	}
	port = sp->s_port;
	if (argc == 3) {
		port = atoi(argv[2]);
		if (port < 0) {
			printf("%s: bad port number\n", argv[2]);
			fflush(stdout);
			connected = 0;
			return 0;
		}
		port = htons(port);
	}
	connected = 1;
	return 0;
}

struct	modes {
	char *m_name;
	char *m_mode;
} modes[] = {
	{ "ascii",	"netascii" },
	{ "netascii",   "netascii" },
	{ "binary",     "octet" },
	{ "image",      "octet" },
	{ "octet",     "octet" },
/*      { "mail",       "mail" },       */
	{ 0,		0 }
};

int modecmd(argc, argv)
	char *argv[];
{
	register struct modes *p;
	char *sep;

	if (argc < 2) {
		printf("Using %s mode to transfer files.\n", mode);
		fflush(stdout);
		return 0;
	}
	if (argc == 2) {
		for (p = modes; p->m_name; p++)
			if (strcmp(argv[1], p->m_name) == 0)
				break;
		if (p->m_name) {
			setmode(p->m_mode);
			return 0;
		}
		printf("%s: unknown mode\n", argv[1]);
		fflush(stdout);
		/* drop through and print usage message */
	}

	printf("usage: %s [", argv[0]);
	sep = " ";
	for (p = modes; p->m_name; p++) {
		printf("%s%s", sep, p->m_name);
		if (*sep == ' ')
			sep = " | ";
	}
	printf(" ]\n");
	fflush(stdout);
	return 0;
}

int setbinary(argc, argv)
char *argv[];
{       setmode("octet");
	return(0);
}

int setascii(argc, argv)
char *argv[];
{       setmode("netascii");
	return(0);
}

int setmode(newmode)
char *newmode;
{
	strcpy(mode, newmode);
	if (verbose)
		printf("mode set to %s\n", mode);
	return(0);
}


/*
 * Send file(s).
 */
int put(argc, argv)
	char *argv[];
{
	int fd;
	register int n;
	register char *cp, *targ;
	int i;

	if (argc < 2) {
		strcpy(line, "send ");
		printf("(file) ");
		fflush(stdout);
		fgets(&line[strlen(line)], LINESIZE-strlen(line), stdin);
		i = strlen(line);
		if (i > 0 && line[i-1] == '\n') {
			line[i-1] = '\0';
		}
		makeargv();
		argc = margc;
		argv = margv;
	}
	if (argc < 2) {
		putusage(argv[0]);
		return 0;
	}
	targ = argv[argc - 1];
	if (index(argv[argc - 1], ':')) {
		char *Pcp;
		struct hostent *hp;

		for (n = 1; n < argc - 1; n++)
			if (index(argv[n], ':')) {
				putusage(argv[0]);
				return 0;
			}
		Pcp = argv[argc - 1];
		targ = index(Pcp, ':');
		*targ++ = 0;
		hp = gethostbyname(Pcp);
		if (hp == NULL) {
			fprintf(stderr, "tftp: %s: ", Pcp);
			fflush(stderr);
			herror((char *)NULL);
			return 0;
		}
		bcopy(hp->h_addr, (caddr_t)&t_sin.sin_addr, hp->h_length);
		t_sin.sin_family = hp->h_addrtype;
		connected = 1;
		strcpy(hostname, hp->h_name);
	}
	if (!connected) {
		printf("No target machine specified.\n");
		fflush(stdout);
		return 0;
	}
	if (argc < 4) {
		cp = argc == 2 ? tail(targ) : argv[1];
		fd = open(cp, O_RDONLY);
		if (fd < 0) {
			fprintf(stderr, "tftp: "); perror(cp);
			fflush(stderr);
			return 0;
		}
		if (verbose) {
			printf("putting %s to %s:%s [%s]\n",
				cp, hostname, targ, mode);
			fflush(stdout);
		}
		t_sin.sin_port = port;
		sendfile(fd, targ, mode);
		return 0;
	}
				/* this assumes the target is a directory */
				/* on a remote unix system.  hmmmm.  */
	cp = index(targ, '\0'); 
	*cp++ = '/';
	for (n = 1; n < argc - 1; n++) {
		strcpy(cp, tail(argv[n]));
		fd = open(argv[n], O_RDONLY);
		if (fd < 0) {
			fprintf(stderr, "tftp: "); perror(argv[n]);
			fflush(stderr);
			continue;
		}
		if (verbose) {
			printf("putting %s to %s:%s [%s]\n",
				argv[n], hostname, targ, mode);
			fflush(stdout);
		}
		t_sin.sin_port = port;
		sendfile(fd, targ, mode);
	}
	return 0;
}

void putusage(s)
	char *s;
{
	printf("usage: %s file ... host:target, or\n", s);
	printf("       %s file ... target (when already connected)\n", s);
	fflush(stdout);
}

/*
 * Receive file(s).
 */
int get(argc, argv)
	char *argv[];
{
	int fd;
	register int n;
	register char *cp;
	char *src;
	int i;

	if (argc < 2) {
		strcpy(line, "get ");
		printf("(files) ");
		fflush(stdout);
		fgets(&line[strlen(line)], LINESIZE-strlen(line), stdin);
		i = strlen(line);
		if (i > 0 && line[i-1] == '\n') {
			line[i-1] = '\0';
		}
		makeargv();
		argc = margc;
		argv = margv;
	}
	if (argc < 2) {
		getusage(argv[0]);
		return 0;
	}
	if (!connected) {
		for (n = 1; n < argc ; n++)
			if (index(argv[n], ':') == 0) {
				getusage(argv[0]);
				return 0;
			}
	}
	for (n = 1; n < argc ; n++) {
		src = index(argv[n], ':');
		if (src == NULL)
			src = argv[n];
		else {
			struct hostent *hp;

			*src++ = 0;
			hp = gethostbyname(argv[n]);
			if (hp == NULL) {
				fprintf(stderr, "tftp: %s: ", argv[n]);
				fflush(stderr);
				herror((char *)NULL);
				continue;
			}
			bcopy(hp->h_addr, (caddr_t)&t_sin.sin_addr, hp->h_length);
			t_sin.sin_family = hp->h_addrtype;
			connected = 1;
			strcpy(hostname, hp->h_name);
		}
		if (argc < 4) {
			cp = argc == 3 ? argv[2] : tail(src);
			fd = creat(cp, 0644);
			if (fd < 0) {
				fprintf(stderr, "tftp: "); perror(cp);
				fflush(stderr);
				return 0;
			}
			if (verbose) {
				printf("getting from %s:%s to %s [%s]\n",
					hostname, src, cp, mode);
				fflush(stdout);
			}
			t_sin.sin_port = port;
			recvfile(fd, src, mode);
			break;
		}
		cp = tail(src);         /* new .. jdg */
		fd = creat(cp, 0644);
		if (fd < 0) {
			fprintf(stderr, "tftp: "); perror(cp);
			fflush(stderr);
			continue;
		}
		if (verbose) {
			printf("getting from %s:%s to %s [%s]\n",
				hostname, src, cp, mode);
			fflush(stdout);
		}
		t_sin.sin_port = port;
		recvfile(fd, src, mode);
	}
	return 0;
}

void getusage(s)
char * s;
{
	printf("usage: %s host:file host:file ... file, or\n", s);
	printf("       %s file file ... file if connected\n", s);
	fflush(stdout);
}

int	rexmtval = TIMEOUT;

int setrexmt(argc, argv)
	char *argv[];
{
	int t;
	int i;

	if (argc < 2) {
		strcpy(line, "Rexmt-timeout ");
		printf("(value) ");
		fflush(stdout);
		fgets(&line[strlen(line)], LINESIZE-strlen(line), stdin);
		i = strlen(line);
		if (i > 0 && line[i-1] == '\n') {
			line[i-1] = '\0';
		}
		makeargv();
		argc = margc;
		argv = margv;
	}
	if (argc != 2) {
		printf("usage: %s value\n", argv[0]);
		fflush(stdout);
		return 0;
	}
	t = atoi(argv[1]);
	if (t < 0) {
		printf("%s: bad value\n", argv[0]);
		fflush(stdout);
	} else
		rexmtval = t;
	return 0;
}

int	maxtimeout = 5 * TIMEOUT;

int settimeout(argc, argv)
	char *argv[];
{
	int t;
	int i;

	if (argc < 2) {
		strcpy(line, "Maximum-timeout ");
		printf("(value) ");
		fflush(stdout);
		fgets(&line[strlen(line)], LINESIZE-strlen(line), stdin);
		i = strlen(line);
		if (i > 0 && line[i-1] == '\n') {
			line[i-1] = '\0';
		}
		makeargv();
		argc = margc;
		argv = margv;
	}
	if (argc != 2) {
		printf("usage: %s value\n", argv[0]);
		fflush(stdout);
		return 0;
	}
	t = atoi(argv[1]);
	if (t < 0) {
		printf("%s: bad value\n", argv[0]);
		fflush(stdout);
	} else
		maxtimeout = t;
	return 0;
}

int status(argc, argv)
	char *argv[];
{
	if (connected)
		printf("Connected to %s.\n", hostname);
	else
		printf("Not connected.\n");
	printf("Mode: %s Verbose: %s Tracing: %s\n", mode,
		verbose ? "on" : "off", trace ? "on" : "off");
	printf("Rexmt-interval: %d seconds, Max-timeout: %d seconds\n",
		rexmtval, maxtimeout);
	fflush(stdout);
	return 0;
}

int intr()
{
	signal(SIGALRM, SIG_IGN);
	alarm(0);
	longjmp(toplevel, -1);
}

char *
tail(filename)
	char *filename;
{
	register char *s;
	
	while (*filename) {
		s = rindex(filename, '/');
		if (s == NULL)
			break;
		if (s[1])
			return (s + 1);
		*s = '\0';
	}
	return (filename);
}

/*
 * Command parser.
 */
void command(top)
	int top;
{
	register struct cmd *c;
	int i;

	if (!top)
		putchar('\n');
	for (;;) {
		printf("%s> ", prompt);
		fflush(stdout);
		if (fgets(line,LINESIZE,stdin) == 0) {
			if (feof(stdin)) {
				quit();
			} else {
				continue;
			}
		}
		i = strlen(line);
		if (i > 0 && line[i-1] == '\n') {
			line[i-1] = '\0';
		}
		if (line[0] == 0)
			continue;
		makeargv();
		c = getcmd(margv[0]);
		if (c == (struct cmd *)-1) {
			printf("?Ambiguous command\n");
			fflush(stdout);
			continue;
		}
		if (c == 0) {
			printf("?Invalid command\n");
			fflush(stdout);
			continue;
		}
		(*c->handler)(margc, margv);
	}
}

struct cmd *
getcmd(name)
	register char *name;
{
	register char *p, *q;
	register struct cmd *c, *found;
	register int nmatches, longest;

	longest = 0;
	nmatches = 0;
	found = 0;
	for (c = cmdtab; (p = c->name) != NULL; c++) {
		for (q = name; *q == *p++; q++)
			if (*q == 0)		/* exact match? */
				return (c);
		if (!*q) {			/* the name was a prefix */
			if (q - name > longest) {
				longest = q - name;
				nmatches = 1;
				found = c;
			} else if (q - name == longest)
				nmatches++;
		}
	}
	if (nmatches > 1)
		return ((struct cmd *)-1);
	return (found);
}

/*
 * Slice a string up into argc/argv.
 */
void makeargv()
{
	register char *cp;
	register char **argp = margv;

	margc = 0;
	for (cp = line; *cp;) {
		while (isspace(*cp))
			cp++;
		if (*cp == '\0')
			break;
		*argp++ = cp;
		margc += 1;
		while (*cp != '\0' && !isspace(*cp))
			cp++;
		if (*cp == '\0')
			break;
		*cp++ = '\0';
	}
	*argp++ = 0;
}

/*VARARGS*/
int quit()
{
	exit(0);
}

/*
 * Help command.
 */
int help(argc, argv)
	int argc;
	char *argv[];
{
	register struct cmd *c;

	if (argc == 1) {
		printf("Commands may be abbreviated.  Commands are:\n\n");
		for (c = cmdtab; c->name; c++)
			printf("%-*s\t%s\n", HELPINDENT, c->name, c->help);
		fflush(stdout);
		return 0;
	}
	while (--argc > 0) {
		register char *arg;
		arg = *++argv;
		c = getcmd(arg);
		if (c == (struct cmd *)-1)
			printf("?Ambiguous help command %s\n", arg);
		else if (c == (struct cmd *)0)
			printf("?Invalid help command %s\n", arg);
		else
			printf("%s\n", c->help);
		fflush(stdout);
	}
	return 0;
}

/*VARARGS*/
int settrace()
{
	trace = !trace;
	printf("Packet tracing %s.\n", trace ? "on" : "off");
	fflush(stdout);
	return 0;
}

/*VARARGS*/
int setverbose()
{
	verbose = !verbose;
	printf("Verbose mode %s.\n", verbose ? "on" : "off");
	fflush(stdout);
	return 0;
}
