/* shutdown.c:
 *
 * Copyright (C) 1998  Kenneth Albanowski <kjahds@kjahds.com>,
 * Copyright (C) 1999  D. Jeff Dionne     <jeff@rt-control.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <unistd.h>
#include <stdlib.h>
#include <linux/autoconf.h>

#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>

#include <sys/stat.h>
#include <dirent.h>
#include <pwd.h>
#include <grp.h>
#include <time.h>
#include <signal.h>
#include <sys/reboot.h>

int
main(argc, argv)
	int argc;
	char	**argv;
{
	if ((argc != 3) || (strcmp(argv[1], "-h") && strcmp(argv[1], "-r")) || strcmp(argv[2], "now")) {
		printf("Usage: %s -h|-r now\n", argv[0]);
		exit(0);
	}

	kill(1, SIGTSTP);
	sync();
	signal(SIGTERM,SIG_IGN);
	setpgrp();
	kill(-1, SIGTERM);
	sleep(1);
	kill(-1, SIGHUP); /* Force PPPD's down, too */
	sleep(1);
	kill(-1, SIGKILL);
	sync();
	sleep(1);

	if (strcmp(argv[1], "-h")==0)
		reboot(0xCDEF0123);
	else
		reboot(0x01234567);

	exit(0); /* Shrug */
}

