/*
 * Copyright (c) 1993 by David I. Bell
 * Permission is granted to use, distribute, or modify this source,
 * provided that this copyright notice remains intact.
 *
 * Definitions for stand-alone shell for system maintainance for Linux.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <ctype.h>
/*#include "config.h"*/

#define	PATHLEN		256	
#define	CMDLEN		256 /* 512 */
#define	MAXARGS		50	
#define	ALIASALLOC	20
#define	STDIN		0
#define	STDOUT		1
#define	MAXSOURCE	10

#ifndef	isblank
#define	isblank(ch)	(((ch) == ' ') || ((ch) == '\t'))
#endif

#define	isquote(ch)	(((ch) == '"') || ((ch) == '\''))
#define	isdecimal(ch)	(((ch) >= '0') && ((ch) <= '9'))
#define	isoctal(ch)	(((ch) >= '0') && ((ch) <= '7'))


typedef	int	BOOL;

#define	FALSE	((BOOL) 0)
#define	TRUE	((BOOL) 1)

extern	void	do_cd();
extern	void	do_echo();
extern	void	do_exec();
extern	void	do_exit();
extern	void	do_hexdump();
extern	void	do_pid();
extern	void	do_setenv();
extern	void	do_sleep();
extern	void	do_source();
extern	void	do_umask();

extern	char	*buildname();
extern	char	*modestring();
extern	char	*timestring();
extern	BOOL	isadir();
extern	BOOL	copyfile();
extern	BOOL	match();
extern	BOOL	makestring();
extern	BOOL	makeargs();
extern	int	expandwildcards();
extern	int	namesort();
extern	char	*getchunk();
extern	void	freechunks();
extern	char	*expandenvvar();

extern	BOOL	intflag;

/* END CODE */
