/*
 * Modifications for uClinux
 * Copyright (C) 1998  Kenneth Albanowski <kjahds@kjahds.com>
 *
 * Original code
 * Copyright (c) 1993 by David I. Bell
 * Permission is granted to use, distribute, or modify this source,
 * provided that this copyright notice remains intact.
 *
 * Most simple built-in commands are here.
 */

#include "sash.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <pwd.h>
#include <grp.h>
#include <utime.h>
#include <errno.h>


void
do_echo(argc, argv)
	char	**argv;
{
	BOOL	first;

	first = TRUE;
	while (argc-- > 1) {
		if (!first)
			fputc(' ', stdout);
		first = FALSE;
		fputs(*++argv, stdout);
	}
	fputc('\n', stdout);
	fflush(stdout);
}


void
do_cd(argc, argv)
	char	**argv;
{
	char	*path;

	if (argc > 1)
		path = argv[1];
	else {
		path = getenv("HOME");
		if (path == NULL) {
			fprintf(stderr, "No HOME environment variable\n");
			fflush(stderr);
			return;
		}
	}

	if (chdir(path) < 0)
		perror(path);
}


void
do_sleep(argc, argv) 
	char	**argv;
{
	if (argc > 1)
		sleep(atoi(argv[1]));
}


void
do_exit(argc, argv)
	char	**argv;
{
	exit(0);
}


void
do_setenv(argc, argv)
	char	**argv;
{
	setenv(argv[1], argv[2], 1);
}


void
do_umask(argc, argv)
	char	**argv;
{
	char	*cp;
	int	mask;

	if (argc <= 1) {
		mask = umask(0);
		umask(mask);
		printf("%03o\n", mask);
		fflush(stdout);
		return;
	}

	mask = 0;
	cp = argv[1];
	while (isoctal(*cp))
		mask = mask * 8 + *cp++ - '0';

	if (*cp || (mask & ~0777)) {
		fprintf(stderr, "Bad umask value\n");
		fflush(stderr);
		return;
	}

	umask(mask);
}

/* END CODE */
