#ifndef IEEE802_1X_H
#define IEEE802_1X_H

/* IEEE Std 802.1X-2001, 7.2 */
struct ieee802_1x_hdr {
	u8 version;
	u8 type;
	u16 length;
	/* followed by length octets of data */
} __attribute__ ((packed));

#define LENGTH_8021X_HDR        4

#define EAPOL_VERSION   1
#define LENGTH_802_1_H			8

enum { IEEE802_1X_TYPE_EAP_PACKET = 0,
       IEEE802_1X_TYPE_EAPOL_START = 1,
       IEEE802_1X_TYPE_EAPOL_LOGOFF = 2,
       IEEE802_1X_TYPE_EAPOL_KEY = 3,
       IEEE802_1X_TYPE_EAPOL_ENCAPSULATED_ASF_ALERT = 4
};

enum { EAPOL_KEY_TYPE_RC4 = 1 };


/* RFC 2284 - PPP Extensible Authentication Protocol (EAP) */

struct eap_hdr {
	u8 code;
	u8 identifier;
	u16 length; /* including code and identifier */
	/* followed by length-2 octets of data */
} __attribute__ ((packed));

#define LENGTH_EAP_HDR        4

enum { EAP_CODE_REQUEST = 1, EAP_CODE_RESPONSE = 2, EAP_CODE_SUCCESS = 3,
       EAP_CODE_FAILURE = 4 };

/* EAP Request and Response data begins with one octet Type. Success and
 * Failure do not have additional data. */

/* RFC 2284, 3.0 */
enum { EAP_TYPE_IDENTITY = 1,
       EAP_TYPE_NOTIFICATION = 2,
       EAP_TYPE_NAK = 3 /* Response only */,
       EAP_TYPE_MD5_CHALLENGE = 4,
       EAP_TYPE_ONE_TIME_PASSWORD = 5 /* RFC 1938 */,
       EAP_TYPE_GENERIC_TOKEN_CARD = 6,
       EAP_TYPE_TLS = 13 /* RFC 2716 */,
       EAP_TYPE_TTLS = 21 /* draft-ietf-pppext-eap-ttls-02.txt */,
       EAP_TYPE_PEAP = 25 /* draft-josefsson-pppext-eap-tls-eap-06.txt */,
};

// Key mapping keys require a BSSID
typedef struct _PMK_KEY
{
    u32           Length;             // Length of this structure
    u32           KeyIndex;           
    u32           KeyLength;          // length of key in bytes
    u8          BSSID[8];
    u8          KeyRSC[8];
    u8           KeyMaterial[32];     // variable length depending on above field
} PMK_KEY, *PPMK_KEY;



void ieee802_1x_receive(rtapd *apd, u8 *sa, u8 *buf, size_t len);
void ieee802_1x_new_station(rtapd *apd, struct sta_info *sta);
void ieee802_1x_free_station(struct sta_info *sta);

void ieee802_1x_request_identity(rtapd *apd, struct sta_info *sta, u8 id);
void ieee802_1x_tx_canned_eap(rtapd *apd, struct sta_info *sta, u8 id,
			      int success);
void ieee802_1x_tx_req(rtapd *apd, struct sta_info *sta, u8 id);
void ieee802_1x_send_resp_to_server(rtapd *apd, struct sta_info *sta);
void ieee802_1x_set_sta_authorized(int authorized);
int ieee802_1x_init(rtapd *apd);
void ieee802_1x_new_auth_session(rtapd *apd, struct sta_info *sta);


#endif /* IEEE802_1X_H */
