#include "iwlib.h"
#include "wireless.h"
#include <stdio.h>

int
main(int	argc,
     char **	argv)
{
  int skfd;		/* generic raw socket desc.	*/
  char wdslink[24];
  char buffer[24];
  char link_no[24];
  char c_temp1[28];
  int goterr = 0;
  struct iwreq 	wrq;
  FILE 			*fp;

  /* Create a channel to the NET kernel. */
  if((skfd = iw_sockets_open()) < 0)
    {
      printf("socket open error");
      exit(-1);
    }

	#ifdef FOR_DEBUG
		printf("wds: 1. skfd = %d \r\n",skfd);
	#endif

  /* No argument : show the list of all device + info */
  if(argc < 5)
  {
    printf("Useage : wdslink <device> <wdslinkadd|wdslinkdel> <MAC address> <link no>\n");
    	return 0;
  }

    /* Set device name */
    strcpy((char *)wrq.ifr_name, argv[1]);
    #if 1
		printf("wds: 2. interface name = %s \r\n",(char *)wrq.ifr_name );
	#endif

	/* Set wdslink add or wdslink del */
	strcpy(wdslink,argv[2]);
	#if 1
		printf("wds:    wdslink command = %s \r\n", wdslink);
	#endif
	
    /* set Cmd and arg */
    wrq.u.data.pointer = (caddr_t)buffer;
    memset(buffer, 0x00, sizeof(buffer));
	strcpy(buffer,argv[3]);
	#if 1
		printf("wds:    MAC address =%s \r\n",buffer);
	#endif
		
	sprintf(link_no,"/var/config/wds_%s",argv[4]);
	
	/* print the parameter */
	#if 1
		printf("wds:    file link no =%s \r\n",link_no);
	#endif


	
	if ( strcmp(wdslink,"wdslinkadd") == 0 )
	{
		#ifdef FOR_DEBUG
			printf("wds: 3. enter wdslinkadd process \r\n");
		#endif
    	/* Do the request */
		
		#if 1
		    strcpy(buffer,"test string");
			printf("wds: 4 before: skfd=%d, magic number: %x, wrq.u.data.pointer: %s \r\n",
				skfd, SIOCIWFIRSTPRIV + 0x10, wrq.u.data.pointer);
			sleep(1);
		#endif
    	goterr = ioctl(skfd, SIOCIWFIRSTPRIV + 0x10, &wrq);
    	#if 1
    		printf("wds: 4. goterr = %d \n",goterr);
    		sleep(5);
    	#endif
    	
    	if( goterr == 0 )
    	{
    		if ( (fp = fopen(link_no,"w")) != NULL )
    		{
    			//fprintf(fp,"%s\n",buffer);
    			fclose(fp);
    			#if 1
    				printf("wds: 5. write interface to file: %s \r\n",link_no);
    			#endif
    		}
    		
    	}
    	sleep(2);
    	
    }
    
   
    if ( strcmp(wdslink,"wdslinkdel") == 0 )
	{
		printf("wdslink: enter wdslinkdel process \n");
    	/* Do the request */
    	goterr = ioctl(skfd, SIOCIWFIRSTPRIV + 0x11, &wrq);
    	
		if ( (fp = fopen(link_no,"r")) != NULL )
		{
			fclose(fp);
			sprintf(c_temp1,"rm -f %s",link_no);
			system(c_temp1);
			//printf("wdslink: %s \n",c_temp1);
		}
    	
    }
    

  
  /* Close the socket. */
  close(skfd);
  if(goterr < 0)
  {
  	printf("Error : %s\n",strerror(errno));
  }
/*  else if(wrq.u.data.flags == 0)
  	printf("Result = 0x%lx\n",(long)wrq.u.data.pointer);
*/
  return(goterr);
}
