# FreeS/WAN pathnames and other master configuration
# Copyright (C) 2001, 2002  Henry Spencer.
# 
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2 of the License, or (at your
# option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
# 
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# RCSID $Id: Makefile.inc,v 1.6 2003/04/28 21:00:41 swahl Exp $



# Variables in this file with names starting with INC_ are not for use
# by Makefiles which include it; they are subject to change without warning.
#
# "Final" and "finally" refer to where the files will end up on the
# running IPsec system, as opposed to where they get installed by our
# Makefiles.  (The two are different for cross-compiles and the like,
# where our Makefiles are not the end of the installation process.)
# Paths with FINAL in their names are the only ones that the installed
# software itself depends on.  (Very few things should know about the
# FINAL paths; think twice and consult Henry before making something new
# depend on them.)  All other paths are install targets.
# See also DESTDIR, below.



### boilerplate, do not change
SHELL=/bin/sh



### install pathnames

# DESTDIR can be used to supply a prefix to all install targets.
# (Note that "final" pathnames, signifying where files will eventually
# reside rather than where install puts them, are exempt from this.)
# The prefixing is done in this file, so as to have central control over
# it; DESTDIR itself should never appear in any other Makefile.
CWD :=$(shell /bin/pwd)
DESTDIR=${CWD}/../freeswan_root

# "local" part of tree, used in building other pathnames
INC_USRLOCAL=/

# PUBDIR is where the "ipsec" command goes; beware, many things define PATH
# settings which are assumed to include it (or at least, to include *some*
# copy of the "ipsec" command).

#changed by hook 20030710 - sbin -> bin
#PUBDIR=$(DESTDIR)$(INC_USRLOCAL)/sbin
PUBDIR=$(DESTDIR)$(INC_USRLOCAL)/bin

# BINDIR is where commands get put, FINALBINDIR is where the "ipsec"
# command will look for them when it is run.
FINALBINDIR=$(INC_USRLOCAL)/lib/ipsec
BINDIR=$(DESTDIR)$(FINALBINDIR)

# where the appropriate manpage tree is located
# location within INC_USRLOCAL
INC_MANDIR=man
# the full pathname
MANTREE=$(DESTDIR)$(INC_USRLOCAL)/$(INC_MANDIR)
# all relevant subdirectories of MANTREE
MANPLACES=man3 man5 man8

# where configuration files go
FINALCONFDIR=/etc
CONFDIR=$(DESTDIR)$(FINALCONFDIR)

# An attempt is made to automatically figure out where boot/shutdown scripts 
# will finally go:  the first directory in INC_RCDIRS which exists gets them.
# If none of those exists (or INC_RCDIRS is empty), INC_RCDEFAULT gets them.
# With a non-null DESTDIR, INC_RCDEFAULT will be used unless one of the
# INC_RCDIRS directories has been pre-created under DESTDIR.
INC_RCDIRS=/etc/rc.d/init.d /etc/rc.d /etc/init.d /sbin/init.d
INC_RCDEFAULT=/etc/rc.d/init.d

# RCDIR is where boot/shutdown scripts go; FINALRCDIR is where they think
# will finally be (so utils/Makefile can create a symlink in BINDIR to the
# place where the boot/shutdown script will finally be, rather than the
# place where it is installed).
FINALRCDIR=$(shell for d in $(INC_RCDIRS) ; \
		do if test -d $(DESTDIR)/$$d ; \
		then echo $$d ; exit 0 ; \
		fi ; done ; echo $(INC_RCDEFAULT) )
RCDIR=$(DESTDIR)$(FINALRCDIR)



### kernel pathnames

# Kernel location:  where patches are inserted, where kernel builds are done.
KERNELSRC=$(CWD)/../uClinux-freeswan/linux

# things whose existence indicates what kernel version we have
DIRIN22=$(KERNELSRC)/net/netlink
FILIN24=$(KERNELSRC)/net/khttpd/main.c

# where kernel configuration outputs are located
KCFILE=$(KERNELSRC)/.config
ACFILE=$(KERNELSRC)/include/linux/autoconf.h
VERFILE=$(KERNELSRC)/include/linux/version.h



### misc installation stuff

# what program to use when installing things
INSTALL=install -c


# flags to the install program, for programs, manpages, and config files
# -b has install make backups (n.b., unlinks original), --suffix controls
# how backup names are composed.
# Note that the install procedures will never overwrite an existing config
# file, which is why -b is not specified for them.
INSTBINFLAGS=
INSTMANFLAGS=
INSTCONFFLAGS=



### misc configuration, included here in hopes that other files will not
### have to be changed for common customizations.

# extra compile flags, for userland and kernel stuff, e.g. -g for debug info
# (caution, this stuff is still being sorted out, will change in future)
USERCOMPILE=-g -O3 -DSINGLE_DES
KLIPSCOMPILE=-O3 -DSINGLE_DES

# command used to link/copy KLIPS into kernel source tree
# There are good reasons why this is "ln -s"; only people like distribution
# builders should ever change it.
KLIPSLINK=ln -s

# extra options for use in kernel build
KERNMAKEOPTS=

# kernel Makefile targets to be done before build
# Can be overridden if you are *sure* your kernel doesn't need them.  (2.2.xx
# and later reportedly do not.)
KERNDEP=dep
KERNCLEAN=clean

# kernel make name:  zImage for 2.0.xx, bzImage for 2.2.xx and later, and
# boot on non-x86s (what ever happened to standards?)
#INC_B=$(shell test -d $(DIRIN22) && echo b)
#KERNEL=$(shell if expr " `uname -m`" : ' i.86' >/dev/null ; \
#	then echo $(INC_B)zImage ; \
#	else echo boot ; \
#	fi)
KERNEL=image.bin
ARCH=mipsnommu

# temporary directory to be used when building RPMs, and where to put the
# resulting RPM tree
RPMKERNDIR := $(shell echo `pwd`/tmp.rpmkernel)
RPMTMPDIR := $(shell echo `pwd`/tmp.rpmbuild)
RPMDEST := $(shell echo `pwd`/rpms)

# Newer versions of RPM do not permit building of packages with the "rpm" 
# command. For RedHat systems with older version of RPM, use:
# RPMBUILD=rpm
# instead.
RPMBUILD=rpmbuild

# Set this to a RedHat kernel-sources RPM. This normally extracts into
# /usr/src/linux-2.4, but you might have extracted it elsewhere with
# rpm2cpio.
#
RH_KERNELSRC=/usr/src/linux-2.4

#RH_KERNELSRC=/a3/kernel_sources/linux-2.4.2
#RH_KERNELSRC=/a3/kernel_sources/linux-2.4.9-13
#RH_KERNELSRC=/c2/kernel/rh/linux-2.4.9-13

# the following is a list of symbols which will be used to construct
# the module goo to identify which module goes with each kernel.
MODULE_GOO_LIST=irq_stat netif_rx register_sysctl_table send_sig
MODULE_GOO_LIST+=kmalloc __kfree_skb __ip_select_ident alloc_skb
MODULE_GOO_LIST+=icmp_send ip_fragment sock_register 


