#define HSUJP
#define NEW_WAIT

/*
 * dhcpcd - DHCP client daemon -
 * Copyright (C) 1996 - 1997 Yoichi Hariguchi <yoichi@fore.com>
 * Copyright (C) January, 1998 Sergei Viznyuk <sv@phystech.com>
 * 
 * dhcpcd is an RFC2131 and RFC1541 compliant DHCP client daemon.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <unistd.h>
#include <fcntl.h>
#include <net/if.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "dhcpcd.h"
#include "client.h"
#include "signals.h"

#ifdef HSUJP
#include "dialondemand.h"
#include "../amit_include/amit.h"
#endif

#ifdef HSUJP
//extern void my_LOG(char *);
#endif

struct in_addr  inform_ipaddr;
char			*ProgramName	=	NULL;
char            **ProgramEnviron=   NULL;
char			*IfName			=	DEFAULT_IFNAME;
int				IfName_len		=	DEFAULT_IFNAME_LEN;
char			*HostName		=	NULL;
int				HostName_len	=	0;
char			*Cfilename		=	NULL;
unsigned char	*ClassID		=	NULL;
int				ClassID_len		=	0;
unsigned char	*ClientID		=	NULL;
int				ClientID_len	=	0;
void			*(*currState)()	=	&dhcpReboot;
int				DebugFlag		=	0;
int				BeRFC1541		=	0;
unsigned		LeaseTime		=	DEFAULT_LEASETIME;
int				ReplResolvConf	=	1;
int				SetDomainName	=	0;
int				SetHostName		=	0;
int             BroadcastResp   =   0;
time_t          TimeOut         =	DEFAULT_TIMEOUT;
int 			magic_cookie    =   0;
unsigned short  dhcpMsgSize     =   0;
unsigned        nleaseTime      =   0;
int				DoCheckSum		=	0;
int				TestCase		=	0;


#ifdef HSUJP

unsigned char   		can_log 		= 0;
unsigned char			display[16], ui_dns1[16], ui_dns2[16];
unsigned char 			ondemand		=   0;
unsigned char			ui_dns			=	0;
unsigned char			M2_On_Off 		= 	0;
unsigned char			is_waiting		=	0;
unsigned char 			monitored_items[120],monitored_items_2[120];

extern dhcpInterface	DhcpIface;

//extern int dialondemand(char *); 

#endif

#ifdef FOR_DEBUG
unsigned char			ever_display_init_state;
#endif



/*****************************************************************************/
void print_version()
{
  	fprintf(stderr,"DHCP Client Daemon v."VERSION"\n\r");
  	fprintf(stderr,"Copyright (C) 1996 - 1997 Yoichi Hariguchi <yoichi@fore.com>\n\r");
  	fprintf(stderr,"Copyright (C) January, 1998 Sergei Viznyuk <sv@phystech.com>\n\r");
  	fprintf(stderr,"------------------------------------------------------------\n\r");

}

/*****************************************************************************/
/********************************  Main Program ******************************/
/*****************************************************************************/

int main(argn,argc,argv)
int argn;
char *argc[],*argv[];
{
  	int 			killFlag	=	0;
  	int 			versionFlag	=	0;
  	int 			s			=	1;
  	int 			k			=	1;
  	int 			i			=	1;
  	#ifdef HSUJP
  	FILE 			*fd;
  	unsigned char 	my_index;
  	#endif
  	
  	// 0. --- entrance
  	#ifdef FOR_DEBUG
		printf("-------------------------------------------------------------------------------\r\n");
		printf("Enter dhcpcd %s %s\r\n",argc[1],argc[2]);
		system("ps");
	#endif
	#ifdef HSUJP
		checkIfAlreadyRunning();
	#endif
	
  	
  	// 0.5 --- pid
 	#ifdef HSUJP
 		#ifdef FOR_DEBUG
 			printf("dhcpcd: Write pid file\r\n");
 		#endif
 		writePidFile(getpid());
 	#endif
 	
 	// 0.7 --- function initialization
 	if((fd = fopen("/var/run/setboot4dhcpcd","r")) != NULL)
	{
		can_log = 1; fclose(fd); remove("/var/run/setboot4dhcpcd");
	}	
 	
 	// 1 --- log
 	#ifdef HSUJP
 		#ifdef FOR_DEBUG
 			printf("dhcpcd: Open log for this module\r\n");
 		#endif
 		openlog("dhcp client", LOG_ODELAY, LOG_DAEMON);
 		#if 0
 	    	if ((fd = fopen("/var/config/monitor","r")) != NULL) {
				fread(monitored_items,120,1,fd); fclose(fd);
			} else {
				memset(monitored_items,0,120); monitored_items[117] = 0x0d; monitored_items[118] = 0x0a;
			}
			#ifdef FOR_DEBUG
				printf("dhcpcd: monitored_items[101]=%x\r\n",monitored_items[101]);
			#endif
			if (monitored_items[101] == 0) {
				can_log = 1;
				Nprintf("dhcp client started\n");
				monitored_items[101] = 1;
				if ((fd = fopen("/var/config/monitor","w")) != NULL) {
					fwrite(monitored_items,120,1,fd); fclose(fd);
				}
			} else can_log = 0;
		#else
			if (can_log)
			{
				Nprintf("dhcp client started\n");
				#ifdef FOR_DEBUG
					printf("dhcpcd: dhcp client started\r\n");
				#endif
			}
			//my_LOG("dhcp client started\n");
		#endif
 	#endif
 	
 	// 2. --- check user id
  	if ( getuid() )
	{
    	fprintf(stderr,"****  %s: not a superuser\n",argc[0]);
      	#ifdef HSUJP
      		deletePidFile();
      	#endif
      	exit(1);
    }

	// 3. --- parameter parsing
	while ( argc[i] )
    	if ( argc[i][0]=='-' )
prgs: 
		switch ( argc[i][s] )
		{
			#ifdef HSUJP
	  		case 'a':
	    		i++; ondemand = 1; break;
	    		
	    	case '1':
	    		i++; 
	    		if (argc[i][0] != '-') 
	    		{
	    			strcpy(ui_dns1,argc[i]);
	    			ui_dns |= 1; i++;
	    		}
	    		break;
	    		
	    	case '2':
	    		i++; 
	    		if (argc[i][0] != '-') 
	    		{
	    			strcpy(ui_dns2,argc[i]);
	    			ui_dns |= 2; i++;
	    		}
	    		break;
	    	#endif
	    	
	  		case 0:
	    		i++; s=1; break;
	    		
	  		case 'k':
	    		s++; killFlag=SIGHUP; goto prgs;
	    		
	  		case 'n':
	    		s++;
	    		killFlag=SIGALRM;
	    		goto prgs;
	  		case 'd':
	    		s++;
	    		DebugFlag=1;
	    		goto prgs;
	  		case 'r':
	    		s++;
	    		BeRFC1541=1;
	    		goto prgs;
	  		case 'D':
	    		s++;
	    		SetDomainName=1;
	    		goto prgs;
	  		case 'H':
	    		s++;
	    		SetHostName=1;
	    		goto prgs;
	  		case 'R':
	    		s++;
	    		ReplResolvConf=0;
	    		goto prgs;
	  		case 'V':
	    		s++;
	    		versionFlag=1;
	    		goto prgs;
	  		case 'c':
	    		i++;
	    		Cfilename=argc[i++];
	    		if ( Cfilename == NULL || Cfilename[0] == '-' ) goto usage;
	    		s=1;
	    		break;
	  		case 'i':
	    		i++;
	    		ClassID=argc[i++];
	    		if ( ClassID == NULL || ClassID[0] == '-' ) goto usage;
	    		s=1;
	    		if ( (ClassID_len=strlen(ClassID)) < CLASS_ID_MAX_LEN+1 ) break;
	    		fprintf(stderr,"****  %s: too long ClassID string: strlen=%d\n",
	    				argc[0],ClassID_len);
	    		goto usage;
	  		case 'I':
	    		i++;
	    		ClientID=argc[i++];
	    		if ( ClientID == NULL || ClientID[0] == '-' ) goto usage;
	    		s=1;
	    		if ( (ClientID_len=strlen(ClientID)) < CLIENT_ID_MAX_LEN ) break;
	    		fprintf(stderr,"****  %s: too long ClientID string: strlen=%d\n",
	    				argc[0],ClientID_len);
	    		goto usage;
	  		case 'h':	//parameter #1: host name
	    		i++;
	    		HostName=argc[i++];
	    		if ( HostName == NULL || HostName[0] == '-' ) goto usage;
	    		s=1;
	    		if ( (HostName_len=strlen(HostName)+1) < HOSTNAME_MAX_LEN ) break;
	    		fprintf(stderr,"****  %s: too long HostName string: strlen=%d\n",
	    				argc[0],HostName_len);
	    		break;
	  		case 't':
	    		i++;
	    		if ( argc[i] ) TimeOut=atol(argc[i++]);	else goto usage;
	    		s=1;
	    		if ( TimeOut > 0 ) break;
	    		goto usage;
	  		case 's':
	    		if ( argc[i][s+1] ) goto usage;
	    		i++;
	    		if ( argc[i] && inet_aton(argc[i],&inform_ipaddr) )	i++;
	    		else memset(&inform_ipaddr,0,sizeof(inform_ipaddr));
	    		currState = &dhcpInform;
	    		s=1;
	    		break;
	  		case 'B':
	    		s++;
	    		BroadcastResp=1;
	    		goto prgs;
	  		case 'C':
	    		s++;
	    		DoCheckSum=1;
	    		goto prgs;
	  		case 'T':
	    		s++;
	    		TestCase=1;
	    		goto prgs;
	  		case 'l':
	    		i++;
	    		if ( argc[i] ) LeaseTime=atol(argc[i++]); else goto usage;
	    		s=1;
	    		if ( LeaseTime > 0 ) break;
          	default:
usage:	    
				print_version();
				fprintf(stderr,"Usage: dhcpcd [-dknrBCDHRT] [-l leasetime] [-h hostname] [-t timeout]\n");
				fprintf(stderr,"[-i vendorClassID] [-I ClientID] [-c filename] [-s [ipaddr]] [interface]\n");
	    		#ifdef HSUJP
	    			deletePidFile(); 
	    		#endif
	    		exit(1);
		}
	else argc[k++]=argc[i++];
	
  	if ( k > 1 )	//parameter#2: listening on which interface (ex:"eth1")
    {
      	if ( (IfName_len=strlen(argc[1])) > IFNAMSIZ ) goto usage; else IfName=argc[1];
    }
    
    #ifdef NEW_WAIT
    // 3.5 wait for traffic	// if this is moved, 3.6 and 3.7 are also
    #ifdef HSUJP
    wait_for_traffic:
    if (ondemand)
	{
		is_waiting = 1;
		#ifdef FOR_DEBUG
  			printf("dhcpcd: Wait for traffic\r\n");
  		#endif
  		if (can_log) Nprintf("Wait for traffic\n");
		if ((fd = fopen("/var/run/wanget.result","w")) != NULL)
		{
			fputs("2 0 0\n",fd); fclose(fd);
			#ifdef FOR_DEBUG
				printf("dhcpcd: WANget result(2)\n");
			#endif
		} else {
			#ifdef FOR_DEBUG
				printf("dhcpcd: WANget result(2): Open write file:/var/run/wanget.result fail!\n");
			#endif
		}
  		//my_LOG("Wait for traffic\n");
  		//while(!dialondemand("eth0"));
		//dialondemand("eth0");
		
		dialondemand("" LANPORTNAME "");
	} else {
		is_waiting = 0;
		if (can_log) Nprintf("Auto-Reconnect is enabled\n");
  		#ifdef FOR_DEBUG
  			printf("dhcpcd: No need to wait for traffic because auto-reconnect is enabled\r\n");
  		#endif
  	}
	#endif
	#endif
	
	// 3.6 Start monitord to monitor dhcpcd
	#ifdef HSUJP
		if((fd = fopen("/var/config/dynamic_monitor","w")) != NULL)
		{
			memset(monitored_items_2,0x00,120);
			monitored_items_2[0]=1; monitored_items_2[1]=1; monitored_items_2[117]=0x0d; monitored_items_2[118]=0x0a;
			fputs(monitored_items_2, fd); fclose(fd);
			#ifdef FOR_DEBUG
				printf("dhcpcd: create dynamic_monitor file for bottom code of ed to write monitor\r\n");
				printf("        1 1 .... \r\n");
			#endif
		}
		if((fd = fopen("/var/config/monitor","r")) != NULL)
		{
			fread(monitored_items, 120, 1, fd); fclose(fd);
			if ((monitored_items[0] != 1) || (monitored_items[1] != 1))
			{
				monitored_items[0] = 1; monitored_items[1] = 1;
				if((fd = fopen("/var/config/monitor","w")) != NULL)
				{
					fwrite(monitored_items, 120, 1, fd); fclose(fd);
					system("echo 77 > /var/run/monitor.fifo&");
		       		#ifdef FOR_DEBUG
		   	    		printf("dhcpcd: monitored items[0,1]=1 and write back; monitor.fifo: 77\r\n");
		       		#endif
		       	} else {
		       		#ifdef FOR_DEBUG
		   	    		printf("dhcpcd: /var/config/monitor is written fail\r\n");
		       		#endif
		       	}
			} else {
				#ifdef FOR_DEBUG
		   	    	printf("dhcpcd: try to set monitor[0-1] = 1, but they both are\r\n");
		       	#endif
			}
		} else {
			#ifdef FOR_DEBUG
				printf("dhcpcd: Open write file:/var/config/monitor fail\r\n");
			#endif
		}
	#endif
	
	// 3.7 note "trying to connect"(99) in wanget.result file
	#ifdef HSUJP
		if ((fd = fopen("/var/run/wanget.result","w")) != NULL)
		{
			fputs("99 0 0\n",fd); fclose(fd);
			#ifdef FOR_DEBUG
				printf("dhcpcd: WANget result(99)\n");
			#endif
		} else {
			#ifdef FOR_DEBUG
				printf("dhcpcd: WANget result(99): Open write file:/var/run/wanget.result fail!\n");
			#endif
		}
	#endif
    
    // 4. initialization
    initialization:
    
  	ProgramName=argc[0];
  	ProgramEnviron=argv;
  	
  	if ( killFlag ) killPid(killFlag);
  	
  	#ifndef HSUJP
  		checkIfAlreadyRunning();	//move to step 0
  	#endif
  	
  	if ( versionFlag ) print_version();
  	
  	#ifndef HSUJP
  		openlog("dhcp client",LOG_CONS,LOG_LOCAL0);
  	#endif
  	
  	signalSetup();
  	magic_cookie = htonl(MAGIC_COOKIE);
  	dhcpMsgSize = htons(sizeof(dhcpMessage));
  	nleaseTime = htonl(LeaseTime);
  	alarm(TimeOut);
  	for (my_index=0; my_index<16; my_index++) display[my_index] = 0;
  	#ifdef FOR_DEBUG
  		printf("dhcpcd: LeaseTime = %4x (%d), TimeOut = %d\r\n", 
  				LeaseTime, (int)nleaseTime, (int)TimeOut);
  	#endif
  	
  	// 4.5 wait for traffic
  	#ifndef NEW_WAIT
  	#ifdef HSUJP
  	wait_for_traffic:
  	if (ondemand)
  	{
  		is_waiting = 1;
  		#ifdef FOR_DEBUG
  			printf("dhcpcd: Wait for traffic\r\n");
  		#endif
  		if (dialondemand("" LANPORTNAME "") == 1)	//successfully
  		{
  			if((fd = fopen("/var/config/monitor","r")) != NULL)
			{
				fread(monitored_items, 120, 1, fd); fclose(fd);
				monitored_items[0] = 1; monitored_items[1] = 1;
				if((fd = fopen("/var/config/monitor","w")) != NULL)
				{
					fwrite(monitored_items, 120, 1, fd); fclose(fd);
					system("echo 77 > /var/run/monitor.fifo&");
		        	#ifdef FOR_DEBUG
		      	    	printf("dhcpcd: /var/config/monitor is written and monitor.fifo: 77\r\n");
		        	#endif
				}
			}
  		}
  	} else {
  		is_waiting = 0;
  		#ifdef FOR_DEBUG
  			printf("dhcpcd: No need to wait for traffic because auto-reconnect is enabled\r\n");
  		#endif
  	}
  	#endif
  	#endif
  	
  	// 5. state machine for first time of bound state
  	#ifdef FOR_DEBUG
  		printf("dhcpcd: Enter dhcpcd state machine for first time of bound state\r\n");
  		ever_display_init_state = 0;
  	#endif
  	
  	do {
    	if ( (currState=(void *(*)())currState()) == NULL ) 
    	{
    		#ifdef HSUJP
    			deletePidFile();
    		#endif
    		exit(1);
    	}
    	#ifdef HSUJP
    		if (currState == &dhcpStop)
    		{
    			currState = &dhcpReboot; goto wait_for_traffic;
    		}
    	#endif
  	} while ( currState != &dhcpBound );
  	
  	#ifdef HSUJP
  		unsigned char *cp;
  		cp = (char *)&DhcpIface.ciaddr;
  		Nprintf("WAN interface is bound on %d.%d.%d.%d\n",*(cp),*(cp+1),*(cp+2),*(cp+3));
  	#endif
  	
  	if ( TestCase ) {
  		#ifdef HSUJP
    		deletePidFile();
    	#endif
    	exit(0);
    }
  	
  	alarm(0);
  	
	/* #ifdef DEBUG */
	
	#ifndef HSUJP
  		writePidFile(getpid());		//move to step 1
  	#endif
  	
	/* #else */
	/*   s=fork(); */
	/*   if ( s ) */
	/*     { */
	/*       writePidFile(s); */
	/*       exit(0); */ /* got into bound state. */
	/*     } */
	
  	setsid();
  	
	#if 0
  		if ( (i=open("/dev/null",O_RDWR,0)) >= 0 )
    	{
      		(void)dup2(i,STDIN_FILENO);
      		(void)dup2(i,STDOUT_FILENO);
      		(void)dup2(i,STDERR_FILENO);
      		if ( i > 2 ) (void)close(i);
    	}
	#endif
	
	/* #endif */
	
  	chdir("/");
  	
  	// 6. state machine for routines
  	#ifdef FOR_DEBUG
  		printf("dhcpcd: Enter dhcpcd state machine during bound state\r\n");
  		ever_display_init_state = 0;
  	#endif
  	
  	do {
  		currState=(void *(*)())currState(); 
  		#ifdef HSUJP
  			#if 0
    			if (currState == &goto_wait_for_traffic) {
    				currState = &dhcpReboot; 
    				//goto initialization;
    				goto wait_for_traffic;
    			}
    		#else
    			if (currState == &dhcpStop)
    			{
    				currState = &dhcpReboot; goto wait_for_traffic;
    			}
    		#endif
    	#endif
  	} while ( currState );
  	
  	deletePidFile();
  	
  	#ifdef HSUJP
    	Nprintf("dhcp client exiting\n");
    	//my_LOG("dhcp client exiting\n");
    	#if 0
    	monitored_items[101] = 0;
 		if ((fd = fopen("/var/config/monitor","w")) != NULL) {
			fwrite(monitored_items,120,1,fd); fclose(fd);
		}
		#endif
    #endif
  	exit(1);
}
