/*
 * Layer Two Tunnelling Protocol Daemon
 * Copyright (C) 1998 Adtran, Inc.
 *
 * Mark Spencer
 *
 * This software is distributed under the terms
 * of the GPL, which you should have received
 * along with this source.
 *
 * Miscellaneous but important functions
 *
 */
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <syslog.h>
#if defined(SOLARIS)
# include <varargs.h>
#endif
#include <netinet/in.h>
#include "l2tp.h"
#include "misc.h"
#include "amit.h"
//@@@ib wnlee 2k2/10/26
#include <dirent.h>
#include <sys/types.h>

// added for dialondemand start
#include <sys/socket.h>			// socket()
#include <sys/ioctl.h>			// ioctl()
#include <net/if.h>				// struct ifreq
#ifdef NEW_SOCKET
#include <linux/if_packet.h>	// struct sockaddr_ll
#else
#include <net/if_packet.h> 		// struct sockaddr_pkt
#endif
#include <netinet/in.h>			// htons()

// "struct sockaddr" is defined in linux/socket.h
// "struct sockaddr_in" is defined in netinet/in.h
// "struct in_addr" is defined in netinet/in.h

// select()
#include <sys/time.h>
#include <unistd.h>

// inet_ntoa()
#include <arpa/inet.h>

// "struct ether_header" is defined in net/ethernet.h
#include <net/ethernet.h>

// "struct iphdr" is defined in linux/ip.h
#include <linux/ip.h>
// added for dialondemand end

//@@@ie
extern	int 	amit_ui_no;
extern	int		autoreconnect;
//extern int dialondemand(char *interface);
//int		wanl2tp_retry =0;


#if 0
void log (int level, const char *fmt, ...)
{
    char buf[256];
    va_list args;
    va_start (args, fmt);
    vsnprintf (buf, sizeof (buf), fmt, args);
    va_end (args);              //bk - otherwise ppc segfaults
    va_start (args, fmt);       //bk
    vfprintf (stderr, fmt, args);
    fflush (stderr);
    //openlog (BINARY, LOG_PID, LOG_DAEMON);
    openlog (BINARY, LOG_ODELAY, LOG_DAEMON);
    syslog (level, "%s", buf);
    va_end (args);
}
#else
void log (int level, const char *fmt, ...)
{
}
#endif

void set_error (struct call *c, int error, const char *fmt, ...)
{
    va_list args;
    va_start (args, fmt);
    c->error = error;
    c->result = RESULT_ERROR;
    c->needclose = -1;
    vsnprintf (c->errormsg, sizeof (c->errormsg), fmt, args);
    if (c->errormsg[strlen (c->errormsg) - 1] == '\n')
        c->errormsg[strlen (c->errormsg) - 1] = 0;
    va_end (args);
}

struct buffer *new_buf (int size)
{
    struct buffer *b = malloc (sizeof (struct buffer));
    if (!b || !size || size < 0)
        return NULL;
    b->rstart = malloc (size);
    if (!b->rstart)
    {
        free (b);
        return NULL;
    }
    b->start = b->rstart;
    b->rend = (void *) ((unsigned int) b->rstart + size - 1);
    b->len = size;
    b->maxlen = size;
    return b;
}

inline void recycle_buf (struct buffer *b)
{
    b->start = b->rstart;
    b->len = b->maxlen;
}

#define bufferDumpWIDTH 16
void bufferDump (char *buf, int buflen)
{
    int i = 0, j = 0;
    /* we need TWO characters to DISPLAY ONE byte */
    unsigned char line[2 * bufferDumpWIDTH + 1], *c;

    for (i = 0; i < buflen / bufferDumpWIDTH; i++)
    {
        c = line;
        for (j = 0; j < bufferDumpWIDTH; j++)
        {
            sprintf (c, "%02x ", (buf[i * bufferDumpWIDTH + j]) & 0xff);
            c++;
            c++;                /* again two characters to display ONE byte */
        }
        *c = '\0';
        log (LOG_WARN, "%s: buflen=%d, buffer[%d]: *%s*\n", __FUNCTION__,
             buflen, i, line);
    }

    c = line;
    for (j = 0; j < buflen % bufferDumpWIDTH; j++)
    {
        sprintf (c, "%02x ",
                 buf[(buflen / bufferDumpWIDTH) * bufferDumpWIDTH +
                     j] & 0xff);
        c++;
        c++;
    }
    if (c != line)
    {
        *c = '\0';
        log (LOG_WARN, "%s:             buffer[%d]: *%s*\n", __FUNCTION__, i,
             line);
    }
}

void do_packet_dump (struct buffer *buf)
{
    int x;
    unsigned char *c = buf->start;
    printf ("packet dump: \nHEX: { ");
    for (x = 0; x < buf->len; x++)
    {
        printf ("%.2X ", *c);
        c++;
    };
    printf ("}\nASCII: { ");
    c = buf->start;
    for (x = 0; x < buf->len; x++)
    {
        if (*c > 31 && *c < 127)
        {
            putchar (*c);
        }
        else
        {
            putchar (' ');
        }
        c++;
    }
    printf ("}\n");
}

inline void swaps (void *buf_v, int len)
{
#ifdef __alpha
    /* Reverse byte order alpha is little endian so lest save a step.
       to make things work out easier */
    int x;
    unsigned char t1;
    unsigned char *tmp = (_u16 *) buf_v;
    for (x = 0; x < len; x += 2)
    {
        t1 = tmp[x];
        tmp[x] = tmp[x + 1];
        tmp[x + 1] = t1;
    =}
#else

    /* Reverse byte order (if proper to do so) 
       to make things work out easier */
    int x;
    _u16 *tmp = (_u16 *) buf_v;
    for (x = 0; x < len / 2; x++)
        tmp[x] = ntohs (tmp[x]);
#endif
}

inline void toss (struct buffer *buf)
{
    /*
     * Toss a frame and free up the buffer that contained it
     */

    free (buf->rstart);
    free (buf);
}

inline void safe_copy (char *a, char *b, int size)
{
    /* Copies B into A (assuming A holds MAXSTRLEN bytes)
       safely */
    strncpy (a, b, MIN (size, MAXSTRLEN - 1));
    a[MIN (size, MAXSTRLEN - 1)] = '\000';
}

struct ppp_opts *add_opt (struct ppp_opts *option, char *fmt, ...)
{
    va_list args;
    struct ppp_opts *new, *last;
    new = (struct ppp_opts *) malloc (sizeof (struct ppp_opts));
    if (!new)
    {
        log (LOG_WARN,
             "%s : Unable to allocate ppp option memory.  Expect a crash\n",
             __FUNCTION__);
        return NULL;
    }
    new->next = NULL;
    va_start (args, fmt);
    vsnprintf (new->option, sizeof (new->option), fmt, args);
    va_end (args);
    if (option)
    {
        last = option;
        while (last->next)
            last = last->next;
        last->next = new;
        return option;
    }
    else
        return new;
}

void opt_destroy (struct ppp_opts *option)
{
    struct ppp_opts *tmp;
    while (option)
    {
        tmp = option->next;
        free (option);
        option = tmp;
    };
}

//@@@ib wnlee 2k2-10-11
int write_csf (int status, int ui_no, char *remote_ip, int tid, int cid, int type)
{
    /*      Format ==> Status:Remote IP:Tunnel id:Call id
     *
     *       Status
     *         0      failed to connect
     *         1      connected
     *        99      connecting 
     *
     *       Type
     *         0      LNS
     *         1      LAC
     *         2      BOTH (LAC or LNS)
     */
    char 			filename[100];
    int 			size = 0;
    DIR 			*dirh;
    struct dirent 	*dirp;
    char 			link_status_file[30];
	FILE 			*fd;
	char			temp[23], *cp, command[132];

	#ifdef FOR_DEBUG
		if( type==LAC )
		{
			printf("l2tpd: write_csf: which:%d\r\n",(ui_no+MAX_NO_ACCOUNT_POOL));
		}
		else
		{
			printf("l2tpd: write_csf: which:%d\r\n",ui_no);
		}
	#endif
	
//	if( status==99 )
//	{
//		sprintf(link_status_file ,"/var/config/ppp/pppd.%d", (ui_no+MAX_NO_ACCOUNT_POOL));
//		fd = fopen(link_status_file ,"w");                   
//		fprintf(fd, "0\n0\n%d\n",status);
//		fclose(fd);
//	}
	
    bzero (filename, 100);
    
        
    if (type == LAC)
    {
        // unlink ui_no-th file
        if ((dirh = opendir (LAC_DIR)) == NULL)
        {
           // Nprintf("opendir [%s] failed\n",LAC_DIR);
            return -1;
        }
        for (dirp = readdir (dirh); dirp != NULL; dirp = readdir (dirh))
        {
            if (!strcmp (dirp->d_name, "."))
                continue;
            if (!strcmp (dirp->d_name, ".."))
                continue;
            size =
                snprintf (filename, 99, "l2tpc%d",
                          (ui_no + MAX_NO_ACCOUNT_POOL));
            *(filename + size) = 0;
            #ifdef FOR_DEBUG
            	printf("l2tpd: write_csf: dirp->d_name [%s] filename [%s]\n",
                 		dirp->d_name, filename);
            #endif
            if (strcmp (dirp->d_name, filename) == 0)
            {
                size =
                    snprintf (filename, 99, "%s/%s", LAC_DIR, dirp->d_name);
                *(filename + size) = 0;
                unlink (filename);
            }
        }
        // Prepare new file
        size =
            snprintf (filename, 99, "%s/l2tpc%d", LAC_DIR,
                      (ui_no + MAX_NO_ACCOUNT_POOL));
        *(filename + size) = 0;
    }
    else if (type == LNS)
    {
        size =
            snprintf (filename, 99, "%s/l2tps%d", LNS_DIR,ui_no);
    	*(filename + size) = 0;
	}

    fd = fopen (filename, "w+");
    if (fd == NULL)
    {
       //Nprintf("can't open %s\n",filename);
        return -1;
    }
    fprintf (fd, "%s\n%d\n%d\n%d\n", remote_ip, tid, cid, status);
    fclose (fd);
    
    #ifdef _WAN_L2TP
	    sprintf(filename,"/var/run/l2tpc/l2tp_wantype_info");
		if( (fd=fopen(filename,"r"))!=NULL )
		{
			fgets(temp,sizeof(temp),fd);
			fclose(fd);
			#ifdef FOR_DEBUG
				printf("l2tpd: write_csf: get WAN type from /var/run/l2tpc/l2tp_wantype_info = %d\r\n",atoi(temp));
			#endif
		}
		
		if ((type==LAC) && (atoi(temp)==WT_L2TP ))
	    {
	    	usleep(300);
			sprintf(filename,"/var/config/ppp/pppd.%d",MAX_NO_ACCOUNT_POOL + MAX_L2TP_CLIENT_NUM - 1);
			fd = fopen (filename, "r");
		    if (fd == NULL)
		    {
		    	#ifdef FOR_DEBUG
					printf("l2tpd: write_csf: can not open file to get ppp string from /var/config/ppp/pppd.n\r\n");
				#endif
		    } else {
		    	fgets(temp,sizeof(temp),fd); fgets(temp,sizeof(temp),fd); fclose(fd); 
		    	cp = strchr(temp,"\n"); if (cp != NULL) *cp = 0; else temp[4] = 0x00;
		    	#ifdef FOR_DEBUG
					printf("l2tpd: write_csf: get ppp string from /var/config/ppp/pppd.n = %s\r\n",temp);
				#endif
		    	if (status == 0)
		    	{
		    		#ifdef FOR_DEBUG
						printf("l2tpd: write_csf: Del the DROP PREROUTING rule for PPP WAN --> LAN\r\n");
					#endif
					sprintf(command,"iptables -t nat -D PREROUTING -i %s -o " LANPORTNAME " -j DROP",temp);
					system(command);
					//wanl2tp_retry++;
		    		//l2tp_reconnect();
		    	} else if (status == 1) {
		    		#if 0
				        #ifdef FOR_DEBUG
							printf("l2tpd: write_csf: Add the DROP PREROUTING rule for PPP WAN --> LAN\r\n");
						#endif
						sprintf(command,"iptables -t nat -I PREROUTING -i %s -o " LANPORTNAME " -j DROP",temp);
					#else
						#ifdef FOR_DEBUG
							printf("l2tpd: write_csf: Run ed 4 background\r\n");
						#endif
						sprintf(command,"ed 4&");
					#endif
					system(command);
				}
		    }
		    return 0;
	    }
    #endif
    
    #if 0
    if( type==LAC )
    {
    	bzero(link_status_file,30);
    	sprintf(link_status_file ,"/var/config/ppp/l2tpc.%d", (ui_no+MAX_NO_ACCOUNT_POOL));
        
		fd = fopen(link_status_file ,"w");                   
		fprintf(fd, "%d\n0\n%d\n",(ui_no+MAX_NO_ACCOUNT_POOL),status);
		fclose(fd);
		
	}
	else
	{
		sprintf(link_status_file ,"/var/config/ppp/l2tps.%d", (ui_no+LNS_TO_PPPD_NUMBER));
		fd = fopen(link_status_file ,"w");                   
		fprintf(fd, "%d\n0\n%d\n",ui_no,status);
		fclose(fd);
	}
	#endif
    
    return 0;
}

int modify_ui_files (int status,int ui_no,char *remote_ip, int tid, int cid, int action)
{
    /*       Filename format: 
     *       --------------------------
     *         dial in   n-remote_ip:ourtid:ourcid
     *         dial out  remote_ip:ourtid:ourcid
     *
     *       Status of call
     *       ---------------------------
     *         0      failed to connect
     *         1      connected
     *        99      connecting 
     *
     *
     *       Action
     *       ---------------------------------------------------------------
     *         0      find all tid-matching files, write_csf(0) ;we are LNS
     *                i.e. match (remote_ip, tid) from LNS_DIR
     *
     *         1      find all tid-matching files, write_csf(0) ;we are LAC
     *                i.e. match (remote_ip, tid) from LAC_DIR
     *
     *         2      When we received StopCCN, we get the target tunnel tid
     *                but we have to see if this tunnel is dial-in or dial-out.
     *                i.e. match (remote_ip, tid) from LNS_DIR and LAC_DIR
     *
     *         3      case CDN
     *                i.e. match (remote_ip, tid, cid) from both 
     *                     LNS_DIR and LAC_DIR directories
     */
    DIR *dirh;
    struct dirent *dirp;
    char filename[MAXSTRLEN];
    char aim_file[MAXSTRLEN];
    char link_status_file[30];
    int size;
	FILE *fd;
	char	temp[23];
	char	command[100];
	char	remotename[23];
	int		nbisd_fd;
	char	ttt[14];
	char	subnet[23];
	char	subnetlx[23];
	int		what_WAN_type, auto_reconnect;

	#ifdef FOR_DEBUG
		if( ui_no<LNS_UI_NO_BASE )
		{
			printf("l2tpd: modify_ui_files: which(LAC):%d\r\n",(ui_no+MAX_NO_ACCOUNT_POOL));
		}
		else
		{
			printf("l2tpd: modify_ui_files: which(LNS):%d\r\n",ui_no);
		}
	#endif
	
	bzero (aim_file, MAXSTRLEN);
	bzero (filename, MAXSTRLEN);
	bzero (link_status_file,30);
	
    
    if (action == 0)
    {
        if ((dirh = opendir (LNS_DIR)) == NULL)
        {
            //Nprintf("opendir [%s] failed\n",LNS_DIR);
            return -1;
        }
        
        size = snprintf(aim_file,MAXSTRLEN - 1,"%s/l2tps%d",LNS_DIR,ui_no);
        *(aim_file+size)=0;
        size = 0;
        for (dirp = readdir (dirh); dirp != NULL; dirp = readdir (dirh))
        {
            if (!strcmp (dirp->d_name, "."))
                continue;
            if (!strcmp (dirp->d_name, ".."))
                continue;

            size = snprintf (filename, MAXSTRLEN - 1, "%s/%s", LNS_DIR, dirp->d_name);  //getfilename
            *(filename + size) = 0;

			if( strcmp(filename,aim_file )!=0 )
			{
				continue;
			}
            // hit (remote_ip, tid) or (remote_ip,tid,cid)
            unlink (filename);
        }
    }
    else if (action == 1)
    {
        if ((dirh = opendir (LAC_DIR)) == NULL)
        {
            //Nprintf("%s:opendir [%s] failed\n",LAC_DIR); 
            return -1;
        }
        
        size = snprintf(aim_file,MAXSTRLEN - 1,"%s/l2tpc%d",LAC_DIR,(ui_no+MAX_NO_ACCOUNT_POOL));
        *(aim_file+size)=0;
        size = 0;
        for (dirp = readdir (dirh); dirp != NULL; dirp = readdir (dirh))
        {
            if (!strcmp (dirp->d_name, "."))
                continue;
            if (!strcmp (dirp->d_name, ".."))
                continue;

            size = snprintf (filename, MAXSTRLEN - 1, "%s/%s", LAC_DIR, dirp->d_name);  //getfilename
            *(filename + size) = 0;

            if( strcmp(filename,aim_file )!=0 )
			{
				continue;
			}

            fd = fopen (filename, "w");
            fprintf (fd, "%s\n%d\n%d\n%d\n", remote_ip, tid, cid, status);
            fclose (fd);
        }
    }
    else                        //action==2 or action==3
    {
        /*  
         * First, look in dial-in directory, unlink the record if hit.
         */
        
        
        if ((dirh = opendir (LNS_DIR)) == NULL)
        {
            //Nprintf("opendir [%s] failed\n",LNS_DIR);
            return -1;
        }
        
        size = snprintf(aim_file,MAXSTRLEN - 1,"%s/l2tps%d",LNS_DIR,ui_no);
        *(aim_file+size) =0;
        size=0;
        for (dirp = readdir (dirh); dirp != NULL; dirp = readdir (dirh))
        {
            if (!strcmp (dirp->d_name, "."))
                continue;
            if (!strcmp (dirp->d_name, ".."))
                continue;
            size = snprintf (filename, MAXSTRLEN - 1, "%s/%s", LNS_DIR, dirp->d_name);  //getfilename
            *(filename + size) = 0;

            if( strcmp(filename,aim_file )!=0 )
			{
				continue;
			}


            // hit (remote_ip, tid) or (remote_ip,tid,cid)
            #ifdef FOR_DEBUG
            	printf("unlink(%s)\n",filename);
            #endif
            unlink (filename);
        }
        closedir (dirh);
        /*
         * Second, look in dial-out directory, 
         *         modify record content as 0 if hit
         */

        
        if ((dirh = opendir (LAC_DIR)) == NULL)
        {
            //Nprintf("opendir [%s] failed\n",LAC_DIR);
            return -1;
        }
        
        size = snprintf(aim_file,MAXSTRLEN - 1,"%s/l2tpc%d",LAC_DIR,(ui_no+MAX_NO_ACCOUNT_POOL));
        *(aim_file+size)=0;
        size=0;
        for (dirp = readdir (dirh); dirp != NULL; dirp = readdir (dirh))
        {

            if (!strcmp (dirp->d_name, "."))
                continue;
            if (!strcmp (dirp->d_name, ".."))
                continue;

            size =
                snprintf (filename, MAXSTRLEN - 1, "%s/%s", LAC_DIR,
                          dirp->d_name);
            *(filename + size) = 0;
            
            if( strcmp(filename,aim_file )!=0 )
			{
				continue;
			}


            // hit (remote_ip, tid), modify content
            fd = fopen (filename, "w");
            fprintf (fd, "%s\n%d\n%d\n%d\n", remote_ip, tid, cid, status);
            fclose (fd);
        }
    }
    closedir (dirh);
    
    #ifdef FOR_DEBUG
    	printf("l2tpd: modify_ui_files: status:%d ui_no:%d\r\n",status,ui_no);
    #endif
    
    #ifdef _NETBIOS_L2TP
    if( (fd=fopen("/var/config/l2tp_netbios","r"))!=NULL  )
    {
    	fclose(fd);
    	if( (status==0) && (ui_no>=LNS_UI_NO_BASE) )
    	{
	    	sprintf(filename,"/var/run/l2tps/l2tps%d_remotename",ui_no);
	    	if( (fd=fopen(filename,"r"))!=NULL )
	    	{
	    		fscanf(fd,"%s\n",remotename);
	    		fclose(fd);
	    		sprintf(filename,"/var/config/%s",remotename);
	    		#ifdef FOR_DEBUG
					printf("l2tpd: modify_ui_files: filename:%s\r\n",filename);
				#endif
	    		if( (fd=fopen(filename,"r"))!=NULL )
				{
					fscanf(fd,"%s\n%s\n",subnet,subnetlx);
					fclose(fd);
				}
				#ifdef FOR_DEBUG
					printf("l2tpd: modify_ui_files: subnet:%s subnetlx:%s\r\n",subnet,subnetlx);
				#endif
					
				nbisd_fd = open("/var/run/nbisd.fifo",/*O_WRONLY*/0x0001 | /*O_NONBLOCK*/0x4000);
				sprintf(ttt,"%s 24 3 ",subnetlx);
				write(nbisd_fd,ttt,strlen(ttt));
				close(nbisd_fd);
	    	}
	    }
    }
    #endif
    
    if( (status==0) && (ui_no>=LNS_UI_NO_BASE) )
    {
    	sprintf(command,"rm -f /var/run/l2tps/l2tps%d_remotename",ui_no);
    	system(command);
    }
    
    #ifdef _WAN_L2TP
    
    	#ifdef FOR_DEBUG
			printf("l2tpd: modify_ui_files: Now L2TP WAN type compiling switch is enabled, Try to kill pppd\r\n");
		#endif
	    sprintf(filename,"/var/run/l2tpc/l2tp_wantype_info");
		if( (fd=fopen(filename,"r")) != NULL )
		{
			fgets(temp,sizeof(temp),fd); sscanf(temp,"%d",&what_WAN_type);
			if (what_WAN_type == WT_L2TP)
			{
				fgets(temp,sizeof(temp),fd); fgets(temp,sizeof(temp),fd); fgets(temp,sizeof(temp),fd); fgets(temp,sizeof(temp),fd);
				fgets(temp,sizeof(temp),fd); sscanf(temp,"%d",&auto_reconnect);
			}
			fclose(fd);
			#ifdef FOR_DEBUG
				printf("l2tpd: modify_ui_files: Check /var/run/l2tpc/l2tp_wantype_info, find WAN type is %d, auto_reconnect=%d\r\n",
						what_WAN_type,auto_reconnect);
				printf("l2tpd:                  from /var/run/l2tpc/l2tp_wantype_info ..... \r\n");
				system("cat /var/run/l2tpc/l2tp_wantype_info");
			#endif
		} else {
			#ifdef FOR_DEBUG
				printf("l2tpd: modify_ui_files: Check /var/run/l2tpc/l2tp_wantype_info, but file is not existed\r\n");
			#endif
			return 0;
		}
		
	    if( status==0 && ui_no<LNS_UI_NO_BASE )
	    {
	    	if (what_WAN_type == WT_L2TP)
	    	{
	    		#ifdef FOR_DEBUG
	    			printf("l2tpd: modify_ui_files: Now L2TP WAN type, Try to restart l2tpd\r\n");
	    		#endif
	    		#if 1
	    			//l2tp_reconnect();
		    		return 0;
		    	#else
		    		if (auto_reconnect == 1)
		    		{
			    		//wanl2tp_retry++;
			    		l2tp_reconnect();
			    		return 0;
			    	} else {	//hsujp
			    		#ifdef FOR_DEBUG
							printf("l2tpd: modify_ui_files: Delete the nat PREROUTING dropping ppp WAN to LAN packets\r\n");
						#endif
						
						#ifdef FOR_DEBUG
							printf("l2tpd: modify_ui_files: Add the nat PREROUTING dropping ethernet WAN to LAN packets\r\n");
						#endif
						
						#if 0	//h command results in the ppp interface to be removed
			    		sprintf(command,"/var/config/ppp/pppd.%d",(MAX_NO_ACCOUNT_POOL + MAX_L2TP_CLIENT_NUM - 1));
						if ( (fd = fopen(command,"r")) != NULL )
						{
							fgets(temp,sizeof(temp),fd);
							fclose(fd);
							
							sprintf(command,"kill -9 %d",atoi(temp));
							#ifdef FOR_DEBUG
								printf("l2tpd: modify_ui_files: Kill pppd: whose pid=%d\r\n",atoi(temp));
							#endif
							system(command);
						} else {
							#ifdef FOR_DEBUG
								printf("l2tpd: modify_ui_files: Kill pppd: Can not find its pid\r\n");
							#endif
						}
						#endif
						
						return 0;
			    	}
			    #endif
	    	}
	    }
    #endif
    
    #if 0
    if( ui_no<LNS_UI_NO_BASE )
    {
        bzero(link_status_file,30);
    	sprintf(link_status_file ,"/var/config/ppp/l2tpc.%d", (ui_no+MAX_NO_ACCOUNT_POOL));
    	
		fd = fopen(link_status_file ,"w");                   
		fprintf(fd, "%d\n0\n%d\n",(ui_no+MAX_NO_ACCOUNT_POOL),status);
		fclose(fd);
    }
    else
    {
        sprintf(link_status_file ,"/var/config/ppp/l2tps.%d", (ui_no+LNS_TO_PPPD_NUMBER));
		fd = fopen(link_status_file ,"w");                   
		fprintf(fd, "%d\n0\n%d\n",ui_no,status);
		fclose(fd);
    }
    #endif
    
    return 0;
}

int write_tid (int tid, int ui_no)
{
    FILE *fd;
    char filename[100];
    int size = 0;

    bzero (filename, 100);
    size =
        snprintf (filename, 99, "/var/run/l2tpd-%d.tid",
                  (ui_no + MAX_NO_ACCOUNT_POOL));
    *(filename + size) = 0;
    fd = fopen (filename, "w+");
    if (fd == NULL)
    {
        //Nprintf("can't open %s\n",filename);
        return -1;
    }
    fprintf (fd, "%d\n", tid);
    fclose (fd);
    return 0;
}

int unlink_ui_files (void)
{
    /*
     *  unlink all l2tpd UI files
     */
    DIR *dirh;
    struct dirent *dirp;
    char filename[100];
    int size = 0;

    if ((dirh = opendir ("/var/run")) == NULL)
    {
        //Nprintf("opendir [%s] failed\n", "/var/run");
        return -1;
    }
    for (dirp = readdir (dirh); dirp != NULL; dirp = readdir (dirh))
    {
        if (strstr (dirp->d_name, "l2tpd-") == NULL)
            continue;
        size = snprintf (filename, 99, "%s/%s", "/var/run", dirp->d_name);
        *(filename + size) = 0;
//#ifdef FOR_DEBUG
//        Nprintf("unlink %s\n", filename);
//#endif
        unlink (filename);
    }
    closedir (dirh);
    if ((dirh = opendir (LAC_DIR)) == NULL)
    {
        //Nprintf("opendir [%s] failed\n", LAC_DIR);
        return -1;
    }
    for (dirp = readdir (dirh); dirp != NULL; dirp = readdir (dirh))
    {
        if (!strcmp (dirp->d_name, "."))
        	continue;
        if (!strcmp (dirp->d_name, ".."))
        	continue;
		if (!strcmp (dirp->d_name, "l2tp_wantype_info"))	//eric add 
			continue;
		
        size = snprintf (filename, 99, "%s/%s", LAC_DIR, dirp->d_name);
        *(filename + size) = 0;
        unlink (filename);
    }
    closedir (dirh);
    if ((dirh = opendir (LNS_DIR)) == NULL)
    {
        //Nprintf("opendir [%s] failed\n", LNS_DIR);
        return -1;
    }
    for (dirp = readdir (dirh); dirp != NULL; dirp = readdir (dirh))
    {
        if (!strcmp (dirp->d_name, "."))
        	continue;
        if (!strcmp (dirp->d_name, ".."))
        	continue;
		if (!strcmp (dirp->d_name, "l2tp_wantype_info"))
			continue;
		
        size = snprintf (filename, 99, "%s/%s", LNS_DIR, dirp->d_name);
        *(filename + size) = 0;
        #ifdef FOR_DEBUG
        	Nprintf("unlink(%s)\n", filename);
        #endif
        unlink (filename);
    }
    closedir (dirh);
    return 0;
}

#ifdef _WAN_L2TP
void l2tp_reconnect( void )
{
	unsigned char	command[100];
	FILE	*fd;
	unsigned char	temp[23];
	unsigned char	wtype[23];
	unsigned char	user[23];
	unsigned char	ip[23];
	unsigned char	maxidle[23];
	unsigned char	iptype[23];
	unsigned char	reconnect[23];
	unsigned char	force[23];
	unsigned char	filename[100];
	
	
	
	sprintf(filename,"/var/run/l2tpc/l2tp_wantype_info");
	if( (fd=fopen(filename,"r"))!=NULL )
	{
		memset(wtype,0x00,23);
		memset(user,0x00,23);
		memset(ip,0x00,23);
		memset(maxidle,0x00,23);
		memset(iptype,0x00,23);
		memset(reconnect,0x00,23);
		memset(force,0x00,23);
		fscanf(fd,"%s\n%s\n%s\n%s\n%s\n%s\n%s\n"
				,wtype,user,ip,maxidle,iptype,reconnect,force);
		fclose(fd);
	}
	#ifdef FOR_DEBUG
		printf("l2tpd: reconnect: wtype:%s\r\n",wtype);
		printf("l2tpd: reconnect: user:%s\r\n",user);
		printf("l2tpd: reconnect: ip:%s\r\n",ip);
		printf("l2tpd: reconnect: maxidle:%s\r\n",maxidle);
		printf("l2tpd: reconnect: iptype:%s\r\n",iptype);
		printf("l2tpd: reconnect: reconnect:%s\r\n",reconnect);
		printf("l2tpd: reconnect: force:%s\r\n",force);
	#endif
	sprintf(filename,"/var/run/l2tpc/l2tp_wantype_info");
	if( (fd=fopen(filename,"w"))!=NULL )
	{
		fprintf(fd,"%s\n",wtype);
		fprintf(fd,"%s\n",user);
		fprintf(fd,"%s\n",ip);
		fprintf(fd,"%s\n",maxidle);
		fprintf(fd,"%s\n",iptype);
		fprintf(fd,"%s\n",reconnect);
		fprintf(fd,"0\n");
		fclose(fd);
	}
	
	if( atoi(reconnect)==0 )
	{
		sprintf(filename,"/var/run/l2tpc/l2tpc%d",(MAX_L2TP_CLIENT_NUM-1+MAX_NO_ACCOUNT_POOL));
		if((fd = fopen(filename, "w")) != NULL)
		{
			fprintf(fd, "0\n");
			fprintf(fd, "0\n");
			fprintf(fd, "0\n");
			fprintf(fd, "2\n");
			fclose(fd);
		}
		if( dialondemand(LANPORTNAME)==1 )
		{
			sprintf(command,"echo \"t %s %d 0 %s\" > /var/run/l2tp-control"
							,user
							,(MAX_L2TP_CLIENT_NUM-1+MAX_NO_ACCOUNT_POOL)
							,ip);
			system(command);
		}
	}
	else if( atoi(reconnect)==1 )
	{
		sprintf(command,"echo \"t %s %d 1 %s\" > /var/run/l2tp-control"
							,user
							,(MAX_L2TP_CLIENT_NUM-1+MAX_NO_ACCOUNT_POOL)
							,ip);
		system(command);
	}
}

int dialondemand(char *interface)
{
	int 					o = 1;
	int 					ethfd;
	struct ifreq 			ifr;
	#ifdef NEW_SOCKET
	  struct sockaddr_ll 	sap;
	#else
	  struct sockaddr_pkt 	sap;
	#endif
	//struct timeval 		tv;
	struct in_addr 			ip, ip2, netmask, netid;
	struct in_addr 			temp_ip;
	unsigned char 			*uptr1, *uptr2;	
	fd_set 					temp, fdread;
	struct 					ether_header *eth_hdr;
	struct iphdr 			*ip_hdr;
	char 					str[100];
	char 					des_ip_str[16], src_ip_str[16];
	char					filename[100];
	char					c_temp[23];
	FILE					*fd;
	
				

	// 1. --- Check parameters
	#if 0		//programmer must be careful of this
	if(strlen(interface) == 0)
	{
		printf("dialondemand: please fill in LAN interface\r\n");
		return -1;
	}
	#endif

	// 2. --- Function entrance
	#ifdef FOR_DEBUG
		printf("l2tpd: dialondemand: Starting to monitor LAN interface %s.\r\n", interface);
	#endif
	
	// 3. --- Function initialization
	memset(&ifr, 0, sizeof(struct ifreq));
	memcpy(ifr.ifr_name, interface, strlen(interface));

	// 4. --- Create socket
	#ifdef FOR_DEBUG
		printf("l2tpd: dialondemand: Create socket: ");
	#endif
	#ifdef NEW_SOCKET
		ethfd = socket(AF_PACKET, SOCK_RAW, htons(ETH_P_ALL));
	#else
		ethfd = socket(AF_PACKET, SOCK_PACKET, htons(ETH_P_ALL));
	#endif
	if(ethfd == -1)
	{
		#ifdef FOR_DEBUG
			printf("failed to create socket.\r\n");
		#endif
		exit(1);
	} else {
		#ifdef FOR_DEBUG
			printf("OK!\r\n");
		#endif
	}

	// 5. --- get hardware address
	#ifdef FOR_DEBUG
		printf("l2tpd: dialondemand: Get hardware address: ");
	#endif
	if(ioctl(ethfd, SIOCGIFHWADDR, &ifr))
	{
		#ifdef FOR_DEBUG
			printf("failed to get hardware address.\r\n");
		#endif
		exit(1);
	} else  {
		#ifdef FOR_DEBUG
			printf("%02X:%02X:%02X:%02X:%02X:%02X\r\n", \
				ifr.ifr_hwaddr.sa_data[0], ifr.ifr_hwaddr.sa_data[1], \
				ifr.ifr_hwaddr.sa_data[2], ifr.ifr_hwaddr.sa_data[3], \
				ifr.ifr_hwaddr.sa_data[4], ifr.ifr_hwaddr.sa_data[5]);
		#endif
	}


	// 6. --- is this interface a ethernet device or not
	#if 0
	#ifdef FOR_DEBUG
		printf("dhcpcd: Check interface: ");
	#endif
	if(ifr.ifr_hwaddr.sa_family != ARPHRD_ETHER)
	{
		#ifdef FOR_DEBUG
			printf("%s is not an ethernet device.\r\n", ifr.ifr_name);
		#endif
		exit(1);
	} else {
		#ifdef FOR_DEBUG
			printf("%s is an ethernet device.\r\n", ifr.ifr_name);
		#endif
	}
	#endif

	// 7. --- get interface ip
	#ifdef FOR_DEBUG
		printf("l2tpd: dialondemand: Get IP address: ");
	#endif
	if(ioctl(ethfd, SIOCGIFADDR, &ifr) < 0)
	{
		#ifdef FOR_DEBUG
			printf("failed to get IP address.\r\n");
		#endif
		exit(1);
	}
	ip = ((struct sockaddr_in *)&ifr.ifr_addr)->sin_addr;
	#ifdef FOR_DEBUG
		printf("%s\r\n", inet_ntoa(ip));
	#endif

	// 8. --- get interface netmask
	#ifdef FOR_DEBUG
		printf("l2tpd: dialondemand: Get Netmask: ");
	#endif
	if(ioctl(ethfd, SIOCGIFNETMASK, &ifr) < 0)
	{
		#ifdef FOR_DEBUG
			printf("failed to get netmask.\r\n");
		#endif
		exit(1);
	}
	netmask = ((struct sockaddr_in *)&ifr.ifr_addr)->sin_addr;
	#ifdef FOR_DEBUG
		printf("%s\r\n", inet_ntoa(netmask));
	#endif

	// 9. --- get network id
	#ifdef FOR_DEBUG
		printf("l2tpd: dialondemand: Get netword id: ");
	#endif
	uptr1 = (unsigned char *)&ip;
	uptr2 = (unsigned char *)&netmask;
	uptr1[0] &= uptr2[0]; uptr1[1] &= uptr2[1];	uptr1[2] &= uptr2[2]; uptr1[3] &= uptr2[3];
	memcpy((void *)&netid, uptr1, sizeof(ip));
	#ifdef FOR_DEBUG
		printf("%s\r\n", inet_ntoa(netid));
	#endif

	// 10. --- get or send broadcast packet
	//if(setsockopt(ethfd, SOL_SOCKET, SO_BROADCAST, &o, sizeof(o)) == -1)
	//	exit(1);

	// set flags
	// IFF_UP: interface is up
	// IFF_BROADCAST: broadcast address valid
	// IFF_NOTRAILERS: avoid use of trailers
	// IFF_RUNNING: resource allocated
	//ifr.ifr_flags = IFF_UP | IFF_BROADCAST | IFF_NOTRAILERS | IFF_RUNNING;
	//if(ioctl(ethfd, SIOCSIFFLAGS, &ifr))
	//	exit(1);

	// 11. --- binding
	#ifdef FOR_DEBUG
		printf("l2tpd: dialondemand: Bind packet socket to %s: ", ifr.ifr_name);
	#endif
	#ifdef NEW_SOCKET
		memset(&sap, 0, sizeof(sap));
		sap.sll_family = AF_PACKET;
		sap.sll_protocol = htons(ETH_P_ALL);
		//sap.sll_ifindex = 0;	//atoi(interface + 3);
		if (ioctl(ethfd, SIOCGIFINDEX, &ifr) < 0) {
			#ifdef FOR_DEBUG
				printf("l2tpd: dialondemand: ioctl(SIOCFIGINDEX): Could not get interface index");
			#endif
			exit(1);
    	}
    	sap.sll_ifindex = ifr.ifr_ifindex;
		if(bind(ethfd, (struct sockaddr *)&sap, sizeof(sap)) == -1)
	#else
		memset(&sap, 0, sizeof(sap));
		sap.spkt_family = AF_PACKET;
		memcpy(sap.spkt_device, interface, strlen(interface));
		if(bind(ethfd, (void *)&sap, sizeof(struct sockaddr)) == -1)
	#endif
	{
		#ifdef FOR_DEBUG
			printf("failed to bind.\r\n");
		#endif
		exit(1);
	} else {
		#ifdef FOR_DEBUG
			#ifdef NEW_SOCKET
				printf("OK! and ifindex=%d\r\n",sap.sll_ifindex);
			#else
				printf("OK!\r\n");
			#endif
		#endif
	}

	//12. --- Wait for traffic
	#ifdef FOR_DEBUG
		printf("l2tpd: dialondemand: Start waiting input packet: \r\n");
	#endif
		
	FD_SET(ethfd, &temp);
	fdread = temp;
	//tv.tv_sec = 5; tv.tv_usec = 0;
	for(;;)
	{
		select(ethfd + 1, &fdread, NULL, NULL, NULL);
		if(FD_ISSET(ethfd, &fdread))
		{
			o = read(ethfd, (void *)str, 100);
			eth_hdr = (struct ether_header *)str;
			#ifdef FOR_DEBUG
				printf("l2tpd: dialondemand: received a packet, type = %04X\r\n", ntohs(eth_hdr->ether_type));
			#endif
			if(ntohs(eth_hdr->ether_type) == ETHERTYPE_IP)
			{
				#ifdef FOR_DEBUG
					printf("                     its ether type = ETHERTYPE_IP\r\n");
				#endif
				usleep(300);
				ip_hdr = (struct iphdr *)((char *)eth_hdr + sizeof(struct ether_header));
				ip.s_addr = ip_hdr->daddr; ip2.s_addr = ip_hdr->saddr;
				temp_ip = ip; strcpy(des_ip_str,inet_ntoa(temp_ip));
				temp_ip = ip2; strcpy(src_ip_str,inet_ntoa(temp_ip));
				#ifdef FOR_DEBUG
					printf("                     source ip=%s, destination ip=%s\r\n",src_ip_str,des_ip_str);
				#endif
				uptr1 = (unsigned char *)&ip; uptr2 = (unsigned char *)&netmask;
				uptr1[0] &= uptr2[0]; uptr1[1] &= uptr2[1]; 
				uptr1[2] &= uptr2[2]; uptr1[3] &= uptr2[3];
				if ((ip.s_addr != netid.s_addr) 					&&
					(ip.s_addr != inet_addr("224.0.0.0"))		 	&&
					(ip_hdr->daddr != inet_addr("255.255.255.255")) &&
					(ip_hdr->daddr != inet_addr("239.255.255.250"))	   )
				{
					#ifdef FOR_DEBUG
						printf("l2tpd: dialondemand: received a packet from LAN %s (%s),\r\n", 
								ifr.ifr_name, src_ip_str);
						printf("                     and send to WAN (%s)\r\n", des_ip_str);
					#endif
					//unsigned char protocol_str[5];
					//if (ip_hdr->protocol == 6) {
					//	strcpy(protocol_str,"TCP");
					//}
					return 1;
				}
			} else {
				#ifdef FOR_DEBUG
					//printf("\r\n");
				#endif
			}
		}
		fdread = temp;
	}
	
	//return 0;
	
}
#endif
