/*
 * Layer Two Tunnelling Protocol Daemon
 * Copyright (C) 1998 Adtran, Inc.
 *
 * Mark Spencer
 *
 * This software is distributed under the terms
 * of the GPL, which you should have received
 * along with this source.
 *
 * Main Daemon source.
 *
 */

#include <stdlib.h>
#include <sys/utsname.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <syslog.h>
#if (__GLIBC__ < 2)
# if defined(FREEBSD)
#  include <sys/signal.h>
# elif defined(LINUX)
#  include <bsd/signal.h>
# elif defined(SOLARIS)
#  include <signal.h>
# endif
#else
# include <signal.h>
#endif
#include <netdb.h>
#include <string.h>
#include <fcntl.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#ifdef USE_KERNEL
#include <sys/ioctl.h>
#endif
#include "l2tp.h"
#include "misc.h"
#include "amit.h"
//@@ib wnlee 2k2/10/26
#include <dirent.h>
#include <sys/types.h>
//@@ie

struct tunnel_list tunnels;
int max_tunnels = DEF_MAX_TUNNELS;
struct utsname uts;
int ppd = 1;                    /* Packet processing delay */
int control_fd;                 /* descriptor of control area */
char *args;

char *dial_no_tmp;              /* jz: Dialnumber for Outgoing Call */
int switch_io = 0;              /* jz: Switch for Incoming or Outgoing Call */
//@@@ib wnlee 2k2-10-11
int amit_ui_no = 0;
int lns_ui_no = 1;
int autoreconnect = 0;
char ppp_name[20];       // username passing to pppd
char host_ip[23];
//@@@ie
extern int out_of_order_flag[5];
extern int rt_init();
extern void rt_close();
extern int set_route(char *ifname, unsigned long ip, unsigned long mask, int flag);
extern int getIFfromUNO(int uno, char *ifname);
void restart_l2tpd(void);

void init_tunnel_list (struct tunnel_list *t)
{
    t->head = NULL;
    t->count = 0;
    t->calls = 0;
}

//@@@ub wnlee 2k2-10-5 modify show_status() such that write output to /var/run/l2tpd-status
void show_status (void)
//@@@ue
{
    struct schedule_entry *se;
    struct tunnel *t;
    struct call *c;
    struct lns *tlns;
    struct lac *tlac;
    struct host *h;
    int s = 0;

//@@@ub wnlee 2k2-10-5 
    FILE *f = fopen ("/var/run/l2tpd-status", "w+");
    if (f == NULL)
    {
        log (LOG_WARN, "can't open /var/l2tpd-status\n");
        return;
    }
//@@@ue    
    fprintf (f, "====== l2tpd statistics ========\n");
    fprintf (f, " Scheduler entries:\n");
    se = events;
    while (se)
    {
        s++;
        t = (struct tunnel *) se->data;
        tlac = (struct lac *) se->data;
        c = (struct call *) se->data;
        if (se->func == &hello)
        {
            fprintf (f, "%d: HELLO to %d\n", s, t->tid);
        }
        else if (se->func == &magic_lac_dial)
        {
            fprintf (f, "%d: Magic dial on %s\n", s, tlac->entname);
        }
        else if (se->func == &send_zlb)
        {
            fprintf (f, "%d: Send payload ZLB on call %d:%d\n", s,
                     c->container->tid, c->cid);
        }
        else if (se->func == &dethrottle)
        {
            fprintf (f, "%d: Dethrottle call %d:%d\n", s, c->container->tid,
                     c->cid);
        }
        else
            fprintf (f, "%d: Unknown event\n", s);
        se = se->next;
    };
    fprintf (f, "Total Events scheduled: %d\n", s);
    fprintf (f, "Number of tunnels open: %d\n", tunnels.count);
    t = tunnels.head;
    while (t)
    {
        fprintf (f, "Tunnel %s, ID = %d (local), %d (remote) to %s:%d\n"
                 "   control_seq_num = %d, control_rec_seq_num = %d,\n"
                 "   cLr = %d\n",
                 (t->lac ? t->lac->entname : (t->lns ? t->lns->entname : "")),
                 t->ourtid, t->tid, IPADDY (t->peer.sin_addr),
                 ntohs (t->peer.sin_port), t->control_seq_num,
                 t->control_rec_seq_num, t->cLr);
        c = t->call_head;
        while (c)
        {
//@@@ub wnlee 2k2-10-5 serno=%d  should be serno=%u 
            fprintf (f,
                     "Call %s, ID = %d (local), %d (remote), serno = %u,\n"
                     "      data_seq_num = %d, data_rec_seq_num = %d,\n"
                     "      pLr = %d, tx = %u bytes (%u), rx= %u bytes (%u)\n",
                     (c->lac ? c->lac->
                      entname : (c->lns ? c->lns->entname : "")), c->ourcid,
                     c->cid, c->serno, c->data_seq_num, c->data_rec_seq_num,
                     c->pLr, c->tx_bytes, c->tx_pkts, c->rx_bytes,
                     c->rx_pkts);
//@@@ue                     
            c = c->next;
        }
        t = t->next;
    }
    fprintf (f, "==========Config File===========\n");
    tlns = lnslist;
    while (tlns)
    {
        fprintf (f, "LNS entry %s\n",
                 tlns->entname[0] ? tlns->entname : "(unnamed)");
        tlns = tlns->next;
    };
    tlac = laclist;
    while (tlac)
    {
        fprintf (f, "LAC entry %s, LNS is/are:",
                 tlac->entname[0] ? tlac->entname : "(unnamed)");
        h = tlac->lns;
        if (h)
        {
            while (h)
            {
                fprintf (f, " %s", h->hostname);
                h = h->next;
            }
        }
        else
            fprintf (f, " [none]");
        fprintf (f, "\n");
        tlac = tlac->next;
    };
    fprintf (f, "================================\n");
    fclose (f);
//@@@db wnlee 2k2-10-5    
//    close (fd2);
//@@@de
}

void null_handler (int sig)
{
    /* FIXME 
     * A sighup is received when a call is terminated, unknown origine .. 
     * I catch it and ll looks good, but .. 
     */
}

void status_handler (int sig)
{
//    show_status (1);
    show_status ();

}

void child_handler (int mysignal)
{
    /*
     * Oops, somebody we launched was killed.
     * It's time to reap them and close that call.
     * But first, we have to find out what PID died.
     * unfortunately, pppd will 
     */
    struct tunnel *t;
    struct call *c;
    pid_t pid;
    int mystatus;

    t = tunnels.head;
    pid = waitpid (-1, &mystatus, WNOHANG);
    if (pid < 1)
    {
        /*
         * Oh well, nobody there.  Maybe we reaped it
         * somewhere else already
         */
        return;
    }
    while (t)
    {
        c = t->call_head;
        while (c)
        {
            if (c->pppd == pid)
            {
                log (LOG_DEBUG, "%s : pppd died for call %d\n", __FUNCTION__,
                     c->cid);
//@@@ib wnlee 2k2-10-11
/*  Before call close, we produce a file to report the connection status.
 *  
 *		Failed to connect !
 */

                if (c->ui_no >= LNS_UI_NO_BASE)
                {
                    //Fix me! match (remote_ip, tid, cid) from LNS_DIR , not LNS_DIR and LAC_DIR
                    //This will speed up a little
                    #ifdef FOR_DEBUG
                		printf("l2tpd: child_handler: modify_ui_files status 0\r\n");
                	#endif
                	//LNS
                    modify_ui_files (0, c->ui_no,IPADDY (c->container->peer.sin_addr),
                                     c->container->ourtid, c->ourcid, 3);
                }
                else
                {
                	#ifdef FOR_DEBUG
                		printf("l2tpd: child_handler: write_csf status 0\r\n");
                	#endif
                	//LAC
                    write_csf (0, amit_ui_no,
                               IPADDY (c->container->peer.sin_addr),
							   c->container->ourtid, c->ourcid, LAC);
					restart_l2tpd();	//call restart l2tpd only effective on l2tp wantype
                }
//@@@ie                                                               
                c->needclose = -1;
                /* 
                 * OK...pppd died, we can go ahead and close the pty for
                 * it
                 */
                close (c->fd);
                return;
            }
            c = c->next;
        }
        t = t->next;
    }
}

//@@@ib wnlee 2k2-10-11
/*
 *	Connected ! We've successfully bring ppp<n> up.
 */
void pppifup_handler (int mysignal)
{

    /*
       *  We do 2 things in pppifup_handler
       *  1. write_csf(1)
       *  2. add a subnet routing entry using "route" command
     */


    struct tunnel *t;
    struct call *c;
    char command[100];
    int size = 0, j = 0;
    unsigned char *bpt;
    

    t = tunnels.head;
    c = t->call_head;

    log (LOG_DEBUG, "pppifup_handler: SIGUSR2\n");


    /* Fix me !!  should be BOTH ? */

    if (c->ui_no >= LNS_UI_NO_BASE)
    {                           //LNS
//    	#ifdef FOR_DEBUG
//    		printf("l2tpd: pppifup_handler: LNS write_csf status 1\r\n");
//    		printf("l2tpd: pppifup_handler: amit_ui_no:%d\r\n",amit_ui_no);
//    	#endif                          
//        write_csf (1, amit_ui_no,
//                   IPADDY (c->container->peer.sin_addr), c->container->ourtid,
//                   c->ourcid, LNS);
                   
        
//        bzero(temp_name_file,23);
//		sprintf(temp_name_file,"/var/run/l2tps/l2tps%d_remotename",amit_ui_no);
//		#ifdef FOR_DEBUG
//			printf("l2tpd: pppifup_handler: temp_name_file:%s\r\n",temp_name_file);
//		#endif
//		if( (fd=fopen(temp_name_file,"w"))!=NULL )
//		{
//			fprintf(fd,"%s\n",c->lns->authname);
//			fclose(fd);
//		}
//		else
//		{
//			#ifdef FOR_DEBUG
//				Nprintf("open %s\n",temp_name_file);
//			#endif
//		}
//		#ifdef FOR_DEBUG
//			printf("l2tpd: pppifup_handler: peername:%s\r\n",c->lns->authname);
//		#endif
        /* 
         *   LNS:
         *     If we want to add routing entry automatically by l2tpd
         *     fill you code here.
         *  
         */
    }
    else
    {                           //LAC 
    	#ifdef FOR_DEBUG
    		printf("l2tpd: pppifup_handler: LAC write_csf status 1\r\n");
    	#endif                          
        write_csf (1, c->ui_no, IPADDY (c->container->peer.sin_addr),
                   c->container->ourtid, c->ourcid, LAC);
                   
        
        /* 
         *   LAC:
         *     If we want to add routing entry automatically by l2tpd
         *     fill you code here.
         *
         *     for example:
         *     add a class C subnet routing entry:
         *     route add -net 192.168.16.0 netmask 255.255.255.0 gw 192.168.16.2
         *     
         */
		#ifdef _NETBIOS_L2TP
		if(rt_init() < 0)
		{
			#ifdef	FOR_DEBUG
				printf("L2TPD: open route socket fail\n");
			#endif
			return;
		}
		else
		{
			FILE *fp,*fd;
			char filename[200], ctemp[20], ifname[20];
			unsigned long procip;
			int		nbisd_fd;
			char	ttt[14];
			char	subnet[23];
			char	subnetlx[23];
			
			getIFfromUNO(amit_ui_no+MAX_NO_ACCOUNT_POOL, ifname);
			sprintf(filename, "/var/config/l2tpc/l2tp_client_routing.%d", amit_ui_no+MAX_NO_ACCOUNT_POOL);
			printf("open file:%s ifname:%s\n", filename, ifname);
			fp = fopen(filename, "r");
			if(fp == NULL)
				return;
			while(fgets(ctemp, sizeof(ctemp), fp))
			{
				sscanf(ctemp, "%u", &procip);
				set_route(ifname, procip, NULL, 1);
			}
			fclose(fp);
			rt_close();
			
		    if( (fd=fopen("/var/config/l2tp_netbios","r"))!=NULL  )
		    {
		    	fclose(fd);
		    	nbisd_fd = open("/var/run/nbisd.fifo",/*O_WRONLY*/0x0001 | /*O_NONBLOCK*/0x4000);
				sprintf(ttt,"%lX 24 4 ",procip);
				#ifdef FOR_DEBUG
					printf("l2tpd: writefifo: ttt:%s\r\n",ttt);
				#endif
				write(nbisd_fd,ttt,strlen(ttt));
				close(nbisd_fd);
		    }
		}
		#endif
    }

}

//@@@ie

void death_handler (int mysignal)
{
    /*
       * If we get here, somebody terminated us with a kill or a control-c.
       * we call call_close on each tunnel twice to get a StopCCN out
       * for each one (we can't pause to make sure it's received.
       * Then we close the connections
     */
    struct tunnel *st, *st2;
    int sec;

	FILE *fp,*new_fp;
	int i;
	char tmp_str[100];
	
    log (LOG_CRIT, "%s: Fatal signal %d received\n", __FUNCTION__, mysignal);
    st = tunnels.head;
    while (st)
    {
        st2 = st->next;
        strcpy (st->self->errormsg, "Server closing");
        sec = st->self->closing;
        if (st->lac)
            st->lac->redial = 0;
        call_close (st->self);
        if (!sec)
        {
            st->self->closing = -1;
            call_close (st->self);
        }
        st = st2;
    }

    /* erase pid file */
    unlink (gconfig.pidfile);
//@@@ib wnlee 2k2/10/26
    unlink_ui_files ();
//@@@ie

	/* add for reset l2tp_wantype_info file */
	fp = fopen("/var/run/l2tpc/l2tp_wantype_info","r");
	if(fp!=NULL){
		printf("l2tp->is dead!\n");
		new_fp=fopen("/var/run/l2tpc/new_wantype_info","w");
		for(i=0;i<6;i++){
			fgets(tmp_str,sizeof(tmp_str),fp);
			fprintf(new_fp,"%s",tmp_str);
		}
		fprintf(new_fp,"0");		//0 means no force connect
		fclose(fp);fclose(new_fp);
	}
	system("mv /var/run/l2tpc/new_wantype_info /var/run/l2tpc/l2tp_wantype_info");
	/* modify l2tp_wantype_info end*/	
	
	exit (1);
}

//@@@ub wnlee 2k2-10-12
int start_pppd (struct call *c, struct ppp_opts *opts, int type,
                int autoreconnect)
{
    /*    Type
     *     LNS  Brecis play LNS. That is, somebody dial in.
     *     LAC  Brecis play LAC. That is, amit dial out.
     */
//@@@ue
    char a, b;
    char tty[80];
    char *stropt[80];
    struct ppp_opts *p;
#ifdef USE_KERNEL
    struct l2tp_call_opts co;
#endif
    int pos = 1, index;
    int fd2;
#ifdef DEBUG_PPPD
    int x;
#endif
    struct termios ptyconf;
    char *str;
    int size;
    char filename[100];
    FILE	*fd;
    char	wtype[23];
    char	c_temp[23];
    char	idle[23];
    char	user[23];
    char	ip_str[23];
    


//@@@ib wnlee 2k2-10-14
#ifdef FOR_DEBUG
    printf("l2tpd: start_pppd: [%s]\r\n", (type == 0) ? "LNS" : "LAC");
#endif
//@@@ie


    stropt[0] = strdup (PPPD);

    if (c->pppd > 0)
    {
        log (LOG_WARN, "%s: PPP already started on call!\n", __FUNCTION__);
        return -EINVAL;
    }
    if (c->fd > -1)
    {
        log (LOG_WARN, "%s: file descriptor already assigned!\n",
             __FUNCTION__);
        return -EINVAL;
    }
#ifdef USE_KERNEL
    if (kernel_support)
    {
        co.ourtid = c->container->ourtid;
        co.ourcid = c->ourcid;
        ioctl (server_socket, L2TPIOCGETCALLOPTS, &co);
        stropt[pos++] = strdup ("channel");
        stropt[pos] = (char *) malloc (10);
        snprintf (stropt[pos], 10, "%d", co.id);
        pos++;
        stropt[pos] = NULL;
    }
    else
    {
#endif
        if ((c->fd = getPtyMaster (&a, &b)) < 0)
        {
            log (LOG_WARN, "%s: unable to allocate pty, abandoning!\n",
                 __FUNCTION__);
            return -EINVAL;
        }

        /* set fd opened above to not echo so we don't see read our own packets
           back of the file descriptor that we just wrote them to */
        tcgetattr (c->fd, &ptyconf);
        *(c->oldptyconf) = ptyconf;
        ptyconf.c_cflag &= ~(ICANON | ECHO);
//@@@ib wnlee 2k3-04-16
/* a loopback problem fix for l2tpd */
        ptyconf.c_lflag &= ~ECHO;
//@@@ie
        tcsetattr (c->fd, TCSANOW, &ptyconf);

        snprintf (tty, sizeof (tty), "/dev/tty%c%c", a, b);
        fd2 = open (tty, O_RDWR);


//@@@ub wnlee 2k2-10-5 
/*
 *  BRECIS pppd set default_devnam as <std> (line 243 at pppd/pppd/main.c)
 *  Hence, we have to assign the  pseudo tty to pppd.
 *  We add an option to pppd  here
 */
        snprintf (tty, sizeof (tty), "/dev/tty%c%c", a, b);
        stropt[pos] = (char *) malloc (strlen (tty) + 1);
        strncpy (stropt[pos], tty, strlen (tty) + 1);
        pos++;

		stropt[pos] = (char *) malloc (strlen ("38400") + 1);
		strcpy (stropt[pos], "38400");
		pos++;
			
		
        p = opts;
        while (p)
        {
            stropt[pos] = (char *) malloc (strlen (p->option) + 1);
            strncpy (stropt[pos], p->option, strlen (p->option) + 1);
            pos++;
            p = p->next;
        }

//@@@ub wnlee 2k3-04-16
        //stropt[pos] = NULL;
        if (type)               // When we are LAC
        {
#ifdef DEBUG_UI
            log (LOG_LOG, "start_pppd: LAC autoreconnect [%d]\n",
                 autoreconnect);
#endif
            /* When l2tpd plays LAC.
             * We will receive the username for pppd through control_fd.
             * We must pass username to pppd to make a correct ppp auth-request
             * By the way, "noauth" is need when l2tpd plays LAC
             * 
             */
            log (LOG_DEBUG, "NAME [%s] PPP_NAME[%s]\n", NAME, ppp_name);
//            if( auth_flag=0 )
            {
            	stropt[pos] = (char *) malloc (strlen (NAME) + 1);
            	strncpy (stropt[pos], NAME, strlen (NAME) + 1);
            	pos++;
            	stropt[pos] = (char *) malloc (strlen (ppp_name) + 1);
 
				strncpy (stropt[pos], ppp_name, strlen (ppp_name) + 1);
            	pos++;
            }
			/* eric make  "noauth" has  already added into stropt[]
            stropt[pos] = (char *) malloc (strlen (NOAUTH) + 1);
            strncpy (stropt[pos], NOAUTH, strlen (NOAUTH) + 1);
            pos++;
			*/
            //removed by rotor (no wait for traffic)
            #if 0
            stropt[pos] = (char *) malloc (strlen (DEMAND) + 1);
            strncpy (stropt[pos], DEMAND, strlen (DEMAND) + 1);
            pos++;
            stropt[pos] = (char *) malloc (strlen (IPCP_ACCEPT_REMOTE) + 1);
            strncpy (stropt[pos], IPCP_ACCEPT_REMOTE, strlen (IPCP_ACCEPT_REMOTE) + 1);
            pos++;
            stropt[pos] = (char *) malloc (strlen (IPCP_ACCEPT_LOCAL) + 1);
            strncpy (stropt[pos], IPCP_ACCEPT_LOCAL, strlen (IPCP_ACCEPT_LOCAL) + 1);
            pos++;
            stropt[pos] = (char *) malloc (strlen (IP_RANDOM) + 1);
            strncpy (stropt[pos], IP_RANDOM, strlen (IP_RANDOM) + 1);
            pos++;
            stropt[pos] = (char *) malloc (strlen (CONNECT) + 1);
            strncpy (stropt[pos], CONNECT, strlen (CONNECT) + 1);
            pos++;
            stropt[pos] = (char *) malloc (strlen (BOOLEAN_TRUE) + 1);
            strncpy (stropt[pos], BOOLEAN_TRUE, strlen (BOOLEAN_TRUE) + 1);
            pos++;
            stropt[pos] = (char *) malloc (strlen (NOIPDEFAULT) + 1);
            strncpy (stropt[pos], NOIPDEFAULT, strlen (NOIPDEFAULT) + 1);
            pos++;
            #endif
            //rotor end (no wait for traffic)
//            stropt[pos] = (char *) malloc (strlen (host_ip) + 1);
//            strncpy (stropt[pos], host_ip, strlen (host_ip) + 1);
//            pos++;
//            #ifdef FOR_DEBUG
//            	Nprintf("host_ip:%s\n",host_ip);
//            	printf("l2tpd: start_pppd: host_ip:%s\r\n",host_ip);
//            #endif
            stropt[pos] = (char *) malloc (strlen (FUNCALL) + 1);
            strncpy (stropt[pos], FUNCALL, strlen (FUNCALL) + 1);
            pos++;
            stropt[pos] = (char *) malloc (strlen (L2TPClIENT) + 1);
            strncpy (stropt[pos], L2TPClIENT, strlen (L2TPClIENT) + 1);
            pos++;
            stropt[pos] = (char *) malloc (strlen (UI_NUM_U) + 1);
            strncpy (stropt[pos], UI_NUM_U, strlen (UI_NUM_U) + 1);
            pos++;
            sprintf(c_temp,"%d",(amit_ui_no+MAX_NO_ACCOUNT_POOL));
            stropt[pos] = (char *) malloc (strlen (c_temp) + 1);
            strncpy (stropt[pos], c_temp, strlen (c_temp) + 1);
            pos++;
            stropt[pos] = (char *) malloc (strlen (UI_NUM_S) + 1);
            strncpy (stropt[pos], UI_NUM_S, strlen (UI_NUM_S) + 1);
            pos++;
            stropt[pos] = (char *) malloc (strlen (c_temp) + 1);
            strncpy (stropt[pos], c_temp, strlen (c_temp) + 1);
            pos++;
			
			#ifdef _WAN_L2TP
			sprintf(filename,"/var/run/l2tpc/l2tp_wantype_info");
			if( (fd=fopen(filename,"r"))!=NULL )
			{
				fscanf(fd,"%s\n%s\n%s\n%s\n"
						,wtype,user,ip_str,idle);
				fclose(fd);
			}
		
			if( atoi(wtype)==WT_L2TP )
			{
	            if (autoreconnect == 0)
	            {
	                stropt[pos] = (char *) malloc (strlen (IDLE) + 1);
	                strncpy (stropt[pos], IDLE, strlen (IDLE) + 1);
	                pos++;
		            stropt[pos] = (char *) malloc (strlen (idle) + 1);
		            strncpy (stropt[pos], idle, strlen (idle) + 1);
		            pos++;
	            }
	        /*    else
	            {
	            	stropt[pos] = (char *) malloc (strlen (AUTORECONNECT) + 1);
	                strncpy (stropt[pos], AUTORECONNECT, strlen (AUTORECONNECT) + 1);
	                pos++;
	            }*/
        	}
        	else
        	#endif
        	{
        	/*	stropt[pos] = (char *) malloc (strlen (AUTORECONNECT) + 1);
                strncpy (stropt[pos], AUTORECONNECT, strlen (AUTORECONNECT) + 1);
                pos++;*/
        	}
        }
        else                    // LNS
        {
            /*      FIX ME:
             *      should we add our hostname as name for pppd ?
             */
            #ifdef FOR_DEBUG
            	printf("l2tpd: start_pppd: LNS: amit_ui_no:%d\r\n",amit_ui_no);
            #endif
            stropt[pos] = (char *) malloc (strlen (UI_NUM_U) + 1);
            strncpy (stropt[pos], UI_NUM_U, strlen (UI_NUM_U) + 1);
            pos++;
            sprintf(c_temp,"%d",(amit_ui_no+LNS_TO_PPPD_NUMBER));
            stropt[pos] = (char *) malloc (strlen (c_temp) + 1);
            strncpy (stropt[pos], c_temp, strlen (c_temp) + 1);
            pos++;
            stropt[pos] = (char *) malloc (strlen (UI_NUM_S) + 1);
            strncpy (stropt[pos], UI_NUM_S, strlen (UI_NUM_S) + 1);
            pos++;
            sprintf(c_temp,"%d",(amit_ui_no+LNS_TO_PPPD_NUMBER));
            stropt[pos] = (char *) malloc (strlen (c_temp) + 1);
            strncpy (stropt[pos], c_temp, strlen (c_temp) + 1);
            pos++;
//            stropt[pos] = (char *) malloc (strlen (NOAUTH) + 1);
//            strncpy (stropt[pos], NOAUTH, strlen (NOAUTH) + 1);
//            pos++;
        	stropt[pos] = (char *) malloc (strlen (FUNCALL) + 1);
            strncpy (stropt[pos], FUNCALL, strlen (FUNCALL) + 1);
            pos++;
            stropt[pos] = (char *) malloc (strlen (L2TPSERVER) + 1);
            strncpy (stropt[pos], L2TPSERVER, strlen (L2TPSERVER) + 1);
            pos++;
        }
        stropt[pos] = NULL;
//        size = snprintf(filename,99,"/var/run/l2tpc/l2tpc%d",ui_num);
//		*(filename+size)=0;
//	    fd = fopen(filename, "r");
//@@@ue 
//@@@ue
		#ifdef FOR_DEBUG		//for show L2TP->pppd patameter
        	for (x = 0; stropt[x]; x++)
        	{
            	printf("%s\r\n", stropt[x]);
        	}
        #endif

#ifdef USE_KERNEL
    }
#endif
    str = stropt[0];
#ifdef DEBUG_PPPD
    log (LOG_DEBUG, "%s: I'm running:  ", __FUNCTION__);
    for (x = 0; stropt[x]; x++)
    {
        log (LOG_DEBUG, "%s ", stropt[x]);
    };
    log (LOG_DEBUG, "\n");
#endif

    c->pppd = fork ();
	//@@@ib wnlee 2k2-10-12
	/*
	 *	we assigned different range of ui_no for dial-in and dial-out calls.
	 *
	 */
 
	//removed by rotor	
	//    if (type == LNS)
	//    {
	//        c->ui_no = CYCLIC_LNS (lns_ui_no);
	//        lns_ui_no++;
	//    }
	//    else
    c->ui_no = amit_ui_no;
	//@@@ie    
    if (c->pppd < 0)
    {
        log (LOG_WARN, "%s: unable to fork(), abandoning!\n", __FUNCTION__);
        return -EINVAL;
    }
    else if (!c->pppd)
    {
        struct call *sc;
        struct tunnel *st;

        log (LOG_DEBUG, "\nIt is child\n");
        close (0);
        close (1);
		//@@@ub wnlee 2k3-4-16        
		/*
		 *	we keep stderr of pppd opened
		 *      so that the debug messages can appear on screen.
		 */
        close (2);
		//@@@ue
#ifdef USE_KERNEL
        if (!kernel_support && (fd2 < 0))
#else
        if (fd2 < 0)
#endif
        {
            log (LOG_WARN, "%s: Unable to open %s to launch pppd!\n",
                 __FUNCTION__, tty);
            exit (1);
        }

        dup2 (fd2, 0);
        dup2 (fd2, 1);


        /* close all the calls pty fds */
        st = tunnels.head;
        while (st)
        {
            sc = st->call_head;
            while (sc)
            {
                close (sc->fd);
                sc = sc->next;
            }
            st = st->next;
        }

        /* close the UDP socket fd */
        close (server_socket);

        /* close the control pipe fd */
        close (control_fd);
        
        execv (PPPD, stropt);
        log (LOG_WARN, "%s: Exec of %s failed!\n", __FUNCTION__, PPPD);
        exit (1);
    };
    close (fd2);
    pos = 0;

    while (stropt[pos])
    {
        free (stropt[pos]);
        pos++;
    };
    return 0;
}

void destroy_tunnel (struct tunnel *t)
{
    /*
     * Immediately destroy a tunnel (and all its calls)
     * and free its resources.  This may be called
     * by the tunnel itself,so it needs to be
     * "suicide safe"
     */

    struct call *c, *me;
    struct tunnel *p;
    struct timeval tv;
    if (!t)
        return;

    /*
     * Save ourselves until the very
     * end, since we might be calling this ourselves.
     * We must divorce ourself from the tunnel
     * structure, however, to avoid recursion
     * because of the logic of the destroy_call
     */
    me = t->self;

    /*
     * Destroy all the member calls
     */
    c = t->call_head;
    while (c)
    {
        destroy_call (c);
        c = c->next;
    };
    /*
     * Remove ourselves from the list of tunnels
     */

    if (tunnels.head == t)
    {
        tunnels.head = t->next;
        tunnels.count--;
    }
    else
    {
        p = tunnels.head;
        if (p)
        {
            while (p->next && (p->next != t))
                p = p->next;
            if (p->next)
            {
                p->next = t->next;
                tunnels.count--;
            }
            else
            {
                log (LOG_WARN,
                     "%s: unable to locate tunnel in tunnel list\n",
                     __FUNCTION__);
            }
        }
        else
        {
            log (LOG_WARN, "%s: tunnel list is empty!\n", __FUNCTION__);
        }
    }
    if (t->lac)
    {
        t->lac->t = NULL;
        if (t->lac->redial && (t->lac->rtimeout > 0) && !t->lac->rsched &&
            t->lac->active)
        {
            log (LOG_LOG, "%s: Will redial in %d seconds\n", __FUNCTION__,
                 t->lac->rtimeout);
            tv.tv_sec = t->lac->rtimeout;
            tv.tv_usec = 0;
            t->lac->rsched = schedule (tv, magic_lac_dial, t->lac);
        }
    }
    /* XXX L2TP/IPSec: remove relevant SAs here?  NTB 20011010
     * XXX But what if another tunnel is using same SA?
     */
    if (t->lns)
        t->lns->t = NULL;
    free (t);
    free (me);
}

struct tunnel *l2tp_call (char *host, int port, struct lac *lac,
                          struct lns *lns)
{
    /*
     * Establish a tunnel from us to host
     * on port port
     */
    struct call 	*tmp = NULL;
    struct hostent 	*hp;
    unsigned int 	addr;
    
    port = htons (port);
    
    hp = gethostbyname (host);
    if (!hp)
    {
    	#if 0
        log (LOG_WARN, "%s: gethostbyname() failed for %s.\n", __FUNCTION__,
             host);
        #endif
        Nprintf("gethostbyname() failed for %s.\n", host); 
        return NULL;
    }
    #ifdef FOR_DEBUG
    	printf("l2tpd: l2tp_call: host name=%s\r\n", host); //peer ip
    #endif
    
    bcopy (hp->h_addr, &addr, hp->h_length);
    /* Force creation of a new tunnel
       and set it's tid to 0 to cause
       negotiation to occur */
    /* XXX L2TP/IPSec: Set up SA to addr:port here?  NTB 20011010
     */
     
    tmp = get_call (0, 0, addr, port);
    if (!tmp)
    {
    	#if 0
        log (LOG_WARN, "%s: Unable to create tunnel to %s.\n", __FUNCTION__,
             host);
        #endif
        Nprintf("Unable to create tunnel to %s.\n",host);
        return NULL;
    }
    #ifdef FOR_DEBUG
    	printf("l2tpd: l2tp_call: Create tunnel to %s.\n",host);
    #endif
    
    tmp->container->tid = 0;
    tmp->container->lac = lac;
    tmp->container->lns = lns;
    tmp->lac = lac;
    tmp->lns = lns;
    if (lac)
        lac->t = tmp->container;
    if (lns)
        lns->t = tmp->container;
        
    /*
     * Since our state is 0, we will establish a tunnel now
     */
    #if 0
    log (LOG_LOG, "%s:Connecting to host %s, port %d\n", __FUNCTION__, host,
         ntohs (port));
    #endif
    #ifdef FOR_DEBUG
    	printf("l2tpd: l2tp_call: Connecting to host %s, port %d\r\n",host,ntohs (port));
    #endif
    
    control_finish (tmp->container, tmp);
    
    return tmp->container;
}

void magic_lac_tunnel (void *data)
{
    struct lac *lac;
    lac = (struct lac *) data;
    if (!lac)
    {
        log (LOG_WARN, "%s: magic_lac_tunnel: called on NULL lac!\n",
             __FUNCTION__);
        return;
    }
    if (lac->lns)
    {
        /* FIXME: I should try different LNS's if I get failures */
        l2tp_call (lac->lns->hostname, lac->lns->port, lac, NULL);
        return;
    }
    else if (deflac && deflac->lns)
    {
        l2tp_call (deflac->lns->hostname, deflac->lns->port, lac, NULL);
        return;
    }
    else
    {
        log (LOG_WARN, "%s: Unable to find hostname to dial for '%s'\n",
             __FUNCTION__, lac->entname);
        return;
    }
}

struct call *lac_call (int tid, struct lac *lac, struct lns *lns)
{
    struct tunnel *t = tunnels.head;
    struct call *tmp;
    while (t)
    {
        if (t->ourtid == tid)
        {
            tmp = new_call (t);
            if (!tmp)
            {
                log (LOG_WARN, "%s: unable to create new call\n",
                     __FUNCTION__);
                return NULL;
            }
            tmp->next = t->call_head;
            t->call_head = tmp;
            t->count++;
            tmp->cid = 0;
            tmp->lac = lac;
            tmp->lns = lns;
            if (lac)
                lac->c = tmp;
            log (LOG_LOG, "%s: Calling on tunnel %d\n", __FUNCTION__, tid);
            strcpy (tmp->dial_no, dial_no_tmp); /*  jz: copy dialnumber to tmp->dial_no  */
            control_finish (t, tmp);
            return tmp;
        }
        t = t->next;
    };
    Nprintf("No such tunnel %d to generate call.\n",tid);
    //rotor
    #ifdef FOR_DEBUG
    	printf("l2tpd: lac_call: modify_ui_files status 0\r\n");
    #endif
    modify_ui_files (0, amit_ui_no,IPADDY (t->peer.sin_addr), t->ourtid,
                                 0, 2);
    return NULL;
}

void magic_lac_dial (void *data)
{
    struct lac *lac;
    lac = (struct lac *) data;
    if (!lac->active)
    {
        log (LOG_DEBUG, "%s: LAC %s not active", __FUNCTION__, lac->entname);
        return;
    }
    lac->rsched = NULL;
    lac->rtries++;
    if (lac->rmax && (lac->rtries > lac->rmax))
    {
        log (LOG_LOG, "%s: maximum retries exceeded.\n", __FUNCTION__);
        return;
    }
    if (!lac)
    {
        log (LOG_WARN, "%s : called on NULL lac!\n", __FUNCTION__);
        return;
    }
    if (!lac->t)
    {
#ifdef DEGUG_MAGIC
        log (LOG_DEBUG, "%s : tunnel not up!  Connecting!\n", __FUNCTION__);
#endif
        magic_lac_tunnel (lac);
        return;
    }
    lac_call (lac->t->ourtid, lac, NULL);
}

void lac_hangup (int cid)
{
    struct tunnel *t = tunnels.head;
    struct call *tmp;
    while (t)
    {
        tmp = t->call_head;
        while (tmp)
        {
            if (tmp->ourcid == cid)
            {
                log (LOG_LOG,
                     "%s :Hanging up call %d, Local: %d, Remote: %d\n",
                     __FUNCTION__, tmp->serno, tmp->ourcid, tmp->cid);
                strcpy (tmp->errormsg, "Goodbye!");
/*				tmp->needclose = -1; */
				kill (tmp->pppd, SIGTERM);
                return;
            }
            tmp = tmp->next;
        }
        t = t->next;
    };
    log (LOG_DEBUG, "%s : No such call %d to hang up.\n", __FUNCTION__, cid);
    return;
}

void lac_disconnect (int tid)
{
    struct 	tunnel 	*t = tunnels.head;
    struct	call	*call_ptr;
    FILE *fp;
    
    while (t)
    {
        if (t->ourtid == tid)
        {
            Nprintf("Disconnecting from %s, Local tunnel: %d, Remote tunnel: %d\n",IPADDY (t->peer.sin_addr), t->ourtid, t->tid);
            t->self->needclose = -1;
            strcpy (t->self->errormsg, "Goodbye!");
            call_close (t->self);
            #ifdef FOR_DEBUG
            	printf("l2tpd: lac_disconnect: modify_ui_files status 0\r\n");
            #endif
            fflush (stderr);
            modify_ui_files (0, amit_ui_no,IPADDY (t->peer.sin_addr), t->ourtid, 0, 2);
            
            fflush (stderr);
            return;
        }
        t = t->next;
    };
    log (LOG_DEBUG, "%s: No such tunnel %d to hang up.\n", __FUNCTION__, tid);
    return;
}

struct tunnel *new_tunnel ()
{
    struct tunnel *tmp = malloc (sizeof (struct tunnel));
    if (!tmp)
        return NULL;
    tmp->control_seq_num = 0;
    tmp->control_rec_seq_num = 0;
    tmp->cLr = 0;
    tmp->call_head = NULL;
    tmp->next = NULL;
    tmp->debug = -1;
    tmp->tid = -1;
    tmp->hello = NULL;
#ifndef TESTING
/*	while(get_call((tmp->ourtid = rand() & 0xFFFF),0,0,0)); */
#ifdef USE_KERNEL
    if (kernel_support)
        tmp->ourtid = ioctl (server_socket, L2TPIOCADDTUNNEL, 0);
    else
#endif
        tmp->ourtid = rand () & 0xFFFF;
#else
    tmp->ourtid = 0x6227;
#endif
    tmp->nego = 0;
    tmp->count = 0;
    tmp->state = 0;             /* Nothing */
    tmp->peer.sin_family = AF_INET;
    tmp->peer.sin_port = 0;
    bzero (&(tmp->peer.sin_addr), sizeof (tmp->peer.sin_addr));
    tmp->sanity = -1;
    tmp->qtid = -1;
    tmp->ourfc = ASYNC_FRAMING | SYNC_FRAMING;
    tmp->ourbc = 0;
    tmp->ourtb = (((_u64) rand ()) << 32) | ((_u64) rand ());
    tmp->fc = -1;               /* These really need to be specified by the peer */
    tmp->bc = -1;               /* And we want to know if they forgot */
    tmp->hostname[0] = 0;
    tmp->vendor[0] = 0;
    tmp->secret[0] = 0;
    if (!(tmp->self = new_call (tmp)))
    {
        free (tmp);
        return NULL;
    };
    tmp->ourrws = DEFAULT_RWS_SIZE;
    tmp->self->ourfbit = FBIT;
    tmp->lac = NULL;
    tmp->lns = NULL;
    tmp->chal_us.state = 0;
    tmp->chal_us.secret[0] = 0;
    memset (tmp->chal_us.reply, 0, MD_SIG_SIZE);
    tmp->chal_them.state = 0;
    tmp->chal_them.secret[0] = 0;
    memset (tmp->chal_them.reply, 0, MD_SIG_SIZE);
    tmp->chal_them.vector = (unsigned char *) malloc (VECTOR_SIZE);
    tmp->chal_us.vector = NULL;
    tmp->hbit = 0;
    return tmp;
}

void do_control ()
{
    char 	buf1[128];
    char	*buf;
    char *host;
    char *tunstr;
    char *callstr;

	char 			ui_str[4];
    char 			*ui_ptr;
    int 			j = 0;
    struct tunnel 	*tptr;        //2k3-4-16
    char 			*uptr;

    char *sub_str;              /* jz: use by the strtok function */
    char *tmp_ptr;              /* jz: use by the strtok function */
    struct lac *lac;
    int call;
    int tunl;
    int size;
    int cnt = -1;
    unsigned char	have_command = 0;
    int				str128_ptr = 128;
    char			*cp;
        
    struct call *call_ptr;
    
    buf = buf1;
    
    while (cnt)
    {
    	have_command = 0;
    	if (str128_ptr < 126) 
    	{
    		have_command = 1; 
    		buf += str128_ptr;
    	} else {
			memset(buf,0x00,sizeof (buf1));
			cnt = read (control_fd, buf, sizeof (buf1)); 
			if (cnt <= 0) break;
			if (cnt < 127) buf[cnt] = 0x00; else buf[127] = 0x00;
			have_command = 1; str128_ptr = 0;
			#ifdef FOR_DEBUG
				printf("l2tpd: read from control pipe: %s\r\n",buf);
			#endif
		}

		cp = strtok(buf,"\n");
		cp = strtok(NULL,"\n");
		if (cp == NULL) 
			str128_ptr = 128; 
		else 
			str128_ptr = (unsigned long)(cp) - (unsigned long)(buf);
        //if (buf[cnt - 1] == '\n') buf[--cnt] = 0;
    	#ifdef FOR_DEBUG
    		printf("---------------------------------------------------------------------------------------------\r\n");
    		printf("l2tpd: do_control: Current process command is %s\r\n",buf);
    		if (str128_ptr == 128)
    			printf("                   Left commands are NULL\r\n");
    		else
    			printf("                   Left commands (at position %d) are %s\r\n",str128_ptr,buf+str128_ptr);
    		printf("---------------------------------------------------------------------------------------------\r\n");
    		system("ps");
    		printf("---------------------------------------------------------------------------------------------\r\n");
    		system("ifconfig");
    		printf("---------------------------------------------------------------------------------------------\r\n");
    	#endif
    	#if 0
			log (LOG_DEBUG, "%s: Got message %s (%d bytes long)\n",
             	__FUNCTION__, buf, cnt);
        #endif		
		
        switch (buf[0])
        {
	        case 't':
	
	            /*
	             *  Format:
	             *  echo "t USERNAME UI_NO  FLAG  Peer_IP" > /var/run/l2tp-control
	             */
	
	            // get USERNAME
				
				
				
	            uptr = strchr (buf, ' ') + 1;
	            for (j = 0; (*uptr != ' '); j++, uptr++)
	            {
	                if (j == 20)
	                    break;
	                ppp_name[j] = *uptr;
	            }
	            if (j >= 20)
	            {
	                Nprintf("username too long (>15) !\n");
	                #ifdef FOR_DEBUG
	                	printf("l2tpd: do_conreol: write_csf status 0\r\n");
	                #endif
	                //LAC
	                write_csf (0, amit_ui_no, "NULL", 0, 0, LAC);
	                exit (-1);
	            }
	            ppp_name[j] = 0;
	
	            // get UI_NO
	
	            ui_ptr = uptr + 1;
	            //ui_ptr = strchr (buf, ' ') + 1;
	
	            for (j = 0; *ui_ptr != ' '; j++, ui_ptr++)
	            {
	                ui_str[j] = *ui_ptr;
	            }
	            ui_str[j] = 0;
	            //LAC
	            amit_ui_no = atoi (ui_str) - MAX_NO_ACCOUNT_POOL;       //       
	
				out_of_order_flag[amit_ui_no] = 0;        //rotor
				
				#ifdef FOR_DEBUG
					printf("l2tpd: do_control: out_of_order_flag[%d]->%d\r\n",amit_ui_no,out_of_order_flag[amit_ui_no]);
				#endif
	            /*  Husjp ask l2tpd to receive a paramter 0/1 denotes 
	             *  "idle 300" and "autoreconnect"
	             */
	            ui_ptr++;
	            ui_str[0] = *(ui_ptr);
	            ui_str[1] = 0;
	            autoreconnect = atoi (ui_str);
	
	            // get Peer_IP
	
	            host = ui_ptr + 2;
	            #if 0
	            //added by rotor start
	                size = snprintf(host_ip,22,"%s",host);
	        		*(host_ip+size)=0;
	        		size = 0;
	        	#endif
	                
	            #ifdef FOR_DEBUG
	            	printf("l2tpd: do_control: user name=%s, ui no=%d, auto reconnect=%d, host=%s\r\n",
	            			ppp_name,amit_ui_no,autoreconnect,host);
	            #endif           
	
				#if 0
	            log (LOG_DEBUG, "%s: Attempting to tunnel to %s\n",
	                 __FUNCTION__, host);
				#endif
				
				#ifdef FOR_DEBUG
	            	printf("l2tpd: do_control: Write_csf status 99\r\n");
	            #endif
	            //LAC
	            write_csf (99, amit_ui_no, host, 0, 0, LAC);
	            
	            tptr = l2tp_call (host, UDP_LISTEN_PORT, NULL, NULL);
	            
	            if (tptr == NULL)
	            {
	            	#ifdef FOR_DEBUG
	            		printf("l2tpd: do_control: write_csf status 0\r\n");
	            	#endif
	            	//LAC
	                write_csf (0, amit_ui_no, host, 0, 0, LAC);
	            }
	
	            break;
	        case 'c':
	
	            switch_io = 1;  /* jz: Switch for Incoming - Outgoing Calls */
	
	            tunstr = strchr (buf, ' ') + 1;
	            lac = laclist;
	            while (lac)
	            {
	                if (!strcasecmp (lac->entname, tunstr))
	                {
	                    lac->active = -1;
	                    lac->rtries = 0;
	                    if (!lac->c)
	                        magic_lac_dial (lac);
	                    else
	                        log (LOG_DEBUG,
	                             "%s: Session '%s' already active!\n",
	                             __FUNCTION__, lac->entname);
	                    break;
	                }
	                lac = lac->next;
	            }
	            if (lac)
	                break;
	            tunl = atoi (tunstr);
	            if (!tunl)
	            {
	                Nprintf("No such tunnel '%s'\n",tunstr);
	                break;
	            }
				#ifdef FOR_DEBUG
	                Nprintf("Attempting to call on tunnel %d\n",tunl);
				#endif
	                
				#ifdef FOR_DEBUG
					printf("l2tpd: do_control: write_csf status 99\r\n");
				#endif              
				//LAC
	            write_csf (99, amit_ui_no, 0, tunl, 0, LAC);
	    
				lac_call (tunl, NULL, NULL);       
	            break;
	
	        case 'o':          /* jz: option 'o' for doing a outgoing call */
	
	            switch_io = 0;  /* jz: Switch for incoming - outgoing Calls */
	
	            sub_str = strchr (buf, ' ') + 1;
	
	            tunstr = strtok (sub_str, " "); /* jz: using strtok function to get */
	            tmp_ptr = strtok (NULL, " ");   /*     params out of the pipe       */
	            strcpy (dial_no_tmp, tmp_ptr);
	
	            lac = laclist;
	            while (lac)
	            {
	                if (!strcasecmp (lac->entname, tunstr))
	                {
	                    lac->active = -1;
	                    lac->rtries = 0;
	                    if (!lac->c)
	                        magic_lac_dial (lac);
	                    else
	                        log (LOG_DEBUG,
	                             "%s: Session '%s' already active!\n",
	                             __FUNCTION__, lac->entname);
	                    break;
	                }
	                lac = lac->next;
	            }
	            if (lac)
	                break;
	            tunl = atoi (tunstr);
	            if (!tunl)
	            {
	                log (LOG_DEBUG, "%s: No such tunnel '%s'\n", __FUNCTION__,
	                     tunstr);
	                break;
	            }
				#ifdef FOR_DEBUG
	                log (LOG_DEBUG, "%s: Attempting to call on tunnel %d\n",
	                     __FUNCTION__, tunl);
				#endif
	            lac_call (tunl, NULL, NULL);
	            break;
	
	        case 'h':
	        
	            callstr = strchr (buf, ' ') + 1;
	            call = atoi (callstr);
				#ifdef FOR_DEBUG
	                log (LOG_DEBUG, "%s: Attempting to call %d\n", __FUNCTION__,call);
				#endif
				
				//added by rotor
				if(  set_ui_no( 2 ,call )>=LNS_UI_NO_BASE )
				{
					call_ptr->ui_no = amit_ui_no = set_ui_no( 2,call );
				}
				else
				{
					call_ptr->ui_no = amit_ui_no = (set_ui_no( 2,call )-MAX_NO_ACCOUNT_POOL);
			//		delete_iptable_rules( amit_ui_no );	 //don't need anymore mark by eric
				}
				
	            lac_hangup (call);
	            
	            usleep(500);	//wait for ppp die: hsujp
	            
	            break;
	            
	        case 'd':
	           
	            /*
	             * we do modify_ui_files() in lac_disconnect
	             * because we have to know peer IP
	             */
	    
	            tunstr = strchr (buf, ' ') + 1;
	            lac = laclist;
	            while (lac)
	            {
	                if (!strcasecmp (lac->entname, tunstr))
	                {
	                    lac->active = 0;
	                    lac->rtries = 0;
	                    if (lac->t)
	                    {
							#ifdef DEBUG_D_TUNNEL
	                            log (LOG_DEBUG,
	                                 "in while(lac), doing lac_disconnect\n");
							#endif
	                        lac_disconnect (lac->t->ourtid);
	                    }
	                    else
	                        log (LOG_DEBUG, "%s: Session '%s' not up\n",
	                             __FUNCTION__, lac->entname);
	                    break;
	                }
	                lac = lac->next;
	            }
	            if (lac)
	                break;
	            tunl = atoi (tunstr);
	            if (!tunl)
	            {
	                log (LOG_DEBUG, "%s: No such tunnel '%s'\n", __FUNCTION__,
	                     tunstr);
	                break;
	            }
				#ifdef FOR_DEBUG
	                log (LOG_DEBUG, "%s: Attempting to disconnect tunnel %d\n",
	                     __FUNCTION__, tunl);
	                log (LOG_LOG, "%s: Attempting to disconnect tunnel %d\n",
	                     __FUNCTION__, tunl);
				#endif
	
				#ifdef DEBUG_D_TUNNEL
	                log (LOG_DEBUG, "before lac_disconnect...\n");
				#endif
	            lac_disconnect (tunl);
				#ifdef DEBUG_D_TUNNEL
	                log (LOG_DEBUG, "after lac_disconnec...\n");
				#endif
	
	            break;
	
	        case 's':
	
	            show_status ();
	
	            break;
	        default:
	            log (LOG_DEBUG, "%s: Unknown command %c\n", __FUNCTION__,
	                 buf[0]);
        }
    }
    
    /* Otherwise select goes nuts */
    #if 0	//marked by Lily, to avoid reopen fifo and get the same command!! --- 20040112
	    close (control_fd);
	    control_fd = open (CONTROL_PIPE, O_RDONLY | O_NONBLOCK, 0600);
	#endif
	#if 0
	    printf("l2tpd: do_control: end of do_control\r\n");
	#endif
	
}

void usage (void)
{
//@@@ub wnlee 2k3-4-18  
    fprintf
        (stderr,
         "Usage: l2tpd -D -c [config file] -s [secret file] -p [pid file]\n");
    fprintf (stderr, "\n");
//@@@ue    
    exit (1);

}

void init_args (int argc, char *argv[])
{
    int i = 0;
    gconfig.daemon = 1;
    memset (gconfig.altauthfile, 0, STRLEN);
    memset (gconfig.altconfigfile, 0, STRLEN);
    memset (gconfig.authfile, 0, STRLEN);
    memset (gconfig.configfile, 0, STRLEN);
    memset (gconfig.pidfile, 0, STRLEN);
    strncpy (gconfig.altauthfile, ALT_DEFAULT_AUTH_FILE,
             sizeof (gconfig.altauthfile) - 1);
    strncpy (gconfig.altconfigfile, ALT_DEFAULT_CONFIG_FILE,
             sizeof (gconfig.altconfigfile) - 1);
    strncpy (gconfig.authfile, DEFAULT_AUTH_FILE,
             sizeof (gconfig.authfile) - 1);
    strncpy (gconfig.configfile, DEFAULT_CONFIG_FILE,
             sizeof (gconfig.configfile) - 1);
    strncpy (gconfig.pidfile, DEFAULT_PID_FILE, sizeof (gconfig.pidfile) - 1);
    for (i = 1; i < argc; i++)
    {
        if (!strncmp (argv[i], "-c", 2))
        {
            if (++i == argc)
                usage ();
            else
                strncpy (gconfig.configfile, argv[i],
                         sizeof (gconfig.configfile) - 1);
        }
        else if (!strncmp (argv[i], "-D", 2))
        {
            gconfig.daemon = 0;
        }
        else if (!strncmp (argv[i], "-s", 2))
        {
            if (++i == argc)
                usage ();
            else
                strncpy (gconfig.authfile, argv[i],
                         sizeof (gconfig.authfile) - 1);
        }
        else if (!strncmp (argv[i], "-p", 2))
        {
            if (++i == argc)
                usage ();
            else
                strncpy (gconfig.pidfile, argv[i],
                         sizeof (gconfig.pidfile) - 1);
        }
        else
        {
            usage ();
        }
    }
}


void daemonize ()
{
    int		pid = 0;
    int 	i, l;
    char 	buf[STRLEN];
    int 	pidfilewritten = 0;

	#ifdef FOR_DEBUG
		printf("l2tpd: daemonize: Enter daemonize!\r\n");
	#endif
	
    if ((pid = fork ()) < 0)
    {
    	#ifdef FOR_DEBUG
			printf("l2tpd: daemonize: (pid = fork ()) < 0!\r\n");
		#endif
        Nprintf("Unable to fork ()\n");
        close (server_socket);
        #ifdef FOR_DEBUG
        	printf("l2tpd: daemonize: close (server_socket) over\r\n");
        #endif
        exit (1);
    }
    else if (pid)
        exit (0);

//@@@ub wnlee 2k2-10-5  
    /* according to version 0.69 bugfix (see V0.69 CHANGELOG) */
    /*close(0); */
//@@@ue
#if 0
	close (1);

    close (2);
#endif

    /* Read previous pid file. */
    if ((i = open (gconfig.pidfile, O_RDONLY)) > 0)
    {
        l = read (i, buf, sizeof (buf) - 1);
        if (i < 0)
        {
            Nprintf("Unable to read pid file [%s]\n",gconfig.pidfile);
        }
        buf[i] = '\0';
        pid = atoi (buf);

        /* If the previous server process is not still running,
           write a new pid file immediately. */
        if (pid && (pid == getpid () || kill (pid, 0) < 0))
        {
            unlink (gconfig.pidfile);
            #ifdef FOR_DEBUG
            	printf("l2tpd: daemonize: Read previous pid file unlink (gconfig.pidfile) over\r\n");
            #endif
            if ((i = open (gconfig.pidfile, O_WRONLY | O_CREAT, 0640)) >= 0)
            {
                snprintf (buf, sizeof (buf), "%d\n", (int) getpid ());
                write (i, buf, strlen (buf));
                close (i);
                pidfilewritten = 1;
            }
        }
        else
        {
            Nprintf("There's already a l2tpd server running.\n");
            close (server_socket);
            exit (1);
        }
    }

    pid = setsid ();

    if (!pidfilewritten)
    {
        unlink (gconfig.pidfile);
        if ((i = open (gconfig.pidfile, O_WRONLY | O_CREAT, 0640)) >= 0)
        {
            snprintf (buf, strlen (buf), "%d\n", (int) getpid ());
            write (i, buf, strlen (buf));
            close (i);
            pidfilewritten = 1;
        }
    }
}



void init (int argc, char *argv[])
{
    struct		lac *lac;
    DIR			*dirh;
    FILE		*fd;
    struct 		stat sbuf;
   
   	#ifdef FOR_DEBUG
   		printf("l2tpd: init: Enter init.\r\n");
   	#endif
   	
    init_args (argc, argv);
    #ifdef FOR_DEBUG
   		printf("l2tpd: init: init_args over.\r\n");
   	#endif
   	
    init_addr ();
    #ifdef FOR_DEBUG
   		printf("l2tpd: init: init_addr over.\r\n");
   	#endif
   	
    if (init_config ())
    {
        Nprintf("Unable to load config file\n");
        exit (1);
    }
    if (uname (&uts))
    {
        Nprintf("Unable to determine host system\n");
        exit (1);
    }
    
    init_tunnel_list (&tunnels);
    #ifdef FOR_DEBUG
   		printf("l2tpd: init: init_tunnel_list over.\r\n");
   	#endif
   	
    if (init_network())
    {
    	#ifdef FOR_DEBUG
   			printf("l2tpd: init: init_network and exit(1)\r\n");
   		#endif
        exit (1);
    }
    
    if (gconfig.daemon)
    {
    	#ifdef FOR_DEBUG
   			printf("l2tpd: init: gconfig.daemon over.\r\n");
   		#endif
        daemonize ();
    }

    
    signal (SIGTERM, &death_handler);
    #ifdef FOR_DEBUG
   		printf("l2tpd: init: signal (SIGTERM, &death_handler).\r\n");
   	#endif
    signal (SIGINT, &death_handler);
    #ifdef FOR_DEBUG
   		printf("l2tpd: init: signal (SIGINT, &death_handler).\r\n");
   	#endif
    signal (SIGCHLD, &child_handler);
    #ifdef FOR_DEBUG
   		printf("l2tpd: init: signal (SIGCHLD, &child_handler).\r\n");
   	#endif
    signal (SIGUSR1, &status_handler);
    #ifdef FOR_DEBUG
   		printf("l2tpd: init: signal (SIGUSR1, &status_handler).\r\n");
   	#endif
   	
//ppp intface up, ppp should notify l2tpd by sending SIGUSR2 signal                   
    signal (SIGUSR2, &pppifup_handler);
    #ifdef FOR_DEBUG
   		printf("l2tpd: init: signal (SIGUSR2, &pppifup_handler).\r\n");
   	#endif
    signal (SIGHUP, &null_handler);
    #ifdef FOR_DEBUG
   		printf("l2tpd: init: signal (SIGHUP, &null_handler).\r\n");
   	#endif
   	
    init_scheduler ();
    #ifdef FOR_DEBUG
   		printf("l2tpd: init: init_scheduler over.\r\n");
   	#endif
   	
	remove (CONTROL_PIPE);	//Lily: e@Ӥp߳Q echo XӪD fifo 
    mkfifo (CONTROL_PIPE, 0600);
    control_fd = open (CONTROL_PIPE, O_RDONLY | O_NONBLOCK, 0600);
    if (control_fd < 0)
    {
        Nprintf("Unable to open \"L2TP CONTROL_PIPE\" for reading.\n");
        exit (1);
    }
    
    #if 0
    log (LOG_LOG, "l2tpd version " SERVER_VERSION " started on %s PID:%d\n",
         hostname, getpid ());
    log (LOG_LOG,
         "Written by Mark Spencer, Copyright (C) 1998, Adtran, Inc.\n");
    log (LOG_LOG, "Forked by Scott Balmos and David Stipp, (C) 2001\n");
	/* update brecis l2tpd from 0.67 to 0.69 without updating rand() */
    log (LOG_LOG, "Brecis version by wnlee@god.csie.ncku.edu.tw, (C) 2k2\n");    
    log (LOG_LOG, "%s version %s on a %s, port %d\n", uts.sysname,
         uts.release, uts.machine, gconfig.port);
    #endif

//@@@ib wnlee 2k2/10/26
/*
 *  make sure (that) LNS_DIR and LAC_DIR are exist.
 */
  open_lac:
    dirh = opendir (LAC_DIR);
    if (dirh == NULL)
    {
        if (errno == ENOENT)
        {
            mkdir (LAC_DIR, 700);
        }
        else if (errno == EMFILE || errno == ENOMEM)
            goto open_lac;
        else
        {
            Nprintf("can create %s\n", LAC_DIR);
            exit (1);
        }

    }
    else
        closedir (dirh);
  open_lns:
    dirh = opendir (LNS_DIR);
    if (dirh == NULL)
    {
        if (errno == ENOENT)
        {
            mkdir (LNS_DIR, 700);
        }
        else if (errno == EMFILE || errno == ENOMEM)
            goto open_lns;
        else
        {
            Nprintf("can create %s\n", LNS_DIR);
            exit (1);
        }

    }
    else
        closedir (dirh);
/*
 *  make sure a null /var/config/l2tp-secrets exists
 *
 */
    if (stat (DEFAULT_AUTH_FILE, &sbuf) == -1)
    {
        fd = fopen (DEFAULT_AUTH_FILE, "w");
        fprintf (fd,
                 "# wnlee@ncku\n# We preserv this file in order to keep the original program architecure unchanged\n#\n");
        fclose (fd);
    }
//@@@ie         
    lac = laclist;
    while (lac)
    {
        if (lac->autodial)
        {
#ifdef DEBUG_MAGIC
            log (LOG_DEBUG, "%s: Autodialing '%s'\n", __FUNCTION__,
                 lac->entname[0] ? lac->entname : "(unnamed)");
#endif
            lac->active = -1;
            switch_io = 1;      /* If we're a LAC, autodials will be ICRQ's */
            magic_lac_dial (lac);
        }
        lac = lac->next;
    }
}

int main (int argc, char *argv[])
{
	int pid;
	FILE *fp;

	fp = fopen("/var/run/l2tpd.pid", "r");
	if(fp != NULL)
	{
		Dprintf("l2tpd: kill priveous l2tpd\n");
		fscanf(fp, "%d", &pid);
		fclose(fp);
		kill(pid, 15);
	}
	fp = fopen("/var/run/l2tpd.pid", "w");
	if(fp == NULL)
	{
		Dprintf("l2tpd: cant open pid file\n");
		exit(0);
	}
	else
	{
		fprintf(fp, "%d", getpid());
		fclose(fp);
	}
	
	Dprintf("l2tpd: Enter l2tpd\r\n");
	
	openlog (BINARY, LOG_ODELAY, LOG_DAEMON);
	Dprintf("l2tpd: Open log over\r\n");
	
    init (argc, argv);
	Dprintf("l2tpd: Initialize over based on arguments\r\n");
	
    dial_no_tmp = calloc (128, sizeof (char));
    network_thread ();
	Dprintf("l2tpd: network_thread over\r\n");
	
    return 0;
}

int set_ui_no( int type ,int id )
{
	struct 	dirent *dirp;
    char	aim_filename[100];
    FILE	*fd;
    char	c_temp[100];
    int		index;
    char	l2tp_ui_str[100];
    DIR 	*dirh;
    int 	size;
	
	if( type==1 )	//tid
	{
		if ((dirh = opendir("/var/run/l2tpc")) == NULL)
    	{
        	#ifdef FOR_DEBUG
        		printf("CGI: l2tps: opendir /var/run/l2tpc failed\r\n");
        	#endif
    	}
    	else
    	{
    		for (dirp = readdir (dirh); dirp != NULL; dirp = readdir (dirh))
        	{
        		if (!strcmp (dirp->d_name, "."))
            		continue;
            	if (!strcmp (dirp->d_name, ".."))
            		continue;
            	bzero(aim_filename,100);
            	sprintf(aim_filename,"/var/run/l2tpc/%s",dirp->d_name);
            	if( (fd=fopen(aim_filename,"r"))!=NULL )
            	{
            		bzero(c_temp,100);
               		fgets(c_temp,sizeof(c_temp),fd);
                	bzero(c_temp,100);
                	fgets(c_temp,sizeof(c_temp),fd);
                	
               		if( id!=atoi(c_temp) )
               		{
               			fclose(fd);
               			continue;
               		}
               		bzero(aim_filename,100);
               		size =0;
               		size = snprintf(aim_filename,99,dirp->d_name);
					*(aim_filename+size)=0;
					bzero(l2tp_ui_str,100);						
					for( index =0; aim_filename[index+5]!='\0'; index++ )
					{
						l2tp_ui_str[index] = aim_filename[index+5];
					}
					*(l2tp_ui_str+index)=0;
					#ifdef FOR_DEBUG
						printf("l2tpd: set_ui_no(c): l2tp_ui_str:%s\r\n",l2tp_ui_str);
					#endif
					return atoi(l2tp_ui_str);
							
	            }
            	else
            	{
                	#ifdef FOR_DEBUG
                		printf("l2tpd: do_control: open %s failed\r\n",aim_filename);
                	#endif
                	continue;
            	}
        	}
    	}
    
    	if ((dirh = opendir("/var/run/l2tpd")) == NULL)
    	{
        	#ifdef FOR_DEBUG
        		printf("CGI: l2tps: opendir /var/run/l2tpd failed\r\n");
        	#endif
    	}
    	else
    	{
    		for (dirp = readdir (dirh); dirp != NULL; dirp = readdir (dirh))
        	{
        		if (!strcmp (dirp->d_name, "."))
            		continue;
            	if (!strcmp (dirp->d_name, ".."))
            		continue;
            	bzero(aim_filename,100);
            	sprintf(aim_filename,"/var/run/l2tpd/%s",dirp->d_name);
            	if( (fd=fopen(aim_filename,"r"))!=NULL )
            	{
            		bzero(c_temp,100);
               		fgets(c_temp,sizeof(c_temp),fd);
                	bzero(c_temp,100);
                	fgets(c_temp,sizeof(c_temp),fd);
                	
                	if( id!=atoi(c_temp) )
                	{
                		fclose(fd);
                		continue;
                	}
                	bzero(aim_filename,100);
                	size =0;
                	size = snprintf(aim_filename,99,dirp->d_name);
					*(aim_filename+size)=0;
					bzero(l2tp_ui_str,100);
					for( index =0; aim_filename[index+5]!='\0'; index++ )
					{
						l2tp_ui_str[index] = aim_filename[index+5];
					}
					*(l2tp_ui_str+index)=0;
					#ifdef FOR_DEBUG
						printf("l2tpd: set_ui_no(s): l2tp_ui_str:%s\r\n",l2tp_ui_str);
					#endif
					return atoi(l2tp_ui_str);
							
            	}
            	else
            	{
                	#ifdef FOR_DEBUG
                		printf("l2tpd: do_control: open %s failed\r\n",aim_filename);
                	#endif
                	continue;
            	}
        	}
    	}
    }
    else if( type==2 )	//cid
    {
    	if ((dirh = opendir("/var/run/l2tpc")) == NULL)
    	{
        	#ifdef FOR_DEBUG
        		printf("CGI: l2tps: opendir /var/run/l2tpc failed\r\n");
        	#endif
    	}
    	else
    	{
    		for (dirp = readdir (dirh); dirp != NULL; dirp = readdir (dirh))
        	{
        		if (!strcmp (dirp->d_name, "."))
            		continue;
            	if (!strcmp (dirp->d_name, ".."))
            		continue;
            	bzero(aim_filename,100);
            	sprintf(aim_filename,"/var/run/l2tpc/%s",dirp->d_name);
            	if( (fd=fopen(aim_filename,"r"))!=NULL )
            	{
            		bzero(c_temp,100);
               		fgets(c_temp,sizeof(c_temp),fd);
                	bzero(c_temp,100);
                	fgets(c_temp,sizeof(c_temp),fd);
                	bzero(c_temp,100);
               		fgets(c_temp,sizeof(c_temp),fd);
               		if( id!=atoi(c_temp) )
               		{
               			fclose(fd);
               			continue;
               		}
               		bzero(aim_filename,100);
               		size =0;
               		size = snprintf(aim_filename,99,dirp->d_name);
					*(aim_filename+size)=0;
					bzero(l2tp_ui_str,100);						for( index =0; aim_filename[index+5]!='\0'; index++ )
					{
						l2tp_ui_str[index] = aim_filename[index+5];
					}
					*(l2tp_ui_str+index)=0;
					#ifdef FOR_DEBUG
						printf("l2tpd: set_ui_no(c): l2tp_ui_str:%s\r\n",l2tp_ui_str);
					#endif
					return atoi(l2tp_ui_str);
							
	            }
            	else
            	{
                	#ifdef FOR_DEBUG
                		printf("l2tpd: do_control: open %s failed\r\n",aim_filename);
                	#endif
                	continue;
            	}
        	}
    	}
    
    	if ((dirh = opendir("/var/run/l2tpd")) == NULL)
    	{
        	#ifdef FOR_DEBUG
        		printf("CGI: l2tps: opendir /var/run/l2tpd failed\r\n");
        	#endif
    	}
    	else
    	{
    		for (dirp = readdir (dirh); dirp != NULL; dirp = readdir (dirh))
        	{
        		if (!strcmp (dirp->d_name, "."))
            		continue;
            	if (!strcmp (dirp->d_name, ".."))
            		continue;
            	bzero(aim_filename,100);
            	sprintf(aim_filename,"/var/run/l2tpd/%s",dirp->d_name);
            	if( (fd=fopen(aim_filename,"r"))!=NULL )
            	{
            		bzero(c_temp,100);
               		fgets(c_temp,sizeof(c_temp),fd);
                	bzero(c_temp,100);
                	fgets(c_temp,sizeof(c_temp),fd);
                	bzero(c_temp,100);
                	fgets(c_temp,sizeof(c_temp),fd);
                	if( id!=atoi(c_temp) )
                	{
                		fclose(fd);
                		continue;
                	}
                	bzero(aim_filename,100);
                	size =0;
                	size = snprintf(aim_filename,99,dirp->d_name);
					*(aim_filename+size)=0;
					bzero(l2tp_ui_str,100);
					for( index =0; aim_filename[index+5]!='\0'; index++ )
					{
						l2tp_ui_str[index] = aim_filename[index+5];
					}
					*(l2tp_ui_str+index)=0;
					#ifdef FOR_DEBUG
						printf("l2tpd: set_ui_no(s): l2tp_ui_str:%s\r\n",l2tp_ui_str);
					#endif
					return atoi(l2tp_ui_str);
							
            	}
            	else
            	{
                	#ifdef FOR_DEBUG
                		printf("l2tpd: do_control: open %s failed\r\n",aim_filename);
                	#endif
                	continue;
            	}
        	}
    	}
    }
}


void delete_iptable_rules( int ui_number )
{
	char command[100];
    char pppno_file[23];
    char pppno[23];
	FILE *fd;
	int index;
	char LAN_net_id[32];
//	char link_status_file[100];
	
//	bzero(link_status_file,100);
//	sprintf(link_status_file ,"/var/config/ppp/l2tpc.%d", (ui_number+MAX_NO_ACCOUNT_POOL));
//    if( (fd = fopen(link_status_file ,"r"))!=NULL )
//    {
//        bzero(c_temp,23);
//        fgets(c_temp, sizeof(c_temp), fd);
//        bzero(c_temp,23);
//        fgets(c_temp, sizeof(c_temp), fd);
//        bzero(c_temp,23);
//        fgets(c_temp, sizeof(c_temp), fd);
//        fclose(fd);
        
//        if( atoi(c_temp)==1 )
//        {
        	bzero(pppno_file,23);
			sprintf(pppno_file,"/var/config/ppp/pppd.%d",(ui_number+MAX_NO_ACCOUNT_POOL));
			#ifdef FOR_DEBUG
				printf("l2tpd: modify_ui_no: pppno_file:%s\r\n",pppno_file);
			#endif
			if( (fd=fopen(pppno_file,"r"))!=NULL )
			{
				fgets(pppno,sizeof(pppno),fd);
				fgets(pppno,sizeof(pppno),fd); pppno[sizeof(pppno)-1] = '\n';
				for( index=0; pppno[index]!='\n'; index++ ) {}
				*(pppno+index)=0;
				fclose(fd);
				if ((fd = fopen("/var/run/LAN_net_id","r")) != NULL)
				{
					fgets(LAN_net_id,sizeof(LAN_net_id),fd);
					fclose(fd);
					sprintf(command,"iptables -t nat -D POSTROUTING -o %s -s %s -j MASQUERADE",pppno,LAN_net_id);
					#ifdef FOR_DEBUG
						printf("l2tpd: modify_ui_no: pppno: command:%s\r\n",command);
					#endif
					system(command);
				}
			}
			else
			{
				#ifdef FOR_DEBUG
					printf("l2tpd: delete_iptable_rules: open %s failed\r\n",pppno_file);
				#endif
			}
			#ifdef FOR_DEBUG
				printf("l2tpd: modify_ui_files: pppno:%s\r\n",pppno);
			#endif
//        }
//	}
}

void reset_pppserver_gateway(void)
{
	FILE *fp;
	unsigned long gateway;
	short gw_ip[4]; 
	char server_ip[20],temp[20];
	char command[120];
	int i;

	fp = fopen("/var/run/l2tpc/l2tp_wantype_info","r");
	if( fp!= NULL ) {		//check wantype and get server ip
		for(i=0;i<3;i++){
			fgets(temp,sizeof(temp) ,fp );
		}
		strncpy(server_ip,temp, (strlen(temp)-1) );	
		fclose(fp);
	    gateway = getWANroute(WANPORTNAME);
		for(i=0;gateway>0;i++){         //paser gateway ip
			gw_ip[i]=gateway%256;
			gateway /= 256;
		}
		sprintf(command,"route add -host %s gw %d.%d.%d.%d dev %s",server_ip
																  ,gw_ip[3],gw_ip[2],gw_ip[1],gw_ip[0]
									                              ,WANPORTNAME);
		system(command);        //add l2tp server routing to routing table
	}
	else{ return; }
}


void restart_l2tpd(void)
{
	FILE *fp,*new_fp;
	int i;
	char tmp_str[100];
	
	/*add for L2TP WANTYPE */
    fp = fopen("/var/run/l2tpc/l2tp_wantype_info","r");
	if(fp!=NULL){
		fclose(fp);
		new_fp = fopen("/var/run/l2tpc/l2tp_wanttype_info_new","w");
		for(i=0;i<6;i++){       //copy unchange section ,we only correct force_connect bit
			fgets(tmp_str,sizeof(tmp_str),fp);
			if(i==0 && atoi(tmp_str!=4)){ return; }	//check l2tpwantype
			else{printf("wantype = %s \n",tmp_str);}
			fprintf(new_fp,"%s",tmp_str);
		}
		fprintf(new_fp,"0\n");
		fclose(fp);fclose(new_fp);

        /*create relaunch l2tp script file */
		fp = fopen("/var/rel2tp.sh","w");
		fprintf(fp,"#!/bin/sh\n");
		fprintf(fp,"killall l2tpd\n");
		fprintf(fp,"l2tpd -D&\n");
		fprintf(fp,"rm -f /var/rel2tp.sh");
		fclose(fp);
		system("chmod 755 /var/rel2tp.sh");
		system("/var/rel2tp.sh");
	}		
}
