/* commonly used type */
#define BYTE            unsigned char
#define WORD            unsigned short
#define DWORD           unsigned long

/*********************/
/* for configuration */
/*********************/

/* ODM customization BEGIN */
#define SMAP_NUM        26      /* default 8, no limit */
#define SPAP_NUM        16      /* default 4, limit:only 1.5K CGI buffer */
#define SPAP_SEPL_NUM   64      /* default 20: 21*SPAP_NUM+14*SPAP_SEPL_NUM */
#define AGRP_NUM        8       /* default 4, limit:only 1.5K CGI buffer */
#define AGRP_PORTS      32      /* default 20  */
#define PMAC_NUM        64      /* default 32  */
/* ODM customization END */

#define PF_RULE_NUM     8       /* number packet filter rules */
#define VIRUS_PATTERN_NUM 50    /* number of virus pattern in ids */
/* when this structure is changed, please review side-effect in
   CGI.C. Which items must take effect after setup? */
typedef struct {
    /* (8) header of configuration data */
    struct {
        BYTE    ver[4];
        WORD    chksum;
        WORD    size;
    } header;
    /* (64) local configuration */
    struct {
        BYTE    ip[4];          /* important, recovering mode use it */
        char    host[16];
        char    pass[10];
        BYTE    wip[4];//WAN IP
        BYTE    wgw[4];//WAN Getway
        BYTE    wnm[4];//WAN Netmask
        BYTE    rhip[4];//Local IP
        BYTE    rhnm[4];//DNS
        BYTE    uwid[6];//Local Netmask
        WORD    wflag;//DMZ Enable
        BYTE    wtype;//WAN Type
        BYTE    dmz_host;//DMZ host
        WORD    adm_to;         /* din_to; */
        BYTE    buivar;         /* din_ip; */
        BYTE    wtypex;         /* din_auth; */
    } local;
    /* (544) reserved */
    char resv544[544];
    /* (512) ip flag */
    struct {
        WORD    val[256];
    } flag;
#ifdef SIP
    /* (64) 16*4 lan */
    struct {
        DWORD   baud;
        char    resv[12];
    } lan[4];
#else
    /* (64) dhcp */
    struct {
        char    domain[32];
        char    resv1[20];
        BYTE    netmask[4];
        BYTE    enable;
        BYTE    range[2];
        char    resv2;
        char    gwip[4];        /* for CyberChannel only */
    } dhcp;
#endif
    /* (156) 6*26, server mapping */
    struct {
        WORD    port;
        WORD    uport;
        BYTE    host;
        BYTE    flag;
    } smap[SMAP_NUM];         /* 26 */
    /* (384) 8*16+4*64, special application */
    struct {
        struct {
                WORD port;
                WORD downcount;
                BYTE sp0;
                BYTE sp1;
                BYTE flag;
                BYTE host;
        } trig[SPAP_NUM];       /* 16 */
        struct {
                WORD lb;
                WORD ub;
        } sepl[SPAP_SEPL_NUM];  /* 64, Subsequence Enable Port List */
    } spap;
    /* (576) (8+2*32)*8, access control */
union {
    struct {
        BYTE    type;
        BYTE    count;
        WORD    ports[AGRP_PORTS];      /* 32 */
        BYTE    resv[6];
    } agrp[AGRP_NUM];           /* 8 */
    struct {
        struct {
            DWORD       ip0[2];         /* 0 for outbound, 1 for inbound */
            DWORD       ip1[2];
            WORD        port0[2];
            WORD        port1[2];
            DWORD       dresv;
            WORD        rflag;          /* rule flag */
            WORD        t_index;        /* temp var to record original rule index */
        } rule[PF_RULE_NUM*2];
        WORD    flag[2];
        char    resv[56];
        int     t_count[2];
    } ipf;
} actl;
    /* (256) access point */
    struct{
        BYTE zn[26];/*network id*/
        BYTE zn_resv[39];
        BYTE zc;/*channel*/
        BYTE zi[4];/*ip address*/
        BYTE zs;/*security*/
        BYTE zk[5];/*security key*/
        BYTE zk_resv[27];
        BYTE ya;/*access control enable or disable*/
        BYTE yan;/*exist access control numbers already*/
        BYTE yg[4][6];/*granted MACs*/
        BYTE yg_resv[6][6];
        BYTE ygs;/*whether user input MACs or not for granting access control*/
        BYTE yd[4][6];/*denied MACs*/
        BYTE yd_resv[6][6];
        BYTE yds;/*whether user input MACs or not for denying access control*/
        BYTE yo;/*grant or deny other stations*/
        BYTE mac[6];
        BYTE broadcast;
        BYTE resv[21];
    } apnt;
    /* (520) 8+8*64 properties of MAC */
    struct {
        WORD flag;
        BYTE resv[6];
        struct {
            BYTE mac[6];
            BYTE ip;
            BYTE prop;
        } list[PMAC_NUM];  /* 64 */
    } pmac;
    /* (64) 6*5+34 local3 */
    struct {
        struct {
            BYTE    gip[4];     /* global IP */
            BYTE    lip;        /* local IP */
            BYTE    flag;
        } mnat[5];
        BYTE    resv[26];
        BYTE    acct[2];
        BYTE    wolmac[6];
    } local3;
    char        resv[500-64];
    /* (1536) 256x6, isp configuration */
    struct {
        char    desc[16];       /* DESCription */
        char    user[54];
        WORD    flag;
        char    pass[24];
        char    tel[32];
        struct {
                BYTE ip[4];
        } dns[2];
        BYTE    ip[4];
        DWORD   baud;
        WORD    mtu;
        WORD    to;
        char    init[82];
        char    resv[26];
    } acctpool[6];
    /* (16) DHCP Server configuration */
    struct {
        BYTE resv;
	BYTE enable;
	BYTE start;
	BYTE end;
	BYTE dns[4];
	int default_lease_time;
	int max_lease_time;
    }dhcps;
    /* (96) (48 + 36 + 4 + 4 + 2 + 2) PPPoE Setting */
    struct {
    	char id[48];	// USER-ID
	char passwd[36];// password
	BYTE dns1[4];	// DNS1
	BYTE dns2[4];	// DNS2
	WORD timeout;	// PPPOE_TIMEOUT
	char resv[2];
    } pppoe;
    /* (8) pptpd configuration */
    struct {
    	BYTE localIP[4];//pptp local IP
	BYTE start;//remote IP range start
	BYTE end;//remote IP range end
	BYTE enable;//pptpd enable
	BYTE resv;//reserved
    }pptp;
    /* (132) pppd configuration */
    struct {
    	char name1[16];//Name 1
	char pass1[16];//Password 1
	char name2[16];//Name 2
	char pass2[16];//Password 2
	char name3[16];//Name 3
	char pass3[16];//Password 3
	char name4[16];//Name 3
	char pass4[16];//Password 3
	BYTE pap;//pap enable
	BYTE chap;//chap enable
	BYTE mschap;//mschap enable
	BYTE mschap2;//mschap2 enable
    }pppd;
    /* (8) remote host */
    struct {
    	BYTE ip[4];//remote host address
	BYTE enable;//Enable or Disable
	BYTE resv[3];//reserve
    }remote_host;
    /* (400) (4+2*16+4*16)*4 access contral 2 for linux */
    struct {
    	BYTE flag;//enable
	BYTE resv[3];//reserve
	struct {
		BYTE sip;//start ip
		BYTE eip;//end ip
	}ip[16];
	struct{
		WORD sp;//strat port
		WORD ep;//end port
	}port[16];
   }actl2[4];/*4 Group*/
   /*(56) 28+4*5 l2tpd */
   struct {
   	struct {
		BYTE local_ip[4];//local virtual ip
		BYTE ip_range_from;//static IP pool: from-to
		BYTE ip_range_to;
		char name[10];// host name for pppd
		struct {
			BYTE ip[4];
		}no_lac[3];// deny IPs
	}lns;
	struct {
		BYTE peer[4];//lns ip
		char name[10];//name for pppd
		char pswd[10];
		//BYTE flag;//bit0: => autodial
		//BYTE resv;
	}lac[5];
   }l2tpd;
   /*(120)24*5 PPTP client*/
   struct {
   	char name[9];
	char pswd[9];
	BYTE ip[4];
	BYTE resv[2];
   }pptpc[5];
   /*()4+ IDS */
   struct{
   	BYTE flag[4];
	//(8004)4+100*80 url blocking
	struct {
		BYTE flag;
		BYTE resv;
		WORD proxy;
		struct {
			char string[80];
		}url[100];
	}urlblock;
	//(4200)84*50 virus pattern match
	struct {
		BYTE protocol;//0-> tcp, 1->udp
		BYTE resv;
		WORD port;
		char pattern[80];
	}virus[VIRUS_PATTERN_NUM];//50
	//(8)dns scan
	struct {
		BYTE wan_dns[4];
		BYTE resv[3];
		BYTE lan_dns;
	}dns_scan;
	//(4)malicious script
	WORD mscript_proxy;
	BYTE resv[2];
	//(8000)80*100 mail address block
	struct {
		char string[80];
	}mailblock[100];
	//(4)mail bomb2 flow block
	struct {
		WORD total_sender;
		WORD total_mails;
	}mbomb2;
   } ids;
   /*******************************************
       flag[0]			flag[1]
     1.Ping of Death		9.ICMP Unreachable
     2.Smurf			A.ping flooding
     3.Teardrop			B.DNS Scan
     4.Port Scan		C.http url block
     5.UDP Bomb			D.Malicious Script
     6.SYN Flooding		E.Virus
     7.Fraggle			F.Mail Bomb1(Advertisement)
     8.Land Attack		G.Mail Bomb2(Total number)
     *******************************************/
     //(1044) 4+80+80*3+40*20 send alert mail
     struct {
	BYTE enable;
	BYTE resv[3];
	char mail_from[80];
	struct {
		char mail_to[80];
	} list[3];
	struct {
		int lognum;
		char logname[35];
		BYTE emergency;
	} alert_table[20];
     } mailalert;
     /*alert table
     =====================
     1XX - Network Layer
     =====================
     101 - ping of death
     102 - tear drop
     103 - ping flood
     104 - smurf
     =====================
     2XX - Transport Layer
     =====================
     201 - port scan
     202 - fraggle
     203 - snork
     204 - land attack
     205 - udp bomb
     206 - DNS scan
     207 - ICMP unreachable
     =======================
     3XX - Application Layer
     =======================
     #301 - URL blocking
     #302 - malicious script
     #303 - illegal mail sender
     */
} ACONFIG;

/*struct for vpn connection*/
typedef struct {
	struct{
		char name[9];
		char pswd[9];
		BYTE ip[4];
		int enable;//1 connection; 0 disconnection
		int type;//1 pptpc, 2 pptpd, 3 L2TP
		int tid;//L2TP Tunnel_id
		int cid;//L2TP Call_id
	}connections[5];
}VPN_struct;

/*struct for ip information*/
typedef struct {
		char name[8];
		BYTE ip[4];
		BYTE mask[4];
		BYTE bcast[4];
		int gw[4];

		char HWaddr[20];
}ip_info_struct;

