#define FOR_DEBUG 4
//#undef FOR_DEBUG

#define usleep(SLEEP_TIME) ;



/* *************************************** */
/* Name : rc2.c                            */
/* Programmer : changkm                    */
/* Date : 2002/8/23                        */
/* Version : v1.0 (use Amit.h)             */
/* Function : set environment after reboot */
/* *************************************** */


/* ===================== */
/* Header file inclusion */
/* ===================== */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <string.h>
#include <stdlib.h>
#include <netinet/in.h>
#include "usercfg5.h"
#include "../../../uC-src/amit_include/amit.h"
#include "../../../uC-src/amit_include/flash.h"
#include "../../../uC-src/amit_include/led.h"
#include <unistd.h>
#include <fcntl.h>
#ifdef CONFIG_MTD
#include <linux/mtd/mtd.h>
#else
#include <linux/blkmem.h>
#endif
#include <sys/timeb.h>




/* ================== */
/* Literal definition */
/* ================== */

//---for different flashing
#define ARM_MIPS 1	//0: for Conexant ARM9; 1: for Brecis MIPS 2000


//---check wan
#ifndef SOCK_DGRAM
	#define SOCK_DGRAM 1
#endif
#ifndef SIOCGIFADDR
	#define SIOCGIFADDR 0x01
#endif
//
#define OFFSET 			4259856
#define FLASH_DUMMY_SIZE	32

#define SLEEP_TIME 300
//---new actrl
#define CONF_PATH	"/proc/access_ctrl_setting"
#define GROUP_NUM	4
#define BOUND		16
//---End new actrl

//---IPSec Manual
#define DEBUG_IPSEC_MANUAL

//---SAVE IP info
#define IP_INFO_FILE "/var/config/host.arg"
//---static DNS file
#define DNS_INFO_FILE "/var/config/resolv.conf"
#define DOMAIN_FILTER_RULE_FILE "/var/config/ipq/domainf.conf"

//---ids
#define PINGF_NUM	"103"
#define SMURF_NUM	"104"
#define PSD_NUM		"201"
#define FRAGGLE_NUM	"202"
#define SNORK_NUM	"203"
#define LAND_NUM	"204"
#define DNS_SCAN_NUM	"206"
//---End ids

//---virus parser
#define MAX 80
#define VIRUS_PATH "/var/config/ipq/virus/"
//---End virus parser

#define MBOMB_PATH "/var/config/ipq/mbomb1.conf"
#define MBOMB2_PATH "/var/config/ipq/mbomb2.conf"

//----Alert Mail
#define MAIL_LIST_FILE "/var/config/mail_list.conf"
#define ALERT_TABLE_FILE "/var/config/alert_table"

//@@@AddBegin by KM 2002/10/07
#define WAN_dis 1
//#define LAN_dis 2
#define DMZ_dis 3
#define DNS_dis 4
#define PROXY_dis 5
#define WANstr_dis 6
#define LANnet_dis 7
#define PROXYmscript_dis 8
//@@@AddEnd by KM 2002/10/07



/* =================== */
/* Function prototypes */
/* =================== */

int ipinfo(char *, ip_info_struct *);//find ip information
int findGW(ip_info_struct *);//find Getway
int setenv(const char *name, const char *value, int overwrite);
int fseek(FILE *stream, long offset, int whence);
long ftell(FILE *stream);
void rewind(FILE *stream);
int set_wanget_result(int act);
void restart_dhcpcd(void);
void del_routes_with_not_if(void);
extern unsigned long getmyLANip(void);
extern unsigned long getmyLANmask(void);
extern unsigned long getmyWANip(void);
extern unsigned long getmyWANmask(void);
extern unsigned long query_netdevice(char *device_name, int query_flag);
char *getenv(const char *name);
int setenv(const char *name, const char *value, int overwrite);
int unsetenv(const char *name);
void getWANstr(char *result);
extern void flashcpy(unsigned char *buf, unsigned char *src, int len);
int dis(int);	//distinguish some types
//@@@InsertBegin by KM 2002/10/16
void getOldWANstr(char *result);
//@@@InsertEnd by KM 2002/10/16




/* ===================== */
/* Global variables      */
/* ===================== */

unsigned char during_booting;
unsigned char cold_start;

extern ACONFIG *ACONF;
extern ACONFIG *oldACONF;



/* ===================== */
/* All procedures        */
/* ===================== */

//succ: insertion sort for dhcpd with pmac
void sort(int *r, int num)
{
  int i, j;
  int tempr;
  
  for(i=0 ; i<num-1; i++)
  {
  	for(j=i+1 ; j<num ; j++)
  	{
  		if(r[i] > r[j])
  		{
  			tempr = r[i]; r[i] = r[j]; r[j] = tempr;	
  		}
  	}	
  }
  
}







/* **** get DNS ******** */
/* file:resolv.conf      */
/* ********************* */

int getDNS( char *dns1, char *dns2 )
{
	FILE *fd;
	char buf[80],temp[17];
	char *pt;
	int flag;
	
	flag=0;
	fd=fopen(DNS_INFO_FILE,"r");
	
	while(fgets(buf,80,fd)!=NULL)
	{
		if ((pt=strstr(buf,"nameserver"))!=NULL)
		{
			if (flag==0)
			{
				pt=pt+11;
				strcpy(temp,pt);
				temp[strlen(temp)-1]=0;
				strcpy(dns1,temp);
				flag=1;
				continue;
			} else {
				pt=pt+11;
				strcpy(temp,pt);
				temp[strlen(temp)-1]=0;
				strcpy(dns2,temp);
				break;
			}
		}
	}
	
	fclose (fd);

	return 0;
}

/* ****save IP info**** */
/*  file:host.arg       */
/*  WAN IP;             */
/*  WAN Netmask;        */
/*  WAN Gateway         */
/* ******************** */
int saveIPinfo(void)
{

	FILE *fd;
	int i;
	ip_info_struct ife;

	
	#ifdef FOR_DEBUG
    		printf("-------------------------------------------------------------------------------\r\n");
    		printf("Enter saveIPinfo procedure\r\n");
    	#endif
	
	if(ACONF->local.wtype!=2) ipinfo("eth1", &ife); else ipinfo("ppp0", &ife);
	
	findGW(&ife);
	
	for(i = 0; i < 5; i++)//check if file can open
	{
		fd=fopen(IP_INFO_FILE,"w");
		if(fd == NULL)
		{
			sleep(1);
			continue;
		}
		else
			break;
	}
	if(fd == NULL)
	{
		printf("saveIPinfo: cannot open file %s.\n", IP_INFO_FILE);
		return 1;
	}
	else
	{
		printf("Open host.arg file ok\r\n");// IMPORTANT!!!   delete this will cause error!!!
	}
		
	fprintf(fd,"%d.%d.%d.%d\n",ife.ip[0],ife.ip[1],ife.ip[2],ife.ip[3]);//save ip
	fprintf(fd,"%d.%d.%d.%d\n",ife.mask[0],ife.mask[1],ife.mask[2],ife.mask[3]);//save wan mask
	fprintf(fd,"%d.%d.%d.%d\n",ife.gw[0],ife.gw[1],ife.gw[2],ife.gw[3]);//save wan gateway
	fclose(fd);
	
	#ifdef FOR_DEBUG
		printf("Save ip ok\r\n");
	#endif

	return 1;
}




void setpmac(int act)
{
  	char temp[180];
  	int i;

	#ifdef FOR_DEBUG
    		printf("-------------------------------------------------------------------------------\r\n");
    		printf("Enter setpmac procedure\r\n");
    	#endif
    	
    	// 1. --- DIsable this function
	if (during_booting == 0)
	{
    		system("iptables -t nat -F PMAC");
    		system("iptables -t nat -X PMAC");
    		system("iptables -t nat -D PREROUTING -i eth0 -j PMAC");
	}
	
	// 2. Exit condition checking
	if ((act==0) || ((ACONF->pmac.flag & PMF_MAC_CONTROL)==0)) goto restart_dhcpd;
    
        /* ******************** */
        /* setup iptables rules */
        /* ******************** */
        if((ACONF->pmac.flag & PMF_D_ENABLE) == PMF_D_ENABLE) //connection control enable
        {
        	
          /* create a new chain, PMAC in nat table from eth0 */
          system("iptables -t nat -N PMAC");
          system("iptables -t nat -I PREROUTING -i eth0 -j PMAC");

          if((ACONF->pmac.flag & PMF_D_DENY_OTHERS) != PMF_D_DENY_OTHERS) //allow
          {
            for(i = 0 ; i < PMAC_NUM ; i++)
            {         	
              if(ACONF->pmac.list[i].prop == 1 && ACONF->pmac.list[i].ip != 0)
              {
                sprintf(temp,"iptables -t nat -I PMAC -s %d.%d.%d.%d -m mac --mac-source ! %02x:%02x:%02x:%02x:%02x:%02x -j DROP",
                            ACONF->local.ip[0],ACONF->local.ip[1],
                            ACONF->local.ip[2],ACONF->pmac.list[i].ip,
                            ACONF->pmac.list[i].mac[0],ACONF->pmac.list[i].mac[1],
                            ACONF->pmac.list[i].mac[2],ACONF->pmac.list[i].mac[3],
                            ACONF->pmac.list[i].mac[4],ACONF->pmac.list[i].mac[5]
                );
  	        system(temp);
                sprintf(temp,"iptables -t nat -I PMAC -s ! %d.%d.%d.%d -m mac --mac-source %02x:%02x:%02x:%02x:%02x:%02x -j DROP",
                            ACONF->local.ip[0],ACONF->local.ip[1],
                            ACONF->local.ip[2],ACONF->pmac.list[i].ip,
                            ACONF->pmac.list[i].mac[0],ACONF->pmac.list[i].mac[1],
                            ACONF->pmac.list[i].mac[2],ACONF->pmac.list[i].mac[3],
                            ACONF->pmac.list[i].mac[4],ACONF->pmac.list[i].mac[5]
                );
	        system(temp);
	        sprintf(temp,"iptables -t nat -I PMAC -p udp --dport 67 -m mac --mac-source %02x:%02x:%02x:%02x:%02x:%02x -j RETURN",
                            ACONF->pmac.list[i].mac[0],ACONF->pmac.list[i].mac[1],
                            ACONF->pmac.list[i].mac[2],ACONF->pmac.list[i].mac[3],
                            ACONF->pmac.list[i].mac[4],ACONF->pmac.list[i].mac[5]
                );
              }
            }
            
            system("iptables -t nat -A PMAC -j RETURN");
            
          }
          else if((ACONF->pmac.flag & PMF_D_DENY_OTHERS) == PMF_D_DENY_OTHERS) //deny
          {
          	
	    for(i = 0 ; i < PMAC_NUM ; i++)  //check with checked C
	    {
	      if(ACONF->pmac.list[i].prop == 1 && ACONF->pmac.list[i].ip != 0)
	      {
	        sprintf(temp,"iptables -t nat -A PMAC -p udp --dport 67 -m mac --mac-source %02x:%02x:%02x:%02x:%02x:%02x -j RETURN",
                            ACONF->pmac.list[i].mac[0],ACONF->pmac.list[i].mac[1],
                            ACONF->pmac.list[i].mac[2],ACONF->pmac.list[i].mac[3],
                            ACONF->pmac.list[i].mac[4],ACONF->pmac.list[i].mac[5]
                );
	        system(temp);
                sprintf(temp,"iptables -t nat -A PMAC -s %d.%d.%d.%d -m mac --mac-source %02x:%02x:%02x:%02x:%02x:%02x -j RETURN",
                            ACONF->local.ip[0],ACONF->local.ip[1],
                            ACONF->local.ip[2],ACONF->pmac.list[i].ip,
                            ACONF->pmac.list[i].mac[0],ACONF->pmac.list[i].mac[1],
                            ACONF->pmac.list[i].mac[2],ACONF->pmac.list[i].mac[3],
                            ACONF->pmac.list[i].mac[4],ACONF->pmac.list[i].mac[5]
                );
	        system(temp);
                sprintf(temp,"iptables -t nat -A PMAC -s %d.%d.%d.%d -j DROP",
			   ACONF->local.ip[0],ACONF->local.ip[1],
			   ACONF->local.ip[2],ACONF->pmac.list[i].ip
	        );
                system(temp);
                sprintf(temp,"iptables -t nat -A PMAC -m mac --mac-source %02x:%02x:%02x:%02x:%02x:%02x -j DROP",
                            ACONF->pmac.list[i].mac[0],ACONF->pmac.list[i].mac[1],
                            ACONF->pmac.list[i].mac[2],ACONF->pmac.list[i].mac[3],
                            ACONF->pmac.list[i].mac[4],ACONF->pmac.list[i].mac[5]
                );
	        system(temp);
              }
            }
            
	    for(i = 0 ; i < PMAC_NUM ; i++)  //check without checked C
            {
              if(ACONF->pmac.list[i].prop == 0 && ACONF->pmac.list[i].ip != 0)
              {
                sprintf(temp,"iptables -t nat -A PMAC -m mac --mac-source %02x:%02x:%02x:%02x:%02x:%02x -j RETURN",
                           ACONF->pmac.list[i].mac[0],ACONF->pmac.list[i].mac[1],
	                   ACONF->pmac.list[i].mac[2],ACONF->pmac.list[i].mac[3],
			   ACONF->pmac.list[i].mac[4],ACONF->pmac.list[i].mac[5]
	        );
	        system(temp);
	      }
	    }
	    
            system("iptables -t nat -A PMAC -j DROP");
            
          }  //deny unspecified MAC
          
        }

restart_dhcpd:
  
	if (during_booting == 0) setdhcpd(1);
  
}







void setrouted(int act)
{
  	char temp[180], WANstr[6];
  	int i,child_id;
  	FILE *fd2;
  	BYTE byte4[4];
  
  	// 1. --- Function indication message
  	#ifdef FOR_DEBUG
  		printf("-------------------------------------------------------------------------------\r\n");
    		printf("Enter setrouted %d procedure\r\n",act);
    	#endif
  	
  	// 2. --- Function initialization
  	//close(2);	//marked by Lily 20020926
  	
  	// 3. --- Disable this function first
  	#ifdef FOR_DEBUG
  		printf("setrouted: disable: Delete routes that are not interfaces\r\n");
 		system("route");
    	#endif
  	del_routes_with_not_if();
  	if (during_booting == 0) {
  		system("iptables -t nat -D POSTROUTING -o eth1 -p udp --dport 520 -j DROP");
  		system("iptables -t nat -D POSTROUTING -o ppp0 -p udp --dport 520 -j DROP");
  		system("iptables -t nat -D PREROUTING -p udp --dport 520 -j ACCEPT");
  	}
        if (cold_start == 0) system("killall routed");
        #ifdef FOR_DEBUG
  		printf("setrouted: disable: Disable this function over\r\n");
    	#endif
    	
        // 4. --- Exit condition checking
        if (act == 0) return;
        if (ACONF->dyna_route.enable_flags == 0) return;
  	
  	// 5. --- Enable this function
  	
  	// 5.1 --- delete routes
  	//del_routes_with_not_if();	//has been done above
  	
  	// 5.2 --- static routing information
  	for (i=0; i<RTAB_NUM; i++) {
  		if (ACONF->rtab[i].enable_flags != 0) {
  			byte4[0] = ACONF->rtab[i].dip[0] & ACONF->rtab[i].dnm[0];
  			byte4[1] = ACONF->rtab[i].dip[1] & ACONF->rtab[i].dnm[1];
  			byte4[2] = ACONF->rtab[i].dip[2] & ACONF->rtab[i].dnm[2];
  			byte4[3] = ACONF->rtab[i].dip[3] & ACONF->rtab[i].dnm[3];
  			sprintf(temp,"route add -net %d.%d.%d.%d netmask %d.%d.%d.%d gw %d.%d.%d.%d metric %d",
  				byte4[0],byte4[1],byte4[2],byte4[3],
  				ACONF->rtab[i].dnm[0],ACONF->rtab[i].dnm[1],ACONF->rtab[i].dnm[2],ACONF->rtab[i].dnm[3],
  				ACONF->rtab[i].dgw[0],ACONF->rtab[i].dgw[1],ACONF->rtab[i].dgw[2],ACONF->rtab[i].dgw[3],
  				ACONF->rtab[i].hop);
  		} 
  		system(temp);
  	}
  	#ifdef FOR_DEBUG
  		printf("setrouted: enable: Static routes adding over\r\n");
    	#endif
  	
  	// 5.3 --- dynamic routing information (RIP)
  	system("iptables -t nat -I PREROUTING -p udp --dport 520 -j ACCEPT");
  	getWANstr(WANstr);
  	sprintf(temp,"iptables -t nat -I POSTROUTING -o %s -p udp --dport 520 -j DROP",WANstr);
  	system(temp);
  	#ifdef FOR_DEBUG
  		printf("setrouted: enable: %s\r\n",temp);
  	#endif
  	system("routed&");
  	#ifdef FOR_DEBUG
  		printf("setrouted: enable: restart routed daemon\r\n");
  	#endif
  	
  	// 6. --- function return
  	return;
  
}





int setsnmpd(int act)
{
  FILE *fd;
  unsigned char check1, check2;
  char temp[180], WANstr[6];
  char buf[128], *bufp;
  unsigned long *ul_p, ul_tmp;
  				#if 0
  				// D area, item #8: snmpd default setting
  				[8] for SNMP default information
  				;1: SNMP_Get_Community_String
				"public\0"
				;2: SNMP_Set_Community_String
				"private\0"
				;3: SNMP_sysDescr_String
				"Internet Gateway Device\0"
				;4: OID_length+SNMP_sysObjectid_String
				"1.3.6.1.4.1.171\0"
				;5: SNMP_sysServices_String
				"2\0"
				;6: SNMP_ifDescr_String
				"Ethernet-WAN\0"
				;7: SNMP_ifSpeed_String
				"30000000\0"
				;8: SNMP_ifOutQLen_String
				"16\0"
				;SNMP_END_index
				"\0"
				#endif
  struct {
  	char read_community[32];
  	char write_community[32];
  	char system_description[256];
  	char system_objectid[32];
  	char system_services[4];
  	char if_description[32];
  	char if_speed[12];
  	char if_outq_len[4];
  } snmpd_patch;
  
  
  if (ACONF->psnmp.flags & 1) check1 =0; else check1 = 1;
  check2 = ACONF->psnmp.flags & 2;
  
  #ifdef FOR_DEBUG
  	printf("-------------------------------------------------------------------------------\r\n");
  	printf("Enter setsnmpd procedure (check1=%x, check2=%x)\r\n",check1,check2);
  #endif
  
  if (cold_start == 0) {
  	system("killall snmpd");
  	#ifdef FOR_DEBUG
  		printf("setsnmpd: kill the last snmpd\r\n");
  	#endif
  }

  if ((check1 | check2) == 0) {
  	if (during_booting == 0) {
	  	system("iptables -t filter -D INPUT -i eth0 -p udp --dport 161 -j DROP");
  		system("iptables -t filter -D INPUT -i eth1 -p udp --dport 161 -j DROP");
  		system("iptables -t filter -D INPUT -i ppp0 -p udp --dport 161 -j DROP");
  		#ifdef FOR_DEBUG
  			printf("setsnmpd: kill the rules in filter table for snmpd\r\n");
  		#endif
  	}
  	system("monitor 1 55 0");
  	return 0;
  }
  
  if (act == 1)
  {
  	if (check1 == 0) {
  		system("iptables -t filter -I INPUT -i eth0 -p udp --dport 161 -j DROP");
  		#ifdef FOR_DEBUG
  			printf("setsnmpd: iptables -t filter -I INPUT -i eth0 -p udp --dport 161 -j DROP\r\n");
  		#endif
  	} else {
  		system("iptables -t filter -D INPUT -i eth0 -p udp --dport 161 -j DROP");
  	}
  	
  	if (check2 == 0) {
  		getWANstr(WANstr);
  		sprintf(temp,"iptables -t filter -I INPUT -i %s -p udp --dport 161 -j DROP",WANstr);
  		system(temp);
  		#ifdef FOR_DEBUG
  			printf("setsnmpd: %s\r\n",temp);
  		#endif
  	} else {
  		system("iptables -t filter -D INPUT -i eth1 -p udp --dport 161 -j DROP");
  		system("iptables -t filter -D INPUT -i ppp0 -p udp --dport 161 -j DROP");
  	}
  	
  	//ŪD϶}Y
	flashcpy(buf,(unsigned char*)(FLASH_START+DATA_START+FLASH_DUMMY_SIZE), sizeof(buf));

	//pKitty.RC}
	ul_p = (unsigned long *)buf;
	ul_tmp = L2BL(ul_p[8]);	//Kitty.RC۹m

	//ŪKitty.RC
	flashcpy(buf,(unsigned char *)(FLASH_START+DATA_START+ul_tmp), sizeof(buf));
	
	//match string pattern to snmpd_patch data structure
	bufp = buf;
	strncpy(snmpd_patch.read_community,bufp,sizeof(snmpd_patch.read_community)); 
	bufp = bufp + strlen(snmpd_patch.read_community) + 1;
	strncpy(snmpd_patch.write_community,bufp,sizeof(snmpd_patch.write_community));
	bufp = bufp + strlen(snmpd_patch.write_community) + 1;
	strncpy(snmpd_patch.system_description,bufp,sizeof(snmpd_patch.system_description));
	bufp = bufp + strlen(snmpd_patch.system_description) + 1;
	strncpy(snmpd_patch.system_objectid,bufp,sizeof(snmpd_patch.system_objectid));
	bufp = bufp + strlen(snmpd_patch.system_objectid) + 1;
	strncpy(snmpd_patch.system_services,bufp,sizeof(snmpd_patch.system_services));
	bufp = bufp + strlen(snmpd_patch.system_services) + 1;
	strncpy(snmpd_patch.if_description,bufp,sizeof(snmpd_patch.if_description));
	bufp = bufp + strlen(snmpd_patch.if_description) + 1;
	strncpy(snmpd_patch.if_speed,bufp,sizeof(snmpd_patch.if_speed));
	bufp = bufp + strlen(snmpd_patch.if_speed) + 1;
	strncpy(snmpd_patch.if_outq_len,bufp,sizeof(snmpd_patch.if_outq_len));
	bufp = bufp + strlen(snmpd_patch.if_outq_len) + 1;
	
  	#ifdef FOR_DEBUG
  		printf("setsnmpd: the item #8 of D area in flash is for snmpd\r\n");
  		printf("setsnmpd: read community: %s\r\n",snmpd_patch.read_community);
  		printf("setsnmpd: write community: %s\r\n",snmpd_patch.write_community);
  		printf("setsnmpd: system description: %s\r\n",snmpd_patch.system_description);
  		printf("setsnmpd: system objectid: %s\r\n",snmpd_patch.system_objectid);
  		printf("setsnmpd: system services: %s\r\n",snmpd_patch.system_services);
  		printf("setsnmpd: if description: %s\r\n",snmpd_patch.if_description);
  		printf("setsnmpd: if speed: %s\r\n",snmpd_patch.if_speed);
  		printf("setsnmpd: if outq length: %s\r\n",snmpd_patch.if_outq_len);
  	#endif
  	
  	if ((fd = fopen("/var/config/snmpd.conf","w")) == NULL) {
  		#ifdef FOR_DEBUG
  			printf("setsnmpd: /var/config/snmpd.conf can not be opened as a write file\r\n");
  		#endif
  		return -1;
  	}
  	 	
  	ACONF->psnmp.community[0][31] = 0; ACONF->psnmp.community[1][31] = 0;
  	if (ACONF->psnmp.community[0][0] > ' ') {
  		sprintf(temp,"com2sec public\tdefault\t%s\n",ACONF->psnmp.community[0]);
  	} else {
  		sprintf(temp,"com2sec public\tdefault\t%s\n",snmpd_patch.read_community);
  	}
  	fputs(temp,fd);
  	#ifdef FOR_DEBUG
  		printf("setsnmpd: in snmpd.conf: %s\r",temp);
  	#endif
  	
  	if (ACONF->psnmp.community[1][0] > ' ') {
	  	sprintf(temp,"com2sec local\tdefault\t%s\n",ACONF->psnmp.community[1]);
	} else {
		sprintf(temp,"com2sec local\tdefault\t%s\n",snmpd_patch.write_community);
	}
  	fputs(temp,fd);
  	#ifdef FOR_DEBUG
  		printf("setsnmpd: in snmpd.conf: %s\r",temp);
  	#endif
  	
  	sprintf(temp,"group\tlocal\tv1\tlocal\n"); fputs(temp,fd);
  	#ifdef FOR_DEBUG
  		printf("setsnmpd: in snmpd.conf: %s\r",temp);
  	#endif
  	
  	sprintf(temp,"group\tlocal\tv2c\tlocal\n"); fputs(temp,fd);
  	#ifdef FOR_DEBUG
  		printf("setsnmpd: in snmpd.conf: %s\r",temp);
  	#endif
  	
  	sprintf(temp,"group\tlocal\tusm\tlocal\n"); fputs(temp,fd);
  	#ifdef FOR_DEBUG
  		printf("setsnmpd: in snmpd.conf: %s\r",temp);
  	#endif
  	
  	sprintf(temp,"group\tpublic\tv1\tpublic\n"); fputs(temp,fd);
  	#ifdef FOR_DEBUG
  		printf("setsnmpd: in snmpd.conf: %s\r",temp);
  	#endif
  	
  	sprintf(temp,"group\tpublic\tv2c\tpublic\n"); fputs(temp,fd);
  	#ifdef FOR_DEBUG
  		printf("setsnmpd: in snmpd.conf: %s\r",temp);
  	#endif
  	
  	sprintf(temp,"group\tpublic\tusm\tpublic\n"); fputs(temp,fd);
  	#ifdef FOR_DEBUG
  		printf("setsnmpd: in snmpd.conf: %s\r",temp);
  	#endif
  	
  	sprintf(temp,"view all\tincluded\t.1\t80\n"); fputs(temp,fd);
  	#ifdef FOR_DEBUG
  		printf("setsnmpd: in snmpd.conf: %s\r",temp);
  	#endif
  	//sprintf(temp,"view system included system        fe\n"); fputs(temp,fd);
  	sprintf(temp,"view mib\tincluded\t.1.3.6.1.2.1\tfc\n"); fputs(temp,fd);
  	#ifdef FOR_DEBUG
  		printf("setsnmpd: in snmpd.conf: %s\r",temp);
  	#endif
  	
  	sprintf(temp,"access public\t\"\"\tany\tnoauth\texact\tall\tnone\tnone\n"); fputs(temp,fd);
  	#ifdef FOR_DEBUG
  		printf("setsnmpd: in snmpd.conf: %s\r",temp);
  	#endif
  	sprintf(temp,"access local\t\"\"\tany\tnoauth\texact\tall\tall\tall\n");  fputs(temp,fd);
  	#ifdef FOR_DEBUG
  		printf("setsnmpd: in snmpd.conf: %s\r",temp);
  	#endif
  	
  	// ------------------------------
  	// system information MIB entries
  	// ------------------------------
  	
  	ACONF->psnmp.sys_location[sizeof(ACONF->psnmp.sys_location)-1] = 0x00;
  	sprintf(temp,"syslocation %s\n",ACONF->psnmp.sys_location); fputs(temp,fd);
  	#ifdef FOR_DEBUG
  		printf("setsnmpd: in snmpd.conf: %s\r",temp);
  	#endif
  	ACONF->psnmp.sys_contact[sizeof(ACONF->psnmp.sys_contact)-1] = 0x00;
  	sprintf(temp,"syscontact H%s\n",ACONF->psnmp.sys_contact);  fputs(temp,fd);
  	#ifdef FOR_DEBUG
  		printf("setsnmpd: in snmpd.conf: %s\r",temp);
  	#endif
  	sprintf(temp,"sysDescr %s\n",snmpd_patch.system_description);  fputs(temp,fd);
  	#ifdef FOR_DEBUG
  		printf("setsnmpd: in snmpd.conf: %s\r",temp);
  	#endif
  	sprintf(temp,"sysObjectID %s\n",snmpd_patch.system_objectid);  fputs(temp,fd);
  	#ifdef FOR_DEBUG
  		printf("setsnmpd: in snmpd.conf: %s\r",temp);
  	#endif
  	sprintf(temp,"sysservices %s\n",snmpd_patch.system_services);  fputs(temp,fd);
  	#ifdef FOR_DEBUG
  		printf("setsnmpd: in snmpd.conf: %s\r",temp);
  	#endif
  	
  	// ---------------------
  	// interface MIB entries
  	// ---------------------
  	
  	sprintf(temp,"ifDescr %s\n",snmpd_patch.if_description);  fputs(temp,fd);
  	#ifdef FOR_DEBUG
  		printf("setsnmpd: in snmpd.conf: %s\r",temp);
  	#endif
  	sprintf(temp,"ifSpeed %s\n",snmpd_patch.if_speed);  fputs(temp,fd);
  	#ifdef FOR_DEBUG
  		printf("setsnmpd: in snmpd.conf: %s\r",temp);
  	#endif
  	sprintf(temp,"ifOutqLen %s\n",snmpd_patch.if_outq_len);  fputs(temp,fd);
  	#ifdef FOR_DEBUG
  		printf("setsnmpd: in snmpd.conf: %s\r",temp);
  	#endif
  	
  	fclose(fd);
  	usleep(SLEEP_TIME);
  	
  	system("snmpd -c /var/config/snmpd.conf -C&");	//modified by Lily 20020926
  	
	system("monitor 1 55 1");
	
	return 0;
  	
  } 
  
}













/* ************* */
/* Set LAN       */
/* 0     : ok    */
/* other : error */
/* ************* */
int setlan(int act)
{
  	unsigned char temp[60];
  	unsigned char AND1, AND2, AND3, AND4;
  	int child_id;
  
  	//close(2);	//marked by Lily 20020926
    
    	if(act == 0) return;
  
  {
  	
    #ifdef FOR_DEBUG
    	printf("-------------------------------------------------------------------------------\r\n");
    	printf("Enter setlan 1 procedure\r\n");
    #endif
    
    sprintf(temp,"ifconfig eth0 %d.%d.%d.%d netmask 255.255.255.0 up",
    		ACONF->local.ip[0],ACONF->local.ip[1],
      		ACONF->local.ip[2],ACONF->local.ip[3]);
    system(temp);
    #ifdef FOR_DEBUG
    	printf("setlan: command=%s\r\n",temp);
    #endif
    
    //set_wanget_result(0);
    
  }
  
}






/* ************* */
/* Set WAN       */
/* 0     : ok    */
/* other : error */
/* ************* */
int setwan(int act)
{
  	unsigned char temp[120];
  	unsigned char AND1, AND2, AND3, AND4;
  	FILE *fd, *fd2;
  	unsigned char pid[10];
  	int i,child_id;
  	FILE *fd_dns;	//succ : for dns
  	char *cp;
  	unsigned char found;
  	long file_pos;
  	BYTE check1, check2;
	
	// 1. --- Function entrance
  	#ifdef FOR_DEBUG
  	  printf("-------------------------------------------------------------------------------\r\n");
  	  printf("Enter setwan %d procedure\n",act);
  	#endif
 
	// 2. --- Disable this function
        if (cold_start == 0) {
        	
        	// 2.1 --- down dhcpcd
        	system("killall dhcpcd"); remove("/var/dhcpc/dhcpcd-eth1.info");
        	
        	// 2.2 --- Qadsl-stoppppoe
		system("adsl-stop"); remove("/var/config/ppp/pppoe.conf");
		if((fd = fopen("/var/config/pap-secrets", "r")) != NULL)
		{
			if ((fd2 = fopen("/var/config/pap-secrets.tmp", "w")) != NULL)
			{
				for(i = 0; i < 4; i++) {fgets(temp, 120, fd);fputs(temp, fd2);}
				fclose(fd); fclose(fd2);
			}
			remove("/var/config/pap-secrets");
			rename("/var/config/pap-secrets.tmp", "/var/config/pap-secrets");
		}
		
		if((fd = fopen("/var/config/chap-secrets", "r")) != NULL)
		{
		  if((fd2 = fopen("/var/config/chap-secrets.tmp", "w")) != NULL)
		  {
			for(i = 0; i < 4; i++)
			{
				fgets(temp, 120, fd); fputs(temp, fd2);
	    		}
			fclose(fd); fclose(fd2);
		  }
		  remove("/var/config/chap-secrets");
		  rename("/var/config/chap-secrets.tmp", "/var/config/chap-secrets");
		}
		
        	//Off M2 led   
        	if (during_booting == 0) {
        		led_change_system_state(0xFFFFFFFF,SYS_STATE_OffLine);
        		#ifdef FOR_DEBUG
        			printf("setwan: Led M2 off\r\n");
        		#endif
        	}
        }
        
        // 3. --- Exit condition checking
        if (act == 0) return 0;
    
    	// 4. --- Enable this function
    	switch(ACONF->local.wtype)
    	{
    	
      	  case 0:  //Static IP
      
        	// 4.1. --- set if_wan up
        	sprintf(temp,"ifconfig eth1 %d.%d.%d.%d netmask %d.%d.%d.%d up",
        		ACONF->local.wip[0],ACONF->local.wip[1],
                	ACONF->local.wip[2],ACONF->local.wip[3],
                	ACONF->local.wnm[0],ACONF->local.wnm[1],
                	ACONF->local.wnm[2],ACONF->local.wnm[3]);
        	system(temp);
        	#ifdef FOR_DEBUG
    			printf("Static WAN: set IP: %s",temp);
  		#endif
        
        	// 4.2. --- set default gw
        	sprintf(temp,"route add default gw %d.%d.%d.%d",
        		ACONF->local.wgw[0],ACONF->local.wgw[1],
                	ACONF->local.wgw[2],ACONF->local.wgw[3]);
        	system(temp);
        	#ifdef FOR_DEBUG
    			printf("Static WAN: set default GW: %s\r\n",temp);
  		#endif
        
        	// 4.4. --- save WAN's IP in /var/config/host.arg
        	if (during_booting == 0) {
	        	i = saveIPinfo();
			#ifdef FOR_DEBUG
    				printf("Static WAN: save WAN's IP in /var/config/host.arg: %d(0 for success)\r\n",i);
  			#endif
  		}
        
        	// 4.5. --- save domain, dns, and search in /var/config/resolv.conf from WAN UI's DNS
        	check1 = ACONF->acctpool[0].dns[0].ip[0]|ACONF->acctpool[0].dns[0].ip[1]|
               		ACONF->acctpool[0].dns[0].ip[2]|ACONF->acctpool[0].dns[0].ip[3];
        	check2 = ACONF->acctpool[0].dns[1].ip[0]|ACONF->acctpool[0].dns[1].ip[1]|
               		ACONF->acctpool[0].dns[1].ip[2]|ACONF->acctpool[0].dns[1].ip[3];
               	
        	if ((check1|check2) == 0) //DNS not set
	        {
        		if (during_booting == 0) {	//has done in setboot for first times
				set_default_DNS(); 
				#ifdef FOR_DEBUG
    					printf("Static WAN: set default DNS in /var/config/resolv.conf \r\n");
    				#endif       		
			}
        	}
        	else
        	{
        		fd_dns = fopen(DNS_INFO_FILE,"w");
        		fprintf(fd_dns,"domain\n");
        		if(check1)
        		{
        			fprintf(fd_dns,"nameserver %d.%d.%d.%d\n",
        			ACONF->acctpool[0].dns[0].ip[0],
          			ACONF->acctpool[0].dns[0].ip[1],
          			ACONF->acctpool[0].dns[0].ip[2],
          			ACONF->acctpool[0].dns[0].ip[3]     );
        		}
        		if(check2)
        		{
        		fprintf(fd_dns,"nameserver %d.%d.%d.%d\n",
          			ACONF->acctpool[0].dns[1].ip[0],
          			ACONF->acctpool[0].dns[1].ip[1],
          			ACONF->acctpool[0].dns[1].ip[2],
          			ACONF->acctpool[0].dns[1].ip[3] );	
			}
			fprintf(fd_dns,"search\n");
			fclose(fd_dns);
			#ifdef FOR_DEBUG
    				printf("Static WAN: set staticWAN UI's DNS in /var/config/resolv.conf \r\n");
    			#endif
		}

		// 4.6. --- start up dhcpd
		if(during_booting == 0)
		{
			setdhcpd(1);	//during booting, setdhcpd is called in setboot
					//so, further setdhcpd call is not necessary
		}
    	
    		// 4.7. --- chear the monitor item that checks if wan is up
    		if (during_booting == 0) system("monitor 1 0 0");
	
		// 8. --- set WAN get result = 0 when static WAN 
		set_wanget_result(0);
		
		// 9. --- get time from NTP
		system("set_time.sh 480 time.nist.gov &");	//480: Timezone id (Taipei)
  	
        	break;

      	  case 1:  //dynamic IP
      		
      		// 0. decide DNS
		if (during_booting == 0) {
        		set_default_DNS();
			#ifdef FOR_DEBUG
    				printf("Dynamic WAN: Set default DNS increate /var/config/resolv.conf\r\n");
    			#endif
    		}       		
        
        	// 1. eth1's IP = 0.0.0.0
        	system("ifconfig eth1 inet 0.0.0.0");	//hsujp
		#ifdef FOR_DEBUG
	  		printf("ifconfig eth1 0.0.0.0\r\n");
		#endif
		
		// 2. start dhcpcd
		set_wanget_result(99);	//the state that dhcpcd is tring to get an IP and other information
		restart_dhcpcd();
		
		// 3. set the flag indicating eth1 is required to be checked
		if (during_booting == 1)
		  system("monitor 91 0 1"); //91: set function but don't invoke another monitor
		  	                    //    if it is 1, set and invoke;
			                    // 0: bit 0, eth1 need to be checked
			                    // 1: set to 1
		else
		  system("monitor 1 0 1");
		
		break;

      	  case 2: //PPPoE
      
      		// 1. store adept dns in /var/config/resolv.conf
      		check1 = ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[0]|
      		 	ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[1]|
      		 	ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[2]|
      		 	ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[3];
        	check2 = ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[0]|
        	 	ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[1]|
        	 	ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[2]|
        	 	ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[3];
        	 
        	if ((check1|check2) == 0)
        	{
      			if (during_booting == 0) {	//has done in setboot for first times
				set_default_DNS(); 
				#ifdef FOR_DEBUG
    					printf("PPPoE WAN: set default DNS in /var/config/resolv.conf \r\n");
    				#endif       		
			}        		
        	}
        	else
        	{
   			fd_dns = fopen(DNS_INFO_FILE,"w");
        		fprintf(fd_dns,"domain\n");
        		if(check1)
        		{
	       			fprintf(fd_dns,"nameserver %d.%d.%d.%d\n",
         			ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[0],
        			ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[1],
        			ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[2],
        			ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[3]     );
        		}
        		if(check2)
        		{
	       			fprintf(fd_dns,"nameserver %d.%d.%d.%d\n",
        			ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[0],
        			ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[1],
        			ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[2],
        			ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[3] );	
			}
			fprintf(fd_dns,"search\n");
			fclose(fd_dns);
			#ifdef FOR_DEBUG
    				printf("PPPoE WAN: set pppoeWAN UI's DNS in /var/config/resolv.conf \r\n");
    			#endif
		}
        
        	// 2. set eth1's IP = 0.0.0.0
		system("ifconfig eth1 inet 0.0.0.0");
	
		// 3. setup the pppoe's configuration file
		if((fd = fopen("/var/config/ppp/pppoe.conf", "w")) != NULL)
		{
			fprintf(fd, "ETH=eth1\n");
			fprintf(fd, "USER=%s\n", ACONF->acctpool[ACONF->local3.acct[0]].user);
			//if((ACONF->acctpool[ACONF->local3.acct[0]].flag & LFLAG_RENEWIP) == LFLAG_RENEWIP)
			if (ACONF->acctpool[ACONF->local3.acct[0]].to > 0)
				fprintf(fd, "DEMAND=%d\n", ACONF->acctpool[ACONF->local3.acct[0]].to);
			else
				fprintf(fd, "DEMAND=no\n");
			i = 0;
			if(check1)
			{
				fprintf(fd, "DNSTYPE=SPECIFY\n");
				fprintf(fd, "USEPEERDNS=no\n");
				fprintf(fd, "DNS1=%d.%d.%d.%d\n",
				ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[0],
				ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[1],
				ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[2],
				ACONF->acctpool[ACONF->local3.acct[0]].dns[0].ip[3]);
				i++;
			}
			if(check2)
			{
				if(i == 0)
				{
					fprintf(fd, "DNSTYPE=SPECIFY\n");
					fprintf(fd, "USEPEERDNS=no\n");
					fprintf(fd, "DNS1=%d.%d.%d.%d\n",
					ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[0],
					ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[1],
					ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[2],
					ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[3]);
				}
				else
				{
					fprintf(fd, "DNS2=%d.%d.%d.%d\n",
					ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[0],
					ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[1],
					ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[2],
					ACONF->acctpool[ACONF->local3.acct[0]].dns[1].ip[3]);
				}
				i++;
			}
			if(!i)
			{
				fprintf(fd, "USEPEERDNS=yes\n");
			}
			fprintf(fd, "CONNECT_TIMEOUT=60\n");
			fprintf(fd, "CONNECT_POLL=6\n");
			fprintf(fd, "PING=\".\"\n");
			fprintf(fd, "PIDFILE=/var/run/pppoe.pid\n");
			fprintf(fd, "SYNCHRONOUS=no\n");
			fprintf(fd, "CLAMPMSS=1412\n");
			fprintf(fd, "LCP_INTERVAL=20\n");
			fprintf(fd, "LCP_FAILURE=3\n");
			fprintf(fd, "PPPOE_TIMEOUT=300\n");
			if((ACONF->acctpool[ACONF->local3.acct[0]].ip[0] |
		    	    ACONF->acctpool[ACONF->local3.acct[0]].ip[1] |
		    	    ACONF->acctpool[ACONF->local3.acct[0]].ip[2] |
		    	    ACONF->acctpool[ACONF->local3.acct[0]].ip[3]) == 0)
				fprintf(fd, "ASSIGNEDIP=no\n");
			else
				fprintf(fd, "ASSIGNEDIP=%d.%d.%d.%d\n",
				ACONF->acctpool[ACONF->local3.acct[0]].ip[0],
				ACONF->acctpool[ACONF->local3.acct[0]].ip[1],
				ACONF->acctpool[ACONF->local3.acct[0]].ip[2],
				ACONF->acctpool[ACONF->local3.acct[0]].ip[3]);
			if(ACONF->acctpool[ACONF->local3.acct[0]].tel[0] == 0)
				fprintf(fd, "SERVICENAME=no\n");
			else
				fprintf(fd, "SERVICENAME=%s\n", ACONF->acctpool[ACONF->local3.acct[0]].tel);
			fprintf(fd, "FIREWALL=NONE\n");
			fprintf(fd, "PPPOE_EXTRA=\"\"\n");
			fprintf(fd, "PPPD_EXTRA=\"\"\n");
			fclose(fd);
		}
	
		// 3. setup the pap secret file
		fd2 = fopen("/var/config/pap-secrets", "a+");
		fprintf(fd2, "\"%s\"\t*\t\"%s\"\n",
			ACONF->acctpool[ACONF->local3.acct[0]].user,
			ACONF->acctpool[ACONF->local3.acct[0]].pass);
		fclose(fd2);
	
		// 4. setup the chap secret file
		fd2 = fopen("/var/config/chap-secrets", "a+");
		fprintf(fd2, "\"%s\"\t*\t\"%s\"\n",
			ACONF->acctpool[ACONF->local3.acct[0]].user,
			ACONF->acctpool[ACONF->local3.acct[0]].pass);
		fclose(fd2);
		
		// 5. start pppoe
		system("adsl-start 6 60");
	
		// 5.5
		system("iptables -t nat -I POSTROUTING -o ppp0 -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --clamp-mss-to-pmtu");
	
		// 6. set the flag indicating ppp0 is required to be checked
		if (during_booting == 1)
		system("monitor 91 0 2"); //91: set function but don't invoke another monitor
		                              //    if it is 1, set and invoke;
		                              // 1: bit 1, dhcpcd-eth1.pid or adsl need to be checked
		                              // 2: set to 2 (adsl)
		else system("monitor 1 0 2");
	
		break;
	
    	} //end for switch

}





/* ************* */
/* Set DHCPD     */
/* 0     : ok    */
/* other : error */
/* ************* */

int setdhcpd(int act)
{

	/* ************************************************************ */
	/* The DHCP server ip range support netmask 255.255.255.0 now!! */
	/* ************************************************************ */

  	unsigned char temp[300];
  	unsigned char SUB[4];
  	unsigned char pid[10];
  	unsigned char check1, check2;
  	char dns_ip1[16],dns_ip2[16];
  	FILE *fd, *fd2;
  	unsigned long default_lease_time,max_lease_time;
  	unsigned long temp_lease_time;
  	ip_info_struct ife;
  	int i,num,pmac1,pmac2,child_id;
  	int ip_list[PMAC_NUM];
  	char host = 'A';
  	num = 0;
  	BYTE check;
  	
  	// 1. --- Entrance to this function
  	#ifdef FOR_DEBUG
  		printf("-------------------------------------------------------------------------------\r\n");
  		printf("Enter setdhcpd %d procedure\r\n",act);
  		//system("ps");
  	#endif
  	
  	// 2. --- Kill older dhcpd
  	if (cold_start == 0) {
  		#ifdef FOR_DEBUG
			printf("Setdhcpd: kill the last dhcpd\r\n");
		#endif
		system("killall dhcpd");
	}
	
	// 3. --- Exit condition checking
	if ((act == 0) || (ACONF->dhcp.enable == 0)) return 0;
  	
  	// 4. --- Enable this function
  	#ifdef FOR_DEBUG
  		printf("setdhcpd 1: dhcpd wants to be enabled\r\n");
  	#endif
 
   	// a. get WAN's IP
	ife.ip[0] = 0x00; ife.ip[1] = 0x00; ife.ip[2] = 0x00; ife.ip[3] = 0x00; 
	if (ACONF->local.wtype!=2) ipinfo("eth1", &ife); else ipinfo("ppp0", &ife);
	  	
	// b. set lease time
	if ((ife.ip[0]+ife.ip[1]+ife.ip[2]+ife.ip[3]) == 0) 
        {
        	temp_lease_time = 60;
        } else if (ACONF->dhcp.lease > 0) {
    		temp_lease_time = ACONF->dhcp.lease;
    	} else {
    		temp_lease_time = 86400;
    	}
    		
    	#ifdef FOR_DEBUG
  		printf("setdhcpd 1: temp lease time = %d\r\n",temp_lease_time);
  	#endif
 
	// c : Get dhcpd DNS
    	check1 = ACONF->dhcp.dns[0].ip[0] | ACONF->dhcp.dns[0].ip[1] | 
    	     	 ACONF->dhcp.dns[0].ip[2] | ACONF->dhcp.dns[0].ip[3];
    	check2 = ACONF->dhcp.dns[1].ip[0] | ACONF->dhcp.dns[1].ip[1] | 
    	    	 ACONF->dhcp.dns[1].ip[2] | ACONF->dhcp.dns[1].ip[3];
    			
    	if ((check1 | check2) == 0) //DNS in dhcpd UI is not set
    	{                           //DNS get from resolv.conf
    		#ifdef FOR_DEBUG
    			printf("setdhcpd 1: Get DNS from resolv.conf ...\r\n");
    		#endif
		dns_ip1[0] = 0; dns_ip2[0] = 0;
		getDNS(dns_ip1,dns_ip2);
		if(dns_ip1[0] == 0) strcpy(dns_ip1,"NOT");
		if(dns_ip2[0] == 0) strcpy(dns_ip2,"NOT");
		#ifdef FOR_DEBUG
    			printf("setdhcpd 1: DNS1=%s, DNS2=%s\r\n",dns_ip1,dns_ip2);
    		#endif
    	} else {
    		#ifdef FOR_DEBUG
    			printf("Get DNS from Aconfig\r\n");
    		#endif
    		if (check1 != 0)
    			sprintf(dns_ip1,"%d.%d.%d.%d",ACONF->dhcp.dns[0].ip[0],
    			ACONF->dhcp.dns[0].ip[1],ACONF->dhcp.dns[0].ip[2],
    			ACONF->dhcp.dns[0].ip[3]);
    		if (check2 != 0)
    		{
    			if (check1 == 0)
    			{
    				sprintf(dns_ip1,"%d.%d.%d.%d",ACONF->dhcp.dns[1].ip[0],
    				ACONF->dhcp.dns[1].ip[1],ACONF->dhcp.dns[1].ip[2],
    				ACONF->dhcp.dns[1].ip[3]);
				strcpy(dns_ip2,"NOT");
			}
			else
				sprintf(dns_ip2,"%d.%d.%d.%d",ACONF->dhcp.dns[1].ip[0],
    					ACONF->dhcp.dns[1].ip[1],ACONF->dhcp.dns[1].ip[2],
    					ACONF->dhcp.dns[1].ip[3]);
    		}
    		else strcpy(dns_ip2,"NOT");
    	}
	
	if((ACONF->pmac.flag & PMF_MAC_CONTROL) == PMF_MAC_CONTROL) //pmac enable
        {
        	/* --------------- */
        	/* edit dhcpd.conf */
        	/* --------------- */
          		
        	// 1. open write file: /var/config/dhcpd.conf
          	if((fd = fopen("/var/config/dhcpd.conf","w")) == NULL) {
            		printf("PMAC: open dhcpd.conf failed!\r\n");
            		return -1;
            	}
         
		// 2. record lease time
		fprintf(fd,"default-lease-time %d;\n",temp_lease_time);
	    	fprintf(fd,"max-lease-time %d;\n",temp_lease_time);
	        
	        /* 3. domain name server */
	        if(strcmp(dns_ip1,"NOT") || strcmp(dns_ip2,"NOT"))
	        { 
	        	fprintf(fd,"option domain-name-servers %s",dns_ip1);
	        	if(strcmp(dns_ip2,"NOT")) //dns_ip1 != "NOT"
	        	{
		       		fprintf(fd,", %s;\n",dns_ip2);
		       	}
	        	else
	        	{
	        		fprintf(fd,";\n");	
	        	}
	        }
	        
        	/* 4. broadcase address */
          	fprintf(fd,"option broadcast-address %d.%d.%d.%d;\n",
                	ACONF->local.ip[0],ACONF->local.ip[1],
                	ACONF->local.ip[2],255                    );
                	
          	/* 5. gateway */
          	fprintf(fd,"option routers %d.%d.%d.%d;\n",
                	ACONF->local.ip[0],ACONF->local.ip[1],
                	ACONF->local.ip[2],ACONF->local.ip[3] );

		/* 6. domain name */
		if(ACONF->dhcp.domain[0] > '0')
		{
       			fprintf(fd,"option domain-name \"%s\";\n",
               			ACONF->dhcp.domain);				
		}

       		/* 7. header : subnet & netmask */
       		fprintf(fd,"subnet %d.%d.%d.%d netmask %d.%d.%d.%d {\n",
               		ACONF->local.ip[0],ACONF->local.ip[1],
               		ACONF->local.ip[2],0,
               		255,255,255,0                                  );
		
		/* pmac host */
		num = 0;
       		for(i = 0; i < PMAC_NUM ; i++)
       		{
       			if(ACONF->pmac.list[i].ip != 0 &&
       			   ACONF->pmac.list[i].ip >= ACONF->dhcp.range[0] &&
       			   ACONF->pmac.list[i].ip <= ACONF->dhcp.range[1]    )	     
       			{
       				ip_list[num] = (int)(ACONF->pmac.list[i].ip);
     				num++;
	   
      				fprintf(fd,"\thost %c {\n",host);
       				fprintf(fd,"\t\thardware ethernet %02x:%02x:%02x:%02x:%02x:%02x;\n",
                      		ACONF->pmac.list[i].mac[0],ACONF->pmac.list[i].mac[1],
                       		ACONF->pmac.list[i].mac[2],ACONF->pmac.list[i].mac[3],
     	         		ACONF->pmac.list[i].mac[4],ACONF->pmac.list[i].mac[5] );
       				fprintf(fd,"\t\tfixed-address %d.%d.%d.%d;\n",
                      			ACONF->local.ip[0],ACONF->local.ip[1],
                       			ACONF->local.ip[2],ACONF->pmac.list[i].ip);
       				fprintf(fd,"\t}\n");
       				host++;
    			}
       		}

		/* ip range */
       		sort(ip_list,num);
         				
       		pmac1 = ACONF->dhcp.range[0];
       		for(i = 0 ; i < num ; i++)
       		{
       			if(pmac1 == ip_list[i])
       			{
       				pmac1 = ip_list[i] + 1;
       				continue;
       			}

       			pmac2 = ip_list[i] - 1;
       			fprintf(fd,"\trange %d.%d.%d.%d %d.%d.%d.%d;\n",
      				ACONF->local.ip[0],ACONF->local.ip[1],
       				ACONF->local.ip[2],pmac1,
      				ACONF->local.ip[0],ACONF->local.ip[1],
      				ACONF->local.ip[2],pmac2              );
            
      			pmac1 = ip_list[i] + 1;
      		}
                    
 		if(pmac1 != ip_list[i])
      			fprintf(fd,"\trange %d.%d.%d.%d %d.%d.%d.%d;\n",
      				ACONF->local.ip[0],ACONF->local.ip[1],
       				ACONF->local.ip[2],pmac1,
       				ACONF->local.ip[0],ACONF->local.ip[1],
       				ACONF->local.ip[2],ACONF->dhcp.range[1]);
      		/* tailer */
      		fprintf(fd,"}\n");

      		fclose(fd);

      		/* ------------------- */
       		/* restart dhcp server */
       		/* ------------------- */
          		
      		system("dhcpd eth0 &");
	  				
       	}
       	else //pmac disable
       	{
        	#ifdef FOR_DEBUG
   	    		printf("dhcpd: PMAC is disabled\r\n");
    		#endif
        			  
          	/* make /var/config/dhcpd.conf */
          	sprintf(temp,"dhcpdconf -r -a %d -b %d -c %d.%d.%d.%d -d %d.%d.%d.%d -e %d.%d.%d.%d -f %d.%d.%d.%d -g %d.%d.%d.%d -h %s -i %d.%d.%d.%d -j %s -k %s\r\n",
	    		temp_lease_time, //ACONF->dhcps.default_lease_time,
	    		temp_lease_time, //ACONF->dhcps.max_lease_time,
	    	        ACONF->local.ip[0],
	    	        ACONF->local.ip[1],
	    	        ACONF->local.ip[2],
	    	        0,
	    		0xff,0xff,0xff,0x00,
	    		ACONF->local.ip[0], ACONF->local.ip[1],
	    		ACONF->local.ip[2],ACONF->dhcp.range[0],	
	    		ACONF->local.ip[0], ACONF->local.ip[1],
	    		ACONF->local.ip[2],ACONF->dhcp.range[1],
	    		ACONF->local.ip[0], ACONF->local.ip[1],ACONF->local.ip[2],255,
	    		dns_ip1,
	    		ACONF->local.ip[0], ACONF->local.ip[1],ACONF->local.ip[2],ACONF->local.ip[3],
	    		dns_ip2,
	    		ACONF->dhcp.domain);
			
          	system(temp);
          			
          	#ifdef FOR_DEBUG
   	    		printf("dhcpd: Create dhcpd.conf (%s) over\r\n", temp);
    		#endif
    			
        }
      		
	// 5. --- Return from this function
	return 0;
}





/* ************* */
/* Set NAT       */
/* 0     : ok    */
/* other : error */
/* ************* */
int setnat(int act)
{
  	unsigned char temp[100];
	
	#ifdef FOR_DEBUG
    		printf("-------------------------------------------------------------------------------\r\n");
    		printf("Enter setnat %d procedure\n",act);
    	#endif
  
  	//close(2);	//marked by Lily 20020926
	
	// 3. --- Disable this function
	if (during_booting == 0)	// disable
	{
		if(ACONF->local.wtype == 2)	// pppoe
		{
			sprintf(temp, "iptables -t nat -D POSTROUTING -o ppp0 -s %d.%d.%d.%d/255.255.255.0 -j MASQUERADE",
				ACONF->local.ip[0], ACONF->local.ip[1],
				ACONF->local.ip[2], ACONF->local.ip[3]);
			system(temp);
			
			sprintf(temp,"iptables -t nat -D PREROUTING -i ppp0 -d %d.%d.%d.%d/24 -j DROP",
				ACONF->local.ip[0],ACONF->local.ip[1],
				ACONF->local.ip[2],ACONF->local.ip[3]);
			system(temp);
		}
		else	//Static or Dynamic
		{
			sprintf(temp,"iptables -t nat -D POSTROUTING -o eth1 -s %d.%d.%d.%d/255.255.255.0 -j MASQUERADE",
				ACONF->local.ip[0],ACONF->local.ip[1],
				ACONF->local.ip[2],ACONF->local.ip[3]);
			system(temp);
			
			sprintf(temp,"iptables -t nat -D PREROUTING -i eth1 -d %d.%d.%d.%d/24 -j DROP",
				ACONF->local.ip[0],ACONF->local.ip[1],
				ACONF->local.ip[2],ACONF->local.ip[3]);
			system(temp);
		}
	}
	
	// 4. --- Exit condition checking
	if (act == 0) return 0;
	
	// 5. --- Enable this function
	if(ACONF->local.wtype == 2)	//pppoe
	{
		sprintf(temp, "iptables -t nat -A POSTROUTING -o ppp0 -s %d.%d.%d.%d/255.255.255.0 -j MASQUERADE",
			ACONF->local.ip[0], ACONF->local.ip[1],
			ACONF->local.ip[2], ACONF->local.ip[3]);
		system(temp);
				
		sprintf(temp,"iptables -t nat -A PREROUTING -i ppp0 -d %d.%d.%d.%d/24 -j DROP",
			ACONF->local.ip[0],ACONF->local.ip[1],
			ACONF->local.ip[2],ACONF->local.ip[3]);
		system(temp);
	}
	else	//Static or Dynamic
	{
		sprintf(temp,"iptables -t nat -A POSTROUTING -o eth1 -s %d.%d.%d.%d/24 -j MASQUERADE",
			ACONF->local.ip[0],ACONF->local.ip[1],
			ACONF->local.ip[2],ACONF->local.ip[3]);
		system(temp);
		
		sprintf(temp,"iptables -t nat -A PREROUTING -i eth1 -d %d.%d.%d.%d/24 -j DROP",
			ACONF->local.ip[0],ACONF->local.ip[1],
			ACONF->local.ip[2],ACONF->local.ip[3]);
		system(temp);
	}
	
	// 6. Return from this function
	return 0;


}




/* ************* */
/* Set smap      */
/* 0     : ok    */
/* other : error */
/* ************* */

int setsmap(int act)
{

	char command[180], WANstr[6];
	int i;
	int isEnable = 0;

	
	#ifdef FOR_DEBUG
    		printf("-------------------------------------------------------------------------------\r\n");
    		printf("Enter setsmap %d (virtual server) procedure\r\n",act);
    	#endif
    	
	//close(2);	//marked by Lily 20020926
	
	if (during_booting == 0)
	{	
		system("iptables -t nat -D PREROUTING -i eth1 -j smap");
		system("iptables -t nat -D PREROUTING -i ppp0 -j smap");
		system("iptables -t nat -F smap");
		system("iptables -t nat -X smap");
	}

	if (act)	// starting enabled server mapping
	{
		for(i = 0; i < SMAP_NUM; i++)
		{
			if(ACONF->smap[i].flag == 1) {isEnable = 1; break;}
		}
		if(isEnable)
		{
			system("iptables -t nat -N smap");
			system("iptables -t nat -A smap -j RETURN");
			getWANstr(WANstr);
  			sprintf(command,"iptables -t nat -I PREROUTING -i %s -j smap",WANstr);
  			system(command);
			//system("iptables -t nat -I PREROUTING -i eth1 -j smap");
		}
		else return 0;
		
		for(i = 0; i < SMAP_NUM; i++)
		{
			if(ACONF->smap[i].flag == 1)
			{
				
				sprintf(command, "iptables -t nat -I smap -p tcp --dport %d:%d -j DNAT --to %d.%d.%d.%d",
					ACONF->smap[i].port, ACONF->smap[i].uport,
					ACONF->local.ip[0],
					ACONF->local.ip[1],
					ACONF->local.ip[2],
					ACONF->smap[i].host);
				system(command);
				
				#ifdef FOR_DEBUG
					printf("setsmap: (%d)%s\n", i, command);
				#endif
				
				memcpy(&command[27], "udp", 3);
				system(command);
				
				#ifdef FOR_DEBUG
					printf("setsmap: (%d)%s\r\n", i, command);
				#endif	
				
				if(ACONF->smap[i].port<=500 && ACONF->smap[i].uport>=500)
				{
					sprintf(command, "iptables -t nat -I smap -p 50 -j DNAT --to %d.%d.%d.%d",
					ACONF->local.ip[0],
					ACONF->local.ip[1],
					ACONF->local.ip[2],
					ACONF->smap[i].host);
					system(command);

					#ifdef FOR_DEBUG
						printf("setsmap: (%d)%s\r\n", i, command);
					#endif
				}

			}
		}
	}

	return 0;
}




/* ************* */
/* Set DMZ host  */
/* 0     : ok    */
/* other : error */
/* ************* */
int setdmz(int act)
{

  	char temp[180], WANstr[6];

  	// 1. --- Function indication message
  	#ifdef FOR_DEBUG
    		printf("-------------------------------------------------------------------------------\r\n");
    		printf("Enter setdmz %d procedure\r\n",act);
    	#endif
  	
  	// 2. --- Function initialization
  	//close(2);	//marked by Lily 20020926
  	getWANstr(WANstr);
  	sprintf(temp,
    		"iptables -t nat -D PREROUTING -p tcp -i %s -j DNAT --to %d.%d.%d.%d",
    		WANstr,
		ACONF->local.ip[0], ACONF->local.ip[1],	ACONF->local.ip[2], 
		ACONF->local.dmz_host);

	// 3. --- Disable this function first
  	if (during_booting == 0) 
  	{
  		system(temp);    		
    		#ifdef FOR_DEBUG
    			printf("setdmz disable: %s\r\n",temp);
    		#endif
    		
    		memcpy(&temp[33], "udp", 3);
    		system(temp);    		
    		#ifdef FOR_DEBUG
    			printf("setdmz disable: %s\r\n",temp);
    		#endif	
  	}
  	
  	// 4. --- Exit condition checking
  	if (act == 0) return 0;	
	if((ACONF->local.wflag & LFLAG_DMZ) != LFLAG_DMZ) return 0;
    	
    	// 5. --- Enable this function	
      	sprintf(temp,
    		"iptables -t nat -A PREROUTING -p tcp -i %s -j DNAT --to %d.%d.%d.%d",
    		WANstr,
		ACONF->local.ip[0], ACONF->local.ip[1],	ACONF->local.ip[2], 
		ACONF->local.dmz_host);
	system(temp);
      	#ifdef FOR_DEBUG
    		printf("setdmz 1&enable: %s\r\n",temp);
    	#endif
    			
      	memcpy(&temp[33], "udp", 3);
      	system(temp);		
      	#ifdef FOR_DEBUG
    		printf("setdmz 1&enable: %s\r\n",temp);
    	#endif
  	
  	return 0;
  
}





/* ****************** */
/* set block wan ping */
/* ****************** */

int setbwping(int act)
{
	char temp[180], WANstr[6];
	
	#ifdef FOR_DEBUG
    		printf("-------------------------------------------------------------------------------\r\n");
    		printf("Enter setbwping %d procedure\r\n",act);
    	#endif
	
	//close(2);	//marked by Lily 20020926
	
	getWANstr(WANstr);
	
	if (act)	// if function is enable, go to start it.
	{
		//check the bit to see if need to on.
		if((ACONF->local.wflag & LFLAG_BWPING) == LFLAG_BWPING) {
			//system("iptables -A INPUT -p icmp --icmp-type ping -i eth1??? -j DROP");
			//system("iptables -t nat -A PREROUTING -p icmp --icmp-type ping -i eth1 -j DROP");
			sprintf(temp,
    				"iptables -t nat -A PREROUTING -p icmp --icmp-type ping -i %s -j DROP",
    				WANstr);
      			system(temp);
      			usleep(SLEEP_TIME);
			#ifdef FOR_DEBUG
    				printf("setbwping 1&eable: iptables -t nat -A PREROUTING -p icmp --icmp-type ping -i %s -j DROP\r\n",WANstr);
    			#endif
		}
	}
	else	// if function is enable, go to close it.
	{
		//if((ACONF->local.wflag & LFLAG_BWPING) == LFLAG_BWPING) {
			//system("iptables -D INPUT -p icmp --icmp-type ping -i eth1 -j DROP");
			system("iptables -t nat -D PREROUTING -p icmp --icmp-type ping -i eth1 -j DROP");
			system("iptables -t nat -D PREROUTING -p icmp --icmp-type ping -i ppp0 -j DROP");
			#ifdef FOR_DEBUG
    				//printf("setdmz 0&enable: iptables -t nat -D PREROUTING -p icmp --icmp-type ping -i eth1 -j DROP\r\n");
    				printf("setbwping 0: iptables -t nat -D PREROUTING -p icmp --icmp-type ping -i eth1 -j DROP\r\n");
    				printf("setbwping 0: iptables -t nat -D PREROUTING -p icmp --icmp-type ping -i ppp0 -j DROP\r\n");
    			#endif
		//}
	}

	return 1;
}





/* ************* */
/* Set  PPTPD    */
/* 0     : ok    */
/* other : error */
/* ************* */
/*
int setpptpd(int act)
{

  char temp[180], WANstr[6];
  char pid[15];
  FILE *fd;
  int child_id;
  
  //close(2);	//marked by Lily 20020926
  
  getWANstr(WANstr);
  
  if (act == 1){
     
     //sprintf(temp,"iptables -t nat -I PREROUTING -i eth1 -p tcp --dport 1723 -j ACCEPT");
     sprintf(temp,"iptables -t nat -I PREROUTING -i %s -p tcp --dport 1723 -j ACCEPT",WANstr);
     system(temp);
     
     sprintf(temp,"pptpdconf -a %d.%d.%d.%d -b %d.%d.%d.%d -c %d",
     		ACONF->local.ip[0],ACONF->local.ip[1],ACONF->local.ip[2],ACONF->pptp.localIP[3],
		ACONF->local.ip[0],ACONF->local.ip[1],ACONF->local.ip[2],ACONF->pptp.start,
		ACONF->pptp.end);
     //sprintf(temp,"pptpdconf -a %d.%d.%d.%d -b %d.%d.%d.%d -c %d.%d.%d.%d",
     	//	ACONF->local.rhip[0],ACONF->local.rhip[1],ACONF->local.rhip[2],ACONF->pptp.localIP[3],
	//	ACONF->local.rhip[0],ACONF->local.rhip[1],ACONF->local.rhip[2],ACONF->pptp.start,
	//	ACONF->local.rhip[0],ACONF->local.rhip[1],ACONF->local.rhip[2],ACONF->pptp.end);
     system(temp);
     
     //system("pptpd");	//modified by Lily 20020926
	 child_id = fork();
	 if(child_id==0)
	 {
	 	setsid();
		umask(0);
	 	execl("/bin/pptpd","pptpd",NULL);
		exit(0);
	 }
	 else
	 {
	 }
     
  }
  else
  {
  
     sprintf(temp,"iptables -t nat -D PREROUTING -i eth1 -p tcp --dport 1723 -j ACCEPT");
     sprintf(temp,"iptables -t nat -D PREROUTING -i ppp0 -p tcp --dport 1723 -j ACCEPT");
     system(temp);
     
     //system("pptpdconf");
     if((fd = fopen("/var/run/pptpd.pid","r")) != NULL) {
     	fgets(pid,10,fd);
     	sprintf(temp,"kill %s",pid);
     	printf("%s\n",temp);
     	system(temp);
     	fclose(fd);
	if((fd= fopen("/var/run/pptpd.pid","w")) !=NULL) {
		fprintf(fd,"");
		fclose(fd);
	}
     }
     
  }
}
*/







/* ************* */
/* Set PPPD      */
/* 0     : ok    */
/* other : error */
/* ************* */
/*
int setpppd(int act)
{
  unsigned char temp[50];
  FILE *fd,*fd2;


  //close(2);	//marked by Lily 20020926

  if(act == 0) {

  } else if(act == 1) {

    //options file
    strcpy(temp,"pppdconf ");

    if(ACONF->pppd.pap != 0)
      strcat(temp,"-a ");
      usleep(SLEEP_TIME);
    if(ACONF->pppd.chap != 0)
      strcat(temp,"-b ");
      usleep(SLEEP_TIME);
    if(ACONF->pppd.mschap != 0)
      strcat(temp,"-c ");
      usleep(SLEEP_TIME);
    if(ACONF->pppd.mschap2 != 0)
      strcat(temp,"-d ");
      usleep(SLEEP_TIME);

    system(temp);

    //secrets files
    if(((fd  = fopen("/var/config/pap-secrets","w")) == NULL) ||
       ((fd2 = fopen("/var/config/chap-secrets","w")) == NULL)  ) {
      fprintf(stderr,"[pppd secrets maker] open file error!!\r\n");
    }
#if 1
    //1
    fprintf(fd,"%s\t*\t%s\t*\n",ACONF->pppd.name1,ACONF->pppd.pass1);
    usleep(500);
    fprintf(fd2,"%s\t*\t%s\t*\n",ACONF->pppd.name1,ACONF->pppd.pass1);
    usleep(500);
    //2
    fprintf(fd,"%s\t*\t%s\t*\n",ACONF->pppd.name2,ACONF->pppd.pass2);
    usleep(500);
    fprintf(fd2,"%s\t*\t%s\t*\n",ACONF->pppd.name2,ACONF->pppd.pass2);
    usleep(500);
    //3
    fprintf(fd,"%s\t*\t%s\t*\n",ACONF->pppd.name3,ACONF->pppd.pass3);
    usleep(SLEEP_TIME);
    fprintf(fd2,"%s\t*\t%s\t*\n",ACONF->pppd.name3,ACONF->pppd.pass3);
    usleep(SLEEP_TIME);
    //4
    fprintf(fd,"%s\t*\t%s\t*\n",ACONF->pppd.name4,ACONF->pppd.pass4);
    usleep(SLEEP_TIME);
    fprintf(fd2,"%s\t*\t%s\t*\n",ACONF->pppd.name4,ACONF->pppd.pass4);
    usleep(SLEEP_TIME);
#endif

    fclose(fd);
    fclose(fd2);
  }
}
*/

/* ****************** */
/* for Set special ap */
/* ****************** */

int htoi(char *src, int len)
{
        int i;
        int result;
        char temp;

        for(i = len - 1, result = 0; i >=0; i--)
        {
                temp = *(src + i);
                if(temp >= '0' && temp <= '9')
                        result += (temp - '0') << (4 * (len - i - 1));
                else if(temp >= 'a' && temp <= 'f')
                        result += (temp - 'a' + 10) << (4 * (len - i - 1));
                else
                        return -1;
        }
        return result;
}

/* ****************** */
/* for Set special ap */
/* ****************** */

int atoh(char *src, char *dst, int dst_len)
{
        char temp[] = "0000000000";
        int len;

        // the required length is longer than the length of temp,
        // so we can't create this string.
        if(dst_len >= strlen(temp))
                return 0;

        sprintf(dst, "%x", atoi(src));
        len = dst_len - strlen(dst);
        if(len != 0)
        {
                memcpy(temp + len, dst, strlen(dst));
                temp[dst_len] = 0;
                memcpy(dst, temp, dst_len + 1);
#ifdef DEBUG
                fprintf(stderr, "dst = %s\n", dst);
#endif
                return 1;
        }
        else
        {
#ifdef DEBUG
                fprintf(stderr, "dst = %s\n", dst);
#endif
                return 1;
        }
}


/* ************** */
/* Set Special Ap */
/* 0     : ok     */
/* other : error  */
/* ************** */

int setspap(int act)
{
	char command[180], WANstr[6];	// 105 is the best
	char dec_port[6];
	char hex_port[5];
	int i, j;
	FILE *conf;
	FILE *dmz;
	FILE *pidf;
	char host_info[25];
	char port_range[12];
	char ip[16];
	FILE *host;
	char pid[8];
	FILE *spapd_pid;
	char temp;
  	unsigned char found;
  	int child_id;
  	unsigned char to_be_enable;

	// 1. --- Entrance
	#ifdef FOR_DEBUG
		printf("-------------------------------------------------------------------------------\r\n");
		printf("Enter setspap (%d)\r\n",act);
	#endif
	
	// 1.5. --- Function initialization
	found = 0;
	for(i = 0; i < SPAP_NUM; i++) if(ACONF->spap.trig[i].flag == 1) {found = 1; break;}
	if ((act == 0) || (found == 0)) to_be_enable = 0; else to_be_enable = 1;
	
	// 2. --- Close standard error output
  	//close(2);	//marked by Lily 20020926
  	
  	// 3. --- Function initialization
  	getWANstr(WANstr);
  	
  	// 4. --- Disable this function
  	if (during_booting == 0)
	{
		
	  	// 4.1 --- remove WAN to LAN rules
	  	#ifdef FOR_DEBUG
			printf("setspap: Remove WAN to LAN rules\r\n");
		#endif
		system("iptables -t nat -D PREROUTING -i eth1 -j spap_in");
		system("iptables -t nat -D PREROUTING -i ppp0 -j spap_in");
		system("iptables -t nat -F spap_in");
		if (to_be_enable == 0) {
			system("iptables -t nat -X spap_in");
		} 
		
		system("iptables -t mangle -D PREROUTING -i eth1 -j spap_in");
		system("iptables -t mangle -D PREROUTING -i ppp0 -j spap_in");
		system("iptables -t mangle -F spap_in");
		if (to_be_enable == 0) {
			system("iptables -t mangle -X spap_in");
		}
		
		system("iptables -t filter -D FORWARD -i eth1 -j spap_in");
		system("iptables -t filter -D FORWARD -i ppp0 -j spap_in");
		system("iptables -t filter -F spap_in");
		if (to_be_enable == 0) {
			system("iptables -t filter -X spap_in");
		}

		// 4.2 --- remove LAN to WAN rules
		#ifdef FOR_DEBUG
			printf("setspap: Remove LAN to WAN rules\r\n");
		#endif
		sprintf(command, "iptables -t mangle -D PREROUTING -i eth0 -s ! %d.%d.%d.%d -j spap_out",
			ACONF->local.ip[0], ACONF->local.ip[1],	ACONF->local.ip[2],
			ACONF->local.dmz_host);
		system(command);
		sprintf(command, "iptables -t mangle -D PREROUTING -i eth0 -j spap_out");
		system(command);
		system("iptables -t mangle -F spap_out");
		if (to_be_enable == 0) 
		{	
			system("iptables -t mangle -X spap_out");
		}
		
		sprintf(command, "iptables -t filter -D FORWARD -i eth0 -s ! %d.%d.%d.%d -j spap_out",
			ACONF->local.ip[0],
			ACONF->local.ip[1],
			ACONF->local.ip[2],
			ACONF->local.dmz_host);
		system(command);
		sprintf(command, "iptables -t filter -D FORWARD -i eth0 -j spap_out");
		system(command);
		sprintf(command, "iptables -t filter -D FORWARD -i eth0 -j spap_out");
		system(command);
		system("iptables -t filter -F spap_out");
		if (to_be_enable == 0) 
		{	
			system("iptables -t filter -X spap_out");
		}
	
	}	
	
	{
		// 4.3 --- remove some files and kill spapd	
		remove("/var/config/spap/spap.conf");
		remove("/var/config/spap/spap.host");
		#ifdef FOR_DEBUG
			printf("setspap: Remove spap.conf and .host\r\n");
		#endif
		
		if (cold_start == 0) {
			system("killall spapd");
			#ifdef FOR_DEBUG
				printf("setspap: kill spapd\r\n");
			#endif
		}
		
		system("monitor 91 66 0");
		#ifdef FOR_DEBUG
			printf("setspap: Call monitor 1 66 0 to decrease the use count of mangle table\r\n");
		#endif
		system("monitor 91 56 0");
		#ifdef FOR_DEBUG
			printf("setspap: Call monitor 1 56 0 to decrease the use count of filter table\r\n");
		#endif
		if (during_booting|found) system("monitor 91 78 0"); else system("monitor 1 78 0");
		#ifdef FOR_DEBUG
			printf("setspap: Call monitor 1 78 0 to decrease the use count of ipqueue\r\n");
		#endif
	}
	
	// 5. --- Exit condition checking
	if (to_be_enable == 0) return 0;

	// 6. --- Enable this function
	{
		system("monitor 91 66 1");
		system("monitor 1 56 1");
		 
		// 6.1 --- Create spap_out chain in mangle table
		#ifdef FOR_DEBUG
			printf("setspap: Create spap_out chain in mangle table\r\n");
		#endif
		system("iptables -t mangle -N spap_out");
		if ((ACONF->local.wflag & LFLAG_DMZ) == LFLAG_DMZ) {
			sprintf(command, 
				"iptables -t mangle -A PREROUTING -i eth0 -s ! %d.%d.%d.%d -j spap_out",
				ACONF->local.ip[0], ACONF->local.ip[1],
				ACONF->local.ip[2], ACONF->local.dmz_host);
			system(command);
		}
		else
		{
			system("iptables -t mangle -A PREROUTING -i eth0 -j spap_out");
		}
		system("iptables -t mangle -A spap_out -j RETURN");
		
		// 6.2 ---
		#ifdef FOR_DEBUG
			printf("setspap: Create spap_out chain in filter table\r\n");
		#endif
		system("iptables -t filter -N spap_out");
		if ((ACONF->local.wflag & LFLAG_DMZ) == LFLAG_DMZ) {
			sprintf(command, 
				"iptables -t filter -A FORWARD -i eth0 -s ! %d.%d.%d.%d -j spap_out",
				ACONF->local.ip[0], ACONF->local.ip[1],
				ACONF->local.ip[2], ACONF->local.dmz_host);
			system(command);
		} else {
			system("iptables -t filter -A FORWARD -i eth0 -j spap_out");
		}
		system("iptables -t filter -A spap_out -j RETURN");
		
		// 6.3 ---
		#ifdef FOR_DEBUG
			printf("setspap: Create configure file (/var/config/spap/spap.conf) and set rules in spap_out chain\r\n");
		#endif
		conf = fopen("/var/config/spap/spap.conf", "w");
		//fseek(conf, 0L, SEEK_SET);
		for(i = 0; i < SPAP_NUM; i++)
		{
			// enable
			if(ACONF->spap.trig[i].flag == 1)
			{
				sprintf(command, "iptables -t mangle -I spap_out -p tcp --dport %d -j MARK --set-mark %d",
					ACONF->spap.trig[i].port, i + 100);
				system(command);

				memcpy(&command[34], (void *)"udp", 3);
				system(command);

				sprintf(command, "iptables -t filter -I spap_out -p tcp --dport %d -j QUEUE",
					ACONF->spap.trig[i].port);
				system(command);

				memcpy(&command[34], (void *)"udp", 3);
				system(command);

				// ------ write to "spap.conf" ------
				sprintf(dec_port, "%d", ACONF->spap.trig[i].port);
                                atoh(dec_port, hex_port, 4);
                                fprintf(conf, "1%s", hex_port);
                                for(j = ACONF->spap.trig[i].sp0; j <= ACONF->spap.trig[i].sp1; j++)
                                {
                                	sprintf(dec_port, "%d", ACONF->spap.sepl[j].lb);
                        	        atoh(dec_port, hex_port, 4);
                	                fprintf(conf, "%s", hex_port);
        	                        sprintf(dec_port, "%d", ACONF->spap.sepl[j].ub);
	                                atoh(dec_port, hex_port, 4);
                                	fprintf(conf, "%s", hex_port);
                        	}
                        	fprintf(conf, "\n");
			}
			// disable
			else
			{
				// ------ write to "spap.conf" ------
				sprintf(dec_port, "%d", ACONF->spap.trig[i].port);
				atoh(dec_port, hex_port, 4);
				fprintf(conf, "0%s", hex_port);
				for(j = ACONF->spap.trig[i].sp0; j <= ACONF->spap.trig[i].sp1; j++)
                                {
					sprintf(dec_port, "%d", ACONF->spap.sepl[j].lb);
					atoh(dec_port, hex_port, 4);
					fprintf(conf, "%s", hex_port);
					sprintf(dec_port, "%d", ACONF->spap.sepl[j].ub);
					atoh(dec_port, hex_port, 4);
					fprintf(conf, "%s", hex_port);
				}
				fprintf(conf, "\n");
			}
			
		}
		fclose(conf);
		
		// 6.4 ---
		#ifdef FOR_DEBUG
			printf("setspap: Create spap_in chain in nat table\r\n");
		#endif
		system("iptables -t nat -N spap_in");
		system("iptables -t nat -A spap_in -j RETURN");
		sprintf(command,"iptables -t nat -I PREROUTING -i %s -j spap_in",WANstr);
		system(command);
		//system("iptables -t nat -I PREROUTING -i eth1 -j spap_in");
		
		// 6.5 ---
		#ifdef FOR_DEBUG
			printf("setspap: Create spap_in chain in mangle table\r\n");
		#endif
		system("iptables -t mangle -N spap_in");
		system("iptables -t mangle -A spap_in -j RETURN");
		sprintf(command,"iptables -t mangle -I PREROUTING -i %s -j spap_in",WANstr);
		system(command);
		//system("iptables -t mangle -I PREROUTING -i eth1 -j spap_in");
		
		// 6.6 ---
		#ifdef FOR_DEBUG
			printf("setspap: Create spap_in chain in filter table\r\n");
		#endif
		system("iptables -t filter -N spap_in");
		system("iptables -t filter -A spap_in -j RETURN");
		//system("iptables -t filter -I FORWARD -i eth1 -j spap_in");
		sprintf(command,"iptables -t filter -I FORWARD -i %s -j spap_in",WANstr);
		system(command);
		
		// 6.7 ---
		#ifdef FOR_DEBUG
			printf("setspap: Create some files (/var/config/spap/spap.host,dmz)\r\n");
		#endif
		host = fopen("/var/config/spap/spap.host", "w");
		for(i = 0; i < SPAP_NUM; i++)
		{
			fprintf(host, "000000000000000000000000\n");
		}
		fclose(host);
		#ifdef FOR_DEBUG
			printf("setspap: /var/config/spap/spap.host:\r\n");
			system("cat /var/config/spap/spap.host");
		#endif
		// generate dmz file
		if ((ACONF->local.wflag & LFLAG_DMZ) == LFLAG_DMZ) {
			dmz = fopen("/var/config/spap/dmz", "w");
			fprintf(dmz, "%d.%d.%d.%d", ACONF->local.ip[0],	ACONF->local.ip[1],
				ACONF->local.ip[2], ACONF->local.dmz_host);
			fclose(dmz);
		}
		
		// 6.7 ---
		#ifdef FOR_DEBUG
			printf("setspap: startup spapd, ip_queue, ipqueue\r\n");
		#endif
		#if 1
			i = -99; 
			while (i == -99) {
		  		if (during_booting) i = system("monitor 91 78 1"); 
		  		else i = system("monitor 1 78 1");
			}
			system("spapd&");
		#else
			system("modprobe ip_queue");
			#if 1
			system("ipqueue&");	//modified by Lily 20020926
			system("spapd&");	//modified by Lily 20020926
			#else
			child_id = fork();
			if(child_id==0)
			{
				setsid(); umask(0); execl("/bin/ipqueue","ipqueue",NULL); exit(0);
			}
			child_id = fork();
			if(child_id==0)
			{
				setsid(); umask(0); execl("/bin/spapd","spapd",NULL); exit(0);
			}
			#endif
		#endif
		
	}
	
	// 7. --- Return from this function
	return 0;

}


/* **************************** */
/* set firewall                 */
/* KM modify 20020913           */
/* because iptables can use     */
/* ip range xxx.ooo.xxx.ooo-xxx */
/* **************************** */

/*KM modify 20020913
void getNetmask(DWORD ip1, DWORD ip2, BYTE *nmask)
{
	BYTE *temp_ip1, *temp_ip2;
	int i;
	BYTE op1, op2;

	if(ip1 == 0 && ip2 == 0)
	{
		nmask[0] = 0; nmask[1] = 0; nmask[2] = 0; nmask[3] = 0; return ;
	}

	temp_ip1 = (BYTE *)&ip1;
	temp_ip2 = (BYTE *)&ip2;

	for(i = 0; i < 4; i++)
	{
		if (*(temp_ip1 + i) != *(temp_ip2 + i))	break;
		else *(nmask + i) = 255;
	}
	op1 = ~(*(temp_ip1 + i) | *(temp_ip2 + i));
	op2 = *(temp_ip1 + i) & *(temp_ip2 + i);
	*(nmask + i) = op1 | op2;
	i++;
	while(i < 4)
	{
		*(nmask + i) = 0;
		i++;
	}
//#ifdef DEBUG
	fprintf(stdout, "getNetmask: %d.%d.%d.%d\n", nmask[0], nmask[1], nmask[2], nmask[3]);
//#endif
}

void getNetid(DWORD ip, DWORD *nm, DWORD *netid)
{
//#ifdef DEBUG
	BYTE *dbg;
//#endif
	*netid = ip & *nm;
//#ifdef DEBUG
	dbg = (BYTE *)netid;
	fprintf(stdout, "getNetid: %d.%d.%d.%d\n", dbg[0], dbg[1], dbg[2], dbg[3]);
//#endif
}
 KM modify end */

int setfirewall(int act)
{
	char command[180], WANstr[6];	// about 160 is enough
	WORD rflag_prot;
	char prot[4];
	char policy[7];
	BYTE *sip_lower,*dip_lower;
	unsigned char check1, check2;
	int i;
	int sport_lower, sport_upper, dport_lower, dport_upper, snetmask, dnetmask;
	unsigned char have_sport, have_dport;
	char sip_str[24], dip_str[24], sport_str[12], dport_str[12];

	// 1. --- Entrance
	#ifdef FOR_DEBUG
		printf("-------------------------------------------------------------------------------\r\n");
		printf("Enter firewall (%d)\r\n",act);
	#endif
	
	// 2. --- Function initialization
	getWANstr(WANstr);
	check1 = (ACONF->actl.ipf.flag[1] & FDF_ENABLED);	//inbound
	check2 = (ACONF->actl.ipf.flag[0] & FDF_ENABLED);	//outbound
	#ifdef FOR_DEBUG
		printf("setfirewall: inbound: %d, outbound: %d\r\n",check1,check2);
	#endif
	
	
	// 3. --- Disable this function
	if (during_booting == 0) 
	{
		// inbound
		system("iptables -t filter -D FORWARD -i eth1 -j inbound");
		system("iptables -t filter -D FORWARD -i ppp0 -j inbound");
		system("iptables -t filter -F inbound");
		if (check1 == 0) system("iptables -t filter -X inbound");
		#ifdef FOR_DEBUG
			printf("setfirewall: remove inbound chain and rules in filter table\r\n");
		#endif
	
		// outbound
		system("iptables -t filter -D FORWARD -o eth1 -j outbound");
		system("iptables -t filter -D FORWARD -o ppp0 -j outbound");
		system("iptables -t filter -F outbound");
		if (check2 == 0) system("iptables -t filter -X outbound");
		#ifdef FOR_DEBUG
			printf("setfirewall: remove outbound chain and rules in filter table\r\n");
		#endif
	}

	// 4. --- Exit condition checking
	if ((act==0) || ((check1|check2) == 0)) {system("monitor 1 57 0"); return 0;}
	
	
	// 5. --- Enable this function
	{
		system("monitor 1 57 1");
	
		// inbound
		if(check1)
		{
			system("iptables -t filter -N inbound");
			sprintf(command,"iptables -t filter -A FORWARD -i %s -j inbound",WANstr);
			system(command);
			#ifdef FOR_DEBUG
				printf("setfirewall: Create inbound chain and a chaining rule in filter table\r\n");
			#endif
			
			if((ACONF->actl.ipf.flag[1] & FDF_PASSRULE) == FDF_PASSRULE)
			{
				//acceptMdrop -- Lily
				sprintf(policy, "ACCEPT");
				system("iptables -t filter -A inbound -j DROP");
				#ifdef FOR_DEBUG
					printf("setfirewall: Create a rules in inbound chain to DROP allother rules\r\n");
				#endif
			}
			else
			{
				sprintf(policy, "DROP");
				system("iptables -t filter -A inbound -j ACCEPT");
				#ifdef FOR_DEBUG
					printf("setfirewall: Create a rules in inbound chain to ACCEPT allother rules\r\n");
				#endif
			}
			
			for(i = PF_RULE_NUM; i < PF_RULE_NUM * 2; i++)
			{
				// rule:1
				if((ACONF->actl.ipf.rule[i].rflag & FRF_ENABLED) != FRF_ENABLED) continue;//disable rule
				
				// rule:2	
				rflag_prot = (ACONF->actl.ipf.rule[i].rflag & FRF_PROT_MASK);
				switch(rflag_prot)
				{
					case FRF_PROT_BOTH:
						*prot = 1;
						break;
					case FRF_PROT_TCP:
						sprintf(prot, "tcp");
						break;
					case FRF_PROT_UDP:
						sprintf(prot, "udp");
						break;
				}
				
				// rule:3
				sip_lower=(BYTE *)&ACONF->actl.ipf.rule[i].ip0[0];
				snetmask=ACONF->actl.ipf.rule[i].ip1[0];
				sprintf(sip_str,"%d.%d.%d.%d/%d",*sip_lower,*(sip_lower+1),*(sip_lower+2),*(sip_lower+3),snetmask);
				sport_lower=ACONF->actl.ipf.rule[i].port0[0];
				sport_upper=ACONF->actl.ipf.rule[i].port1[0];
				have_sport=sport_lower|sport_upper;
				sprintf(sport_str,"%d:%d",sport_lower,sport_upper);
				
				dip_lower=(BYTE *)&ACONF->actl.ipf.rule[i].ip0[1];
				dnetmask=ACONF->actl.ipf.rule[i].ip1[1];
				sprintf(dip_str,"%d.%d.%d.%d/%d",*dip_lower,*(dip_lower+1),*(dip_lower+2),*(dip_lower+3),dnetmask);
				dport_lower=ACONF->actl.ipf.rule[i].port0[1];
				dport_upper=ACONF->actl.ipf.rule[i].port1[1];
				have_dport=dport_lower|dport_upper;
				sprintf(dport_str,"%d:%d",dport_lower,dport_upper);
				
				// rule:4
				if(*prot == 1)	// protocol = all
				{
					// none sport
					if(have_sport == 0)
					{
						// none sport, none dport
						if(have_dport == 0)
						{
							sprintf(command, "iptables -t filter -I inbound -p tcp -s %s -d %s -j %s",
								sip_str, dip_str, policy);
							system(command);
							#ifdef FOR_DEBUG
								printf("setfirewall: %s\r\n",command);
							#endif
						
							memcpy(&command[33], "udp", 3);
							system(command);
							#ifdef FOR_DEBUG
								printf("setfirewall: %s\r\n",command);
							#endif
						}
						// none sport, have dport
						else
						{
							sprintf(command, "iptables -t filter -I inbound -p tcp -s %s -d %s --dport %s -j %s",
								sip_str, dip_str, dport_str, policy);
							system(command);
							#ifdef FOR_DEBUG
								printf("setfirewall: %s\r\n",command);
							#endif
							
							memcpy(&command[33], "udp", 3);
							system(command);
							#ifdef FOR_DEBUG
								printf("setfirewall: %s\r\n",command);
							#endif
						}
					}
					// have sport
					else
					{
						// have sport, none dport
						if(have_dport == 0)
						{
							sprintf(command, "iptables -t filter -I inbound -p tcp -s %s --sport %s -d %s -j %s",
								sip_str, sport_str, dip_str, policy);
							system(command);
							#ifdef FOR_DEBUG
								printf("setfirewall: %s\r\n",command);
							#endif
							
							memcpy(&command[33], "udp", 3);
							system(command);
							#ifdef FOR_DEBUG
								printf("setfirewall: %s\r\n",command);
							#endif
						}
						// have sport, have dport
						else
						{
							sprintf(command, "iptables -t filter -I inbound -p tcp -s %s --sport %s -d %s --dport %s -j %s",
								sip_str, sport_str, dip_str, dport_str, policy);
							system(command);
							#ifdef FOR_DEBUG
								printf("setfirewall: %s\r\n",command);
							#endif
							
							memcpy(&command[33], "udp", 3);
							system(command);
							#ifdef FOR_DEBUG
								printf("setfirewall: %s\r\n",command);
							#endif
						}
					}
				}
				else	// protocol only tcp or udp
				{
					// none sport
					if(have_sport == 0)
					{
						// none sport, none dport
						if(have_dport == 0)
						{
							sprintf(command, "iptables -t filter -I inbound -p %s -s %s -d %s -j %s",
								prot, sip_str, dip_str, policy);
							system(command);
							#ifdef FOR_DEBUG
								printf("setfirewall: %s\r\n",command);
							#endif
						}
						// none sport, have dport
						else
						{
							sprintf(command, "iptables -t filter -I inbound -p %s -s %s -d %s --dport %s -j %s",
								prot, sip_str, dip_str, dport_str, policy);
							system(command);
							#ifdef FOR_DEBUG
								printf("setfirewall: %s\r\n",command);
							#endif
						}
					}
					// have sport
					else
					{
						// have sport, none dport
						if(have_dport == 0)
						{
							sprintf(command, "iptables -t filter -I inbound -p %s -s %s --sport %s -d %s -j %s",
								prot, sip_str, sport_str, dip_str, policy);
							system(command);
							#ifdef FOR_DEBUG
								printf("setfirewall: %s\r\n",command);
							#endif
						}
						// have sport, have dport
						else
						{
							sprintf(command, "iptables -t filter -I inbound -p %s -s %s --sport %s -d %s --dport %s -j %s",
								prot, sip_str, sport_str, dip_str, dport_str, policy);
							system(command);
							#ifdef FOR_DEBUG
								printf("setfirewall: %s\r\n",command);
							#endif
						}
					}
				}
			}
		}
		
		// outbound
		if(check2)
		{
			system("iptables -t filter -N outbound");
			sprintf(command,"iptables -t filter -A FORWARD -o %s -j outbound",WANstr);
			system(command);
			#ifdef FOR_DEBUG
				printf("setfirewall: Create outbound chain and a chaining rule in filter table\r\n");
			#endif
			
			if((ACONF->actl.ipf.flag[0] & FDF_PASSRULE) == FDF_PASSRULE)
			{
				//acceptMdrop -- Lily
				sprintf(policy, "ACCEPT");
				system("iptables -t filter -A outbound -j DROP");
				#ifdef FOR_DEBUG
					printf("setfirewall: Create a rules in outbound chain to DROP allother rules\r\n");
				#endif
			}
			else
			{
				sprintf(policy, "DROP");
				system("iptables -t filter -A outbound -j ACCEPT");
				#ifdef FOR_DEBUG
					printf("setfirewall: Create a rules in outbound chain to ACCEPT allother rules\r\n");
				#endif
			}
			
			for(i = 0; i < PF_RULE_NUM; i++)
			{
				// rule:1
				if((ACONF->actl.ipf.rule[i].rflag & FRF_ENABLED) != FRF_ENABLED) continue;//disable rule
				
				// rule:2	
				rflag_prot = (ACONF->actl.ipf.rule[i].rflag & FRF_PROT_MASK);
				switch(rflag_prot)
				{
					case FRF_PROT_BOTH:
						*prot = 1;
						break;
					case FRF_PROT_TCP:
						sprintf(prot, "tcp");
						break;
					case FRF_PROT_UDP:
						sprintf(prot, "udp");
						break;
				}
				
				// rule:3
				sip_lower=(BYTE *)&ACONF->actl.ipf.rule[i].ip0[0];
				snetmask=ACONF->actl.ipf.rule[i].ip1[0];
				sprintf(sip_str,"%d.%d.%d.%d/%d",*sip_lower,*(sip_lower+1),*(sip_lower+2),*(sip_lower+3),snetmask);
				sport_lower=ACONF->actl.ipf.rule[i].port0[0];
				sport_upper=ACONF->actl.ipf.rule[i].port1[0];
				have_sport=sport_lower|sport_upper;
				sprintf(sport_str,"%d:%d",sport_lower,sport_upper);
				
				dip_lower=(BYTE *)&ACONF->actl.ipf.rule[i].ip0[1];
				dnetmask=ACONF->actl.ipf.rule[i].ip1[1];
				sprintf(dip_str,"%d.%d.%d.%d/%d",*dip_lower,*(dip_lower+1),*(dip_lower+2),*(dip_lower+3),dnetmask);
				dport_lower=ACONF->actl.ipf.rule[i].port0[1];
				dport_upper=ACONF->actl.ipf.rule[i].port1[1];
				have_dport=dport_lower|dport_upper;
				sprintf(dport_str,"%d:%d",dport_lower,dport_upper);
				
				// rule:4
				if(*prot == 1)	// protocol = all
				{
					// none sport
					if(have_sport == 0)
					{
						// none sport, none dport
						if(have_dport == 0)
						{
							sprintf(command, "iptables -t filter -I outbound -p tcp -s %s -d %s -j %s",
								sip_str, dip_str, policy);
							system(command);
							#ifdef FOR_DEBUG
								printf("setfirewall: %s\r\n",command);
							#endif
						
							memcpy(&command[34], "udp", 3);
							system(command);
							#ifdef FOR_DEBUG
								printf("setfirewall: %s\r\n",command);
							#endif
						}
						// none sport, have dport
						else
						{
							sprintf(command, "iptables -t filter -I outbound -p tcp -s %s -d %s --dport %s -j %s",
								sip_str, dip_str, dport_str, policy);
							system(command);
							#ifdef FOR_DEBUG
								printf("setfirewall: %s\r\n",command);
							#endif
							
							memcpy(&command[34], "udp", 3);
							system(command);
							#ifdef FOR_DEBUG
								printf("setfirewall: %s\r\n",command);
							#endif
						}
					}
					// have sport
					else
					{
						// have sport, none dport
						if(have_dport == 0)
						{
							sprintf(command, "iptables -t filter -I outbound -p tcp -s %s --sport %s -d %s -j %s",
								sip_str, sport_str, dip_str, policy);
							system(command);
							#ifdef FOR_DEBUG
								printf("setfirewall: %s\r\n",command);
							#endif
							
							memcpy(&command[34], "udp", 3);
							system(command);
							#ifdef FOR_DEBUG
								printf("setfirewall: %s\r\n",command);
							#endif
						}
						// have sport, have dport
						else
						{
							sprintf(command, "iptables -t filter -I outbound -p tcp -s %s --sport %s -d %s --dport %s -j %s",
								sip_str, sport_str, dip_str, dport_str, policy);
							system(command);
							#ifdef FOR_DEBUG
								printf("setfirewall: %s\r\n",command);
							#endif
							
							memcpy(&command[34], "udp", 3);
							system(command);
							#ifdef FOR_DEBUG
								printf("setfirewall: %s\r\n",command);
							#endif
						}
					}
				}
				else	// protocol only tcp or udp
				{
					// none sport
					if(have_sport == 0)
					{
						// none sport, none dport
						if(have_dport == 0)
						{
							sprintf(command, "iptables -t filter -I outbound -p %s -s %s -d %s -j %s",
								prot, sip_str, dip_str, policy);
							system(command);
							#ifdef FOR_DEBUG
								printf("setfirewall: %s\r\n",command);
							#endif
						}
						// none sport, have dport
						else
						{
							sprintf(command, "iptables -t filter -I outbound -p %s -s %s -d %s --dport %s -j %s",
								prot, sip_str, dip_str, dport_str, policy);
							system(command);
							#ifdef FOR_DEBUG
								printf("setfirewall: %s\r\n",command);
							#endif
						}
					}
					// have sport
					else
					{
						// have sport, none dport
						if(have_dport == 0)
						{
							sprintf(command, "iptables -t filter -I outbound -p %s -s %s --sport %s -d %s -j %s",
								prot, sip_str, sport_str, dip_str, policy);
							system(command);
							#ifdef FOR_DEBUG
								printf("setfirewall: %s\r\n",command);
							#endif
						}
						// have sport, have dport
						else
						{
							sprintf(command, "iptables -t filter -I outbound -p %s -s %s --sport %s -d %s --dport %s -j %s",
								prot, sip_str, sport_str, dip_str, dport_str, policy);
							system(command);
							#ifdef FOR_DEBUG
								printf("setfirewall: %s\r\n",command);
							#endif
						}
					}
				}
			}
		}
	}
	
	// 6. Return from this function
	return 0;
}


/* ********** */
/* pptpc_dial */
/* ********** */
/*
int pptpc_dial(char *ip,char *name, char *pswd)
{
  unsigned char temp[50];
  sprintf(temp,"pptp %s name %s -r",ip,name);
  system(temp);
}
*/
// succ 0513
/*
int pptpc_disc(int index, VPN_struct *vpn)
{
  unsigned char command[50],pid[10];
  FILE *fd;

  // remove ip file in /var/run/pptp
  sprintf(command,"/var/run/pptp/%d.%d.%d.%d",vpn->connections[index].ip[0],vpn->connections[index].ip[1],
                                              vpn->connections[index].ip[2],vpn->connections[index].ip[3] );
  remove(command);

  // remove pid of pppd
  sprintf(command,"/var/run/pptp/pptpc.%d.%d.%d.%d",vpn->connections[index].ip[0],vpn->connections[index].ip[1],
                                                    vpn->connections[index].ip[2],vpn->connections[index].ip[3] );
  fd = fopen(command,"r");
  fgets(pid,10,fd);
  fclose(fd);
  remove(command);
  sprintf(command,"kill %s",pid);
  system(command);

  // remove pid of pptpc
  sprintf(command,"/var/run/pptp/pptpcall.%d.%d.%d.%d",vpn->connections[index].ip[0],vpn->connections[index].ip[1],
                                                       vpn->connections[index].ip[2],vpn->connections[index].ip[3] );
  fd = fopen(command,"r");
  fgets(pid,10,fd);
  fclose(fd);
  remove(command);
  sprintf(command,"kill %s",pid);
  system(command);
}
*/
// succ


#ifdef IDS

/* ************ */
/* url blocking */
/* ************ */
int add_url(ACONFIG *src, char *url)
{
	int i = 0;
	while(src->ids.urlblock.url[i].string[0] != 0)
		i++;
//@@@ModifyBegin by KM 2002/10/05
	if(i < URL_NUM)
//@@@ModifyEnd by KM 
		strcpy(src->ids.urlblock.url[i].string,url);
	else
		return 0;

	return 1;
}
int del_url(ACONFIG *src, int num)
{
	int i;
	num--;
	if(src->ids.urlblock.url[num].string[0] != 0)
		src->ids.urlblock.url[num].string[0] = 0;

	i = num + 1;
//@@@ModifyBegin by KM 2002/10/05
	if(i == URL_NUM)
//@@@ModifyEnd
		return 1;
	while(src->ids.urlblock.url[i].string[0] != 0)
	{
		//memcpy((void *)src->ids.urlblock.url[i - 1].string, (void *)src->ids.urlblock.url[i].string, strlen(src->ids.urlblock.url[i].string));
		strcpy(src->ids.urlblock.url[i-1].string,src->ids.urlblock.url[i].string);
		i++;
		//@@@ModifyBegin by KM 2002/10/05
		if(i == URL_NUM)
		//@@@ModifyEnd by KM
		{
			src->ids.urlblock.url[i - 1].string[0] = 0;
			return 1;
		}
	}
	src->ids.urlblock.url[i - 1].string[0] = 0;
	return 1;
}


/* ************ */
/* ids switch   */
/* ************ */
int setids_pingf(int act)
{
	char command[180], WANstr[6];


	//close(2);	//marked by Lily 20020926
	
	getWANstr(WANstr);

	if(act)
	{
		//@@@AddBegin by KM 2002/10/07
		if((oldACONF->ids.flag[1]&0x02)==0x02)		// Ping Flooding (ICMP Echo Flooding)
			return 0;
		//@@@AddEnd by KM 2002/10/07
		sprintf(command, "iptables -N pingflood");
		system(command);
		
		//@@@ModifyBegin by KM 2002/10/21 
		
		sprintf(command, "iptables -I pingflood -m limit --limit 10/minute --limit-burst 1 -j LOG --log-prefix %s", PINGF_NUM);
		system(command);

		sprintf(command, "iptables -A pingflood -j DROP");
		system(command);
		//@@@ModifyEnd by KM 2002/10/21 
		
		sprintf(command, "iptables -A INPUT -i %s -p icmp --icmp-type echo-request -m state --state NEW -j pingflood",WANstr);
		system(command);
	}
	else
	{
		//@@@AddBegin by KM 2002/10/07
		if((ACONF->ids.flag[1]&0x02)==0x02)		// Ping Flooding (ICMP Echo Flooding)
			return 0;
		//@@@AddEnd by KM 2002/10/07
		//@@@ModifyBegin by KM 2002/10/18 use getOldWANstr()
		getOldWANstr(WANstr);
		sprintf(command,"iptables -D INPUT -i %s -p icmp --icmp-type echo-request -m state --state NEW -j pingflood",WANstr);
		system(command);
		//@@@ModifyEnd by KM 2002/10/18

		sprintf(command, "iptables -F pingflood");
		system(command);

		sprintf(command, "iptables -X pingflood");
		system(command);
	}

	return 0;
}


int setids_smurf(int act)
{
	char command[180], WANstr[6];


	//close(2);	//marked by Lily 20020926
	
	getWANstr(WANstr);

	if(act)
	{
		//@@@AddBegin by KM 2002/10/07
		if((oldACONF->ids.flag[0]&0x02)==0x02)
			return 0;
		//@@@AddEnd by KM 2002/10/07
		sprintf(command, "iptables -N smurf");
		system(command);

		sprintf(command, "iptables -A smurf -m state --state ESTABLISHED,RELATED -j ACCEPT");
		system(command);

		sprintf(command, "iptables -A smurf -m limit --limit 10/minute --limit-burst 1 -j LOG --log-prefix %s", SMURF_NUM);
		system(command);

		sprintf(command, "iptables -A smurf -j DROP");
		system(command);

		sprintf(command, "iptables -A INPUT -i %s -p ICMP --icmp-type echo-reply -j smurf",WANstr);
		system(command);
	}
	else
	{
		//@@@AddBegin by KM 2002/10/07
		if((ACONF->ids.flag[0]&0x02)==0x02)
			return 0;
		//@@@AddEnd by KM 2002/10/07
		//@@@ModifyBegin by KM 2002/10/18 use getOldWANstr()
		getOldWANstr(WANstr);
		sprintf(command,"iptables -D INPUT -i %s -p ICMP --icmp-type echo-reply -j smurf",WANstr);
		system(command);
		//@@@ModifyEnd by KM 2002/10/18

		sprintf(command, "iptables -F smurf");
		system(command);

		sprintf(command, "iptables -X smurf");
		system(command);
	}

	return 0;
}



int setids_psd(int act)
{
	char command[180], WANstr[6];


	//close(2);	//marked by Lily 20020926
	
	getWANstr(WANstr);

	if(act)
	{
		//@@@AddBegin by KM 2002/10/07
		if((oldACONF->ids.flag[0]&0x08)==0x08)		// Port Scan Detection
		{
			if(!dis(WANstr_dis) && !dis(LANnet_dis))
				return 0;
		}
		//@@@AddEnd by KM 2002/10/07
		sprintf(command, "iptables -N psd");
		system(command);

		sprintf(command, "iptables -A psd -m limit --limit 10/minute --limit-burst 1 -j LOG --log-prefix %s", PSD_NUM);
		system(command);

		//sprintf(command, "iptables -A psd -d %d.%d.%d.%d -j ACCEPT",
		//	ACONF->local.rhip[0],
		//	ACONF->local.rhip[1],
		//	ACONF->local.rhip[2],
		//	ACONF->local.dmz_host);
		//system(command);

		sprintf(command, "iptables -A psd -j DROP");
		system(command);
		//@@@ModifyBegin by KM 2002/10/05
		sprintf(command, 
			"iptables -A FORWARD -i %s -o eth0 -p tcp -d %d.%d.%d.0/24 -m psd --psd-weight-threshold 5 --psd-delay-threshold 200 -j psd",
			WANstr,
			ACONF->local.ip[0],
			ACONF->local.ip[1],
			ACONF->local.ip[2]);
		//@@@ModifyEnd by KM
		system(command);
		//@@@ModifyBegin by KM 2002/10/19 INPUT 
		sprintf(command, 
			"iptables -A INPUT -i %s -p tcp -m psd --psd-weight-threshold 5 --psd-delay-threshold 200 -j psd",
			WANstr);
		system(command);
		//@@@ModifyEnd by KM 2002/10/19
	}
	else
	{
		//@@@AddBegin by KM 2002/10/07
		if((ACONF->ids.flag[0]&0x08)==0x08)		// Port Scan Detection
		{
			if(!dis(WANstr_dis) && !dis(LANnet_dis))
				return 0;
		}
		//@@@AddEnd by KM 2002/10/07
		//@@@ModifyBegin by KM 2002/10/18 use getOldWANstr()
		getOldWANstr(WANstr);
		sprintf(command, "iptables -D FORWARD -i %s -o eth0 -p tcp -d %d.%d.%d.0/24 -m psd --psd-weight-threshold 5 --psd-delay-threshold 200 -j psd",
			WANstr,
			oldACONF->local.ip[0],
			oldACONF->local.ip[1],
			oldACONF->local.ip[2]);
		system(command);
		//@@@ModifyEnd by KM 2..2/10/18
		//@@@ModifyBegin by KM 2002/10/19 INPUT 
		sprintf(command, "iptables -D INPUT -i %s -p tcp -m psd --psd-weight-threshold 5 --psd-delay-threshold 200 -j psd",
			WANstr);
		system(command);
		//@@@ModifyEnd by KM 2002/10/19
		
		sprintf(command, "iptables -F psd");
		system(command);

		sprintf(command, "iptables -X psd");
		system(command);
	}

	return 0;
}



int setids_fraggle(int act)
{
	char command[120], WANstr[6];


	//close(2);	//marked by Lily 20020926
	
	getWANstr(WANstr);

	if(act)
	{
		//@@@AddBegin by KM 2002/10/07
		if((oldACONF->ids.flag[0]&0x40)==0x40)		// Fraggle
			return 0;
		//@@@AddEnd by KM 2002/10/07
		sprintf(command, "iptables -N fraggle");
		system(command);

		sprintf(command, "iptables -A fraggle -p udp -m state --state ESTABLISHED -j ACCEPT");
		system(command);

		sprintf(command, "iptables -A fraggle -m limit --limit 10/minute --limit-burst 1 -j LOG --log-prefix %s", FRAGGLE_NUM);
		system(command);

		sprintf(command, "iptables -A fraggle -j DROP");
		system(command);

		//sprintf(command, "iptables -A FORWARD -i eth1??? -o eth0 -p udp -m multiport --sports 7,11,19,37,45,513,550 -d ! %d.%d.%d.%d -j fraggle",
		//	ACONF->local.ip[0],
		//	ACONF->local.ip[1],
		//	ACONF->local.ip[2],
		//	ACONF->local.dmz_host);
		sprintf(command, "iptables -A FORWARD -i %s -o eth0 -p udp -m multiport --sports 7,11,19,37,45,513,550 -j fraggle",WANstr);
		system(command);
		//@@@AddBegin by KM 2002/10/28
		sprintf(command, "iptables -A INPUT -i %s -p udp -m multiport --sports 7,11,19,37,45,513,550 -j fraggle",WANstr);
		system(command);
		//@@@AddEnd by KM 2002/10/28
	}
	else
	{
		//@@@AddBegin by KM 2002/10/07
		if((ACONF->ids.flag[0]&0x40)==0x40)		// Fraggle
			return 0;
		//@@@AddEnd by KM 2002/10/07
		
		//sprintf(command, "iptables -D FORWARD -i eth1??? -o eth0 -p udp -m multiport --sports 7,11,19,37,45,513,550 -d ! %d.%d.%d.%d -j fraggle",
		//	ACONF->local.ip[0],
		//	ACONF->local.ip[1],
		//	ACONF->local.ip[2],
		//	ACONF->local.dmz_host);
		
		//@@@ModifyBegin by KM 2002/10/18 use getOldWANstr()
		getOldWANstr(WANstr);
		sprintf(command, "iptables -D FORWARD -i %s -o eth0 -p udp -m multiport --sports 7,11,19,37,45,513,550 -j fraggle",WANstr);
		system(command);
		//@@@ModifyEnd by KM 2002/10/18

		sprintf(command, "iptables -F fraggle");
		system(command);

		sprintf(command, "iptables -X fraggle");
		system(command);
	}

	return 0;
}



int setids_snork(int act)
{
	char command[180], WANstr[6];


	//close(2);	//marked by Lily 20020926
	
	getWANstr(WANstr);

	if(act)
	{
		//@@@AddBegin by KM 2002/10/07
		if((oldACONF->ids.flag[0]&0x01)==0x01)
			return 0;//have set rules when "old"
		//@@@AddEnd by KM 2002/10/07
		sprintf(command, "iptables -N snork");
		system(command);

		sprintf(command, "iptables -A snork -m limit --limit 10/minute --limit-burst 1 -j LOG --log-prefix %s", SNORK_NUM);
		system(command);

		sprintf(command, "iptables -A snork -j DROP");
		system(command);

		sprintf(command, "iptables -A FORWARD -i %s -o eth0 -p udp --dport 135 -m multiport --sports 7,11,19,37,45,135,513,550 -j snork", WANstr);
		system(command);
		//@@@AddBegin by KM 2002/10/28
		sprintf(command, "iptables -A INPUT -i %s -p udp --dport 135 -m multiport --sports 7,11,19,37,45,135,513,550 -j snork", WANstr);
		system(command);
		//@@@AddEnd by KM 2002/10/28
	}
	else
	{
		//@@@AddBegin by KM 2002/10/07
		if((ACONF->ids.flag[0]&0x01)==0x01)
			return 0;//don't kill, because the "new" need
		//@@@AddEnd by KM 2002/10/07
		//@@@ModifyBegin by KM 2002/10/18 use getOldWANstr()
		getOldWANstr(WANstr);
		sprintf(command, "iptables -D FORWARD -i %s -o eth0 -p udp --dport 135 -m multiport --sports 7,11,19,37,45,135,513,550 -j snork",WANstr);
		system(command);
		//@@@ModifyEnd by KM 2002/10/18

		//@@@AddBegin by KM 2002/10/28
		sprintf(command, "iptables -D INPUT -i %s -p udp --dport 135 -m multiport --sports 7,11,19,37,45,135,513,550 -j snork",WANstr);
		system(command);
		//@@@AddEnd by KM 2002/10/28
		
		sprintf(command, "iptables -F snork");
		system(command);

		sprintf(command, "iptables -X snork");
		system(command);
	}

	return 0;
}



int setids_land(int act)
{
	char command[180], WANstr[6];


	//close(2);	//marked by Lily 20020926
	
	getWANstr(WANstr);

	if(act)
	{
		//@@@AddBegin by KM 2002/10/07
		if((oldACONF->ids.flag[0]&0x80)==0x80)		// Land Attack
		{
			if(!dis(WAN_dis) && !dis(WANstr_dis))
				return 0;
		}
		//@@@AddEnd by KM 2002/10/07
		sprintf(command, "iptables -t mangle -N land");
		system(command);

		sprintf(command, "iptables -t mangle -A land -m limit --limit 10/minute --limit-burst 1 -j LOG --log-prefix %s", LAND_NUM);
		system(command);

		sprintf(command, "iptables -t mangle -A land -j DROP");
		system(command);

		sprintf(command, 
			"iptables -t mangle -A PREROUTING -p TCP -i %s -s %d.%d.%d.%d -d %d.%d.%d.%d -j land",
			WANstr,
			ACONF->local.wip[0],
			ACONF->local.wip[1],
			ACONF->local.wip[2],
			ACONF->local.wip[3],
			ACONF->local.wip[0],
			ACONF->local.wip[1],
			ACONF->local.wip[2],
			ACONF->local.wip[3]);
		system(command);
	}
	else
	{
		//@@@AddBegin by KM 2002/10/07
		if((ACONF->ids.flag[0]&0x80)==0x80)		// Land Attack
		{
			if(!dis(WAN_dis) && !dis(WANstr_dis))
				return 0;
		}
		//@@@AddEnd by KM 2002/10/07
		
		//@@@ModifyBegin by KM 2002/10/18 use getOldWANstr()
		getOldWANstr(WANstr);
		sprintf(command, "iptables -t mangle -D PREROUTING -p TCP -i %s -s %d.%d.%d.%d -d %d.%d.%d.%d -j land",
			WANstr,
			oldACONF->local.wip[0],
			oldACONF->local.wip[1],
			oldACONF->local.wip[2],
			oldACONF->local.wip[3],
			oldACONF->local.wip[0],
			oldACONF->local.wip[1],
			oldACONF->local.wip[2],
			oldACONF->local.wip[3]);
		system(command);
		//@@@ModifyEnd by KM 2002/10/18
		
		sprintf(command, "iptables -t mangle -F land");
		system(command);

		sprintf(command, "iptables -t mangle -X land");
		system(command);
	}

	return 0;
}



int setids_urlblock(int act)
{
	FILE *fp;
	int i;
	char command[110];


	//close(2);	//marked by Lily 20020926

	if(act)
	{
		fp = fopen("/var/config/ipq/url.conf", "w");
		if(fp == NULL)
		{
			fclose(fp);
			return 0;
		}
		for(i = 0; ACONF->ids.urlblock.url[i].string[0] != 0; i++)
		{
			fprintf(fp, "%s\n", ACONF->ids.urlblock.url[i].string);
		}
		fclose(fp);

		//@@@AddBegin by KM 2002/10/07
		if((oldACONF->ids.flag[1]&0x08)==0x08)		// http url block
		{
			if(!dis(DMZ_dis) && !dis(PROXY_dis) )
				return 0;
		}
		//@@@AddEnd by KM 2002/10/07
		

		sprintf(command, "iptables -t mangle -N urlblock");
		system(command);
		sprintf(command, "iptables -t mangle -A urlblock -p TCP -s ! %d.%d.%d.%d --dport 80 -j MARK --set-mark 3",
			ACONF->local.ip[0],
			ACONF->local.ip[1],
			ACONF->local.ip[2],
			ACONF->local.dmz_host);
		system(command);
		sprintf(command, "iptables -t mangle -A urlblock -j RETURN");
		system(command);
		sprintf(command, "iptables -t mangle -I PREROUTING -i eth0 -p TCP ! --syn -j urlblock");
		system(command);

		/*
		sprintf(command, "iptables -t mangle -A PREROUTING -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport 80 -j MARK --set-mark 3",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->local.dmz_host);
		system(command);
		*/

		sprintf(command, "iptables -t filter -N urlblock");
		system(command);
		sprintf(command, "iptables -t filter -A urlblock -p TCP -s ! %d.%d.%d.%d --dport 80 -j QUEUE",
			ACONF->local.ip[0],
			ACONF->local.ip[1],
			ACONF->local.ip[2],
			ACONF->local.dmz_host);
		system(command);
		sprintf(command, "iptables -t filter -A urlblock -j RETURN");
		system(command);
		sprintf(command, "iptables -A FORWARD -i eth0 -p TCP ! --syn -j urlblock");
		system(command);
		/*
		sprintf(command, "iptables -A FORWARD -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport 80 -j QUEUE",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->local.dmz_host);
		system(command);
		*/

		if(ACONF->ids.urlblock.proxy)
		{
			sprintf(command, "iptables -t mangle -I urlblock -p TCP -s ! %d.%d.%d.%d --dport %d -j MARK --set-mark 3",
				ACONF->local.ip[0],
				ACONF->local.ip[1],
				ACONF->local.ip[2],
				ACONF->local.dmz_host,
				ACONF->ids.urlblock.proxy);
			system(command);
			/*
			sprintf(command, "iptables -t mangle -A PREROUTING -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport %d -j MARK --set-mark 3",
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->local.dmz_host,
				ACONF->ids.urlblock.proxy);
			system(command);
			*/

			sprintf(command, "iptables -t filter -I urlblock -p TCP -s ! %d.%d.%d.%d --dport %d -j QUEUE",
				ACONF->local.ip[0],
				ACONF->local.ip[1],
				ACONF->local.ip[2],
				ACONF->local.dmz_host,
				ACONF->ids.urlblock.proxy);
			system(command);
			/*
			sprintf(command, "iptables -A FORWARD -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport %d -j QUEUE",
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->local.dmz_host,
				ACONF->ids.urlblock.proxy);
			system(command);
			*/
		}
	}
	else
	{
		fp = fopen("/var/config/ipq/url.conf", "w");
		fclose(fp);

		//@@@AddBegin by KM 2002/10/07
		if((ACONF->ids.flag[1]&0x08)==0x08)		// http url block
		{
			if(!dis(DMZ_dis) && !dis(PROXY_dis) )
				return 0;
		}
		//@@@AddEnd by KM 2002/10/07

		sprintf(command, "iptables -t mangle -D PREROUTING -i eth0 -p TCP ! --syn -j urlblock");
		system(command);
		sprintf(command, "iptables -t mangle -F urlblock");
		system(command);
		sprintf(command, "iptables -t mangle -X urlblock");
		system(command);
		/*
		sprintf(command, "iptables -t mangle -D PREROUTING -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport 80 -j MARK --set-mark 3",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->local.dmz_host);
		system(command);
		*/

		sprintf(command, "iptables -D FORWARD -i eth0 -p TCP ! --syn -j urlblock");
		system(command);
		sprintf(command, "iptables -t filter -F urlblock");
		system(command);
		sprintf(command, "iptables -t filter -X urlblock");
		system(command);
		/*
		sprintf(command, "iptables -D FORWARD -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport 80 -j QUEUE",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->local.dmz_host);
		system(command);
		*/
		/*
		if(ACONF->ids.urlblock.proxy)
		{
			sprintf(command, "iptables -t mangle -D PREROUTING -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport %d -j MARK --set-mark 3",
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->local.dmz_host,
				ACONF->ids.urlblock.proxy);
			system(command);

			sprintf(command, "iptables -D FORWARD -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport %d -j QUEUE",
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->local.dmz_host,
				ACONF->ids.urlblock.proxy);
			system(command);
		}
		*/
	}

	return 0;
}



/* ************ */
/* virus pattern*/
/* 0:error      */
/* 1:success    */
/* ************ */
int add_virus(ACONFIG *src, int protocol, int port, char * pattern)
{
	int i = 0;
	while(src->ids.virus[i].pattern[0] != 0)
		i++;
	//memcpy((void *)src->ids.urlblock.url[i].string, (void *)url, strlen(url));
	if(i == VIRUS_PATTERN_NUM )
		return 0;
	strcpy(src->ids.virus[i].pattern,pattern);
	src->ids.virus[i].protocol = protocol;
	src->ids.virus[i].port = port;
	return 1;
}
int del_virus(ACONFIG *src, int num)
{
	int i;
	num--;
	if(num < 0 || num >VIRUS_PATTERN_NUM )
		return 0;
	if(src->ids.virus[num].pattern[0] != 0)
	{
		src->ids.virus[num].protocol=0;
		src->ids.virus[num].port=0;
		src->ids.virus[num].pattern[0] = 0;
	}
	i = num + 1;
	if( i == VIRUS_PATTERN_NUM )
		return 1;
	while( src->ids.virus[i].pattern[0] != 0 )
	{
		//memcpy((void *)src->ids.urlblock.url[i - 1].string, (void *)src->ids.urlblock.url[i].string, strlen(src->ids.urlblock.url[i].string));
		strcpy(src->ids.virus[i-1].pattern,src->ids.virus[i].pattern);
		src->ids.virus[i-1].protocol = src ->ids.virus[i].protocol;
		src->ids.virus[i-1].port = src ->ids.virus[i].port;
		i++;
		if(i == VIRUS_PATTERN_NUM)
			break;
	}
	src->ids.virus[i - 1].pattern[0] = 0;
	src->ids.virus[i-1].protocol = 0;
	src->ids.virus[i-1].port = 0;
	return 1;
}

/*-----Virus Parser-----*/
int virusParser()
{
	FILE *creat;
	char protocol[4];
	char port[6];
	char pattern[MAX];
	char name[100];
	char hostnet[25];
	char command1[180], WANstr[6];
	char command2[110];
	char DMZ[25];
	int i,temp;


	//close(2);	//marked by Lily 20020926
	
	getWANstr(WANstr);

	printf("in parser\r\n");
	//strcpy(name,VIRUS_PATH);
	//strcat(name,pattern);
	//sprintf(hostnet,"%d.%d.%d.0/24",ACONF->local.rhip[0],ACONF->local.rhip[1],ACONF->local.rhip[2]);
	//@@@ModifyBegin by KM 2002/10/05 dmz
	sprintf(DMZ,"%d.%d.%d.%d",ACONF->local.ip[0],ACONF->local.ip[1],ACONF->local.ip[2],ACONF->local.dmz_host);
	//@@@ModifyEnd
	//printf("hostnet=%s\n",hostnet);

	//@@@ModifyBegin by KM 2002/10/17 use chain
	system("iptables -t mangle -N virus");
	system("iptables -t mangle -A virus -j RETURN");
	sprintf(command1,"iptables -t mangle -A PREROUTING -i %s -j virus",WANstr);
	system(command1);
	system("iptables -t filter -N virus");
	system("iptables -t filter -A virus -j RETURN");
	sprintf(command1,"iptables -t filter -A FORWARD -i %s -j virus",WANstr);
	system(command1);
	//@@@ModifyBegin by KM 2002/10/17 use chain
	for(i=0;i<VIRUS_PATTERN_NUM;i++)
	{
		if(ACONF->ids.virus[i].pattern[0]=='\0')
			continue;
		if(ACONF->ids.virus[i].protocol== 0)
			strcpy(protocol,"tcp");
		else
			strcpy(protocol,"udp");
		temp=(int)ACONF->ids.virus[i].port;
		sprintf(port,"%d",temp);
		//@@@ModifyBegin by KM 2002/10/17 use chain
		//set command1 to add mark
		sprintf(command1,"iptables -t mangle -I virus -i %s -p %s -d ! %s --dport %s -j MARK --set-mark 6",
			WANstr,	protocol, DMZ, port);		
		//set command2 to add "QUEUE"
		sprintf(command2,"iptables -t filter -I virus -i %s -p %s -d ! %s --dport %s -j QUEUE",
			WANstr,	protocol, DMZ, port);
		//@@@ModifyBegin by KM 2002/10/17 use chain

		if(strcmp(protocol,"tcp")==0){
			name[0]='\0';
			//strcpy(name,"t");
			strcpy(name,VIRUS_PATH);
			strcat(name,"t");
			system(command1);
			system(command2);
		}
		else if(strcmp(protocol,"udp")==0){
			name[0]='\0';
			//strcpy(name,"u");
			strcpy(name,VIRUS_PATH);
			strcat(name,"u");
			system(command1);
			system(command2);
		}
		else {
			//printf("protocol unknow\n");
			return 0;
		}
		strcat(name,port);
		//printf("file=%s\n",name);
		//getchar();
		for(temp=0;temp<5;temp++)
		{
			if((creat=fopen(name,"a"))==NULL)
				continue;
			else
				break;
		}
		if(creat != NULL)
		{
			fprintf(creat,"%s\n",ACONF->ids.virus[i].pattern,creat);
			fclose(creat);
		}
		else
			printf("can't open file\r\n");
	}

	return 0;
}
/*-----End Virus Parser-----*/

/* ************** */
/* set virus scan */
/* ************** */
int setids_virusscan(int act)
{
	//char buf[10];
	char protocol[4];
	//char port[6];
	char command[180], WANstr[6];
	int i;
	//@@@AddBegin by KM 2002/10/18
	int rule_not_change;
	//@@@AddEnd by KM 2002/10/18


	//close(2);	//marked by Lily 20020926
	
	getWANstr(WANstr);
	
	//@@@AddBegin by KM 2002/10/18 check the rules change
	for(i=0,rule_not_change=1;i<VIRUS_PATTERN_NUM;i++)
	{
		if(strcmp(ACONF->ids.virus[i].pattern,oldACONF->ids.virus[i].pattern) || 
		   (ACONF->ids.virus[i].protocol != oldACONF->ids.virus[i].protocol) ||
		   (ACONF->ids.virus[i].port != oldACONF->ids.virus[i].port) )
		{
			rule_not_change=0;
			break;
		}
	}
	//@@@AddEnd by KM 2002/10/18
	if(act)
	{
		if((oldACONF->ids.flag[1]&0x20)==0x20)		// Virus Scan
		{
			if(!dis(WANstr_dis) && rule_not_change && !dis(DMZ_dis) )
				return 0;
		}
		virusParser();
	}
	else
	{
	//@@@ModifyBegin by KM 2002/10/05
		if((oldACONF->ids.flag[1]&0x20)==0x20)
		{
			if((ACONF->ids.flag[1]&0x20)==0x20)		// Virus Scan
			{
				if(!dis(WANstr_dis) && rule_not_change && !dis(DMZ_dis) )
					return 0;
			}
			//@@@ModifyBegin by KM 2002/10/17 use chain
			getOldWANstr(WANstr);
			sprintf(command,"iptables -t mangle -D PREROUTING -i %s -j virus",WANstr);
			system(command);
			system("iptables -t mangle -F virus");
			system("iptables -t mangle -X virus");
			sprintf(command,"iptables -t filter -D FORWARD -i %s -j virus",WANstr);
			system(command);
			system("iptables -t filter -F virus");
			system("iptables -t filter -X virus");
			//for(i=0;i<VIRUS_PATTERN_NUM;i++)
			//{
			//	if(oldACONF->ids.virus[i].pattern[0]==0)
			//	{
			//		continue;
			//	}
			//	if(oldACONF->ids.virus[i].protocol==0)
			//		sprintf(protocol,"tcp");
			//	else
			//		sprintf(protocol,"udp");
			//	sprintf(command,
			//		"iptables -t mangle -D PREROUTING -i %s -p %s -d ! %d.%d.%d.%d --dport %d -j MARK --set-mark 6",
			//		WANstr,
			//		protocol,oldACONF->local.ip[0],oldACONF->local.ip[1],oldACONF->local.ip[2],oldACONF->local.dmz_host,
			//		oldACONF->ids.virus[i].port);
			//	system(command);
			//	
			//	sprintf(command,
			//		"iptables -D FORWARD -i %s -p %s -d ! %d.%d.%d.%d --dport %d -j QUEUE",
			//		WANstr,
			//		protocol,oldACONF->local.ip[0],oldACONF->local.ip[1],oldACONF->local.ip[2],oldACONF->local.dmz_host,
			//		oldACONF->ids.virus[i].port);
			//	system(command);
			//	
			//}
			//@@@ModifyEnd by KM 2002/10/17 use chain
			
		}
	//@@@ModifyEnd by KM
	}
	return 0;
}
/*-----*/



int setids_udpbomb(int act)
{
	FILE *fp;

	if(act)
	{
		//@@@AddBegin by KM 2002/10/07
		if((oldACONF->ids.flag[0]&0x10)==0x10)		// UDP Bomb
			return 0;
		//@@@AddEnd by KM 2002/10/07
		fp = fopen("/proc/sys/net/ipv4/udp_bomb", "w");
		if(fp == NULL)
		{
			fclose(fp);
			return 1;
		}
		fprintf(fp, "1");
		fclose(fp);
	}
	else
	{
		//@@@AddBegin by KM 2002/10/07
		if((ACONF->ids.flag[0]&0x10)==0x10)		// UDP Bomb
			return 0;
		//@@@AddEnd by KM 2002/10/07
		fp = fopen("/proc/sys/net/ipv4/udp_bomb", "w");
		if(fp == NULL)
		{
			fclose(fp);
			return 1;
		}
		fprintf(fp, "0");
		fclose(fp);
	}

	return 0;
}



int setids_synf(int act)
{
	FILE *fp;

	if(act)
	{
		//@@@AddBegin by KM 2002/10/07
		if((oldACONF->ids.flag[0]&0x20)==0x20)		// SYN Flooding
			return 0;
		//@@@AddEnd by KM 2002/10/07
		fp = fopen("/proc/sys/net/ipv4/tcp_syncookies", "w");
		if(fp == NULL)
		{
			fclose(fp);
			return 1;
		}
		fprintf(fp, "1");
		fclose(fp);
	}
	else
	{
		//@@@AddBegin by KM 2002/10/07
		if((ACONF->ids.flag[0]&0x20)==0x20)		// SYN Flooding
			return 0;
		//@@@AddEnd by KM 2002/10/07
		fp = fopen("/proc/sys/net/ipv4/tcp_syncookies", "w");
		if(fp == NULL)
		{
			fclose(fp);
			return 1;
		}
		fprintf(fp, "0");
		fclose(fp);
	}

	return 0;
}



int setids_icmpun(int act)
{
	FILE *fp;
	char command[180], WANstr[6];


	//close(2);	//marked by Lily 20020926
	
	getWANstr(WANstr);

	if(act)
	{
		//@@@AddBegin by KM 2002/10/07
		if((oldACONF->ids.flag[1]&0x01)==0x01)		// ICMP Unreachable
			return 0;
		//@@@AddEnd by KM 2002/10/07
		fp = fopen("/proc/sys/net/ipv4/icmp_ignore_dest_unreach", "w");
		if(fp == NULL)
		{
			fclose(fp);
			return 1;
		}
		fprintf(fp, "1");
		fclose(fp);
		//@@@ModifyBegin by KM 2002/10/18 use chain
		system("iptables -t filter -N icmpun");
		system("iptables -t filter -A icmpun -j RETURN");
		sprintf(command, "iptables -t filter -A FORWARD -i %s -o eth0 -p icmp -j icmpun",WANstr);
		system(command);		
		system("iptables -t filter -I icmpun -p icmp --icmp-type port-unreachable -j DROP");
		system("iptables -t filter -I icmpun -p icmp --icmp-type protocol-unreachable -j DROP");
		system("iptables -t filter -I icmpun -p icmp --icmp-type network-unreachable -j DROP");
		system("iptables -t filter -I icmpun -p icmp --icmp-type host-unreachable -j DROP");
		//@@@ModifyEnd by KM 2002/10/18 use chain
	}
	else
	{
		//@@@AddBegin by KM 2002/10/07 check if need to kill rules
		if((ACONF->ids.flag[1]&0x01)==0x01 && !dis(WANstr_dis))		// ICMP Unreachable
			return 0;
		//@@@AddEnd by KM 2002/10/07
		fp = fopen("/proc/sys/net/ipv4/icmp_ignore_dest_unreach", "w");
		if(fp == NULL)
		{
			fclose(fp);
			return 1;
		}
		fprintf(fp, "0");
		fclose(fp);
		//@@@ModifyBegin by KM 2002/10/18 use oldWANstr to kill rule
		getOldWANstr(WANstr);
		sprintf(command,"iptables -t filter -D FORWARD -i %s -o eth0 -p icmp -j icmpun",WANstr);
		system(command);
		system("iptables -t filter -F icmpun");
		system("iptables -t filter -X icmpun");
		//@@@ModifyEnd by KM 2002/10/18
	}

	return 0;
}



int setids_dns(int act)
{
	char command[100];


	//close(2);	//marked by Lily 20020926

	if(act)
	{
		//@@@AddBegin by KM 2002/10/07
		if((oldACONF->ids.flag[1]&0x04)==0x04)		// DNS Scan
		{
			if(!dis(DNS_dis))
				return 0;
		}
		//@@@AddEnd by KM 2002/10/07
		
		sprintf(command, "iptables -N dns");
		system(command);

		sprintf(command, "iptables -A dns -m limit --limit 10/minute --limit-burst 1 -j LOG --log-prefix %s", DNS_SCAN_NUM);
		system(command);
		sprintf(command, "iptables -A dns -j DROP");
		system(command);
		
		//@@@ModifyBegin by KM 2002/10/05
		sprintf(command, "iptables -A FORWARD -p tcp -s ! %d.%d.%d.%d -d %d.%d.%d.%d --dport 53 -j dns",
			ACONF->ids.dns_scan.wan_dns[0],
			ACONF->ids.dns_scan.wan_dns[1],
			ACONF->ids.dns_scan.wan_dns[2],
			ACONF->ids.dns_scan.wan_dns[3],
			ACONF->local.ip[0],
			ACONF->local.ip[1],
			ACONF->local.ip[2],
			ACONF->ids.dns_scan.lan_dns);
		//@@@ModifyEnd by KM 
		
		//printf("%s\n",command);
		system(command);
	}
	else
	{
		//@@@AddBegin by KM 2002/10/07
		if((ACONF->ids.flag[1]&0x04)==0x04)		// DNS Scan
		{
			if(!dis(DNS_dis))
				return 0;
		}
		//@@@AddEnd by KM 2002/10/07		
		
		//@@@ModifyBegin by KM 2002/10/05
		if((oldACONF->ids.flag[1] & 0x04) == 0x04)
		{
			sprintf(command, "iptables -D FORWARD -p tcp -s ! %d.%d.%d.%d -d %d.%d.%d.%d --dport 53 -j dns",
				oldACONF->ids.dns_scan.wan_dns[0],
				oldACONF->ids.dns_scan.wan_dns[1],
				oldACONF->ids.dns_scan.wan_dns[2],
				oldACONF->ids.dns_scan.wan_dns[3],
				oldACONF->local.ip[0],
				oldACONF->local.ip[1],
				oldACONF->local.ip[2],
				oldACONF->ids.dns_scan.lan_dns);
			//printf("%s\n",command);
			system(command);

			sprintf(command, "iptables -F dns");
			system(command);

			sprintf(command, "iptables -X dns");
			system(command);
		}
		//@@@ModifyEnd by KM 
	}

	return 0;
}



int setids_mailblock(int act)
{
	FILE *fp;
	int i;
	char command[180], WANstr[6];

	
	//close(2);	//marked by Lily 20020926
	
	getWANstr(WANstr);

	if(act)
	{

		//----mbomb2 flow block
		if((ACONF->ids.flag[1]&0x80)==0x80)
		{
			//printf("m2\n");
			fp=fopen(MBOMB2_PATH,"w");
			fprintf(fp,"1\n");
			fprintf(fp,"%d\n",ACONF->ids.mbomb2.total_sender);
			fprintf(fp,"%d\n",ACONF->ids.mbomb2.total_mails);
			fclose(fp);
		}
		else
		{
			//printf("off m2\n");
			fp=fopen(MBOMB2_PATH,"w");
			fprintf(fp,"0\n");
			fclose(fp);
		}

		//----mbomb1 address block
		if((ACONF->ids.flag[1]&0x40)==0x40)
		{
			//printf("m1\n");
			fp=fopen(MBOMB_PATH,"w");
			fprintf(fp,"1\n");
			fclose(fp);
		}
		else
		{	//printf("off m1\n");
			fp=fopen(MBOMB_PATH,"w");
			fprintf(fp,"0\n");
			fclose(fp);
		}

		fp = fopen("/var/config/ipq/mailaddr.conf", "w");
		if(fp == NULL)
		{
			fclose(fp);
			return 0;
		}
		for(i = 0; ACONF->ids.mailblock[i].string[0] != 0; i++)
		{
			fprintf(fp, "%s\n", ACONF->ids.mailblock[i].string);
		}
		fclose(fp);
		
		//@@@InsertBegin by KM 2002/10/16 check if set rules
		if(((oldACONF->ids.flag[1]&0x80)==0x80) || ((oldACONF->ids.flag[1]&0x40)==0x40))		
		{
			if( !dis(DMZ_dis) && !dis(WANstr_dis) )
				return 0;
		}
		//@@@InsertEnd by KM 2002/10/16
		
		//@@@ModifyBegin by KM 2002/10/16 change rules
		sprintf(command, "iptables -t mangle -N mailblock");
		system(command);
		sprintf(command, "iptables -t mangle -A mailblock -i %s -p TCP ! --syn -d ! %d.%d.%d.%d --dport 25 -j MARK --set-mark 4",
			WANstr,
			ACONF->local.ip[0],
			ACONF->local.ip[1],
			ACONF->local.ip[2],
			ACONF->local.dmz_host);
		system(command);
		sprintf(command, "iptables -t mangle -A mailblock -j RETURN");
		system(command);
		sprintf(command, "iptables -t mangle -I PREROUTING -i %s -p TCP ! --syn -j mailblock",WANstr);
		system(command);

		sprintf(command, "iptables -t filter -N mailblock");
		system(command);
		sprintf(command, "iptables -t filter -A mailblock -i %s -o eth0 -p TCP ! --syn -d ! %d.%d.%d.%d --dport 25 -j QUEUE",
			WANstr,
			ACONF->local.ip[0],
			ACONF->local.ip[1],
			ACONF->local.ip[2],
			ACONF->local.dmz_host);
		system(command);
		sprintf(command, "iptables -t filter -A mailblock -j RETURN");
		system(command);

		sprintf(command, "iptables -t filter -A FORWARD -i %s -o eth0 -p TCP ! --syn -j mailblock",WANstr);
		system(command);
		//@@@ModifyEnd by KM 2002/10/16
	}
	else
	{
		//@@@ModifyBegin by KM 2002/10/16 add check for each mbomb
		if((ACONF->ids.flag[1]&0x80)!=0x80)
		{
			//----close mbomb2 flow block
			fp=fopen(MBOMB2_PATH,"w");
			fprintf(fp,"0\n");
			fclose(fp);
		}
		if((ACONF->ids.flag[1]&0x40)!=0x40)
		{
			//----close mbomb address block
			fp=fopen(MBOMB_PATH,"w");
			fprintf(fp,"0\n");
			fclose(fp);

			fp = fopen("/var/config/ipq/mailaddr.conf", "w");
			fclose(fp);
		}
		//@@@ModifyEnd by KM 2002/10/16
		
		//@@@InsertBegin by KM 2002/10/16 check if will set rules
		if(((ACONF->ids.flag[1]&0x80)==0x80) || ((ACONF->ids.flag[1]&0x40)==0x40))		
		{
			if( !dis(DMZ_dis) && !dis(WANstr_dis) )
				return 0;
		}
		//@@@InsertEnd by KM 2002/10/16
		
		//@@@ModifyBegin by KM 2002/10/16
		getOldWANstr(WANstr);
		
		sprintf(command, "iptables -t mangle -D PREROUTING -i %s -p TCP ! --syn -j mailblock",WANstr);
		system(command);
		sprintf(command, "iptables -t mangle -F mailblock");
		system(command);
		sprintf(command, "iptables -t mangle -X mailblock");
		system(command);
		
		sprintf(command, "iptables -t filter -D FORWARD -i eth1 -o eth0 -p TCP ! --syn -j mailblock",WANstr);
		system(command);
		sprintf(command, "iptables -t filter -F mailblock");
		system(command);
		sprintf(command, "iptables -t filter -X mailblock");
		system(command);
		//@@@ModifyEnd by KM 2002/10/16
	}

	return 0;
}



int setids_mscript(int act)
{
	FILE *fp;
	//char temp[10];
	char command[180], WANstr[6];


	//close(2);	//marked by Lily 20020926
	
	getWANstr(WANstr);

	if(act)
	{
		//@@@AddBegin by KM 2002/10/07
		if((oldACONF->ids.flag[1]&0x10)==0x10)		// Malicious Script
		{
			if( !dis(DMZ_dis) && !dis(PROXYmscript_dis) )
				return 0;
		}
		//@@@AddEnd by KM 2002/10/07
		
		fp = fopen("/var/config/ipq/mscript.conf", "w");
		if(fp == NULL)
		{
			return 0;
		}
		fprintf(fp, "1");
		fclose(fp);

		if((ACONF->ids.flag[1] & 0x08) != 0x08)
		{
		//@@@ModifyBegin modify by KM 2002/10/16 use set chains rules
			
			sprintf(command, "iptables -t mangle -N urlblock");
			system(command);
			sprintf(command, "iptables -t mangle -A urlblock -p TCP -s ! %d.%d.%d.%d --dport 80 -j MARK --set-mark 3",
				ACONF->local.ip[0],
				ACONF->local.ip[1],
				ACONF->local.ip[2],
				ACONF->local.dmz_host);
			system(command);
			sprintf(command, "iptables -t mangle -A urlblock -j RETURN");
			system(command);
			sprintf(command, "iptables -t mangle -I PREROUTING -i eth0 -p TCP ! --syn -j urlblock");
			system(command);


			sprintf(command, "iptables -t filter -N urlblock");
			system(command);
			sprintf(command, "iptables -t filter -A urlblock -p TCP -s ! %d.%d.%d.%d --dport 80 -j QUEUE",
				ACONF->local.ip[0],
				ACONF->local.ip[1],
				ACONF->local.ip[2],
				ACONF->local.dmz_host);
			system(command);
			sprintf(command, "iptables -t filter -A urlblock -j RETURN");
			system(command);
			sprintf(command, "iptables -A FORWARD -i eth0 -p TCP ! --syn -j urlblock");
			system(command);

			if(ACONF->ids.mscript_proxy)
			{
				sprintf(command, "iptables -t mangle -I urlblock -p TCP -s ! %d.%d.%d.%d --dport %d -j MARK --set-mark 3",
					ACONF->local.ip[0],
					ACONF->local.ip[1],
					ACONF->local.ip[2],
					ACONF->local.dmz_host,
					ACONF->ids.mscript_proxy);
				system(command);
				                        	
				sprintf(command, "iptables -t filter -I urlblock -p TCP -s ! %d.%d.%d.%d --dport %d -j QUEUE",
					ACONF->local.ip[0],
					ACONF->local.ip[1],
					ACONF->local.ip[2],
					ACONF->local.dmz_host,
					ACONF->ids.mscript_proxy);
				system(command);
			}
		}
		sprintf(command, "iptables -t mangle -N mscript");
		system(command);
		sprintf(command, "iptables -t mangle -A mscript -i %s -p tcp ! --syn -d ! %d.%d.%d.%d --sport 80 -j MARK --set-mark 5",
			WANstr,
			ACONF->local.ip[0],
			ACONF->local.ip[1],
			ACONF->local.ip[2],
			ACONF->local.dmz_host);
		system(command);
		sprintf(command, "iptables -t mangle -A mscript -j RETURN");
		system(command);
		sprintf(command, "iptables -t mangle -I PREROUTING -i %s -p tcp ! --syn -j mscript",WANstr);
		system(command);

		sprintf(command, "iptables -t filter -N mscript");
		system(command);
		sprintf(command, "iptables -t filter -A mscript -i %s -o eth0 -p tcp ! --syn -d ! %d.%d.%d.%d --sport 80 -j QUEUE",
			WANstr,
			ACONF->local.ip[0],
			ACONF->local.ip[1],
			ACONF->local.ip[2],
			ACONF->local.dmz_host);
		system(command);
		sprintf(command, "iptables -t filter -A mscript -j RETURN");
		system(command);
		sprintf(command, "iptables -A FORWARD -i %s -o eth0 -p tcp ! --syn -j mscript",WANstr);
		system(command);

		if(ACONF->ids.mscript_proxy)
		{
			sprintf(command, "iptables -t mangle -I mscript -i %s -p TCP ! --syn -d ! %d.%d.%d.%d --sport %d -j MARK --set-mark 5",
				WANstr,
				ACONF->local.ip[0],
				ACONF->local.ip[1],
				ACONF->local.ip[2],
				ACONF->local.dmz_host,
				ACONF->ids.mscript_proxy);
			system(command);

			sprintf(command, "iptables -t filter -I mscript -i %s -o eth0 -p TCP ! --syn -d ! %d.%d.%d.%d --sport %d -j QUEUE",
				WANstr,
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->local.dmz_host,
				ACONF->ids.mscript_proxy);
			system(command);
		}
		//@@@ModifyEnd by KM 2002/10/16
		
	}
	else
	{
		//@@@AddBegin by KM 2002/10/07
		if((ACONF->ids.flag[1]&0x10)==0x10)		// Malicious Script
		{
			if( !dis(DMZ_dis) && !dis(PROXYmscript_dis) )
				return 0;
		}
		//@@@AddEnd by KM 2002/10/07
		
		fp = fopen("/var/config/ipq/mscript.conf", "w");
		if(fp == NULL)
		{
			return 0;
		}
		fprintf(fp, "0");
		fclose(fp);
		
		//@@@ModifyBegin by KM 2002/10/16 change the rules to be in chains
		if((ACONF->ids.flag[1] & 0x08) != 0x08)
		{
			sprintf(command, "iptables -t mangle -D PREROUTING -i eth0 -p TCP ! --syn -j urlblock");
			system(command);
			sprintf(command, "iptables -t mangle -F urlblock");
			system(command);
			sprintf(command, "iptables -t mangle -X urlblock");
			system(command);

			sprintf(command, "iptables -t filter -D FORWARD -i eth0 -p TCP ! --syn -j urlblock");
			system(command);
			sprintf(command, "iptables -t filter -F urlblock");
			system(command);
			sprintf(command, "iptables -t filter -X urlblockp");
			system(command);
		}

		getOldWANstr(WANstr);
		
		sprintf(command, "iptables -t mangle -D PREROUTING -i %s -p tcp ! --syn -j mscript",WANstr);
		system(command);
		sprintf(command, "iptables -t mangle -F mscript");
		system(command);
		sprintf(command, "iptables -t mangle -X mscript");
		system(command);

		sprintf(command, "iptables -t filter -D FORWARD -i %s -o eth0 -p tcp ! --syn -j mscript",WANstr);
		system(command);
		sprintf(command, "iptables -t filter -F mscript");
		system(command);
		sprintf(command, "iptables -t filter -X mscript");
		system(command);
		//@@@ModifyEnd by KM 2002/10/16
	}

	return 0;
}



int add_maddr(ACONFIG *src, char *mail)
{
	int i = 0;

	while(src->ids.mailblock[i].string[0] != 0)
		i++;
//@@@ModifyBegin by KM 2002/10/05
	if(i < MAIL_ADDRESS_NUM)
//@@@ModifyEnd by KM
		strcpy(src->ids.mailblock[i].string, mail);
	else
		return 0;

	return 1;
}

int del_maddr(ACONFIG *src, int num)
{
	int i;

	num--;
//@@@ModifyBegin by KM 2002/10/05
	if(num < 0 && num > MAIL_ADDRESS_NUM)
//@@@ModifyEnd by KM
		return 0;

	if(src->ids.mailblock[num].string[0] != 0)
		src->ids.mailblock[num].string[0] = 0;
	else
		return 0;

	i = num + 1;
//@@@ModifyBegin by KM 2002/10/05
	if(i == MAIL_ADDRESS_NUM)
//@@@ModifyEnd by KM
		return 1;
	while(src->ids.mailblock[i].string[0] != 0)
	{
		strcpy(src->ids.mailblock[i - 1].string, src->ids.mailblock[i].string);
		i++;
//@@@ModifyBegin by KM 2002/10/05
		if(i == MAIL_ADDRESS_NUM)
//@@@ModifyEnd by KM
		{
			src->ids.mailblock[i - 1].string[0] = 0;
			return 1;
		}
	}
	src->ids.mailblock[i - 1].string[0] = 0;

	return 1;
}



int setids(int act)
{

	//close(2);	//mark by Lily 20020926
//@@@ModifyBegin by KM 2002/10/05
	if(act==0)	return 0;//no use setids(0);
	
	if(act)
	{
		//---delete old rules use oldACONF (in the RAM)
		if((oldACONF->ids.flag[0]&0x01)==0x01)		// Snork
			setids_snork(0);
		if((oldACONF->ids.flag[0]&0x02)==0x02)		// Smurf
			setids_smurf(0);
		//if((oldACONF->ids.flag[0]&0x04)==0x04)	// Nothing
		//	;
		if((oldACONF->ids.flag[0]&0x08)==0x08)		// Port Scan Detection
			setids_psd(0);
		if((oldACONF->ids.flag[0]&0x10)==0x10)		// UDP Bomb
			setids_udpbomb(0);
		if((oldACONF->ids.flag[0]&0x20)==0x20)		// SYN Flooding
			setids_synf(0);
		if((oldACONF->ids.flag[0]&0x40)==0x40)		// Fraggle
			setids_fraggle(0);
		if((oldACONF->ids.flag[0]&0x80)==0x80)		// Land Attack
			setids_land(0);
		if((oldACONF->ids.flag[1]&0x01)==0x01)		// ICMP Unreachable
			setids_icmpun(0);
		if((oldACONF->ids.flag[1]&0x02)==0x02)		// Ping Flooding (ICMP Echo Flooding)
			setids_pingf(0);
		if((oldACONF->ids.flag[1]&0x04)==0x04)		// DNS Scan
			setids_dns(0);
		if((oldACONF->ids.flag[1]&0x08)==0x08)		// http url block
			setids_urlblock(0);
		if((oldACONF->ids.flag[1]&0x10)==0x10)		// Malicious Script
			setids_mscript(0);
		if((oldACONF->ids.flag[1]&0x20)==0x20)		// Virus
			setids_virusscan(0);
		if(((oldACONF->ids.flag[1]&0x40)==0x40)  || ((oldACONF->ids.flag[1]&0x80)==0x80) )
			setids_mailblock(0);
								// Mail Bomb - Address Blocking
								// Mail Bomb - total number
		//---end close old rules
		
		//---add new rules use ACONF (in the flash)
		if((ACONF->ids.flag[0]&0x01)==0x01)		// Snork
			setids_snork(1);
		if((ACONF->ids.flag[0]&0x02)==0x02)		// Smurf
			setids_smurf(1);
		//if((oldACONF->ids.flag[0]&0x04)==0x04)	// Nothing
		//	;
		if((ACONF->ids.flag[0]&0x08)==0x08)		// Port Scan Detection               
			setids_psd(1);                                                                  
		if((ACONF->ids.flag[0]&0x10)==0x10)		// UDP Bomb                          
			setids_udpbomb(1);                                                              
		if((ACONF->ids.flag[0]&0x20)==0x20)		// SYN Flooding                      
			setids_synf(1);                                                                 
		if((ACONF->ids.flag[0]&0x40)==0x40)		// Fraggle                           
			setids_fraggle(1);                                                              
		if((ACONF->ids.flag[0]&0x80)==0x80)		// Land Attack                       
			setids_land(1);                                                                 
		if((ACONF->ids.flag[1]&0x01)==0x01)		// ICMP Unreachable                  
			setids_icmpun(1);                                                               
		if((ACONF->ids.flag[1]&0x02)==0x02)		// Ping Flooding (ICMP Echo Flooding)
			setids_pingf(1);
		if((ACONF->ids.flag[1]&0x04)==0x04)		// DNS Scan
			setids_dns(1);
		if((ACONF->ids.flag[1]&0x08)==0x08)		// http url block
			setids_urlblock(1);
		if((ACONF->ids.flag[1]&0x10)==0x10)		// Malicious Script
			setids_mscript(1);
		if((ACONF->ids.flag[1]&0x20)==0x20)		// Virus
			setids_virusscan(1);
		if(((ACONF->ids.flag[1]&0x40)==0x40)  || ((ACONF->ids.flag[1]&0x80)==0x80) )
			setids_mailblock(1);
								// Mail Bomb - Address Blocking
								// Mail Bomb - total number
	}
	/*
	else
	{
		// Closing already opened items.
		// If we just close all items but doesn't check that had been opened or not,
		// it will cause some problems like "fault-common.c 242".
		if((ACONF->ids.flag[0]&0x01)==0x01)		// Snork
		{
			//printf("0 - flag[0]:0x01\n");
			setids_snork(0);
		}
		if((ACONF->ids.flag[0]&0x02)==0x02)		// Smurf
		{
			//printf("0 - flag[0]:0x02\n");
			setids_smurf(0);
		}
		//if((ACONF->ids.flag[0]&0x04)==0x04)	// Nothing
		//	;
		if((ACONF->ids.flag[0]&0x08)==0x08)		// Port Scan Detection
		{
			//printf("0 - flag[0]:0x08\n");
			setids_psd(0);
		}
		if((ACONF->ids.flag[0]&0x10)==0x10)		// UDP Bomb
		{
			//printf("0 - flag[0]:0x10\n");
			setids_udpbomb(0);
		}
		if((ACONF->ids.flag[0]&0x20)==0x20)		// SYN Flooding
		{
			//printf("0 - flag[0]:0x20\n");
			setids_synf(0);
		}
		if((ACONF->ids.flag[0]&0x40)==0x40)		// Fraggle
		{
			//printf("0 - flag[0]:0x40\n");
			setids_fraggle(0);
		}
		if((ACONF->ids.flag[0]&0x80)==0x80)		// Land Attack
		{
			//printf("0 - flag[0]:0x80\n");
			setids_land(0);
		}
		if((ACONF->ids.flag[1]&0x01)==0x01)		// ICMP Unreachable
		{
			//printf("0 - flag[1]:0x01\n");
			setids_icmpun(0);
		}
		if((ACONF->ids.flag[1]&0x02)==0x02)		// Ping Flooding (ICMP Echo Flooding)
		{
			//printf("0 - flag[1]:0x02\n");
			setids_pingf(0);
		}
		// --- DNS Scan has its own menu, do not set it ---
		if((ACONF->ids.flag[1]&0x04)==0x04)	// DNS Scan
			setids_dns(0);
		if((ACONF->ids.flag[1]&0x08)==0x08)	// http url block
			setids_urlblock(0);
		// --- Malicious Script has its own menu, do not set it ---
		if((ACONF->ids.flag[1]&0x10)==0x10)	// Malicious Script
			setids_mscript(0);
		if((ACONF->ids.flag[1]&0x20)==0x20)		// Virus
			setids_virusscan(0);
		if(((ACONF->ids.flag[1]&0x40)==0x40)  || ((ACONF->ids.flag[1]&0x80)==0x80) )
			setids_mailblock(0);
		// --- Mail Bomb has its own menu, do not set it ---
		//if((ACONF->ids.flag[1]&0x40)==0x40)	// Mail Bomb - Address Blocking
		//	setids_mailblock(0);
		//if((ACONF->ids.flag[1]&0x80)==0x80)		// Mail Bomb - total number
	}
	*/
//@@@ModifyEnd by KM 2002/10/05
	return 0;
}
#endif


/*---set Send ---*/
int setsend(int act)
{
	int i,child_id;
	char command[80];
	FILE *alert_table, *mail_list, *send_pid;

	#if 1
	system("amit_send f&");	//modified by Lily 20020926
	#else
	child_id = fork();
	if (child_id == 0)
	{
		setsid(); umask(0); execl("/bin/amit_send","amit_send","f",NULL); exit(0);
	} else {
		return -1;
	}
	#endif
	
	return 0;
}





#ifdef _IPSec

/* *************** */
/* IPsec  settings */
/* *************** */

// *************** *
// IPsec setManual *
// *************** *

int do_command(char *cmd, int mode)
{
	if( mode )
	{
		printf("%s\n", cmd);
		return 0;
	}
//printf("%s\n", cmd);
	return system(cmd);
}

int
setmanual(int index_of_tunnel, int action)
{

	char command[80];
	char temp[6];
	char dir[25];
	char spi[6];
	char local_ip[16];
	char remote_ip[16];
	char auth[8];
	char authkey[43];
	char enckey[51];
	char gateway[16];
	char local_net[16];
	char l_mask[16];
	char remote_net[16];
	char r_mask[16];
	int debug,i,j;
	BYTE encap_protocol;
	FILE *fp_ip;
	ip_info_struct ife;
	

	strcpy(dir,"/usr/local/lib/ipsec/");
	//--get spi (0x100~0xfff)
	sprintf(temp,"%lx",ACONF->ipsec.Tunnel_Info[index_of_tunnel].key_method.manual.local_spi);
	strcpy(spi,"0x000");
	for(i=strlen(temp)-1,j=0;i>=0;i--,j++)
	{
		spi[4-j]=temp[i];
	}

	//get local wan ip
	fp_ip = fopen(IP_INFO_FILE,"r");
	fgets(local_ip,16,fp_ip);

	//get remote ip
	sprintf(remote_ip,"%d.%d.%d.%d",
			ACONF->ipsec.Tunnel_Info[index_of_tunnel].remote_gateway[0],
			ACONF->ipsec.Tunnel_Info[index_of_tunnel].remote_gateway[1],
			ACONF->ipsec.Tunnel_Info[index_of_tunnel].remote_gateway[2],
			ACONF->ipsec.Tunnel_Info[index_of_tunnel].remote_gateway[3]);
	//get auth & auth key
	if(ACONF->ipsec.Tunnel_Info[index_of_tunnel].key_method.manual.auth_algorithm==0)
	{
		strcpy(auth,"");
		strcpy(authkey,"");
	}
	else if(ACONF->ipsec.Tunnel_Info[index_of_tunnel].key_method.manual.auth_algorithm==1)//MD5
	{
		strcpy(auth,"md5-96");
		strcpy(authkey,"0x");
		memcpy(authkey+2,ACONF->ipsec.Tunnel_Info[index_of_tunnel].key_method.manual.auth_key,32);
		authkey[34]=0;
	}
	else
	{
		strcpy(auth,"sha1-96");
		strcpy(authkey,"0x");
		memcpy(authkey+2,ACONF->ipsec.Tunnel_Info[index_of_tunnel].key_method.manual.auth_key,40);
		authkey[42]=0;
	}

	//get enckey
	strcpy(enckey,"0x");
	memcpy(enckey+2,ACONF->ipsec.Tunnel_Info[index_of_tunnel].key_method.manual.encry_num[0].encryption_key,48);
	enckey[50]=0;
	//get GW
	findGW(&ife);
	sprintf(gateway,"%d.%d.%d.%d",ife.gw[0],ife.gw[1],ife.gw[2],ife.gw[3]);
	//get local subnet
	if(ACONF->ipsec.Tunnel_Info[index_of_tunnel].local_subnet[0]==0 &&
	   ACONF->ipsec.Tunnel_Info[index_of_tunnel].local_subnet[1]==0 &&
	   ACONF->ipsec.Tunnel_Info[index_of_tunnel].local_subnet[2]==0 &&
	   ACONF->ipsec.Tunnel_Info[index_of_tunnel].local_subnet[3]==0 )
		strcpy(local_net,"");
	else
		sprintf(local_net,"%d.%d.%d.%d",ACONF->ipsec.Tunnel_Info[index_of_tunnel].local_subnet[0],
						ACONF->ipsec.Tunnel_Info[index_of_tunnel].local_subnet[1],
						ACONF->ipsec.Tunnel_Info[index_of_tunnel].local_subnet[2],
						ACONF->ipsec.Tunnel_Info[index_of_tunnel].local_subnet[3]);
	//get local netmask
	if(ACONF->ipsec.Tunnel_Info[index_of_tunnel].local_netmask[0]==0 &&
	   ACONF->ipsec.Tunnel_Info[index_of_tunnel].local_netmask[1]==0 &&
	   ACONF->ipsec.Tunnel_Info[index_of_tunnel].local_netmask[2]==0 &&
	   ACONF->ipsec.Tunnel_Info[index_of_tunnel].local_netmask[3]==0 )
	   	strcpy(l_mask,"");
	else
		sprintf(l_mask,"%d.%d.%d.%d",ACONF->ipsec.Tunnel_Info[index_of_tunnel].local_netmask[0],
						ACONF->ipsec.Tunnel_Info[index_of_tunnel].local_netmask[1],
						ACONF->ipsec.Tunnel_Info[index_of_tunnel].local_netmask[2],
						ACONF->ipsec.Tunnel_Info[index_of_tunnel].local_netmask[3]);
	//get remote subnet
	if(ACONF->ipsec.Tunnel_Info[index_of_tunnel].remote_subnet[0]==0 &&
	   ACONF->ipsec.Tunnel_Info[index_of_tunnel].remote_subnet[1]==0 &&
	   ACONF->ipsec.Tunnel_Info[index_of_tunnel].remote_subnet[2]==0 &&
	   ACONF->ipsec.Tunnel_Info[index_of_tunnel].remote_subnet[3]==0 )
	   	strcpy(remote_net,"");
	else
		sprintf(remote_net,"%d.%d.%d.%d",ACONF->ipsec.Tunnel_Info[index_of_tunnel].remote_subnet[0],
						ACONF->ipsec.Tunnel_Info[index_of_tunnel].remote_subnet[1],
						ACONF->ipsec.Tunnel_Info[index_of_tunnel].remote_subnet[2],
						ACONF->ipsec.Tunnel_Info[index_of_tunnel].remote_subnet[3]);
	//get remote netmask
	if(ACONF->ipsec.Tunnel_Info[index_of_tunnel].remote_netmask[0]==0 &&
	   ACONF->ipsec.Tunnel_Info[index_of_tunnel].remote_netmask[1]==0 &&
	   ACONF->ipsec.Tunnel_Info[index_of_tunnel].remote_netmask[2]==0 &&
	   ACONF->ipsec.Tunnel_Info[index_of_tunnel].remote_netmask[3]==0 )
	   	strcpy(r_mask,"");
	else
		sprintf(r_mask,"%d.%d.%d.%d",ACONF->ipsec.Tunnel_Info[index_of_tunnel].remote_netmask[0],
						ACONF->ipsec.Tunnel_Info[index_of_tunnel].remote_netmask[1],
						ACONF->ipsec.Tunnel_Info[index_of_tunnel].remote_netmask[2],
						ACONF->ipsec.Tunnel_Info[index_of_tunnel].remote_netmask[3]);
	//get encap_protocol
	encap_protocol=ACONF->ipsec.Tunnel_Info[index_of_tunnel].key_method.manual.encap_protocol;

	//char spi[] = "0x600";
	//char local_ip[] =  "140.116.247.37";
	//char remote_ip[] =  "140.116.247.9";
	//char auth[] = "sha1-96";
	//char authkey[] = "0x1111222233334444555566667777888899990000";
	//char enckey[] = "0x111122223333444455556666777788889999000011112222";
	//char gateway[] = "140.116.247.253";
	//char local_net[] ="192.168.37.0";
	//char l_mask[] = "24";
	//char remote_net[] = "192.168.9.0";
	//char r_mask[] = "24";



	 // unsigned char encap_protocol
	 //
	 // 0x01	 AH_TUNNEL
	 // 0x02  AH_TRANSPORT
	 // 0x03  ESP_TUNNEL
	 // 0x04  ESP_TRANSPORT
	 // 0x05  ESP_TUNNEL_WITH_AUTH
	 // 0x06  ESP_TRANSPORT_WITH_AUTH


	//unsigned char encap_protocol = 0x06;

	debug=0;

//printf(" %x \n\n", encap_protocol);



#ifdef DEBUG_IPSEC_MANUAL
	debug = 1;;
#endif

	if( action )	// ipsec manual --up tunnel_i
	{
		if( encap_protocol == 0x01 ){		// AH_TUNNEL

			// outbound
			sprintf(command, "%sspi --af inet --said tun%s@%s --ip4 --src %s --dst %s", dir, spi, remote_ip, local_ip, remote_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --said ah%s@%s --ah hmac-%s --src %s --authkey %s", dir, spi, remote_ip, auth, local_ip, authkey);
			do_command(command,debug);
			sprintf(command, "%sspigrp --said tun%s@%s ah%s@%s", dir, spi, remote_ip, spi, remote_ip);
			do_command(command,debug);

			// inbound
			sprintf(command, "%sspi --af inet --said tun%s@%s --ip4 --src %s --dst %s", dir, spi, local_ip, remote_ip, local_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --said ah%s@%s --ah hmac-%s --src %s --authkey %s", dir, spi, local_ip, auth, remote_ip, authkey);
			do_command(command,debug);
			sprintf(command, "%sspigrp --said tun%s@%s ah%s@%s", dir, spi, local_ip, spi, local_ip);
			do_command(command,debug);
			// eroute
			if( strlen(local_net)==0 && strlen(remote_net) != 0)
				sprintf(command,"%seroute --eraf inet --replace --src %s/32 --dst %s/%s --said tun%s@%s", dir,local_ip, remote_net, r_mask,spi,  remote_ip);
			else if(strlen(local_net) !=0 && strlen(remote_net) ==0  )
				sprintf(command,"%seroute --eraf inet --replace --src %s/%s --dst %s/32 --said tun%s@%s",dir, local_net, l_mask, remote_ip,  spi, remote_ip);
			else
				sprintf(command,"%seroute --eraf inet --replace --src %s/%s --dst %s/%s --said tun%s@%s",dir, local_net, l_mask, remote_net, r_mask, spi, remote_ip);
			do_command(command,debug);
		}
		else if( encap_protocol == 0x02){	// AH_TRANSPORT

			// outbound
			sprintf(command,"%sspi --af inet --said ah%s@%s --ah hmac-%s --src %s --authkey %s", dir, spi, remote_ip, auth, local_ip, authkey);
			do_command(command,debug);
			// inbound
			sprintf(command,"%sspi --af inet --said ah%s@%s --ah hmac-%s --src %s --authkey %s", dir, spi, local_ip, auth, remote_ip, authkey);
			do_command(command,debug);
			// eroute
			sprintf(command,"%seroute --eraf inet --replace  --src %s/32 --dst %s/32 --said ah%s@%s",dir, local_ip, remote_ip, spi, remote_ip);
			do_command(command,debug);

		}
		else if( encap_protocol == 0x03 ){	// ESP_TUNNEL


			// outbound
			sprintf(command, "%sspi --af inet --said tun%s@%s --ip4 --src %s --dst %s", dir, spi, remote_ip,  local_ip, remote_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --said esp%s@%s --esp 3des --src %s --enckey %s", dir, spi, remote_ip, local_ip, enckey);
			do_command(command,debug);
			sprintf(command, "%sspigrp --said tun%s@%s esp%s@%s", dir, spi, remote_ip, spi, remote_ip);
			do_command(command,debug);

			// inbound
			sprintf(command, "%sspi --af inet --said tun%s@%s --ip4 --src %s --dst %s", dir, spi, local_ip,  remote_ip, local_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --said esp%s@%s --esp 3des --src %s --enckey %s", dir, spi, local_ip, remote_ip, enckey);
			do_command(command,debug);
			sprintf(command, "%sspigrp --said tun%s@%s esp%s@%s", dir, spi, local_ip, spi, local_ip);
			do_command(command,debug);

			// eroute
			if( strlen(local_net)==0 && strlen(remote_net) != 0)
				sprintf(command,"%seroute --eraf inet --replace --src %s/32 --dst %s/%s --said tun%s@%s", dir,local_ip, remote_net, r_mask,spi,  remote_ip);
			else if(strlen(local_net) !=0 && strlen(remote_net) ==0  )
				sprintf(command,"%seroute --eraf inet --replace --src %s/%s --dst %s/32 --said tun%s@%s",dir, local_net, l_mask, remote_ip,  spi, remote_ip);
			else
				sprintf(command,"%seroute --eraf inet --replace --src %s/%s --dst %s/%s --said tun%s@%s",dir, local_net, l_mask, remote_net, r_mask, spi, remote_ip);
			do_command(command,debug);
		}
		else if( encap_protocol == 0x04){	// ESP_TRANSPORT

			// outbound
			sprintf(command, "%sspi --af inet --said esp%s@%s --esp 3des --src %s --enckey %s", dir, spi, remote_ip, local_ip, enckey);
			do_command(command,debug);
			// inbound
			sprintf(command, "%sspi --af inet --said esp%s@%s --esp 3des --src %s --enckey %s", dir, spi, local_ip, remote_ip, enckey);
			do_command(command,debug);
			// eroute
			sprintf(command, "%seroute --eraf inet --replace --src %s/32 --dst %s/32 --said esp%s@%s", dir, local_ip, remote_ip, spi, remote_ip);
			do_command(command,debug);

		}
		else if( encap_protocol == 0x05){//ESP_TUNNEL_WITH_AUTH


			// outbound
			sprintf(command, "%sspi --af inet --said tun%s@%s --ip4 --src %s --dst %s", dir, spi, remote_ip, local_ip, remote_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --said esp%s@%s --esp 3des-%s --src %s --authkey %s --enckey %s", dir, spi, remote_ip, auth, local_ip, authkey, enckey);
			do_command(command,debug);
			sprintf(command, "%sspigrp --said tun%s@%s esp%s@%s", dir, spi, remote_ip, spi, remote_ip);
			do_command(command,debug);

			// inbound
			sprintf(command, "%sspi --af inet --said tun%s@%s --ip4 --src %s --dst %s", dir, spi, local_ip, remote_ip, local_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --said esp%s@%s --esp 3des-%s --src %s --authkey %s --enckey %s", dir, spi, local_ip, auth, remote_ip, authkey, enckey);
			do_command(command,debug);
			sprintf(command, "%sspigrp --said tun%s@%s esp%s@%s", dir, spi, local_ip, spi, local_ip);
			do_command(command,debug);

			//eroute
			if( strlen(local_net)==0 && strlen(remote_net) != 0)
				sprintf(command,"%seroute --eraf inet --replace --src %s/32 --dst %s/%s --said tun%s@%s", dir,local_ip, remote_net, r_mask,spi,  remote_ip);
			else if(strlen(local_net) !=0 && strlen(remote_net) ==0  )
				sprintf(command,"%seroute --eraf inet --replace --src %s/%s --dst %s/32 --said tun%s@%s",dir, local_net, l_mask, remote_ip,  spi, remote_ip);
			else
				sprintf(command,"%seroute --eraf inet --replace --src %s/%s --dst %s/%s --said tun%s@%s",dir, local_net, l_mask, remote_net, r_mask, spi, remote_ip);
			do_command(command,debug);
		}
		else{				//ESP_TRANSPORT_WITH_AUTH

			// outbound
			sprintf(command, "%sspi --af inet --said esp%s@%s --esp 3des-%s --src %s --authkey %s --enckey %s", dir, spi, remote_ip, auth, local_ip, authkey, enckey);
			do_command(command,debug);
			// inbound
			sprintf(command, "%sspi --af inet --said esp%s@%s --esp 3des-%s --src %s --authkey %s --enckey %s", dir, spi, local_ip, auth, remote_ip, authkey, enckey);
			do_command(command,debug);
			// eroute
			sprintf(command, "%seroute --replace --src %s/32 --dst %s/32 --said esp%s@%s", dir, local_ip, remote_ip, spi, remote_ip);
			do_command(command,debug);
		}

		//---------------------------
		//  add a routing table entry
		//---------------------------
		if( encap_protocol == 0x02 ||  encap_protocol == 0x04 ||  encap_protocol == 0x06 )	// all transport modes
		{
			sprintf(command,"route add -host %s/32 dev ipsec0 gw %s", remote_ip, gateway);
		}
		else{	// all tunnel modes
			if(  strlen(remote_net) == 0 )
				sprintf(command,"route add -host %s/32 dev ipsec0 gw %s", remote_ip, gateway);
			else
				sprintf(command,"route add -net %s/%s dev ipsec0 gw %s", remote_net,r_mask, gateway);
		}
		do_command(command, debug);

	}
	else		// ipsec_manual --down tunnel_i
	{


		if( encap_protocol  == 0x01 || encap_protocol == 0x03 || encap_protocol == 0x05 ) 	// all tunnel modes
		{

			if( strlen(local_net)==0 && strlen(remote_net) != 0)
				sprintf(command,"%seroute --del --eraf inet --src %s/32 --dst %s/%s", dir, local_ip, remote_net, r_mask);
			else if(strlen(local_net) !=0 && strlen(remote_net) ==0 )
				sprintf(command,"%seroute --del --eraf inet --src %s/%s --dst %s/32", dir, local_net,l_mask, remote_ip);
			else
				sprintf(command,"%seroute --del --eraf inet --src %s/%s --dst %s/%s", dir, local_net,l_mask, remote_net, r_mask);
			do_command(command,debug);
			sprintf(command,"%sspi --af inet --del --said tun%s@%s", dir, spi, remote_ip);
			do_command(command,debug);
			sprintf(command,"%sspi --af inet --del --said tun%s@%s", dir, spi, local_ip);
			do_command(command,debug);
		}
		else if( encap_protocol == 0x02){	// AH_TRANSPORT
			sprintf(command, "%seroute --del --eraf inet --src %s/32 --dst %s/32", dir, local_ip, remote_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --del --said ah%s@%s", dir, spi, remote_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --del --said ah%s@%s", dir, spi, local_ip);
			do_command(command,debug);

			sprintf(command, "route del -host %s", remote_ip);
			do_command(command,debug);
		}
		else{	// ESP_TRANSPORT or ESP_TRANSPORT_WITH_AUTH
			sprintf(command, "%seroute --del --eraf inet --src %s/32 --dst %s/32", dir, local_ip, remote_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --del --said esp%s@%s", dir, spi, remote_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --del --said esp%s@%s", dir, spi, local_ip);
			do_command(command,debug);

		}
		//---------------------------
		// delete a routing table entry
		//---------------------------
		if( encap_protocol == 0x02 ||  encap_protocol == 0x04 ||  encap_protocol == 0x06 )	// all transport modes
		{
			sprintf(command,"route del -host %s/32 dev ipsec0 gw %s", remote_ip, gateway);
		}
		else{	// all tunnel modes
			if(  strlen(remote_net) == 0 )
				sprintf(command,"route del -host %s/32 dev ipsec0 gw %s", remote_ip, gateway);
			else
				sprintf(command,"route del -net %s/%s dev ipsec0 gw %s", remote_net,r_mask, gateway);
		}
		do_command(command, debug);

	}

}

//----end set manual ---by wnlee
//----by succ
void setsecrets(int switchs)
{
	int i,j,ip_value;
	FILE *fp, *fp_ip;
	BYTE ip_now[4];
	char ip_temp[20],ip_num[4];
	char *tp;

	//get now ip
	fp_ip = fopen(IP_INFO_FILE,"r");
	fgets(ip_temp,20,fp_ip);
	tp=ip_temp;
	for(j=0;j<4;j++)
	{
		i=0;
		while(*tp!='.' && *tp!= '\0')
		{
			ip_num[i]=*tp;
			i++;
			tp++;
		}
		ip_num[i]=0;
		ip_value=atoi(ip_num);
		ip_now[j]=ip_value;
	}

  if(switchs == 1)
  {
    if(ACONF->ipsec.Tunnel_Info[i].type_of_key_method == 0 &&  //IKE
       ACONF->ipsec.Tunnel_Info[i].tunnel_name == NULL)               //Legal tunnel
    {
      fp = fopen("/var/ipsec.secrets","a+");
      for(i=0;i<MAX_NUMBER_OF_TUNNELS;i++)
      {
        fprintf(fp,"%d.%d.%d.%d %d.%d.%d.%d: PSK \"%s\"\n",
                    ip_now[0],
    	            ip_now[1],
  	            ip_now[2],
  	            ip_now[3],
        	    ACONF->ipsec.Tunnel_Info[i].remote_gateway[0],
    	            ACONF->ipsec.Tunnel_Info[i].remote_gateway[1],
  	            ACONF->ipsec.Tunnel_Info[i].remote_gateway[2],
  	            ACONF->ipsec.Tunnel_Info[i].remote_gateway[3],
  	            ACONF->ipsec.Tunnel_Info[i].key_method.ike.preshared_key);
      }
      fclose(fp);
    }
  }
  else
  {
    // *********************** *
    // remove the secrets file *
    // *********************** *
    remove("/var/ipsec.secrets");
  }
}

// ******* *
// set ike *
// ******* *
void setike(int index,int switchs)
{
	int i,j,ip_value;
	char temp[300];
	char time[30];
	FILE *fp, *fp_ip;
	BYTE ip_now[4];
	char ip_temp[20],ip_num[4];
	char *tp;


	//get now ip
	fp_ip = fopen(IP_INFO_FILE,"r");
	fgets(ip_temp,20,fp_ip);
	tp=ip_temp;
	for(j=0;j<4;j++)
	{
		i=0;
		while(*tp!='.' && *tp!= '\0')
		{
			ip_num[i]=*tp;
			i++;
			tp++;
		}
		ip_num[i]=0;
		ip_value=atoi(ip_num);
		ip_now[j]=ip_value;
	}

  if(switchs == 1) //ON
  {
    setsecrets(1);

    // ****************** *
    // add ike connection *
    // ****************** *
    if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.mode == 0) //transport mode
    {
      sprintf(temp,"/bin/whack --name %s --host %d.%d.%d.%d --to --host %d.%d.%d.%d",
                   ACONF->ipsec.Tunnel_Info[i].tunnel_name,
                   ip_now[0],
                   ip_now[1],
                   ip_now[2],
                   ip_now[3],
                   ACONF->ipsec.Tunnel_Info[i].remote_gateway[0],
                   ACONF->ipsec.Tunnel_Info[i].remote_gateway[1],
                   ACONF->ipsec.Tunnel_Info[i].remote_gateway[2],
                   ACONF->ipsec.Tunnel_Info[i].remote_gateway[3]);

      if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.encap_protocol == 0) //ESP only
      {
        strcat(temp," --encrypt");
      }
      else if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.encap_protocol == 1) //AH only
      {
        strcat(temp," --authentication");
      }
      else //ESP and AH
      {
        strcat(temp," --encrypt --authentication");
      }

      if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.pfs == 1) //pfs enable
      {
        strcat(temp," --pfs");
      }

      if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.ikelifetime != 0)
      {
      	sprintf(time," --ikelifetime %d",ACONF->ipsec.Tunnel_Info[i].key_method.ike.ikelifetime);
        strcat(temp,time);
      }

      if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.ipseclifetime != 0)
      {
      	sprintf(time," --ipseclifetime %d",ACONF->ipsec.Tunnel_Info[i].key_method.ike.ikelifetime);
        strcat(temp,time);
      }

      strcat(temp," --delete");

    }
    else  //tunnel mode
    {
      sprintf(temp,"/bin/whack --name %s --host %d.%d.%d.%d --client %d.%d.%d.%d/%d --to --host %d.%d.%d.%d --client %d.%d.%d.%d/%d",
                   ACONF->ipsec.Tunnel_Info[i].tunnel_name,
                   ip_now[0],
                   ip_now[1],
		   ip_now[2],
                   ip_now[3],
                   ACONF->ipsec.Tunnel_Info[i].local_subnet[0],
                   ACONF->ipsec.Tunnel_Info[i].local_subnet[1],
                   ACONF->ipsec.Tunnel_Info[i].local_subnet[2],
                   ACONF->ipsec.Tunnel_Info[i].local_subnet[3],
                   ACONF->ipsec.Tunnel_Info[i].local_netmask[0],
                   ACONF->ipsec.Tunnel_Info[i].local_netmask[1],
                   ACONF->ipsec.Tunnel_Info[i].local_netmask[2],
                   ACONF->ipsec.Tunnel_Info[i].local_netmask[3],
                   ACONF->ipsec.Tunnel_Info[i].remote_gateway[0],
                   ACONF->ipsec.Tunnel_Info[i].remote_gateway[1],
                   ACONF->ipsec.Tunnel_Info[i].remote_gateway[2],
                   ACONF->ipsec.Tunnel_Info[i].remote_gateway[3],
                   ACONF->ipsec.Tunnel_Info[i].remote_subnet[0],
                   ACONF->ipsec.Tunnel_Info[i].remote_subnet[1],
                   ACONF->ipsec.Tunnel_Info[i].remote_subnet[2],
                   ACONF->ipsec.Tunnel_Info[i].remote_subnet[3],
                   ACONF->ipsec.Tunnel_Info[i].remote_netmask[0],
                   ACONF->ipsec.Tunnel_Info[i].remote_netmask[1],
                   ACONF->ipsec.Tunnel_Info[i].remote_netmask[2],
                   ACONF->ipsec.Tunnel_Info[i].remote_netmask[3] );

      if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.encap_protocol == 0) //ESP only
      {
        strcat(temp," --encrypt");
      }
      else if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.encap_protocol == 1) //AH only
      {
        strcat(temp," --authentication");
      }
      else //ESP and AH
      {
        strcat(temp," --encrypt --authentication");
      }

      if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.pfs == 1) //pfs enable
      {
        strcat(temp," --pfs");
      }

      if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.ikelifetime != 0)
      {
      	sprintf(time," --ikelifetime %d",ACONF->ipsec.Tunnel_Info[i].key_method.ike.ikelifetime);
        strcat(temp,time);
      }

      if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.ipseclifetime != 0)
      {
      	sprintf(time," --ipseclifetime %d",ACONF->ipsec.Tunnel_Info[i].key_method.ike.ikelifetime);
        strcat(temp,time);
      }

      strcat(temp," --delete");
    }
  }
  else
  {
    setsecrets(0);


    // delete ike connection

    sprintf(temp,"/bin/whack --delete --name %s",ACONF->ipsec.Tunnel_Info[i].tunnel_name);
    system(temp);
  }
}




// ********** *
// Set IPSec  *
// ********** *

setipsec(int mode, int switchs)   //mode = -1,reset,_hھindexh@reset
{
  int i;
  FILE *fp;
  char pid[10];
  char temp[80];


  if(switchs == 1)
  {
    if(ACONF->ipsec.if_enable_ipsec == 1)
    {
      // *********************
      // setup ipsec interface
      // *********************
      if(mode == -1) //OPEN ALL
      {
        system("/usr/local/lib/ipsec/tncfg --attach --virtual ipsec0 --physical eth1");
        sprintf(temp,"ifconfig ipsec0 %d.%d.%d.%d netmask %d.%d.%d.%d",
                     ACONF->local.rhip[0],
                     ACONF->local.rhip[1],
                     ACONF->local.rhip[2],
                     ACONF->local.rhip[3],
                     ACONF->local.rhnm[0],
                     ACONF->local.rhnm[1],
                     ACONF->local.rhnm[2],
                     ACONF->local.rhnm[3]);


        // setup ipsec connections
        for(i = 0;i<MAX_NUMBER_OF_TUNNELS;i++)
        {
      	  if(ACONF->ipsec.Tunnel_Info[i].tunnel_name != NULL)
      	  {
            if(ACONF->ipsec.Tunnel_Info[i].type_of_key_method == 0) //IKE
            {
              // setup ike connection
 	      setike(i,1);
            }
            else if(ACONF->ipsec.Tunnel_Info[i].type_of_key_method == 1)
            {
              // setup manual connection
      	      setmanual(i,1);
            }
          }
        }
      }
      else  //mode != -1
      {
      	if(ACONF->ipsec.Tunnel_Info[mode].tunnel_name != NULL)
      	{
          if(ACONF->ipsec.Tunnel_Info[mode].type_of_key_method == 0) //IKE
          {
            // setup ike connection
 	    setike(mode,1);
          }
          else if(ACONF->ipsec.Tunnel_Info[mode].type_of_key_method == 1)
          {
            // setup manual connection
      	    setmanual(mode,1);
          }
        }
      }

      // open pluto
      system("/bin/pluto --nofork &");
      system("/bin/whack --listen");
    }
    else
    {
      goto stop_ipsec;
    }
  }
  else // close ipsec
  {
stop_ipsec:

    // close pluto

    fp = fopen("/var/run/pluto.pid","w");
    fgets(pid,10,fp);
    fclose(fp);
    sprintf(temp,"kill %s",pid);
    system(temp);


    // shutdowm ipsec connections
    if(mode == -1)
    {
      for(i = 0;i<MAX_NUMBER_OF_TUNNELS;i++)
      {
        if(ACONF->ipsec.Tunnel_Info[i].tunnel_name != NULL)
        {
          if(ACONF->ipsec.Tunnel_Info[i].type_of_key_method == 0) //IKE
          {
 	    setike(i,0);
          }
          else if(ACONF->ipsec.Tunnel_Info[i].type_of_key_method == 1)
          {
      	    setmanual(i,0);
          }
        }
      }

      // shutdown ipsec interface
      system("ifconfig ipsec0 down");
      system("/usr/local/lib/ipsec/tncfg --dttach --virtual ipsec0 --physical eth1");
    }
    else //mode != -1
    {
      if(ACONF->ipsec.Tunnel_Info[mode].tunnel_name != NULL)
      {
        if(ACONF->ipsec.Tunnel_Info[mode].type_of_key_method == 0) //IKE
        {
          setike(mode,0);
        }
        else if(ACONF->ipsec.Tunnel_Info[mode].type_of_key_method == 1)
        {
      	  setmanual(mode,0);
        }
      }
    }
  }
}

#endif	//_IPSec



/* ********** */
/* set boot   */
/* ********** */

int setboot(int act)
{
	FILE *fd;
	struct timeb nowtime;
	int child_id;
        
        
	#ifdef FOR_DEBUG
		printf("**************************************** SET BOOT *****************\r\n");
	#endif
	
	// 1. --- set global variables and initialization for some procedures
	during_booting = 1;
	set_wanget_result(77);
	cold_start = 0; 
	ftime(&nowtime); 
	if (nowtime.time < 943920010) {
		cold_start = 1;
	} else {
		system("iptables -t nat -F");		//clean rules
		system("iptables -t nat -X");		//delete chains
		//system("iptables -t nat -Z");		//clean counters
		system("iptables -t filter -F");	//clean rules
		system("iptables -t filter -X");	//delete chains
		//system("iptables -t filter -Z");	//clean counters
		system("iptables -t mangle -F");	//clean rules
		system("iptables -t mangle -X");	//delete chains
		//system("iptables -t mangle -Z");	//clean counters
		system("rmmod iptable_filter");
		system("rmmod iptable_mangle");
	}
	#ifdef FOR_DEBUG
		if (cold_start) printf("========================== COLD START =============\r\n");
	#endif
	
	// 1.5. ---
	#ifdef FOR_DEBUG
		printf("-------------------------------------------------------------------------------\r\n");
		printf("Start heart beat\r\n");
	#endif
	if (cold_start == 0) system("led 1 77 &");	//don't move
	else system("led 1 0 &");
	
	// 3. --- create linked file "/var/config/resolv.conf" for "/etc/resolv.conf" ---
	#ifdef FOR_DEBUG
		printf("-------------------------------------------------------------------------------\r\n");
		printf("setboot: Create /var/config/resolv.conf\r\n");
	#endif
	set_default_DNS();
	
	// 4. --- initialize monitor
	system("monitor 0");
	
	// 4.4 --- set LAN's MAC
	setlanmac(1);
	// 4.5 --- set WAN's MAC
	setwanmac(1);
	
	// 5. --- 
	setnat(1);		//it must be called before setlan
	
	// 6. ---
	setlan(1);
	
	// 7. ---
	if (act == 1) {		//act==9: no invoking httpd
	  #ifdef FOR_DEBUG
		printf("-------------------------------------------------------------------------------\r\n");
		printf("Start amit HTTPD\r\n");
	  #endif
	  system("amit_httpd&");
	}
		
	// 9. ---
	setwan(1);
	
	// 10. ---
	setsmap(1);
	
	// 11. ---
	setdmz(1);
	
	// 12. ---
	setbwping(1);
	
	// 13. ---
	setspap(1);
	
	// 14. ---
	setpmac(1);
	
	// 15. ---
	setdhcpd(1);	//must be behind of setwan and setpmac
	
	// 16. ---
	setsnmpd(1);
	
	// 17. ---
	setdomainf(1);
	
	// 18. ---
	saveIPinfo();
	
	// 19. ---
	setfirewall(1);
	
	// 20. ---
	setmnat(1);	//virtual computer
	
	// 21. ---
	setsend(1);
	
	// 21.5 ---
	setremoteadmin();
	
	//setpppd(1);	//for PPTP
	//if(ACONF->pptp.enable==1) setpptpd(1);
	//system("l2tpd_conf");
	//system("l2tpd");
	//setids(1);
	//setipsec(-1,1);
	
	
	// 22. ---
	system("ifconfig lo 127.0.0.1");
	system("route add -net 127.0.0.0 netmask 255.0.0.0 lo");
    
    	#ifdef FOR_DEBUG
    		//system("ifconfig");
    	#endif
    	
    	// 23. ---
    	system("monitor 2&");
    	
    	// 24. ---
    	system("amit_syslogd");
    	
    	// 25. ---
    	system("amit_ftpd &");
	
	// 26. ---
	//system("inetd &");	//moved to rc
	
	// 27. ---
	setrouted(1);	//to be last one, 
			
	// 99. --- reset global variables
	during_booting = 0;
	cold_start = 0;
	
	// 100. --- test area
	#ifdef FOR_DEBUG
		printf("-------------------------------------------------------------------------------\r\n");
		printf("Test area in setboot\r\n");
	#endif
	
	//Test#1: del_routes_with_not_if()
	//system("route add -net 192.168.99.0 netmask 255.255.255.0 gw 192.168.123.250 metric 1");
	//system("route");
	//del_routes_with_not_if();
	//system("route");
	
	return 0;
}


int set_wanget_result(int act)
{
	FILE *fd;
	
	#ifdef FOR_DEBUG
		printf("Set wanget.result %d\r\n",act);
	#endif
	
	switch (act) {
		
		case 77:	//init
		case 0:		//get no
			if ((fd = fopen("/var/run/wanget.result","w")) != NULL)
			{
				fputs("0",fd);
				fclose(fd);
			} else {
				printf("WANget result(%d): Open write file:/var/run/wanget.result fail!\n",act);
			}
			break;
			
		case 1:		//get yes
			if ((fd = fopen("/var/run/wanget.result","w")) != NULL)
			{
				fputs("1",fd);
				fclose(fd);
			} else {
				printf("WANget result(%d): Open write file:/var/run/wanget.result fail!\n",act);
			}
			break;
			
		case 99:	//get yes
			if ((fd = fopen("/var/run/wanget.result","w")) != NULL)
			{
				fputs("99",fd);
				fclose(fd);
			} else {
				printf("WANget result(%d): Open write file:/var/run/wanget.result fail!\n",act);
			}
			break;
			
	} //end switch
	
}





void restart_dhcpcd(void)
{
	FILE *fd;
	int child_id;
	unsigned char temp[180];
	unsigned char pid[10];
	
	if((fd = fopen("/var/run/dhcpcd-eth1.pid","r")) != NULL) {
	  	fgets(pid,10,fd);
          	sprintf(temp,"kill %s",pid);
          	system(temp);
          	fclose(fd);
          	#ifdef FOR_DEBUG
	    		printf("Kill older dhcpcd daemon\r\n");
	  	#endif
        }
	
	if (ACONF->local.host[0] > ' ') {
		sprintf(temp,"dhcpcd -h %s eth1 &",ACONF->local.host);
        } else {
		sprintf(temp,"dhcpcd eth1 &");
	}
	system(temp);	//modified by Lily
	#ifdef FOR_DEBUG
		printf("Run dhcpcd eth1 background: %s\r\n",temp);
	#endif
	
}	






void del_routes_with_not_if(void)
{
	
	FILE *fp;
	unsigned char buf[180], *cp, *cp_des, *cp_nm, *cp_gw;
	unsigned long ul, ul_des, ul_gw, ul_nm, LAN_net, WAN_net;
	
	#ifdef FOR_DEBUG
		printf("setrouted: Del routes: get WAN and LAN nets\r\n");
	#endif
	WAN_net = getmyWANip() & getmyWANmask();
	LAN_net = getmyLANip() & getmyLANmask();
	
	#ifdef FOR_DEBUG
		printf("setrouted: Del routes: WAN net: %lx,  LAN net: %lx\r\n", WAN_net, LAN_net);
	#endif
	
	fp = fopen("/proc/net/route", "r");
	if(fp == NULL)
	{
		Nprintf("Del route: /proc/net/route open error!\n");
	}
	else
	{
		fgets(buf, 180, fp);	// read over the title
		
		while(fgets(buf, 180, fp)!=NULL)
		{
			cp = strtok(buf, " \t\n");	//iface
			cp = strtok(NULL, " \t\n");	//destination
			sscanf(cp, "%lx", &ul_des);
			cp = strtok(NULL, " \t\n");	//Gateway
			sscanf(cp, "%lx", &ul_gw);
			cp = strtok(NULL, " \t\n");	//Flags
			cp = strtok(NULL, " \t\n");	//RefCnt
			cp = strtok(NULL, " \t\n");	//Use
			cp = strtok(NULL, " \t\n");	//Metric
			cp = strtok(NULL, " \t\n");	//Mask
			sscanf(cp, "%lx", &ul_nm);
			ul = ul_des & ul_nm;
			
			#ifdef FOR_DEBUG
				printf("Del routes: find a route: %lx\r\n",ul);
			#endif
			
			if ((ul != LAN_net) && (ul != WAN_net) && (ul != 0x7F000000) && (ul != 0)) {
				cp_des = (char *)(&ul_des); cp_nm = (char *)(&ul_nm); cp_gw = (char *)(&ul_gw);
				sprintf(buf,"route del -net %d.%d.%d.%d netmask %d.%d.%d.%d gw %d.%d.%d.%d",
  					*(cp_des),*(cp_des+1),*(cp_des+2),*(cp_des+3),
  					*(cp_nm),*(cp_nm+1),*(cp_nm+2),*(cp_nm+3),
  					*(cp_gw),*(cp_gw+1),*(cp_gw+2),*(cp_gw+3));
  				system(buf);
  				#ifdef FOR_DEBUG
  					printf("Del routes:%s\r\n",buf);
  				#endif
  			}
		}
		fclose(fp);
	}
	
}






void getWANstr(char *result)
{
	if(ACONF->local.wtype!=2) strcpy(result,"eth1"); else strcpy(result,"ppp0");
}

//@@@InsertBegin by KM 2002/10/16
void getOldWANstr(char *result)
{
	if(oldACONF->local.wtype!=2) strcpy(result,"eth1"); else strcpy(result,"ppp0");
}
//@@@InsertEnd by KM 2002/10/16


int setdomainf(int act)
{
	FILE *fp;
	int i;
	char command[110];
	unsigned char check1, check2, check3, check4;

	// 1. --- Entrance
	#ifdef FOR_DEBUG
		printf("-------------------------------------------------------------------------------\r\n");
		printf("Enter setdomainf (%d)\r\n",act);
	#endif
	
	// 2. --- Close standard error output
	//close(2);	//marked by Lily 20020926
	
	// 3. --- Check if domain filtering is eanbled
	check1 = ((act) && (ACONF->dctl.flag & 1));
	
	#ifdef FOR_DEBUG
		if (check1 != 0)
			printf("setdomainf: total check: Domain filter is enabled\r\n");
		else
			printf("setdomainf: total check: Domain filter is not enabled\r\n");
	#endif
	
	// 4. --- Kill used chain in domain filtering
	if (during_booting == 0) {
		
		system("iptables -t mangle -F mangle_domainf"); //kill rules in mangle_domainf chain
		system("iptables -t mangle -X mangle_domainf"); //kill mangle_domainf chain in mangle table
		
		system("iptables -t filter -F filter_domainf"); //kill rules in filter_domainf chain
		system("iptables -t filter -X filter_domainf"); //kill filter_domainf chain in filter table
		
		#ifdef FOR_DEBUG
			printf("setdomainf: Kill mangle_domainf and filter_domainf chains\r\n");
		#endif
		
		if (check1 == 0) {
			system("iptables -t mangle -D PREROUTING -i eth0 -p UDP --dport 53 -j mangle_domainf");
			system("iptables -D FORWARD -i eth0 -p udp --dport 53 -j filter_domainf");
			#ifdef FOR_DEBUG
				printf("setdomainf: Remove links to mangle_domainf and filter_domainf chains\r\n");
			#endif
		}
	}
	
	if (check1 == 0) {
		
		// 5. --- Remove the rule file used in domain filtering
		if (cold_start == 0) {	
			remove(DOMAIN_FILTER_RULE_FILE);
			#ifdef FOR_DEBUG
				printf("setdomainf: Remove the rule file for domain filter\r\n");
			#endif
		}
		
		// 6. --- Return when domain filtering is disabled
		system("monitor 91 77 0");
		system("monitor 91 67 0");
		system("monitor 1 58 0");
		
		#ifdef FOR_DEBUG
			printf("setdomainf:\r\n");
			system("cat /var/config/monitor");
		#endif
		return 0;
	}
		
	// 7. --- Create a new chain mangle_domainf in mangle table	
	system("iptables -t mangle -N mangle_domainf");
	system("iptables -t mangle -A mangle_domainf -j RETURN");
	system("iptables -t mangle -I PREROUTING -i eth0 -p UDP --dport 53 -j mangle_domainf");
	
	// 8. --- Create a new chain filter_domainf in filter table
	system("iptables -t filter -N filter_domainf");
	system("iptables -t filter -A filter_domainf -j RETURN");
	system("iptables -I FORWARD -i eth0 -p UDP --dport 53 -j filter_domainf");
	
	#ifdef FOR_DEBUG
		printf("setdomainf: Privilege rule: %d.%d.%d.%d/%d\r\n",
			ACONF->local.ip[0], ACONF->local.ip[1], ACONF->local.ip[2], 
			ACONF->dctl.privilege[0], ACONF->dctl.privilege[1]);
	#endif
	
	// 9. --- Set up 2 rules in mangle_domainf chain
	check1 = (ACONF->local.wflag & LFLAG_DMZ);
	if (check1) {
		sprintf(command, 
			"iptables -t mangle -I mangle_domainf -s ! %d.%d.%d.%d -j MARK --set-mark 7",
			ACONF->local.ip[0], ACONF->local.ip[1],
			ACONF->local.ip[2], ACONF->local.dmz_host);
	} else {
		sprintf(command, 
			"iptables -t mangle -I mangle_domainf -j MARK --set-mark 7");
	}
	system(command);
	
	//if ( ((ACONF->dctl.privilege[0] | ACONF->dctl.privilege[1]) != 0) &&
	//     (ACONF->dctl.privilege[0] <= ACONF->dctl.privilege[1])		)
	if ((ACONF->dctl.privilege[0] | ACONF->dctl.privilege[1]) != 0)
	{
		if ((ACONF->dctl.privilege[1] == 0) || (ACONF->dctl.privilege[1] > 32))
			ACONF->dctl.privilege[1] = 32;
		sprintf(command, 
			"iptables -t mangle -I mangle_domainf -s %d.%d.%d.%d/%d -j ACCEPT",
			ACONF->local.ip[0], ACONF->local.ip[1], ACONF->local.ip[2], 
			ACONF->dctl.privilege[0], ACONF->dctl.privilege[1]);
		#ifdef FOR_DEBUG
			printf("setdomainf: Privilege rule in mangle_domainf chain\r\n");
		#endif
	} else command[0] = 0;
	if (command[0] != 0) system(command);
		
	// 10. --- Set up 2 rules in filter_domainf chain	
	if (check1) {
		sprintf(command, 
			"iptables -I filter_domainf -s ! %d.%d.%d.%d -j QUEUE",
			ACONF->local.ip[0], ACONF->local.ip[1],
			ACONF->local.ip[2], ACONF->local.dmz_host);
	} else {
		sprintf(command, 
			"iptables -I filter_domainf -j QUEUE");
	}
	system(command);
		
	if ( ((ACONF->dctl.privilege[0] | ACONF->dctl.privilege[1]) != 0) &&
	     (ACONF->dctl.privilege[0] <= ACONF->dctl.privilege[1])		)
	{
		sprintf(command, 
			"iptables -I filter_domainf -s %d.%d.%d.%d/%d -j ACCEPT",
			ACONF->local.ip[0], ACONF->local.ip[1], ACONF->local.ip[2], 
			ACONF->dctl.privilege[0], ACONF->dctl.privilege[1]);
		#ifdef FOR_DEBUG
			printf("setdomainf: Privilege rule in filter_domainf chain\r\n");
		#endif
	} else command[0] = 0;
	if (command[0] != 0) system(command);
		
	#ifdef FOR_DEBUG
		printf("setdomainf: Set cmmands in mangle_domainf and filter_domainf chains\r\n");
	#endif
	
	// 11. --- Create a new file storing rules used in domain filtering
	#ifdef FOR_DEBUG
		printf("setdomainf: Create the rule file for domain filter\r\n");
	#endif
	fp = fopen(DOMAIN_FILTER_RULE_FILE, "w");
	if (fp == NULL) {
		#ifdef FOR_DEBUG
			printf("setdomainf: Create the rule file for domain filter fail\r\n");
		#endif
		return -1;
	}
	
	// 12. --- Set drop and log rules --- for each UI configure rule
	check4 = (ACONF->dctl.flag & 0x10);
	#ifdef FOR_DEBUG
		printf("setdomainf: Global setting of logging = %d\r\n",(int)check4);
	#endif
	for(i = 0; i<DCTL_SUFFIX_SZ; i++)
	{
		check1 = (ACONF->dctl.rules[i].flag & 1);
		check2 = (ACONF->dctl.rules[i].flag & 2);
		check3 = (ACONF->dctl.rules[i].flag & 4);
	
		if ((check1) && (ACONF->dctl.rules[i].suffix[0] > ' '))
		{
			fprintf(fp, "%d %d %s\n", 
				(int)check2,			//drop or not
				(int)(check3&&check4),		//log or not
				ACONF->dctl.rules[i].suffix);	//domain
		}
	}
		
	// 13. --- Set drop and log rule --- for all others UI configure rule
	check1 = ACONF->dctl.flag & 2;
	check2 = ACONF->dctl.flag & 4;
	fprintf(fp, "%d %d ALLOTHERS\n",(int)check1,(int)(check2&&check4));
		
	fclose(fp); 
	usleep(SLEEP_TIME);
	#ifdef FOR_DEBUG
		printf("setdomainf: Set drop and log rules in file\r\n");
	#endif

	// 14. startup ipqueue
	#ifdef FOR_DEBUG
		printf("setdomainf: Probe ip_queue module and ipqueue daemon\r\n");
	#endif
	system("monitor 91 77 1");
	system("monitor 91 67 1");
	system("monitor 1 58 1");

	// 15. return successfully
	return 0;
	
}





/* ************* */
/* Set mnat      */
/* 0     : ok    */
/* other : error */
/* ************* */

int setmnat(int act)
{

	char command[180];
	int i;
	int isEnable = 0;

	
	#ifdef FOR_DEBUG
    		printf("-------------------------------------------------------------------------------\r\n");
    		printf("Enter setmnat %d (virtual computer) procedure\r\n",act);
    	#endif
	
	//close(2);	//marked by Lily 20020926
	
	if (during_booting == 0)
	{	
		system("iptables -t nat -D PREROUTING -j mnat");
		system("iptables -t nat -F mnat");
		system("iptables -t nat -X mnat");
		system("iptables -t nat -D POSTROUTING -o eth0 -j lmnat");
		system("iptables -t nat -F lmnat");
		system("iptables -t nat -X lmnat");
		
		for(i = 0; i < MNAT_NUM; i++)
		{
			sprintf(command, "ifconfig eth1:%d down", i+1);
			system(command);
		}		
	}

	if (act)	// starting enabled server mapping
	{	
		if(ACONF->local.wtype == 2) //wantype not pppoe
			return 0;
			
		for(i = 0; i < MNAT_NUM; i++)
		{
			if(ACONF->local3.mnat[i].flag == 1) {isEnable = 1; break;}
		}
		if(isEnable)
		{
			system("iptables -t nat -N mnat");
			system("iptables -t nat -A mnat -j RETURN");
			system("iptables -t nat -I PREROUTING -j mnat");
			
			system("iptables -t nat -N lmnat");
			system("iptables -t nat -A lmnat -j RETURN");
			system("iptables -t nat -I POSTROUTING -o eth0 -j lmnat");
		}
		else 
			return 0;
		
		for(i = 0; i < MNAT_NUM; i++)
			if(ACONF->local3.mnat[i].flag == 1)
			{
				sprintf(command, "ifconfig eth1:%d %d.%d.%d.%d", i+1,
					ACONF->local3.mnat[i].gip[0],
					ACONF->local3.mnat[i].gip[1],
					ACONF->local3.mnat[i].gip[2],
					ACONF->local3.mnat[i].gip[3]);
				system(command);
				
				sprintf(command, "iptables -t nat -I lmnat -s %d.%d.%d.%d/24 -d %d.%d.%d.%d -j SNAT --to %d.%d.%d.%d",
					ACONF->local.ip[0],
					ACONF->local.ip[1],
					ACONF->local.ip[2],
					ACONF->local.ip[3],
					ACONF->local.ip[0],
					ACONF->local.ip[1],
					ACONF->local.ip[2],
					ACONF->local3.mnat[i].lip,
					ACONF->local.ip[0],
					ACONF->local.ip[1],
					ACONF->local.ip[2],
					ACONF->local.ip[3]);
					
					
				system(command);	

				sprintf(command, "iptables -t nat -I mnat -d %d.%d.%d.%d -j DNAT --to %d.%d.%d.%d",
					ACONF->local3.mnat[i].gip[0],
					ACONF->local3.mnat[i].gip[1],
					ACONF->local3.mnat[i].gip[2],
					ACONF->local3.mnat[i].gip[3],
					ACONF->local.ip[0],
					ACONF->local.ip[1],
					ACONF->local.ip[2],
					ACONF->local3.mnat[i].lip);
				system(command);
				
				#ifdef FOR_DEBUG
					printf("setmnat: (%d)%s\n", i, command);
				#endif
				
			}
	}

	return 0;
}





int setwanmac(void)
{
  char command[128];
  unsigned char *ethaddr1;
  unsigned int tmp[2];
  
  tmp[0] = *((unsigned int *)0xbfc06010);
  tmp[1] = *((unsigned int *)0xbfc06014);  
  ethaddr1 = (unsigned char *)(&(tmp[0]));

  //close(2);	//marked by Lily 20020926

  system("ifconfig eth1 down");  
  
  if((ACONF->local.uwid[0] != 0xff) || (ACONF->local.uwid[1] != 0xff) ||
     (ACONF->local.uwid[2] != 0xff) || (ACONF->local.uwid[3] != 0xff) ||
     (ACONF->local.uwid[4] != 0xff) || (ACONF->local.uwid[5] != 0xff)   )
  {
	sprintf(command, "ifconfig eth1 hw ether %02x:%02x:%02x:%02x:%02x:%02x", 
       		ACONF->local.uwid[0], ACONF->local.uwid[1],
		ACONF->local.uwid[2], ACONF->local.uwid[3],
		ACONF->local.uwid[4], ACONF->local.uwid[5]);
  	system(command);


        #ifdef FOR_DEBUG
          printf("setwanmac: %s\r\n", command);
        #endif
  	
  	return 0;	
  }

  if((ethaddr1[0] != 0xff) || (ethaddr1[1] != 0xff) ||
     (ethaddr1[2] != 0xff) || (ethaddr1[3] != 0xff) ||
     (ethaddr1[4] != 0xff) || (ethaddr1[5] != 0xff)  )
  {
	sprintf(command, "ifconfig eth1 hw ether %02x:%02x:%02x:%02x:%02x:%02x", 
       		ethaddr1[0], ethaddr1[1],
		ethaddr1[2], ethaddr1[3],
		ethaddr1[4], ethaddr1[5]);
  	system(command);
  	
        #ifdef FOR_DEBUG
          printf("setwanmac: %s\r\n", command);
        #endif
  			
  	return 0;
  }
  else
  {
	sprintf(command, "ifconfig eth1 hw ether 00:50:18:00:00:%02x", 
		ACONF->local.ip[3]);
  	system(command);
  	
        #ifdef FOR_DEBUG
          printf("%s\n", command);
        #endif
  
        return 0;  
  }  
}



int setlanmac(void)
{
  char command[128];
  
  //close(2);	//marked by Lily 20020926

  system("ifconfig eth0 down");
  
  sprintf(command, "ifconfig eth0 hw ether 00:50:18:00:0f:%02x", 
  	 (ACONF->local.ip[3])+1);
  system(command);
  #ifdef FOR_DEBUG
    printf("---------------------------------------------------------------\n");
    printf("Enter setlanmac : %s\r\n", command);
  #endif

}




int setremoteadmin(void)
{
  char command[132];
  int *ip;
  int temp_i;
  
  // 1. --- Function indication message
  #ifdef FOR_DEBUG
  	printf("-------------------------------------------------------------------------------\r\n");
  	printf("Enter setremoteadmin procedure\r\n");
  #endif
  	
  // 2. --- Function initialization
  //close(2);	//marked by Lily 20020926
  	
  // 3. --- Disable this function first
  if (during_booting == 0)
  {	
	system("iptables -t nat -D PREROUTING -j remote_admin");
	system("iptables -t nat -F remote_admin");	//clean chain
	system("iptables -t nat -X remote_admin");	//kill chain
  }
  
  // 4. --- Exit condition checking
  if ((ACONF->local.wflag & LFLAG_RADM) == 0) return 0;
  
  // 5. --- Enable this function
  system("iptables -t nat -N remote_admin");
  system("iptables -t nat -A remote_admin -j RETURN");
  system("iptables -t nat -I PREROUTING -j remote_admin");
  ip = &(ACONF->local.rhip[0]);
  if (*ip == 0)
  {
  	sprintf(command,"iptables -t nat -I remote_admin -p tcp -s 0.0.0.0/0 --dport %d -j DNAT --to %d.%d.%d.%d:80",
  	ACONF->local3.raport,
  	ACONF->local.ip[0],ACONF->local.ip[1],ACONF->local.ip[2],ACONF->local.ip[3]);
  }
  else 
  {
  	temp_i = ACONF->local.rhnm[3]; if (temp_i > 32) temp_i = 32;
  	sprintf(command,"iptables -t nat -I remote_admin -p tcp -s %d.%d.%d.%d/%d --dport %d -j DNAT --to %d.%d.%d.%d:80",
  	ACONF->local.rhip[0],ACONF->local.rhip[1],ACONF->local.rhip[2],ACONF->local.rhip[3],
  	temp_i,ACONF->local3.raport,
  	ACONF->local.ip[0],ACONF->local.ip[1],ACONF->local.ip[2],ACONF->local.ip[3]);
  }
  system(command);
  #ifdef FOR_DEBUG
  	printf("setremoteadmin: enable: %s\r\n",command);
  #endif
  
  // 6. --- Return from this function
  return 0;
  
}






void set_default_DNS(void)
{
	unsigned char check1, check2;
	FILE *fd_dns;
	
        fd_dns = fopen(DNS_INFO_FILE,"w");
        fprintf(fd_dns,"domain\n");
	//fprintf(fd_dns,"nameserver %d.%d.%d.%d\n",
        //	ACONF->local.ip[0],ACONF->local.ip[1],
        //	ACONF->local.ip[2],ACONF->local.ip[3]);
        fprintf(fd_dns,"nameserver 168.95.1.1\n");
	fprintf(fd_dns,"search\n");
	fclose(fd_dns);        		
	
}


//@@@AddBegin by KM 2002/10/07
/* ********************** */
/* distinguish some types */
/* if old==new return 0   */
/* else return 1          */
/* ********************** */
int dis(int type)
{
	int return_value=1;
	switch (type)
	{
		case WAN_dis:
			if(oldACONF->local.wip[0]==ACONF->local.wip[0] && 
			   oldACONF->local.wip[1]==ACONF->local.wip[1] &&
			   oldACONF->local.wip[2]==ACONF->local.wip[2] &&
			   oldACONF->local.wip[3]==ACONF->local.wip[3] &&
			   oldACONF->local.wnm[0]==ACONF->local.wnm[0] &&
			   oldACONF->local.wnm[1]==ACONF->local.wnm[1] &&
			   oldACONF->local.wnm[2]==ACONF->local.wnm[2] &&
			   oldACONF->local.wnm[3]==ACONF->local.wnm[3] )
			   	return_value=0;
			break;
//		case LAN_dis:
//			if(oldACONF->local.ip[0]==ACONF->local.ip[0] && 
//			   oldACONF->local.ip[1]==ACONF->local.ip[1] && 
//			   oldACONF->local.ip[2]==ACONF->local.ip[2] && 
//			   oldACONF->local.ip[3]==ACONF->local.ip[3] )
//			   	return_value=0;
//			break;
		case DMZ_dis:
			if(oldACONF->local.ip[0]==ACONF->local.ip[0] && 
			   oldACONF->local.ip[1]==ACONF->local.ip[1] && 
			   oldACONF->local.ip[2]==ACONF->local.ip[2] && 
			   oldACONF->local.dmz_host==ACONF->local.dmz_host )
			   	return_value=0;
			break;
		case DNS_dis:
			if(oldACONF->ids.dns_scan.wan_dns[0]==ACONF->ids.dns_scan.wan_dns[0] &&
			   oldACONF->ids.dns_scan.wan_dns[1]==ACONF->ids.dns_scan.wan_dns[1] &&
			   oldACONF->ids.dns_scan.wan_dns[2]==oldACONF->ids.dns_scan.wan_dns[2] &&
			   oldACONF->ids.dns_scan.wan_dns[3]==ACONF->ids.dns_scan.wan_dns[3] &&
			   oldACONF->local.ip[0]==ACONF->local.ip[0] &&
			   oldACONF->local.ip[1]==ACONF->local.ip[1] &&
			   oldACONF->local.ip[2]==oldACONF->local.ip[2] &&
			   oldACONF->ids.dns_scan.lan_dns==oldACONF->ids.dns_scan.lan_dns)
			   	return_value=0;
			break;
		case PROXY_dis:
			if(oldACONF->ids.urlblock.proxy==ACONF->ids.urlblock.proxy)
				return_value=0;
			break;
		case WANstr_dis:
			if(oldACONF->local.wtype==ACONF->local.wtype)
				return_value=0;
			break;
		case LANnet_dis:
			if(oldACONF->local.ip[0]==ACONF->local.ip[0] && 
			   oldACONF->local.ip[1]==ACONF->local.ip[1] && 
			   oldACONF->local.ip[2]==ACONF->local.ip[2] )
			   	return_value=0;
			break;
		case PROXYmscript_dis:
			if(oldACONF->local.ip[0]==ACONF->local.ip[0] &&
			   oldACONF->local.ip[1]==ACONF->local.ip[1] &&
			   oldACONF->local.ip[2]==ACONF->local.ip[2] &&
			   oldACONF->local.dmz_host==ACONF->local.dmz_host &&
			   oldACONF->ids.mscript_proxy==ACONF->ids.mscript_proxy )
			   	return_value=0;
			break;
		default:
				return_value=1;
			break;
		
	}
	return return_value;
}
//@@@AddEnd by KM 2002/10/07

