/* *************************************** */
/* Name : rc2.c                            */
/* Programmer : Su Chien-Chung             */
/* Date : 2002/4/28                        */
/* Version : v1.0                          */
/* Function : set environment after reboot */
/* *************************************** */

#include<stdio.h>
#include<stdlib.h>
#include<netinet/in.h>

#include "usercfg.h"

#define OFFSET 4259856

#define SLEEP_TIME 300
//---new actrl
#define CONF_PATH	"/proc/access_ctrl_setting"
#define GROUP_NUM	4
#define BOUND		16
//---End new actrl

//---IPSec Manual
#define DEBUG_IPSEC_MANUAL

//---SAVE IP info
#define IP_INFO_FILE "/var/config/host.arg"
//---static DNS file
#define DNS_INFO_FILE "/var/config/dns.conf"

//---ids
#define PINGF_NUM	"103"
#define SMURF_NUM	"104"
#define PSD_NUM		"201"
#define FRAGGLE_NUM	"202"
#define SNORK_NUM	"203"
#define LAND_NUM	"204"
#define DNS_SCAN_NUM	"206"
//---End ids
//---virus parser
#define MAX 80
#define VIRUS_PATH "/var/config/ipq/virus/"
//---End virus parser
#define MBOMB_PATH "/var/config/ipq/mbomb1.conf"
#define MBOMB2_PATH "/var/config/ipq/mbomb2.conf"
//----Alert Mail
#define MAIL_LIST_FILE "/var/config/mail_list.conf"
#define ALERT_TABLE_FILE "/var/config/alert_table"



int ipinfo(char *, ip_info_struct *);
int findGW(ip_info_struct *);//find Getway
/*-----save IP info-----*/
int saveIPinfo(ACONFIG *a)
{
	FILE *fd;
	int i;
	ip_info_struct ife;
	if(a->local.wtype!=2)//check wan type
		ipinfo("eth1", &ife);
	else
		ipinfo("ppp0", &ife);
	//printf("ipinfo ok\n");
	//find wan gateway
	findGW(&ife);
	for(i = 0; i < 5; i++)//check if file can open
	{
		fd=fopen(IP_INFO_FILE,"w");
		if(fd == NULL)
		{
			sleep(1);
			continue;
		}
		else
			break;
	}
	if(fd == NULL)
	{
		printf("saveIPinfo: cannot open file %s.\n", IP_INFO_FILE);
		return 1;
	}
	else
		printf("open file ok\n");// IMPORTANT!!!   delete this will cause error!!!
	fprintf(fd,"%d.%d.%d.%d\n",ife.ip[0],ife.ip[1],ife.ip[2],ife.ip[3]);//save ip
	fprintf(fd,"%d.%d.%d.%d\n",ife.mask[0],ife.mask[1],ife.mask[2],ife.mask[3]);//save wan mask
	fprintf(fd,"%d.%d.%d.%d\n",ife.gw[0],ife.gw[1],ife.gw[2],ife.gw[3]);//save wan gateway
	fclose(fd);
	printf("save ip ok\n");

	for(i = 0; i < 5; i++)
	{
		fd=fopen(DNS_INFO_FILE,"w");
		if(fd == NULL)
			continue;
		else
			break;
	}
	if(fd == NULL)
	{
		printf("saveIPinfo: cannot open file %s.\n", DNS_INFO_FILE);
		return 1;
	}
	else
		printf("");// IMPORTANT!!!   delete this will cause error!!!
	fprintf(fd,"nameserver %d.%d.%d.%d\n",a->local.rhnm[0],a->local.rhnm[1],a->local.rhnm[2],a->local.rhnm[3]);
	fclose(fd);
	return 0;
}
/*-----End save IP info-----*/

/* ************* */
/* Set LAN       */
/* 0     : ok    */
/* other : error */
/* ************* */
int setlan(int act)
{
  unsigned char temp[60];
  unsigned char AND1, AND2, AND3, AND4;

  ACONFIG * ACONF;
  ACONF = (ACONFIG *)OFFSET;
  close(2);

  if(act == 0)
    system("ifconfig eth0 down");
  else {
    sprintf(temp,"ifconfig eth0 %d.%d.%d.%d netmask %d.%d.%d.%d up",ACONF->local.rhip[0],ACONF->local.rhip[1],
         			  				    ACONF->local.rhip[2],ACONF->local.rhip[3],
                                                                    ACONF->local.uwid[0],ACONF->local.uwid[1],
                                                                    ACONF->local.uwid[2],ACONF->local.uwid[3]);
    system(temp);
  }
  usleep(SLEEP_TIME);
}

/* ************* */
/* Set NAT       */
/* 0     : ok    */
/* other : error */
/* ************* */
int setnat(int act)
{
  unsigned char temp[100];

  ACONFIG * ACONF;
  ACONF = (ACONFIG *)OFFSET;
  close(2);

	if(act == 0)	// disable
	{
		if(ACONF->local.wtype == 2)	// pppoe
		{
			sprintf(temp, "iptables -t nat -D POSTROUTING -o ppp0 -s %d.%d.%d.%d/%d.%d.%d.%d -j MASQUERADE",
				ACONF->local.rhip[0], ACONF->local.rhip[1],
				ACONF->local.rhip[2], ACONF->local.rhip[3],
				ACONF->local.uwid[0], ACONF->local.uwid[1],
				ACONF->local.uwid[2], ACONF->local.uwid[3]);
		}
		else
		{
			sprintf(temp,"iptables -t nat -D POSTROUTING -o eth1 -s %d.%d.%d.%d/%d.%d.%d.%d -j MASQUERADE",
				ACONF->local.rhip[0],ACONF->local.rhip[1],
				ACONF->local.rhip[2],ACONF->local.rhip[3],
				ACONF->local.uwid[0],ACONF->local.uwid[1],
				ACONF->local.uwid[2],ACONF->local.uwid[3]);
		}
	}
	else		// enable
	{
		if(ACONF->local.wtype == 2)
		{
			sprintf(temp, "iptables -t nat -A POSTROUTING -o ppp0 -s %d.%d.%d.%d/%d.%d.%d.%d -j MASQUERADE",
				ACONF->local.rhip[0], ACONF->local.rhip[1],
				ACONF->local.rhip[2], ACONF->local.rhip[3],
				ACONF->local.uwid[0], ACONF->local.uwid[1],
				ACONF->local.uwid[2], ACONF->local.uwid[3]);
		}
		else
		{
			sprintf(temp,"iptables -t nat -A POSTROUTING -o eth1 -s %d.%d.%d.%d/%d.%d.%d.%d -j MASQUERADE",
				ACONF->local.rhip[0],ACONF->local.rhip[1],
				ACONF->local.rhip[2],ACONF->local.rhip[3],
				ACONF->local.uwid[0],ACONF->local.uwid[1],
				ACONF->local.uwid[2],ACONF->local.uwid[3]);
		}
	}

	system(temp);
	usleep(SLEEP_TIME);
}

/* ************* */
/* Set WAN       */
/* 0     : ok    */
/* other : error */
/* ************* */
int setwan(int act)
{
  unsigned char temp[120];
  unsigned char AND1, AND2, AND3, AND4;

  FILE *fd, *fd2;
  unsigned char pid[10];
  int i;

  ACONFIG * ACONF;
  ACONF = (ACONFIG *)OFFSET;
  close(2);

  //set if_wan down
  if(act == 0) {
    switch(ACONF->local.wtype)
    {
      case 0:  //Static IP
        //set if_wan down
	system("ifconfig eth1 down");
        //set default gw down
        sprintf(temp,"route del default gw %d.%d.%d.%d",ACONF->local.wgw[0],ACONF->local.wgw[1],
                                                        ACONF->local.wgw[2],ACONF->local.wgw[3]);
        system(temp);
        usleep(SLEEP_TIME);
        break;

      case 1:  //dynamic IP
        //fprintf(stderr,"We don't support this WAN type now!!\n");
	if((fd = fopen("/var/run/dhcpcd-eth1.pid","r")) != NULL) {
          fgets(pid,10,fd);
          sprintf(temp,"kill %s",pid);
          system(temp);
          fclose(fd);
        }
        break;

	/*
      case 2: //PPPoE
        system("adsl-stop");
	system("ifconfig eth1 down");
        sprintf(temp,"route del default gw %d.%d.%d.%d",ACONF->local.wgw[0],ACONF->local.wgw[1],
                                                        ACONF->local.wgw[2],ACONF->local.wgw[3]);
        system(temp);
	if((fd = fopen("/var/config/ppp/pppoe.conf", "w")) != NULL)
	{
		fclose(fd);
	}
	if((fd = fopen("/var/config/pap-secrets", "r+")) != NULL)
	{
		for(i = 0; i < 4; i++)
			fgets(temp, 120, fd);
		fprintf(fd, "%c", EOF);
		fclose(fd);
	}
	if((fd = fopen("/var/config/chap-secrets", "r+")) != NULL)
	{
		for(i = 0; i < 4; i++)
			fgets(temp, 120, fd);
		fprintf(fd, "%c", EOF);
		fclose(fd);
	}
        break;
	*/
	case 2: //PPPoE
		// 1. Qadsl-stoppppoe
		system("adsl-stop");
		// 2. eth1
		system("ifconfig eth1 down");
		// 3. pppoeconfig
		remove("/var/config/ppp/pppoe.conf");
		// 4. /var/config/ip.conf
		if(ACONF->pppoe.dns1[0] != 0 ||
			ACONF->pppoe.dns1[1] != 0 ||
			ACONF->pppoe.dns1[2] != 0 ||
			ACONF->pppoe.dns1[3] != 0 ||
			ACONF->pppoe.dns2[0] != 0 ||
			ACONF->pppoe.dns2[1] != 0 ||
			ACONF->pppoe.dns2[2] != 0 ||
			ACONF->pppoe.dns2[3] != 0)
		{
			remove("/var/config/ip.conf");
			fd = fopen("/var/config/ip.conf", "w");
			fclose(fd);
		}
		// 5. קpap-secrets
		if((fd = fopen("/var/config/pap-secrets", "r")) != NULL)
		{
			if((fd2 = fopen("/var/config/pap-secrets.tmp", "w")) != NULL)
			{
				for(i = 0; i < 4; i++)
				{
					fgets(temp, 120, fd);
					fputs(temp, fd2);
				}
				fclose(fd);
				fclose(fd2);
			}
			remove("/var/config/pap-secrets");
			rename("/var/config/pap-secrets.tmp", "/var/config/pap-secrets");
		}
		// 6. קchap-secrets
		if((fd = fopen("/var/config/chap-secrets", "r+")) != NULL)
		{
			if((fd2 = fopen("/var/config/chap-secrets.tmp", "w")) != NULL)
			{
				for(i = 0; i < 4; i++)
				{
					fgets(temp, 120, fd);
					fputs(temp, fd2);
				}
				fclose(fd);
				fclose(fd2);
			}
			remove("/var/config/chap-secrets");
			rename("/var/config/chap-secrets.tmp", "/var/config/chap-secrets");
		}
        	break;
    }
  } else if(act == 1){
    switch(ACONF->local.wtype)
    {
      case 0:  //Static IP
        //set if_wan up
        sprintf(temp,"ifconfig eth1 %d.%d.%d.%d netmask %d.%d.%d.%d up",ACONF->local.wip[0],ACONF->local.wip[1],
                                                                        ACONF->local.wip[2],ACONF->local.wip[3],
                                                                        ACONF->local.wnm[0],ACONF->local.wnm[1],
                                                                        ACONF->local.wnm[2],ACONF->local.wnm[3]);
        system(temp);
        usleep(SLEEP_TIME);
        //set default gw
        sprintf(temp,"route add default gw %d.%d.%d.%d",ACONF->local.wgw[0],ACONF->local.wgw[1],
                                                        ACONF->local.wgw[2],ACONF->local.wgw[3]);
        system(temp);
        usleep(SLEEP_TIME);
        break;

      case 1:  //dynamic IP
        //fprintf(stderr,"We don't support this WAN type now!!\n");
	system("ifconfig eth1 down;ifconfig eth1 up;dhcpcd eth1 &");
        break;

	/*
	case 2: //PPPoE
	system("ifconfig eth1 inet 0.0.0.0");
	if((fd = fopen("/var/config/ppp/pppoe.conf", "w")) != NULL)
	{
		fprintf(fd, "ETH=eth1\n");
		fprintf(fd, "USER=%s\n", ACONF->pppoe.id);
		fprintf(fd, "DEMAND=no\n");
		if(ACONF->pppoe.dns1[0] != 0 ||
			ACONF->pppoe.dns1[1] != 0 ||
			ACONF->pppoe.dns1[2] != 0 ||
			ACONF->pppoe.dns1[3] != 0 ||
			ACONF->pppoe.dns2[0] != 0 ||
			ACONF->pppoe.dns2[1] != 0 ||
			ACONF->pppoe.dns2[2] != 0 ||
			ACONF->pppoe.dns2[3] != 0)
		{
			fprintf(fd, "DNSTYPE=SPECIFY\n");
			fprintf(fd, "USEPEERDNS=no\n");
			fprintf(fd, "DNS1=%d.%d.%d.%d\n", ACONF->pppoe.dns1[0], ACONF->pppoe.dns1[1], ACONF->pppoe.dns1[2], ACONF->pppoe.dns1[3]);
			fprintf(fd, "DNS2=%d.%d.%d.%d\n", ACONF->pppoe.dns2[0], ACONF->pppoe.dns2[1], ACONF->pppoe.dns2[2], ACONF->pppoe.dns2[3]);

			fd2 = fopen("/var/config/dns.conf", "w");
			fprintf(fd2, "nameserver %d.%d.%d.%d\n", ACONF->pppoe.dns1[0], ACONF->pppoe.dns1[1], ACONF->pppoe.dns1[2], ACONF->pppoe.dns1[3]);
			fprintf(fd2, "nameserver %d.%d.%d.%d\n", ACONF->pppoe.dns2[0], ACONF->pppoe.dns2[1], ACONF->pppoe.dns2[2], ACONF->pppoe.dns2[3]);
			fclose(fd2);
		}
		else
		{
			fprintf(fd, "USEPEERDNS=yes\n");
		}
		fprintf(fd, "CONNECT_TIMEOUT=60\n");
		fprintf(fd, "CONNECT_POLL=6\n");
		fprintf(fd, "PING=\".\"\n");
		fprintf(fd, "PIDFILE=/var/run/pppoe.pid\n");
		fprintf(fd, "SYNCHRONOUS=no\n");
		fprintf(fd, "CLAMPMSS=1412\n");
		fprintf(fd, "LCP_INTERVAL=20\n");
		fprintf(fd, "LCP_FAILURE=3\n");
		fprintf(fd, "PPPOE_TIMEOUT=%d\n", ACONF->pppoe.timeout);
		fprintf(fd, "FIREWALL=NONE\n");
		fprintf(fd, "PPPOE_EXTRA=\"\"\n");
		fprintf(fd, "PPPD_EXTRA=\"\"\n");
		fclose(fd);

		system("adsl-start");
	}
	fd2 = fopen("/var/config/pap-secrets", "a+");
	fprintf(fd2, "\"%s\"\t*\t\"%s\"", ACONF->pppoe.id, ACONF->pppoe.passwd);
	fclose(fd2);
	fd2 = fopen("/var/config/chap-secrets", "a+");
	fprintf(fd2, "\"%s\"\t*\t\"%s\"", ACONF->pppoe.id, ACONF->pppoe.passwd);
	fclose(fd2);
        break;
	*/
	case 2: //PPPoE
	system("ifconfig eth1 inet 0.0.0.0");
	if((fd = fopen("/var/config/ppp/pppoe.conf", "w")) != NULL)
	{
		fprintf(fd, "ETH=eth1\n");
		fprintf(fd, "USER=%s\n", ACONF->pppoe.id);
		fprintf(fd, "DEMAND=no\n");
		i = 0;
		if(ACONF->pppoe.dns1[0] != 0 ||
			ACONF->pppoe.dns1[1] != 0 ||
			ACONF->pppoe.dns1[2] != 0 ||
			ACONF->pppoe.dns1[3] != 0)
		{
			fprintf(fd, "DNSTYPE=SPECIFY\n");
			fprintf(fd, "USEPEERDNS=no\n");
			fprintf(fd, "DNS1=%d.%d.%d.%d\n", ACONF->pppoe.dns1[0], ACONF->pppoe.dns1[1], ACONF->pppoe.dns1[2], ACONF->pppoe.dns1[3]);
			fd2 = fopen("/var/config/ip.conf", "w");
			fprintf(fd2, "nameserver %d.%d.%d.%d\n", ACONF->pppoe.dns1[0], ACONF->pppoe.dns1[1], ACONF->pppoe.dns1[2], ACONF->pppoe.dns1[3]);
			fclose(fd2);
			i++;
		}
		if(ACONF->pppoe.dns2[0] != 0 ||
			ACONF->pppoe.dns2[1] != 0 ||
			ACONF->pppoe.dns2[2] != 0 ||
			ACONF->pppoe.dns2[3] != 0)
		{
			if(i == 0)
			{
				fprintf(fd, "DNSTYPE=SPECIFY\n");
				fprintf(fd, "USEPEERDNS=no\n");
				fprintf(fd, "DNS1=%d.%d.%d.%d\n", ACONF->pppoe.dns2[0], ACONF->pppoe.dns2[1], ACONF->pppoe.dns2[2], ACONF->pppoe.dns2[3]);
				fd2 = fopen("/var/config/ip.conf", "w");
				fprintf(fd2, "nameserver %d.%d.%d.%d\n", ACONF->pppoe.dns2[0], ACONF->pppoe.dns2[1], ACONF->pppoe.dns2[2], ACONF->pppoe.dns2[3]);
				fclose(fd2);
			}
			else
			{
				fprintf(fd, "DNS2=%d.%d.%d.%d\n", ACONF->pppoe.dns2[0], ACONF->pppoe.dns2[1], ACONF->pppoe.dns2[2], ACONF->pppoe.dns2[3]);
				fd2 = fopen("/var/config/ip.conf", "a+");
				fprintf(fd2, "nameserver %d.%d.%d.%d\n", ACONF->pppoe.dns2[0], ACONF->pppoe.dns2[1], ACONF->pppoe.dns2[2], ACONF->pppoe.dns2[3]);
				fclose(fd2);
			}
			i++;
		}
		if(!i)
		{
			fprintf(fd, "USEPEERDNS=yes\n");
		}
		fprintf(fd, "CONNECT_TIMEOUT=60\n");
		fprintf(fd, "CONNECT_POLL=6\n");
		fprintf(fd, "PING=\".\"\n");
		fprintf(fd, "PIDFILE=/var/run/pppoe.pid\n");
		fprintf(fd, "SYNCHRONOUS=no\n");
		fprintf(fd, "CLAMPMSS=1412\n");
		fprintf(fd, "LCP_INTERVAL=20\n");
		fprintf(fd, "LCP_FAILURE=3\n");
		fprintf(fd, "PPPOE_TIMEOUT=%d\n", ACONF->pppoe.timeout);
		fprintf(fd, "FIREWALL=NONE\n");
		fprintf(fd, "PPPOE_EXTRA=\"\"\n");
		fprintf(fd, "PPPD_EXTRA=\"\"\n");
		fclose(fd);
	}
	fd2 = fopen("/var/config/pap-secrets", "a+");
	fprintf(fd2, "\"%s\"\t*\t\"%s\"\n", ACONF->pppoe.id, ACONF->pppoe.passwd);
	fclose(fd2);
	fd2 = fopen("/var/config/chap-secrets", "a+");
	fprintf(fd2, "\"%s\"\t*\t\"%s\"\n", ACONF->pppoe.id, ACONF->pppoe.passwd);
	fclose(fd2);
	system("adsl-start 6 60");
        break;
    }
  }
  usleep(SLEEP_TIME);
}

/* ************* */
/* Set DHCPD     */
/* 0     : ok    */
/* other : error */
/* ************* */
int setdhcpd(int act)
{

  /* ************************************************************ */
  /* The DHCP server ip range support netmask 255.255.255.0 now!! */
  /* ************************************************************ */

  unsigned char temp[300];
  unsigned char SUB[4];
  unsigned char pid[10];
  FILE *fd, *fd2;

  ACONFIG *ACONF;
  ACONF = (ACONFIG *)OFFSET;
  close(2);

  fd2 = fopen("/var/debug","w");

  if(act == 0) {
    //dummy
    goto dhcpd_off;
  } else {

    SUB[0] = ACONF->local.rhip[0] & ACONF->local.uwid[0];
    SUB[1] = ACONF->local.rhip[1] & ACONF->local.uwid[1];
    SUB[2] = ACONF->local.rhip[2] & ACONF->local.uwid[2];
    SUB[3] = ACONF->local.rhip[3] & ACONF->local.uwid[3];

    switch(ACONF->dhcps.enable)
    {
      case 1:  //dhcpd on
        /* make /var/config/dhcpd.conf */
        sprintf(temp,"dhcpdconf -r -a %d -b %d -c %d.%d.%d.%d -d %d.%d.%d.%d -e %d.%d.%d.%d -f %d.%d.%d.%d -g %d.%d.%d.%d -h %d.%d.%d.%d -i %d.%d.%d.%d",
				   ACONF->dhcps.default_lease_time,ACONF->dhcps.max_lease_time,
				   SUB[0],SUB[1],SUB[2],SUB[3],
				   ACONF->local.uwid[0], ACONF->local.uwid[1],ACONF->local.uwid[2],ACONF->local.uwid[3],
				   ACONF->local.rhip[0], ACONF->local.rhip[1],ACONF->local.rhip[2],ACONF->dhcps.start,
				   ACONF->local.rhip[0], ACONF->local.rhip[1],ACONF->local.rhip[2],ACONF->dhcps.end,
				   ACONF->local.rhip[0], ACONF->local.rhip[1],ACONF->local.rhip[2],255,
				   ACONF->dhcps.dns[0],ACONF->dhcps.dns[1],ACONF->dhcps.dns[2],ACONF->dhcps.dns[3],
				   ACONF->local.rhip[0], ACONF->local.rhip[1],ACONF->local.rhip[2],ACONF->local.rhip[3]
        );

        fprintf(fd2,"%s",temp);
	fclose(fd2);
        system(temp);
        break;

      case 0:  //dhcpd off
dhcpd_off:
        if((fd = fopen("/var/run/dhcpd.pid","r")) != NULL) {
	  fgets(pid,10,fd);
          sprintf(temp,"kill %s",pid);
          system(temp);
          fclose(fd);
        }
        break;
    }
  }
  usleep(SLEEP_TIME);
}

/* ************* */
/* Set  PPTPD    */
/* 0     : ok    */
/* other : error */
/* ************* */
int setpptpd(int act)
{
  char temp[120];
  char pid[15];
  FILE *fd;

  ACONFIG *ACONF;
  ACONF = (ACONFIG *)OFFSET;
  close(2);
  if(act == 1){
     sprintf(temp,"iptables -t nat -I PREROUTING -i eth1 -p tcp --dport 1723 -j ACCEPT");
     system(temp);
     sprintf(temp,"pptpdconf -a %d.%d.%d.%d -b %d.%d.%d.%d -c %d",
     		ACONF->local.rhip[0],ACONF->local.rhip[1],ACONF->local.rhip[2],ACONF->pptp.localIP[3],
		ACONF->local.rhip[0],ACONF->local.rhip[1],ACONF->local.rhip[2],ACONF->pptp.start,
		ACONF->pptp.end);
     /*sprintf(temp,"pptpdconf -a %d.%d.%d.%d -b %d.%d.%d.%d -c %d.%d.%d.%d",
     		ACONF->local.rhip[0],ACONF->local.rhip[1],ACONF->local.rhip[2],ACONF->pptp.localIP[3],
		ACONF->local.rhip[0],ACONF->local.rhip[1],ACONF->local.rhip[2],ACONF->pptp.start,
		ACONF->local.rhip[0],ACONF->local.rhip[1],ACONF->local.rhip[2],ACONF->pptp.end);*/
     system(temp);
     system("pptpd");
  }
  else{
     sprintf(temp,"iptables -t nat -D PREROUTING -i eth1 -p tcp --dport 1723 -j ACCEPT");
     system(temp);
     //system("pptpdconf");
     if((fd = fopen("/var/run/pptpd.pid","r")) != NULL) {
     	fgets(pid,10,fd);
     	sprintf(temp,"kill %s",pid);
     	printf("%s\n",temp);
     	system(temp);
     	fclose(fd);
	if((fd= fopen("/var/run/pptpd.pid","w")) !=NULL) {
		fprintf(fd,"");
		fclose(fd);
	}
     }
  }
}

/* ************* */
/* Set V_SERVER  */
/* 0     : ok    */
/* other : error */
/* ************* */
int setvserver(int act)
{
  char temp[120];
  int i;

  ACONFIG *ACONF;
  ACONF = (ACONFIG *)OFFSET;
  close(2);

  if(act == 0) {
    for(i=0;i<8;i++)
    {
      sprintf(temp,"iptables -t nat -D PREROUTING -i eth1 -p tcp --dport %d -j DNAT --to %d.%d.%d.%d",
                                        ACONF->smap[i].port,
                                        ACONF->local.rhip[0],
                                        ACONF->local.rhip[1],
                                        ACONF->local.rhip[2],
                                        ACONF->smap[i].host);
      system(temp);
      usleep(SLEEP_TIME);
      sprintf(temp,"iptables -t nat -D PREROUTING -i eth1 -p udp --dport %d -j DNAT --to %d.%d.%d.%d",
                                        ACONF->smap[i].port,
                                        ACONF->local.rhip[0],
                                        ACONF->local.rhip[1],
                                        ACONF->local.rhip[2],
                                        ACONF->smap[i].host);
      system(temp);
      usleep(SLEEP_TIME);
    }
  } else if(act == 1) {
    for(i=0;i<8;i++)
    {
      if(ACONF->smap[i].flag == 1){
        sprintf(temp,"iptables -t nat -I PREROUTING -i eth1 -p tcp --dport %d -j DNAT --to %d.%d.%d.%d",
                                        ACONF->smap[i].port,
					ACONF->local.rhip[0],
					ACONF->local.rhip[1],
					ACONF->local.rhip[2],
					ACONF->smap[i].host);
        system(temp);
        usleep(SLEEP_TIME);
        sprintf(temp,"iptables -t nat -I PREROUTING -i eth1 -p udp --dport %d -j DNAT --to %d.%d.%d.%d",
                                        ACONF->smap[i].port,
                                        ACONF->local.rhip[0],
                                        ACONF->local.rhip[1],
                                        ACONF->local.rhip[2],
                                        ACONF->smap[i].host);
        system(temp);
        usleep(SLEEP_TIME);
      } else {
        sprintf(temp,"iptables -t nat -D PREROUTING -i eth1 -p tcp --dport %d -j DNAT --to %d.%d.%d.%d",
                                        ACONF->smap[i].port,
					ACONF->local.rhip[0],
					ACONF->local.rhip[1],
					ACONF->local.rhip[2],
					ACONF->smap[i].host);
        system(temp);
        usleep(SLEEP_TIME);
        sprintf(temp,"iptables -t nat -D PREROUTING -i eth1 -p udp --dport %d -j DNAT --to %d.%d.%d.%d",
                                        ACONF->smap[i].port,
                                        ACONF->local.rhip[0],
                                        ACONF->local.rhip[1],
                                        ACONF->local.rhip[2],
                                        ACONF->smap[i].host);
        system(temp);
        usleep(SLEEP_TIME);
      }
    }
  }
}

/* ************* */
/* Set DMZ host  */
/* 0     : ok    */
/* other : error */
/* ************* */
int setdmz(int act)
{
  char temp[120];

  ACONFIG *ACONF;
  ACONF = (ACONFIG *)OFFSET;
  close(2);

  if(act == 0) {
    sprintf(temp,"iptables -t nat -D PREROUTING -i eth1 -p tcp -j DNAT --to %d.%d.%d.%d",
					ACONF->local.rhip[0],
					ACONF->local.rhip[1],
					ACONF->local.rhip[2],
					ACONF->local.dmz_host);
    system(temp);
    usleep(SLEEP_TIME);
    sprintf(temp,"iptables -t nat -D PREROUTING -i eth1 -p udp -j DNAT --to %d.%d.%d.%d",
                                        ACONF->local.rhip[0],
                                        ACONF->local.rhip[1],
                                        ACONF->local.rhip[2],
                                        ACONF->local.dmz_host);
    system(temp);
    usleep(SLEEP_TIME);
  } else if(act == 1) {
    //if(ACONF->local.wflag == 0) {
      sprintf(temp,"iptables -t nat -D PREROUTING -i eth1 -p tcp -j DNAT --to %d.%d.%d.%d",
                                          ACONF->local.rhip[0],
                                          ACONF->local.rhip[1],
                                          ACONF->local.rhip[2],
                                          ACONF->local.dmz_host);
      system(temp);
      usleep(SLEEP_TIME);
      sprintf(temp,"iptables -t nat -D PREROUTING -i eth1 -p udp -j DNAT --to %d.%d.%d.%d",
                                          ACONF->local.rhip[0],
                                          ACONF->local.rhip[1],
                                          ACONF->local.rhip[2],
                                          ACONF->local.dmz_host);
      system(temp);
      usleep(SLEEP_TIME);
    //} else {
      sprintf(temp,"iptables -t nat -A PREROUTING -i eth1 -p tcp -j DNAT --to %d.%d.%d.%d",
                                          ACONF->local.rhip[0],
                                          ACONF->local.rhip[1],
                                          ACONF->local.rhip[2],
                                          ACONF->local.dmz_host);
      system(temp);
      usleep(SLEEP_TIME);
      sprintf(temp,"iptables -t nat -A PREROUTING -i eth1 -p udp -j DNAT --to %d.%d.%d.%d",
                                          ACONF->local.rhip[0],
                                          ACONF->local.rhip[1],
                                          ACONF->local.rhip[2],
                                          ACONF->local.dmz_host);
      system(temp);
      usleep(SLEEP_TIME);
    //}
  }
}

/* ************* */
/* Set PPPD      */
/* 0     : ok    */
/* other : error */
/* ************* */
int setpppd(int act)
{
  unsigned char temp[50];
  FILE *fd,*fd2;

  ACONFIG *ACONF;
  ACONF = (ACONFIG *)OFFSET;
  close(2);

  if(act == 0) {

  } else if(act == 1) {

    //options file
    strcpy(temp,"pppdconf ");

    if(ACONF->pppd.pap != 0)
      strcat(temp,"-a ");
      usleep(SLEEP_TIME);
    if(ACONF->pppd.chap != 0)
      strcat(temp,"-b ");
      usleep(SLEEP_TIME);
    if(ACONF->pppd.mschap != 0)
      strcat(temp,"-c ");
      usleep(SLEEP_TIME);
    if(ACONF->pppd.mschap2 != 0)
      strcat(temp,"-d ");
      usleep(SLEEP_TIME);

    system(temp);

    //secrets files
    if(((fd  = fopen("/var/config/pap-secrets","w")) == NULL) ||
       ((fd2 = fopen("/var/config/chap-secrets","w")) == NULL)  ) {
      fprintf(stderr,"[pppd secrets maker] open file error!!\n");
    }
#if 1
    //1
    fprintf(fd,"%s\t*\t%s\t*\n",ACONF->pppd.name1,ACONF->pppd.pass1);
    usleep(500);
    fprintf(fd2,"%s\t*\t%s\t*\n",ACONF->pppd.name1,ACONF->pppd.pass1);
    usleep(500);
    //2
    fprintf(fd,"%s\t*\t%s\t*\n",ACONF->pppd.name2,ACONF->pppd.pass2);
    usleep(500);
    fprintf(fd2,"%s\t*\t%s\t*\n",ACONF->pppd.name2,ACONF->pppd.pass2);
    usleep(500);
    //3
    fprintf(fd,"%s\t*\t%s\t*\n",ACONF->pppd.name3,ACONF->pppd.pass3);
    usleep(SLEEP_TIME);
    fprintf(fd2,"%s\t*\t%s\t*\n",ACONF->pppd.name3,ACONF->pppd.pass3);
    usleep(SLEEP_TIME);
    //4
    fprintf(fd,"%s\t*\t%s\t*\n",ACONF->pppd.name4,ACONF->pppd.pass4);
    usleep(SLEEP_TIME);
    fprintf(fd2,"%s\t*\t%s\t*\n",ACONF->pppd.name4,ACONF->pppd.pass4);
    usleep(SLEEP_TIME);
#endif

    fclose(fd);
    fclose(fd2);
  }
}

/* ****************** */
/* for Set special ap */
/* ****************** */
int htoi(char *src, int len)
{
        int i;
        int result;
        char temp;

        for(i = len - 1, result = 0; i >=0; i--)
        {
                temp = *(src + i);
                if(temp >= '0' && temp <= '9')
                        result += (temp - '0') << (4 * (len - i - 1));
                else if(temp >= 'a' && temp <= 'f')
                        result += (temp - 'a' + 10) << (4 * (len - i - 1));
                else
                        return -1;
        }
        return result;
}

/* ****************** */
/* for Set special ap */
/* ****************** */
int atoh(char *src, char *dst, int dst_len)
{
        char temp[] = "0000000000";
        int len;

        // the required length is longer than the length of temp,
        // so we can't create this string.
        if(dst_len >= strlen(temp))
                return 0;

        sprintf(dst, "%x", atoi(src));
        len = dst_len - strlen(dst);
        if(len != 0)
        {
                memcpy(temp + len, dst, strlen(dst));
                temp[dst_len] = 0;
                memcpy(dst, temp, dst_len + 1);
#ifdef DEBUG
                fprintf(stderr, "dst = %s\n", dst);
#endif
                return 1;
        }
        else
        {
#ifdef DEBUG
                fprintf(stderr, "dst = %s\n", dst);
#endif
                return 1;
        }
}


/* ************** */
/* Set Special Ap */
/* 0     : ok     */
/* other : error  */
/* ************** */
int setspap(int act)
{
	char command[110];	// 105 is the best
	char dec_port[6];
	char hex_port[5];
	int i;
	FILE *conf;
	FILE *dmz;
	char host_info[25];
	char port_range[12];
	char ip[16];
	FILE *host;
	char pid[8];
	FILE *spapd_pid;

	ACONFIG *ACONF;
	ACONF = (ACONFIG *)OFFSET;
	close(2);

	if(act)
	{
		conf = fopen("/var/config/spap/spap.conf", "w+");
		fseek(conf, 0L, SEEK_SET);
		for(i = 0; i < 4; i++)
		{
			if(ACONF->spap.trig[i].flag == 1)
			{
				sprintf(command, "iptables -t mangle -A PREROUTING -i eth0 -p tcp -s ! %d.%d.%d.%d --dport %d -j MARK --set-mark %d",
					ACONF->local.rhip[0],
					ACONF->local.rhip[1],
					ACONF->local.rhip[2],
					ACONF->local.dmz_host,
					ACONF->spap.trig[i].port,
					i + 11);
				system(command);

				memcpy(&command[44], (void *)"udp", 3);
				system(command);

				sprintf(command, "iptables -A FORWARD -i eth0 -p tcp -s ! %d.%d.%d.%d --dport %d -j QUEUE",
					ACONF->local.rhip[0],
					ACONF->local.rhip[1],
					ACONF->local.rhip[2],
					ACONF->local.dmz_host,
					ACONF->spap.trig[i].port);
				system(command);

				memcpy(&command[31], (void *)"udp", 3);
				system(command);

				sprintf(dec_port, "%d", ACONF->spap.trig[i].port);
                                atoh(dec_port, hex_port, 4);
                                fprintf(conf, "1%s", hex_port);
                                sprintf(dec_port, "%d", ACONF->spap.sepl[i].lb);
                                atoh(dec_port, hex_port, 4);
                                fprintf(conf, "%s", hex_port);
                                sprintf(dec_port, "%d", ACONF->spap.sepl[i].ub);
                                atoh(dec_port, hex_port, 4);
                                fprintf(conf, "%s\n", hex_port);
			}
			else
			{
				sprintf(dec_port, "%d", ACONF->spap.trig[i].port);
				atoh(dec_port, hex_port, 4);
				fprintf(conf, "0%s", hex_port);
				sprintf(dec_port, "%d", ACONF->spap.sepl[i].lb);
				atoh(dec_port, hex_port, 4);
				fprintf(conf, "%s", hex_port);
				sprintf(dec_port, "%d", ACONF->spap.sepl[i].ub);
				atoh(dec_port, hex_port, 4);
				fprintf(conf, "%s\n", hex_port);
			}
		}
		fclose(conf);

		// generate dmz file
		dmz = fopen("/var/config/spap/dmz", "w+");
		fprintf(dmz, "%d.%d.%d.%d",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->local.dmz_host);
		fclose(dmz);

		// generate spap.host file
		host = fopen("/var/config/spap/spap.host", "w+");
		fprintf(host, "000000000000000000000000\n000000000000000000000000\n000000000000000000000000\n000000000000000000000000\n");
		fclose(host);

		// call spapd
		system("/bin/spapd");
	}
	else
	{
		// kill spapd
		spapd_pid = fopen("/var/run/spapd", "r");
		if(spapd_pid != NULL)
		{
			fseek(spapd_pid, 0L, SEEK_SET);
			fgets(pid, 8, spapd_pid);
			if(strlen(pid) != 0)
			{
				sprintf(command, "kill %s", pid);
				system(command);
			}
			fclose(spapd_pid);
		}

		// remove WAN to LAN rules
		host = fopen("/var/config/spap/spap.host", "r");
		if(host != NULL)
		{
			fseek(host, 0L, SEEK_SET);
			i = 1;
			while(fgets(host_info, 26, host) != NULL)
			{
				if(!strncmp(host_info + 8, "0000000000000000", 16))
				{
					i++;
					continue;
				}
				else
				{
					sprintf(ip, "%d.%d.%d.%d", htoi(host_info + 8, 2), htoi(host_info + 10, 2), htoi(host_info + 12, 2), htoi(host_info + 14, 2));
					sprintf(port_range, "%d:%d", htoi(host_info + 16, 4), htoi(host_info + 20, 4));
					sprintf(command, "iptables -t nat -D PREROUTING -i eth1 -p tcp --dport %s -j DNAT --to %s",
						port_range, ip);
					system(command);

					memcpy(&command[41], (void *)"udp", 3);
					system(command);

					sprintf(command, "iptables -t mangle -D PREROUTING -i eth1 -p tcp --dport %s -j MARK --set-mark %d",
						port_range, i + 14);
					system(command);

					memcpy(&command[44], (void *)"udp", 3);
					system(command);

					sprintf(command, "iptables -D FORWARD -i eth1 -p tcp --dport %s -j QUEUE",
						port_range);
					system(command);

					memcpy(&command[31], (void *)"udp", 3);
					system(command);

					i++;
				}
			}
			fclose(host);
		}

		// remove LAN to WAN rules
		for(i = 0; i < 4; i++)
                {
                        if(ACONF->spap.trig[i].flag == 1)
                        {
                                sprintf(command, "iptables -t mangle -D PREROUTING -i eth0 -p tcp -s ! %d.%d.%d.%d --dport %d -j MARK --set-mark %d",
                                        ACONF->local.rhip[0],
                                        ACONF->local.rhip[1],
                                        ACONF->local.rhip[2],
                                        ACONF->local.dmz_host,
                                        ACONF->spap.trig[i].port,
                                        i + 11);
                                system(command);

                                memcpy(&command[44], (void *)"udp", 3);
                                system(command);

                                sprintf(command, "iptables -D FORWARD -i eth0 -p tcp -s ! %d.%d.%d.%d --dport %d -j QUEUE",
                                        ACONF->local.rhip[0],
                                        ACONF->local.rhip[1],
                                        ACONF->local.rhip[2],
                                        ACONF->local.dmz_host,
                                        ACONF->spap.trig[i].port);
                                system(command);

                                memcpy(&command[31], (void *)"udp", 3);
                                system(command);
			}
		}
	}
}

int setactrl(int act)
{
	int i, j;
	FILE *fp;
	char temp[13];
	ACONFIG *ACONF;
	ACONF = (ACONFIG *)OFFSET;
	close(2);

	if(act)
	{
		if((fp = fopen(CONF_PATH, "w")) == NULL)
		{
#ifdef DEBUG
			fprintf(stdout, "#setactrl: cannot open %s.\n", CONF_PATH);
#endif
			fclose(fp);
			return 1;
		}

		fprintf(fp, "%d\n", ACONF->local.dmz_host);
#ifdef DEBUG
		fprintf(stdout, "#setactrl: dmz = %d.\n", ACONF->local.dmz_host);
#endif

		for(i = 0; i < GROUP_NUM; i++)
		{
			/*** ]wpolicy ***/
			if(ACONF->actl2[i].flag)
			{
				fprintf(fp, "1 ");
#ifdef DEBUG
				fprintf(stdout, "#setactrl: 1 ");
#endif
			}
			else
			{
				fprintf(fp, "0 ");
#ifdef DEBUG
				fprintf(stdout, "#setactrl: 0 ");
#endif
			}

			/*** ]wip ***/
			// default group(i = 0)ݳ]wip
			if(i)
			{
				for(j = 0; j < BOUND; j++)
				{
					sprintf(temp, "%d %d ", ACONF->actl2[i].ip[j].sip, ACONF->actl2[i].ip[j].eip);
					fprintf(fp, "%s", temp);
#ifdef DEBUG
					fprintf(stdout, "%s", temp);
#endif
				}
			}

			/*** ]wport ***/
			for(j = 0; j < BOUND; j++)
			{
				sprintf(temp, "%d %d ", ACONF->actl2[i].port[j].sp, ACONF->actl2[i].port[j].ep);
				fprintf(fp, "%s", temp);
#ifdef DEBUG
				fprintf(stdout, "%s", temp);
#endif
			}
			fprintf(fp, "\n");
#ifdef DEBUG
			fprintf(stdout, "\n");
#endif
		}
		fclose(fp);
	}
	else
	{
		return 0;
	}
}
//----End new actrl
// pj

/* ********** */
/* pptpc_dial */
/* ********** */
int pptpc_dial(char *ip,char *name, char *pswd)
{
  unsigned char temp[50];
  sprintf(temp,"pptp %s name %s -r",ip,name);
  system(temp);
}

/* succ 0513 */
int pptpc_disc(int index, VPN_struct *vpn)
{
  unsigned char command[50],pid[10];
  FILE *fd;

  /* remove ip file in /var/run/pptp */
  sprintf(command,"/var/run/pptp/%d.%d.%d.%d",vpn->connections[index].ip[0],vpn->connections[index].ip[1],
                                              vpn->connections[index].ip[2],vpn->connections[index].ip[3] );
  remove(command);

  /* remove pid of pppd */
  sprintf(command,"/var/run/pptp/pptpc.%d.%d.%d.%d",vpn->connections[index].ip[0],vpn->connections[index].ip[1],
                                                    vpn->connections[index].ip[2],vpn->connections[index].ip[3] );
  fd = fopen(command,"r");
  fgets(pid,10,fd);
  fclose(fd);
  remove(command);
  sprintf(command,"kill %s",pid);
  system(command);

  /* remove pid of pptpc */
  sprintf(command,"/var/run/pptp/pptpcall.%d.%d.%d.%d",vpn->connections[index].ip[0],vpn->connections[index].ip[1],
                                                       vpn->connections[index].ip[2],vpn->connections[index].ip[3] );
  fd = fopen(command,"r");
  fgets(pid,10,fd);
  fclose(fd);
  remove(command);
  sprintf(command,"kill %s",pid);
  system(command);
}
/* succ */

/* ************ */
/* url blocking */
/* ************ */
int add_url(ACONFIG *src, char *url)
{
	int i = 0;
	while(src->ids.urlblock.url[i].string[0] != 0)
		i++;

	if(i < 100)
		strcpy(src->ids.urlblock.url[i].string,url);
	else
		return 0;

	return 1;
}
int del_url(ACONFIG *src, int num)
{
	int i;
	num--;
	if(src->ids.urlblock.url[num].string[0] != 0)
		src->ids.urlblock.url[num].string[0] = 0;

	i = num + 1;
	if(i == 100)
		return 1;
	while(src->ids.urlblock.url[i].string[0] != 0)
	{
		//memcpy((void *)src->ids.urlblock.url[i - 1].string, (void *)src->ids.urlblock.url[i].string, strlen(src->ids.urlblock.url[i].string));
		strcpy(src->ids.urlblock.url[i-1].string,src->ids.urlblock.url[i].string);
		i++;
		if(i == 100)
		{
			src->ids.urlblock.url[i - 1].string[0] = 0;
			return 1;
		}
	}
	src->ids.urlblock.url[i - 1].string[0] = 0;
	return 1;
}
/* ************ */
/* ids switch   */
/* ************ */
int setids_pingf(int act)
{
	char command[100];
	ACONFIG *ACONF;
	ACONF = (ACONFIG *)OFFSET;
	close(2);

	if(act)
	{
		sprintf(command, "iptables -N pingflood");
		system(command);

		sprintf(command, "iptables -A pingflood -m limit --limit 1/sec --limit-burst 1 -j RETURN");
		system(command);

		sprintf(command, "iptables -A pingflood -m limit --limit 10/minute --limit-burst 1 -j LOG --log-prefix %s", PINGF_NUM);
		system(command);

		sprintf(command, "iptables -A pingflood -j DROP");
		system(command);

		sprintf(command, "iptables -A INPUT -i eth1 -p icmp --icmp-type echo-request -m state --state NEW -j pingflood");
		system(command);
	}
	else
	{
		sprintf(command, "iptables -D INPUT -i eth1 -p icmp --icmp-type echo-request -m state --state NEW -j pingflood");
		system(command);

		sprintf(command, "iptables -F pingflood");
		system(command);

		sprintf(command, "iptables -X pingflood");
		system(command);
	}

	return 0;
}

int setids_smurf(int act)
{
	char command[90];
	ACONFIG *ACONF;
	ACONF = (ACONFIG *)OFFSET;
	close(2);

	if(act)
	{
		sprintf(command, "iptables -N smurf");
		system(command);

		sprintf(command, "iptables -A smurf -m state --state ESTABLISHED,RELATED -j ACCEPT");
		system(command);

		sprintf(command, "iptables -A smurf -m limit --limit 10/minute --limit-burst 1 -j LOG --log-prefix %s", SMURF_NUM);
		system(command);

		sprintf(command, "iptables -A smurf -j DROP");
		system(command);

		sprintf(command, "iptables -A INPUT -i eth1 -p ICMP --icmp-type echo-reply -j smurf");
		system(command);
	}
	else
	{
		sprintf(command, "iptables -D INPUT -i eth1 -p ICMP --icmp-type echo-reply -j smurf");
		system(command);

		sprintf(command, "iptables -F smurf");
		system(command);

		sprintf(command, "iptables -X smurf");
		system(command);
	}

	return 0;
}

int setids_psd(int act)
{
	char command[130];
	ACONFIG *ACONF;
	ACONF = (ACONFIG *)OFFSET;
	close(2);

	if(act)
	{
		sprintf(command, "iptables -N psd");
		system(command);

		sprintf(command, "iptables -A psd -m limit --limit 10/minute --limit-burst 1 -j LOG --log-prefix %s", PSD_NUM);
		system(command);

		//sprintf(command, "iptables -A psd -d %d.%d.%d.%d -j ACCEPT",
		//	ACONF->local.rhip[0],
		//	ACONF->local.rhip[1],
		//	ACONF->local.rhip[2],
		//	ACONF->local.dmz_host);
		//system(command);

		sprintf(command, "iptables -A psd -j DROP");
		system(command);

		sprintf(command, "iptables -A FORWARD -i eth1 -o eth0 -p tcp -d %d.%d.%d.0/24 -m psd --psd-weight-threshold 5 --psd-delay-threshold 200 -j psd",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2]);
		system(command);
	}
	else
	{
		sprintf(command, "iptables -D FORWARD -i eth1 -o eth0 -p tcp -d %d.%d.%d.0/24 -m psd --psd-weight-threshold 5 --psd-delay-threshold 200 -j psd",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2]);
		system(command);

		sprintf(command, "iptables -F psd");
		system(command);

		sprintf(command, "iptables -X psd");
		system(command);
	}

	return 0;
}

int setids_fraggle(int act)
{
	char command[120];
	ACONFIG *ACONF;
	ACONF = (ACONFIG *)OFFSET;
	close(2);

	if(act)
	{
		sprintf(command, "iptables -N fraggle");
		system(command);

		sprintf(command, "iptables -A fraggle -p udp -m state --state ESTABLISHED -j ACCEPT");
		system(command);

		sprintf(command, "iptables -A fraggle -m limit --limit 10/minute --limit-burst 1 -j LOG --log-prefix %s", FRAGGLE_NUM);
		system(command);

		sprintf(command, "iptables -A fraggle -j DROP");
		system(command);

		//sprintf(command, "iptables -A FORWARD -i eth1 -o eth0 -p udp -m multiport --sports 7,11,19,37,45,513,550 -d ! %d.%d.%d.%d -j fraggle",
		//	ACONF->local.rhip[0],
		//	ACONF->local.rhip[1],
		//	ACONF->local.rhip[2],
		//	ACONF->local.dmz_host);
		sprintf(command, "iptables -A FORWARD -i eth1 -o eth0 -p udp -m multiport --sports 7,11,19,37,45,513,550 -j fraggle");
		system(command);
	}
	else
	{
		//sprintf(command, "iptables -D FORWARD -i eth1 -o eth0 -p udp -m multiport --sports 7,11,19,37,45,513,550 -d ! %d.%d.%d.%d -j fraggle",
		//	ACONF->local.rhip[0],
		//	ACONF->local.rhip[1],
		//	ACONF->local.rhip[2],
		//	ACONF->local.dmz_host);
		sprintf(command, "iptables -D FORWARD -i eth1 -o eth0 -p udp -m multiport --sports 7,11,19,37,45,513,550 -j fraggle");
		system(command);

		sprintf(command, "iptables -F fraggle");
		system(command);

		sprintf(command, "iptables -X fraggle");
		system(command);
	}

	return 0;
}

int setids_snork(int act)
{
	char command[140];
	ACONFIG *ACONF;
	ACONF = (ACONFIG *)OFFSET;
	close(2);

	if(act)
	{
		sprintf(command, "iptables -N snork");
		system(command);

		sprintf(command, "iptables -A snork -m limit --limit 10/minute --limit-burst 1 -j LOG --log-prefix %s", SNORK_NUM);
		system(command);

		sprintf(command, "iptables -A snork -j DROP");
		system(command);

		sprintf(command, "iptables -A FORWARD -i eth1 -o eth0 -p udp --dport 135 -m multiport --sports 7,11,19,37,45,135,513,550 -j snork");
		system(command);
	}
	else
	{
		sprintf(command, "iptables -D FORWARD -i eth1 -o eth0 -p udp --dport 135 -m multiport --sports 7,11,19,37,45,135,513,550 -j snork");
		system(command);

		sprintf(command, "iptables -F snork");
		system(command);

		sprintf(command, "iptables -X snork");
		system(command);
	}

	return 0;
}

int setids_land(int act)
{
	char command[100];
	ACONFIG *ACONF;
	ACONF = (ACONFIG *)OFFSET;
	close(2);

	if(act)
	{
		sprintf(command, "iptables -t mangle -N land");
		system(command);

		sprintf(command, "iptables -t mangle -A land -m limit --limit 10/minute --limit-burst 1 -j LOG --log-prefix %s", LAND_NUM);
		system(command);

		sprintf(command, "iptables -t mangle -A land -j DROP");
		system(command);

		sprintf(command, "iptables -t mangle -A PREROUTING -p TCP -i eth1 -s %d.%d.%d.%d -d %d.%d.%d.%d -j land",
			ACONF->local.wip[0],
			ACONF->local.wip[1],
			ACONF->local.wip[2],
			ACONF->local.wip[3],
			ACONF->local.wip[0],
			ACONF->local.wip[1],
			ACONF->local.wip[2],
			ACONF->local.wip[3]);
		system(command);
	}
	else
	{
		sprintf(command, "iptables -t mangle -D PREROUTING -p TCP -i eth1 -s %d.%d.%d.%d -d %d.%d.%d.%d -j land",
			ACONF->local.wip[0],
			ACONF->local.wip[1],
			ACONF->local.wip[2],
			ACONF->local.wip[3],
			ACONF->local.wip[0],
			ACONF->local.wip[1],
			ACONF->local.wip[2],
			ACONF->local.wip[3]);
		system(command);

		sprintf(command, "iptables -t mangle -F land");
		system(command);

		sprintf(command, "iptables -t mangle -X land");
		system(command);
	}

	return 0;
}

int setids_urlblock(int act)
{
	FILE *fp;
	int i;
	char command[110];
	ACONFIG *ACONF;
	ACONF = (ACONFIG *)OFFSET;
	close(2);

	if(act)
	{
		fp = fopen("/var/config/ipq/url.conf", "w");
		if(fp == NULL)
		{
			fclose(fp);
			return 0;
		}
		for(i = 0; ACONF->ids.urlblock.url[i].string[0] != 0; i++)
		{
			fprintf(fp, "%s\n", ACONF->ids.urlblock.url[i].string);
		}
		fclose(fp);

		sprintf(command, "iptables -t mangle -A PREROUTING -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport 80 -j MARK --set-mark 3",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->local.dmz_host);
		system(command);

		sprintf(command, "iptables -A FORWARD -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport 80 -j QUEUE",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->local.dmz_host);
		system(command);

		if(ACONF->ids.urlblock.proxy)
		{
			sprintf(command, "iptables -t mangle -A PREROUTING -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport %d -j MARK --set-mark 3",
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->local.dmz_host,
				ACONF->ids.urlblock.proxy);
			system(command);

			sprintf(command, "iptables -A FORWARD -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport %d -j QUEUE",
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->local.dmz_host,
				ACONF->ids.urlblock.proxy);
			system(command);
		}
	}
	else
	{
		fp = fopen("/var/config/ipq/url.conf", "w");
		fclose(fp);

		sprintf(command, "iptables -t mangle -D PREROUTING -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport 80 -j MARK --set-mark 3",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->local.dmz_host);
		system(command);

		sprintf(command, "iptables -D FORWARD -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport 80 -j QUEUE",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->local.dmz_host);
		system(command);

		if(ACONF->ids.urlblock.proxy)
		{
			sprintf(command, "iptables -t mangle -D PREROUTING -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport %d -j MARK --set-mark 3",
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->local.dmz_host,
				ACONF->ids.urlblock.proxy);
			system(command);

			sprintf(command, "iptables -D FORWARD -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport %d -j QUEUE",
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->local.dmz_host,
				ACONF->ids.urlblock.proxy);
			system(command);
		}
	}

	return 0;
}
/* ************ */
/* virus pattern*/
/* 0:error      */
/* 1:success    */
/* ************ */
int add_virus(ACONFIG *src, int protocol, int port, char * pattern)
{
	int i = 0;
	while(src->ids.virus[i].pattern[0] != 0)
		i++;
	//memcpy((void *)src->ids.urlblock.url[i].string, (void *)url, strlen(url));
	if(i == VIRUS_PATTERN_NUM )
		return 0;
	strcpy(src->ids.virus[i].pattern,pattern);
	src->ids.virus[i].protocol = protocol;
	src->ids.virus[i].port = port;
	return 1;
}
int del_virus(ACONFIG *src, int num)
{
	int i;
	num--;
	if(num < 0 || num >VIRUS_PATTERN_NUM )
		return 0;
	if(src->ids.virus[num].pattern[0] != 0)
	{
		src->ids.virus[num].protocol=0;
		src->ids.virus[num].port=0;
		src->ids.virus[num].pattern[0] = 0;
	}
	i = num + 1;
	if( i == VIRUS_PATTERN_NUM )
		return 1;
	while( src->ids.virus[i].pattern[0] != 0 )
	{
		//memcpy((void *)src->ids.urlblock.url[i - 1].string, (void *)src->ids.urlblock.url[i].string, strlen(src->ids.urlblock.url[i].string));
		strcpy(src->ids.virus[i-1].pattern,src->ids.virus[i].pattern);
		src->ids.virus[i-1].protocol = src ->ids.virus[i].protocol;
		src->ids.virus[i-1].port = src ->ids.virus[i].port;
		i++;
		if(i == VIRUS_PATTERN_NUM)
			break;
	}
	src->ids.virus[i - 1].pattern[0] = 0;
	src->ids.virus[i-1].protocol = 0;
	src->ids.virus[i-1].port = 0;
	return 1;
}
/*-----Virus Parser-----*/
int virusParser()
{
	FILE *creat;
	char protocol[4];
	char port[6];
	char pattern[MAX];
	char name[100];
	char hostnet[25];
	char command1[110];
	char command2[110];
	char DMZ[25];
	int i,temp;
	ACONFIG *a;
	a = (ACONFIG *)OFFSET;
	close(2);

	printf("in parser\n");
	//strcpy(name,VIRUS_PATH);
	//strcat(name,pattern);
	//sprintf(hostnet,"%d.%d.%d.0/24",a->local.rhip[0],a->local.rhip[1],a->local.rhip[2]);
	sprintf(DMZ,"%d.%d.%d.%d",a->local.rhip[0],a->local.rhip[1],a->local.rhip[2],a->local.dmz_host);
	//printf("hostnet=%s\n",hostnet);
	for(i=0;i<50;i++)
	{
		if(a->ids.virus[i].pattern[0]=='\0')
			continue;
		printf("i=%d \n",i);
		if(a->ids.virus[i].protocol== 0)
			strcpy(protocol,"tcp");
		else
			strcpy(protocol,"udp");
		temp=(int)a->ids.virus[i].port;
		//printf("port=%d\n",temp);
		sprintf(port,"%d",temp);
		//printf("port=%s\n",port);
		//set command1 to add "mark"
		//strcpy(command1,"iptables -t mangle -A PREROUTING -p ");
		//strcat(command1,protocol);
		//strcat(command1," -s ! ");
		//strcat(command1,hostnet);
		//strcat(command1," --dport ");
		//strcat(command1,port);
		//strcat(command1," -j MARK --set-mark 6");
		//command1[strlen(command1)] = '\0';
		//sprintf(command1,"iptables -t mangle -A PREROUTING -p %s -s ! %s --dport %s -j MARK --set-mark 6",
		//		protocol, hostnet, port);
		sprintf(command1,"iptables -t mangle -A PREROUTING -i eth1 -p %s -d ! %s --dport %s -j MARK --set-mark 6",
				protocol, DMZ, port);
		//set command2 to add "QUEUE"
		//strcpy(command2,"iptables -A FORWARD -p ");
		//strcat(command2,protocol);
		//strcat(command2," -s ! ");
		//strcat(command2,hostnet);
		//strcat(command2," --dport ");
		//strcat(command2,port);
		//strcat(command2," -j QUEUE");
		//command2[strlen(command2)] = '\0';
		//sprintf(command2,"iptables -A FORWARD -p %s -s ! %s --dport %s -j QUEUE",
		//		protocol, hostnet, port);
		sprintf(command2,"iptables -A FORWARD -i eth1 -p %s -d ! %s --dport %s -j QUEUE",
				protocol, DMZ, port);
		//printf("protocol=%s\n",protocol);
		//printf("port=%s\n",port);
		//printf("pattern=%s\n",pattern);
		if(strcmp(protocol,"tcp")==0){
			name[0]='\0';
			//strcpy(name,"t");
			strcpy(name,VIRUS_PATH);
			strcat(name,"t");
			system(command1);
			system(command2);
		}
		else if(strcmp(protocol,"udp")==0){
			name[0]='\0';
			//strcpy(name,"u");
			strcpy(name,VIRUS_PATH);
			strcat(name,"u");
			system(command1);
			system(command2);
		}
		else {
			//printf("protocol unknow\n");
			return 0;
		}
		strcat(name,port);
		//printf("file=%s\n",name);
		//getchar();
		for(temp=0;temp<5;temp++)
		{
			if((creat=fopen(name,"a"))==NULL)
				continue;
			else
				break;
		}
		if(creat != NULL)
		{
			fprintf(creat,"%s\n",a->ids.virus[i].pattern,creat);
			fclose(creat);
		}
		else
			printf("can't open file\n");
	}

	return 0;
}
/*-----End Virus Parser-----*/
/* ************** */
/* set virus scan */
/* ************** */
int setids_virusscan(int act)
{
	//char buf[10];
	char protocol[4];
	//char port[6];
	char command[110];
	int i;
	ACONFIG *a;
	a = (ACONFIG *)OFFSET;
	close(2);
	//printf("1-2\n");
	if(act)
	{
		//printf("1-3\n");
		virusParser();
		//printf("1-4\n");
	}
	else
	{
		//printf("1-5\n");
		if((a->ids.flag[1]&0x20)==0x20)
		{
			for(i=0;i<50;i++)
			{
				//printf("1-6\n");
				if(a->ids.virus[i].pattern[0]==0)
				{
					continue;
					//printf("1-7\n");
				}
				if(a->ids.virus[i].protocol==0)
					sprintf(protocol,"tcp");
				else
					sprintf(protocol,"udp");
				//printf("1-7.\n");
				sprintf(command,"iptables -t mangle -D PREROUTING -i eth1 -p %s -d ! %d.%d.%d.%d --dport %d -j MARK --set-mark 6",
						protocol,a->local.rhip[0],a->local.rhip[1],a->local.rhip[2],a->local.dmz_host,
						a->ids.virus[i].port);
				system(command);
				//printf("%s\n",command);
				//printf("1-8\n");
				sprintf(command,"iptables -D FORWARD -i eth1 -p %s -d ! %d.%d.%d.%d --dport %d -j QUEUE",
						protocol,a->local.rhip[0],a->local.rhip[1],a->local.rhip[2],a->local.dmz_host,
						a->ids.virus[i].port);
				system(command);
				//printf("%s\n",command);
				//printf("1-9\n");
			}
			//printf("1-10\n");
			//strcpy(command,VIRUS_PATH);
			//strcat(command,"*");
			//remove(command);
		}
	}
	return 0;
}

/*-----*/
int setids_udpbomb(int act)
{
	FILE *fp;

	if(act)
	{
		fp = fopen("/proc/sys/net/ipv4/udp_bomb", "w");
		if(fp == NULL)
		{
			fclose(fp);
			return 1;
		}
		fprintf(fp, "1");
		fclose(fp);
	}
	else
	{
		fp = fopen("/proc/sys/net/ipv4/udp_bomb", "w");
		if(fp == NULL)
		{
			fclose(fp);
			return 1;
		}
		fprintf(fp, "0");
		fclose(fp);
	}

	return 0;
}

int setids_synf(int act)
{
	FILE *fp;

	if(act)
	{
		fp = fopen("/proc/sys/net/ipv4/tcp_syncookies", "w");
		if(fp == NULL)
		{
			fclose(fp);
			return 1;
		}
		fprintf(fp, "1");
		fclose(fp);
	}
	else
	{
		fp = fopen("/proc/sys/net/ipv4/tcp_syncookies", "w");
		if(fp == NULL)
		{
			fclose(fp);
			return 1;
		}
		fprintf(fp, "0");
		fclose(fp);
	}

	return 0;
}

int setids_icmpun(int act)
{
	FILE *fp;
	char command[110];
	ACONFIG *ACONF;
	ACONF = (ACONFIG *)OFFSET;
	close(2);

	if(act)
	{
		fp = fopen("/proc/sys/net/ipv4/icmp_ignore_dest_unreach", "w");
		if(fp == NULL)
		{
			fclose(fp);
			return 1;
		}
		fprintf(fp, "1");
		fclose(fp);

		sprintf(command, "iptables -A FORWARD -i eth1 -o eth0 -p icmp --icmp-type network-unreachable -j DROP");
		system(command);

		sprintf(command, "iptables -A FORWARD -i eth1 -o eth0 -p icmp --icmp-type host-unreachable -j DROP");
		system(command);

		sprintf(command, "iptables -A FORWARD -i eth1 -o eth0 -p icmp --icmp-type protocol-unreachable -j DROP");
		system(command);

		sprintf(command, "iptables -A FORWARD -i eth1 -o eth0 -p icmp --icmp-type port-unreachable -j DROP");
		system(command);
	}
	else
	{
		fp = fopen("/proc/sys/net/ipv4/icmp_ignore_dest_unreach", "w");
		if(fp == NULL)
		{
			fclose(fp);
			return 1;
		}
		fprintf(fp, "0");
		fclose(fp);

		sprintf(command, "iptables -D FORWARD -i eth1 -o eth0 -p icmp --icmp-type network-unreachable -j DROP");
		system(command);

		sprintf(command, "iptables -D FORWARD -i eth1 -o eth0 -p icmp --icmp-type host-unreachable -j DROP");
		system(command);

		sprintf(command, "iptables -D FORWARD -i eth1 -o eth0 -p icmp --icmp-type protocol-unreachable -j DROP");
		system(command);

		sprintf(command, "iptables -D FORWARD -i eth1 -o eth0 -p icmp --icmp-type port-unreachable -j DROP");
		system(command);
	}

	return 0;
}

int setids_dns(int act)
{
	char command[100];
	ACONFIG *ACONF;
	ACONF = (ACONFIG *)OFFSET;
	close(2);

	if(act)
	{
		sprintf(command, "iptables -N dns");
		system(command);

		sprintf(command, "iptables -A dns -m limit --limit 10/minute --limit-burst 1 -j LOG --log-prefix %s", DNS_SCAN_NUM);
		system(command);

		sprintf(command, "iptables -A dns -j DROP");
		system(command);

		sprintf(command, "iptables -A FORWARD -p tcp -s ! %d.%d.%d.%d -d %d.%d.%d.%d --dport 53 -j dns",
			ACONF->ids.dns_scan.wan_dns[0],
			ACONF->ids.dns_scan.wan_dns[1],
			ACONF->ids.dns_scan.wan_dns[2],
			ACONF->ids.dns_scan.wan_dns[3],
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->ids.dns_scan.lan_dns);
		//printf("%s\n",command);
		system(command);
	}
	else
	{
		if((ACONF->ids.flag[1] & 0x04) == 0x04)
		{
			sprintf(command, "iptables -D FORWARD -p tcp -s ! %d.%d.%d.%d -d %d.%d.%d.%d --dport 53 -j dns",
				ACONF->ids.dns_scan.wan_dns[0],
				ACONF->ids.dns_scan.wan_dns[1],
				ACONF->ids.dns_scan.wan_dns[2],
				ACONF->ids.dns_scan.wan_dns[3],
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->ids.dns_scan.lan_dns);
			//printf("%s\n",command);
			system(command);

			sprintf(command, "iptables -F dns");
			system(command);

			sprintf(command, "iptables -X dns");
			system(command);
		}
	}

	return 0;
}

int setids_mailblock(int act)
{
	FILE *fp;
	int i;
	char command[110];
	ACONFIG *ACONF;
	ACONF = (ACONFIG *)OFFSET;
	close(2);

	if(act)
	{

		//----mbomb2 flow block
		if((ACONF->ids.flag[1]&0x80)==0x80)
		{
			//printf("m2\n");
			fp=fopen(MBOMB2_PATH,"w");
			fprintf(fp,"1\n");
			fprintf(fp,"%d\n",ACONF->ids.mbomb2.total_sender);
			fprintf(fp,"%d\n",ACONF->ids.mbomb2.total_mails);
			fclose(fp);
		}
		else
		{
			//printf("off m2\n");
			fp=fopen(MBOMB2_PATH,"w");
			fprintf(fp,"0\n");
			fclose(fp);
		}

		//----mbomb1 address block
		if((ACONF->ids.flag[1]&0x40)==0x40)
		{
			//printf("m1\n");
			fp=fopen(MBOMB_PATH,"w");
			fprintf(fp,"1\n");
			fclose(fp);
		}
		else
		{	//printf("off m1\n");
			fp=fopen(MBOMB_PATH,"w");
			fprintf(fp,"0\n");
			fclose(fp);
		}

		fp = fopen("/var/config/ipq/mailaddr.conf", "w");
		if(fp == NULL)
		{
			fclose(fp);
			return 0;
		}
		for(i = 0; ACONF->ids.mailblock[i].string[0] != 0; i++)
		{
			fprintf(fp, "%s\n", ACONF->ids.mailblock[i].string);
		}
		fclose(fp);

		sprintf(command, "iptables -t mangle -A PREROUTING -i eth1 -p TCP ! --syn -d ! %d.%d.%d.%d --dport 25 -j MARK --set-mark 4",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->local.dmz_host);
		system(command);

		sprintf(command, "iptables -A FORWARD -i eth1 -o eth0 -p TCP ! --syn -d ! %d.%d.%d.%d --dport 25 -j QUEUE",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->local.dmz_host);
		system(command);
	}
	else
	{

		//----close mbomb2 flow block
		fp=fopen(MBOMB2_PATH,"w");
		fprintf(fp,"0\n");
		fclose(fp);
		//----close mbomb address block
		fp=fopen(MBOMB_PATH,"w");
		fprintf(fp,"0\n");
		fclose(fp);


		fp = fopen("/var/config/ipq/mailaddr.conf", "w");
		fclose(fp);

		sprintf(command, "iptables -t mangle -D PREROUTING -i eth1 -p TCP ! --syn -d ! %d.%d.%d.%d --dport 25 -j MARK --set-mark 4",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->local.dmz_host);
		system(command);

		sprintf(command, "iptables -D FORWARD -i eth1 -o eth0 -p TCP ! --syn -d ! %d.%d.%d.%d --dport 25 -j QUEUE",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->local.dmz_host);
		system(command);
	}

	return 0;
}

int setids_mscript(int act)
{
	FILE *fp;
	//char temp[10];
	char command[120];
	ACONFIG *ACONF;
	ACONF = (ACONFIG *)OFFSET;
	close(2);

	if(act)
	{
		fp = fopen("/var/config/ipq/mscript.conf", "w");
		if(fp == NULL)
		{
			return 0;
		}
		fprintf(fp, "1");
		fclose(fp);

		if((ACONF->ids.flag[1] & 0x08) != 0x08)
		{
			sprintf(command, "iptables -t mangle -A PREROUTING -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport 80 -j MARK --set-mark 3",
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->local.dmz_host);
			system(command);

			sprintf(command, "iptables -A FORWARD -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport 80 -j QUEUE",
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->local.dmz_host);
			system(command);

			if(ACONF->ids.mscript_proxy)
			{
				sprintf(command, "iptables -t mangle -A PREROUTING -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport %d -j MARK --set-mark 3",
					ACONF->local.rhip[0],
					ACONF->local.rhip[1],
					ACONF->local.rhip[2],
					ACONF->local.dmz_host,
					ACONF->ids.mscript_proxy);
				system(command);

				sprintf(command, "iptables -A FORWARD -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport %d -j QUEUE",
					ACONF->local.rhip[0],
					ACONF->local.rhip[1],
					ACONF->local.rhip[2],
					ACONF->local.dmz_host,
					ACONF->ids.mscript_proxy);
				system(command);
			}
		}

		sprintf(command, "iptables -t mangle -A PREROUTING -i eth1 -p tcp ! --syn -d ! %d.%d.%d.%d --sport 80 -j MARK --set-mark 5",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->local.dmz_host);
		system(command);

		sprintf(command, "iptables -A FORWARD -i eth1 -o eth0 -p tcp ! --syn -d ! %d.%d.%d.%d --sport 80 -j QUEUE",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->local.dmz_host);
		system(command);

		if(ACONF->ids.mscript_proxy)
		{
			sprintf(command, "iptables -t mangle -A PREROUTING -i eth1 -p TCP ! --syn -d ! %d.%d.%d.%d --sport %d -j MARK --set-mark 5",
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->local.dmz_host,
				ACONF->ids.mscript_proxy);
			system(command);

			sprintf(command, "iptables -A FORWARD -i eth1 -o eth0 -p TCP ! --syn -d ! %d.%d.%d.%d --sport %d -j QUEUE",
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->local.dmz_host,
				ACONF->ids.mscript_proxy);
			system(command);
		}
	}
	else
	{
		fp = fopen("/var/config/ipq/mscript.conf", "w");
		if(fp == NULL)
		{
			return 0;
		}
		fprintf(fp, "0");
		fclose(fp);

		if((ACONF->ids.flag[1] & 0x08) != 0x08)
		{
			sprintf(command, "iptables -t mangle -D PREROUTING -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport 80 -j MARK --set-mark 3",
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->local.dmz_host);
			system(command);

			sprintf(command, "iptables -D FORWARD -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport 80 -j QUEUE",
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->local.dmz_host);
			system(command);

			if(ACONF->ids.mscript_proxy)
			{
				sprintf(command, "iptables -t mangle -D PREROUTING -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport %d -j MARK --set-mark 3",
					ACONF->local.rhip[0],
					ACONF->local.rhip[1],
					ACONF->local.rhip[2],
					ACONF->local.dmz_host,
					ACONF->ids.mscript_proxy);
				system(command);

				sprintf(command, "iptables -D FORWARD -i eth0 -p TCP ! --syn -s ! %d.%d.%d.%d --dport %d -j QUEUE",
					ACONF->local.rhip[0],
					ACONF->local.rhip[1],
					ACONF->local.rhip[2],
					ACONF->local.dmz_host,
					ACONF->ids.mscript_proxy);
				system(command);
			}
		}

		sprintf(command, "iptables -t mangle -D PREROUTING -i eth1 -p tcp ! --syn -d ! %d.%d.%d.%d --sport 80 -j MARK --set-mark 5",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->local.dmz_host);
		system(command);

		sprintf(command, "iptables -D FORWARD -i eth1 -o eth0 -p tcp ! --syn -d ! %d.%d.%d.%d --sport 80 -j QUEUE",
			ACONF->local.rhip[0],
			ACONF->local.rhip[1],
			ACONF->local.rhip[2],
			ACONF->local.dmz_host);
		system(command);

		if(ACONF->ids.mscript_proxy)
		{
			sprintf(command, "iptables -t mangle -D PREROUTING -i eth1 -p TCP ! --syn -d ! %d.%d.%d.%d --sport %d -j MARK --set-mark 5",
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->local.dmz_host,
				ACONF->ids.mscript_proxy);
			system(command);

			sprintf(command, "iptables -D FORWARD -i eth1 -o eth0 -p TCP ! --syn -d ! %d.%d.%d.%d --sport %d -j QUEUE",
				ACONF->local.rhip[0],
				ACONF->local.rhip[1],
				ACONF->local.rhip[2],
				ACONF->local.dmz_host,
				ACONF->ids.mscript_proxy);
			system(command);
		}
	}

	return 0;
}

int add_maddr(ACONFIG *src, char *mail)
{
	int i = 0;

	while(src->ids.mailblock[i].string[0] != 0)
		i++;

	if(i < 100)
		strcpy(src->ids.mailblock[i].string, mail);
	else
		return 0;

	return 1;
}

int del_maddr(ACONFIG *src, int num)
{
	int i;

	num--;
	if(num < 0 && num > 100)
		return 0;

	if(src->ids.mailblock[num].string[0] != 0)
		src->ids.mailblock[num].string[0] = 0;
	else
		return 0;

	i = num + 1;
	if(i == 100)
		return 1;
	while(src->ids.mailblock[i].string[0] != 0)
	{
		strcpy(src->ids.mailblock[i - 1].string, src->ids.mailblock[i].string);
		i++;
		if(i == 100)
		{
			src->ids.mailblock[i - 1].string[0] = 0;
			return 1;
		}
	}
	src->ids.mailblock[i - 1].string[0] = 0;

	return 1;
}

int setids(int act)
{
	ACONFIG *a = (ACONFIG *)OFFSET;
	close(2);

	if(act)
	{
		if((a->ids.flag[0]&0x01)==0x01)
		{
			//printf("1 - flag[0]:0x01\n");
			setids_snork(1);
		}
		if((a->ids.flag[0]&0x02)==0x02)
		{
			//printf("1 - flag[0]:0x02\n");
			setids_smurf(1);
		}
		//if((a->ids.flag[0]&0x04)==0x04)
		//	;
		if((a->ids.flag[0]&0x08)==0x08)
		{
			//printf("1 - flag[0]:0x08\n");
			setids_psd(1);
		}
		if((a->ids.flag[0]&0x10)==0x10)
		{
			//printf("1 - flag[0]:0x10\n");
			setids_udpbomb(1);
		}
		if((a->ids.flag[0]&0x20)==0x20)
		{
			//printf("1 - flag[0]:0x20\n");
			setids_synf(1);
		}
		if((a->ids.flag[0]&0x40)==0x40)
		{
			//printf("1 - flag[0]:0x40\n");
			setids_fraggle(1);
		}
		if((a->ids.flag[0]&0x80)==0x80)
		{
			//printf("1 - flag[0]:0x80\n");
			setids_land(1);
		}
		if((a->ids.flag[1]&0x01)==0x01)
		{
			//printf("1 - flag[1]:0x01\n");
			setids_icmpun(1);
		}
		if((a->ids.flag[1]&0x02)==0x02)
		{
			//printf("1 - flag[1]:0x02\n");
			setids_pingf(1);
		}
		// --- DNS Scan has its own menu, do not set it ---
		if((a->ids.flag[1]&0x04)==0x04)	// DNS Scan
			setids_dns(1);
		if((a->ids.flag[1]&0x08)==0x08)	// http url block
			setids_urlblock(1);
		// --- Malicious Script has its own menu, do not set it ---
		if((a->ids.flag[1]&0x10)==0x10)	// Malicious Script
			setids_mscript(1);
		if((a->ids.flag[1]&0x20)==0x20)	// Virus
			setids_virusscan(1);
		if(((a->ids.flag[1]&0x40)==0x40)  || ((a->ids.flag[1]&0x80)==0x80) )
			setids_mailblock(1);
		//if((a->ids.flag[1]&0x40)==0x40)	// Mail Bomb - Address Blocking
		//	setids_mailblock(1);
		//if((a->ids.flag[1]&0x80)==0x80)		// Mail Bomb - total number
			;
	}
	else
	{
		// Closing already opened items.
		// If we just close all items but doesn't check that had been opened or not,
		// it will cause some problems like "fault-common.c 242".
		if((a->ids.flag[0]&0x01)==0x01)		// Snork
		{
			//printf("0 - flag[0]:0x01\n");
			setids_snork(0);
		}
		if((a->ids.flag[0]&0x02)==0x02)		// Smurf
		{
			//printf("0 - flag[0]:0x02\n");
			setids_smurf(0);
		}
		//if((a->ids.flag[0]&0x04)==0x04)	// Nothing
		//	;
		if((a->ids.flag[0]&0x08)==0x08)		// Port Scan Detection
		{
			//printf("0 - flag[0]:0x08\n");
			setids_psd(0);
		}
		if((a->ids.flag[0]&0x10)==0x10)		// UDP Bomb
		{
			//printf("0 - flag[0]:0x10\n");
			setids_udpbomb(0);
		}
		if((a->ids.flag[0]&0x20)==0x20)		// SYN Flooding
		{
			//printf("0 - flag[0]:0x20\n");
			setids_synf(0);
		}
		if((a->ids.flag[0]&0x40)==0x40)		// Fraggle
		{
			//printf("0 - flag[0]:0x40\n");
			setids_fraggle(0);
		}
		if((a->ids.flag[0]&0x80)==0x80)		// Land Attack
		{
			//printf("0 - flag[0]:0x80\n");
			setids_land(0);
		}
		if((a->ids.flag[1]&0x01)==0x01)		// ICMP Unreachable
		{
			//printf("0 - flag[1]:0x01\n");
			setids_icmpun(0);
		}
		if((a->ids.flag[1]&0x02)==0x02)		// Ping Flooding (ICMP Echo Flooding)
		{
			//printf("0 - flag[1]:0x02\n");
			setids_pingf(0);
		}
		// --- DNS Scan has its own menu, do not set it ---
		if((a->ids.flag[1]&0x04)==0x04)	// DNS Scan
			setids_dns(0);
		if((a->ids.flag[1]&0x08)==0x08)	// http url block
			setids_urlblock(0);
		// --- Malicious Script has its own menu, do not set it ---
		if((a->ids.flag[1]&0x10)==0x10)	// Malicious Script
			setids_mscript(0);
		if((a->ids.flag[1]&0x20)==0x20)		// Virus
			setids_virusscan(0);
		if(((a->ids.flag[1]&0x40)==0x40)  || ((a->ids.flag[1]&0x80)==0x80) )
			setids_mailblock(0);
		// --- Mail Bomb has its own menu, do not set it ---
		//if((a->ids.flag[1]&0x40)==0x40)	// Mail Bomb - Address Blocking
		//	setids_mailblock(0);
		//if((a->ids.flag[1]&0x80)==0x80)		// Mail Bomb - total number
	}

	return 0;
}
/*---set Send ---*/
int setsend(int act)
{
	int i;
	char command[80];
	FILE *alert_table, *mail_list, *send_pid;
	ACONFIG * ACONF;
	ACONF = (ACONFIG *)OFFSET;

	close(2);
	if(act ==1)
	{
		for(i=0;i<5;i++)
		{
			if((mail_list=fopen(MAIL_LIST_FILE,"w"))!=NULL)
				break;
			sleep(1);
		}
		if(mail_list==NULL)
			return 0;//error to open file
		if(ACONF->mailalert.mail_from[0]!= '\0')
			fprintf(mail_list,"%s\n",ACONF->mailalert.mail_from);
		if(ACONF->mailalert.list[0].mail_to[0] != '\0')
			fprintf(mail_list,"%s\n",ACONF->mailalert.list[0].mail_to);
		if(ACONF->mailalert.list[1].mail_to[0] != '\0')
			fprintf(mail_list,"%s\n",ACONF->mailalert.list[1].mail_to);
		if(ACONF->mailalert.list[2].mail_to[0] != '\0')
			fprintf(mail_list,"%s\n",ACONF->mailalert.list[2].mail_to);
		fclose(mail_list);

		for(i=0;i<5;i++)
		{
			if((alert_table=fopen(ALERT_TABLE_FILE,"w"))!=NULL)
				break;
			sleep(1);
		}
		if(alert_table==NULL)
			return 0;//error to open file
		for(i=0;i<20;i++)
		{
			if(ACONF->mailalert.alert_table[i].logname[0]==0)
				continue;//no data
			fprintf(alert_table,"%d %d %s\n",
			ACONF->mailalert.alert_table[i].lognum,
			ACONF->mailalert.alert_table[i].emergency,
			ACONF->mailalert.alert_table[i].logname);
		}
		fclose(alert_table);
		system("send");
	}
	else
	{
		printf("set send off\n");
		remove(MAIL_LIST_FILE);
		remove(ALERT_TABLE_FILE);
		for(i=0;i<5;i++)
		{
			if((send_pid=fopen("/var/run/send","r"))!=NULL)
				break;
			sleep(1);
		}
		if(send_pid==NULL)
		{
			printf("can't open file /var/run/send\n");
			return 0;//error to open file
		}
		fgets(command,80,send_pid);
		//command[strlen(command)-1]=0;
		i=atoi(command);
		sprintf(command,"kill %d",i);
		printf("%s\n",command);
		system(command);
	}
	return 0;
}

/* *************** */
/* IPsec  settings */
/* *************** */

/* *************** */
/* IPsec setManual */
/* *************** */

int do_command(char *cmd, int mode)
{
	if( mode )
	{
		printf("%s\n", cmd);
		return 0;
	}
/*printf("%s\n", cmd);*/
	return system(cmd);
}

int
setmanual(int index_of_tunnel, int action)
{

	char command[80];
	char temp[6];
	char dir[25];
	char spi[6];
	char local_ip[16];
	char remote_ip[16];
	char auth[8];
	char authkey[43];
	char enckey[51];
	char gateway[16];
	char local_net[16];
	char l_mask[16];
	char remote_net[16];
	char r_mask[16];
	int debug,i,j;
	BYTE encap_protocol;
	ACONFIG *a;
	FILE *fp_ip;
	ip_info_struct ife;
	a = (ACONFIG *)OFFSET;
	strcpy(dir,"/usr/local/lib/ipsec/");
	//--get spi (0x100~0xfff)
	sprintf(temp,"%lx",a->ipsec.Tunnel_Info[index_of_tunnel].key_method.manual.local_spi);
	strcpy(spi,"0x000");
	for(i=strlen(temp)-1,j=0;i>=0;i--,j++)
	{
		spi[4-j]=temp[i];
	}

	//get local wan ip
	fp_ip = fopen(IP_INFO_FILE,"r");
	fgets(local_ip,16,fp_ip);

	//get remote ip
	sprintf(remote_ip,"%d.%d.%d.%d",
			a->ipsec.Tunnel_Info[index_of_tunnel].remote_gateway[0],
			a->ipsec.Tunnel_Info[index_of_tunnel].remote_gateway[1],
			a->ipsec.Tunnel_Info[index_of_tunnel].remote_gateway[2],
			a->ipsec.Tunnel_Info[index_of_tunnel].remote_gateway[3]);
	//get auth & auth key
	if(a->ipsec.Tunnel_Info[index_of_tunnel].key_method.manual.auth_algorithm==0)
	{
		strcpy(auth,"");
		strcpy(authkey,"");
	}
	else if(a->ipsec.Tunnel_Info[index_of_tunnel].key_method.manual.auth_algorithm==1)//MD5
	{
		strcpy(auth,"md5-96");
		strcpy(authkey,"0x");
		memcpy(authkey+2,a->ipsec.Tunnel_Info[index_of_tunnel].key_method.manual.auth_key,32);
		authkey[34]=0;
	}
	else
	{
		strcpy(auth,"sha1-96");
		strcpy(authkey,"0x");
		memcpy(authkey+2,a->ipsec.Tunnel_Info[index_of_tunnel].key_method.manual.auth_key,40);
		authkey[42]=0;
	}

	//get enckey
	strcpy(enckey,"0x");
	memcpy(enckey+2,a->ipsec.Tunnel_Info[index_of_tunnel].key_method.manual.encry_num[0].encryption_key,48);
	enckey[50]=0;
	//get GW
	findGW(&ife);
	sprintf(gateway,"%d.%d.%d.%d",ife.gw[0],ife.gw[1],ife.gw[2],ife.gw[3]);
	//get local subnet
	if(a->ipsec.Tunnel_Info[index_of_tunnel].local_subnet[0]==0 &&
	   a->ipsec.Tunnel_Info[index_of_tunnel].local_subnet[1]==0 &&
	   a->ipsec.Tunnel_Info[index_of_tunnel].local_subnet[2]==0 &&
	   a->ipsec.Tunnel_Info[index_of_tunnel].local_subnet[3]==0 )
		strcpy(local_net,"");
	else
		sprintf(local_net,"%d.%d.%d.%d",a->ipsec.Tunnel_Info[index_of_tunnel].local_subnet[0],
						a->ipsec.Tunnel_Info[index_of_tunnel].local_subnet[1],
						a->ipsec.Tunnel_Info[index_of_tunnel].local_subnet[2],
						a->ipsec.Tunnel_Info[index_of_tunnel].local_subnet[3]);
	//get local netmask
	if(a->ipsec.Tunnel_Info[index_of_tunnel].local_netmask[0]==0 &&
	   a->ipsec.Tunnel_Info[index_of_tunnel].local_netmask[1]==0 &&
	   a->ipsec.Tunnel_Info[index_of_tunnel].local_netmask[2]==0 &&
	   a->ipsec.Tunnel_Info[index_of_tunnel].local_netmask[3]==0 )
	   	strcpy(l_mask,"");
	else
		sprintf(l_mask,"%d.%d.%d.%d",a->ipsec.Tunnel_Info[index_of_tunnel].local_netmask[0],
						a->ipsec.Tunnel_Info[index_of_tunnel].local_netmask[1],
						a->ipsec.Tunnel_Info[index_of_tunnel].local_netmask[2],
						a->ipsec.Tunnel_Info[index_of_tunnel].local_netmask[3]);
	//get remote subnet
	if(a->ipsec.Tunnel_Info[index_of_tunnel].remote_subnet[0]==0 &&
	   a->ipsec.Tunnel_Info[index_of_tunnel].remote_subnet[1]==0 &&
	   a->ipsec.Tunnel_Info[index_of_tunnel].remote_subnet[2]==0 &&
	   a->ipsec.Tunnel_Info[index_of_tunnel].remote_subnet[3]==0 )
	   	strcpy(remote_net,"");
	else
		sprintf(remote_net,"%d.%d.%d.%d",a->ipsec.Tunnel_Info[index_of_tunnel].remote_subnet[0],
						a->ipsec.Tunnel_Info[index_of_tunnel].remote_subnet[1],
						a->ipsec.Tunnel_Info[index_of_tunnel].remote_subnet[2],
						a->ipsec.Tunnel_Info[index_of_tunnel].remote_subnet[3]);
	//get remote netmask
	if(a->ipsec.Tunnel_Info[index_of_tunnel].remote_netmask[0]==0 &&
	   a->ipsec.Tunnel_Info[index_of_tunnel].remote_netmask[1]==0 &&
	   a->ipsec.Tunnel_Info[index_of_tunnel].remote_netmask[2]==0 &&
	   a->ipsec.Tunnel_Info[index_of_tunnel].remote_netmask[3]==0 )
	   	strcpy(r_mask,"");
	else
		sprintf(r_mask,"%d.%d.%d.%d",a->ipsec.Tunnel_Info[index_of_tunnel].remote_netmask[0],
						a->ipsec.Tunnel_Info[index_of_tunnel].remote_netmask[1],
						a->ipsec.Tunnel_Info[index_of_tunnel].remote_netmask[2],
						a->ipsec.Tunnel_Info[index_of_tunnel].remote_netmask[3]);
	//get encap_protocol
	encap_protocol=a->ipsec.Tunnel_Info[index_of_tunnel].key_method.manual.encap_protocol;

	//char spi[] = "0x600";
	//char local_ip[] =  "140.116.247.37";
	//char remote_ip[] =  "140.116.247.9";
	//char auth[] = "sha1-96";
	//char authkey[] = "0x1111222233334444555566667777888899990000";
	//char enckey[] = "0x111122223333444455556666777788889999000011112222";
	//char gateway[] = "140.116.247.253";
	//char local_net[] ="192.168.37.0";
	//char l_mask[] = "24";
	//char remote_net[] = "192.168.9.0";
	//char r_mask[] = "24";



	 // unsigned char encap_protocol
	 //
	 // 0x01	 AH_TUNNEL
	 // 0x02  AH_TRANSPORT
	 // 0x03  ESP_TUNNEL
	 // 0x04  ESP_TRANSPORT
	 // 0x05  ESP_TUNNEL_WITH_AUTH
	 // 0x06  ESP_TRANSPORT_WITH_AUTH


	//unsigned char encap_protocol = 0x06;

	debug=0;

//printf(" %x \n\n", encap_protocol);



#ifdef DEBUG_IPSEC_MANUAL
	debug = 1;;
#endif

	if( action )	// ipsec manual --up tunnel_i
	{
		if( encap_protocol == 0x01 ){		// AH_TUNNEL

			// outbound
			sprintf(command, "%sspi --af inet --said tun%s@%s --ip4 --src %s --dst %s", dir, spi, remote_ip, local_ip, remote_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --said ah%s@%s --ah hmac-%s --src %s --authkey %s", dir, spi, remote_ip, auth, local_ip, authkey);
			do_command(command,debug);
			sprintf(command, "%sspigrp --said tun%s@%s ah%s@%s", dir, spi, remote_ip, spi, remote_ip);
			do_command(command,debug);

			// inbound
			sprintf(command, "%sspi --af inet --said tun%s@%s --ip4 --src %s --dst %s", dir, spi, local_ip, remote_ip, local_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --said ah%s@%s --ah hmac-%s --src %s --authkey %s", dir, spi, local_ip, auth, remote_ip, authkey);
			do_command(command,debug);
			sprintf(command, "%sspigrp --said tun%s@%s ah%s@%s", dir, spi, local_ip, spi, local_ip);
			do_command(command,debug);
			// eroute
			if( strlen(local_net)==0 && strlen(remote_net) != 0)
				sprintf(command,"%seroute --eraf inet --replace --src %s/32 --dst %s/%s --said tun%s@%s", dir,local_ip, remote_net, r_mask,spi,  remote_ip);
			else if(strlen(local_net) !=0 && strlen(remote_net) ==0  )
				sprintf(command,"%seroute --eraf inet --replace --src %s/%s --dst %s/32 --said tun%s@%s",dir, local_net, l_mask, remote_ip,  spi, remote_ip);
			else
				sprintf(command,"%seroute --eraf inet --replace --src %s/%s --dst %s/%s --said tun%s@%s",dir, local_net, l_mask, remote_net, r_mask, spi, remote_ip);
			do_command(command,debug);
		}
		else if( encap_protocol == 0x02){	// AH_TRANSPORT

			// outbound
			sprintf(command,"%sspi --af inet --said ah%s@%s --ah hmac-%s --src %s --authkey %s", dir, spi, remote_ip, auth, local_ip, authkey);
			do_command(command,debug);
			// inbound
			sprintf(command,"%sspi --af inet --said ah%s@%s --ah hmac-%s --src %s --authkey %s", dir, spi, local_ip, auth, remote_ip, authkey);
			do_command(command,debug);
			// eroute
			sprintf(command,"%seroute --eraf inet --replace  --src %s/32 --dst %s/32 --said ah%s@%s",dir, local_ip, remote_ip, spi, remote_ip);
			do_command(command,debug);

		}
		else if( encap_protocol == 0x03 ){	// ESP_TUNNEL


			// outbound
			sprintf(command, "%sspi --af inet --said tun%s@%s --ip4 --src %s --dst %s", dir, spi, remote_ip,  local_ip, remote_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --said esp%s@%s --esp 3des --src %s --enckey %s", dir, spi, remote_ip, local_ip, enckey);
			do_command(command,debug);
			sprintf(command, "%sspigrp --said tun%s@%s esp%s@%s", dir, spi, remote_ip, spi, remote_ip);
			do_command(command,debug);

			// inbound
			sprintf(command, "%sspi --af inet --said tun%s@%s --ip4 --src %s --dst %s", dir, spi, local_ip,  remote_ip, local_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --said esp%s@%s --esp 3des --src %s --enckey %s", dir, spi, local_ip, remote_ip, enckey);
			do_command(command,debug);
			sprintf(command, "%sspigrp --said tun%s@%s esp%s@%s", dir, spi, local_ip, spi, local_ip);
			do_command(command,debug);

			// eroute
			if( strlen(local_net)==0 && strlen(remote_net) != 0)
				sprintf(command,"%seroute --eraf inet --replace --src %s/32 --dst %s/%s --said tun%s@%s", dir,local_ip, remote_net, r_mask,spi,  remote_ip);
			else if(strlen(local_net) !=0 && strlen(remote_net) ==0  )
				sprintf(command,"%seroute --eraf inet --replace --src %s/%s --dst %s/32 --said tun%s@%s",dir, local_net, l_mask, remote_ip,  spi, remote_ip);
			else
				sprintf(command,"%seroute --eraf inet --replace --src %s/%s --dst %s/%s --said tun%s@%s",dir, local_net, l_mask, remote_net, r_mask, spi, remote_ip);
			do_command(command,debug);
		}
		else if( encap_protocol == 0x04){	// ESP_TRANSPORT

			// outbound
			sprintf(command, "%sspi --af inet --said esp%s@%s --esp 3des --src %s --enckey %s", dir, spi, remote_ip, local_ip, enckey);
			do_command(command,debug);
			// inbound
			sprintf(command, "%sspi --af inet --said esp%s@%s --esp 3des --src %s --enckey %s", dir, spi, local_ip, remote_ip, enckey);
			do_command(command,debug);
			// eroute
			sprintf(command, "%seroute --eraf inet --replace --src %s/32 --dst %s/32 --said esp%s@%s", dir, local_ip, remote_ip, spi, remote_ip);
			do_command(command,debug);

		}
		else if( encap_protocol == 0x05){//ESP_TUNNEL_WITH_AUTH


			// outbound
			sprintf(command, "%sspi --af inet --said tun%s@%s --ip4 --src %s --dst %s", dir, spi, remote_ip, local_ip, remote_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --said esp%s@%s --esp 3des-%s --src %s --authkey %s --enckey %s", dir, spi, remote_ip, auth, local_ip, authkey, enckey);
			do_command(command,debug);
			sprintf(command, "%sspigrp --said tun%s@%s esp%s@%s", dir, spi, remote_ip, spi, remote_ip);
			do_command(command,debug);

			// inbound
			sprintf(command, "%sspi --af inet --said tun%s@%s --ip4 --src %s --dst %s", dir, spi, local_ip, remote_ip, local_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --said esp%s@%s --esp 3des-%s --src %s --authkey %s --enckey %s", dir, spi, local_ip, auth, remote_ip, authkey, enckey);
			do_command(command,debug);
			sprintf(command, "%sspigrp --said tun%s@%s esp%s@%s", dir, spi, local_ip, spi, local_ip);
			do_command(command,debug);

			//eroute
			if( strlen(local_net)==0 && strlen(remote_net) != 0)
				sprintf(command,"%seroute --eraf inet --replace --src %s/32 --dst %s/%s --said tun%s@%s", dir,local_ip, remote_net, r_mask,spi,  remote_ip);
			else if(strlen(local_net) !=0 && strlen(remote_net) ==0  )
				sprintf(command,"%seroute --eraf inet --replace --src %s/%s --dst %s/32 --said tun%s@%s",dir, local_net, l_mask, remote_ip,  spi, remote_ip);
			else
				sprintf(command,"%seroute --eraf inet --replace --src %s/%s --dst %s/%s --said tun%s@%s",dir, local_net, l_mask, remote_net, r_mask, spi, remote_ip);
			do_command(command,debug);
		}
		else{				//ESP_TRANSPORT_WITH_AUTH

			// outbound
			sprintf(command, "%sspi --af inet --said esp%s@%s --esp 3des-%s --src %s --authkey %s --enckey %s", dir, spi, remote_ip, auth, local_ip, authkey, enckey);
			do_command(command,debug);
			// inbound
			sprintf(command, "%sspi --af inet --said esp%s@%s --esp 3des-%s --src %s --authkey %s --enckey %s", dir, spi, local_ip, auth, remote_ip, authkey, enckey);
			do_command(command,debug);
			// eroute
			sprintf(command, "%seroute --replace --src %s/32 --dst %s/32 --said esp%s@%s", dir, local_ip, remote_ip, spi, remote_ip);
			do_command(command,debug);
		}

		//---------------------------
		//  add a routing table entry
		//---------------------------
		if( encap_protocol == 0x02 ||  encap_protocol == 0x04 ||  encap_protocol == 0x06 )	// all transport modes
		{
			sprintf(command,"route add -host %s/32 dev ipsec0 gw %s", remote_ip, gateway);
		}
		else{	// all tunnel modes
			if(  strlen(remote_net) == 0 )
				sprintf(command,"route add -host %s/32 dev ipsec0 gw %s", remote_ip, gateway);
			else
				sprintf(command,"route add -net %s/%s dev ipsec0 gw %s", remote_net,r_mask, gateway);
		}
		do_command(command, debug);

	}
	else		// ipsec_manual --down tunnel_i
	{


		if( encap_protocol  == 0x01 || encap_protocol == 0x03 || encap_protocol == 0x05 ) 	// all tunnel modes
		{

			if( strlen(local_net)==0 && strlen(remote_net) != 0)
				sprintf(command,"%seroute --del --eraf inet --src %s/32 --dst %s/%s", dir, local_ip, remote_net, r_mask);
			else if(strlen(local_net) !=0 && strlen(remote_net) ==0 )
				sprintf(command,"%seroute --del --eraf inet --src %s/%s --dst %s/32", dir, local_net,l_mask, remote_ip);
			else
				sprintf(command,"%seroute --del --eraf inet --src %s/%s --dst %s/%s", dir, local_net,l_mask, remote_net, r_mask);
			do_command(command,debug);
			sprintf(command,"%sspi --af inet --del --said tun%s@%s", dir, spi, remote_ip);
			do_command(command,debug);
			sprintf(command,"%sspi --af inet --del --said tun%s@%s", dir, spi, local_ip);
			do_command(command,debug);
		}
		else if( encap_protocol == 0x02){	// AH_TRANSPORT
			sprintf(command, "%seroute --del --eraf inet --src %s/32 --dst %s/32", dir, local_ip, remote_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --del --said ah%s@%s", dir, spi, remote_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --del --said ah%s@%s", dir, spi, local_ip);
			do_command(command,debug);

			sprintf(command, "route del -host %s", remote_ip);
			do_command(command,debug);
		}
		else{	// ESP_TRANSPORT or ESP_TRANSPORT_WITH_AUTH
			sprintf(command, "%seroute --del --eraf inet --src %s/32 --dst %s/32", dir, local_ip, remote_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --del --said esp%s@%s", dir, spi, remote_ip);
			do_command(command,debug);
			sprintf(command, "%sspi --af inet --del --said esp%s@%s", dir, spi, local_ip);
			do_command(command,debug);

		}
		//---------------------------
		// delete a routing table entry
		//---------------------------
		if( encap_protocol == 0x02 ||  encap_protocol == 0x04 ||  encap_protocol == 0x06 )	// all transport modes
		{
			sprintf(command,"route del -host %s/32 dev ipsec0 gw %s", remote_ip, gateway);
		}
		else{	// all tunnel modes
			if(  strlen(remote_net) == 0 )
				sprintf(command,"route del -host %s/32 dev ipsec0 gw %s", remote_ip, gateway);
			else
				sprintf(command,"route del -net %s/%s dev ipsec0 gw %s", remote_net,r_mask, gateway);
		}
		do_command(command, debug);

	}

}

//----end set manual ---by wnlee
//----by succ
void setsecrets(int switchs)
{
	int i,j,ip_value;
	FILE *fp, *fp_ip;
	BYTE ip_now[4];
	char ip_temp[20],ip_num[4];
	char *tp;
	ACONFIG * ACONF;
	ACONF = (ACONFIG *)OFFSET;

	//get now ip
	fp_ip = fopen(IP_INFO_FILE,"r");
	fgets(ip_temp,20,fp_ip);
	tp=ip_temp;
	for(j=0;j<4;j++)
	{
		i=0;
		while(*tp!='.' && *tp!= '\0')
		{
			ip_num[i]=*tp;
			i++;
			tp++;
		}
		ip_num[i]=0;
		ip_value=atoi(ip_num);
		ip_now[j]=ip_value;
	}

  if(switchs == 1)
  {
    if(ACONF->ipsec.Tunnel_Info[i].type_of_key_method == 0 &&  //IKE
       ACONF->ipsec.Tunnel_Info[i].tunnel_name == NULL)               //Legal tunnel
    {
      fp = fopen("/var/ipsec.secrets","a+");
      for(i=0;i<MAX_NUMBER_OF_TUNNELS;i++)
      {
        fprintf(fp,"%d.%d.%d.%d %d.%d.%d.%d: PSK \"%s\"\n",
                    ip_now[0],
    	            ip_now[1],
  	            ip_now[2],
  	            ip_now[3],
        	    ACONF->ipsec.Tunnel_Info[i].remote_gateway[0],
    	            ACONF->ipsec.Tunnel_Info[i].remote_gateway[1],
  	            ACONF->ipsec.Tunnel_Info[i].remote_gateway[2],
  	            ACONF->ipsec.Tunnel_Info[i].remote_gateway[3],
  	            ACONF->ipsec.Tunnel_Info[i].key_method.ike.preshared_key);
      }
      fclose(fp);
    }
  }
  else
  {
    /* *********************** */
    /* remove the secrets file */
    /* *********************** */
    remove("/var/ipsec.secrets");
  }
}

/* ******* */
/* set ike */
/* ******* */
void setike(int index,int switchs)
{
	int i,j,ip_value;
	char temp[300];
	char time[30];
	FILE *fp, *fp_ip;
	BYTE ip_now[4];
	char ip_temp[20],ip_num[4];
	char *tp;
	ACONFIG * ACONF;
	ACONF = (ACONFIG *)OFFSET;

	//get now ip
	fp_ip = fopen(IP_INFO_FILE,"r");
	fgets(ip_temp,20,fp_ip);
	tp=ip_temp;
	for(j=0;j<4;j++)
	{
		i=0;
		while(*tp!='.' && *tp!= '\0')
		{
			ip_num[i]=*tp;
			i++;
			tp++;
		}
		ip_num[i]=0;
		ip_value=atoi(ip_num);
		ip_now[j]=ip_value;
	}

  if(switchs == 1) //ON
  {
    setsecrets(1);

    /* ****************** */
    /* add ike connection */
    /* ****************** */
    if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.mode == 0) //transport mode
    {
      sprintf(temp,"/bin/whack --name %s --host %d.%d.%d.%d --to --host %d.%d.%d.%d",
                   ACONF->ipsec.Tunnel_Info[i].tunnel_name,
                   ip_now[0],
                   ip_now[1],
                   ip_now[2],
                   ip_now[3],
                   ACONF->ipsec.Tunnel_Info[i].remote_gateway[0],
                   ACONF->ipsec.Tunnel_Info[i].remote_gateway[1],
                   ACONF->ipsec.Tunnel_Info[i].remote_gateway[2],
                   ACONF->ipsec.Tunnel_Info[i].remote_gateway[3]);

      if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.encap_protocol == 0) //ESP only
      {
        strcat(temp," --encrypt");
      }
      else if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.encap_protocol == 1) //AH only
      {
        strcat(temp," --authentication");
      }
      else //ESP and AH
      {
        strcat(temp," --encrypt --authentication");
      }

      if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.pfs == 1) //pfs enable
      {
        strcat(temp," --pfs");
      }

      if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.ikelifetime != 0)
      {
      	sprintf(time," --ikelifetime %d",ACONF->ipsec.Tunnel_Info[i].key_method.ike.ikelifetime);
        strcat(temp,time);
      }

      if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.ipseclifetime != 0)
      {
      	sprintf(time," --ipseclifetime %d",ACONF->ipsec.Tunnel_Info[i].key_method.ike.ikelifetime);
        strcat(temp,time);
      }

      strcat(temp," --delete");

    }
    else  //tunnel mode
    {
      sprintf(temp,"/bin/whack --name %s --host %d.%d.%d.%d --client %d.%d.%d.%d/%d --to --host %d.%d.%d.%d --client %d.%d.%d.%d/%d",
                   ACONF->ipsec.Tunnel_Info[i].tunnel_name,
                   ip_now[0],
                   ip_now[1],
		   ip_now[2],
                   ip_now[3],
                   ACONF->ipsec.Tunnel_Info[i].local_subnet[0],
                   ACONF->ipsec.Tunnel_Info[i].local_subnet[1],
                   ACONF->ipsec.Tunnel_Info[i].local_subnet[2],
                   ACONF->ipsec.Tunnel_Info[i].local_subnet[3],
                   ACONF->ipsec.Tunnel_Info[i].local_netmask[0],
                   ACONF->ipsec.Tunnel_Info[i].local_netmask[1],
                   ACONF->ipsec.Tunnel_Info[i].local_netmask[2],
                   ACONF->ipsec.Tunnel_Info[i].local_netmask[3],
                   ACONF->ipsec.Tunnel_Info[i].remote_gateway[0],
                   ACONF->ipsec.Tunnel_Info[i].remote_gateway[1],
                   ACONF->ipsec.Tunnel_Info[i].remote_gateway[2],
                   ACONF->ipsec.Tunnel_Info[i].remote_gateway[3],
                   ACONF->ipsec.Tunnel_Info[i].remote_subnet[0],
                   ACONF->ipsec.Tunnel_Info[i].remote_subnet[1],
                   ACONF->ipsec.Tunnel_Info[i].remote_subnet[2],
                   ACONF->ipsec.Tunnel_Info[i].remote_subnet[3],
                   ACONF->ipsec.Tunnel_Info[i].remote_netmask[0],
                   ACONF->ipsec.Tunnel_Info[i].remote_netmask[1],
                   ACONF->ipsec.Tunnel_Info[i].remote_netmask[2],
                   ACONF->ipsec.Tunnel_Info[i].remote_netmask[3] );

      if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.encap_protocol == 0) //ESP only
      {
        strcat(temp," --encrypt");
      }
      else if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.encap_protocol == 1) //AH only
      {
        strcat(temp," --authentication");
      }
      else //ESP and AH
      {
        strcat(temp," --encrypt --authentication");
      }

      if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.pfs == 1) //pfs enable
      {
        strcat(temp," --pfs");
      }

      if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.ikelifetime != 0)
      {
      	sprintf(time," --ikelifetime %d",ACONF->ipsec.Tunnel_Info[i].key_method.ike.ikelifetime);
        strcat(temp,time);
      }

      if(ACONF->ipsec.Tunnel_Info[i].key_method.ike.ipseclifetime != 0)
      {
      	sprintf(time," --ipseclifetime %d",ACONF->ipsec.Tunnel_Info[i].key_method.ike.ikelifetime);
        strcat(temp,time);
      }

      strcat(temp," --delete");
    }
  }
  else
  {
    setsecrets(0);

    /* ********************* */
    /* delete ike connection */
    /* ********************* */
    sprintf(temp,"/bin/whack --delete --name %s",ACONF->ipsec.Tunnel_Info[i].tunnel_name);
    system(temp);
  }
}

/* ********** */
/* Set IPSec  */
/* ********** */
setipsec(int mode, int switchs)   //mode = -1,reset,_hھindexh@reset
{
  int i;
  FILE *fp;
  char pid[10];
  char temp[80];
  ACONFIG * ACONF;
  ACONF = (ACONFIG *)OFFSET;

  if(switchs == 1)
  {
    if(ACONF->ipsec.if_enable_ipsec == 1)
    {
      /* ********************* */
      /* setup ipsec interface */
      /* ********************* */
      if(mode == -1) //OPEN ALL
      {
        system("/usr/local/lib/ipsec/tncfg --attach --virtual ipsec0 --physical eth1");
        sprintf(temp,"ifconfig ipsec0 %d.%d.%d.%d netmask %d.%d.%d.%d",
                     ACONF->local.rhip[0],
                     ACONF->local.rhip[1],
                     ACONF->local.rhip[2],
                     ACONF->local.rhip[3],
                     ACONF->local.rhnm[0],
                     ACONF->local.rhnm[1],
                     ACONF->local.rhnm[2],
                     ACONF->local.rhnm[3]);

        /* *********************** */
        /* setup ipsec connections */
        /* *********************** */
        for(i = 0;i<MAX_NUMBER_OF_TUNNELS;i++)
        {
      	  if(ACONF->ipsec.Tunnel_Info[i].tunnel_name != NULL)
      	  {
            if(ACONF->ipsec.Tunnel_Info[i].type_of_key_method == 0) //IKE
            {
              /* ******************** */
              /* setup ike connection */
              /* ******************** */
 	      setike(i,1);
            }
            else if(ACONF->ipsec.Tunnel_Info[i].type_of_key_method == 1)
            {
              /* *********************** */
              /* setup manual connection */
              /* *********************** */
      	      setmanual(i,1);
            }
          }
        }
      }
      else  //mode != -1
      {
      	if(ACONF->ipsec.Tunnel_Info[mode].tunnel_name != NULL)
      	{
          if(ACONF->ipsec.Tunnel_Info[mode].type_of_key_method == 0) //IKE
          {
            /* ******************** */
            /* setup ike connection */
            /* ******************** */
 	    setike(mode,1);
          }
          else if(ACONF->ipsec.Tunnel_Info[mode].type_of_key_method == 1)
          {
            /* *********************** */
            /* setup manual connection */
            /* *********************** */
      	    setmanual(mode,1);
          }
        }
      }
      /* ********** */
      /* open pluto */
      /* ********** */
      system("/bin/pluto --nofork &");
      system("/bin/whack --listen");
    }
    else
    {
      goto stop_ipsec;
    }
  }
  else /* close ipsec */
  {
stop_ipsec:

    /* *********** */
    /* close pluto */
    /* *********** */
    fp = fopen("/var/run/pluto.pid","w");
    fgets(pid,10,fp);
    fclose(fp);
    sprintf(temp,"kill %s",pid);
    system(temp);

    /* ************************** */
    /* shutdowm ipsec connections */
    /* ************************** */
    if(mode == -1)
    {
      for(i = 0;i<MAX_NUMBER_OF_TUNNELS;i++)
      {
        if(ACONF->ipsec.Tunnel_Info[i].tunnel_name != NULL)
        {
          if(ACONF->ipsec.Tunnel_Info[i].type_of_key_method == 0) //IKE
          {
 	    setike(i,0);
          }
          else if(ACONF->ipsec.Tunnel_Info[i].type_of_key_method == 1)
          {
      	    setmanual(i,0);
          }
        }
      }
      /* ************************ */
      /* shutdown ipsec interface */
      /* ************************ */
      system("ifconfig ipsec0 down");
      system("/usr/local/lib/ipsec/tncfg --dttach --virtual ipsec0 --physical eth1");
    }
    else //mode != -1
    {
      if(ACONF->ipsec.Tunnel_Info[mode].tunnel_name != NULL)
      {
        if(ACONF->ipsec.Tunnel_Info[mode].type_of_key_method == 0) //IKE
        {
          setike(mode,0);
        }
        else if(ACONF->ipsec.Tunnel_Info[mode].type_of_key_method == 1)
        {
      	  setmanual(mode,0);
        }
      }
    }
  }
}



/* ********** */
/* set boot   */
/* ********** */

int setboot(int act)
{
	FILE *fd;
	ACONFIG * ACONF;
	ACONF = (ACONFIG *)OFFSET;
	close(2);

	// --- create linked file "/var/config/ip.conf" for "/etc/resolv.conf" ---
	fd = fopen("/var/config/ip.conf", "w");
	fclose(fd);
	// --- End ---

	setpppd(1);
	setlan(1);
	setwan(1);
	setdhcpd(1);
	setnat(1);
	setvserver(1);
	setdmz(1);
	setspap(1);
	saveIPinfo(ACONF);
	if(ACONF->pptp.enable==1)
		setpptpd(1);
	system("l2tpd_conf");
	system("l2tpd");
	setids(1);
	//setipsec(-1,1);
	if(ACONF->mailalert.enable==1)
		setsend(1);
	return 0;
}



