/*  
 * 02/08/06 midified by Max from mtd_debug.c
 *    
 * usage:      
 *
 *   read:
 *     fd = open("/dev/mtd0", O_SYNC | O_RDONLY);
 *     flash_to_ptr (fd, offset, len, ptr);
 *     close(fd);
 *
 *   write:
 *     fd = open("/dev/mtd0", O_SYNC | O_RDWR);
 *     erase_flash (fd, offset, bytes);
 *     ptr_to_flash (fd, offset, len, ptr);      
 *     close(fd);
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <linux/mtd/mtd.h>

static int memerase (int fd,struct erase_info_user *erase)
{
   return (ioctl (fd,MEMERASE,erase));
}

int erase_flash (int fd,u_int32_t offset,u_int32_t bytes)
{
   int err;
   struct erase_info_user erase;
   erase.start = offset;
   erase.length = bytes;
   err = memerase (fd,&erase);
   if (err < 0)
   {
      perror ("MEMERASE");
      return (1);
   }
   return (0);
}

int flash_to_ptr (int fd, u_int32_t offset, size_t len, u_int8_t *ptr)
{
   int err;
   if (offset != lseek (fd, offset, SEEK_SET))
   {
      perror ("lseek()");
      return (1);
   }
   err = read (fd, ptr, len);
   if (err < 0)
   {
      perror ("read()");
      return (1);
   }
   return (0);
}

int ptr_to_flash (int fd, u_int32_t offset, u_int32_t len, u_int8_t *ptr)
{
   int err;
   if (offset != lseek (fd,offset,SEEK_SET))
   {
      perror ("lseek()");
      return (1);
   }
   err = write (fd, ptr, len);
   if (err < 0)
   {
      perror ("write()");
      return (1);
   }
   return (0);
}
