#include<stdio.h>
#include<signal.h>
#include<string.h>
#include "usercfg.h"
//---write flash
#include <fcntl.h>
#include <getopt.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <linux/config.h>
//--define L2TP
#define L2TPSFROM a->l2tpd.lns.local_ip[0],a->l2tpd.lns.local_ip[1],a->l2tpd.lns.local_ip[2],a->l2tpd.lns.ip_range_from
#define L2TPSTO a->l2tpd.lns.local_ip[0],a->l2tpd.lns.local_ip[1],a->l2tpd.lns.local_ip[2],a->l2tpd.lns.ip_range_to
#define L2TPSIP a->l2tpd.lns.local_ip[0],a->l2tpd.lns.local_ip[1],a->l2tpd.lns.local_ip[2],a->l2tpd.lns.local_ip[3]
#define L2TPSNO1 a->l2tpd.lns.no_lac[0].ip[0],a->l2tpd.lns.no_lac[0].ip[1],a->l2tpd.lns.no_lac[0].ip[2],a->l2tpd.lns.no_lac[0].ip[3]
#define L2TPSNO2 a->l2tpd.lns.no_lac[1].ip[0],a->l2tpd.lns.no_lac[1].ip[1],a->l2tpd.lns.no_lac[1].ip[2],a->l2tpd.lns.no_lac[1].ip[3]
#define L2TPSNO3 a->l2tpd.lns.no_lac[2].ip[0],a->l2tpd.lns.no_lac[2].ip[1],a->l2tpd.lns.no_lac[2].ip[2],a->l2tpd.lns.no_lac[2].ip[3]
#define L2TPCLIST a->l2tpd.lac[i].peer[0],a->l2tpd.lac[i].peer[1],a->l2tpd.lac[i].peer[2],a->l2tpd.lac[i].peer[3]
//---L2TP status
#define L2TP_STATE_FILE "/var/run/l2tp-status"
#define L2TP_AUTHNAME_FILE "/var/run/l2tp-lac-authname"
//---SAVE IP info
#define IP_INFO_FILE "/var/config/host.arg"
//---FindGW
#define ROUTE_PATH	"/proc/net/route"
#define GW_PATH		"/var/config/gw.conf"
//---static DNS file
#define DNS_INFO_FILE "/var/config/dns.conf"
int read_Aconfig(ACONFIG *);//read struct from flash
int write_Aconfig(ACONFIG *);//write struct to flash
int reset_Default(ACONFIG *);//set the struct with default value
int userMainMenu(ACONFIG *);//show the User's Main Menu
int adminMainMenu(ACONFIG *);//show the Administrator's Main Menu
int status(ACONFIG *);//get the system status function
int login(ACONFIG *);//authenticate the user
int toolbox(ACONFIG *);//administrator't Toolbox
int primarySetup(ACONFIG *);//primary setup
int dhcpServer(ACONFIG *);//DHCP Server setting
int virtualServer(ACONFIG *);//Virtual Server setting
int specialApplications(ACONFIG *);//Special Applications setting
int accessControl(ACONFIG *);//Access control seeting
int miscellancous(ACONFIG *);//Miscellancouns Items
int pppdMenu(ACONFIG *);//pppd Main Menu
int pptpMenu(ACONFIG *);//pptp Main Menu
int reboot(void);//Toolbox ->'R' reboot
int lanIpSet(ACONFIG *);//Primary Setup->(1) LAN IP Address seting
int wanType(ACONFIG *);//Primary Setup->(2) WAN Type
int wanTypeStatic(ACONFIG *);//Primary Setup->(2) WAN Type (1)-> Static IP Address
int wanTypePPPoE(ACONFIG *);//Primary Setup->(2) WAN Type (3)-> PPPoE Setting
int pptpClient(ACONFIG *);//pptp Client setting
int vpnStatus(ACONFIG *);
int l2tpdMainMenu(ACONFIG *);//L2TP Server setting
int idsMainMenu(ACONFIG *);//IDS Setting
int getIP(char *, BYTE *);//get IP from user to structure
int getPort(char *, WORD *);//get Port from user to structure
int getIPrange(char *, BYTE *);//get 1 BYTE of IP
int actlDefaultGroup(ACONFIG *);//Access Control -> Default Group
int actlGroup(int , ACONFIG *);//Access Control -> Group 1~3
int actlShowStr(char *, char , int , ACONFIG *);//Access Control, read the rule of IP or Port to show as String
void acparser(char *, char , int, ACONFIG *);
int l2tpStatus(void);//Read L2TP state from file then save in VPN structure
int ipinfo(char *, ip_info_struct *);
int urlblockMainMenu(ACONFIG *);//ids -> http url block
int urlblocklist(ACONFIG *);//ids -> http url block -> url list
int saveIPinfo(ACONFIG *);
int htoi_GW(char *, int);//used by findGW
int findGW(ip_info_struct *);//find Getway
int virusScanMainMenu(ACONFIG * );//ids ->virus scan
int viruslist(ACONFIG *);//ids-> virus scan -> virus list
int dnsMainMenu(ACONFIG * );//ids-> dns scan
int mscriptMainMenu(ACONFIG * );//ids-> malicious script
int sendalertmail(ACONFIG * );//Administrator -> send alert mail main menu
int alerttablelist(ACONFIG *);//Adminicstrator -> send alert mail -> alert table list
//---creat VPN structure
VPN_struct vpn;
//---End
char *topLine=	"=================================================================================\n";
char *line=	"\t+-----------------------------------------------------------------------+\n";
char pptpc_state[5];//to save what pptp client connected
/*-----main-----*/

int main(int argc,char* argv[])
{
	int logIn=0;//default not log in.
	int i;
	char command[80],ch;

        ACONFIG memACONF;
        ACONFIG *ACONF;
        ACONF = &memACONF;
        read_Aconfig(ACONF);
               
	if(argc != 2)
	{
		printf("USAGE: ed <option num>\noption num: 1 - normal booting,\n            else - do nothing.\n");
		return;
	}
	//---pptpc
	for(i=0;i<5;i++)
		pptpc_state[i]=0;

//bishan boot
	if(strcmp(argv[1],"1")==0) {
		setboot(1);
		return;
	}
	
	//---init vpn connection
	for(i=0;i<5;i++)
	{
		vpn.connections[i].type=0;
		vpn.connections[i].enable=0;
		vpn.connections[i].ip[0]='\0';
		vpn.connections[i].name[0]='\0';
		vpn.connections[i].pswd[0]='\0';
	}
	//system("clear");
	while(1)
	{
		system("clear");
		/*
		if(logIn)
			logIn=adminMainMenu();
		else
			logIn=userMainMenu();
		*/
		//----test----
		if(logIn)
			logIn=adminMainMenu(&memACONF);
		else if((i=userMainMenu(&memACONF))==3)
			break;
		else
			logIn=i;
		//----End test----
	}
	return 0;
}
/*-----End main-----*/

/*-----Read struct from flash-----*/
int read_Aconfig(ACONFIG *a )
{
  int fd = 0;
  u_int32_t offset = 0x8000;
  int err = 0;
  fd = open("/dev/mtd0", O_SYNC | O_RDONLY);
  /* check the project's memory map for 16*/
  flash_to_ptr(fd, offset+16, sizeof(ACONFIG), (unsigned char *)a);
  close(fd);
  return 0;    
}
/*-----End Read struct from flash-----*/

/*-----Write struct to flash-----*/
int write_Aconfig(ACONFIG * a)
{
  int fd = 0;
  u_int32_t offset = 0x8000;
  int err = 0;
  fd = open("/dev/mtd0", O_SYNC | O_RDWR);
  erase_flash(fd, offset, 32768);
  close(fd);
  fd = open("/dev/mtd0", O_SYNC | O_RDWR);
  err = ptr_to_flash(fd, offset+16, sizeof(ACONFIG), (unsigned char *)a);  
  close(fd);
  return 0;
}
/*-----End Write struct to flash-----*/

int reset_Default(ACONFIG * a)
{
	int i,j;
    /* (8) header of configuration data */
	strcpy(a->header.ver,"1.0");
	a->header.chksum=0;
	a->header.size=32752;
    /* (64) local configuration */
	a->local.ip[0]=192;
	a->local.ip[1]=168;
	a->local.ip[2]=15;
	a->local.ip[3]=2;
	strcpy(a->local.host,"Amit");
	strcpy(a->local.pass,"12345678");
	a->local.wip[0]=192;//WAN IP
	a->local.wip[1]=168;
	a->local.wip[2]=16;
	a->local.wip[3]=2;
	a->local.wgw[0]=192;//WAN Gateway
	a->local.wgw[1]=168;
	a->local.wgw[2]=16;
	a->local.wgw[3]=1;
	a->local.wnm[0]=255;//WAN netmask
	a->local.wnm[1]=255;
	a->local.wnm[2]=255;
	a->local.wnm[3]=0;
	a->local.rhip[0]=192;//local ip
	a->local.rhip[1]=168;
	a->local.rhip[2]=15;
	a->local.rhip[3]=2;
	a->local.rhnm[0]=192;//DNS 1
	a->local.rhnm[1]=168;
	a->local.rhnm[2]=15;
	a->local.rhnm[3]=1;
	a->local.uwid[0]=255;//Lan netmask(succ)
	a->local.uwid[1]=255;
	a->local.uwid[2]=255;
	a->local.uwid[3]=0;
	a->local.uwid[4]=0;//???
	a->local.uwid[5]=0;//???
	a->local.wflag=0;//DMZ host enable
	a->local.wtype=0;//WAN type
	a->local.dmz_host=119;//DMZ host
	a->local.adm_to=0;
	a->local.buivar=0;
	a->local.wtypex=0;//renew ip (primary setup)
    /* (16) DHCP server*/
	a->dhcps.resv=0;
	a->dhcps.enable=0;//on/off
	a->dhcps.default_lease_time=600;//DHCP server
	a->dhcps.max_lease_time=7200;//DHCP server
	a->dhcps.start=10;//start_range
	a->dhcps.end=20;//end_range
	a->dhcps.dns[0]=168;
	a->dhcps.dns[1]=95;
	a->dhcps.dns[2]=1;
	a->dhcps.dns[3]=1;
    /* (8) pptp*/
	a->pptp.localIP[0]=192;
	a->pptp.localIP[1]=168;
	a->pptp.localIP[2]=0;
	a->pptp.localIP[3]=1;
	a->pptp.start=10;
	a->pptp.end=20;
	a->pptp.enable=0;
	a->pptp.resv=0;
    /* (132) pppd*/
	strcpy(a->pppd.name1,"Name1");
	strcpy(a->pppd.pass1,"Pass1");
	strcpy(a->pppd.name2,"Name2");
	strcpy(a->pppd.pass2,"Pass2");
	strcpy(a->pppd.name3,"Name3");
	strcpy(a->pppd.pass3,"Pass3");
	strcpy(a->pppd.name4,"Name4");
	strcpy(a->pppd.pass4,"Pass4");
	a->pppd.pap=0;
	a->pppd.chap=0;
	a->pppd.mschap=0;
	a->pppd.mschap2=0;
    /* (8) remote host*/
	a->remote_host.ip[0]=0;
	a->remote_host.ip[1]=0;
	a->remote_host.ip[2]=0;
	a->remote_host.ip[3]=0;
	a->remote_host.enable=0;
	a->remote_host.resv[0]=0;
	a->remote_host.resv[1]=0;
	a->remote_host.resv[2]=0;
    /* (400) access control 2 for linux*/
	for(i=0;i<4;i++)
	{
		a->actl2[i].flag=0;//enable
		a->actl2[i].resv[0]=0;//reserve
		a->actl2[i].resv[1]=0;
		a->actl2[i].resv[2]=0;
		for(j=0;j<16;j++)
		{
			a->actl2[i].ip[j].sip=0;//ip start
			a->actl2[i].ip[j].eip=0;//ip end
			a->actl2[i].port[j].sp=0;//port start
			a->actl2[i].port[j].ep=0;//port end
		}
	}
    /* (544) reserved */
       for(i=0;i<544;i++)
                a->resv544[i]=0;
    /* (512) ip flag */
    	for(i=0;i<256;i++)
    		a->flag.val[i]=0;
#ifdef SIP
    /* (64) 16*4 lan */
	for(i=0;i<4;i++)
	{
		a->lan[0].baud=0;
		strcpy(a->lan[0].resv,"00000000000");
	}
#else
    /* (64) dhcp */
	strcpy(a->dhcp.domain,"");
	strcpy(a->dhcp.resv1,"");
	a->dhcp.netmask[0]=255;
	a->dhcp.netmask[1]=255;
	a->dhcp.netmask[2]=255;
	a->dhcp.netmask[3]=0;
	a->dhcp.enable=0;
	a->dhcp.range[0]=0;
	a->dhcp.range[1]=0;
	a->dhcp.resv2=0;
	strcpy(a->dhcp.gwip,"000");
#endif
    /* (156) 6*26, server mapping */
	for(i=0;i<SMAP_NUM;i++)/* 26 */
	{
		a->smap[i].port=0;
		a->smap[i].uport=0;
		a->smap[i].host=0;
		a->smap[i].flag=0;
	}
    /* (384) 8*16+4*64, special application */
	for(i=0;i<SPAP_NUM;i++)/* 16 */
	{
		a->spap.trig[i].port=0;// special AP trigger port
		a->spap.trig[i].downcount=0;
		a->spap.trig[i].sp0=0;
		a->spap.trig[i].sp1=0;
		a->spap.trig[i].flag=0;// special AP enable
		a->spap.trig[i].host=0;
	}
	for(i=0;i<SPAP_SEPL_NUM;i++)/* 64, Subsequence Enable Port List */
	{
		a->spap.sepl[i].lb=0;// special AP lower bound
		a->spap.sepl[i].ub=0;// special AP upper bound
	}
    /* (576) (8+2*32)*8, access control */
	for(i=0;i<AGRP_NUM;i++)/*8*/
	{
		a->actl.agrp[i].type=0;
		a->actl.agrp[i].count=0;
		for(j=0;j<AGRP_PORTS;j++)/*32*/
			a->actl.agrp[i].ports[j]=0;
		a->actl.agrp[i].resv[0]=0;
		a->actl.agrp[i].resv[1]=0;
		a->actl.agrp[i].resv[2]=0;
		a->actl.agrp[i].resv[3]=0;
		a->actl.agrp[i].resv[4]=0;
		a->actl.agrp[i].resv[5]=0;
	}
    /* (256) access point */
	for(i=0;i<26;i++)
		a->apnt.zn[i]=0;/*network id*/
	for(i=0;i<39;i++)
		a->apnt.zn_resv[i]=0;
	a->apnt.zc=0;/*channel*/
	for(i=0;i<4;i++)
		a->apnt.zi[i]=0;/*ip address*/
	a->apnt.zs=0;/*security*/
	for(i=0;i<5;i++)
		a->apnt.zk[i]=0;/*security key*/
	for(i=0;i<27;i++)
		a->apnt.zk_resv[i]=0;
	a->apnt.ya=0;/*access control enable or disable*/
	a->apnt.yan=0;/*exist access control numbers already*/
	for(i=0;i<4;i++)
		for(j=0;j<6;j++)
			a->apnt.yg[i][j]=0;/*granted MACs*/
	for(i=0;i<6;i++)
		for(j=0;j<6;j++)
			a->apnt.yg_resv[6][6]=0;
	a->apnt.ygs;/*whether user input MACs or not for granting access control*/
	for(i=0;i<4;i++)
		for(j=0;j<6;j++)
			a->apnt.yd[4][6]=0;/*denied MACs*/
	for(i=0;i<6;i++)
		for(j=0;j<6;j++)
			a->apnt.yd_resv[6][6]=0;
	a->apnt.yds=0;/*whether user input MACs or not for denying access control*/
	a->apnt.yo=0;/*grant or deny other stations*/
	for(i=0;i<6;i++)
		a->apnt.mac[i]=0;
	a->apnt.broadcast=0;
	for(i=0;i<21;i++)
		a->apnt.resv[i];
    /* (520) 8+8*64 properties of MAC */
	a->pmac.flag=0;
	for(i=0;i<6;i++)
		a->pmac.resv[i]=0;
	for(i=0;i<PMAC_NUM;i++)
	{
		for(j=0;j<6;j++)
			a->pmac.list[i].mac[j]=0;
		a->pmac.list[i].ip=0;
		a->pmac.list[i].prop=0;
	}
    /* (64) 6*5+34 local3 */
	for(i=0;i<5;i++)
	{
		for(j=0;j<4;j++)
			a->local3.mnat[i].gip[j]=0;
		a->local3.mnat[i].lip=0;
		a->local3.mnat[i].flag=0;
	}
	for(i=0;i<26;i++)
		a->local3.resv[i]=0;
	a->local3.acct[0]=0;
	a->local3.acct[1]=0;
	a->local3.wolmac[0]=0;
	a->local3.wolmac[1]=0;
	a->local3.wolmac[2]=0;
	a->local3.wolmac[3]=0;
	a->local3.wolmac[4]=0;
	a->local3.wolmac[5]=0;
	for(i=0;i<(500-64);i++)
		a->resv[i]=0;
    /* (1536) 256x6, isp configuration */
	for(i=0;i<6;i++)
	{
		for(j=0;j<16;j++)
			a->acctpool[i].desc[j]=0;
		for(j=0;j<54;j++)
			a->acctpool[i].user[j]=0;
		a->acctpool[i].flag=0;
		for(j=0;j<24;j++)
			a->acctpool[i].pass[j]=0;
		for(j=0;j<32;j++)
			a->acctpool[i].tel[j]=0;
		for(j=0;j<2;j++)
		{
			a->acctpool[i].dns[j].ip[0]=0;
			a->acctpool[i].dns[j].ip[1]=0;
			a->acctpool[i].dns[j].ip[2]=0;
			a->acctpool[i].dns[j].ip[3]=0;
		}
		a->acctpool[i].ip[0]=0;
		a->acctpool[i].ip[1]=0;
		a->acctpool[i].ip[2]=0;
		a->acctpool[i].ip[3]=0;
		a->acctpool[i].baud=0;
		a->acctpool[i].mtu=0;
		a->acctpool[i].to=0;
		for(j=0;j<82;j++)
			a->acctpool[i].init[j]=0;
		for(j=0;j<26;j++)
			a->acctpool[i].resv[j]=0;
	}
    /* (116) L2tpd*/
    	a->l2tpd.lns.ip_range_from=11;
	a->l2tpd.lns.ip_range_to=21;
	a->l2tpd.lns.local_ip[0]=192;
	a->l2tpd.lns.local_ip[1]=168;
	a->l2tpd.lns.local_ip[2]=1;
	a->l2tpd.lns.local_ip[3]=1;
	for(i=0;i<3;i++)
		for(j=0;j<4;j++)
			a->l2tpd.lns.no_lac[i].ip[j]=0;
	strcpy(a->l2tpd.lns.name,"");
	for(i=0;i<5;i++)
	{
		for(j=0;j<4;j++)
			a->l2tpd.lac[i].peer[j]=0;
		strcpy(a->l2tpd.lac[i].name,"");
		strcpy(a->l2tpd.lac[i].pswd,"");
	}
   /* (120) pptpc */
   	for(i=0;i<5;i++)
	{
		strcpy(a->pptpc[i].name,"");
		strcpy(a->pptpc[i].pswd,"");
		a->pptpc[i].ip[0]=0;
		a->pptpc[i].ip[1]=0;
		a->pptpc[i].ip[2]=0;
		a->pptpc[i].ip[3]=0;
		a->pptpc[i].resv[0]=0;
		a->pptpc[i].resv[1]=0;
	}
   /*(4) IDS */
   	a->ids.flag[0]=0;
	a->ids.flag[1]=0;
	a->ids.flag[2]=0;
	a->ids.flag[3]=0;
	//(8004)url block
	a->ids.urlblock.flag=0;
	a->ids.urlblock.resv=0;
	a->ids.urlblock.proxy=0;
	for(i=0;i<100;i++)
		a->ids.urlblock.url[i].string[0]=0;
	//(4200)virus pattern
	for(i=0;i<50;i++)
	{
		a->ids.virus[i].protocol=0;
		a->ids.virus[i].port=1;
		a->ids.virus[i].pattern[0]=0;
	}
	//(8)dns scan
	a->ids.dns_scan.wan_dns[0]=0;
	a->ids.dns_scan.wan_dns[1]=0;
	a->ids.dns_scan.wan_dns[2]=0;
	a->ids.dns_scan.wan_dns[3]=0;
	a->ids.dns_scan.lan_dns=0;
	//(4)malicious script
	a->ids.mscript_proxy=0;
	//(8000)80*100 mail address block
	for(i=0;i<100;i++)
		a->ids.mailblock[i].string[0]=0;
	//(4)mail bomb2 mail flow block
	a->ids.mbomb2.total_sender=1000;
	a->ids.mbomb2.total_mails=2000;
	//(1044)send alert mail
	a->mailalert.enable=0;
	a->mailalert.mail_from[0]=0;
	a->mailalert.list[0].mail_to[0]=0;
	a->mailalert.list[1].mail_to[0]=0;
	a->mailalert.list[2].mail_to[0]=0;
	//alert table
	a->mailalert.alert_table[0].lognum=101;
	a->mailalert.alert_table[0].emergency=0;
	strcpy(a->mailalert.alert_table[0].logname,"ping of death");
	a->mailalert.alert_table[1].lognum=102;
	a->mailalert.alert_table[1].emergency=0;
	strcpy(a->mailalert.alert_table[1].logname,"tear drop");
	a->mailalert.alert_table[2].lognum=103;
	a->mailalert.alert_table[2].emergency=0;
	strcpy(a->mailalert.alert_table[2].logname,"ping flood");
	a->mailalert.alert_table[3].lognum=104;
	a->mailalert.alert_table[3].emergency=0;
	strcpy(a->mailalert.alert_table[3].logname,"smurf");
	a->mailalert.alert_table[4].lognum=201;
	a->mailalert.alert_table[4].emergency=0;
	strcpy(a->mailalert.alert_table[4].logname,"port scan");
	a->mailalert.alert_table[5].lognum=202;
	a->mailalert.alert_table[5].emergency=0;
	strcpy(a->mailalert.alert_table[5].logname,"fraggle");
	a->mailalert.alert_table[6].lognum=203;
	a->mailalert.alert_table[6].emergency=0;
	strcpy(a->mailalert.alert_table[6].logname,"snork");
	a->mailalert.alert_table[7].lognum=204;
	a->mailalert.alert_table[7].emergency=0;
	strcpy(a->mailalert.alert_table[7].logname,"land attack");
	a->mailalert.alert_table[8].lognum=205;
	a->mailalert.alert_table[8].emergency=0;
	strcpy(a->mailalert.alert_table[8].logname,"udp bomb");
	a->mailalert.alert_table[9].lognum=206;
	a->mailalert.alert_table[9].emergency=0;
	strcpy(a->mailalert.alert_table[9].logname,"DNS scan");
	a->mailalert.alert_table[10].lognum=207;
	a->mailalert.alert_table[10].emergency=0;
	strcpy(a->mailalert.alert_table[10].logname,"ICMP unreachable");
	a->mailalert.alert_table[11].lognum=301;
	a->mailalert.alert_table[11].emergency=0;
	strcpy(a->mailalert.alert_table[11].logname,"URL blocking");
	a->mailalert.alert_table[12].lognum=302;
	a->mailalert.alert_table[12].emergency=0;
	strcpy(a->mailalert.alert_table[12].logname,"malicious script");
	a->mailalert.alert_table[13].lognum=303;
	a->mailalert.alert_table[13].emergency=0;
	strcpy(a->mailalert.alert_table[13].logname,"illegal mail sender");
	a->mailalert.alert_table[14].lognum=304;
	a->mailalert.alert_table[14].emergency=0;
	strcpy(a->mailalert.alert_table[14].logname,"virus scan");
	a->mailalert.alert_table[15].lognum=305;
	a->mailalert.alert_table[15].emergency=0;
	strcpy(a->mailalert.alert_table[15].logname,"mail flow control");
	for(i=16;i<20;i++)
	{
		a->mailalert.alert_table[i].lognum=0;
		a->mailalert.alert_table[i].emergency=0;
		strcpy(a->mailalert.alert_table[i].logname,"");
	}
	//----PPPoE
	a->pppoe.id[0]=0;
	a->pppoe.passwd[0]=0;
	for(i=0;i<4;i++)
	{
		a->pppoe.dns1[i]=0;
		a->pppoe.dns2[i]=0;
	}
	a->pppoe.timeout=0;
	a->pppoe.resv[0]=0;
	a->pppoe.resv[1]=0;
	//----
	return 0;
}
/*-----End reset default value-----*/

/*-----User Main Menu-----*/
int userMainMenu(ACONFIG *a)
{
	int i;
	char *user_main_menu[7]={	"================================================================================",
					"\t\t\t\tUser's Main Menu",
					"================================================================================",
					"",
					"\t\t(1)Status",
					"\t\t(2)Log in",
					"\tPlease enter your choice. (1~2)",
				};
	char command[80],ch;
	ip_info_struct ife;
	while(1)
	{
		system("clear");
		for(i=0; i<7; i++)
			printf("%s\n",user_main_menu[i]);

		fgets(command,80,stdin);
		command[strlen(command)-1]=0;
		if(!strcmp(command,"prompt 13"))
		{
			return 3;
		}
		if(strlen(command)!=1)
			continue;
		ch=command[0];
		switch (ch){
		case '1':
			status(a);
			break;
		case '2':
			return(login(a));
			break;
		//---test----
		case '3':
			if(ipinfo("eth1", &ife))
			{
			printf("     name=%s\n",ife.name);
			printf("     ip=%d.%d.%d.%d\n",ife.ip[0],ife.ip[1],ife.ip[2],ife.ip[3]);
			printf("     bcast=%d.%d.%d.%d\n",ife.bcast[0],ife.bcast[1],ife.bcast[2],ife.bcast[3]);
			printf("     mask=%d.%d.%d.%d\n",ife.mask[0],ife.mask[1],ife.mask[2],ife.mask[3]);
			printf("     HWaddr=%s\n",ife.HWaddr);
			}
			getchar();
			break;
		case '4':
			read_Aconfig(a);
			break;	
		case '5':
			write_Aconfig(a);
			break;
		case '6':
			printf("passwd: %s", a->local.pass);		
			break;
		case '7':
			reset_Default(a);
			break;	
		//---test----	
		case 'Y':
			reset_Default(a);
			write_Aconfig(a);
			read_Aconfig(a);
			break;
		case 'z':
			printf("size of ACONFIG=%d\n",sizeof(ACONFIG));
			getchar();
			break;
		//case 'p':
		//	printf("%s\n",command);
		//	getchar();
		//	if(!strcmp(command,"prompt 13"))
		//	{
		//		return 3;//exit the main program (for test)
		//	}
		//---End test---
		default:
			continue;
		};
	}
	return 0;
}
/*-----End User Main Menu-----*/

/*-----Administrator's Main Menu-----*/
int adminMainMenu(ACONFIG *a)
{
	int i;
	char *admin_main_menu[21]={	"================================================================================",
					"\t\t\t\tAdministrator's Main Menu",
					"================================================================================",
					"\t\t(1)Status",
					"\t\t(2)Toolbox",
					"\t\t(3)Primary Setup",
					"\t\t(4)DHCP Server",
					"\t\t(5)Virtual Server",
					"\t\t(6)Special Applications",
					"\t\t(7)Access Control",
					"\t\t(8)Miscellancous Items",
					"\t\t(9)pppd",
					"\t\t(A)pptp server",
					"\t\t(B)pptp client",
					"\t\t(C)VPN status",
					"\t\t(D)L2TP Setting",
					"\t\t(E)IDS Setting",
					"\t\t(F)Send Alert Mail",
					"\t\t(Y)Default Setting",
					"\t\t(Z)Save Setting",
					"\tPlease enter your choice. (1~E),or press 'b' to log out",
				};
	char command[80],ch;
	while(1)
	{
		system("clear");
		for(i=0; i<21; i++)
			printf("%s\n",admin_main_menu[i]);
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case '1':
			status(a);
			break;
		case '2':
			toolbox(a);
			break;
		case '3':
			primarySetup(a);
			break;
		case '4':
			dhcpServer(a);
			break;
		case '5':
			virtualServer(a);
			break;
		case '6':
			specialApplications(a);
			break;
		case '7':
			accessControl(a);
			break;
		case '8':
			miscellancous(a);
			break;
		case '9':
			pppdMenu(a);
			break;
		case 'A':
			pptpMenu(a);
			break;
		case 'B':
			pptpClient(a);
			break;
		case 'C':
			vpnStatus(a);
			break;
		case 'D':
			l2tpdMainMenu(a);
			break;
		case 'E':
			idsMainMenu(a);
			break;
		case 'F':
			sendalertmail(a);
			break;
		case 'Y':
			reset_Default(a);
			write_Aconfig(a);
			read_Aconfig(a);
			break;
		case 'Z':
			write_Aconfig(a);
			sleep(1);
			break;
		case 'b':
			system("clear");
			return 0;//log out
			break;
		default:
			continue;
		};
	}
	return 1;//still log in
}
/*-----End Administrator's Main Menu-----*/

/*-----Login-----*/
int login(ACONFIG * a)
{
	char *pwd;//old password in system
	char input[80];
	strcpy(pwd,a->local.pass);
	//printf("%s\n",pwd);
#ifdef PASSWORD
	//pwd="firewall";
#endif
	printf("\tPlease input Administrator't password\n");
	fgets(input,80,stdin);
	if(strlen(input)>1 && strlen(input)<=10)//because there is \n in the end of string.
	{
			input[strlen(input)-1]='\0';//replace the \n to \0
			if(!strcmp(pwd,input))
				return 1;//log in
	}
	return 0;//not log in 
}
/*-----End Login-----*/

/*-----System Status-----*/
int status(ACONFIG * a)
{
	char * leaseTime;
	char * ipAddress;
	char * subnetMask;
	char * gateway;
	char * dns;
	char * moden;
	char * printer;
	char * status_title="System Status";
	int i;
	char command[80],ch;
	ip_info_struct ife;
	//---test
	leaseTime="00";
	moden="no";
	printer="no";
	//---end test
	while(1)
	{
		if(a->local.wtype == 2)
		{
			if(!ipinfo("ppp0", &ife))
			{
				sleep(1);
				continue;
			}
		}
		else
		{
			if(!ipinfo("eth1", &ife))
			{
				sleep(1);
				continue;
				//printf("     bcast=%d.%d.%d.%d\n",ife.bcast[0],ife.bcast[1],ife.bcast[2],ife.bcast[3]);
				//printf("     HWaddr=%s\n",ife.HWaddr);
			}
		}
		findGW(&ife);
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",status_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\tIterm\t\t\tWAN Status\t\t\t\t|\n");
		printf("%s",line);
		//printf("\t|\tLease Time\t\t%-10s\t\t\t\t|\n",leaseTime);
		printf("\t|\tIP Address\t\t%3d.%3d.%3d.%3d\t\t\t\t|\n",ife.ip[0],ife.ip[1],ife.ip[2],ife.ip[3]);
		printf("\t|\tSubnet Mask\t\t%3d.%3d.%3d.%3d\t\t\t\t|\n",ife.mask[0],ife.mask[1],ife.mask[2],ife.mask[3]);
		printf("\t|\tGateway\t\t\t%3d.%3d.%3d.%3d\t\t\t\t|\n",ife.gw[0],ife.gw[1],ife.gw[2],ife.gw[3]);
		//printf("\t|\tGateway\t\t\t%3d.%3d.%3d.%3d\t\t\t\t|\n",a->local.wgw[0],a->local.wgw[1],a->local.wgw[2],a->local.wgw[3]);
		printf("\t|\tDomain Name Servers\t%3d.%3d.%3d.%3d\t\t\t\t|\n",a->local.rhnm[0],a->local.rhnm[1],a->local.rhnm[2],a->local.rhnm[3]);
		//printf("%s",line);
		//printf("\t|\tIterm\t\t\tPeripheral Status\t\t\t|\n");
		//printf("%s",line);
		//printf("\t|\tModen\t\t\t%-10s\t\t\t\t|\n",moden);
		//printf("\t|\tPrinter\t\t\t%-10s\t\t\t\t|\n",printer);
		printf("%s",line);
		//printf("   Please enter your choice (1~7),or press 'b' to back.\n");
		printf("\tPlease press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 'b':
			system("clear");
			return 1;
			break;
		default:
			continue;
		};
	}
	return 0;
}
/*-----End System Status-----*/

/*-----Toolbox-----*/
int toolbox(ACONFIG *a)
{
	char pwd[10];//old password in system
	char newPwd[10];
	char *toolbox_title="Administrator's Toolbox";
	char *vision;
	char *mac;
	char command[80],ch;
	int i;
	//---test
	vision="R1.70i";
	mac="00-50-:8-00-03-08";
	//---test end
	while(1)
	{
		system("clear");
		strcpy(pwd,a->local.pass);
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",toolbox_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\t(1)Change Administrator't Password\t\t\t\t|\n");
		printf("%s",line);
		printf("\t|\t(R)Save and Reboot\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\t|\tMiscellaneous Information & Commands\t\t\t\t|\n");
		printf("%s",line);
		printf("\t|\tFirmware version: %20s\t\t\t\t|\n",vision);
		printf("\t|\tWAN.s MAC Address:%20s\t\t\t\t|\n",mac);
		printf("%s",line);
		printf("\tPlease enter your choice (1), 'R' , or press 'b' to back\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case '1':
			printf("Old Password=");
			fgets(command,80,stdin);
			if(strlen(command)>1 && strlen(command)<=10)//because there is \n in the end of string.
			{
				command[strlen(command)-1]='\0';//replace the \n to \0
				if(!strcmp(pwd,command))
				{
					printf("New Password=");
					fgets(command,80,stdin);
					command[strlen(command)-1]='\0';//replace the \n to \0
					strcpy(newPwd,command);
					printf("Reconfirm   =");
					fgets(command,80,stdin);
					command[strlen(command)-1]='\0';//replace the \n to \0
					if(!strcmp(newPwd,command))//New password==Reconfirm
					{
						printf("New password OK!\n");
						strcpy(a->local.pass,newPwd);
						sleep(1);
					}
				}
			}
			break;
		case 'R':
			printf("Worning! this will reboot!\n");
			printf("press 'reboot' to make sure\n");
			fgets(command,80,stdin);
			if(strlen(command)==7)
			{
				command[strlen(command)-1]='\0';
				if(!strcmp(command,"reboot"))
				{
					reboot();
				}
			}
			break;
		case 'b':
			return(1);
			break;
		default:
			continue;
		};
	}
	return 0;
}
/*-----End Toolbox-----*/

/*-----Primary Setup-----*/
int primarySetup(ACONFIG *a)
{
	int wType;
	int renewIP;
	char *primary_setup_title="Primary Setup";
	int i;
	char command[80],ch;
	while(1)
	{
		renewIP=(int)a->local.wtypex;
		wType=(int)a->local.wtype;
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",primary_setup_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\tIterm\t\t\t\tSetting\t\t\t\t|\n");
		printf("%s",line);
		printf("\t|\t(1)LAN IP Address\t\t%3d.%3d.%3d.%3d\t\t\t|\n",a->local.rhip[0],a->local.rhip[1],a->local.rhip[2],a->local.rhip[3]);
		if(wType==0)
		{
			printf("\t|\t(2)WAN Type\t\t\tStatic IP Address\t\t|\n");
/* succ */
			printf("\t|\t(s)Save and Reset\t\t\t\t\t\t|\n");
/* succ */
			printf("%s",line);
			printf("\tPlease enter your choice (1~2),or press 'b' to back.\n");
		}
		else if(wType==1)
		{
			printf("\t|\t(2)WAN Type\t\t\tDynamic IP Address\t\t|\n");
			if(renewIP==1)
				printf("\t|\t(3)Renew IP Forever\t\tEnable\t\t\t\t|\n");
			else
				printf("\t|\t(3)Renew IP Forever\t\tDisable\t\t\t\t|\n");
/* succ */
			printf("\t|\t(s)Save and Reset\t\t\t\t\t\t|\n");
/* succ */
			printf("%s",line);
			printf("\tPlease enter your choice (1~3),or press 'b' to back.\n");
		}
		else
		{
			printf("\t|\t(2)WAN Type\t\t\tPPP over Ethernet\t\t|\n");
/* succ */
			printf("\t|\t(s)Save and Reset\t\t\t\t\t\t|\n");
/* succ */
			printf("%s",line);
			printf("\tPlease enter your choice (1~2),or press 'b' to back.\n");
		}
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
/* succ */
		case 's':
                        /* setlan(0);
                        setwan(0);
                        setdhcpd(0);
                        setnat(0);
                        setvserver(0);
			setdmz(0); */
                        write_Aconfig(a);
                        /* setlan(1); */
                        setwan(1);
                        /* setdhcpd(1);
                        setnat(1);
                        setvserver(1);
			setdmz(1); */
			//bishan
			//saveIPinfo(a);
                        break;
/* succ */
		case '1':
			lanIpSet(a);
			break;
		case '2':
			wanType(a);
			break;
		case '3':
			if(wType==1)
				a->local.wtypex=-1*(a->local.wtypex-1);
			break;
		case 'b':
			system("clear");
			return 1;
			break;
		default:
			continue;
		};
	}
	return 0;
}
/*-----End Primary Setup-----*/

/*-----DHCP Server-----*/
int dhcpServer(ACONFIG * a)
{
	int  dhcpServer,temp;
	char buf[4];
	char *ipPoolStart;
	char *ipPoolEnd;
	char *domainName;
	char *dhcp_title="DHCP Server";
	int i;
	char command[80],ch;
	while(1)
	{
		dhcpServer=(int)a->dhcps.enable;
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",dhcp_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\tIterm\t\t\t\tSetting\t\t\t\t|\n");
		printf("%s",line);
		if(dhcpServer==1)
			printf("\t|\t(1)DHCP Server\t\t\t\t Enable\t\t\t|\n");
		else
			printf("\t|\t(1)DHCP Server\t\t\t\tDisable\t\t\t|\n");
		printf("\t|\t(2)IP Pool Starting Address\t\t%3d.%3d.%3d.%3d\t\t|\n",a->local.rhip[0],a->local.rhip[1],a->local.rhip[2],a->dhcps.start);
		printf("\t|\t(3)IP Pool Ending Address\t\t%3d.%3d.%3d.%3d\t\t|\n",a->local.rhip[0],a->local.rhip[1],a->local.rhip[2],a->dhcps.end);
		printf("\t|\t(4)Domain Name Server\t\t\t%3d.%3d.%3d.%3d\t\t|\n",a->dhcps.dns[0],a->dhcps.dns[1],a->dhcps.dns[2],a->dhcps.dns[3]);
		printf("\t|\t(5)Default Lease Time\t\t\t%-10d\t\t|\n",a->dhcps.default_lease_time);
		printf("\t|\t(6)MAX Lease Time\t\t\t%-10d\t\t|\n",a->dhcps.max_lease_time);
/* succ */
		printf("\t|\t(s)Save and Reset\t\t\t\t\t\t|\n");
/* succ */
		printf("%s",line);
		printf("\tPlease enter your choice (1~6),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
/* succ */
		case 's':
			setdhcpd(0);
			write_Aconfig(a);
			setdhcpd(1);
			break;
/* succ */
		case '1':
			a->dhcps.enable=(BYTE)-1*(dhcpServer-1);
			break;
		case '2':
			printf("IP Pool Start:%d.%d.%d.",a->local.rhip[0],a->local.rhip[1],a->local.rhip[2]);
			fgets(command,80,stdin);
			getIPrange(command, &(a->dhcps.start));
			break;
		case '3':
			printf("IP Pool End:%d.%d.%d.",a->local.rhip[0],a->local.rhip[1],a->local.rhip[2]);
			fgets(command,80,stdin);
			getIPrange(command, &(a->dhcps.end));
			break;
		case '4':
			printf("Domain Name Server=");
			fgets(command,80,stdin);
			getIP(command, a->dhcps.dns);
			break;
		case '5':
			printf("Default lease time:");
			fgets(command,80,stdin);
			command[strlen(command)-1]='\0';
			temp=atoi(command);
			a->dhcps.default_lease_time=temp;
			break;
		case '6':
			printf("MAX lease time:");
			fgets(command,80,stdin);
			command[strlen(command)-1]='\0';
			temp=atoi(command);
			a->dhcps.max_lease_time=temp;
			break;
		case 'b':
			system("clear");
			return 1;
			break;
		default:
			continue;
		};
	}
	return 0;
}
/*-----End DHCP Server-----*/

/*-----Virtual Server-----*/

int virtualServer(ACONFIG * a)
{
	char *q="Service Port:";
	char *q2="Server IP:";
	char *virtual_server_title="Virtual Server";
	int i;
	char command[80],ch;
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",virtual_server_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|ID\tService Port\tServer IP\t\tStatus\t\t\t|\n");
		printf("%s",line);
		for(i=0;i<8;i++)
		{
			if(a->smap[i].flag==1)
				printf("\t|(%d)\t%-5d\t\t%3d.%3d.%3d.%-3d\t\t(%2d) Enable\t\t|\n",i+1,a->smap[i].port,a->local.rhip[0],a->local.rhip[1],a->local.rhip[2],a->smap[i].host,i+9);
			else
				printf("\t|(%d)\t%-5d\t\t%3d.%3d.%3d.%-3d\t\t(%2d)Disable\t\t|\n",i+1,a->smap[i].port,a->local.rhip[0],a->local.rhip[1],a->local.rhip[2],a->smap[i].host,i+9);
		}

				printf("\t|(s)Save and Reset\t\t\t\t\t\t\t|\n");

		printf("%s",line);
		printf("\tPlease enter your choice (1~G),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){

		case 's':
			setvserver(0);
			write_Aconfig(a);
			setvserver(1);
			break;

		case '1':
			printf("%s",q);
			fgets(command,80,stdin);
			getPort(command, &(a->smap[0].port));
			printf("%s%3d.%3d.%3d.",q2,a->local.rhip[0],a->local.rhip[1],a->local.rhip[2]);
			fgets(command,80,stdin);
			getIPrange(command, &(a->smap[0].host));
			break;
		case '2':
			printf("%s",q);
			fgets(command,80,stdin);
			getPort(command, &(a->smap[1].port));
			printf("%s%3d.%3d.%3d.",q2,a->local.rhip[0],a->local.rhip[1],a->local.rhip[2]);
			fgets(command,80,stdin);
			getIPrange(command, &(a->smap[1].host));
			break;
		case '3':
			printf("%s",q);
			fgets(command,80,stdin);
			getPort(command, &(a->smap[2].port));
			printf("%s%3d.%3d.%3d.",q2,a->local.rhip[0],a->local.rhip[1],a->local.rhip[2]);
			fgets(command,80,stdin);
			getIPrange(command, &(a->smap[2].host));
			break;
		case '4':
			printf("%s",q);
			fgets(command,80,stdin);
			getPort(command, &(a->smap[3].port));
			printf("%s%3d.%3d.%3d.",q2,a->local.rhip[0],a->local.rhip[1],a->local.rhip[2]);
			fgets(command,80,stdin);
			getIPrange(command, &(a->smap[3].host));
			break;
		case '5':
			printf("%s",q);
			fgets(command,80,stdin);
			getPort(command, &(a->smap[4].port));
			printf("%s%3d.%3d.%3d.",q2,a->local.rhip[0],a->local.rhip[1],a->local.rhip[2]);
			fgets(command,80,stdin);
			getIPrange(command, &(a->smap[4].host));
			break;
		case '6':
			printf("%s",q);
			fgets(command,80,stdin);
			getPort(command, &(a->smap[5].port));
			printf("%s%3d.%3d.%3d.",q2,a->local.rhip[0],a->local.rhip[1],a->local.rhip[2]);
			fgets(command,80,stdin);
			getIPrange(command, &(a->smap[5].host));
			break;
		case '7':
			printf("%s",q);
			fgets(command,80,stdin);
			getPort(command, &(a->smap[6].port));
			printf("%s%3d.%3d.%3d.",q2,a->local.rhip[0],a->local.rhip[1],a->local.rhip[2]);
			fgets(command,80,stdin);
			getIPrange(command, &(a->smap[6].host));
			break;
		case '8':
			printf("%s",q);
			fgets(command,80,stdin);
			getPort(command, &(a->smap[7].port));
			printf("%s%3d.%3d.%3d.",q2,a->local.rhip[0],a->local.rhip[1],a->local.rhip[2]);
			fgets(command,80,stdin);
			getIPrange(command, &(a->smap[7].host));
			break;
		case '9':
			a->smap[0].flag=-1*(a->smap[0].flag-1);
			break;
		case 'A':
			a->smap[1].flag=-1*(a->smap[1].flag-1);
			break;
		case 'B':
			a->smap[2].flag=-1*(a->smap[2].flag-1);
			break;
		case 'C':
			a->smap[3].flag=-1*(a->smap[3].flag-1);
			break;
		case 'D':
			a->smap[4].flag=-1*(a->smap[4].flag-1);
			break;
		case 'E':
			a->smap[5].flag=-1*(a->smap[5].flag-1);
			break;
		case 'F':
			a->smap[6].flag=-1*(a->smap[6].flag-1);
			break;
		case 'G':
			a->smap[7].flag=-1*(a->smap[7].flag-1);
			break;
		case 'b':
			return 0;
		default:
			continue;
		};
	}
	return 0;
}

/*-----End Virtual Server-----*/

/*-----Special Applications-----*/
int specialApplications(ACONFIG *a)
{
	char *q[3]={	"Trigger port:",
			"Incoming port range start:",
			"Incoming port range end:",
		   };
	char *special_ap_title="Special Applications";
	int i;
	char command[80],ch;
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",special_ap_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\tID\tTrigger\t\tIncoming Ports\t\tState\t\t|\n");
		printf("%s",line);
		for(i=0;i<4;i++)
		{
			if(a->spap.trig[i].flag==1)
				printf("\t|\t(%d)%6d\t\t%6d-%-6d\t\t(%d)Enable\t|\n",i+1,a->spap.trig[i].port,a->spap.sepl[i].lb,a->spap.sepl[i].ub,i+5);
			else
				printf("\t|\t(%d)%6d\t\t%6d-%-6d\t\t(%d)Disable\t|\n",i+1,a->spap.trig[i].port,a->spap.sepl[i].lb,a->spap.sepl[i].ub,i+5);
		}
/* succ */
				printf("\t|\t(s)Save and Reset\t\t\t\t\t\t|\n");
/* succ */
		printf("%s",line);
		printf("\tPlease enter your choice (1~4) to change,(5~8)to enable,or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
/* succ */
		case 's':
			setspap(0);
			write_Aconfig(a);
			setspap(1);
			break;
/* succ */
		case '1':
			printf("%s",q[0]);
			fgets(command,80,stdin);
			getPort(command,&(a->spap.trig[0].port));
			printf("%s",q[1]);
			fgets(command,80,stdin);
			getPort(command,&(a->spap.sepl[0].lb));
			printf("%s",q[2]);
			fgets(command,80,stdin);
			getPort(command, &(a->spap.sepl[0].ub));
			break;
		case '2':
			printf("%s",q[0]);
			fgets(command,80,stdin);
			getPort(command,&(a->spap.trig[1].port));
			printf("%s",q[1]);
			fgets(command,80,stdin);
			getPort(command,&(a->spap.sepl[1].lb));
			printf("%s",q[2]);
			fgets(command,80,stdin);
			getPort(command, &(a->spap.sepl[1].ub));
			break;
		case '3':
			printf("%s",q[0]);
			fgets(command,80,stdin);
			getPort(command,&(a->spap.trig[2].port));
			printf("%s",q[1]);
			fgets(command,80,stdin);
			getPort(command,&(a->spap.sepl[2].lb));
			printf("%s",q[2]);
			fgets(command,80,stdin);
			getPort(command, &(a->spap.sepl[2].ub));
			break;
		case '4':
			printf("%s",q[0]);
			fgets(command,80,stdin);
			getPort(command,&(a->spap.trig[3].port));
			printf("%s",q[1]);
			fgets(command,80,stdin);
			getPort(command,&(a->spap.sepl[3].lb));
			printf("%s",q[2]);
			fgets(command,80,stdin);
			getPort(command, &(a->spap.sepl[3].ub));
			break;
		case '5':
			a->spap.trig[0].flag=-1*(a->spap.trig[0].flag-1);
			break;
		case '6':
			a->spap.trig[1].flag=-1*(a->spap.trig[1].flag-1);
			break;
		case '7':
			a->spap.trig[2].flag=-1*(a->spap.trig[2].flag-1);
			break;
		case '8':
			a->spap.trig[3].flag=-1*(a->spap.trig[3].flag-1);
			break;
		case 'b':
			system("clear");
			return 1;
			break;
		default:
			continue;
		}
	}
	return 0;
}
/*-----End Special Applications-----*/

/*-----Access Control-----*/
int accessControl(ACONFIG *a)
{
	char groupMembers[3][80];
	char group[3][6];
	char groupPorts[3][80];
	char *access_control_title="Access Control";
	int i;
	char command[80],ch;
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",access_control_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\tGroup\t\t\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\t|\t(1)Default Group\t\t\t\t\t\t|\n");
		printf("\t|\t   (all hosts except those listed on the other groups.)\t\t|\n");
		for(i=1;i<4;i++)
		printf("\t|\t(%d)Group%d\t\t\t\t\t\t\t|\n",i+1,i);
/* pj */
		printf("\t|\t(s)Save and Reset\t\t\t\t\t\t|\n");
/* pj */
		printf("%s",line);
		printf("\tPlease enter your choice (1~4),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
/* pj */
		case 's':
			setactrl(0);
			write_Aconfig(a);
			setactrl(1);
			break;
/* pj */
		case '1':
			actlDefaultGroup(a);
			break;
		case '2':
		case '3':
		case '4':
			i=ch-'0'-1;
			actlGroup(i,a);
			break;
		case 'b':
			return 1;
		default:
			continue;
		}
	}
	return 0;
}
/*-----End Access Control-----*/

/*-----Miscellancous Items-----*/
int miscellancous(ACONFIG *a)
{
	char buf[4];
	int temp;
	char *misc_items_title="Miscellancous Items";
	int i;
	char command[80],ch;
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",misc_items_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\tIterm\t\t\t\t\tSetting\t\t\t|\n");
		printf("%s",line);
		printf("\t|\t(1)IP Address of DMS Host\t\t%3d.%3d.%3d.%3d\t\t|\n",a->local.rhip[0],a->local.rhip[1],a->local.rhip[2],a->local.dmz_host);
		printf("\t|\t(2)Remote Administrator Host\t\t%3d.%3d.%3d.%3d\t\t|\n",a->remote_host.ip[0],a->remote_host.ip[1],a->remote_host.ip[2],a->remote_host.ip[3]);
/* succ */
		printf("\t|\t(s)Save and Reset\t\t\t\t\t\t|\n");
/* succ */
		printf("%s",line);
		printf("\tPlease enter your choice (1~2),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
/* succ */
		case 's':
			setdmz(0);
			write_Aconfig(a);
			setdmz(1);
			break;
/* succ */
		case '1':
			printf("DMZ host=%d.%d.%d.",a->local.rhip[0],a->local.rhip[1],a->local.rhip[2]);
			fgets(command,80,stdin);
			getIPrange(command,&(a->local.dmz_host));
			break;
		case '2':
			printf("Remote Administrator Host=");
			fgets(command,80,stdin);
			getIP(command, a->remote_host.ip);
			break;
		case 'b':
			system("clear");
			return 1;
			break;
		default:
			continue;
		};
	}
	return 0;
}
/*-----End Miscellancous Items-----*/

/*-----pppd Main Menu-----*/
int pppdMenu(ACONFIG *a)
{
	char *q[2]={	"Name:",
			"Password:",
		    };
	char name[16];
	char pass[16];
	char *pppd_title="pppd Main Menu";
	int i;
	char command[80],ch;
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",pppd_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\tName\t\t\tPassword\t\t\t\t|\n");
		printf("%s",line);
		printf("\t|\t(1)%-16s\t%-16s\t\t\t|\n",a->pppd.name1,a->pppd.pass1);
		printf("\t|\t(2)%-16s\t%-16s\t\t\t|\n",a->pppd.name2,a->pppd.pass2);
		printf("\t|\t(3)%-16s\t%-16s\t\t\t|\n",a->pppd.name3,a->pppd.pass3);
		printf("\t|\t(4)%-16s\t%-16s\t\t\t|\n",a->pppd.name4,a->pppd.pass4);
		printf("%s",line);
		printf("\t|\tItem\t\t\tSetting\t\t\t\t\t|\n");
		printf("%s",line);
		if(a->pppd.pap==1)
			printf("\t|\t(5)pap\t\t\tEnable\t\t\t\t\t|\n");
		else
			printf("\t|\t(5)pap\t\t\tDisable\t\t\t\t\t|\n");
		if(a->pppd.chap==1)
			printf("\t|\t(6)chap\t\t\tEnable\t\t\t\t\t|\n");
		else
			printf("\t|\t(6)chap\t\t\tDisable\t\t\t\t\t|\n");
		if(a->pppd.mschap==1)
			printf("\t|\t(7)mschap\t\tEnable\t\t\t\t\t|\n");
		else
			printf("\t|\t(7)mschap\t\tDisable\t\t\t\t\t|\n");
		if(a->pppd.mschap2==1)
			printf("\t|\t(8)mschap2\t\tEnable\t\t\t\t\t|\n");
		else
			printf("\t|\t(8)mschap2\t\tDisable\t\t\t\t\t|\n");
/* succ */
			printf("\t|\t(s)Save and Reset\t\t\t\t\t\t|\n");
/* succ */
		printf("%s",line);
		printf("\tPlease enter your choice (1~8),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
/* succ */
		case 's':
			setpppd(0);
			setpptpd(0);
			write_Aconfig(a);
			setpppd(1);
			setpptpd(1);
			break;
/* succ */
		case '1':
			printf("%s",q[0]);
			fgets(command,80,stdin);
			if(strlen(command)>17)
				continue;
			command[strlen(command)-1]='\0';
			strcpy(a->pppd.name1,command);
			printf("%s",q[1]);
			fgets(command,80,stdin);
			if(strlen(command)>17)
				continue;
			command[strlen(command)-1]='\0';
			strcpy(a->pppd.pass1,command);
			break;
		case '2':
			printf("%s",q[0]);
			fgets(command,80,stdin);
			if(strlen(command)>17)
				continue;
			command[strlen(command)-1]='\0';
			strcpy(a->pppd.name2,command);
			printf("%s",q[1]);
			fgets(command,80,stdin);
			if(strlen(command)>17)
				continue;
			command[strlen(command)-1]='\0';
			strcpy(a->pppd.pass2,command);
			break;
		case '3':
			printf("%s",q[0]);
			fgets(command,80,stdin);
			if(strlen(command)>17)
				continue;
			command[strlen(command)-1]='\0';
			strcpy(a->pppd.name3,command);
			printf("%s",q[1]);
			fgets(command,80,stdin);
			if(strlen(command)>17)
				continue;
			command[strlen(command)-1]='\0';
			strcpy(a->pppd.pass3,command);
			break;
		case '4':
			printf("%s",q[0]);
			fgets(command,80,stdin);
			if(strlen(command)>17)
				continue;
			command[strlen(command)-1]='\0';
			strcpy(a->pppd.name4,command);
			printf("%s",q[1]);
			fgets(command,80,stdin);
			if(strlen(command)>17)
				continue;
			command[strlen(command)-1]=='\0';
			strcpy(a->pppd.pass4,command);
			break;
		case '5':
			a->pppd.pap=-1*(a->pppd.pap-1);
			break;
		case '6':
			a->pppd.chap=-1*(a->pppd.chap-1);
			break;
		case '7':
			a->pppd.mschap=-1*(a->pppd.mschap-1);
			break;
		case '8':
			a->pppd.mschap2=-1*(a->pppd.mschap2-1);
			break;
		case 'b':
			system("clear");
			return 1;
			break;
		default:
			continue;
		};
	}
	return 0;
}
/*-----End pppd Main Menu-----*/

/*-----pptp Main Menu-----*/

int pptpMenu(ACONFIG *a)
{
	char *remoteIpStart;
	char *remoteIpEnd;
	char *state[2]={"Disable",
			"Enable",
			};
	char *pptp_title="pptp Main Menu";
	int i,temp;
	char command[80],ch;
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",pptp_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\tIterm\t\t\t\tSetting\t\t\t\t|\n");
		printf("%s",line);
		printf("\t|\t(1)Local IP\t\t\t:%3d.%3d.%3d.%3d\t\t|\n",a->local.rhip[0],a->local.rhip[1],a->local.rhip[2],a->pptp.localIP[3]);
		printf("\t|\t(2)Remote IP Start\t\t:%3d.%3d.%3d.%3d\t\t|\n",a->local.rhip[0],a->local.rhip[1],a->local.rhip[2],a->pptp.start);
		printf("\t|\t(3)Remote IP End\t\t:%3d.%3d.%3d.%3d\t\t|\n",a->local.rhip[0],a->local.rhip[1],a->local.rhip[2],a->pptp.end);
		printf("\t|\t(4)pptpd state \t\t\t%-8s\t\t\t|\n",state[a->pptp.enable] );
/* succ */
		printf("\t|\t(s)Save and Rset\t\t\t\t\t\t|\n");
/* succ */
		printf("%s",line);
		printf("\tPlease enter your choice (1~3),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
/* succ */
		case 's':
			if(a->pptp.enable==0)
			{
				setpptpd(0);
				write_Aconfig(a);
			}
			else
			{
				setpptpd(0);
				setpptpd(1);
				write_Aconfig(a);
			}
			break;
/* succ */
		case '1':
			printf("Local IP=%d.%d.%d.",a->local.rhip[0],a->local.rhip[1],a->local.rhip[2]);
			fgets(command,80,stdin);
			getIPrange(command, &(a->pptp.localIP[3]));
			if(a->pptp.localIP[3] == a->local.rhip[3])
			{
				printf("Worring! pptp local ip can't be the same as LAN local ip\n");
				getchar();
				(a->pptp.localIP[3])+=1;
			}
			break;
		case '2':
			printf("remote IP start:%3d.%3d.%3d.",a->pptp.localIP[0],a->pptp.localIP[1],a->pptp.localIP[2]);
			fgets(command,80,stdin);
			getIPrange(command,&(a->pptp.start));
			break;
		case '3':
			printf("remote IP end:%3d.%3d.%3d.",a->pptp.localIP[0],a->pptp.localIP[1],a->pptp.localIP[2]);
			fgets(command,80,stdin);
			getIPrange(command, &(a->pptp.end));
			break;
		case '4':
			a->pptp.enable= -1*(a->pptp.enable - 1);
			break;
		case 'b':
			system("clear");
			return 1;
			break;
		default:
			continue;
		}
	}
	return 0;
}

/*-----End pptp Main Menu-----*/

/*-----Reboot-----*/
int reboot()
{
	printf("Rebooting!!\n");
	sleep(1);
	return 0;
}
/*-----End Reboot-----*/

/*-----LAN IP Address-----*/
int lanIpSet(ACONFIG *a)
{
	char command[80];
	printf("Please input your LAN IP Address");
	fgets(command,80,stdin);
	getIP(command, a->local.rhip);
	return 1;
}
/*-----End LAN IP Address-----*/

/*-----WAN Type-----*/
int wanType(ACONFIG * a)
{
	char *type;
	char *wan_type_title="WAN Type";
	int i;
	char command[80],ch;
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",wan_type_title);
		printf("%s",topLine);
		printf("%s",line);
		if(a->local.wtype==0)
		{
			printf("\t|\t(1)Static IP Address\t\t\t\tEnable\t\t|\n");
			printf("\t|\t(2)Dynamic IP Address\t\t\t\tDisable\t\t|\n");
			printf("\t|\t(3)PPP over Ethernet\t\t\t\tDisable\t\t|\n");
		}
		else if(a->local.wtype==1)
		{
			printf("\t|\t(1)Static IP Address\t\t\t\tDisable\t\t|\n");
			printf("\t|\t(2)Dynamic IP Address\t\t\t\tEnable\t\t|\n");
			printf("\t|\t(3)PPP over Ethernet\t\t\t\tDisable\t\t|\n");
		}
		else
		{
			printf("\t|\t(1)Static IP Address\t\t\t\tDisable\t\t|\n");
			printf("\t|\t(2)Dynamic IP Address\t\t\t\tDisable\t\t|\n");
			printf("\t|\t(3)PPP over Ethernet\t\t\t\tEnable\t\t|\n");
		}
/* succ */
		printf("\t|\t(s)Save and Reset\t\t\t\t\t\t|\n");
/* succ */
		printf("%s",line);
		printf("\tPlease enter your choice (1~3),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
/* succ */
		case 's':
			setwan(0);
			write_Aconfig(a);
			setwan(1);
			break;
/* succ */
		case '1':
			a->local.wtype=0;
			wanTypeStatic(a);
			break;
		case '2':
			a->local.wtype=1;
			system("clear");
			break;
		case '3':
			a->local.wtype=2;
			wanTypePPPoE(a);
			//system("clear");
			break;
		case 'b':
			system("clear");
			return 0;
			break;
		default:
			continue;
		};
	}
	return 1;
}
/*-----End WAN Tpye-----*/

/*-----Static IP Address Setting-----*/
int wanTypeStatic( ACONFIG * a)
{
	char command[80],ch,buf[3];
	int i,tempa,tempb,tempc,tempd;
	char *static_ip_title="Static IP Address";
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",static_ip_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\t(1)WAN IP Address\t%3d.%3d.%3d.%3d\t\t\t\t|\n",a->local.wip[0],a->local.wip[1],a->local.wip[2],a->local.wip[3]);
		printf("\t|\t(2)Subnet Mask\t\t%3d.%3d.%3d.%3d\t\t\t\t|\n",a->local.wnm[0],a->local.wnm[1],a->local.wnm[2],a->local.wnm[3]);
		printf("\t|\t(3)Getway\t\t%3d.%3d.%3d.%3d\t\t\t\t|\n",a->local.wgw[0],a->local.wgw[1],a->local.wgw[2],a->local.wgw[3]);
		printf("\t|\t(4)Primary DNS\t\t%3d.%3d.%3d.%3d\t\t\t\t|\n",a->local.rhnm[0],a->local.rhnm[1],a->local.rhnm[2],a->local.rhnm[3]);
		printf("%s",line);
		printf("\tPlease enter your choice (1~4),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case '1':
			printf("IP:");
			fgets(command,80,stdin);
			getIP(command,a->local.wip);
			break;
		case '2':
			printf("Net mask:");
			fgets(command,80,stdin);
			getIP(command,a->local.wnm);
			break;
		case '3':
			printf("GW:");
			fgets(command,80,stdin);
			getIP(command, a->local.wgw);
			break;
		case '4':
			printf("DNS1:");
			fgets(command,80,stdin);
			getIP(command, a->local.rhnm);
			break;
		case 'b':
			system("clear");
			return 0;
			break;
		default:
			continue;
		};
	}
	return 1;
}
/*-----End Static IP Address Setting-----*/

/*----- PPPoE Setting-----*/
int wanTypePPPoE( ACONFIG * a)
{
	char command[80], ch, buf[4];
	int i, j, k;
	char *pppoe_title="PPPoE Setting";
	while(1)
	{
		system("clear");
		printf("%s", topLine);
		printf("\t\t\t\t%s\n", pppoe_title);
		printf("%s", topLine);
		printf("%s", line);
		printf("\t|\t(1)User ID\t%s\n", a->pppoe.id);
		printf("\t|\t(2)Password\t%s\n", a->pppoe.passwd);
		printf("\t|\t   DNS Server (If you don't know your DNS server, please do not |\n");
		printf("\t|\t   set this option)\t\t\t\t\t\t|\n");
		printf("\t|\t      (3)DNS1\t%3d.%3d.%3d.%3d\t\t\t\t\t|\n", a->pppoe.dns1[0], a->pppoe.dns1[1], a->pppoe.dns1[2], a->pppoe.dns1[3]);
		printf("\t|\t      (4)DNS2\t%3d.%3d.%3d.%3d\t\t\t\t\t|\n", a->pppoe.dns2[0], a->pppoe.dns2[1], a->pppoe.dns2[2], a->pppoe.dns2[3]);
		printf("\t|\t(5)Timeout\t\t\t\t\t\t\t|\n");
		printf("\t|\t   If %d seconds elapse without any activity, we will disconnect|\n", a->pppoe.timeout);
		printf("%s",line);
		printf("\tPlease enter your choice (1~5),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case '1':
			printf("User ID:");
			fgets(command,80,stdin);
			command[strlen(command) - 1] = 0;
			strcpy(a->pppoe.id, command);
			break;
		case '2':
			printf("Password:");
			fgets(command, 80, stdin);
			command[strlen(command) - 1] = 0;
			strcpy(a->pppoe.passwd, command);
			break;
		case '3':
			printf("DNS1:");
			fgets(command, 80, stdin);
			command[strlen(command) - 1] = 0;
			for(i = k = 0; k < 4; k++)
			{
				for(j =0; command[i] != '.' && command[i] != 0; i++)
					j++;
				strncpy(buf, command + i - j, j);
				buf[j] = 0;
				a->pppoe.dns1[k] = atoi(buf);
				i++;
			}
			break;
		case '4':
			printf("DNS2:");
			fgets(command, 80, stdin);
			command[strlen(command) - 1] = 0;
			for(i = k = 0; k < 4; k++)
			{
				for(j =0; command[i] != '.' && command[i] != 0; i++)
					j++;
				strncpy(buf, command + i - j, j);
				buf[j] = 0;
				a->pppoe.dns2[k] = atoi(buf);
				i++;
			}
			break;
		case '5':
			printf("Timeout(in seconds):");
			fgets(command, 80, stdin);
			command[strlen(command) - 1] = 0;
			a->pppoe.timeout = atoi(command);
			break;
		case 'b':
			system("clear");
			return 0;
			break;
		default:
			continue;
		};
	}
	return 1;
}
/*-----End PPPoE Setting-----*/

/*-----pptp Client Setting-----*/
int pptpClient(ACONFIG *a)
{
	char name[9];
	char pswd[9];
	char ip[16];
	char buf[4];
	int i,temp;
	char *pptp_client_title="pptp Client";
	char command[80],ch;
	name[0]='\0';
	pswd[0]='\0';
	ip[0]='\0';
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",pptp_client_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\tName\t\tPassword\t\tIP\tstate\t\t|\n");
		for(i=0;i<5;i++)
		{
			if( pptpc_state[i] == 1)
				printf("\t|\t(%d)%-8s\t%-8s\t%3d.%3d.%3d.%3d\t  Connected\t|\n",i+1,a->pptpc[i].name,a->pptpc[i].pswd,a->pptpc[i].ip[0],a->pptpc[i].ip[1],a->pptpc[i].ip[2],a->pptpc[i].ip[3]);
			else
				printf("\t|\t(%d)%-8s\t%-8s\t%3d.%3d.%3d.%3d\t\t\t|\n",i+1,a->pptpc[i].name,a->pptpc[i].pswd,a->pptpc[i].ip[0],a->pptpc[i].ip[1],a->pptpc[i].ip[2],a->pptpc[i].ip[3]);
		}
		printf("\t|\t(C)Choose which to connect\t\t\t\t\t|\n");
		printf("\t|\t(s)Save setting\t\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (1~5) to modify or 'C' to connect,\n\tPress 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 's':
			write_Aconfig(a);
			break;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
			i=ch-'0'-1;
			printf("Name=");
			fgets(command,80,stdin);
			if(strlen(command)>10)
				continue;
			command[strlen(command)-1]='\0';
			strcpy(a->pptpc[i].name,command);
			printf("Password=");
			fgets(command,80,stdin);
			if(strlen(command)>10)
				continue;
			command[strlen(command)-1]='\0';
			strcpy(a->pptpc[i].pswd,command);
			printf("IP=");
			fgets(command,80,stdin);
			if(strlen(command)>16)
				continue;
			getIP(command,a->pptpc[i].ip);
			break;
		case 'C':
			printf("which pptpc[1-5]:");
			fgets(command,80,stdin);
			if(strlen(command)!=2)
				continue;
			ch=command[0];
			i=ch-'0'-1;
			temp=i;//pptpc number
			sprintf(ip,"%d.%d.%d.%d",a->pptpc[i].ip[0],a->pptpc[i].ip[1],a->pptpc[i].ip[2],a->pptpc[i].ip[3]);
/* succ */
                        strcpy(name,a->pptpc[i].name);
                        strcpy(pswd,a->pptpc[i].pswd);
                        pptpc_dial(ip,name,pswd);
/* succ */
			//---save to VPN status
			for(i=0;vpn.connections[i].enable==1;i++);
			strcpy(vpn.connections[i].name,a->pptpc[temp].name);
			strcpy(vpn.connections[i].pswd,a->pptpc[temp].pswd);
			vpn.connections[i].enable=1;
			vpn.connections[i].type=1;//pptpc
			memcpy(vpn.connections[i].ip,a->pptpc[temp].ip,4);
			name[0]='\0';
			pswd[0]='\0';
			ip[0]='\0';
			pptpc_state[temp]=1;//pptpc connected status
			break;
		case 'b':
			system("clear");
			return 0;
			break;
		default:
			continue;
		};
	}
	return 0;
}
/*-----End pptp Client Setting-----*/
/*-----VPN status----*/
int vpnStatus(ACONFIG * a)
{
	int i,j;
	int flag;
	char ch;
	char command[80];
	char *vps_status_title="VPN Status";

/* succ 0515 for pptpc disconnect */
        FILE *fd;
        unsigned char temp[20];
        unsigned char pid[10];
/* succ */
	l2tpStatus();//get the l2tp status
	while(1)
	{
		flag=0;
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",vps_status_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|Portocol\tIP\t\t\tName\t\tPassword\t|\n");
		printf("%s",line);
		for(i=0;i<5;i++)
		{
			if(vpn.connections[i].enable==0)
				continue;
			flag=1;
			if(vpn.connections[i].type==1)
				printf("\t|(%d)pptpc\t%3d.%3d.%3d.%3d\t\t%-10s\t%-10s\t|\n",i+1,vpn.connections[i].ip[0],vpn.connections[i].ip[1],vpn.connections[i].ip[2],vpn.connections[i].ip[3],vpn.connections[i].name,vpn.connections[i].pswd);
			else if(vpn.connections[i].type==2)
				printf("\t|(%d)pptpd\t%3d.%3d.%3d.%3d\t\t%-10s\t%-10s\t|\n",i+1,vpn.connections[i].ip[0],vpn.connections[i].ip[1],vpn.connections[i].ip[2],vpn.connections[i].ip[3],vpn.connections[i].name,vpn.connections[i].pswd);
			else if(vpn.connections[i].type==3)//lac
				printf("\t|(%d)L2TP\t%3d.%3d.%3d.%3d\t\t%-10s\t%-10s\t|\n",i+1,vpn.connections[i].ip[0],vpn.connections[i].ip[1],vpn.connections[i].ip[2],vpn.connections[i].ip[3],vpn.connections[i].name,vpn.connections[i].pswd);
		}
		if(flag==0)
			printf("\t|\t\t\t\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease choice the number to disconnect, or press 'b' to back\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
			i=ch-'0'-1;
			vpn.connections[i].name[0]='\0';
			vpn.connections[i].pswd[0]='\0';
			vpn.connections[i].enable=0;
/* succ 0515 for pptpc disconnect */
			if(vpn.connections[i].type == 1)//pptpc
			{
				pptpc_disc(i,&vpn);
				for(j=0;j<5;j++)
				{
					if( (!memcmp(vpn.connections[i].ip,a->pptpc[j].ip,4)) && (!strcmp(vpn.connections[i].name,a->pptpc[j].name)) )
						pptpc_state[j]=0;
				}
			}
			else if(vpn.connections[i].type == 2)
				;
			else if(vpn.connections[i].type == 3)
			{
				vpn.connections[i].enable=0;
				vpn.connections[i].name[0]='\0';
				vpn.connections[i].pswd[0]='\0';
				sprintf(command, "echo \"h %d \" > /var/run/l2tp-control",vpn.connections[i].cid);
				system(command);
				sprintf(command, "echo \"d %d \" > /var/run/l2tp-control",vpn.connections[i].tid);
				system(command);//disconnect
			}
			else if(vpn.connections[i].type == 4)
				;
/* succ */
			break;
		case 'b':
			return 0;
			break;
		default:
			continue;
		};
	}
	return 1;
}
/*-----End VPN status-----*/

/*-----L2TP Server setting-----*/
int l2tpdMainMenu(ACONFIG *a)
{
	char command[80],ch,buf[3];
	int i,temp,flag;
	char *l2tp_title="L2TP Setting";
	FILE *fd;
	int tid, cid;//Tunnel id, Call id
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",l2tp_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\t\t\tLNS\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\t|\t(1)Local Virtual IP\t\t%3d.%3d.%3d.%3d\t\t\t|\n",L2TPSIP);
		printf("\t|\t(2)Static IP Pool from:\t%3d.%3d.%3d.%3d to:%3d.%3d.%3d.%3d\t|\n",L2TPSFROM,L2TPSTO);
		printf("\t|\t(3)Deny[1] LAC IP\t\t%3d.%3d.%3d.%3d\t\t\t|\n",L2TPSNO1);
		printf("\t|\t(4)Deny[2] LAC IP\t\t%3d.%3d.%3d.%3d\t\t\t|\n",L2TPSNO2);
		printf("\t|\t(5)Deny[3] LAC IP\t\t%3d.%3d.%3d.%3d\t\t\t|\n",L2TPSNO3);
		printf("\t|\t(6)Host Name for pppd\t\t%-10s\t\t\t|\n",a->l2tpd.lns.name);
		printf("%s",line);
		printf("\t|\t\t\tLAC\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\t|\t(7)Setup LAC\t\t\t\t\t\t\t|\n");
		printf("\t|\t(8)Choose which Amit to connect\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\t|\tLAC Amit\tLNS IP\t\tname\t\tpassword\t|\n");
		for(i=0;i<5;i++)
		{
			printf("\t|\t%d\t%3d.%3d.%3d.%3d\t\t%-8s\t%-8s\t|\n",i+1,L2TPCLIST,a->l2tpd.lac[i].name,a->l2tpd.lac[i].pswd);
		}
		printf("\t|\t(s)Save setting\t\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (1~8),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 's':
			write_Aconfig(a);//need to restart L2TP daemon!!
			break;
		case '1':
			printf("Local virtual ip(*.*.*.*):");
			fgets(command,80,stdin);
			getIP(command, a->l2tpd.lns.local_ip);
			break;
		case '2':
			printf("Static IP Pool from(1~254):");
			fgets(command,80,stdin);
			if(strlen(command)>4 || strlen(command) < 2)
				continue;
			command[strlen(command)-1]=0;
			temp=atoi(command);
			if(temp<1 || temp >254)
				continue;
			a->l2tpd.lns.ip_range_from=(BYTE)temp;
			printf("Static IP Pool to(1~254):");
			fgets(command,80,stdin);
			if(strlen(command)>4 || strlen(command) < 2)
				continue;
			command[strlen(command)-1]=0;
			temp=atoi(command);
			if(temp<1 || temp >254)
				continue;
			a->l2tpd.lns.ip_range_to=(BYTE)temp;
			if(a->l2tpd.lns.ip_range_from > a->l2tpd.lns.ip_range_to)//if from > to ,swap them
			{
				temp=a->l2tpd.lns.ip_range_to;
				a->l2tpd.lns.ip_range_to=a->l2tpd.lns.ip_range_from;
				a->l2tpd.lns.ip_range_from=temp;
			}
			break;
		case '3':
		case '4':
		case '5':
			i=ch-'0';
			i=i-3;
			printf("Set or Clean (S/C):");
			fgets(command,80,stdin);
			if(strlen(command)>2)
				continue;
			ch=command[0];
			if(ch=='C')
			{
				a->l2tpd.lns.no_lac[i].ip[0]=0;
				a->l2tpd.lns.no_lac[i].ip[1]=0;
				a->l2tpd.lns.no_lac[i].ip[2]=0;
				a->l2tpd.lns.no_lac[i].ip[3]=0;
			}
			else if(ch=='S')
			{
				printf("Deny LAC IP(*.*.*.*):");
				fgets(command,80,stdin);
				getIP(command, a->l2tpd.lns.no_lac[i].ip);
			}
			break;
		case '6':
			printf("Host Name for pppd:");
			fgets(command,80,stdin);
			if(strlen(command)>10)
				continue;
			command[strlen(command)-1]='\0';
			strcpy(a->l2tpd.lns.name,command);
			break;
		case '7'://setup LAC
			printf("Which LAC [1-5]?");
			fgets(command,80,stdin);
			if(strlen(command)>2)
				continue;
			command[strlen(command)-1]='\0';
			i=atoi(command);
			if(i<0 || i>5)
				continue;
			i--;
			printf("Please enter your LNS ip(*.*.*.*):");
			fgets(command,80,stdin);
			getIP(command, a->l2tpd.lac[i].peer);
			printf("Name?");
			fgets(command,80,stdin);
			if(strlen(command)>10)
				continue;
			command[strlen(command)-1]='\0';
			strcpy(a->l2tpd.lac[i].name,command);
			printf("Password?");
			fgets(command,80,stdin);
			if(strlen(command)>10)
				continue;
			command[strlen(command)-1]='\0';
			strcpy(a->l2tpd.lac[i].pswd,command);
			break;
		case '8'://connect LAC
			printf("Which LAC [1-5]?");
			fgets(command,80,stdin);
			if(strlen(command)>2)
				continue;
			command[strlen(command)-1]='\0';
			temp=atoi(command);
			if(temp<0 || temp>5)
				continue;
			temp--;//the LAC number
			//--- Connect
			sprintf(command,"iptables -t nat -D PREROUTING -d %d.%d.%d.%d -p udp --dport 1701 -j ACCEPT",a->local.wip[0],a->local.wip[1],a->local.wip[2],a->local.wip[3]);
			printf("%s\n",command);
			system(command);
			sprintf(command,"iptables -t nat -I PREROUTING -d %d.%d.%d.%d -p udp --dport 1701 -j ACCEPT",a->local.wip[0],a->local.wip[1],a->local.wip[2],a->local.wip[3]);
			printf("%s\n",command);
			system(command);
			fd=fopen(L2TP_AUTHNAME_FILE,"w");
			fprintf(fd,"%s\n",a->l2tpd.lac[temp].name);
			fclose(fd);
			i=temp;//the LAC number
			sprintf(command,"echo \"t %d.%d.%d.%d\" > /var/run/l2tp-control",L2TPCLIST);
			printf("%s\n",command);
			system(command);//creat Tunnel
			for(i=0,flag=0;i<5;i++)
			{
				if((fd=fopen("/var/run/l2tpd.tid","r"))==NULL )
				{
					fprintf(stdout,"Connection fail !");
					sleep(1);
					fprintf(stdout,"Try again times=%d\n",i+1);
					continue;
				}
				flag=1;
				break;
			}
			if(flag==0)//can't open file
			{
				printf("connection fail!");
				unlink(L2TP_AUTHNAME_FILE);
				sprintf(command,"iptables -t nat -D PREROUTING -d %d.%d.%d.%d -p udp --dport 1701 -j ACCEPT",a->local.wip[0],a->local.wip[1],a->local.wip[2],a->local.wip[3]);
				system(command);
				break;
			}
			fgets(command,80,fd);//read the Tunnel_id;
			fclose(fd);
			fprintf(stdout,"%s\n",command);
			command[strlen(command)-1]=0;
			tid=atoi(command);
			//---debug
			//printf("tid=%d\n",tid);
			//---end debug
			if(!unlink("/var/run/l2tpd.tid"))
				printf("unlink success\n");
			else
				printf("unlink error\n");
			sprintf(command,"echo \"c %d \" > /var/run/l2tp-control", tid);
			printf("%s\n",command);
			system(command);//creat Call
			/*
			if((fd=fopen("/var/run/l2tpd.csf","r"))==NULL )
			{
				fprintf(stdout,"open /var/run/l2tpd.csf fail !");
				sleep(2);
				break;
			}
			fgets(command,80,fd);
			if(command[0]='1')
			{
				sprintf(command, "echo \"h %d \" > /var/run/l2tp-control",cid);
				system(command);
				sprintf(command, "echo \"d %d \" > /var/run/l2tp-control",tid);
				system(command);//disconnect
			}
			else
			{
				fprintf(stdout,"Connection established successfully!");
				//---SAVE to the VPN status
				//for(i=0;vpn.connections[i].enable==1;i++);//find empty vpn connect [i]
				//strcpy(vpn.connections[i].name,a->l2tpd.lac[temp].name);//save name
				//strcpy(vpn.connections[i].pswd,a->l2tpd.lac[temp].pswd);//save password
				//memcpy(vpn.connections[i].ip,a->l2tpd.lac[temp].peer,4);//save LAC IP
				//vpn.connections[i].enable=1;
				//vpn.connections[i].type=3;//l2tpc

			}
			*/
			unlink(L2TP_AUTHNAME_FILE);
			//--- End Connect
			break;
		case 'b':
			system("clear");
			return 0;
			break;
		default:
			continue;
		};
	}
	return 0;
}
/*-----End L2TP Server setting-----*/

/*-----IDS Setting-----*/
int idsMainMenu(ACONFIG * a)
{

	char command[80],ch;
	int i,temp;
	char *state[2]={"OFF",
			"ON",
			};
	char *ids_title="IDS Main Menu";
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",ids_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\tItem\t\t\t\t\tState\t\t\t|\n");
		printf("%s",line);
		i=(a->ids.flag[0]&0x01);
		printf("\t|\t(1)Snork\t\t\t\t%3s\t\t\t|\n",state[i]);
		i=(a->ids.flag[0]&0x02)>>1;
		printf("\t|\t(2)Smurf\t\t\t\t%3s\t\t\t|\n",state[i]);
		//i=(a->ids.flag[0]&0x04)>>2;
		//printf("\t|\t(3)Teardrop\t\t\t\t%3s\t\t\t|\n",state[i]);
		i=(a->ids.flag[0]&0x08)>>3;
		printf("\t|\t(3)Port Scan\t\t\t\t%3s\t\t\t|\n",state[i]);
		i=(a->ids.flag[0]&0x10)>>4;
		printf("\t|\t(4)UDP Bomb\t\t\t\t%3s\t\t\t|\n",state[i]);
		i=(a->ids.flag[0]&0x20)>>5;
		printf("\t|\t(5)SYN Flooding\t\t\t\t%3s\t\t\t|\n",state[i]);
		i=(a->ids.flag[0]&0x40)>>6;
		printf("\t|\t(6)Fraggle\t\t\t\t%3s\t\t\t|\n",state[i]);
		i=(a->ids.flag[0]&0x80)>>7;
		printf("\t|\t(7)Land Attack\t\t\t\t%3s\t\t\t|\n",state[i]);
		i=(a->ids.flag[1]&0x01);
		printf("\t|\t(8)ICMP Unreachable\t\t\t%3s\t\t\t|\n",state[i]);
		i=(a->ids.flag[1]&0x02)>>1;
		printf("\t|\t(9)Ping flooding\t\t\t%3s\t\t\t|\n",state[i]);
		i=(a->ids.flag[1]&0x04)>>2;
		printf("\t|\t(A)DNS Scan\t\t\t\t%3s\t\t\t|\n",state[i]);
		i=(a->ids.flag[1]&0x08)>>3;
		printf("\t|\t(B)http url block\t\t\t%3s\t\t\t|\n",state[i]);
		i=(a->ids.flag[1]&0x10)>>4;
		printf("\t|\t(C)Malicious Script\t\t\t%3s\t\t\t|\n",state[i]);
		i=(a->ids.flag[1]&0x20)>>5;
		printf("\t|\t(D)Virus scan\t\t\t\t%3s\t\t\t|\n",state[i]);
		i=(a->ids.flag[1]&0x40)>>6;
		printf("\t|\t(E)Mail Bomb - Address Block\t\t%3s\t\t\t|\n",state[i]);
		i=(a->ids.flag[1]&0x80)>>7;
		printf("\t|\t(F)Mail Bomb - Total number\t\t%3s\t\t\t|\n",state[i]);
		printf("\t|\t(s)Save and Rest\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (1~G),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 's':
			setids(0);
			// Writing new status into flash rom.
			write_Aconfig(a);
			setids(1);
			break;
		case '1'://Snork
			if((a->ids.flag[0]&0x01)==0x01)//OFF
				a->ids.flag[0]=a->ids.flag[0]&(~0x01);
			else//ON
				a->ids.flag[0]=a->ids.flag[0]|0x01;
			break;
		case '2'://smurf
			if((a->ids.flag[0]&0x02)==0x02)//OFF
				a->ids.flag[0]=a->ids.flag[0]&(~0x02);
			else//ON
				a->ids.flag[0]=a->ids.flag[0]|0x02;
			break;
		case '3'://port scan
			if((a->ids.flag[0]&0x08)==0x08)//OFF
				a->ids.flag[0]=a->ids.flag[0]&(~0x08);
			else//ON
				a->ids.flag[0]=a->ids.flag[0]|0x08;
			break;
		case '4'://udp bomb
			if((a->ids.flag[0]&0x10)==0x10)//OFF
				a->ids.flag[0]=a->ids.flag[0]&(~0x10);
			else//ON
				a->ids.flag[0]=a->ids.flag[0]|0x10;
			break;
		case '5'://SYN flooding
			if((a->ids.flag[0]&0x20)==0x20)//OFF
				a->ids.flag[0]=a->ids.flag[0]&(~0x20);
			else//ON
				a->ids.flag[0]=a->ids.flag[0]|0x20;
			break;
		case '6'://fraggle
			if((a->ids.flag[0]&0x40)==0x40)//OFF
				a->ids.flag[0]=a->ids.flag[0]&(~0x40);
			else//ON
				a->ids.flag[0]=a->ids.flag[0]|0x40;
			break;
		case '7'://land attack
			if((a->ids.flag[0]&0x80)==0x80)//OFF
				a->ids.flag[0]=a->ids.flag[0]&(~0x80);
			else//ON
				a->ids.flag[0]=a->ids.flag[0]|0x80;
			break;
		case '8'://icmp unreachable
			if((a->ids.flag[1]&0x01)==0x01)//OFF
				a->ids.flag[1]=a->ids.flag[1]&(~0x01);
			else//ON
				a->ids.flag[1]=a->ids.flag[1]|0x01;
			break;
		case '9'://icmp flooding
			if((a->ids.flag[1]&0x02)==0x02)//OFF
				a->ids.flag[1]=a->ids.flag[1]&(~0x02);
			else//ON
				a->ids.flag[1]=a->ids.flag[1]|0x02;
			break;
		case 'A'://dns
			dnsMainMenu(a);
			//if((a->ids.flag[1]&0x04)==0x04)//OFF
			//	a->ids.flag[1]=a->ids.flag[1]&(~0x04);
			//else//ON
			//	a->ids.flag[1]=a->ids.flag[1]|0x04;
			break;
		case 'B'://http url block
			urlblockMainMenu(a);
			break;
		case 'C'://malicious script
			mscriptMainMenu(a);
			//if((a->ids.flag[1]&0x10)==0x10)//OFF
			//	a->ids.flag[1]=a->ids.flag[1]&(~0x10);
			//else//ON
			//	a->ids.flag[1]=a->ids.flag[1]|0x10;
			break;
		case 'D'://virus
			virusScanMainMenu(a);
			//if((a->ids.flag[1]&0x20)==0x20)//OFF
			//	a->ids.flag[1]=a->ids.flag[1]&(~0x20);
			//else//ON
			//	a->ids.flag[1]=a->ids.flag[1]|0x20;
			break;
		case 'E'://mail bomb1
			mailblockMainMenu(a);
			//if((a->ids.flag[1]&0x40)==0x40)//OFF
			//	a->ids.flag[1]=a->ids.flag[1]&(~0x40);
			//else//ON
			//	a->ids.flag[1]=a->ids.flag[1]|0x40;
			break;
		case 'F'://mail bomb2
			mailblockMainMenu(a);
			//if((a->ids.flag[1]&0x80)==0x80)//OFF
			//	a->ids.flag[1]=a->ids.flag[1]&(~0x80);
			//else//ON
			//	a->ids.flag[1]=a->ids.flag[1]|0x80;
			break;
		case 'b':
			return 0;
		default:
			continue;
		};
	}
	return 0;
}
/*-----End IDS Setting-----*/

/*-----Get IP-----*/
int getIP(char * command, BYTE *ip)
{
	char * temp;
	char buf[3];
	int i, x;
	command[strlen(command)-1]='\0';//use "fgets" need to ignore '\n'
	i=strlen(command);
	if(i>15 || i<7)
		return 0;//check len 7~15
	temp=command;
	for(x=0;x<4;x++)
	{
		i=0;
		while(*temp != '.' && *temp!='\0')
		{
			buf[i]=*temp;
			i++;
			temp++;
		}
		temp++;
		buf[i]='\0';
		i=atoi(buf);
		if(i<0 || i>255)
			return 0;//error value
		*(ip+x)=(BYTE)i;
	}
	return 1;
}
/*-----End Get IP-----*/

/*-----Get Port-----*/
int getPort(char * command, WORD *port)
{
	int temp;
	command[strlen(command)-1]='\0';//use "fgets" need to ignore '\n'
	temp=strlen(command);
	if(temp==0 || temp >5)
		return 0; //check len 1~5
	temp=atoi(command);
	if(temp<1 || temp >65535)
		return 0;//overflow
	*port=(WORD)temp;
	return 1;
}
/*-----End Get Port-----*/

/*-----Get IP range-----*/
int getIPrange(char * command, BYTE *ip)
{
	int i;
	command[strlen(command)-1]='\0';//use "fgets" need to ignore '\n'
	i=strlen(command);
	if(i==0 || i>3)
		return 0; //check len 1~3
	i=atoi(command);
	if(i<0 || i>255)
		return 0;//error value
	*ip=(BYTE)i;
	return 1;
}
/*-----End Get IP range-----*/

/*-----Access Control Default Group-----*/
int actlDefaultGroup(ACONFIG *a)
{
	char *str[3]={	"Block",
			"Allow",
			"Input String:",
		       };
	char tempPort[192];
	int rule;
	char *type;
	char *actl_default_title="Access Control Default Group";
	int i;
	char command[193],ch;
	while(1)
	{
		tempPort[0]=0;
		actlShowStr(tempPort, '1', 0, a);
		rule=a->actl2[0].flag;
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",actl_default_title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\t(1)rule:\t%-5s\t\t\t\t\t\t|\n",str[rule]);
		printf("\t|\t(2)Port range:\t%-40s\t|\n",tempPort);
		printf("%s",line);
		printf("\tPlease enter your choice (1~2),or press 'b' to back.\n");
		fgets(command,193,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case '1':
			rule= -1*(a->actl2[0].flag-1);
			a->actl2[0].flag=rule;
			break;
		case '2':
			printf("%s",str[2]);
			fgets(command,193,stdin);
			acparser(command, 1, 0, a);
			break;
		case 'b':
			return 0;
		default:
			continue;
		}
	}
	return 1;
}
/*-----End Access Control Default Group-----*/

/*-----Access Control Group 1~3-----*/
int actlGroup(int group, ACONFIG * a)
{
	char *str[3]={	"Block",
			"Allow",
			"Input String:"
		       };
	char temp[192];
	int rule;
	char *type;
	char *actl_default_title="Access Control Group 1~3";
	int i;
	char command[193],ch;
	while(1)
	{
		rule=a->actl2[group].flag;
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",actl_default_title);
		printf("%s",topLine);
		printf("%s",line);
		temp[0]=0;
		actlShowStr(temp, '0', group, a);
		printf("\t|\t(1)IP range:\t%-40s\t|\n",temp);
		printf("\t|\t(2)rule:\t%-5s\t\t\t\t\t\t|\n",str[rule]);
		temp[0]=0;
		actlShowStr(temp, '1', group, a);
		printf("\t|\t(3)Port range:\t%-40s\t|\n",temp);
		printf("%s",line);
		printf("\tPlease enter your choice (1~3),or press 'b' to back.\n");
		fgets(command,193,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case '1':
			printf("%s",str[2]);
			fgets(command,193,stdin);
			acparser(command, 0, group, a);
			break;
		case '2':
			rule= -1*(a->actl2[group].flag-1);
			a->actl2[group].flag=rule;
			break;
		case '3':
			printf("%s",str[2]);
			fgets(command,193,stdin);
			acparser(command, 1, group, a);
			break;
		case 'b':
			return 0;
		default:
			continue;
		};
	}
	return 1;
}
/*-----End Access Control Group 1~3-----*/

/*-----Access Control Show String-----*/
//type 0 -> IP
//type 1 -> Port
int actlShowStr(char *str, char type, int group ,ACONFIG *a)
{
	int temp;
	char buf[6]="00000";
	int i,j;
	if(type=='0')
	{
		for(i=0;i<16;i++)
		{
			if(a->actl2[group].ip[i].sip==a->actl2[group].ip[i].eip && a->actl2[group].ip[i].sip!=0)
			{
				sprintf(buf,"%d",a->actl2[group].ip[i].sip);
				strcat(str,buf);
				strcat(str,",");
			}
			else
			{
				temp=a->actl2[group].ip[i].sip;
				if(temp==0)
					continue;
				temp=a->actl2[group].ip[i].eip;
				if(temp==0)
					continue;
				sprintf(buf,"%d",a->actl2[group].ip[i].sip);
				strcat(str,buf);
				strcat(str,"-");
				sprintf(buf,"%d",a->actl2[group].ip[i].eip);
				strcat(str,buf);
				strcat(str,",");
			}
		}
	}
	else
	{
		for(i=0;i<16;i++)
		{
			if(a->actl2[group].port[i].sp==a->actl2[group].port[i].ep && a->actl2[group].port[i].sp!=0)
			{
				sprintf(buf,"%d",a->actl2[group].port[i].sp);
				strcat(str,buf);
				strcat(str,",");

			}
			else
			{
				temp=a->actl2[group].port[i].sp;
				if(temp==0)
					continue;
				temp=a->actl2[group].port[i].ep;
				if(temp==0)
					continue;
				sprintf(buf,"%d",a->actl2[group].port[i].sp);
				strcat(str,buf);
				strcat(str,"-");
				sprintf(buf,"%d",a->actl2[group].port[i].ep);
				strcat(str,buf);
				strcat(str,",");
			}
		}
	}
	return 1;
}
/*-----End Access Control Show String-----*/

/* succ */ /* access control */
/* type 0 : IP   */
/* type 1 : port */
void acparser(char *a,char type,int group,ACONFIG *aconf)
{
  int head = 0, tail = 1;
  int tlen;
  int i,j,flag;
  int mark = 0;
  int index = 0;
  char temp[10];

  tlen = strlen(a);
  flag=1;

  while(head<tlen)
  {

    for(j=tail ; a[j]!=',' && a[j]!='\0' ; j++) tail += 1;

    i = 0;

    for(j=head ; j <= tail ; j++)
    {
      if(a[j] != ',' && a[j] != '-' && a[j] != '\0') {
        temp[i++] = a[j];
        continue;
      } else if(a[j] == ',' || a[j] == '\0')
      {
        //fprintf(stderr,"[%s]\n",temp);
	if(atoi(temp)==0)
	{
		flag=0;
		break;
	}
	else
		flag=1;
	if(type == 0) {
          if(mark == 0) {
            aconf->actl2[group].ip[index].sip = (BYTE)atoi(temp);
            aconf->actl2[group].ip[index].eip = (BYTE)atoi(temp);
          } else {
	    aconf->actl2[group].ip[index].eip = (BYTE)atoi(temp);
          }
        } else//type=1
        {
          if(mark == 0) {
            aconf->actl2[group].port[index].sp  = (WORD)atoi(temp);
            aconf->actl2[group].port[index].ep  = (WORD)atoi(temp);
          } else {
            aconf->actl2[group].port[index].ep  = (WORD)atoi(temp);
          }
        }
        break;
      } else if(a[j] == '-')
      {
	mark = 1;
        //fprintf(stderr,"[%s]-",temp);
	if(atoi(temp)==0)
	{
		flag=0;
		break;
	}
	else
		flag=1;
        if(type == 0) {
            aconf->actl2[group].ip[index].sip  = (BYTE)atoi(temp);
        } else {
            aconf->actl2[group].port[index].sp   = (WORD)atoi(temp);
        }
	//
        i = 0;
        continue;
      }
    }

    head = tail+1;
    tail += 2;
    mark = 0;
    index+=flag;
  }
  for(i=index;i<16;i++)
  {
	if(type==0)
	{
		aconf->actl2[group].ip[i].sip=0;
		aconf->actl2[group].ip[i].eip=0;
	}
	else
	{
		aconf->actl2[group].port[i].sp=0;
		aconf->actl2[group].port[i].ep=0;
	}
  }
  for(i=0;i<16;i++)
  {
	if(type==0)
	{	//if start > end, swap them.
		if(aconf->actl2[group].ip[i].sip > aconf->actl2[group].ip[i].eip)
		{
			j = aconf->actl2[group].ip[i].sip;
			aconf->actl2[group].ip[i].sip = aconf->actl2[group].ip[i].eip;
			aconf->actl2[group].ip[i].eip = j;
		}
	}
	else
	{
		if(aconf->actl2[group].port[i].sp > aconf->actl2[group].port[i].ep )
		{
			j = aconf->actl2[group].port[i].sp;
			aconf->actl2[group].port[i].sp = aconf->actl2[group].port[i].ep;
			aconf->actl2[group].port[i].ep = j;
		}
	}
  }
}

/* succ */

/* **************** */
/* read L2TP status */
/* 0:error          */
/* 1:success        */
/* **************** */
int l2tpStatus(void)
{
	FILE * fd;
	char num[10],buf[100],ip_buf[22];
	char *temp;
	int i,flag,tid,cid;
	BYTE ip[4];
	flag=0;
	system("echo \"s\" > /var/run/l2tp-control");
	for(i=0,flag=0;i<5;i++)
	{
		if((fd=fopen(L2TP_STATE_FILE,"r"))==NULL)
		{
			//printf("can't read file \n");
			//printf("try again times=%d\n",i+1);
			sleep(1);
			continue;
		}
		flag=1;
		break;
	}
	if(flag==0)//can't open file
		return 0;
	flag=0;//no read tid
	//printf("c\n\n");
	while(fgets(buf,100,fd)!=NULL)
	{
		if((temp=strstr(buf,"Tunnel , ID = "))!=NULL)//read Tunnel ID & remote IP
		{
			//printf("d\n\n");
			temp+=14;
			i=0;
			while(*temp != ' ')//save tid
			{
				num[i++]=*temp;
				temp++;
			}
			num[i]='\0';
			tid=atoi(num);
			//printf("tid=%d\n\n",tid);
			temp=buf+(strlen(buf)-1);
			//printf("1\n\n");
			while(*temp != ' ')
				temp=temp-1;
			//printf("2\n\n");
			//printf("temp=%s.\n\n",temp);
			i=0;
			temp=temp+1;
			while((*temp) != ':')//save remote IP
			{
				//printf("x\n\n");
				ip_buf[i++]=*temp;
				temp++;
			}
			//printf("3\n\n");
			ip_buf[i]='\n';
			ip_buf[i+1]=0;
			//printf("ip=%s\n",ip_buf);
			getIP(ip_buf,ip);
		}
		//printf("e\n\n");
		if((temp=strstr(buf,"Call , ID = "))!=NULL)//read Call ID
		{
			printf("f\n\n");
			temp+=12;
			i=0;
			while(*temp != ' ')//save cid
			{
				num[i++]=*temp;
				temp++;
			}
			num[i]=0;
			cid=atoi(num);
			for(i=0;vpn.connections[i].enable==1;i++);//find empty vpn connect [i]
			strcpy(vpn.connections[i].name,"*");
			strcpy(vpn.connections[i].pswd,"*");
			memcpy(vpn.connections[i].ip,ip,4);
			vpn.connections[i].enable=1;
			vpn.connections[i].type=3;
			vpn.connections[i].tid=tid;
			vpn.connections[i].cid=cid;
		}
		//printf("g\n\n");
	}//while end
	fclose(fd);
	return 1;
}
/*-----ip information-----*/
/*  0:error               */
/*  1:success             */
int ipinfo(char *name, ip_info_struct * ife)
{
	FILE *fd;
	char buf[80],temp[20];
	char *pt;
	int i,flag;
	int find = 0;	// use this var to specify we get the interface or not.
	//----set ip info
	system("ifconfig > /var/config/ife.conf");
	//----End
	sleep(1);
	for(i=0;i<5;i++)
	{
		if((fd=fopen("/var/config/ife.conf","r"))==NULL)
		{
			sleep(1);
			continue;
		}
		flag=1;
		break;
	}
	if(flag==0)
	{
		printf("can't open file");
		return 0;
	}
	flag=0;
	while(fgets(buf,80,fd)!=NULL)
	{
		flag = 1;
		find = 1;
		if((pt=strstr(buf,name))!=NULL && flag==0)
		{
			strcpy(ife->name,name);
			flag=1;
			if((pt=strstr(buf,"HWaddr "))!=NULL)
			{
				pt=pt+7;
				i=0;
				while(*pt!='\n')
				{
					temp[i++]=*pt;
					pt++;
				}
				temp[i]='\0';
				strcpy(ife->HWaddr,temp);
			}
		}
		if(flag==1)//get the interface at pt
		{
			if((pt=strstr(buf,"addr:"))!=NULL)
			{
				pt=pt+5;
				i=0;
				while(*pt!=' ')
				{
					temp[i++]=*pt;
					pt++;
				}
				temp[i]='\n';
				temp[i+1]='\0';
				getIP(temp,ife->ip);
				flag=0;
			}
			if((pt=strstr(buf,"Bcast:"))!=NULL)
			{
				pt=pt+6;
				i=0;
				while(*pt!=' ')
				{
					temp[i++]=*pt;
					pt++;
				}
				temp[i]='\n';
				temp[i+1]='\0';
				getIP(temp,ife->bcast);
			}
			if((pt=strstr(buf,"Mask:"))!=NULL)
			{
				pt=pt+5;
				i=0;
				while(((*pt >= '0') && (*pt <= '9')) || (*pt == '.'))
				{
					temp[i++]=*pt;
					pt++;
				}
				temp[i]='\n';
				temp[i+1]='\0';
				getIP(temp,ife->mask);
			}
		}
	}
	fclose(fd);
	unlink("/var/config/ife.conf");
	if(!find)	// we cannot find the interface, so we store some information into ife to express.
	{
		// interface
		sprintf(ife->name, "none");
		sprintf(temp, "0.0.0.0\n");
		getIP(temp, ife->ip);
		// netmask
		sprintf(temp, "255.255.255.255\n");
		getIP(temp, ife->mask);
		// broadcast
		sprintf(temp, "0.0.0.0\n");
		getIP(temp, ife->bcast);
		// ether addr
		sprintf(ife->HWaddr, "Cannot used!");
	}
	return 1;
}
/*-----End ip information-----*/

/*-----url block Main Menu----*/
int urlblockMainMenu(ACONFIG * a)
{
	char command[80],ch;
	int i,temp;
	char *state[2]={"Disable",
			"Enable",
			};
	char *title="http URL blocking Main Menu";
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",title);
		printf("%s",topLine);
		printf("%s",line);
		i=(a->ids.flag[1]&0x08)>>3;
		printf("\t|\t(1)State\t\t\t\t%7s\t\t\t|\n",state[i]);
		printf("\t|\t(2)Proxy port\t\t\t\t%d\t\t\t|\n",a->ids.urlblock.proxy);
		printf("\t|\t(3)Edit url list\t\t\t\t\t\t|\n");
		printf("\t|\t(s)Save and Rest\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (1~G),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 's':
			if((a->ids.flag[1]&0x08)==0x08)
			{//ON
				setids_urlblock(0);
				write_Aconfig(a);
				setids_urlblock(1);
			}
			else
			{//OFF
				setids_urlblock(0);
				write_Aconfig(a);
			}
			break;
		case '1':
			if((a->ids.flag[1]&0x08)==0x08)
			{//OFF
				a->ids.flag[1]=a->ids.flag[1]&(~0x08);
			}
			else
			{//ON
				a->ids.flag[1]=a->ids.flag[1]|0x08;
			}
			break;
		case '2':
			printf("Proxy Port[1~65536]:");
			fgets(command,80,stdin);
			getPort(command,&(a->ids.urlblock.proxy));
			break;
		case '3':
			urlblocklist(a);
			break;
		case 'b':
			return 0;
		default:
			continue;
		}//switch end
	}//while end
	return 0;
}
/*-----End url block Main Menu----*/

/*-----url block list-----*/
int urlblocklist(ACONFIG *a)
{
	char command[80],ch;
	int i,page,temp;
	char *line="+-----------------------------------------------------------------------+\n";
	char *title="http URL blocking list";
	page =0;
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t%s\n",title);
		printf("%s",topLine);
		printf("%s",line);
		for(i=0;i<10;i++)
			printf("(%d)%-80s\n",page*10+(i+1),a->ids.urlblock.url[page*10+i].string);
		printf("[Page%2d]\t\t\t\t\t\t\n",page+1);
		printf("%s",line);
		printf("|(U)page up\t\t\t\t\t\t\t\t|\n");
		printf("|(D)page down\t\t\t\t\t\t\t\t|\n");
		printf("|(G)Go page?\t\t\t\t\t\t\t\t|\n");
		printf("|(a)Add new URL\t\t\t\t\t\t\t\t|\n");
		printf("|(d)Delete a URL\t\t\t\t\t\t\t|\n");
		//printf("|(s)Save and Rest\t\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (1~G),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 'D':
			if(page==9)
				page=-1;
			page=page+1;
			break;
		case 'U':
			if(page==0)
				page=10;
			page=page-1;
			break;
		case 'G':
			printf("go to page?");
			fgets(command,80,stdin);
			command[strlen(command)-1]=0;
			temp=atoi(command);
			if(temp<1 || temp>10)
				continue;
			page=temp-1;
			break;
		case 'a':
			printf("url:");
			fgets(command,80,stdin);
			command[strlen(command)-1]=0;
			add_url(a,command);
			break;
		case 'd':
			printf("delet which?");
			fgets(command,80,stdin);
			command[strlen(command)-1]=0;
			del_url(a, atoi(command));
			break;
		case 'b':
			return 0;
		default:
			continue;
		}//switch end
	}//while end
	return 0;
}
/*-----url block list-----*/

/*-----save IP info-----*/
int saveIPinfo(ACONFIG *a)
{
	FILE *fd;
	int i;
	ip_info_struct ife;
	ipinfo("eth1", &ife);
	printf("ipinfo ok\n");
	for(i = 0; i < 5; i++)
	{
		fd=fopen(IP_INFO_FILE,"w");
		if(fd == NULL)
			continue;
		else
			break;
	}
	if(fd == NULL)
	{
		printf("saveIPinfo: cannot open file %s.\n", IP_INFO_FILE);
		return 1;
	}
	else
		printf("open file ok\n");// IMPORTANT!!!   delete this will cause error!!!
	fprintf(fd,"%d.%d.%d.%d\n",ife.ip[0],ife.ip[1],ife.ip[2],ife.ip[3]);//save ip
	fclose(fd);
	printf("save ip ok\n");

	for(i = 0; i < 5; i++)
	{
		fd=fopen(DNS_INFO_FILE,"w");
		if(fd == NULL)
			continue;
		else
			break;
	}
	if(fd == NULL)
	{
		printf("saveIPinfo: cannot open file %s.\n", DNS_INFO_FILE);
		return 1;
	}
	else
		printf("");// IMPORTANT!!!   delete this will cause error!!!
	fprintf(fd,"nameserver %d.%d.%d.%d\n",a->local.rhnm[0],a->local.rhnm[1],a->local.rhnm[2],a->local.rhnm[3]);
	fclose(fd);
	return 0;
}
/*-----End save IP info-----*/

/* *********** */
/* find getway */
/* *********** */

int htoi_GW(char *src, int len)
{
	int i;
	int result;

	for(result = 0, i = 0; i < len; i++)
	{
		if(src[i] >= '0' && src[i] <= '9')
			result += (src[i] - '0') * (i == len - 1 ? 1 : 16 * (len - i - 1));
		else
			result += (src[i] - 'A' + 10) * (i == len - 1 ? 1 : 16 * (len - i - 1));
	}

	return result;
}


int findGW(ip_info_struct * ife)
{
	FILE *route;
	FILE *gw;
	char buffer[129];
	int before_pos;
	int index;
#ifdef DEBUG
	char temp[9];
#endif

	route = fopen(ROUTE_PATH, "r");
	if(route == NULL)
	{
		fclose(route);
#ifdef DEBUG
		fprintf(stderr, "%s: Cannot open file \"%s\".\n", argv[0], ROUTE_PATH);
#endif
		return 0;
	}

	fseek(route, 128L, SEEK_SET);
	before_pos = ftell(route);

	fgets(buffer, 129, route);
	while(strlen(buffer) != 0)
	{
		if(ftell(route) == before_pos)
		{
#ifdef DEBUG
			fprintf(stderr, "%s: Reach the end of file.\n", argv[0]);
#endif
			break;
		}
		else
		{
			before_pos = ftell(route);
		}

		index = 0;
		while(buffer[index] != '\t')
			index++;
		index++;
#ifdef DEBUG
		strncpy(temp, buffer + index, 8);
		temp[8] = 0;
		fprintf(stderr, "%s: We may get the string of destination: %s.\n", argv[0], temp);
#endif
		if(strncmp(buffer + index, "00000000", 8))
		{
#ifdef DEBUG
			fprintf(stderr, "%s: %s is not the default destination.\n", argv[0], temp);
#endif
			fgets(buffer, 129, route);
			continue;
		}
		else
		{
#ifdef DEBUG
			fprintf(stderr, "%s: We get the default destination.\n", argv[0]);
#endif
			while(buffer[index] != '\t')
				index++;
			index++;
#ifdef DEBUG
			gw = fopen(GW_PATH, "w");
			fprintf(gw, "%d.%d.%d.%d", htoi_GW(buffer + index + 6, 2), htoi_GW(buffer + index + 4, 2), htoi_GW(buffer + index + 2, 2), htoi_GW(buffer + index, 2));
			fclose(gw);
#endif
			ife->gw[0]=htoi_GW(buffer + index, 2);
			ife->gw[1]=htoi_GW(buffer + index + 2, 2);
			ife->gw[2]=htoi_GW(buffer + index + 4, 2);
			ife->gw[3]=htoi_GW(buffer + index + 6, 2);
			break;
		}
	}
	fclose(route);
	return 1;
}

/*-----virus scan Main Menu----*/
int virusScanMainMenu(ACONFIG * a)
{
	char command[80],ch;
	int i,temp;
	char *state[2]={"Disable",
			"Enable",
			};
	char *title="Virus Scan Main Menu";
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",title);
		printf("%s",topLine);
		printf("%s",line);
		i=(a->ids.flag[1]&0x20)>>5;
		printf("\t|\t(1)State\t\t\t\t%7s\t\t\t|\n",state[i]);
		printf("\t|\t(2)Edit virus list\t\t\t\t\t\t|\n");
		printf("\t|\t(s)Save and Rest\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (1~G),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 's':
			if((a->ids.flag[1]&0x20)==0x20)
			{
			//ON
				//fprintf(stdout,"1\n");
				setids_virusscan(0);
				//fprintf(stdout,"2\n");
				write_Aconfig(a);
				//fprintf(stdout,"3\n");
				setids_virusscan(1);
				//fprintf(stdout,"4\n");
			}
			else
			{//OFF
				//printf("5\n");
				setids_virusscan(0);
				//printf("6\n");
				write_Aconfig(a);
				//printf("7\n");
			}
			break;
		case '1':
			if((a->ids.flag[1]&0x20)==0x20)
				a->ids.flag[1]=a->ids.flag[1]&(~0x20);//turn OFF
			else
				a->ids.flag[1]=a->ids.flag[1]|0x20;//turn ON
			break;
		case '2':
			viruslist(a);
			break;
		case 'b':
			return 0;
		default:
			continue;
		}//switch end
	}//while end
	return 0;
}
/*-----End virus scan Main Menu----*/

/*-----virus pattern list-----*/
int viruslist(ACONFIG *a)
{
	char command[80],ch;
	int i,page,temp;
	char *line="+-----------------------------------------------------------------------+\n";
	char *title="Virus Pattern list";
	int protocol;
	int port;
	page =0;
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t%s\n",title);
		printf("%s",topLine);
		printf("%s",line);
		printf(" protocal\tport\t\t\tpattern\n");
		for(i=0;i<10;i++)
		{
			if ( a->ids.virus[page*10+i].pattern[0] == 0 )
				printf("(%d)\n", page*10+(i+1));
			else
			{
				if(a->ids.virus[page*10+i].protocol == 0)
					printf("(%d)tcp %5d %-80s\n",page*10+(i+1),a->ids.virus[page*10+i].port,a->ids.virus[page*10+i].pattern);
				else
					printf("(%d)udp %5d %-80s\n",page*10+(i+1),a->ids.virus[page*10+i].port,a->ids.virus[page*10+i].pattern);
			}
		}
		printf("[Page%2d]\t\t\t\t\t\t\n",page+1);
		printf("%s",line);
		printf("|(U)page up\t\t\t\t\t\t\t\t|\n");
		printf("|(D)page down\t\t\t\t\t\t\t\t|\n");
		printf("|(G)Go page?[1~5]\t\t\t\t\t\t\t|\n");
		printf("|(a)Add new virus pattern\t\t\t\t\t\t|\n");
		printf("|(d)Delete a virus pattern\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (1~G),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 'D':
			if(page==4)
				page= -1;
			page=page+1;
			break;
		case 'U':
			if(page==0)
				page=5;
			page=page-1;
			break;
		case 'G':
			printf("go to page?");
			fgets(command,80,stdin);
			command[strlen(command)-1]=0;
			temp=atoi(command);
			if(temp<1 || temp>10)
				continue;
			page=temp-1;
			break;
		case 'a':
			printf("protocal (0)tcp or (1)udp?[0/1]");
			fgets(command,80,stdin);
			if(strlen(command)>2)
				continue;
			command[strlen(command)-1]=0;
			protocol = atoi(command);
			printf("port [1~65535]?");
			fgets(command,80,stdin);
			if(strlen(command)>6)
				continue;
			command[strlen(command)-1]=0;
			port = atoi(command);
			printf("pattern?");
			fgets(command,80,stdin);
			command[strlen(command)-1]=0;
			if(add_virus(a,protocol,port,command))
				printf("Add success\n");
			else
				printf("Add error\n");
			break;
		case 'd':
			printf("delet which?");
			fgets(command,80,stdin);
			command[strlen(command)-1]=0;
			if(del_virus(a, atoi(command)))
				printf("Delet success");
			else
				printf("Delet error");
			break;
		case 'b':
			return 0;
		default:
			continue;
		}//switch end
	}//while end
	return 0;
}
/*-----End virus pattern list-----*/

/*-----DNS Main Menu----*/
int dnsMainMenu(ACONFIG * a)
{
	char command[80],ch;
	int i,temp;
	char *state[2]={"Disable",
			"Enable",
			};
	char *title="DNS Main Menu";
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",title);
		printf("%s",topLine);
		printf("%s",line);
		i=(a->ids.flag[1]&0x04)>>2;
		printf("\t|\t(1)State\t\t\t\t%7s\t\t\t|\n",state[i]);
		printf("\t|\t(2)WAN DNS\t\t\t%3d.%3d.%3d.%3d\t\t\t|\n",
			a->ids.dns_scan.wan_dns[0],
			a->ids.dns_scan.wan_dns[1],
			a->ids.dns_scan.wan_dns[2],
			a->ids.dns_scan.wan_dns[3]);
		printf("\t|\t(3)LAN DNS\t\t\t%3d.%3d.%3d.%3d\t\t\t|\n",
			a->local.rhip[0],
			a->local.rhip[1],
			a->local.rhip[2],
			a->ids.dns_scan.lan_dns);
		printf("\t|\t(s)Save and Rest\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (1~3),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 's':
			if((a->ids.flag[1]&0x04)==0x04)
			{//ON
				setids_dns(0);
				write_Aconfig(a);
				setids_dns(1);
			}
			else
			{//OFF
				setids_dns(0);
				write_Aconfig(a);
			}
			break;
		case '1':
			if((a->ids.flag[1]&0x04)==0x04)
			{//OFF
				a->ids.flag[1]=a->ids.flag[1]&(~0x04);
			}
			else
			{//ON
				a->ids.flag[1]=a->ids.flag[1]|0x04;
			}
			break;
		case '2':
			printf("WAN DNS?[x.x.x.x]");
			fgets(command,80,stdin);
			getIP(command,a->ids.dns_scan.wan_dns);
			break;
		case '3':
			printf("LAN DNS?%d.%d.%d.",
			a->local.rhip[0],
			a->local.rhip[1],
			a->local.rhip[2]);
			fgets(command,80,stdin);
			if(strlen(command) <2 || strlen(command) >6)
				continue;
			command[strlen(command)-1]=0;
			temp=atoi(command);
			if(temp <1 || temp >254)
				continue;
			a->ids.dns_scan.lan_dns=temp;
			break;
		case 'b':
			return 0;
		default:
			continue;
		}//switch end
	}//while end
	return 0;
}
/*-----End DNS Main Menu----*/

/*-----Malicious Script Main Menu----*/
int mscriptMainMenu(ACONFIG * a)
{
	char command[80],ch;
	int i,temp;
	char *state[2]={"Disable",
			"Enable",
			};
	char *title="Malicious Script Main Menu";
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",title);
		printf("%s",topLine);
		printf("%s",line);
		i=(a->ids.flag[1]&0x10)>>4;
		printf("\t|\t(1)State\t\t\t\t%7s\t\t\t|\n",state[i]);
		printf("\t|\t(2)Proxy port\t\t\t\t%d\t\t\t|\n",a->ids.mscript_proxy);
		printf("\t|\t(s)Save and Rest\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (1~3),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 's':
			if((a->ids.flag[1]&0x10)==0x10)
			{//ON
				setids_mscript(0);
				write_Aconfig(a);
				setids_mscript(1);
			}
			else
			{//OFF
				setids_mscript(0);
				write_Aconfig(a);
			}
			break;
		case '1':
			if((a->ids.flag[1]&0x10)==0x10)
			{//OFF
				a->ids.flag[1]=a->ids.flag[1]&(~0x10);
			}
			else
			{//ON
				a->ids.flag[1]=a->ids.flag[1]|0x10;
			}
			break;
		case '2':
			printf("Proxy?[0~65535]");
			fgets(command,80,stdin);
			getPort(command,&(a->ids.mscript_proxy));
			break;
		case 'b':
			return 0;
		default:
			continue;
		}//switch end
	}//while end
	return 0;
}
/*-----End Malicious Script Main Menu----*/

/*-----mail address Main Menu----*/
int mailblockMainMenu(ACONFIG * a)
{
	char command[80],ch;
	int i,temp;
	char *state[2]={"Disable",
			"Enable",
			};
	char *title="Mail Bomb Main Menu";
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",title);
		printf("%s",topLine);
		printf("%s",line);
		i=(a->ids.flag[1]&0x40)>>6;
		printf("\t|\t(1)Mail address block State\t\t%7s\t\t\t|\n",state[i]);
		printf("\t|\t(2)Edit url list\t\t\t\t\t\t|\n");
		i=(a->ids.flag[1]&0x80)>>7;
		printf("\t|\t(3)Mail flow control State\t\t%7s\t\t\t|\n",state[i]);
		printf("\t|\t(4)Alow total number of sender a day\t\t%d\t\t|\n",a->ids.mbomb2.total_sender);
		printf("\t|\t(5)Alow total number of mails a day\t\t%d\t\t|\n",a->ids.mbomb2.total_mails);
		printf("\t|\t(s)Save and Rest\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (1~5),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 's':
			if(((a->ids.flag[1]&0x40)==0x40)  || ((a->ids.flag[1]&0x80)==0x80) )
			{//mbomb1 on
				setids_mailblock(0);
				write_Aconfig(a);
				setids_mailblock(1);
			}
			else
			{//OFF
				setids_mailblock(0);
				write_Aconfig(a);
			}
			break;
		case '1':
			if((a->ids.flag[1]&0x40)==0x40)
			{//OFF
				a->ids.flag[1]=a->ids.flag[1]&(~0x40);
			}
			else
			{//ON
				a->ids.flag[1]=a->ids.flag[1]|0x40;
			}
			break;
		case '2':
			mailblocklist(a);
			break;
		case '3':
			if((a->ids.flag[1]&0x80)==0x80)
			{//OFF
				a->ids.flag[1]=a->ids.flag[1]&(~0x80);
			}
			else
			{//ON
				a->ids.flag[1]=a->ids.flag[1]|0x80;
			}
			break;
		case '4':
			printf("total number of sender?[0~65535]");
			fgets(command,80,stdin);
			command[strlen(command)-1]=0;
			if(strlen(command)< 1 || strlen(command) > 5)
				continue;
			temp=atoi(command);
			if(temp <0 || temp >65535)
				continue;
			a->ids.mbomb2.total_sender=temp;
			break;
		case '5':
			printf("total number of sender?[0~65535]");
			fgets(command,80,stdin);
			command[strlen(command)-1]=0;
			if(strlen(command)< 1 || strlen(command) > 5)
				continue;
			temp=atoi(command);
			if(temp <0 || temp >65535)
				continue;
			a->ids.mbomb2.total_mails=temp;
			break;

		case 'b':
			return 0;
		default:
			continue;
		}//switch end
	}//while end
	return 0;
}
/*-----End mail address Main Menu----*/

/*-----Mail address list-----*/
int mailblocklist(ACONFIG *a)
{
	char command[80],ch;
	int i,page,temp;
	char *line="+-----------------------------------------------------------------------+\n";
	char *title="Mail address block list";
	page =0;
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t%s\n",title);
		printf("%s",topLine);
		printf("%s",line);
		for(i=0;i<10;i++)
			printf("(%d)%-80s\n",page*10+(i+1),a->ids.mailblock[page*10+i].string);
		printf("[Page%2d]\t\t\t\t\t\t\n",page+1);
		printf("%s",line);
		printf("|(U)page up\t\t\t\t\t\t\t\t|\n");
		printf("|(D)page down\t\t\t\t\t\t\t\t|\n");
		printf("|(G)Go page?\t\t\t\t\t\t\t\t|\n");
		printf("|(a)Add new address\t\t\t\t\t\t\t|\n");
		printf("|(d)Delete a address\t\t\t\t\t\t\t|\n");
		//printf("|(s)Save and Rest\t\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (1~G),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 'D':
			if(page==9)
				page=-1;
			page=page+1;
			break;
		case 'U':
			if(page==0)
				page=10;
			page=page-1;
			break;
		case 'G':
			printf("go to page?");
			fgets(command,80,stdin);
			command[strlen(command)-1]=0;
			temp=atoi(command);
			if(temp<1 || temp>10)
				continue;
			page=temp-1;
			break;
		case 'a':
			printf("address:");
			fgets(command,80,stdin);
			command[strlen(command)-1]=0;
			add_maddr(a,command);
			break;
		case 'd':
			printf("delet which?");
			fgets(command,80,stdin);
			command[strlen(command)-1]=0;
			del_maddr(a, atoi(command));
			break;
		case 'b':
			return 0;
		default:
			continue;
		}//switch end
	}//while end
	return 0;
}
/*-----End mail address list-----*/

/*-----send alert mail main menu-----*/
int sendalertmail(ACONFIG * a)
{
	char *type;
	char *title="Send Alert Mail Main Menu";
	int i,temp;
	char command[80],ch;
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t\t%s\n",title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\t|\t(1)Mail from:\t\t%s\t\t\t\t\t|\n",a->mailalert.mail_from);
		printf("\t|\t(2)Mail to 1:\t\t%s\t\t\t\t\t|\n",a->mailalert.list[0].mail_to);
		printf("\t|\t(3)Mail to 2:\t\t%s\t\t\t\t\t|\n",a->mailalert.list[1].mail_to);
		printf("\t|\t(4)Mail to 3:\t\t%s\t\t\t\t\t|\n",a->mailalert.list[2].mail_to);
		if(a->mailalert.enable==0)
			printf("\t|\t(5)Alert state:\t\tDisable\t\t\t\t\t|\n");
		else
			printf("\t|\t(5)Alert state:\t\tEnable\t\t\t\t\t|\n");
		printf("\t|\t(6)Alert table list\t\t\t\t\t\t|\n");
		printf("\t|\t(7)Clean Mail address 1~4\t\t\t\t\t|\n");
		printf("\t|\t(s)Save and Reset\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (1~7),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case 's':
			setsend(0);
			write_Aconfig(a);
			if(a->mailalert.enable==1)
			setsend(1);
			break;
		case '1':
			printf("Mail from:");
			fgets(command,80,stdin);
			if(strlen(command)<4)
				continue;
			command[strlen(command)-1]=0;
			strcpy(a->mailalert.mail_from, command);
			break;
		case '2':
		case '3':
		case '4':
			temp=ch-'0';
			temp=temp-2;
			printf("Mail to%d:",temp+1);
			fgets(command,80,stdin);
			if(strlen(command)<4)
				continue;
			command[strlen(command)-1]=0;
			strcpy(a->mailalert.list[temp].mail_to, command);
			break;
		case '5':
			a->mailalert.enable= -1*(a->mailalert.enable -1);
			break;
		case '6':
			alerttablelist(a);
			break;
		case '7':
			printf("clean which one?[1~4]");
			fgets(command,80,stdin);
			if(strlen(command)>2)
				continue;
			command[strlen(command)-1]=0;
			i=atoi(command);
			if(i==1)
				a->mailalert.mail_from[0]=0;
			else
				a->mailalert.list[i-2].mail_to[0]=0;
			break;
		case 'b':
			return 0;
			break;
		default:
			continue;
		}//switch end
	}//while end
	return 1;
}
/*-----End send alert mail main menu-----*/

/*-----Alert table list-----*/
int alerttablelist(ACONFIG *a)
{
	char command[80],ch;
	int i,page,temp;
	char *line="+-----------------------------------------------------------------------+\n";
	char *title="Alert table list";
	char *state[2]={"Disable",
			"Enable",
			};
	page =0;
	while(1)
	{
		system("clear");
		printf("%s",topLine);
		printf("\t\t\t%s\n",title);
		printf("%s",topLine);
		printf("%s",line);
		printf("\tAttack name\t\tEmergency(Send Mail)\n");
		printf("%s",line);
		for(i=0;i<10;i++)
		{
			if(a->mailalert.alert_table[page*10+i].logname[0]==0)
				continue;
			printf("(%d)%-35s\t%s\n",i,a->mailalert.alert_table[page*10+i].logname,state[a->mailalert.alert_table[page*10+i].emergency]);
		}
		printf("   [Page%2d]\n",page+1);
		printf("%s",line);
		printf("|(U)page up\t\t\t\t\t\t\t\t|\n");
		printf("|(D)page down\t\t\t\t\t\t\t\t|\n");
		printf("%s",line);
		printf("\tPlease enter your choice (0~9),or press 'b' to back.\n");
		fgets(command,80,stdin);
		if(strlen(command)!=2)
			continue;
		ch=command[0];
		switch (ch){
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
			i=ch-'0';
			i=page*10+i;
			a->mailalert.alert_table[i].emergency= -1 * (a->mailalert.alert_table[i].emergency - 1) ;
			break;
		case 'D':
			if(page==1)
				page=-1;
			page=page+1;
			break;
		case 'U':
			if(page==0)
				page=2;
			page=page-1;
			break;
		case 'b':
			return 0;
		default:
			continue;
		}//switch end
	}//while end
	return 0;
}
/*-----End alert table list-----*/





