#ifndef __AMIT_H
#define __AMIT_H

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "ver.h"

//#ifdef	LITTLE
#ifndef BRECIS
  #define H2BS(s)	(s)
  #define B2HS(s)	(s)
  #define H2BL(l)	(l)
  #define B2HL(l)	(l)
  #define L2BS(x)	(x)
  #define L2BL(x)	(x)
#else
//  #define H2BS(s)	htons(s)
  #define H2BS(x)       ((unsigned short)(x<<8) | (unsigned short)(x>>8))
  #define B2HS(s)	ntohs(s)
  #define B2HL(l)	ntohl(l)
  #define L2BS(x)	((unsigned short)(x<<8) | (unsigned short)(x>>8))	//wallance 90.11.22
  #define L2BL(x)	(((unsigned long)(x)<<24) |           \
		        (((unsigned long)(x)&0xFF00)<<8) |    \
			(((unsigned long)(x)>>8)&0xFF00) |    \
			((unsigned long)(x)>>24))
  //#define H2BL(l)	htonl(l)
  #define H2BL(l)	L2BL(l)
/*
  #define H2BL(x)         ((((unsigned long)(x)&0x000000FF)<<24) |  \
                          (((unsigned long)(x)&0x0000FF00)<<8) |    \
                          (((unsigned long)(x)>>8)&0xFF00) |        \
                          ((unsigned long)(x)>>24))
*/
#endif	//LITTLE

#define DISABLE()	//do nothing
#define ENABLE()	//do nothing

/* QB=Quad-Byte, DB=Dual-Byte
   UL=Unsigned-Long, SL=Signed-Long
   US=Unsigned-Short, SS=Signed-Short */
#define QB2UL(x)        (*(unsigned long*)(x))
#define QB2SL(x)        (*(signed long*)(x))
#define DB2US(x)        (*(unsigned short*)(x))
#define DB2SS(x)        (*(signed short*)(x))

/* commonly used type */
#define BYTE            unsigned char
#define WORD            unsigned short
#define DWORD           unsigned long

//time_util.c
#define CurrDeciSec	(get_current_time())

#if FOR_DEBUG > 1
  #define	Nprintf(x...)	printf(x)
#else
  #define	Nprintf(x...)	{}
#endif

#define	LANPORTNAME	"eth0"
#define WANPORTNAME	"eth1"

#define MAX_DATA	(1500-20-20)
#define BUFF_SIZE	(MAX_DATA+8)

#define AOC_PEER_CLOSE		100
#define AOC_SERV_TIMEOUT	101

/*********************/
/* for resource data */
/*********************/

/*  RESLANG(0) default
    RESLANG(1) post-setting
*/
//char *normalize_segoff_address(char *base, unsigned long offset);	//marked by wallance 90.11.29 -- defined in common.c
//#define RESDATA(x)  normalize_segoff_address((char*)0xE0000000L,*(unsigned long*)(0xE0000020L+sizeof(long)*x))	//old code --wallance
//#define RESDATA(x)  normalize_segoff_address((char*)DATA_BASE,*(unsigned long*)(DATA_BASE+0x20+sizeof(long)*x))	//wallance 90.11.26
#define RESDATA(x)  (unsigned char*)(FLASH_START + DATA_START + *(unsigned long*)(FLASH_START + DATA_START + DATA_OFS_ENTRY + (x<<2)))	//wallance 90.11.29

#define RES_IDX_NUM_URITAB      0
#define RES_IDX_PAGESDATA       1
#define RES_IDX_PAGE_HEAD       2
#define RES_IDX_BODY_HEAD       3
#define RES_IDX_DDNS_PROVIDER   3
#define RES_IDX_REBOOT_PAGE     4
#define RES_IDX_SSI_DATA        5
#define RES_IDX_UPNP_DATA       6
#define RES_IDX_ODM_DATA        7
#define RES_IDX_SNMP_DATA	8
#define RES_IDX_PATCH_OLV       9

#ifndef FARDATA
#define FARDATA
#endif

/*********************/
/* for configuration */
/*********************/

/* ODM customization BEGIN */
#define SMAP_NUM        26      /* default 8, no limit */
#define SPAP_NUM        16      /* default 4, limit:only 1.5K CGI buffer */
#define SPAP_SEPL_NUM   64      /* default 20: 21*SPAP_NUM+14*SPAP_SEPL_NUM */
#define AGRP_NUM        8       /* default 4, limit:only 1.5K CGI buffer */
#define AGRP_PORTS      32      /* default 20  */
#define PMAC_NUM        64      /* default 32  */
#define RTAB_NUM        32      /* default 10  */
#define MNAT_NUM        32      /* default 16  */
#define DCTL_RULE_NUM   20
#define DCTL_SUFFIX_SZ  64
/* ODM customization END */

#define PF_RULE_NUM     48       /* number packet filter rules */

typedef struct {
    BYTE    dip[4];          // destination ip address
    BYTE    dnm[4];          // destination subnet mask
    BYTE    dgw[4];          // default gateway
    BYTE    dif;             // destination interface -- 0: LAN, 1: WAN, else reserved
    BYTE    hop;             // hop count (matrix)
    BYTE    flag;            // flag for Static Routing
    BYTE    enable_flags;    // bit0: enable/disable; else reserved
} STRoutingTableEntry;


/* when this structure is changed, please review side-effect in
   CGI.C. Which items must take effect after setup? */
typedef struct {
    /* (8) header of configuration data */
    struct {
        WORD resvFFFF;  // ثeNȶJ 0xFFFF, HKª (R1.94f0 Τe) {ˬd config ɵoͿ~Ӧ۰ reset to default
        BYTE minor_ver;  // config  minor version
        BYTE major_ver;  // config  major version
                         // t downgrade , Yo{ flash W major version {Ҥ䴩ٷs, hj reset to default
        WORD    chksum;
        WORD    size;
    } header;
    /* (64) local configuration */
    struct {
        BYTE    ip[4];          /* important, recovering mode use it */
        char    host[16];
        char    pass[10];       // system password
        BYTE    wip[4];
        BYTE    wgw[4];
        BYTE    wnm[4];
        BYTE    rhip[4];
        BYTE    rhnm[4];
        BYTE    uwid[6];
        WORD    wflag;
        BYTE    wtype;          // WAN type
        BYTE    dmz_host;
        WORD    adm_to;         /* din_to; */
        BYTE    buivar;         /* din_ip; */
        BYTE    wtypex;         /* din_auth; */
        BYTE    upnp_disabled;  // 1: disable UPnP; 0: enable UPnP
        BYTE    led_mode;       // ѩ󤣦PȤ, i|ݭnP LED ܼҦ
                                // ]HذO LED ܼҦ
                                // C@ؼҦܤ覡, ثeO led_change_system_state {Mw
        BYTE    resv[2];
    } local;

    /* reserved */
    char resv_local[540];

    /* (512) ip flag */
    struct {
        WORD    val[256];
    } flag;
    /* (64) dhcp */
    struct {
        char    domain[32];
        //char    resv1[4];
        unsigned long lease;	// in secod. Default(=0) is DEF_LEASE_TIME
        struct {
                BYTE ip[4];
        } dns[2];
        struct {
                BYTE ip[4];
        } wins[2];
        BYTE    netmask[4];
        BYTE    enable;
        BYTE    range[2];
        char    resv2;
        char    gwip[4];        /* for CyberChannel only */
    } dhcp;
    /* (208) 8*26, server mapping */
    struct {
        WORD    port;
        WORD    uport;
        BYTE    host;
        BYTE    flag;
        char    resv_smap[2];    // for ARM9 alignment
    } smap[SMAP_NUM];         // SMAP_NUM = 26
    /* (384) 8*16+4*64, special application */
    struct {
        struct {
                WORD port;
                WORD downcount;
                BYTE sp0;
                BYTE sp1;
                BYTE flag;
                BYTE host;
        } trig[SPAP_NUM];       /* SPAP_NUM = 16 */
        struct {
                WORD lb;
                WORD ub;
        } sepl[SPAP_SEPL_NUM];  /* SPAP_SEPL_NUM = 64, Subsequence Enable Port List */
    } spap;
    /* (576) (8+2*32)*8, access control */
union {
    struct {
        BYTE    type;
        BYTE    count;
        WORD    ports[AGRP_PORTS];      // AGRP_PORTS = 32
        BYTE    resv[6];
    } agrp[AGRP_NUM];           // AGRP_NUM = 8
    struct {
        struct {
            DWORD       ip0[2];         // source ip. 0 for lowerbound, 1 for upperbound
            DWORD       ip1[2];         // target ip. 0 for lowerbound, 1 for upperbound
            WORD        port0[2];       // source port. 0 for lowerbound, 1 for upperbound
            WORD        port1[2];       // target port. 0 for lowerbound, 1 for upperbound
            DWORD       dresv;
            WORD        rflag;          // rule flag
            WORD        t_index;        // temp var to record original rule index
        } rule[PF_RULE_NUM*2];          // PF_RULE_NUM = 48. eb in bound, b out bound
        WORD    flag[2];		// 0 for inbound, 1 for outbound
        char    resv[56];
        short   t_count[2];
    } ipf;
} actl;
    /* (4) reserved */
    char resv4[4];
    /* (256) access point */
#if PSIS_SONIC_FAMILY()
    struct{
        char ssid[33];  // SSID
        char ssid_resv[32];
        BYTE channel; //channel
        BYTE security; //security. 0: no WEP; 1: 64-bit WEP; 2: 128-bit WEP; 3: 256-bit WEP
        BYTE select_wep_key;  //selected security key, range: 0 to 3
        BYTE wep_key[52];  //security key
                           // 64-bit:
                           //     52 bytes  4 , C@Ӭ 13 bytes
                           //     4  WEP keys Ob byte 0-5, 13-18, 26-31, 39-44 m
                           //     C WEP key u 5  bytes, ]OH WORD , ] 6  bytes
                           // 128-bit:
                           //     52 bytes  4 , C@Ӭ 13 bytes
                           //     4  WEP keys Ob byte 0-12, 13-25, 26-28, 39-51 m
                           // 256-bit:
                           //     52 bytes  2 , C@Ӭ 26 bytes
                           //     2  WEP keys Ob byte 0-25, 26-51 m
        char wep_key_resv[26];
        BYTE area_code;     // area code, this will used to decide what channels will be supported
        BYTE wireless_mode; // Wireless Mode. The meaning of value are defined as "WLAN_MODE_xxx" constants in wlan.h
        WORD basic_rate;    // Basic Rate. This field is a bit-map of basic data rates.
                            // Its value specifies the basic rates used
                            // and reported for this BSS by the AP.
                            // Bit       Data Rate
                            //  0           1 Mbps
                            //  1           2 Mbps
                            //  2         5.5 Mbps
                            //  3          11 Mbps
                            //  4          22 Mbps
                            // ***** NOTE *****
                            // The meaning of this item's value depends on the definition of both Intersil 802.11b and TI 802.11b+
        // 2001/10/25, by Aries
        BYTE pp_method;     // passphrase method:
                            // 0: hex (no passphrase)
                            // 1: Intersil
                            // 2: Lucent
        char pp_string[33]; // passphrase key string, max length=32
        WORD enhanced_security;  // Allows configuration of enhanced security items in the AP.
                                 // Bit       Control
                                 //  0        Hide SSID name in Beacon frame
                                 //  1        Block response to "Unspecified-SSID"
                                 // 2~15      Reserved (set to 0)
                                 // ***** NOTE *****
                                 // The meaning of this item's value depends on the definition of Intersil
        WORD frag_threshold;     // Fragmentation Threshold (Even number from 256 to 2346)
        WORD cts_rts_threshold;  // CTS/RTS Threshold
                                 // range: 0 ~ 3000 for Intersil 802.11b
                                 //        256 ~ 2432 for TI 802.11b+
        WORD supported_rate;     // Supported Rate. This field is a bit-map of basic data rates.
                                 // Its value specifies the basic rates used
                                 // and reported for this BSS by the AP.
                                 // Bit       Data Rate
                                 //  0           1 Mbps
                                 //  1           2 Mbps
                                 //  2         5.5 Mbps
                                 //  3          11 Mbps
                                 //  4          22 Mbps
                                 // ***** NOTE *****
                                 // The meaning of this item's value depends on the definition of both Intersil 802.11b and TI 802.11b+
        BYTE prev_security;      // OϥΪ̤W@ܪ security type
                                 // HKbϥΪ̭쥻FY WEP Type, F WEP,
                                 // MS^_쥻 WEP type , ڭ̥iHܥT WEP 
                                 // 0: no WEP; 1: 64-bit WEP; 2: 128-bit WEP; 3: 256-bit WEP
        char resv[63];           // reserved
    } apnt;
#elif PSIS_SONICPLUS_FAMILY()
    struct{
        char ssid[32];  // SSID
        BYTE channel; //channel
        BYTE pp_method;     // passphrase method:
                            // 0: hex (no passphrase)
                            // 1: Intersil
                            // 2: Lucent
        BYTE security; //security. 0: no WEP; 1: 64-bit WEP; 2: 128-bit WEP; 3: 256-bit WEP
        BYTE select_wep_key;  //selected security key, range: 0 to 3
        BYTE wep_key[120]; //security key
                           // 64-bit:
                           //     52 bytes  4 , C@Ӭ 13 bytes
                           //     4  WEP keys Ob byte 0-5, 13-18, 26-31, 39-44 m
                           //     C WEP key u 5  bytes, ]OH WORD , ] 6  bytes
                           // 128-bit:
                           //     52 bytes  4 , C@Ӭ 13 bytes
                           //     4  WEP keys Ob byte 0-12, 13-25, 26-28, 39-51 m
                           // 256-bit:
                           //     52 bytes  2 , C@Ӭ 26 bytes
                           //     2  WEP keys Ob byte 0-25, 26-51 m
        char pp_string[32]; // passphrase key string, max length=32
        BYTE area_code;     // area code, this will used to decide what channels will be supported
        BYTE wireless_mode; // Wireless Mode. The meaning of value are defined as "WLAN_MODE_xxx" constants in wlan.h
        WORD basic_rate;    // Basic Rate. This field is a bit-map of basic data rates.
                            // Its value specifies the basic rates used
                            // and reported for this BSS by the AP.
                            // Bit       Data Rate
                            //  0           1 Mbps
                            //  1           2 Mbps
                            //  2         5.5 Mbps
                            //  3          11 Mbps
                            //  4          22 Mbps
                            // ***** NOTE *****
                            // The meaning of this item's value depends on the definition of both Intersil 802.11b and TI 802.11b+
        WORD enhanced_security;  // Allows configuration of enhanced security items in the AP.
                                 // Bit       Control
                                 //  0        Hide SSID name in Beacon frame
                                 //  1        Block response to "Unspecified-SSID"
                                 // 2~15      Reserved (set to 0)
                                 // ***** NOTE *****
                                 // The meaning of this item's value depends on the definition of Intersil
        WORD frag_threshold;     // Fragmentation Threshold (Even number from 256 to 2346)
        WORD cts_rts_threshold;  // CTS/RTS Threshold
                                 // range: 0 ~ 3000 for Intersil 802.11b
                                 //        256 ~ 2432 for TI 802.11b+
        WORD supported_rate;     // Supported Rate. This field is a bit-map of basic data rates.
                                 // Its value specifies the basic rates used
                                 // and reported for this BSS by the AP.
                                 // Bit       Data Rate
                                 //  0           1 Mbps
                                 //  1           2 Mbps
                                 //  2         5.5 Mbps
                                 //  3          11 Mbps
                                 //  4          22 Mbps
                                 // ***** NOTE *****
                                 // The meaning of this item's value depends on the definition of both Intersil 802.11b and TI 802.11b+
        BYTE prev_security;      // OϥΪ̤W@ܪ security type
                                 // HKbϥΪ̭쥻FY WEP Type, F WEP,
                                 // MS^_쥻 WEP type , ڭ̥iHܥT WEP 
                                 // 0: no WEP; 1: 64-bit WEP; 2: 128-bit WEP; 3: 256-bit WEP
        BYTE preamble_type;        // 0: long preamble;  1: short preamble
        BYTE authentication_type;  // 0: open system;  1: shared key;  2: Both
        BYTE antenna_selection;    // 1: Left antenna only;  2: Right antenna only;  3: Diversity;  0 N default  3
        WORD beacon_interval;      // range: 1 ~ 1000; : msec; 0 N default  100
        WORD DTIM_interval;        // range: 1 ~ 65535; 0 N default  3
        char resv[48];             // reserved
    } apnt;
#else
    char resv_apnt[256];           // reserved
#endif

    /* (520) 8+8*64 properties of MAC */
    struct {
        WORD flag;
        BYTE resv[6];
        struct {
            BYTE mac[6];
            BYTE ip;
            BYTE prop;
        } list[PMAC_NUM];  // PMAC_NUM = 64
    } pmac;
    /* (76) 8*5+36 local3 */
    struct {
        struct {
            BYTE    gip[4];     /* global IP */
            BYTE    lip;        /* local IP */
            BYTE    flag;
            char    resv_mnat[2];  // for alignment
        } mnat[MNAT_NUM];
        DWORD   real_max_speed;  // added by Herbert at 2002/01/17
        char    resv1[20];
        WORD    raport;
        BYTE    acct[2];
        BYTE    wolmac[6];
        char    resv2[2];
    } local3;

    // (4) Syslog
    struct {
        unsigned char enabled;   // does Syslog enabled. 1: enabled; 0: disabled
        unsigned char host_ip;   // host ip for Syslog
        char resv2[2];
    } syslog;

    /* (64) */
    char resv_syslog[64];

    /* (260) Email Alert */
    struct {
        unsigned short port;	// default=0 means using port 25.
    	BYTE enable;		// default=0 means disable
        BYTE select;		// what kinds of log will be emailed
        char smtp_server[64];	// DNS allowed
        char receiver[128];	// allow multiple receivers
        char subject[64];	// default is null string
    } emalt;

    /* (107) */
    char resv_emalt[107];

    /* (1536) acctpool1 */
    unsigned char use_acctpool2;  // 0: use acctpool1;  1: use acctpool2
    struct {
        char    desc[16];       /* DESCription */
        char    user[54];
        WORD    flag;           // auto-reconnect
        char    pass[24];
        char    tel[32];
        struct {
                BYTE ip[4];
        } dns[2];
        BYTE    ip[4];
        DWORD   baud;
        WORD    mtu;
        WORD    to;             // max. idle time
        char    init[82];
        char    resv[26];
    } acctpool[6];

    // (836) SNMP
    struct {
        unsigned short flags;
        char resv[2];
        unsigned char community[2][32];
        unsigned char  sys_contact[256];
        unsigned char  sys_name[256];
        unsigned char  sys_location[256];
    } psnmp;
    // (252) reserved for SNMP future using
    char        snmp_resv[252];
    // (4) Dynamic Routing
    struct {
    	unsigned short enable_flags;  // bit 0: to indicate whether RIP1/RIP2 is enabled or disabled
                                      // others: reserved
    	char resv[2];
    } dyna_route;
    // (512) Routing Table
    STRoutingTableEntry rtab[RTAB_NUM];
    /* 3244 (340) ddns */
    struct {
    	BYTE	flag;
    	BYTE	provider;
    	char    resv[2];
    	char	fqdn[64];	//Full Qualified Domain Name
    	char	user[64];	//username to login DDNS provider
    	char	pass[64];	//password to login DDNS provider, sometimes, e-mail address
    	char	cmds[256];	//command string
    } ddns;

    /* (128) */
    char resv_ddns[128];

    /* (4608) 256x16, acctpool2 */
    struct {
        char	desc[16];	//DESCription
        char    user[54];	//account name of ISP account
        WORD    flag;       // auto-reconnect
        char    pass[24];	//password of ISP account
        char    tel[32];	//Tel number for dial-up
        struct {
                BYTE ip[4];
        } dns[2];           //dns IP address
        BYTE    ip[4];		//WAN IP assigned by ISP
        DWORD   baud;       //baud rate
        WORD    mtu;
        WORD    to;
        char    init[82];
        BYTE    wtypex;		//extended WAN type (low byte of little endian word)
        BYTE    wtype;		//WAN type (high byte of little endian word)
        char    resv[56];
    } acctpool2[16];

    /* (128) */
    char resv_acctpool2[128];

    /* (80) Simple NTP */
    struct {
    	long tz_min;	// time zone offset, in minute; (can be negative)
    	char dnip[64];	// Time Server, domain name
    	BYTE autosync;	// Auto sync, 0:disable, maybe 1:per day, 2:per week,...
    	BYTE timezone;	// the index of SELECT with rspected to UI
    	char resv[10];
    } sntp;

    /* (128) */
    char resv_sntp[128];

    /* (132) 802.1X & RADIUS */
    struct {
    	unsigned long timeout;	// when to re-auth, in 0.1 second
    	char server[64];	// RADIUS server IP, domain name allowed
    	BYTE enable;		// default=0 :disable
    	char key[63];		// share key
    } radius;

    /* (128) */
    char resv_radius[128];

#ifdef _IPSEC

    #define MAX_NUMBER_OF_TUNNELS         16
    #define MAX_NUMBER_OF_IKE_PROPOSALS   20
    #define MAX_NUMBER_OF_IPSEC_PROPOSALS 20
    #define IPSEC_ENTRY_NAME_LEN          20

    /* (3652) IPSec */
    struct {

        char if_enable_ipsec;
        char max_number_of_tunnels;
        char resv[2];
        struct {
            char          tunnel_name[IPSEC_ENTRY_NAME_LEN];
                          //first char with 0 value stands for
                          //the tunnel information is not available
            BYTE          local_subnet[4];
            BYTE          local_netmask[4];
            BYTE          remote_subnet[4];
            BYTE          remote_netmask[4];
            BYTE          remote_gateway[4];
            unsigned char type_of_key_method;//0: IKE; 1: Manual
            char          resv[3];
            union {
                struct {
                    unsigned char ike_proposal_index[4];    // index of selected IKE proposal
                                                            // 0xff indicates no indexing
                                                            // at least one element with non-ff value
                    unsigned char ipsec_proposal_index[4];  // index of selected IPSec proposal
                                                            // 0xff indicates no indexing
                                                            // at least one element with non-ff value
                    unsigned char preshared_key[20];
                    char          resv[76];
                } ike;
                struct {
                    unsigned long local_spi;
                    unsigned long remote_spi;
                    unsigned char encryption_key[3][16];
                    //for ESP only; DES: 1*16 nibbles, 3DES: 3*16 nibbles
                    //value of a nibble is among the set of "0"~"9" and "a"~"f"
                    unsigned char encap_protocol;
                    //AH_TUNNEL(1); AH_TRANSPORT(2); ESP_TUNNEL(3);
                    //ESP_TRANSPORT(4); ESP_TUNNEL_WITH_AUTH(5);
                    //ESP_TRANSPORT_WITH_AUTH(6);
                    unsigned char encrypt_algorithm;
                    //0:none; 1:DES; 2:3DES
                    unsigned char auth_algorithm;
                    //0:none; 1:MD5; 2:SHA1
                    unsigned char life_time_unit;
                    //1:second; 2:KB;
                    unsigned char auth_key[40];
                    //SHA1: 20 bytes=40 nibbles;  MD5: 16 bytes;  None: 0 byte
                    //value of a nibble is among the set of "0"~"9" and "a"~"f"
                    unsigned long life_time;
                    //may be in second or KB unit
                } manual;
            } key_method ;

        } Tunnel_Info[MAX_NUMBER_OF_TUNNELS]; //16

        struct {
            char          proposal_name[IPSEC_ENTRY_NAME_LEN];
                          //first char with 0 value stands for
                          //the proposal is not available
            unsigned char dh_group;              // 1:MODP768, 2:MODP1024, 5:MODP1536
            unsigned char encrypt_algorithm;     // 5:3DES;  1:DES
            unsigned char auth_algorithm;        // 2:SHA1;  1:MD5
            unsigned char life_time_unit;        // 1:second;  2:Kbyte
            unsigned long life_time;
            char          resv[4];
        } IKE_Proposal_Pool[MAX_NUMBER_OF_IKE_PROPOSALS];

        struct {
            char          proposal_name[IPSEC_ENTRY_NAME_LEN];
                          //first char with 0 value stands for
                          //the proposal is not available
            unsigned char dh_group;              // 0:none 1:MODP768, 2:MODP1024, 5:MODP1536
            unsigned char encap_protocol;        // 3: ESP;  2: AH
            unsigned char encrypt_algorithm;     // 2: 3DES;  1: DES;  0: none only for AH
            unsigned char auth_algorithm;        // 2: SHA1;  1: MD5;  0: None for ESP only
            unsigned long life_time;             //
            unsigned char life_time_unit;        // 1: second; 2: Kbyte;
            char          resv[3];
        } IPSec_Proposal_Pool[MAX_NUMBER_OF_IPSEC_PROPOSALS];

    } ipsec;
#else
    char resv_ipsec[3652];
#endif  // ifdef _IPSEC

    /* O=0x1DF0 L=0x208(520) U=domain control */
    struct {
    	struct {
    	    char suffix[DCTL_SUFFIX_SZ];	//domain name suffix
    	    BYTE flag;		//bit0: 1=enable rule, bit1: 0=pass,1=block bit2=log
    	} rules[DCTL_RULE_NUM];
    	BYTE	privilege[2];	//ip range that have privilege
    	BYTE	flag;		//bit0: 1=enable all
    	                        //bit1: 0=pass, 1=block if no rule matched
    	                        //bit2: 1=log if no rule matched
    	                        //bit4: log enable
    	BYTE	resv_flag;
    	BYTE	resv[2];
    	int	rule_count;	//use as variable only, not configuration item
    } dctl;

} ACONFIG;


/*-------------------------------------------------------------------------------------
 * Add by Aries Wang, 2002/08/22
 * These definitions will be used between tasks, and I suggest to define them in amit.h,
 *   just like ARM-9, x86 serials do.
 *-------------------------------------------------------------------------------------*/
extern ACONFIG Aconfig;
extern char VersionName[];


#define PASSWD_SUPER    2
#define PASSWD_ROOT     1
#define PASSWD_NONE     0

#define IS_WT_PPP(x)    ((x)&0x02)
#define WT_STATIC       0x00
#define WT_DYNAMIC      0x01
#define WT_PPPOE        0x02    /* bit1 PPP 0010 */
#define WT_PPTP         0x03    /* bit1 PPP 0011 */
#define WT_DUN          0x06    /* bit1 PPP 0110 */

/* Aconfig.local.wtypex for Aconfig.local.wtype = WT_STATIC */
#define WTEX_STATIC      0x00	/* WAN type : static IP address */

/* Aconfig.local.wtypex for Aconfig.local.wtype = WT_DYNAMIC */
#define WTEX_DYNAMIC    0x00	/* WAN type : dynamic IP address */
#define WTEX_ROADRUNNER 0x01	/* WAN type : Road Runner Session Management (Telstra BigPond) */

/* Aconfig.local.wtypex for Aconfig.local.wtype = WT_PPPOE */
#define WTEX_PPPOE      0x00	/* WAN type : PPPoE */
#define WTEX_UNNUMBERED_PPPOE 0x01	/* WAN type : unnumbered PPPoE */
#define WTEX_MULTI_SESSION_PPPOE 0x02	/* WAN type : multi-session PPPoE */

/* Aconfig.local.wtypex for Aconfig.local.wtype = WT_PPTP */
#define WTEX_PPTP      0x00	/* WAN type : PPPT */

/* Aconfig.local.wtypex for Aconfig.local.wtype = WT_DUN */
#define WTEX_DUN       0x00	/* WAN type : dial-up network (PSTN/ISDN) */

// this should be not defined here!
#define Eid_SZ 6
struct Eid {unsigned char c[Eid_SZ];};
/* internal or IP address format */
#define Iid_SZ 4
typedef union {
    unsigned char  c[Iid_SZ];
    unsigned short s[Iid_SZ/2];
    unsigned long  l;
} Iid;


/*********************/
/* for local flag    */
/*********************/
#define LFLAG_DMZ       0x0001  /*DMZ host*/
#define LFLAG_ACTL      0x0002  /*Access ConTroL*/
#define LFLAG_RADM      0x0004  /*Remote ADMinistration*/
#define LFLAG_BWPING    0x0010  /*Block Wan PING*/
#define LFLAG_IOPF      0x0080  /*IO Packet Filter*/
#define LFLAG_EFFMASK   0x0013  /*take effective immediately*/

/*******************/
/* for Filter Flag */
/*******************/
#define FDF_ENABLED             0x0001
#define FDF_PASSRULE            0x0002

#define FRF_ENABLED             0x0001

#define FRF_PROT_SHIFT          6
#define FRF_PROT_MASK           0x00C0
#define FRF_PROT_BOTH           0x0000
#define FRF_PROT_TCP            0x0040
#define FRF_PROT_UDP            0x0080

#define FRF_DPORT_SHIFT         8
#define FRF_DPORT_MASK          0x0300
#define FRF_DPORT_SKIP          0x0000
#define FRF_DPORT_EQ            0x0100
#define FRF_DPORT_IN            0x0200

#define FRF_DIP_SHIFT           10
#define FRF_DIP_MASK            0x0C00
#define FRF_DIP_SKIP            0x0000
#define FRF_DIP_EQ              0x0400
#define FRF_DIP_IN              0x0800

#define FRF_SPORT_SHIFT         12
#define FRF_SPORT_MASK          0x3000
#define FRF_SPORT_SKIP          0x0000
#define FRF_SPORT_EQ            0x1000
#define FRF_SPORT_IN            0x2000

#define FRF_SIP_SHIFT           14
#define FRF_SIP_MASK            0xC000
#define FRF_SIP_SKIP            0x0000
#define FRF_SIP_EQ              0x4000
#define FRF_SIP_IN              0x8000

#define MAXPFLEN        256


#endif	//ifndef __AMIT_H
