/*
 * Copyright (c) 1985, 1988, 1990 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* #ifndef lint */
/* char copyright[] = */
/* "@(#) Copyright (c) 1985, 1988, 1990 Regents of the University of California.\n\ */
/*  All rights reserved.\n"; */
/* #endif */ /* not lint */

/* #ifndef lint */
/* static char sccsid[] = "@(#)ftpd.c	6 (mjr) 4/1/95"; */
/* #endif */ /* not lint */

/*
 * FTP server.
 */
#include <sys/param.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/wait.h>

#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>

#define	FTP_NAMES
#include "ftp.h"
#include <arpa/inet.h>
#include <arpa/telnet.h>

#include <signal.h>
#include <dirent.h>
#include <fcntl.h>
#include <time.h>
#include <setjmp.h>
#include <netdb.h>
#include <errno.h>
#ifndef SOCK_STREAM
#define SOCK_STREAM       2
#endif

extern	int	errno;

#include <syslog.h>
#include <unistd.h>
#include <stdio.h>

#include <ctype.h>
#include <stdlib.h>
#include <string.h>



#include <getopt.h>
#include <stdarg.h>

#include "aftpd.h"

/*
	I have been all over this code with a chainsaw just like
that guy in DOOM.

mjr.
*/


static	void		lostconn();
static	void		myoob();
static	FILE		*getdatasock();
static	FILE		*dataconn();

void			dolog(struct sockaddr_in *);
void			dologout(int status);
void			perror_reply(int code, char *string);
int			send_data(FILE *instr, FILE *outstr, off_t blksize);
int			receive_data(FILE *instr, FILE *outstr);
int			exitstats();

static	struct	sockaddr_in ctrl_addr;
static	struct	sockaddr_in data_source;
static	struct	sockaddr_in his_addr;
static	struct	sockaddr_in pasv_addr;


static	int	data;
static	jmp_buf	urgcatch;
static	int	stru;
static	int	transflag;
static	off_t	file_size;
static	off_t	byte_count;
static	int	askpasswd = 0;		/* had user command, ask for passwd */


#ifndef	FILECMASK
#define FILECMASK 027
#endif

static	int	defumask = FILECMASK;		/* default umask value */
static	char	hostname[MAXHOSTNAMELEN];

static	time_t	ontime;

#define	SWAITMAX	90	/* wait at most 90 seconds */
#define	SWAITINT	5	/* interval between retries */

static	int	swaitmax = SWAITMAX;
static	int	swaitint = SWAITINT;


#ifdef	NOEXPORT
int	foreigner = 0;
#endif


int
main(argc, argv)
	int argc;
	char *argv[];
{
	int	x;
	char	*homedir = FTPD_DEFAULT_HOME;
	int	runuid = FTPD_DEFAULT_UID;
	int	rungid = FTPD_DEFAULT_GID;

	/*
	NOTE - DURING THIS PART OF THE CODE WE MAY BE RUNNING
	WITH PRIVILEGES. DO NOTHING UNSAFE HERE.
	*/
	openlog("ftpd", LOG_PID | LOG_NDELAY, LOG_DAEMON);


	x = sizeof (his_addr);
	if (getpeername(0, (struct sockaddr *)&his_addr, &x) < 0) {
		syslog(LOG_ERR, "getpeername (%s): %m",argv[0]);
		exit(1);
	}
	x = sizeof (ctrl_addr);
	if (getsockname(0, (struct sockaddr *)&ctrl_addr, &x) < 0) {
		syslog(LOG_ERR, "getsockname (%s): %m",argv[0]);
		exit(1);
	}


#ifdef IP_TOS
	{
		int	tos;

		tos = IPTOS_LOWDELAY;
		if(setsockopt(0,IPPROTO_IP,IP_TOS,(char *)&tos,sizeof(int)) < 0)
			syslog(LOG_WARNING, "setsockopt (IP_TOS): %m");
	}
#endif


	while((x = getopt(argc,argv,"H:U:G:fvdt:T:u:")) != -1) {
		switch(x) {
#ifdef	NOEXPORT
		case 'f':
			foreigner = 1;
			break;
#endif

		case 'H':
			homedir = optarg;
			break;

		case 'U':
			runuid = atoi(optarg);
			break;

		case 'G':
			rungid = atoi(optarg);
			break;

		case 'v':
			debug = 1;
			break;

		case 'd':
			debug = 1;
			break;

		case 't':
			timeout = atoi(optarg);
			if (maxtimeout < timeout)
				maxtimeout = timeout;
			break;

		case 'T':
			maxtimeout = atoi(optarg);
			if (timeout > maxtimeout)
				timeout = maxtimeout;
			break;

		case 'u':
			{
				int	val = 0;
				char	*cp;

				cp = optarg;
				while(*++cp && *cp >= '0' && *cp <= '9')
					val = val*8 + *cp - '0';
				if(*cp) {
					syslog(LOG_NOTICE,"cannot decode umask -u %s",optarg);
					exit(1);
				}
					defumask = val;
			}
			break;


		default:
			syslog(LOG_NOTICE,"unknown option %c",x);
			exit(1);
		}
	}



#if defined(DEBUG)
	(void)freopen("/debug.txt", "w", stderr);
#else
	(void)freopen("/dev/null", "w", stderr);
#endif
	(void)signal(SIGPIPE, lostconn);
	(void)signal(SIGCHLD, SIG_IGN);
#ifdef	 SIGURG
	(void)signal(SIGURG, myoob);
#endif


	/* Try to handle urgent data inline */
#ifdef SO_OOBINLINE
	{
		int	on = 1;
		if(setsockopt(0,SOL_SOCKET,SO_OOBINLINE,(char *)&on,sizeof(on)) < 0)
			syslog(LOG_ERR, "setsockopt: %m");
	}
#endif


#ifdef	F_SETOWN
	if(fcntl(fileno(stdin), F_SETOWN, getpid()) == -1)
		syslog(LOG_ERR, "fcntl F_SETOWN: %m");
#endif

	/* sanity checks */
	if(rungid < 0) {
		syslog(LOG_NOTICE,"Aborting - runtime GID %d not permitted.",rungid);
		exit(1);
	}
	if(runuid < 0) {
		syslog(LOG_NOTICE,"Aborting - runtime UID %d not permitted.",runuid);
		exit(1);
	}
	if(homedir == (char *)0) {
		syslog(LOG_NOTICE,"Aborting - home directory not specified.");
		exit(1);
	}

	/* THIS IS THE SECURITY CRITICAL CODE RIGHT HERE */
	chdir(homedir);

/*	if(chroot(homedir)) {
		syslog(LOG_NOTICE,"Aborting - chroot %s: %m",homedir);
		exit(1);
	}
*/
	if(setgid(rungid)) {
		syslog(LOG_NOTICE,"Aborting - setgid: %m");
		exit(1);
	}
	if(setuid(runuid)) {
		syslog(LOG_NOTICE,"Aborting - setuid: %m");
		exit(1);
	}

	/* END SECURITY CRITICAL CODE */


	/* log the victim's arrival */
	dolog(&his_addr);

	/* Set up default state */
	data = -1;
	file_type = TYPE_A;
	stru = STRU_F;
	oob_saveline[0] = '\0';

	//(void)gethostname(hostname, sizeof (hostname));
	reply(220, "Connected to BLIP.");

	(void)setjmp(errcatch);
	for (;;)
		(void)yyparse();
	/* NOTREACHED */
}


static	void
lostconn()
{
	if (debug)
		syslog(LOG_DEBUG, "lost connection");
	dologout(-1);
}


#ifndef __USE_TEXT_PASSWORDS__
#include <pwd.h>
#include <crypt.h>
#include <grp.h>

static struct passwd savepwd;

static char * sgetsave(s)
char *s;
{
	char *new = malloc((unsigned) strlen(s) + 1);

	if (new == NULL) {
		perror_reply(421, "Local resource failure: malloc");
		dologout(1);
		/* NOTREACHED */
	}
	(void) strcpy(new, s);
	return (new);
}

#endif	/* __USE_TEXT_PASSWORDS__ */

/*
 * USER command.
 * -gutted with a chainsaw. mjr@tis.com 1995
 */
void
user(name)
	char *name;
{
#ifndef __USE_TEXT_PASSWORDS__
	struct passwd *p;
#endif

	if(logged_in) {
		reply(530, "Already logged in.");
		return;
	}

#ifdef	PROXY_PASSTHRU
	if(index(name,'@') != (char *)0 || index(name,'!') != (char *)0) {
		execl(PROXY_PASSTHRU,PROXY_PASSTHRU,"-u",name,(char *)0);
		reply(530, "Can't exec proxy.");
		return;
	}
#endif
#ifdef __USE_TEXT_PASSWORDS__
	if (strcmp(name, USERNAME_PERMITTED) == 0) {
		reply(331, "User %s OK.", USERNAME_PERMITTED);
	} else {
		reply(530, "User %s not permitted.", name);
		return;
	}
#else	/* __USE_TEXT_PASSWORDS__ */
	if ((p = getpwnam(name)) == NULL) {
		reply(530, "User %s not permitted.", name);
		return;
	}
	if (savepwd.pw_name) {
		free(savepwd.pw_name);
		free(savepwd.pw_passwd);
		free(savepwd.pw_gecos);
		free(savepwd.pw_dir);
		free(savepwd.pw_shell);
	}
	savepwd = *p;
	savepwd.pw_name = sgetsave(p->pw_name);
	savepwd.pw_passwd = sgetsave(p->pw_passwd);
	savepwd.pw_gecos = sgetsave(p->pw_gecos);
	savepwd.pw_dir = sgetsave(p->pw_dir);
	savepwd.pw_shell = sgetsave(p->pw_shell);
	reply(331, "User %s OK.", savepwd.pw_name);
#endif	/* __USE_TEXT_PASSWORDS__ */

	askpasswd = 1;
	return;
}



void
pass(passwd)
	char *passwd;
{
#ifndef __USE_TEXT_PASSWORDS__
	char *xpasswd = NULL;
#endif	/* __USE_TEXT_PASSWORDS__ */

	if (logged_in || askpasswd == 0) {
		reply(503, "Login with USER first.");
		return;
	}
	askpasswd = 0;

#ifdef __USE_TEXT_PASSWORDS__
	if(strcmp(passwd, PASSWD_PERMITTED))
	{
	    reply(530, "Login incorrect.");
	    logged_in = 0;
	    return;
	}
#else	/* __USE_TEXT_PASSWORDS__ */
	if (savepwd.pw_passwd != NULL) {
	    char *salt = savepwd.pw_passwd;
	    xpasswd = crypt (passwd, salt);
	}
	if (!savepwd.pw_passwd || !xpasswd || strcmp(xpasswd, savepwd.pw_passwd) != 0) {
	    reply(530, "Login incorrect.");
	    logged_in = 0;
	    return;
	}
	if (setegid((gid_t)savepwd.pw_gid) < 0) {
	    reply(550, "Can't set gid.");
	    logged_in = 0;
	    return;
	}
	(void) initgroups(savepwd.pw_name, savepwd.pw_gid);
	if (chdir(savepwd.pw_dir) < 0) {
	  if (chdir("/") < 0) {
	      reply(530, "User %s: can't change directory to %s.",
		  savepwd.pw_name, savepwd.pw_dir);
	      logged_in = 0;
	      return;
	  } else {
	      lreply(230, "No directory! Logging in with home=/");
	  }
        }
        if (seteuid((uid_t)savepwd.pw_uid) < 0) {
	    reply(550, "Can't set uid.");
	    logged_in = 0;
	    return;
        }
#endif	/* __USE_TEXT_PASSWORDS__ */

//	strncpy(remoteuser,passwd,STATS_RUSERSIZ - 1);
//	remoteuser[STATS_RUSERSIZ - 2] = '\0';

	reply(230, "Login ok.");
	logged_in = 1;

//	syslog(LOG_INFO, "ANONYMOUS FTP LOGIN FROM %s, %s",
//	    remotehost, passwd);
	(void)umask(defumask);
	return;
}



void
retrieve(cmd, name)
	char *cmd, *name;
{
	FILE *fin, *dout;
	struct stat st;
	int (*closefunc)();
	char *ret_line;

	ret_line = (char *)malloc(BUFSIZ);
	if (ret_line == NULL) {   /* if malloc fails */
	  return;
	}
	if (cmd == 0) {
		fin = fopen(name, "r"), closefunc = fclose;
		st.st_size = 0;
	} else {

		/* mjr */
		if(strlen(cmd) + strlen(name) + 20 > BUFSIZ) {
			reply(550, "File name too long");
			return;
		}

		(void) sprintf(ret_line, cmd, name), name = ret_line;
		fin = ftpd_popen(ret_line, "r");
		closefunc = ftpd_pclose;
		st.st_size = -1;
		st.st_blksize = BUFSIZ;
	}
	if (fin == NULL) {
		if (errno != 0)
			perror_reply(550, name);
		free(ret_line);
		return;
	}
	if (cmd == 0 &&
	    (fstat(fileno(fin), &st) < 0 || (st.st_mode&S_IFMT) != S_IFREG)) {
		reply(550, "%s: not a plain file.", name);
		goto done;
	}

	/* check for dimwits */
	if(cmd == 0) {
		struct	stat	sb;
		int		savi;
		int		savd;

		if(stat("/etc/passwd",&sb) == 0) {
			savi = sb.st_ino;
			savd = sb.st_dev;
			if(stat(name,&sb) == 0) {
				if(sb.st_ino == savi && sb.st_dev == savd) {
					reply(550, "Grow up, kid.");
				syslog(LOG_NOTICE,
					"refused passwd file to %s from %s",
					remoteuser,remotehost);
					goto done;
				}
			}
		}
	}


#ifdef	NOEXPORT
	if (cmd == 0) {
		char		nbuf[BUFSIZ];
		struct	stat	sb;
		char		*p;

		if(strlen(name) > sizeof(nbuf) - 90) {
			reply(550, "%s: name too long.", name);
			goto done;
		}
		strcpy(nbuf,name);
		if((p = rindex(nbuf,'/')) != (char *)0)
			*p = '\0';
		strcat(nbuf,"/.noexport");
		if(stat(nbuf,&sb) == 0 && foreigner) {
			sprintf(nbuf,"File %s only exportable to hosts registered in the US/Canada DNS",name);
			reply(530,nbuf);
			syslog(LOG_NOTICE,
				"FTP REFUSED EXPORT %s FROM %s",name,remotehost);
			goto done;
		}
	}
#endif

	if (restart_point) {
		if (file_type == TYPE_A) {
			register int i, n, c;

			n = restart_point;
			i = 0;
			while (i++ < n) {
				if ((c=getc(fin)) == EOF) {
					perror_reply(550, name);
					goto done;
				}
				if (c == '\n')
					i++;
			}	
		} else if (lseek(fileno(fin), restart_point, L_SET) < 0) {
			perror_reply(550, name);
			goto done;
		}
	}
	dout = dataconn(name, st.st_size, "w");
	if (dout == NULL)
		goto done;

	if(send_data(fin, dout, st.st_blksize)) {
		if(st.st_size > 0) {
			char		tname[MAXPATHLEN];
			char		wd[MAXPATHLEN];
			time_t		l;
			struct tm	*t;

			time(&l);
			t = localtime(&l);

			if(name[0] == '/')
				strcpy(tname, name);
			else {
				getcwd(wd, sizeof(wd));
				if(!strcmp(wd,"/"))
					sprintf(tname, "/%s", name);
				else
					sprintf(tname, "%s/%s", wd, name);
			}
			syslog(LOG_NOTICE,
"%d: %02d/%02d/%02d %02d:%02d:%02d %s(%s) retrieved %s (%d bytes)\n",
				getpid(),
				t->tm_mon+1, t->tm_mday, t->tm_year,
				t->tm_hour, t->tm_min, t->tm_sec,
				remotehost, remoteuser,
				tname, (int)st.st_size);
		}
	}
	(void) fclose(dout);
	data = -1;
	passivedata = -1;
done:
	(*closefunc)(fin);
	free(ret_line);
}



#ifndef	READONLY
void
store(name, mode, unique)
	char *name, *mode;
	int unique;
{
	FILE *fout, *din;
	int ret;
	struct stat st;
	int (*closefunc)();
	char *gunique();

	if (unique && stat(name, &st) == 0 &&
	    (name = gunique(name)) == NULL)
		return;

	if (restart_point)
		mode = "r+w";
	fout = fopen(name, mode);
	closefunc = fclose;
	if (fout == NULL) {
		perror_reply(553, name);
		return;
	}
	if (restart_point) {
		if (file_type == TYPE_A) {
			register int i, n, c;

			n = restart_point;
			i = 0;
			while (i++ < n) {
				if ((c=getc(fout)) == EOF) {
					perror_reply(550, name);
					goto done;
				}
				if (c == '\n')
					i++;
			}	
			/*
			 * We must do this seek to "current" position
			 * because we are changing from reading to
			 * writing.
			 */
			if (fseek(fout, 0L, L_INCR) < 0) {
				perror_reply(550, name);
				goto done;
			}
		} else if (lseek(fileno(fout), restart_point, L_SET) < 0) {
			perror_reply(550, name);
			goto done;
		}
	}
	din = dataconn(name, (off_t)-1, "r");
	if (din == NULL)
		goto done;
	ret = receive_data(din, fout);
	if (ret == 0)
	{
		char		tname[MAXPATHLEN];
		char		wd[MAXPATHLEN];
		time_t		l;
		struct tm	*t;
		struct stat	stbuf;

		if (unique)
			reply(226, "Transfer complete (unique file name:%s).",
			    name);
		else
			reply(226, "Transfer complete.");

		chmod(name, S_IRUSR | S_IWUSR | S_IXUSR | S_IRGRP | S_IWGRP | S_IXGRP | S_IROTH | S_IWOTH | S_IXOTH);
		time(&l);
		t = localtime(&l);

		if (name[0] == '/')
			strcpy(tname, name);
		else {
			getcwd(wd, sizeof(wd));
			sprintf(tname, "%s/%s", wd, name);
		}
		if(stat(name,&stbuf))
			stbuf.st_size = -1;
		syslog(LOG_NOTICE,
			"%d: %02d/%02d/%02d %02d:%02d:%02d %s(%s) stored %s (%d bytes)\n",
			getpid(),
			t->tm_mon+1, t->tm_mday, t->tm_year,
			t->tm_hour, t->tm_min, t->tm_sec,
			remotehost, remoteuser,
			tname, (int)stbuf.st_size);
	}
	if (ret == -1)
	{
		unlink(name);
	}
	(void) fclose(din);
	data = -1;
	passivedata = -1;
done:
	(*closefunc)(fout);
}
#endif



static FILE *
getdatasock(mode)
	char *mode;
{
	int s, on = 1, tries;

	if (data >= 0)
		return (fdopen(data, mode));
	s = socket(AF_INET, SOCK_STREAM, 0);
	if (s < 0)
		goto bad;

	if (setsockopt(s, SOL_SOCKET, SO_REUSEADDR,
	    (char *) &on, sizeof (on)) < 0)
		goto bad;

	/* anchor socket to avoid multi-homing problems */
	data_source.sin_family = AF_INET;
	data_source.sin_addr = ctrl_addr.sin_addr;

	/* mjr - the RFCs say to bind port 20. How stupid. We don't. */
	data_source.sin_port = 0;

	for (tries = 1; ; tries++) {
		if (bind(s, (struct sockaddr *)&data_source,
		    sizeof (data_source)) >= 0)
			break;
		if (errno != EADDRINUSE || tries > 10)
			goto bad;
		sleep(tries);
	}
#ifdef IP_TOS
	on = IPTOS_THROUGHPUT;
	if (setsockopt(s, IPPROTO_IP, IP_TOS, (char *)&on, sizeof(int)) < 0)
		syslog(LOG_WARNING, "setsockopt (IP_TOS): %m");
#endif
	return (fdopen(s, mode));
bad:
	(void) close(s);
	return (NULL);
}

static FILE *
dataconn(name, size, mode)
	char *name;
	off_t size;
	char *mode;
{
	char sizebuf[32];
	FILE *file;
	int retry = 0;

	file_size = size;
	byte_count = 0;
	if (size != (off_t) -1)
		(void) sprintf (sizebuf, " (%ld bytes)", size);
	else
		(void) strcpy(sizebuf, "");
	if (passivedata >= 0) {
		struct sockaddr_in from;
		int s, fromlen = sizeof(from);

		s = accept(passivedata, (struct sockaddr *)&from, &fromlen);
		if (s < 0) {
			reply(425, "Can't open data connection.");
			(void) close(passivedata);
			passivedata = -1;
			return(NULL);
		}
		(void) close(passivedata);
		passivedata = s;
#ifdef IP_TOS
		{
			int	tos;

			tos = IPTOS_LOWDELAY;
			(void) setsockopt(s, IPPROTO_IP, IP_TOS,
					  (char *)&tos, sizeof(int));
		}
#endif
		reply(150, "Opening %s mode data connection for %s%s.",
		     file_type == TYPE_A ? "ASCII" : "BINARY", name, sizebuf);
		return(fdopen(passivedata, mode));
	}
	if (data >= 0) {
		reply(125, "Using existing data connection for %s%s.",
		    name, sizebuf);
		usedefaultport = 1;
		return (fdopen(data, mode));
	}
	if (usedefaultport)
		data_dest = his_addr;
	usedefaultport = 1;
	file = getdatasock(mode);
	if (file == NULL) {
		reply(425, "Can't create data socket (%s,%d): %s.",
		    inet_ntoa(data_source.sin_addr),
#ifdef __OPTIMIZE__
		    ntohs(data_source.sin_port),
#else
		    data_source.sin_port,
#endif
		    strerror(errno));

		return (NULL);
	}
	data = fileno(file);
	while (connect(data, (struct sockaddr *)&data_dest,
	    sizeof (data_dest)) < 0) {
		if (errno == EADDRINUSE && retry < swaitmax) {
			sleep((unsigned) swaitint);
			retry += swaitint;
			continue;
		}
		perror_reply(425, "Can't build data connection");
		(void) fclose(file);
		data = -1;
		return (NULL);
	}
	reply(150, "Opening %s mode data connection for %s%s.",
	     file_type == TYPE_A ? "ASCII" : "BINARY", name, sizebuf);
	return (file);
}

/*
 * Tranfer the contents of "instr" to
 * "outstr" peer using the appropriate
 * encapsulation of the data subject
 * to Mode, Structure, and Type.
 */
int
send_data(instr, outstr, blksize)
	FILE *instr, *outstr;
	off_t blksize;
{
	register int c, cnt;
	register char *buf;
	int netfd, filefd;

	transflag++;
	if (setjmp(urgcatch)) {
		transflag = 0;
		return(0);
	}
	switch (file_type) {

	case TYPE_A:
		while ((c = getc(instr)) != EOF) {
			byte_count++;
			if (c == '\n') {
				if (ferror(outstr))
					goto data_err;
				(void) putc('\r', outstr);
			}
			(void) putc(c, outstr);
		}
		fflush(outstr);
		transflag = 0;
		if (ferror(instr))
			goto file_err;
		if (ferror(outstr))
			goto data_err;
		reply(226, "Transfer complete.");
		return(1);

	case TYPE_I:
	case TYPE_L:
		if ((buf = malloc((u_int)blksize)) == NULL) {
			transflag = 0;
			perror_reply(451, "Local resource failure: malloc");
			return(0);
		}
		netfd = fileno(outstr);
		filefd = fileno(instr);
		while ((cnt = read(filefd, buf, (u_int)blksize)) > 0 &&
		    write(netfd, buf, cnt) == cnt)
			byte_count += cnt;
		transflag = 0;
		(void)free(buf);
		if (cnt != 0) {
			if (cnt < 0)
				goto file_err;
			goto data_err;
		}
		reply(226, "Transfer complete.");
		return(1);
	default:
		transflag = 0;
		reply(550, "Unimplemented TYPE %d in send_data", file_type);
		return(0);
	}

data_err:
	transflag = 0;
	perror_reply(426, "Data connection");
	return(0);

file_err:
	transflag = 0;
	perror_reply(551, "Error on input file");
	return(0);
}

/*
 * Transfer data from peer to
 * "outstr" using the appropriate
 * encapulation of the data subject
 * to Mode, Structure, and Type.
 */
int
receive_data(instr, outstr)
	FILE *instr, *outstr;
{
	register int c;
	int cnt, bare_lfs = 0;
	char *rec_buf;

	transflag++;
	if (setjmp(urgcatch)) {
		transflag = 0;
		return (-1);
	}
	rec_buf = (char *)malloc(BUFSIZ);
	if (rec_buf == NULL) {   /* if malloc fails */
	  return(0);
	}
	switch (file_type) {

	case TYPE_I:
	case TYPE_L:
		while ((cnt = read(fileno(instr), rec_buf, sizeof rec_buf)) > 0) {
			if (write(fileno(outstr), rec_buf, cnt) != cnt)
				goto file_err;
			byte_count += cnt;
		}
		if (cnt < 0)
			goto data_err;
		transflag = 0;
		free(rec_buf);
		return (0);

	case TYPE_E:
		reply(553, "TYPE E not implemented.");
		transflag = 0;
		free(rec_buf);
		return (-1);

	case TYPE_A:
		while ((c = getc(instr)) != EOF) {
			byte_count++;
			if (c == '\n')
				bare_lfs++;
			while (c == '\r') {
				if (ferror(outstr))
					goto data_err;
				if ((c = getc(instr)) != '\n') {
					(void) putc ('\r', outstr);
					if (c == '\0' || c == EOF)
						goto contin2;
				}
			}
			(void) putc(c, outstr);
	contin2:	;
		}
		fflush(outstr);
		if (ferror(instr))
			goto data_err;
		if (ferror(outstr))
			goto file_err;
		transflag = 0;
		if (bare_lfs) {
			lreply(230, "WARNING! %d bare linefeeds received in ASCII mode", bare_lfs);
			printf("   File may not have transferred correctly.\r\n");
		}
		free(rec_buf);
		return (0);
	default:
		reply(550, "Unimplemented TYPE %d in receive_data", file_type);
		transflag = 0;
		free(rec_buf);
		return (-1);
	}

data_err:
	transflag = 0;
	perror_reply(426, "File removed, Data Connection");
	free(rec_buf);
	return (-1);

file_err:
	transflag = 0;
	perror_reply(452, "File removed, Error writing file");
	free(rec_buf);
	return (-1);
}

static char stat_line[BUFSIZ];
void
statfilecmd(filename)
	char *filename;
{
	FILE *fin;
	int c;

	/* mjr - berkeley weenies :(  */
	if(strlen(filename) > sizeof(stat_line) - 20) {
		reply(550, "File name too long");
		return;
	}
#ifdef _uclinux_
	(void) sprintf(stat_line, "/bin/ls -al %s", filename);
#else
	(void) sprintf(stat_line, "/bin/ls -lgA %s", filename);
#endif

	fin = ftpd_popen(stat_line, "r");
	lreply(211, "status of %s:", filename);
	while ((c = getc(fin)) != EOF) {
		if (c == '\n') {
			if (ferror(stdout)){
				perror_reply(421, "control connection");
				(void) ftpd_pclose(fin);
				dologout(1);
				/* NOTREACHED */
			}
			if (ferror(fin)) {
				perror_reply(551, filename);
				(void) ftpd_pclose(fin);
				return;
			}
			(void) putc('\r', stdout);
		}
		(void) putc(c, stdout);
	}
	(void) ftpd_pclose(fin);
	reply(211, "End of Status");
}

void
statcmd()
{
	struct sockaddr_in *Ssin;
	u_char *a, *p;

	lreply(211, "%s FTP server status:", hostname, version);
	printf("     %s\r\n", version);
	printf("     Connected to %s", remotehost);
	if (!isdigit(remotehost[0]))
		printf(" (%s)", inet_ntoa(his_addr.sin_addr));
	printf("\r\n");
	if (logged_in) {
		printf("     Logged in as user %s\r\n", USERNAME_PERMITTED);
	} else if (askpasswd)
		printf("     Waiting for password\r\n");
	else
		printf("     Waiting for user name\r\n");
	if (file_type == TYPE_L)

/* #if NBBY == 8 */
		printf(" %d", NBBY);
/* 		//printf(" %d", NBBY); */
/* #else */
/* 		printf(" %d", bytesize); */	/* need definition! */
/* #endif */
	if (data != -1)
		printf("     Data connection open\r\n");
	else if (passivedata != -1) {
		printf("     in Passive mode");
		Ssin = &pasv_addr;
		goto printaddr;
	} else if (usedefaultport == 0) {
		printf("     PORT");
		Ssin = &data_dest;
printaddr:
		a = (u_char *) &Ssin->sin_addr;
		p = (u_char *) &Ssin->sin_port;
#define UC(b) (((int) b) & 0xff)
		printf(" (%d,%d,%d,%d,%d,%d)\r\n", UC(a[0]),
			UC(a[1]), UC(a[2]), UC(a[3]), UC(p[0]), UC(p[1]));
#undef UC
	} else
		printf("     No data connection\r\n");
	reply(211, "End of status");
}

void
fatal(s)
	char *s;
{
	reply(451, "Error in server: %s\n", s);
	reply(221, "Closing connection due to server error.");
	dologout(0);
	/* NOTREACHED */
}


/* VARARGS */
void 
reply(int code, ...)
{
	va_list args;
	char	*fmt;

	va_start(args, code);
	printf("%d ", code);
	fmt = va_arg(args, char *);
	(void)vprintf(fmt, args);
	va_end(args);
	printf("\r\n");
	(void)fflush(stdout);
	if(debug)
		syslog(LOG_NOTICE,"<-- %d %s",code,fmt);
}

/* VARARGS */
void 
lreply(int code, ...)
{
	va_list args;
	char	*fmt;

	va_start(args, code);
	printf("%d- ", code);
	fmt = va_arg(args, char *);
	(void)vprintf(fmt, args);
	va_end(args);
	printf("\r\n");
	(void)fflush(stdout);
	if(debug)
		syslog(LOG_NOTICE,"<-- %d %s",code,fmt);
}


void
ack(s)
	char *s;
{
	reply(250, "%s command successful.", s);
}

void
nack(s)
	char *s;
{
	reply(502, "%s command not implemented.", s);
}


#ifndef	READONLY
void
delete(name)
	char *name;
{
	struct stat st;

	if (stat(name, &st) < 0) {
		perror_reply(550, name);
		return;
	}
	if ((st.st_mode&S_IFMT) == S_IFDIR) {
		if (rmdir(name) < 0) {
			perror_reply(550, name);
			return;
		}
		goto done;
	}
	if (unlink(name) < 0) {
		perror_reply(550, name);
		return;
	}
done:
	ack("DELE");
}
#endif


void
cwd(path)
	char *path;
{
#ifdef	NOEXPORT
	char		nbuf[BUFSIZ];
	struct	stat	sb;
	char		*p;

	if(strlen(path) > sizeof(nbuf) + 90) {
		reply(550, "%s: name too long.", path);
		return;
	}
	strcpy(nbuf,path);
	if((p = rindex(nbuf,'/')) != (char *)0)
		*p = '\0';
	strcat(nbuf,"/.noexport");
	if(stat(nbuf,&sb) == 0 && foreigner) {
		sprintf(nbuf,"Directory %s only available to hosts registered in the US/Canada DNS",path);
		reply(530,nbuf);
		return;
	}
#endif
	if (chdir(path) < 0)
		perror_reply(550, path);
	else
		ack("CWD");
}


#ifndef	READONLY
void
makedir(name)
	char *name;
{
	if (mkdir(name, 0777) < 0)
		perror_reply(550, name);
	else
		reply(257, "MKD command successful.");
}
#endif


#ifndef	READONLY
void
removedir(name)
	char *name;
{
	if (rmdir(name) < 0)
		perror_reply(550, name);
	else
		ack("RMD");
}
#endif


void
pwd()
{
	char path[MAXPATHLEN + 1];

	if (getcwd(path, sizeof(path)) == (char *)NULL)
		reply(550, "%s.", path);
	else
		reply(257, "\"%s\" is current directory.", path);
}


#ifndef	READONLY
char *
renamefrom(name)
	char *name;
{
	struct stat st;

	if (stat(name, &st) < 0) {
		perror_reply(550, name);
		return ((char *)0);
	}
	reply(350, "File exists, ready for destination name");
	return (name);
}
#endif


#ifndef	READONLY
void
renamecmd(from, to)
	char *from, *to;
{
	if (rename(from, to) < 0)
		perror_reply(550, "rename");
	else
		ack("RNTO");
}
#endif

void
dolog(Dsin)
	struct sockaddr_in *Dsin;
{
/*
	struct hostent *hp = gethostbyaddr((char *)&Dsin->sin_addr,
		sizeof (struct in_addr), AF_INET);
	time_t t;

	if (hp)
		(void) strncpy(remotehost, hp->h_name, STATS_RHOSTSIZ - 1);
	else
		(void) strncpy(remotehost, inet_ntoa(Dsin->sin_addr), STATS_RHOSTSIZ - 1);
	remotehost[STATS_RHOSTSIZ - 2] = '\0';

	t = time((time_t *) 0);
	syslog(LOG_INFO, "connection from %s at %s",
	    remotehost, ctime(&t));
	time(&ontime);
*/
}

/*
 * Record logout in wtmp file
 * and exit with supplied status.
 */
void
dologout(status)
	int status;
{
	/* beware of flushing buffers after a SIGPIPE */
	exitstats();
	_exit(status);
}


static	void
myoob()
{
	char *cp;

	/* only process if transfer occurring */
	if (!transflag)
		return;
	cp = oob_saveline;
	if (getline(cp, OOB_SAVELINESIZ, stdin) == NULL) {
		reply(221, "You could at least say goodbye.");
		dologout(0);
	}
	upper(cp);
	if (strcmp(cp, "ABOR\r\n") == 0) {
		oob_saveline[0] = '\0';
		reply(426, "Transfer aborted. Data connection closed.");
		reply(226, "Abort successful");
		longjmp(urgcatch, 1);
	}
	if (strcmp(cp, "STAT\r\n") == 0) {
		if (file_size != (off_t) -1)
			reply(213, "Status: %lu of %lu bytes transferred",
			    byte_count, file_size);
		else
			reply(213, "Status: %lu bytes transferred", byte_count);
	}
}

/*
 * Note: a response of 425 is not mentioned as a possible response to
 * 	the PASV command in RFC959. However, it has been blessed as
 * 	a legitimate response by Jon Postel in a telephone conversation
 *	with Rick Adams on 25 Jan 89.
 */
void
passive()
{
	int len;
	register char *p, *a;

	passivedata = socket(AF_INET, SOCK_STREAM, 0);
	if (passivedata < 0) {
		perror_reply(425, "Can't open passive connection");
		return;
	}
	pasv_addr = ctrl_addr;
	pasv_addr.sin_port = 0;
	if (bind(passivedata, (struct sockaddr *)&pasv_addr, sizeof(pasv_addr)) < 0)
		goto pasv_error;
	len = sizeof(pasv_addr);
	if (getsockname(passivedata, (struct sockaddr *) &pasv_addr, &len) < 0)
		goto pasv_error;
	if (listen(passivedata, 1) < 0)
		goto pasv_error;
	a = (char *) &pasv_addr.sin_addr;
	p = (char *) &pasv_addr.sin_port;

#define UC(b) (((int) b) & 0xff)

	reply(227, "Entering Passive Mode (%d,%d,%d,%d,%d,%d)", UC(a[0]),
		UC(a[1]), UC(a[2]), UC(a[3]), UC(p[0]), UC(p[1]));
	return;

pasv_error:
	(void) close(passivedata);
	passivedata = -1;
	perror_reply(425, "Can't open passive connection");
	return;
}

/*
 * Generate unique name for file with basename "local".
 * The file named "local" is already known to exist.
 * Generates failure reply on error.
 */
char *
gunique(local)
	char *local;
{
	static char new[MAXPATHLEN];
	struct stat st;
	char *cp = (char *)rindex(local, '/');
	int count = 0;

	if (cp)
		*cp = '\0';
	if (stat(cp ? local : ".", &st) < 0) {
		perror_reply(553, cp ? local : ".");
		return((char *) 0);
	}
	if (cp)
		*cp = '/';
	(void) strcpy(new, local);
	cp = new + strlen(new);
	*cp++ = '.';
	for (count = 1; count < 100; count++) {
		(void) sprintf(cp, "%d", count);
		if (stat(new, &st) < 0)
			return(new);
	}
	reply(452, "Unique file name cannot be created.");
	return((char *) 0);
}

/*
 * Format and send reply containing system error number.
 */
void
perror_reply(code, string)
	int code;
	char *string;
{
	reply(code, "%s: %s.", string, strerror(errno));
}

static char *onefile[] = {
	"",
	0
};

void
send_file_list(whichfiles)
	char *whichfiles;
{
	struct stat st;
	DIR *dirp = NULL;
	struct dirent *dir;
	FILE *dout = NULL;
	register char **dirlist, *dirname;
	int simple = 0;
	char *strpbrk();

	if (strpbrk(whichfiles, "~{[*?") != NULL) {

		globerr = NULL;
		dirlist = ftpglob(whichfiles);
		if (globerr != NULL) {
			reply(550, globerr);
			return;
		} else if (dirlist == NULL) {
			errno = ENOENT;
			perror_reply(550, whichfiles);
			return;
		}
	} else {
		onefile[0] = whichfiles;
		dirlist = onefile;
		simple = 1;
	}

	if (setjmp(urgcatch)) {
		transflag = 0;
		return;
	}
	while ((dirname = *dirlist++) != NULL) {
		if (stat(dirname, &st) < 0) {
			/*
			 * If user typed "ls -l", etc, and the client
			 * used NLST, do what the user meant.
			 */
			if (dirname[0] == '-' && *dirlist == NULL &&
			    transflag == 0) {
				retrieve("ls %s", dirname);
				return;
			}
			perror_reply(550, whichfiles);
			if (dout != NULL) {
				(void) fclose(dout);
				transflag = 0;
				data = -1;
				passivedata = -1;
			}
			return;
		}

		if ((st.st_mode&S_IFMT) == S_IFREG) {
			if (dout == NULL) {
				dout = dataconn("file list", (off_t)-1, "w");
				if (dout == NULL)
					return;
				transflag++;
			}
			fprintf(dout, "%s%s\n", dirname,
				file_type == TYPE_A ? "\r" : "");
			byte_count += strlen(dirname) + 1;
			continue;
		} else if ((st.st_mode&S_IFMT) != S_IFDIR)
			continue;

		if ((dirp = opendir(dirname)) == NULL)
			continue;

		while ((dir = readdir(dirp)) != NULL) {
			char nbuf[MAXPATHLEN];

			if (dir->d_name[0] == '.' && dir->d_name[1] == '\0')
				continue;
			if (dir->d_name[0] == '.' && dir->d_name[1] == '.' &&
			    dir->d_name[2] == '\0')
				continue;

			sprintf(nbuf, "%s/%s", dirname, dir->d_name);

			/*
			 * We have to do a stat to insure it's
			 * not a directory or special file.
			 */
			if (simple || (stat(nbuf, &st) == 0 &&
			    (st.st_mode&S_IFMT) == S_IFREG)) {
				if (dout == NULL) {
					dout = dataconn("file list", (off_t)-1,
						"w");
					if (dout == NULL)
						return;
					transflag++;
				}
				if (nbuf[0] == '.' && nbuf[1] == '/')
					fprintf(dout, "%s%s\n", &nbuf[2],
						file_type == TYPE_A ? "\r" : "");
				else
					fprintf(dout, "%s%s\n", nbuf,
						file_type == TYPE_A ? "\r" : "");
				byte_count += strlen(nbuf) + 1;
			}
		}
		(void) closedir(dirp);
	}

	if (dout == NULL)
		reply(550, "No files found.");
	else if (ferror(dout) != 0)
		perror_reply(550, "Data connection");
	else
		reply(226, "Transfer complete.");

	transflag = 0;
	if (dout != NULL)
		(void) fclose(dout);
	data = -1;
	passivedata = -1;
}

int
exitstats()
{
	time_t			l;
	struct tm		*t;

	time(&l);
	t = localtime(&ontime);
	syslog(LOG_NOTICE,
"%d: %02d/%02d/%02d %02d:%02d:%02d %s connected, duration %d seconds\n",
		getpid(),
		t->tm_mon+1, t->tm_mday, t->tm_year,
		t->tm_hour, t->tm_min, t->tm_sec,
		remotehost, (int)(l - ontime));
	return(0);
}
