/*
 * RCSID $Id: ipsec_hw_md5c.c,v 1.4 2003/03/31 23:11:00 swahl Exp $
 */

/*
 * Changed to use BRECIS hardware to perform the MD5 transforms
 * using the same external API as the usual software routines.
 *
 * Much of the remaining code is derived from MD5C.C by RSADSI.
 * Minor cosmetic changes to accomodate it in the kernel by ji.
 * Copyright therefore left in place.
 */

#include <asm/byteorder.h>
#include <linux/string.h>

#include "ipsec_md5h.h"
#include <brecis/msp_sec.h>

#ifdef __KERNEL__
#include <brecis/msp_sec_kern.h>

static struct msp_sec_context sec_ctx ;
#endif

#ifndef __KERNEL__
static int secfd = -1 ;
#endif

/* MD5C.C - RSA Data Security, Inc., MD5 message-digest algorithm
 */

/* Copyright (C) 1991-2, RSA Data Security, Inc. Created 1991. All
rights reserved.

License to copy and use this software is granted provided that it
is identified as the "RSA Data Security, Inc. MD5 Message-Digest
Algorithm" in all material mentioning or referencing this software
or this function.

License is also granted to make and use derivative works provided
that such works are identified as "derived from the RSA Data
Security, Inc. MD5 Message-Digest Algorithm" in all material
mentioning or referencing the derived work.

RSA Data Security, Inc. makes no representations concerning either
the merchantability of this software or the suitability of this
software for any particular purpose. It is provided "as is"
without express or implied warranty of any kind.

These notices must be retained in any copies of any part of this
documentation and/or software.
 */

/*
 * Additions by JI
 * 
 * HAVEMEMCOPY is defined if mem* routines are available
 *
 * HAVEHTON is defined if htons() and htonl() can be used
 * for big/little endian conversions
 *
 */

#define HAVEMEMCOPY
#ifdef __LITTLE_ENDIAN
#define LITTLENDIAN
#endif
#ifdef __BIG_ENDIAN
#define BIGENDIAN
#endif

/* Constants for MD5Transform routine.
 */

#define S11 7
#define S12 12
#define S13 17
#define S14 22
#define S21 5
#define S22 9
#define S23 14
#define S24 20
#define S31 4
#define S32 11
#define S33 16
#define S34 23
#define S41 6
#define S42 10
#define S43 15
#define S44 21

//static void MD5Transform PROTO_LIST ((UINT4 [4], unsigned char [64]));
static void MD5Transform PROTO_LIST ((UINT4 [4], unsigned char [64],
				      unsigned int numBlocks));

#ifdef LITTLEENDIAN
#define Encode MD5_memcpy
#define Decode MD5_memcpy
#else
static void Encode PROTO_LIST
  ((unsigned char *, UINT4 *, unsigned int));
/* static void Decode PROTO_LIST
   ((UINT4 *, unsigned char *, unsigned int)); */
#endif

#ifdef HAVEMEMCOPY
/* no need to include <memory.h> here; <linux/string.h> defines these */
#define MD5_memcpy	memcpy
#define MD5_memset	memset
#else
#ifdef HAVEBCOPY
#define MD5_memcpy(_a,_b,_c) bcopy((_b),(_a),(_c))
#define MD5_memset(_a,_b,_c) bzero((_a),(_c))
#else
static void MD5_memcpy PROTO_LIST ((POINTER, POINTER, unsigned int));
static void MD5_memset PROTO_LIST ((POINTER, int, unsigned int));
#endif
#endif
static unsigned char PADDING[64] = {
  0x80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

/* F, G, H and I are basic MD5 functions.
 */
#define F(x, y, z) (((x) & (y)) | ((~x) & (z)))
#define G(x, y, z) (((x) & (z)) | ((y) & (~z)))
#define H(x, y, z) ((x) ^ (y) ^ (z))
#define I(x, y, z) ((y) ^ ((x) | (~z)))

/* ROTATE_LEFT rotates x left n bits.
 */
#define ROTATE_LEFT(x, n) (((x) << (n)) | ((x) >> (32-(n))))

/* FF, GG, HH, and II transformations for rounds 1, 2, 3, and 4.
Rotation is separate from addition to prevent recomputation.
 */
#define FF(a, b, c, d, x, s, ac) { \
 (a) += F ((b), (c), (d)) + (x) + (UINT4)(ac); \
 (a) = ROTATE_LEFT ((a), (s)); \
 (a) += (b); \
  }
#define GG(a, b, c, d, x, s, ac) { \
 (a) += G ((b), (c), (d)) + (x) + (UINT4)(ac); \
 (a) = ROTATE_LEFT ((a), (s)); \
 (a) += (b); \
  }
#define HH(a, b, c, d, x, s, ac) { \
 (a) += H ((b), (c), (d)) + (x) + (UINT4)(ac); \
 (a) = ROTATE_LEFT ((a), (s)); \
 (a) += (b); \
  }
#define II(a, b, c, d, x, s, ac) { \
 (a) += I ((b), (c), (d)) + (x) + (UINT4)(ac); \
 (a) = ROTATE_LEFT ((a), (s)); \
 (a) += (b); \
  }

/* MD5 initialization. Begins an MD5 operation, writing a new context.
 */
void MD5Init (context)
MD5_CTX *context;                                        /* context */
{
#ifndef __KERNEL__
	if (secfd == -1)
		secfd = open(SECDEV,0) ;
#endif

	context->count[0] = context->count[1] = 0;
	/* Load magic initialization constants.
	 */
#if 0
	context->state[0] = 0x67452301;
	context->state[1] = 0xefcdab89;
	context->state[2] = 0x98badcfe;
	context->state[3] = 0x10325476;
#else
	/*
	** Brecis hardware does the MD5 calc's
	** in the algorithm's native little
	** endian mode, even though the processor
	** is big endian.
	*/
	context->state[0] = 0x01234567;
	context->state[1] = 0x89abcdef;
	context->state[2] = 0xfedcba98;
	context->state[3] = 0x76543210;
#endif
  
}

/* MD5 block update operation. Continues an MD5 message-digest
  operation, processing another message block, and updating the
  context.
 */
void MD5Update (context, input, inputLen)
MD5_CTX *context;                                        /* context */
unsigned char *input;                                /* input block */
__u32 inputLen;                     /* length of input block */
{
	__u32 i;
	unsigned int index, partLen;

	/* Compute number of bytes mod 64 */
	index = (unsigned int)((context->count[0] >> 3) & 0x3F);

	/* Update number of bits */
	if ((context->count[0] += ((UINT4)inputLen << 3))
	    < ((UINT4)inputLen << 3))
		context->count[1]++;
	context->count[1] += ((UINT4)inputLen >> 29);

	partLen = 64 - index;

	/* Transform as many times as possible.
	 */
	if (inputLen >= partLen) {
		MD5_memcpy
			((POINTER)&context->buffer[index], (POINTER)input, partLen);
		MD5Transform (context->state, context->buffer, 1);

		// for (i = partLen; i + 63 < inputLen; i += 64)
		// MD5Transform (context->state, &input[i]);

		i = (inputLen - partLen) / 64 ;
		MD5Transform (context->state, &input[partLen], i) ;
		i = i * 64 + partLen ;

		index = 0;
	}
	else
		i = 0;

	/* Buffer remaining input */
	MD5_memcpy
		((POINTER)&context->buffer[index], (POINTER)&input[i],
		 inputLen-i);
}

/* MD5 finalization. Ends an MD5 message-digest operation, writing the
  the message digest and zeroizing the context.
 */
void MD5Final (digest, context)
unsigned char digest[16];                         /* message digest */
MD5_CTX *context;                                       /* context */
{
  unsigned char bits[8];
  unsigned int index, padLen;

  /* Save number of bits */
  Encode (bits, context->count, 8);

  /* Pad out to 56 mod 64.
*/
  index = (unsigned int)((context->count[0] >> 3) & 0x3f);
  padLen = (index < 56) ? (56 - index) : (120 - index);
  MD5Update (context, PADDING, padLen);

  /* Append length (before padding) */
  MD5Update (context, bits, 8);

  if (digest != NULL)			/* Bill Simpson's padding */
  {
	  /* store state in digest */
#if 0
	  Encode (digest, context->state, 16);
#else
	  MD5_memcpy (digest, context->state, 16) ;
#endif

	  /* Zeroize sensitive information.
	   */
	  MD5_memset ((POINTER)context, 0, sizeof (*context));
  }
}

/* MD5 basic transformation. Transforms state based on block.
 */
// static void MD5Transform (state, block)
static void MD5Transform (state, block, numblocks)
UINT4 state[4];
unsigned char block[64];
unsigned int numblocks;
{
#ifndef __KERNEL__

	struct sec_ioctl sioc ;

	if (!numblocks)
		return ;
	
	sioc.type = MSP_SEC_HASH ;
	sioc.options = 0 ;
	sioc.cbufcount = 0 ;
	sioc.buflen = 64 * numblocks ;
	sioc.srcaddr = block ;
	sioc.dstaddr = (void *) state ;

	sioc.chainvar[0] = state[0] ;
	sioc.chainvar[1] = state[1] ;
	sioc.chainvar[2] = state[2] ;
	sioc.chainvar[3] = state[3] ;

	sioc.mode = HMC_MD5 | HMC_CRV ;

	ioctl(secfd, MSP_SEC_CTL, &sioc) ;
#else

	struct sec_desc desc ;

	if (!numblocks)
		return ;
	
	desc.next = 0 ;

	desc.ioctl.type = MSP_SEC_HASH ;
	desc.ioctl.options = 0 ;
	desc.ioctl.buflen = 64 * numblocks;
	desc.ioctl.srcaddr = block ;
	desc.ioctl.dstaddr = (void *) state ;

	desc.ioctl.chainvar[0] = state[0] ;
	desc.ioctl.chainvar[1] = state[1] ;
	desc.ioctl.chainvar[2] = state[2] ;
	desc.ioctl.chainvar[3] = state[3] ;

	desc.ioctl.mode = HMC_MD5 | HMC_CRV ;

	msp_sec_ioctl_kernel(&sec_ctx, MSP_SEC_CTL, &desc) ;
#endif
}

#ifndef LITTLEENDIAN

/* Encodes input (UINT4) into output (unsigned char). Assumes len is
  a multiple of 4.
 */
static void Encode (output, input, len)
unsigned char *output;
UINT4 *input;
unsigned int len;
{
  unsigned int i, j;

  for (i = 0, j = 0; j < len; i++, j += 4) {
 output[j] = (unsigned char)(input[i] & 0xff);
 output[j+1] = (unsigned char)((input[i] >> 8) & 0xff);
 output[j+2] = (unsigned char)((input[i] >> 16) & 0xff);
 output[j+3] = (unsigned char)((input[i] >> 24) & 0xff);
  }
}
#endif

#if 0
/* Decodes input (unsigned char) into output (UINT4). Assumes len is
  a multiple of 4.
 */
static void Decode (output, input, len)
UINT4 *output;
unsigned char *input;
unsigned int len;
{
  unsigned int i, j;

  for (i = 0, j = 0; j < len; i++, j += 4)
 output[i] = ((UINT4)input[j]) | (((UINT4)input[j+1]) << 8) |
   (((UINT4)input[j+2]) << 16) | (((UINT4)input[j+3]) << 24);
}

#endif

#ifndef HAVEMEMCOPY
#ifndef HAVEBCOPY
/* Note: Replace "for loop" with standard memcpy if possible.
 */

static void MD5_memcpy (output, input, len)
POINTER output;
POINTER input;
unsigned int len;
{
  unsigned int i;

  for (i = 0; i < len; i++)

 output[i] = input[i];
}

/* Note: Replace "for loop" with standard memset if possible.
 */

static void MD5_memset (output, value, len)
POINTER output;
int value;
unsigned int len;
{
  unsigned int i;

  for (i = 0; i < len; i++)
 ((char *)output)[i] = (char)value;
}
#endif
#endif

