/* $Id: mspPCI.h,v 1.6 2003/04/10 22:55:06 mrustad Exp $ */
/*
 * mspPCI.h - Definitions for BRECIS PCI interface.
 *
 ******************************************************************
 * Copyright (c) 2002 BRECIS Communications
 *
 *     This program is free software; you can redistribute it
 *     and/or modify it under the terms of the GNU General
 *     Public License as published by the Free Software
 *     Foundation; either version 2 of the License, or (at your
 *     option) any later version.
 *
 *     This program is distributed in the hope that it will be
 *     useful, but WITHOUT ANY WARRANTY; without even the implied
 *     warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *     PURPOSE.  See the GNU General Public License for more
 *     details.
 *
 *     You should have received a copy of the GNU General Public
 *     License along with this program; if not, write to the Free
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA
 *     02139, USA.
 *
 * BRECIS COMMUNICATIONS DISCLAIMS ANY LIABILITY OF ANY KIND
 * FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS
 * SOFTWARE.
 *
 ******************************************************************
 */


#ifndef	_MSPPCI_H_
#define	_MSPPCI_H_


//#define	PCI_REG_BASE	0xB9000000

//#define	PCI_CONFIG_SPACE	0xB9000800

#define	PCI_IOSPACE_BASE	0xB9001000
#define	PCI_IOSPACE_END		0xB9001FFF

#define	PCI_SPACE_BASE	0xB9002000
#define	PCI_SPACE_END	0xBBFFFFFF

#define	PCI_STAT_IRQ	20	/* IRQ for PCI status interrupts */

typedef volatile unsigned int	pcireg;
typedef void	* volatile ppcireg;

typedef struct blockCopy_st
{
	pcireg	status;		/* +0x00 */
	pcireg	mode;		/* +0x04 */
	ppcireg	src_addr;	/* +0x08 */
	ppcireg	dest_addr;	/* +0x0C */
	pcireg	byte_count;	/* +0x10 */
	pcireg	fill_value;	/* +0x14 */
	pcireg	desc_mode;	/* +0x18 */
	ppcireg	curr_desc_addr;	/* +0x1C */
	ppcireg	next_desc_addr;	/* +0x20 */
	pcireg	desc_control;	/* +0x24 */
	ppcireg	buff_src_addr;	/* +0x28 */
	ppcireg	buff_dest_addr;	/* +0x2C */
}	pciBlockCopy;

enum
{
	config_device_vendor,	/* 0 */
	config_status_command,	/* 1 */
	config_class_revision,	/* 2 */
	config_BIST_header_latency_cache,	/* 3 */
	config_BAR0,		/* 4 */
	config_BAR1,		/* 5 */
	config_BAR2,		/* 6 */
	config_not_used7,	/* 7 */
	config_not_used8,	/* 8 */
	config_not_used9,	/* 9 */
	config_CIS,		/* 10 */
	config_subsystem,	/* 11 */
	config_not_used12,	/* 12 */
	config_capabilities,	/* 13 */
	config_not_used14,	/* 14 */
	config_lat_grant_irq,	/* 15 */
	config_message_control,	/* 16 */
	config_message_addr,	/* 17 */
	config_message_data,	/* 18 */
	config_VPD_addr,	/* 19 */
	config_VPD_data,	/* 20 */
	config_maxregs		/* 21 - number of registers */
};
	
typedef struct mspPci_st
{
	pcireg	bar0;		/* +0x00 */
	pcireg	mask0;		/* +0x04 */
	pcireg	bar1;		/* +0x08 */
	pcireg	mask1;		/* +0x0C */
	pcireg	bar2;		/* +0x10 */
	pcireg	mask2;		/* +0x14 */
	pcireg	prot_base0;	/* +0x18 */
	pcireg	prot_mask0;	/* +0x1C */
	pcireg	prot_base1;	/* +0x20 */
	pcireg	prot_mask1;	/* +0x24 */
	pcireg	atran0;		/* +0x28 */
	pcireg	atran1;		/* +0x2C */
	pcireg	atran2;		/* +0x30 */
	pcireg	vpd_base;	/* +0x34 */
	pcireg	if_control;	/* +0x38 */
	pcireg	oatran;		/* +0x3C */
	pcireg	reset_ctl;	/* +0x40 */
	pcireg	config_addr;	/* +0x44 */
	pcireg	unused1;	/* +0x48 */
	pcireg	msg_signaled_int_status;	/* +0x4C */
	pcireg	msg_signaled_int_mask;	/* +0x50 */
	pcireg	if_status;	/* +0x54 */
	pcireg	if_mask;	/* +0x58 */
	pcireg	inbound_data;	/* +0x5C */
	pcireg	inbound_int;	/* +0x60 */
	pcireg	inbound_int_mask;	/* +0x64 */
	pcireg	outbound_data;	/* +0x68 */
	pcireg	outbound_int;	/* +0x6C */
	pcireg	outbound_int_mask;	/* +0x70 */

	pciBlockCopy	pci_bc[2] __attribute__((aligned(64)));

	pcireg	error_hdr1;	/* +0xE0 */
	pcireg	error_hdr2;	/* +0xE4 */

	pcireg	config[config_maxregs] __attribute__((aligned(256)));

}	mspPciRegs;


/* The following macros check for PCI
 *
 * HasPCI	- true when PCI is available
 * IsPCIHost	- true when acting as PCI host
 *
 * Both macros take the value of the system ID register as input.
 */

#define	HasPCI(id)	(((id) & DEV_ID_PCI_DIS) == 0)
#define	IsPCIHost(id)	(HasPCI(id) && ((id) & DEV_ID_PCI_HOST))

#define	BPCI_CFGADDR_BUSNUM_SHF	16
#define	BPCI_CFGADDR_FUNCTNUM_SHF	8
#define	BPCI_CFGADDR_REGNUM_SHF	2
#define	BPCI_CFGADDR_ENABLE	(1<<31)

#define	BPCI_IFCONTROL_RTO	(1<<20)	/* Retry timeout */
#define	BPCI_IFCONTROL_HCE	(1<<16)	/* Host configuration enable */
#define	BPCI_IFCONTROL_CTO_SHF	12	/* Shift count for CTO bits */
#define	BPCI_IFCONTROL_SE	(1<<5)	/* Enable exceptions on errors */
#define	BPCI_IFCONTROL_BIST	(1<<4)	/* Use BIST in per. mode */
#define	BPCI_IFCONTROL_CAP	(1<<3)	/* Enable capabilities */
#define	BPCI_IFCONTROL_MMC_SHF	0	/* Shift count for MMC bits */

#define	BPCI_IFSTATUS_MGT	(1<<8)	/* Master Grant timeout */
#define	BPCI_IFSTATUS_MTT	(1<<9)	/* Master TRDY timeout */
#define	BPCI_IFSTATUS_MRT	(1<<10)	/* Master retry timeout */
#define	BPCI_IFSTATUS_VPDU	(1<<11)	/* VPD updated */
#define	BPCI_IFSTATUS_BIST	(1<<12)	/* BIST start request */
#define	BPCI_IFSTATUS_BC0F	(1<<13)	/* Block copy 0 fault */
#define	BPCI_IFSTATUS_BC1F	(1<<14)	/* Block copy 1 fault */
#define	BPCI_IFSTATUS_PCIU	(1<<15)	/* PCI unable to respond */
#define	BPCI_IFSTATUS_BSIZ	(1<<16)	/* PCI access with illegal size */
#define	BPCI_IFSTATUS_BADD	(1<<17)	/* PCI access with illegal addr */
#define	BPCI_IFSTATUS_RTO	(1<<18)	/* Retry time out */
#define	BPCI_IFSTATUS_SER	(1<<19)	/* System error */
#define	BPCI_IFSTATUS_PER	(1<<20)	/* Parity error */
#define	BPCI_IFSTATUS_LCA	(1<<21)	/* Local CPU abort */
#define	BPCI_IFSTATUS_MEM	(1<<22)	/* Memory prot. violation */
#define	BPCI_IFSTATUS_ARB	(1<<23)	/* Arbiter timed out */
#define	BPCI_IFSTATUS_MSER	(1<<24)	/* Msg-signalled error */
#define	BPCI_IFSTATUS_ISER	(1<<25)	/* Initiator system error */
#define	BPCI_IFSTATUS_TSERR	(1<<26)	/* Target system error */
#define	BPCI_IFSTATUS_STA	(1<<27)	/* Signaled target abort */
#define	BPCI_IFSTATUS_TA	(1<<28)	/* Target abort */
#define	BPCI_IFSTATUS_MA	(1<<29)	/* Master abort */
#define	BPCI_IFSTATUS_PEI	(1<<30)	/* Parity error as initiator */
#define	BPCI_IFSTATUS_PET	(1<<31)	/* Parity error as target */

#define	BPCI_RESETCTL_PR	(1<<0)	/* True if reset asserted */
#define	BPCI_RESETCTL_RT	(1<<4)	/* Release time */
#define	BPCI_RESETCTL_CT	(1<<8)	/* Config time */
#define	BPCI_RESETCTL_PE	(1<<12)	/* PCI enabled */
#define	BPCI_RESETCTL_HM	(1<<13)	/* PCI host mode */
#define	BPCI_RESETCTL_RI	(1<<14)	/* PCI reset in */

extern mspPciRegs msp_pci_regs __attribute__((section(".register")));
extern unsigned long	msp_pci_config_space
	__attribute__((section(".register")));

#endif	/* _MSPPCI_H_ */
