/*
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 1996, 1999, 2001 Ralf Baechle
 * Copyright (C) 1999 Silicon Graphics, Inc.
 * Copyright (C) 2001 MIPS Technologies, Inc.
 */
#ifndef __ASM_SGIDEFS_H
#define __ASM_SGIDEFS_H

/*
 * Using a Linux compiler for building Linux seems logic but not to
 * everybody.
 */
#ifndef __linux__
#error Use a Linux compiler or give up.
#endif

/*
 * Definitions for the ISA levels
 *
 * With the introduction of MIPS32 / MIPS64 instruction sets definitions
 * MIPS ISAs are no longer subsets of each other.  Therefore comparisons
 * on these symbols except with == may result in unexpected results and
 * are forbidden!
 */
#define _MIPS_ISA_MIPS1		1
#define _MIPS_ISA_MIPS2		2
#define _MIPS_ISA_MIPS3		3
#define _MIPS_ISA_MIPS4		4
#define _MIPS_ISA_MIPS5		5
#define _MIPS_ISA_MIPS32	6
#define _MIPS_ISA_MIPS64	7

/*
 * Subprogram calling convention
 */
#define _MIPS_SIM_ABI32		1
#define _MIPS_SIM_NABI32	2
#define _MIPS_SIM_ABI64		3

#ifdef CONFIG_BRECIS

#ifndef _MIPS_ISA
  #if __mips == 1
    #define _MIPS_ISA       _MIPS_ISA_MIPS1
  /* It is impossible to handle the -mips2 case correct.  */
  #elif __mips == 3
    #define _MIPS_ISA       _MIPS_ISA_MIPS3
  #elif __mips == 4
    #define _MIPS_ISA       _MIPS_ISA_MIPS4
  #elif __mips == 5
    #define _MIPS_ISA       _MIPS_ISA_MIPS5
  #elif __mips == 32
    #define _MIPS_ISA       _MIPS_ISA_MIPS32
  #elif __mips == 64
    #define _MIPS_ISA       _MIPS_ISA_MIPS64
  #endif
#endif

#ifndef _MIPS_SIM
  #define _MIPS_SIM       _MIPS_SIM_ABI32
#endif
#ifndef _MIPS_SZINT
  #define _MIPS_SZINT     32
#endif
#ifndef _MIPS_SZLONG
  #define _MIPS_SZLONG    32
#endif
#ifndef _MIPS_SZPTR
  #define _MIPS_SZPTR     32
#endif

#endif	/* CONFIG_BRECIS */

#endif /* __ASM_SGIDEFS_H */
