 /*
  * @(#) stdarg.h 1.2 91/11/30 21:10:39
  * 
  * Sample stdarg.h file for use with the unproto filter.
  * 
  * This file serves two purposes.
  * 
  * 1 - As an include file for use with ANSI-style C source that implements
  * variadic functions.
  * 
  * 2 - To configure the unproto filter itself. If the _VA_ALIST_ macro is
  * defined, its value will appear in the place of the "..." in argument
  * lists of variadic function *definitions* (not declarations).
  * 
  * Compilers that pass arguments via the stack can use the default code at the
  * end of this file (this usually applies for the VAX, MC68k and 80*86
  * architectures).
  * 
  * RISC-based systems often need special tricks. An example of the latter is
  * given for the SPARC architecture. Read your /usr/include/varargs.h for
  * more information.
  * 
  * You can use the varargs.c program provided with the unproto package to
  * verify that the stdarg.h file has been set up correctly.
  */

#ifndef __STDARG_H
#define __STDARG_H

#ifdef sparc
#  define _VA_ALIST_		"__builtin_va_alist"
   typedef char *va_list;
#  define va_start(ap, p)	(ap = (char *) &__builtin_va_alist)
#  define va_arg(ap, type)	((type *) __builtin_va_arg_incr((type *) ap))[0]
#  define va_end(ap)
#else
#ifdef __arm__
#ifndef __GNUC_VA_LIST
#define __GNUC_VA_LIST
typedef __builtin_va_list __gnuc_va_list;
#endif
typedef __gnuc_va_list va_list;
#ifndef _VA_LIST
#define _VA_LIST
#endif
#ifndef _VA_LIST_DEFINED
#define _VA_LIST_DEFINED
#endif
#ifndef _VA_LIST_T_H
#define _VA_LIST_T_H
#endif
#ifndef __va_list__
#define __va_list__
#endif
#define va_start(v,l)   __builtin_stdarg_start((v),l)
#define va_end          __builtin_va_end
#define va_arg          __builtin_va_arg
#if !defined(__STRICT_ANSI__) || __STDC_VERSION__ + 0 >= 199900L
#define va_copy(d,s)    __builtin_va_copy((d),(s))
#endif
#define __va_copy(d,s)  __builtin_va_copy((d),(s))

#else /* vax, mc68k, 80*86 */
   typedef char *va_list;
#  define va_start(ap, p)	(ap = (char *) (&(p)+1))
#  define va_arg(ap, type)	((type *) (ap += sizeof(type)))[-1]
#  define va_end(ap)
#endif
#endif

#endif /* __STDARG_H */

#if __FIRST_ARG_IN_AX__
#error First arg is in a register, stdarg.h cannot take its address
#endif
