#include <linux/config.h>

/*
 *  linux/fs/binfmt_flat.c
 *
 * Copyright (c) 2001 Lineo Canada Corp., Faisal Akber <fakber@lineo.ca>
 *     Added support for MIPS and other platforms that have non-standard
 *     relocations.
 *
 *	Copyright (C) 2000 Lineo, by David McCullough <davidm@lineo.com>
 *  based heavily on:
 *  linux/fs/binfmt_aout.c:
 *
 *      Copyright (C) 1991, 1992, 1996  Linus Torvalds
 *  linux/fs/binfmt_flat.c for 2.0 kernel
 *	    Copyright (C) 1998  Kenneth Albanowski <kjahds@kjahds.com>
 *	JAN/99 -- coded full program relocation (gerg@lineo.com)
 */

#include <linux/module.h>

#include <linux/mm.h>
#include <linux/fs.h>
#include <linux/slab.h>

#if defined(CONFIG_BINFMT_ZELF)
/*
 * this is fairly harmless unless you use it.  It hasn't had a lot
 * of testing but I have run systems with every binary compressed (davidm)
 *
 * here are the zlib hacks - to replace globals with locals
 */

typedef unsigned char uch;
typedef unsigned short ush;
typedef unsigned long ulg;
#define INBUFSIZ 4096
#define WSIZE 0x8000			/* window size--must be a power of two, and */
					/* at least 32K for zip's deflate method */
struct s_zloc {
  struct linux_binprm *bprm;
  unsigned long   start_pos;
  unsigned long   bytes2read;
  char           *data_pointer,
                 *out_pointer;
  uch            *inbuf;
  uch            *window;
  unsigned        insize;		/* valid bytes in inbuf */
  unsigned        inptr;		/* index of next byte to be processed in inbuf */
  unsigned        outcnt;		/* bytes in output buffer */
  int             exit_code;
  long            bytes_out;
  int             crd_infp,
                  crd_outfp;
  ulg             bb;			/* bit buffer */
  unsigned        bk;			/* bits in bit buffer */
  ulg             crc_32_tab[256];
  ulg             crc;			/* shift register contents */
  unsigned        hufts;
};

static int      fill_inbuf(struct s_zloc * zloc)
{
  int             i;
  loff_t          fpos;

  if (zloc->exit_code)
    return -1;
  i = (zloc->bytes2read > INBUFSIZ) ? INBUFSIZ : zloc->bytes2read;
  fpos = zloc->start_pos;
  i = zloc->bprm->file->f_op->read(zloc->bprm->file,
				   (char *) zloc->data_pointer, i, &fpos);
  if (i >= (unsigned long) -4096)
    return -1;
  zloc->bytes2read -= i;
  zloc->start_pos += i;
  zloc->insize = i;
  zloc->inptr = 1;
  return zloc->inbuf[0];
}

static void     flush_window(struct s_zloc * zloc)
{
  ulg             c = zloc->crc;
  unsigned        n;
  uch            *in,
                  ch;
  memcpy(zloc->out_pointer, zloc->window, zloc->outcnt);
  in = zloc->window;
  for (n = 0; n < zloc->outcnt; n++) {
    ch = *in++;
    c = zloc->crc_32_tab[((int) c ^ ch) & 0xff] ^ (c >> 8);
  }
  zloc->crc = c;
  zloc->out_pointer += zloc->outcnt;
  zloc->bytes_out += (ulg) zloc->outcnt;
  zloc->outcnt = 0;
}

#define inbuf (zloc->inbuf)
#define window (zloc->window)
#define insize (zloc->insize)
#define inptr (zloc->inptr)
#define outcnt (zloc->outcnt)
#define exit_code (zloc->exit_code)
#define bytes_out (zloc->bytes_out)
#define crd_infp (zloc->crd_infp)
#define crd_infp (zloc->crd_infp)
#define bb (zloc->bb)
#define bk (zloc->bk)
#define crc (zloc->crc)
#define crc_32_tab (zloc->crc_32_tab)
#define hufts (zloc->hufts)

#define get_byte()  (inptr < insize ? inbuf[inptr++] : fill_inbuf(zloc))
/* Prior definition is better(if defined) ...MaTed-- - */
#ifndef memzero
#define memzero(s, n)     memset ((s), 0, (n))
#endif	/* memzero */

#define OF(args)  args
#define Assert(cond,msg)
#define Trace(x)
#define Tracev(x)
#define Tracevv(x)
#define Tracec(c,x)
#define Tracecv(c,x)

#define STATIC static

#define malloc(arg) kmalloc(arg, GFP_KERNEL)
#define free(arg) kfree(arg)

#define error(arg) printk("zflat:" arg "\n")

#include "../lib/inflate2.c"

#undef error

#undef malloc
#undef free

#undef inbuf
#undef window
#undef insize
#undef inptr
#undef outcnt
#undef exit_code
#undef bytes_out
#undef crd_infp
#undef crd_outp
#undef bb
#undef bk
#undef crc
#undef crc_32_tab

#undef get_byte

int      decompress_exec(struct linux_binprm * bprm,
				unsigned long offset, char *buffer, long len)
{
  struct s_zloc  *zloc;
  int             res;

  zloc = kmalloc(sizeof(*zloc), GFP_KERNEL);
  if (!zloc) {
    return -ENOMEM;
  }
  memset(zloc, 0, sizeof(*zloc));
  zloc->bprm = bprm;
  zloc->out_pointer = buffer;
  zloc->inbuf = kmalloc(INBUFSIZ, GFP_KERNEL);
  if (!zloc->inbuf) {
    kfree(zloc);
    return -ENOMEM;
  }
  zloc->window = kmalloc(WSIZE, GFP_KERNEL);
  if (!zloc->window) {
    kfree(zloc->inbuf);
    kfree(zloc);
    return -ENOMEM;
  }
  zloc->data_pointer = zloc->inbuf;
  zloc->bytes2read = len;
  zloc->start_pos = offset;
  zloc->crc = (ulg) 0xffffffffL;
  makecrc(zloc);
  res = gunzip(zloc);
  kfree(zloc->window);
  kfree(zloc->inbuf);
  kfree(zloc);
  return res ? -ENOMEM : 0;
}

EXPORT_SYMBOL(decompress_exec) ;
#endif	/* CONFIG_BINFMT_ZELF */
