/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************/
#include	"rt_config.h"

VOID RaiseClock(
    IN	PRTMP_ADAPTER	pAd,
    IN  ULONG *x)
{
    *x = *x | EESK;
    RTMP_IO_WRITE32(pAd, CSR21, *x);
    udelay(1);
}

VOID LowerClock(
    IN	PRTMP_ADAPTER	pAd,
    IN  ULONG *x)
{
    *x = *x & ~EESK;
    RTMP_IO_WRITE32(pAd, CSR21, *x);
    udelay(1);
}

USHORT ShiftInBits(
    IN	PRTMP_ADAPTER	pAd)
{
    ULONG       x,i;
	USHORT      data=0;

    RTMP_IO_READ32(pAd, CSR21, &x);

    x &= ~( EEDO | EEDI);
    
    for(i=0; i<16; i++)
    {
        data = data << 1;
        RaiseClock(pAd, &x);

        RTMP_IO_READ32(pAd, CSR21, &x);

        x &= ~(EEDI);
        if(x & EEDO)
            data |= 1;

        LowerClock(pAd, &x);
    }

    return data;
}

VOID ShiftOutBits(
    IN	PRTMP_ADAPTER	pAd,
    IN  USHORT data,
    IN  USHORT count)
{
    ULONG       x,mask;

    mask = 0x01 << (count - 1);
    RTMP_IO_READ32(pAd, CSR21, &x);

    x &= ~(EEDO | EEDI);

    do
    {
        x &= ~EEDI;
        if(data & mask)		x |= EEDI;

        RTMP_IO_WRITE32(pAd, CSR21, x);

        RaiseClock(pAd, &x);
        LowerClock(pAd, &x);

        mask = mask >> 1;
    } while(mask);

    x &= ~EEDI;
    RTMP_IO_WRITE32(pAd, CSR21, x);
}

VOID EEpromCleanup(
    IN	PRTMP_ADAPTER	pAd)
{
    ULONG x;

    RTMP_IO_READ32(pAd, CSR21, &x);
	
    x &= ~(EECS | EEDI);
    RTMP_IO_WRITE32(pAd, CSR21, x);

    RaiseClock(pAd, &x);
    LowerClock(pAd, &x);	
}

VOID EWEN(
	IN	PRTMP_ADAPTER	pAd)
{
    ULONG	x;

    // reset bits and set EECS
    RTMP_IO_READ32(pAd, CSR21, &x);
    x &= ~(EEDI | EEDO | EESK);
    x |= EECS;
    RTMP_IO_WRITE32(pAd, CSR21, x);

	// kick a pulse
	RaiseClock(pAd, &x);
	LowerClock(pAd, &x);

    // output the read_opcode and six pulse in that order    
    ShiftOutBits(pAd, EEPROM_EWEN_OPCODE, 5);
    ShiftOutBits(pAd, 0, 6);

    EEpromCleanup(pAd);    
}

VOID EWDS(
	IN	PRTMP_ADAPTER	pAd)
{
    ULONG	x;

    // reset bits and set EECS
    RTMP_IO_READ32(pAd, CSR21, &x);
    x &= ~(EEDI | EEDO | EESK);
    x |= EECS;
    RTMP_IO_WRITE32(pAd, CSR21, x);

	// kick a pulse
	RaiseClock(pAd, &x);
	LowerClock(pAd, &x);

    // output the read_opcode and six pulse in that order    
    ShiftOutBits(pAd, EEPROM_EWDS_OPCODE, 5);
    ShiftOutBits(pAd, 0, 6);

    EEpromCleanup(pAd);    
}

USHORT RTMP_EEPROM_READ16(
    IN	PRTMP_ADAPTER	pAd,
    IN  USHORT Offset)
{
    ULONG       x;
    USHORT      data;

    Offset /= 2;
    // reset bits and set EECS
    RTMP_IO_READ32(pAd, CSR21, &x);
    x &= ~(EEDI | EEDO | EESK);
    x |= EECS;
    RTMP_IO_WRITE32(pAd, CSR21, x);

	// kick a pulse
	RaiseClock(pAd, &x);
	LowerClock(pAd, &x);

    // output the read_opcode and register number in that order    
    ShiftOutBits(pAd, EEPROM_READ_OPCODE, 3);
    ShiftOutBits(pAd, Offset, pAd->EEPROMAddressNum);

    // Now read the data (16 bits) in from the selected EEPROM word
    data = ShiftInBits(pAd);

    EEpromCleanup(pAd);

    return data;
}	//ReadEEprom

VOID RTMP_EEPROM_WRITE16(
    IN	PRTMP_ADAPTER	pAd,
    IN  USHORT Offset,
    IN  USHORT Data)
{
    ULONG	i, x;

	Offset /= 2;
	
	EWEN(pAd);

    // reset bits and set EECS
    RTMP_IO_READ32(pAd, CSR21, &x);
    x &= ~(EEDI | EEDO | EESK);
    x |= EECS;
    RTMP_IO_WRITE32(pAd, CSR21, x);

	// kick a pulse
	RaiseClock(pAd, &x);
	LowerClock(pAd, &x);

    // output the read_opcode ,register number and data in that order    
    ShiftOutBits(pAd, EEPROM_WRITE_OPCODE, 3);
    ShiftOutBits(pAd, Offset, pAd->EEPROMAddressNum);
	ShiftOutBits(pAd, Data, 16);		// 16-bit access

    // read DO status
    RTMP_IO_READ32(pAd, CSR21, &x);

    EEpromCleanup(pAd);

    for(i=0; i<10; i++)
    	udelay(1000);		//delay for twp(MAX)=10ms
		
	EWDS(pAd);

    EEpromCleanup(pAd);
}


