/****************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 * (c) Copyright 2002, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ****************************************************************************
     
     Module Name:
     sync.c
     
     Abstract:
     Synchronization state machine related services
     
     Revision History:
     Who         When          What
     --------    ----------    ----------------------------------------------
     John Chang  08-04-2003    created for 11g soft-AP
     
 */

#include "rt_config.h"

/*
    ==========================================================================
    Description:
        The sync state machine, 
    Parameters:
        Sm - pointer to the state machine
    Note:
        the state machine looks like the following
        
                        SYNC_IDLE             
    MT2_PEER_PROBE_REQ  peer_probe_req_action    
    ==========================================================================
 */
VOID SyncStateMachineInit(
    IN PRTMP_ADAPTER pAd, 
    IN STATE_MACHINE *Sm, 
    OUT STATE_MACHINE_FUNC Trans[]) 
{
    StateMachineInit(Sm, (STATE_MACHINE_FUNC*)Trans, MAX_SYNC_STATE, MAX_SYNC_MSG, (STATE_MACHINE_FUNC)Drop, SYNC_IDLE, SYNC_MACHINE_BASE);

    StateMachineSetAction(Sm, SYNC_IDLE, MT2_PEER_PROBE_REQ, (STATE_MACHINE_FUNC)PeerProbeReqAction); 
    StateMachineSetAction(Sm, SYNC_IDLE, MT2_PEER_BEACON, (STATE_MACHINE_FUNC)PeerBeaconAction); 
}

/*
    ==========================================================================
    Description:
        Process the received ProbeRequest from clients
    Parameters:
        Elem - msg containing the ProbeReq frame
    ==========================================================================
 */
VOID PeerProbeReqAction(
    IN PRTMP_ADAPTER pAd, 
    IN MLME_QUEUE_ELEM *Elem) 
{
    MACADDR       Addr2;
    CHAR          Ssid[MAX_LEN_OF_SSID];
    UCHAR         SsidLen; //, Rates[MAX_LEN_OF_SUPPORTED_RATES], RatesLen;
    MACHDR        ProbeRspHdr;
    NDIS_STATUS   NStatus;
    UCHAR         *OutBuffer = NULL;
    ULONG         FrameLen = 0;
    LARGE_INTEGER FakeTimestamp;
    UCHAR         SsidIe = IE_SSID, DsIe = IE_DS_PARM, IbssIe = IE_IBSS_PARM, SuppIe = IE_SUPP_RATES, 
                  DsLen = 1, IbssLen = 2, TimIe=IE_TIM, TimLen=1, // DtimCount=0, DtimPeriod=1,
                  BitmapControl=0, VirtualBitmap=0;
    UCHAR         RSN_IE[22]={ 0x00,0x50,0xf2,0x01,0x01,0x00,0x00,0x50,0xf2,0x02,0x01,0x00,0x00,0x50,0xf2,0x02,0x01,0x00,0x00,0x50,0xf2,0x02};
    UCHAR         RSNIe=IE_WPA_RSN_IE,RSN_Len=22;
    
    if (! PeerProbeReqSanity(pAd, Elem->Msg, Elem->MsgLen, &Addr2, Ssid, &SsidLen)) //, Rates, &RatesLen))
        return;
    
    if (((SsidLen == 0) && (pAd->PortCfg.HideSsid == 0)) || 
        ((SsidLen == pAd->PortCfg.SsidLen) && RTMPEqualMemory(Ssid, pAd->PortCfg.Ssid, (ULONG) SsidLen)))
    {
        // allocate and send out ProbeRsp frame
        OutBuffer = kmalloc(MAX_LEN_OF_MLME_BUFFER, GFP_KERNEL);
        if(OutBuffer == NULL)
	        return;
            
        DBGPRINT(RT_DEBUG_INFO, "SYNC - Send PROBE_RSP to %02x:%02x:%02x:%02x:%02x:%02x...\n", 
            Addr2.Octet[0],Addr2.Octet[1],Addr2.Octet[2],Addr2.Octet[3],Addr2.Octet[4],Addr2.Octet[5] );

        MgtMacHeaderInit(pAd, &ProbeRspHdr, SUBTYPE_PROBE_RSP, 0, &Addr2, &pAd->PortCfg.Bssid);

        // Append RSN_IE when  WPA OR WPAPSK, 
        if (((pAd->PortCfg.PhyMode == PHY_11BG_MIXED) || (pAd->PortCfg.PhyMode == PHY_11G)) 
            && (pAd->PortCfg.AuthMode < Ndis802_11AuthModeWPA))
        {
            UCHAR SupportedRatesLen = 8, ErpLen = 1;
            UCHAR ExtendedRatesIe = IE_EXT_SUPP_RATES, ErpIe = IE_ERP;
            UCHAR ExtendedRatesLen = pAd->PortCfg.SupportedRatesLen - SupportedRatesLen;
                
            MakeOutgoingFrame(OutBuffer,                    &FrameLen, 
                          MAC_HDR_LEN,                      &ProbeRspHdr, 
                          TIMESTAMP_LEN,                    &FakeTimestamp,
                          2,                                &pAd->PortCfg.BeaconPeriod,
                          2,                                &pAd->PortCfg.CapabilityInfo,
                          1,                                &SsidIe, 
                          1,                                &pAd->PortCfg.SsidLen, 
                          pAd->PortCfg.SsidLen,             pAd->PortCfg.Ssid,
                          1,                                &SuppIe, 
                          1,                                &SupportedRatesLen,
                          SupportedRatesLen,                pAd->PortCfg.SupportedRates, 
                          1,                                &DsIe, 
                          1,                                &DsLen, 
                          1,                                &pAd->PortCfg.Channel,
                          1,                                &ErpIe,
                          1,                                &ErpLen,
                          1,                                &pAd->Mlme.ErpIeContent,
                          1,                                &ExtendedRatesIe,
                          1,                                &ExtendedRatesLen,
                          ExtendedRatesLen,                 &pAd->PortCfg.SupportedRates[SupportedRatesLen],
                          END_OF_ARGS);
        }
        else if(  pAd->PortCfg.AuthMode<Ndis802_11AuthModeWPA)
        {
            MakeOutgoingFrame(OutBuffer,                  &FrameLen, 
                        MAC_HDR_LEN,                      &ProbeRspHdr, 
                        TIMESTAMP_LEN,                    &FakeTimestamp,
                        2,                                &pAd->PortCfg.BeaconPeriod,
                        2,                                &pAd->PortCfg.CapabilityInfo,
                        1,                                &SsidIe, 
                        1,                                &pAd->PortCfg.SsidLen, 
                        pAd->PortCfg.SsidLen,             pAd->PortCfg.Ssid,
                        1,                                &SuppIe, 
                        1,                                &pAd->PortCfg.SupportedRatesLen,
                        pAd->PortCfg.SupportedRatesLen,   pAd->PortCfg.SupportedRates, 
                        1,                                &DsIe, 
                        1,                                &DsLen, 
                        1,                                &pAd->PortCfg.Channel,
                        END_OF_ARGS);
        }
        else if ((pAd->PortCfg.PhyMode == PHY_11BG_MIXED) || (pAd->PortCfg.PhyMode == PHY_11G))
        {
            UCHAR SupportedRatesLen = 8, ErpLen = 1;
            UCHAR ExtendedRatesIe = IE_EXT_SUPP_RATES, ErpIe = IE_ERP;
            UCHAR ExtendedRatesLen = pAd->PortCfg.SupportedRatesLen - SupportedRatesLen;
             
            MakeOutgoingFrame(OutBuffer,                  &FrameLen, 
                        MAC_HDR_LEN,                      &ProbeRspHdr, 
                        TIMESTAMP_LEN,                    &FakeTimestamp,
                        2,                                &pAd->PortCfg.BeaconPeriod,
                        2,                                &pAd->PortCfg.CapabilityInfo,
                        1,                                &SsidIe, 
                        1,                                &pAd->PortCfg.SsidLen, 
                        pAd->PortCfg.SsidLen,             pAd->PortCfg.Ssid,
                        1,                                &SuppIe, 
                        1,                                &SupportedRatesLen,
                        SupportedRatesLen,                pAd->PortCfg.SupportedRates, 
                        1,                                &DsIe, 
                        1,                                &DsLen, 
                        1,                                &pAd->PortCfg.Channel,
                        1,                                &ErpIe,
                        1,                                &ErpLen,
                        1,                                &pAd->Mlme.ErpIeContent,
                        1,                                &ExtendedRatesIe,
                        1,                                &ExtendedRatesLen,
                        ExtendedRatesLen,                 &pAd->PortCfg.SupportedRates[SupportedRatesLen],
                        1,                                &RSNIe,
                        1,                                &pAd->PortCfg.RSNIE_Len,
                        pAd->PortCfg.RSNIE_Len,           pAd->PortCfg.RSN_IE,
                        END_OF_ARGS);
        }
        else
        {
            MakeOutgoingFrame(OutBuffer,                  &FrameLen, 
                        MAC_HDR_LEN,                      &ProbeRspHdr, 
                        TIMESTAMP_LEN,                    &FakeTimestamp,
                        2,                                &pAd->PortCfg.BeaconPeriod,
                        2,                                &pAd->PortCfg.CapabilityInfo,
                        1,                                &SsidIe, 
                        1,                                &pAd->PortCfg.SsidLen, 
                        pAd->PortCfg.SsidLen,             pAd->PortCfg.Ssid,
                        1,                                &SuppIe, 
                        1,                                &pAd->PortCfg.SupportedRatesLen,
                        pAd->PortCfg.SupportedRatesLen,   pAd->PortCfg.SupportedRates, 
                        1,                                &DsIe, 
                        1,                                &DsLen, 
                        1,                                &pAd->PortCfg.Channel,
                        1,                                &RSNIe,
                        1,                                &pAd->PortCfg.RSNIE_Len,
                        pAd->PortCfg.RSNIE_Len,           pAd->PortCfg.RSN_IE,
                        END_OF_ARGS);
        }
            
        MiniportMMRequest(pAd, OutBuffer, FrameLen);
    }
}

/* 
    ==========================================================================
    Description:
        parse the received BEACON

    NOTE:
        The only thing AP cares about received BEACON frames is to decide 
        if there's any overlapped legacy BSS condition (OLBC).
        If OLBC happened, this AP should set the ERP->Use_Protection bit in its 
        outgoing BEACON. The result is to tell all its clients to use RTC/CTS
        or CTS-to-self protection to protect B/G mixed traffic
    ==========================================================================
 */
VOID PeerBeaconAction(
    IN PRTMP_ADAPTER pAd, 
    IN MLME_QUEUE_ELEM *Elem) 
{
    MACADDR       Bssid, Addr2;
    CHAR          Ssid[MAX_LEN_OF_SSID];
    UCHAR         SsidLen, MessageToMe=0, BssType, Channel, Rates[MAX_LEN_OF_SUPPORTED_RATES];
    UCHAR         RatesLen, DtimCount=0, DtimPeriod=0, BcastFlag=0, Legacy;
    USHORT        CapabilityInfo, AtimWin, BeaconPeriod;
    LARGE_INTEGER TimeStamp;
    BOOLEAN       ExtendedRateIeExist;
    BOOLEAN       LegacyBssExist;
    UCHAR         Erp;

    if (PeerBeaconAndProbeRspSanity(pAd, 
                                Elem->Msg, 
                                Elem->MsgLen, 
                                &Addr2, 
                                &Bssid, 
                                Ssid, 
                                &SsidLen, 
                                &BssType, 
                                &BeaconPeriod, 
                                &Channel, 
                                &TimeStamp, 
                                &CapabilityInfo, 
                                Rates, 
                                &RatesLen,
                                &ExtendedRateIeExist,
                                &Erp))
    {
        if (Channel == pAd->PortCfg.AutoChannel_Channel)
        {
            // record the max RSSI of any received BEACON frames. APStartUp phase will
            // use this information to help select a less interference channel
            if (Elem->Rssi> pAd->PortCfg.AutoChannel_MaxRssi)
                pAd->PortCfg.AutoChannel_MaxRssi = Elem->Rssi;
        }

        // ignore BEACON not in this channel
        if (Channel != pAd->PortCfg.Channel)
            return;

        if ((Erp & 0x01) || (RatesLen <= 4))
            LegacyBssExist = TRUE;
        else
            LegacyBssExist = FALSE;

        if (LegacyBssExist)
        {
            pAd->Mlme.LastOLBCDetectTime = pAd->Mlme.Now32;
            DBGPRINT(RT_DEBUG_INFO, "%02x:%02x:%02x:%02x:%02x:%02x is a legacy BSS (rate# =%d, ERP=%d), set Use_Protection bit\n", 
                Bssid.Octet[0], Bssid.Octet[1], Bssid.Octet[2], 
                Bssid.Octet[3], Bssid.Octet[4], Bssid.Octet[5], 
                RatesLen, Erp);
        }            
    }
    // sanity check fail, ignore this frame
}

