/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology	5th	Rd.
 * Science-based Industrial	Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002, Ralink Technology, Inc.
 *
 * All rights reserved.	Ralink's source	code is	an unpublished work	and	the
 * use of a	copyright notice does not imply	otherwise. This	source code
 * contains	confidential trade secret material of Ralink Tech. Any attemp
 * or participation	in deciphering,	decoding, reverse engineering or in	any
 * way altering	the	source code	is stricitly prohibited, unless	the	prior
 * written consent of Ralink Technology, Inc. is obtained.
 ***************************************************************************

	Module Name:
	rtmp_data.c

	Abstract:
	Data path subroutines

	Revision History:
	Who			When			What
	--------	----------		----------------------------------------------
	Paul Lin	08-01-2002		created
	Paul Lin	07-01-2003		add	encryption/decryption data flow
	John Chang	08-05-2003		modify 802.11 header for AP	purpose
*/
#include "rt_config.h"

static const ULONG Bit[32] = {
	0x00000001,	0x00000002,	0x00000004,	0x00000008,	0x00000010,	0x00000020,	0x00000040,	0x00000080,
	0x00000100,	0x00000200,	0x00000400,	0x00000800,	0x00001000,	0x00002000,	0x00004000,	0x00008000,
	0x00010000,	0x00020000,	0x00040000,	0x00080000,	0x00100000,	0x00200000,	0x00400000,	0x00800000,
	0x01000000,	0x02000000,	0x04000000,	0x08000000,	0x10000000,	0x20000000,	0x40000000,	0x80000000 };
		
static	UCHAR	SNAP_802_1H[] =	{0xaa, 0xaa, 0x03, 0x00, 0x00, 0x00};
static	UCHAR	SNAP_BRIDGE_TUNNEL[] = {0xaa, 0xaa,	0x03, 0x00,	0x00, 0xf8};
static	UCHAR	EAPOL[]	= {0x88, 0x8e};

static	UCHAR	IPX[] =	{0x81, 0x37};
static	UCHAR	APPLE_TALK[] = {0x80, 0xf3};
static	UCHAR	PlcpSignal[12] = { 
	 0,	/* RATE_1 */	1, /* RATE_2 */		2, /* RATE_5_5 */	3, /* RATE_11 */	// see BBP spec
	11,	/* RATE_6 */   15, /* RATE_9 */	   10, /* RATE_12 */   14, /* RATE_18 */	// see IEEE802.11a-1999	p.14
	 9,	/* RATE_24 */  13, /* RATE_36 */	8, /* RATE_48 */   12  /* RATE_54 */ };	// see IEEE802.11a-1999	p.14

/*
	========================================================================
	Routine	Description:
		Process	RxDone interrupt, running in DPC level

	Arguments:
		pAdapter	Pointer	to our adapter

	Return Value:
		None

	Note:
		This routine has to	maintain Rx	ring read pointer.
	========================================================================
*/
VOID	RTMPHandleRxDoneInterrupt(
	IN	PRTMP_ADAPTER	pAdapter)
{
	PRXD_STRUC		pRxD;
	RXD_STRUC		RxD; //tt_lin_big
	
	PHEADER_802_11	pHeader;
	HEADER_802_11	Header;	//tt_lin_big

	PUCHAR			pData;
	PVOID			pManage;
	PUCHAR			pDestMac, pSrcMac;
	UCHAR			Count;
	UCHAR			KeyIdx;
	PWPA_KEY		pWpaKey	= (PWPA_KEY) NULL;
	NDIS_STATUS		Status;
	BOOLEAN			bDropFrame;
	ULONG			RegValue, Address;
	ULONG			HwDecryptIndex;
	MAC_TABLE_ENTRY	*pEntry;

	// Make	sure Rx	ring resource won't	be used	by other threads
	NdisAcquireSpinLock(&pAdapter->RxRingLock);

	// Verify Hardware Decryption pointer with Software	Decryption pointer
	RTMP_IO_READ32(pAdapter, SECCSR0, &RegValue);
	HwDecryptIndex = (RegValue - pAdapter->RxRing[0].pa_addr) /	RING_DESCRIPTOR_SIZE;
	Address	= pAdapter->RxRing[pAdapter->CurDecryptIndex].pa_addr;
	if (Address	!= RegValue)
	{
		DBGPRINT(RT_DEBUG_ERROR,"pAdapter->CurDecryptIndex =  %d, \n", pAdapter->CurDecryptIndex);
		DBGPRINT(RT_DEBUG_ERROR,"Decrypt pointer not matched SW	= 0x%x,	HW = 0x%x\n", Address, RegValue);
		DBGPRINT(RT_DEBUG_ERROR,"Sw	Decr Ptr = %d, Rx ptr =	%d Hw ptr =	%d\n",
			pAdapter->CurDecryptIndex, pAdapter->CurRxIndex, HwDecryptIndex);
	}

	Count =	0;
	do
	{
		// Point to	Rx indexed rx ring descriptor
		pRxD = (PRXD_STRUC)	pAdapter->RxRing[pAdapter->CurRxIndex].va_addr;
		*(PULONG)&RxD =	RTMP_LE32_TO_CPU( *(PULONG)pRxD	);//tt_lin_big
		*(((PULONG)&RxD)+10) = RTMP_LE32_TO_CPU( *(((PULONG)pRxD)+10) );//tt_lin_big
		
		// Initialize drop frame flag
		bDropFrame = FALSE;

		// In case of false	alarm or processed at last instance
		if (RxD.Owner != DESC_OWN_HOST)//w0
		{
			break;
		}

		// Decrypt engine stuck
		if (RxD.CipherOwner	!= DESC_OWN_HOST)//w0
		{
			pAdapter->RalinkCounters.RxRingErrCount++;
			break;
		}

#ifdef RALINK_ATE
		if(pAdapter->ate.Mode == ATE_RXFRAME)
		{
			bDropFrame = TRUE;
		}
#endif	//#ifdef RALINK_ATE
		
		// Point to	Rx ring	buffer where stores	the	real data frame
		pData	= (PUCHAR) (pAdapter->RxRing[pAdapter->CurRxIndex].va_data_addr);
		// Cast	to 802.11 header for flags checking
		pHeader	= (PHEADER_802_11) pData;
		*(PUSHORT)&Header =	RTMP_LE16_TO_CPU( *(PUSHORT)pHeader	);//tt_lin_big

#if	0
DebugPrint(	"HEADER_802_11_ORGIN", (PUCHAR)pHeader,	RxD.DataByteCnt);
DebugPrint(	"Rxd_ORGIN", (PUCHAR)pRxD, sizeof(RXD_STRUC) );	
#endif

	   // Increase Total receive byte counter after	real data received no mater	any	error or not
		pAdapter->RalinkCounters.ReceivedByteCount +=  RxD.DataByteCnt;
		
		// Check for all RxD errors
		Status = RTMPCheckRxDescriptor(pRxD);
		
		// Paul	04-03 for OFDM Rx length issue
		if (RxD.DataByteCnt	> 1600)	//w0
			Status = NDIS_STATUS_FAILURE;
			
		if (Status == NDIS_STATUS_SUCCESS)
		{
			INC_COUNTER(pAdapter->WlanCounters.ReceivedFragmentCount);
			pAdapter->Counters.GoodReceives++;
					// collect current antenna's average RSSI
			if (pAdapter->PortCfg.RxAnt.PrimaryInUsed)
			{
				USHORT AvgRssi = pAdapter->PortCfg.RxAnt.AvgRssi[pAdapter->PortCfg.RxAnt.PrimaryRxAnt];
				if (AvgRssi > 0) 
					AvgRssi = (AvgRssi + pRxD->BBR1) >> 1;
				else
					AvgRssi = pRxD->BBR1;
				pAdapter->PortCfg.RxAnt.AvgRssi[pAdapter->PortCfg.RxAnt.PrimaryRxAnt] = AvgRssi;
			}
			else
			{
				USHORT AvgRssi = pAdapter->PortCfg.RxAnt.AvgRssi[pAdapter->PortCfg.RxAnt.SecondaryRxAnt];
				if (AvgRssi > 0) 
					AvgRssi = (AvgRssi + pRxD->BBR1) >> 1;
				else
					AvgRssi = pRxD->BBR1;
				pAdapter->PortCfg.RxAnt.AvgRssi[pAdapter->PortCfg.RxAnt.SecondaryRxAnt] = AvgRssi;
			}
		}
		else
		{
			pAdapter->Counters.RxErrors++;
		}

		// All frames to AP	are	directed except	probe_req. IEEE	802.11/1999	- p.463
		// Do this before checking "duplicate frame".
		// 2003-08-20 accept BEACON	to decide if OLBC (Overlapping Legacy BSS Condition) happens
		if (RxD.U2M)//w0
		{
			// ignore all CNTL frames except PS-POLL
				if ((Header.Controlhead.Frame.Type == BTYPE_CNTL) && (Header.Controlhead.Frame.Subtype != SUBTYPE_PS_POLL)) {//s0
					Status = NDIS_STATUS_FAILURE;
					DBGPRINT(RT_DEBUG_INFO,	"--1-Status	= NDIS_STATUS_FAILURE\n");
				}
		}
		else if	((Header.Controlhead.Frame.Type	== BTYPE_MGMT) &&  //s0
				 ((Header.Controlhead.Frame.Subtype	== SUBTYPE_BEACON) ||  //s0
				  (Header.Controlhead.Frame.Subtype	== SUBTYPE_PROBE_REQ)))	//s0
			;
		else
		{
			Status = NDIS_STATUS_FAILURE;
			DBGPRINT(RT_DEBUG_INFO,	"--2-Status==NDIS_STATUS_FAILURE\n");
		}	
			// Gather PowerSave	information	from all valid frames. IEEE	802.11/1999	p.461
		if ((Status	== NDIS_STATUS_SUCCESS)	&& (RxD.U2M) &&	(Header.Controlhead.Frame.Type == BTYPE_DATA) )//w0, s0
		{
			if (Header.Controlhead.Frame.PwrMgt)//s0
				PsIndicate(pAdapter, &pHeader->Controlhead.Addr2,  pRxD->BBR1, PWR_SAVE);
			else
				PsIndicate(pAdapter, &pHeader->Controlhead.Addr2, pRxD->BBR1, PWR_ACTIVE);
		}
		
		// Duplicate frame check. This check only apply	to unicast data	& management frames
		if ((Status	== NDIS_STATUS_SUCCESS)	&& (RxD.U2M) &&	//w0
			((Header.Controlhead.Frame.Type	== BTYPE_DATA)||(Header.Controlhead.Frame.Type	== BTYPE_MGMT)))   //s0
		{
			Status = RTMPCheckDuplicateFrame(pAdapter, pHeader);
			DBGPRINT(RT_DEBUG_INFO,	"RTMPCheckDuplicateFrame-%d\n",Status );
		}
		//
		// Do RxD release operation	for	all	failure	frames
		//
		if (Status == NDIS_STATUS_SUCCESS)
		{
			// Saved data pointer for management frame which will pass to MLME block
			pManage	= (PVOID) pData;

			// pData : Pointer skip	the	first 24 bytes,	802.11 HEADER
#ifdef	WDS
			if((Header.Controlhead.Frame.FrDs == 1)	&& (Header.Controlhead.Frame.ToDs == 1))//s0
			{
				pData += LENGTH_802_11_WITH_ADDR4;
			}
			else
#endif
			{
				pData += LENGTH_802_11;
			}

			//
			// Start of	main loop to parse receiving frames.
			// The sequence	will be	Type first,	then subtype...
			//
			switch (Header.Controlhead.Frame.Type)//s0
			{
				// Frame with data type
				case BTYPE_DATA:
					pEntry = MacTableLookup(pAdapter, &pHeader->Controlhead.Addr2);			
#ifdef	WDS
					if (Header.Controlhead.Frame.ToDs == 0)
					{
						bDropFrame = TRUE;
						break;
					}
#else
					if ((Header.Controlhead.Frame.FrDs==1) || (Header.Controlhead.Frame.ToDs==0))	   //s0
					{
						bDropFrame = TRUE;
						break;
					}
#endif

					// check if	Class2 or 3	error
#ifdef	WDS
					if(!(Header.Controlhead.Frame.FrDs == 1) &&	(Header.Controlhead.Frame.ToDs == 1))	 //s0
#endif
					{
						if (RTMPCheckClass2Class3Error(pAdapter, pHeader))
						{
							bDropFrame = TRUE;
							DBGPRINT(RT_DEBUG_INFO,	"RTMPCheckClass2Class3Error->FALSE\n");
							break;
						}
					}

					// Drop	NULL, CF-ACK(no	data), CF-POLL(no data), and CF-ACK+CF-POLL(no data) data frame
					if (Header.Controlhead.Frame.Subtype & 0x04) //	bit	2 :	no DATA	 (s0)
					{
						bDropFrame = TRUE;
						DBGPRINT(RT_DEBUG_INFO,	"Frame.Subtype & 0x04 == TRUE\n");
						break;
					}
					
					// Find	the	WPA	key, either	Group or Pairwise Key
					if (pAdapter->PortCfg.WepStatus	>= Ndis802_11Encryption2Enabled)
					{
//						  INT	  idx;
						
						pWpaKey	= (PWPA_KEY) NULL;
						
#ifdef	WDS
						if ((Header.Controlhead.Frame.FrDs == 1) &&	(Header.Controlhead.Frame.ToDs == 1)) //s0
						{
							pWpaKey	= (PWPA_KEY) &pAdapter->WdsTab.Wpa_key;
						}
						else
#endif
						{
							if (pHeader->Controlhead.Addr1.Octet[0]	& 0x01)
							{
								if (pAdapter->PortCfg.GroupKey[pAdapter->PortCfg.WPAGKeyID].KeyLen != 0)
								{
									pWpaKey	= (PWPA_KEY) &pAdapter->PortCfg.GroupKey[pAdapter->PortCfg.WPAGKeyID];
								}
							}						
							else
							{
								if (pEntry && (pEntry->PairwiseKey[0].KeyLen !=	0))
								{
									pWpaKey	= (PWPA_KEY) &pEntry->PairwiseKey[0];
								}
								// Use default Group Key if	there is no	Pairwise key present
								if ((pWpaKey ==	NULL) && (pAdapter->PortCfg.GroupKey[pAdapter->PortCfg.WPAGKeyID].KeyLen != 0))
								{
									pWpaKey	= (PWPA_KEY) &pAdapter->PortCfg.GroupKey[pAdapter->PortCfg.WPAGKeyID];				
								}
							}
						}
					}
					// Begin process unicast to	me frame
					RxD.CipherAlg =	CIPHER_NONE; //w0-(write back)
					if	(RxD.U2M)//w0
					{
						//
						// Begin frame processing
						//
#ifdef	WDS
						// WDS packet's	DA & SA	is not the same
						if ((Header.Controlhead.Frame.FrDs == 1) &&	(Header.Controlhead.Frame.ToDs == 1)) //s0
						{
							pDestMac = (PUCHAR)	&(pHeader->Addr3);
							pSrcMac	= (PUCHAR)pHeader +	sizeof(HEADER_802_11);
						}
						else
#endif
						{
							pDestMac = (PUCHAR)	&(pHeader->Addr3);
							pSrcMac	= (PUCHAR) &(pHeader->Controlhead.Addr2);
						}

						// WEP encrypted frame
						if (pAdapter->PortCfg.WepStatus	== Ndis802_11Encryption1Enabled)	// WEP
						{
							if (Header.Controlhead.Frame.Wep)//s0
							{ 
								NdisMoveMemory((PUCHAR)	&pRxD->Iv, pData, 4);	//Get WEP IV  
								//*(PULONG)&pRxD->Iv = RTMP_LE32_TO_CPU( *(PULONG)&pRxD->Iv	); //tt_lin_big	
								KeyIdx = (*(pData +	3) & 0xc0) >> 6;
								NdisMoveMemory(pRxD->Key, pAdapter->PortCfg.SharedKey[KeyIdx].Key, 
											   pAdapter->PortCfg.SharedKey[KeyIdx].KeyLen);									
								if (pAdapter->PortCfg.SharedKey[KeyIdx].KeyLen == 5)
									RxD.CipherAlg =	CIPHER_WEP64; //w0 (write back)
								else
									RxD.CipherAlg =	CIPHER_WEP128; //w0	(Write back)								 
							}
							else if	(pAdapter->PortCfg.PrivacyFilter ==	Ndis802_11PrivFilter8021xWEP)
							{
								// In Ndis802_11PrivFilter8021xWEP,	this frame is not encrypted,
								//Check	802.1x frame, if not drop it.
								if (!RTMPEqualMemory(EAPOL,	pData +	6, 2))
								{
									// Not 802.1X frames
									// Add error counter
									DBGPRINT(RT_DEBUG_TTL,"Drop	Frame for 802.1x, Ndis802_11PrivFilter8021xWEP\n");
									Status = NDIS_STATUS_FAILURE;
									bDropFrame = TRUE;
									break;
								}
							}
						}
						else if	((pAdapter->PortCfg.WepStatus == Ndis802_11Encryption2Enabled) && (pWpaKey != NULL))	   // TKIP
						{
							if (Header.Controlhead.Frame.Wep)//s0
							{
								UCHAR	Eiv_Tmp[4];
								
								NdisMoveMemory((PUCHAR)	&pRxD->Iv, pData, 4);			//Get  IV  (Need to	turn to	Big-endian?????)
//								*(PULONG)&pRxD->Iv = RTMP_LE32_TO_CPU( *(PULONG)&pRxD->Iv ); //tt_lin_big(change to	big-endian)
								// Swap	EIV	byte order,	due	to ASIC's bug.
								Eiv_Tmp[0] = *(pData + 7);
								Eiv_Tmp[1] = *(pData + 6);
								Eiv_Tmp[2] = *(pData + 5);
								Eiv_Tmp[3] = *(pData + 4);								
								NdisMoveMemory((PUCHAR)	&pRxD->Eiv,	Eiv_Tmp, 4);	//Get WEP EIV
//								  *(PULONG)&pRxD->Eiv =	RTMP_LE32_TO_CPU( *(PULONG)&pRxD->Eiv );//tt_lin_big(change	to big-endian)
								KeyIdx = (*(pData +	3) & 0xc0) >> 6;
								// Copy	TA into	RxD
								NdisMoveMemory(pRxD->TA, &pHeader->Controlhead.Addr2, 6);
								NdisMoveMemory(pRxD->Key, pWpaKey->Key,	16);									
								RxD.CipherAlg =	CIPHER_TKIP;
							}
							else if	(pAdapter->PortCfg.PrivacyFilter ==	Ndis802_11PrivFilter8021xWEP)
							{
								// In Ndis802_11PrivFilter8021xWEP,	this frame is not encrypted,
								// Check 802.1x	frame, if not drop it.
								if (!RTMPEqualMemory(EAPOL,	pData +	6, 2))
								{
									// Not 802.1X frames
									// Add error counter
									DBGPRINT(RT_DEBUG_TTL, "Drop frame for 802.1x, Ndis802_11PrivFilter8021xWEP\n");									
									Status = NDIS_STATUS_FAILURE;
									bDropFrame = TRUE;
									break;
								}
							}
						}
						else if	((pAdapter->PortCfg.WepStatus == Ndis802_11Encryption3Enabled) && (pWpaKey != NULL))	   // AES
						{
							if (Header.Controlhead.Frame.Wep)//s0
							{
								NdisMoveMemory((PUCHAR)	&pRxD->Iv, pData, 4);			//Get IV
								//Chgange to Big-endian
//								*(PULONG)&pRxD->Iv = RTMP_LE32_TO_CPU( *(PULONG)&pRxD->Iv ); //tt_lin_big
								NdisMoveMemory((PUCHAR)	&pRxD->Eiv,	(pData + 4), 4);	//Get  EIV 
//								*(PULONG)&pRxD->Eiv	= RTMP_LE32_TO_CPU(	*(PULONG)&pRxD->Eiv	); //tt_lin_big
								// Copy	TA into	RxD
								NdisMoveMemory(pRxD->TA, &pHeader->Controlhead.Addr2, 6);								
								KeyIdx = (*(pData +	3) & 0xc0) >> 6;
								NdisMoveMemory(pRxD->Key, pWpaKey->Key,	16);									
								RxD.CipherAlg =	CIPHER_AES;
							}
							else if	(pAdapter->PortCfg.PrivacyFilter ==	Ndis802_11PrivFilter8021xWEP)
							{
								// In Ndis802_11PrivFilter8021xWEP,	this EAPOL frame is	not	encrypted,
								// Check 802.1x	frame, if not drop it.
								if (!RTMPEqualMemory(EAPOL,	pData +	6, 2))
								{
									// Not 802.1X frames
									// Add error counter
									DBGPRINT(RT_DEBUG_TTL, "Drop frame for 802.1x, Ndis802_11PrivFilter8021xWEP\n");								   
									Status = NDIS_STATUS_FAILURE;
									bDropFrame = TRUE;
									break;
								}
							}
						}
						else if	(Header.Controlhead.Frame.Wep)//s0
						{
							// Drop	WEP	frame when WepStatus is	FALSE
							Status = NDIS_STATUS_FAILURE;
							DBGPRINT(RT_DEBUG_TTL, "Header.Controlhead.Frame.Wep==1\n");
							bDropFrame = TRUE;
							break;							  
						}						
						else	// Not encryptrd frames
						{
							RxD.CipherAlg =	CIPHER_NONE; //write-back w0
						}
					}
					break;
				case BTYPE_MGMT:
					if (Header.Controlhead.Frame.Wep)//s0
					{
						UCHAR *pPayload	= (UCHAR *)pManage + LENGTH_802_11;

						// must	be SHARED_KEY AUTH seq#3, decryption starts	after MAC header
						if (RTMPDecryptData(pAdapter, pPayload,	RxD.DataByteCnt	- LENGTH_802_11) ==	FALSE)//w0
							bDropFrame = 1;
						else 
							RxD.DataByteCnt	-= 8;  // Minus	WEP	size w0
					
						DBGPRINT(RT_DEBUG_TTL, "BTYPE_MGMT wep on -%d\n", bDropFrame);
					}
						
					// Always None encrypted
					RxD.CipherAlg =	CIPHER_NONE; //w0
					break;

				case BTYPE_CNTL:
					// Always None encrypted; must be PS-POLL
					RxD.CipherAlg =	CIPHER_NONE; //w0
					break;

				default	:
					bDropFrame = TRUE;
					DBGPRINT(RT_DEBUG_INFO,	"UnKnow	Frame type\n");							
					break;
			}//end of switch
		}
		else
		{
			bDropFrame = TRUE;
			DBGPRINT(RT_DEBUG_INFO,	"else bDropFrame==TRUE\n");
		}

		// Packet will still do	NULL cipher	operation and drop afterward
		if (bDropFrame == TRUE)
		{
			RxD.Drop	  =	1; //w10   (write back)
			RxD.CipherAlg =	CIPHER_NONE; //w0 (write back)
		}
		else
		{
			RxD.Drop	  =	0; //w10
#ifdef	WDS
			if ((Header.Controlhead.Frame.FrDs == 1) &&	(Header.Controlhead.Frame.ToDs == 1))//s0
			{
				RxD.IvOffset = LENGTH_802_11_WITH_ADDR4; //w0
			}
			else
#endif
			{
				RxD.IvOffset = LENGTH_802_11; //w0 (write back)
			}
		}
		
		RxD.CipherOwner	= DESC_OWN_NIC;	//w0 (write	back)
		pAdapter->CurRxIndex++;
		if (pAdapter->CurRxIndex >=	RX_RING_SIZE)
		{
			pAdapter->CurRxIndex = 0;
		}
		Count++;
		
		pAdapter->RalinkCounters.RxCount ++;
		*(PULONG)pRxD =	RTMP_CPU_TO_LE32( *(PULONG)&RxD	);//tt_lin_big
		*(((PULONG)pRxD)+10) = RTMP_CPU_TO_LE32( *(((PULONG)&RxD)+10) );//tt_lin_big
			 
	}	while (Count < MAX_RX_PROCESS);
		
	// Kick	Decrypt	Control	Register, based	on ASIC's implementation
	// We have to kick decrypt & encrypt every frame.
	RTMP_IO_WRITE32(pAdapter, SECCSR0, 0x1);

	// Make	sure to	release	Rx ring	resource
	NdisReleaseSpinLock(&pAdapter->RxRingLock);
}

/*
	========================================================================

	Routine	Description:
		Process	TxRing TxDone interrupt, running in	DPC	level

	Arguments:
		Adapter		Pointer	to our adapter

	Return Value:
		None

	Note:

	========================================================================
*/
VOID	RTMPHandleTxRingTxDoneInterrupt(
	IN	PRTMP_ADAPTER	pAdapter)
{
	PTXD_STRUC		pTxD;
	TXD_STRUC		TxD; //tt_lin_big
	
	PHEADER_802_11	pHeader;
	//HEADER_802_11	Header;	//tt_lin_big
	
	UCHAR			Count;
	
	// Make	sure Tx	ring resource won't	be used	by other threads
	NdisAcquireSpinLock(&pAdapter->TxRingLock);
	
	Count =	0;
	do
	{
		pTxD = (PTXD_STRUC)	(pAdapter->TxRing[pAdapter->NextTxDoneIndex].va_addr);
		*(PULONG)&TxD =	RTMP_LE32_TO_CPU( *(PULONG)pTxD	); //tt_lin_big
		
		pHeader	= (PHEADER_802_11) (pAdapter->TxRing[pAdapter->NextTxDoneIndex].va_data_addr);
		//*(PHEADER_802_11)&Header = RTMP_LE16_TO_CPU( *(PHEADER_802_11)pHeader	); //tt_lin_big
		
		// Check for the descriptor	ownership
		if ((TxD.Owner == DESC_OWN_NIC)||(TxD.CipherOwn == DESC_OWN_NIC)||(TxD.Valid == FALSE))	//w0
		{
			break;
		}
		
		RTMPHardTransmitDone(
			pAdapter, 
			pTxD, 
			&pHeader->Controlhead.Addr1,
			pAdapter->TxRing[pAdapter->NextTxDoneIndex].FrameType);
		
		// It might	happend	with no	Ndis packet	to indicate	back to	upper layer
		// Clear for NdisSendComplete request
		*(PULONG)&TxD =	RTMP_LE32_TO_CPU( *(PULONG)pTxD	); //tt_lin_big
		TxD.Valid =	FALSE;//w0
		*(PULONG)pTxD =	RTMP_CPU_TO_LE32( *(PULONG)&TxD	); //tt_lin_big

		// Increase	Total transmit byte	counter	after real data	sent out
		pAdapter->RalinkCounters.TransmittedByteCount +=  TxD.DataByteCnt; //tt_lin_big	(w0)
		
		pAdapter->NextTxDoneIndex++;
		if (pAdapter->NextTxDoneIndex >= TX_RING_SIZE)			
		{
			pAdapter->NextTxDoneIndex =	0;
			
			// Group Rekey counter based on	packets	number tramsmitted
			if(	  (pAdapter->PortCfg.WPAREKEY.ReKeyMethod==PKT_REKEY) \
				&& (pAdapter->PortCfg.REKEYTimerRunning==TRUE )	)
			{	
				pAdapter->PortCfg.REKEYCOUNTER++;
			}
		}
	}	while (++Count < MAX_TX_PROCESS);
#ifdef RALINK_ATE
	if((pAdapter->ate.Mode == ATE_TXCONT) || (pAdapter->ate.Mode == ATE_TXCARR) || (pAdapter->ate.Mode == ATE_TXFRAME))
	{
		if((pAdapter->ate.Mode == ATE_TXCONT) || (pAdapter->ate.Mode == ATE_TXCARR) || ((pAdapter->ate.Mode == ATE_TXFRAME) && (pAdapter->ate.TxDoneCount < pAdapter->ate.TxCount)))
		{
			pAdapter->ate.TxDoneCount++;
			pTxD = (PTXD_STRUC)pAdapter->TxRing[pAdapter->CurEncryptIndex].va_addr;

			RTMPWriteTxDescriptor(pTxD, TRUE, CIPHER_NONE, FALSE, FALSE, FALSE,
				SHORT_RETRY, IFS_BACKOFF, pAdapter->ate.TxRate, 4,
				pAdapter->ate.TxLength, pAdapter->PortCfg.TxPreamble, 0);

			pAdapter->CurEncryptIndex++;
			if (pAdapter->CurEncryptIndex >= TX_RING_SIZE)
			{
				pAdapter->CurEncryptIndex = 0;
			}

			RTMP_IO_WRITE32(pAdapter, SECCSR1, 0x1);
		}
		else
		{
			pTxD->Valid = FALSE;
		}
	}
#endif	//#ifdef RALINK_ATE

	// Make	sure to	release	Tx ring	resource
	NdisReleaseSpinLock(&pAdapter->TxRingLock);
	
	// Some	Tx ring	resource freed,	check for pending send frame for hard transmit
	if ((!RTMP_TEST_FLAG(pAdapter, fRTMP_ADAPTER_BSS_SCAN_IN_PROGRESS))	&& 
		(!RTMP_TEST_FLAG(pAdapter, fRTMP_ADAPTER_RADIO_OFF)) &&
		(!RTMP_TEST_FLAG(pAdapter, fRTMP_ADAPTER_RESET_IN_PROGRESS)))
	{
		RTMPDeQueuePacket(pAdapter);
	}
}

/*
	========================================================================

	Routine	Description:
		Process	Priority ring TxDone interrupt,	running	in DPC level

	Arguments:
		Adapter		Pointer	to our adapter

	Return Value:
		None

	Note:

	========================================================================
*/
VOID	RTMPHandlePrioRingTxDoneInterrupt(
	IN	PRTMP_ADAPTER	pAdapter)
{
	PTXD_STRUC		pTxD;
	TXD_STRUC		TxD; //tt_lin_big

	PHEADER_802_11	pHeader;
	UCHAR			Count;
	PMGMT_STRUC		pMgmt;
	
	// Make	sure Prio ring resource	won't be used by other threads
	NdisAcquireSpinLock(&pAdapter->PrioRingLock);	
	
	Count =	0;
	do
	{
		pTxD = (PTXD_STRUC)	(pAdapter->PrioRing[pAdapter->NextPrioDoneIndex].va_addr);
		pHeader	= (PHEADER_802_11) (pAdapter->PrioRing[pAdapter->NextPrioDoneIndex].va_data_addr);
		
		*(PULONG)&TxD =	RTMP_LE32_TO_CPU( *(PULONG)pTxD	); //tt_lin_big

		// Check for the descriptor	ownership
		if ((TxD.Owner == DESC_OWN_NIC)	|| (TxD.Valid == FALSE)) //w0
		{
			break;
		}
		
		// No need to put in reply for MLME
		RTMPHardTransmitDone(
			pAdapter, 
			pTxD, 
			&pHeader->Controlhead.Addr1,
			pAdapter->PrioRing[pAdapter->NextPrioDoneIndex].FrameType);
		
		// It might	happend	with no	Ndis packet	to indicate	back to	upper layer
		*(PULONG)&TxD =	RTMP_LE32_TO_CPU( *(PULONG)pTxD	); //tt_lin_big
		TxD.Valid =	FALSE;//w0		  
		*(PULONG)pTxD =	RTMP_CPU_TO_LE32( *(PULONG)&TxD	); //tt_lin_big

		// Increase	Total transmit byte	counter	after real data	sent out
		pAdapter->RalinkCounters.TransmittedByteCount +=  TxD.DataByteCnt;//w0

		pAdapter->NextPrioDoneIndex++;
		if (pAdapter->NextPrioDoneIndex	>= PRIO_RING_SIZE)
		{
			pAdapter->NextPrioDoneIndex	= 0;
		}
	}	while (++Count < MAX_TX_PROCESS);

	// Make	sure to	release	Prio ring resource
	NdisReleaseSpinLock(&pAdapter->PrioRingLock);	
	
	if (RTMP_TEST_FLAG(pAdapter, fRTMP_ADAPTER_RADIO_OFF))
		return;
	
	if (pAdapter->PushMgmtIndex	!= pAdapter->PopMgmtIndex)
	{
		if (RTMPFreeDescriptorRequest(pAdapter,	PRIO_RING, 1) == NDIS_STATUS_SUCCESS)
		{
			pMgmt =	(PMGMT_STRUC) &pAdapter->MgmtRing[pAdapter->PopMgmtIndex];
			if (pMgmt->Valid ==	TRUE)
			{
				MlmeHardTransmit(pAdapter, pMgmt->pBuffer, pMgmt->Length);
				MlmeConfirm((PVOID)pAdapter, pMgmt->pBuffer, 0);
				pMgmt->Valid = FALSE;
				pAdapter->PopMgmtIndex++;
				pAdapter->MgmtQueueSize--;
				if (pAdapter->PopMgmtIndex >= MGMT_RING_SIZE)
				{
					pAdapter->PopMgmtIndex = 0;
				}
			}
		}
	}	
}


/*
	========================================================================

	Routine	Description:
		Process	Rx ring	DecryptionDone interrupt, running in DPC level

	Arguments:
		Adapter		Pointer	to our adapter

	Return Value:
		None

	Note:

	========================================================================
*/
VOID	RTMPHandleDecryptionDoneInterrupt(
	IN	PRTMP_ADAPTER	pAdapter)
{
	PRXD_STRUC		pRxD;
	RXD_STRUC		RxD;  //tt_lin_big

	PHEADER_802_11	pHeader;
	HEADER_802_11	Header;	//tt_lin_big
	
	UINT			PacketSize;
	PVOID			pManage;
	UCHAR			Header802_3[14];
	UCHAR			LLC_Len[2];
//	  ULONG			  High32TSF, Low32TSF;
	UCHAR			Count;
//	  UCHAR			  RxTsc[6];
	ULONG			RegValue;
	ULONG			HwDecryptIndex;
	PUCHAR			pDestMac, pSrcMac;
	PUCHAR			pData;
	PUCHAR			pEncap;
	NDIS_STATUS		Status;
	PWPA_KEY		pWpaKey	= (PWPA_KEY) NULL;
	MAC_TABLE_ENTRY	*pEntry;
	NDIS_802_11_PRIVACY_FILTER	 Privacy;
	WPA_STATE		WpaState;
	struct sk_buff	*skb;
	struct net_device	*net_dev = pAdapter->net_dev;
#ifdef WDS
	ULONG			i;
	BOOLEAN			bWdsPacket;
#endif

	// Make	sure Rx	ring resource won't	be used	by other threads
	NdisAcquireSpinLock(&pAdapter->RxRingLock);
	
	RTMP_IO_READ32(pAdapter, SECCSR0, &RegValue);
	HwDecryptIndex = (RegValue - pAdapter->RxRing[0].pa_addr) /	RING_DESCRIPTOR_SIZE;

	Count =	0;
	//do
	while (pAdapter->CurDecryptIndex !=	HwDecryptIndex)
	{
		// Point to	Rx indexed rx ring descriptor
		pRxD = (PRXD_STRUC)	pAdapter->RxRing[pAdapter->CurDecryptIndex].va_addr;
		
		*(PULONG)&RxD =	 RTMP_LE32_TO_CPU( *(PULONG)pRxD );	//tt_lin_big
		*(((PULONG)&RxD)+10) = RTMP_LE32_TO_CPU( *(((PULONG)pRxD)+10) ); //tt_lin_big

		// In case of false	alarm or processed at last instance
		if (RxD.Owner != DESC_OWN_HOST)	//w0
		{
			break;
		}
			
		if (RxD.CipherOwner	!= DESC_OWN_HOST) //w0
		{
			break;
		}
	
		// Point to	Rx ring	buffer where stores	the	real data frame
		pData	= (PUCHAR) (pAdapter->RxRing[pAdapter->CurDecryptIndex].va_data_addr);
		// Cast	to 802.11 header for flags checking
		pHeader	= (PHEADER_802_11) pData;
		*(PUSHORT)&Header =	 RTMP_LE16_TO_CPU( *(PUSHORT)pHeader );	//tt_lin_big (s0)
		*(((PUSHORT)&Header)+1)	=  RTMP_LE16_TO_CPU( *(((PUSHORT)pHeader)+1) );//tt_lin_big	(s1)
		*(((PUSHORT)&Header)+11) = RTMP_LE16_TO_CPU( *(((PUSHORT)pHeader)+11) );//tt_lin_big (s11)
		
		// Patch for ASIC: There are some occasions	ASIC will false	turned on this bit
		// Driver will check the decrypt algorithm and decide whether this ICV is true or not		
		if ((RxD.IcvError == 1)	&& (RxD.CipherAlg == CIPHER_NONE)) //w0
				RxD.IcvError = 0; //w0
		
		// Since we	already	process	header at RxDone interrupt,	there is no	need to	proces
		// header sanity again,	the	only thing we have to check	is icv_err bit
		if (RxD.IcvError == 1) //w0
		{
			DBGPRINT(RT_DEBUG_TTL/*TRACE*/,"DecryptDone	- ICV error\n");
			RxD.Drop =1;   /*w10*/		 //	Drop frame with	icv	error  w10
		}
			
		// Saved data pointer for management frame which will pass to MLME block
		pManage	= (PVOID) pData;

		// pData : Pointer skip	the	first 24 bytes,	802.11 HEADER
		pData += LENGTH_802_11;

#ifdef	WDS
		bWdsPacket = FALSE;
		if ((RxD.Drop == 0)	&&	//w10
			(Header.Controlhead.Frame.FrDs == 1) &&	//s0 
			(Header.Controlhead.Frame.ToDs == 1))//s0
		{
			for	(i = 0;	i <	pAdapter->WdsTab.Num; i++)
			{
				if (MAC_ADDR_EQUAL(&pAdapter->WdsTab.WdsEntry[i].WdsAddr, &pHeader->Controlhead.Addr2))
				{
					net_dev	= pAdapter->WdsTab.WdsEntry[i].dev;
					bWdsPacket = TRUE;
					pData += ETH_LENGTH_OF_ADDRESS;	// offset the addr4
					DBGPRINT(RT_DEBUG_WDS/*INFO*/,	"WDS packet	from (%d)!!!\n", i);
					break;
				}
			}
			if (i == pAdapter->WdsTab.Num)
			{
				DBGPRINT(RT_DEBUG_ERROR, "WDS packet, but not our WDS group!!!\n");
				RxD.Drop = 1; //w10
			}
		}
#endif

		//
		// Start of	main loop to parse receiving frames.
		// The sequence	will be	Type first,	then subtype...
		//
		if (RxD.Drop ==	0)//w10
		{

	// The total available payload should exclude 24-byte 802.11 Header
			// If Security is enabled, IV, EIV,	ICV	size is	excluded by	ASIC
#ifdef	WDS
			if (bWdsPacket)
			{
				PacketSize = RxD.DataByteCnt - LENGTH_802_11_WITH_ADDR4; //w0
			}
			else
#endif
			{
				PacketSize = RxD.DataByteCnt - LENGTH_802_11; //w0
			}

			// Find	the	WPA	key, either	Group or Pairwise Key
			// Although	the	data has been decrypted	by ASIC,
			// driver has to calculate the RxMIC which required	the	key.
			// The failed case should not happen. If it	did, drop it.

			// port	access control
			pEntry=PACInquiry(pAdapter,	&pHeader->Controlhead.Addr2, &Privacy, &WpaState);

			if (pAdapter->PortCfg.WepStatus	>= Ndis802_11Encryption2Enabled)
			{
//				INT		idx;				
				pWpaKey	= (PWPA_KEY) NULL;
			
#ifdef	WDS
				if (bWdsPacket)
				{
					Privacy	= Ndis802_11PrivFilterAcceptAll;
					pWpaKey	= (PWPA_KEY) &pAdapter->WdsTab.Wpa_key;
				}
				else
#endif
				{
					if (pHeader->Controlhead.Addr1.Octet[0]	&0x01)
					{
						if (pAdapter->PortCfg.GroupKey[pAdapter->PortCfg.WPAGKeyID].KeyLen != 0)
						{
							pWpaKey	= (PWPA_KEY) &pAdapter->PortCfg.GroupKey[pAdapter->PortCfg.WPAGKeyID];
						}
					}
					// Try to find the Pairwise	Key
					else
					{
						if (pEntry && (pEntry->PairwiseKey[0].KeyLen !=	0))
						{
							pWpaKey	= (PWPA_KEY) &pEntry->PairwiseKey[0];
						}
						// Use default Group Key if	there is no	Pairwise key present
						if ((pWpaKey ==	NULL) && (pAdapter->PortCfg.GroupKey[pAdapter->PortCfg.WPAGKeyID].KeyLen	!= 0))
						{
							pWpaKey	= (PWPA_KEY) &pAdapter->PortCfg.GroupKey[pAdapter->PortCfg.WPAGKeyID];				
							DBGPRINT(RT_DEBUG_INFO,	"Rx	Use	Group Key\n");
						}
					}
				}
			}

			switch (Header.Controlhead.Frame.Type)//s0
			{
				// Frame with data type
				case BTYPE_DATA:	
					if(pAdapter->PortCfg.BANClass3Data==TRUE)
						break;
#ifdef	WDS
					// WDS packet's	DA & SA	is not the same
					if (bWdsPacket)
					{
						pDestMac = (PUCHAR)	&(pHeader->Addr3);
						pSrcMac	= (PUCHAR)pHeader +	sizeof(HEADER_802_11);
					}
					else
#endif
					{
						pDestMac = (PUCHAR)	&(pHeader->Addr3);
						pSrcMac	= (PUCHAR) &(pHeader->Controlhead.Addr2);
					}

					switch(Privacy)
					{
						case Ndis802_11PrivFilter8021xWEP:
							if (pEntry == NULL)   // this should not happen
								break;
							if (!RTMPCheckWPAframe(pAdapter, (UCHAR	*)pHeader, RxD.DataByteCnt)) //w0
								break;
							
							if ((pEntry->Flag&DISASSOC_4_WAY_TMOUT)	&& (pAdapter->PortCfg.AuthMode	>= Ndis802_11AuthModeWPA))
							{
								DBGPRINT(RT_DEBUG_TTL/*TRACE*/,	"	HandleRx  :	  GO to	 DisAssocAction	: REASON_4_WAY_TIMEOUT \n");
								if (pEntry->Flag&DIS_REASON_RSNIE_DIFF)
									DisAssocAction(	pAdapter, pEntry,SUBTYPE_DISASSOC, REASON_IE_DIFFERENT);
								else
									DisAssocAction(	pAdapter, pEntry, SUBTYPE_DISASSOC, REASON_4_WAY_TIMEOUT);
								break;
							}
							if ((pEntry->WpaState < AS_INITPMK) && (pAdapter->PortCfg.AuthMode == Ndis802_11AuthModeWPA))
							{
								NdisMoveMemory(LLC_Len, EAPOL, 2);
								MAKE_802_3_HEADER(Header802_3, pDestMac, pSrcMac, ((PUCHAR) LLC_Len));
								DBGPRINT(DEBUG_TEMP, "   pData %x %x %x %x %x \n",*pData,*(pData+1),*(pData+2),*(pData+3),*(pData+4));
								if ((skb = dev_alloc_skb(PacketSize + LENGTH_802_3 + 2)) != NULL) {                                
										skb->dev = net_dev;
										skb_reserve(skb, 2);	// 16 byte align the IP header
										memcpy(skb_put(skb, LENGTH_802_3), Header802_3, LENGTH_802_3);
										memcpy(skb_put(skb, PacketSize), pData, PacketSize);
										skb->protocol = eth_type_trans(skb, net_dev);
										netif_rx(skb);
										net_dev->last_rx = jiffies;
										pAdapter->stats.rx_packets++;
								}
							}
							else
							{	MlmeEnqueueForRecv(
									pAdapter,
									&pAdapter->Mlme.Queue,	
									(UCHAR)pRxD->BBR1, 
									RxD.DataByteCnt,  //w0
									pManage);
							}	
							break;
							
						case Ndis802_11PrivFilterAcceptAll:
				
							if ((pEntry) &&	(pEntry->Flag&DISASSOC_GRP_UDATE_TMOUT)	&& (pAdapter->PortCfg.AuthMode	>= Ndis802_11AuthModeWPA))
							{		  
								DBGPRINT(RT_DEBUG_TTL/*TRACE*/,	"	HandleRx  :	  GO to	 DisAssocAction	: REASON_GROUP_KEY_UPDATE_TIMEOUT\n");
								DisAssocAction(pAdapter, pEntry, SUBTYPE_DISASSOC, REASON_GROUP_KEY_UPDATE_TIMEOUT);
							}
						
							if (Header.Frag	== 0)	  // First or Only fragment	(s11)
							{
								// For TKIP	frame, calculate the MIC value
								if (Header.Controlhead.Frame.MoreFrag == FALSE)	//s0
								{
									if (RxD.CipherAlg == CIPHER_TKIP) //w0
									{
										// Minus MIC length
										PacketSize -= 8;
										if (RTMPTkipCompareMICValue(pAdapter, pData, pDestMac, pSrcMac, pWpaKey->RxMic,	PacketSize)	== FALSE)
										{
											DBGPRINT(RT_DEBUG_ERROR,"Rx	MIC	Value error\n");						  
											Status = NDIS_STATUS_FAILURE;
											break;
										} 
											//	TODO:  Getting RxTSC from Rx descriptor
									}				
								}								 
								// Save	encapaturation starting	pointer
								pEncap = pData;								
								pAdapter->FragFrame.Flags &= 0xFFFFFFFE;								
								// Check for encapsulataion	other than RFC1042 & Bridge	tunnel
								if ((!RTMPEqualMemory(SNAP_802_1H, pEncap, 6)) && (!RTMPEqualMemory(SNAP_BRIDGE_TUNNEL, pEncap, 6)))
								{
									LLC_Len[0] = PacketSize	/ 256;
									LLC_Len[1] = PacketSize	% 256;
									MAKE_802_3_HEADER(Header802_3, pDestMac, pSrcMac, ((PUCHAR)	LLC_Len));
								}
								else
								{
									// Remove 802.11 H header &	reconstruct	802.3 header
									pData += (LENGTH_802_1_H - LENGTH_802_3_TYPE);
									if (RTMPEqualMemory(EAPOL, pData, 2)) 
									{
										//DBGPRINT(RT_DEBUG_TTL, "Drop frame for 802.1x,Remove 802.11 H	& recon	802.3 header\n");										 
										PacketSize+=LENGTH_802_11;
										if(pEntry )
											MlmeEnqueueForRecv(pAdapter, 
																&pAdapter->Mlme.Queue, 
																(UCHAR)pRxD->BBR1, //CHAR->UCHAR
																PacketSize,	 
																pManage);										
									}
									// Patch for WHQl only,	which did not turn on Netbios but use IPX within its payload
									if ((RTMPEqualMemory(IPX, pData, 2)	|| RTMPEqualMemory(APPLE_TALK, pData, 2)) && RTMPEqualMemory(SNAP_802_1H, pEncap, 6))
									{
										LLC_Len[0] = PacketSize	/ 256;
										LLC_Len[1] = PacketSize	% 256;
										pData =	pData -	LENGTH_802_1_H;
										MAKE_802_3_HEADER(Header802_3, pDestMac, pSrcMac, ((PUCHAR)	LLC_Len));
									}
									else
									{
										MAKE_802_3_HEADER(Header802_3, pDestMac, pSrcMac, pData);
										// The total available payload should exclude 24-byte 802.11 Header
										// and 8-byte 802.2	LLC
										PacketSize -= LENGTH_802_1_H;
										NdisMoveMemory(pAdapter->FragFrame.Header_LLC, pEncap, 8); //MACADDR(6), (2) //`N
										pAdapter->FragFrame.Flags |= 0x01;
									}								 
									// Point to	read 802.3 payload
									pData += LENGTH_802_3_TYPE;
								}									 
								// One & The only fragment
								if (Header.Controlhead.Frame.MoreFrag == FALSE)//s0
								{
									DBGPRINT(RT_DEBUG_INFO,	"Data-ForFrag==FALSE\n"	);
									// For miniportTransferData
									pAdapter->pRxData =	pData;	 //`N								 
									pAdapter->PortCfg.LedCntl.fRxActivity =	TRUE; // for RX	ACTIVITY LED						
									// check if	DA is another associted	WSTA reachable via wireless	bridging,
									// if it is, then no need to indicate to LLC
									if (RTMPBridgeToWirelessSta(pAdapter, Header802_3, LENGTH_802_3, pData,	PacketSize))
										break;
					
									// Acknolwdge upper	layer the received frame
									if ((skb = dev_alloc_skb(PacketSize	+ LENGTH_802_3 + 2)) !=	NULL) 
									{
										skb->dev = net_dev;
										skb_reserve(skb, 2);	// 16 byte align the IP	header
										memcpy(skb_put(skb,	LENGTH_802_3), Header802_3,	LENGTH_802_3);
										memcpy(skb_put(skb,	PacketSize), pData,	PacketSize);
										skb->protocol =	eth_type_trans(skb,	net_dev);
										netif_rx(skb);
										net_dev->last_rx = jiffies;
										pAdapter->stats.rx_packets++;
									}
									NdisZeroMemory(Header802_3,	LENGTH_802_3);									  
								}
								// First fragment of fragmented	frames
								else
								{
									NdisMoveMemory(pAdapter->FragFrame.Buffer,	pData, PacketSize);
									NdisMoveMemory(pAdapter->FragFrame.Header802_3,	Header802_3, LENGTH_802_3);
									NdisZeroMemory(Header802_3,	LENGTH_802_3);
									pAdapter->FragFrame.RxSize	 = PacketSize;
									pAdapter->FragFrame.Sequence = Header.Sequence;	  //s11
									pAdapter->FragFrame.LastFrag = Header.Frag;		  //s11
								}
							}
							// Middle &	End	of fragment	burst fragments
							else
							{
								// No LLC-SNAP header in except	the	first fragment frame								
								if ((Header.Sequence !=	pAdapter->FragFrame.Sequence) ||  //s11
									(Header.Frag !=	(pAdapter->FragFrame.LastFrag +	1)))  //s11
								{
									// Fragment	is not the same	sequence or	out	of fragment	number order
									// Clear Fragment frame	contents
									NdisZeroMemory(&pAdapter->FragFrame, sizeof(FRAGMENT_FRAME));
									Status = NDIS_STATUS_FAILURE;
									break;
								}	
								else if	((pAdapter->FragFrame.RxSize + PacketSize) > MAX_FRAME_SIZE)
								{
									// Fragment	frame is too large,	it exeeds the maximum frame	size.
									// We have to drop it.
									// Clear Fragment frame	contents
									NdisZeroMemory(&pAdapter->FragFrame, sizeof(FRAGMENT_FRAME));
									Status = NDIS_STATUS_FAILURE;
									break;
								}
								NdisMoveMemory(&pAdapter->FragFrame.Buffer[pAdapter->FragFrame.RxSize],	pData, PacketSize);
								pAdapter->FragFrame.RxSize	+= PacketSize;
								pAdapter->FragFrame.LastFrag = Header.Frag;	 //s11	   // Update fragment number
									
								// Last	fragment
								if (Header.Controlhead.Frame.MoreFrag == FALSE)	//s0
								{
									DBGPRINT(RT_DEBUG_INFO," Data-MoreFrag==FALSE\n");
									// For miniportTransferData
									pAdapter->pRxData =	pAdapter->FragFrame.Buffer;
								
									pAdapter->PortCfg.LedCntl.fRxActivity =	TRUE; // for RX	ACTIVITY LED
						
									// For TKIP	frame, calculate the MIC value
									if (RxD.CipherAlg == CIPHER_TKIP) //w0
									{
										// Minus MIC length
										pAdapter->FragFrame.RxSize -= 8;
										
										if (pAdapter->FragFrame.Flags &	0x00000001)
										{
											if (RTMPTkipCompareMICValueWithLLC(
												pAdapter,
												pAdapter->FragFrame.Header_LLC,
												pAdapter->FragFrame.Buffer,
												pDestMac,
												pSrcMac,
												pWpaKey->RxMic,
												pAdapter->FragFrame.RxSize)	== FALSE)
											{
												DBGPRINT(RT_DEBUG_ERROR,"Rx	MIC	Value error	2\n");							  
												Status = NDIS_STATUS_FAILURE;
												break;
											}
										}
										else
										{
											if (RTMPTkipCompareMICValue(
												pAdapter,
												pAdapter->FragFrame.Buffer,
												pDestMac,
												pSrcMac,
												pWpaKey->RxMic,
												pAdapter->FragFrame.RxSize)	== FALSE)
											{
												DBGPRINT(RT_DEBUG_ERROR,"Rx	MIC	Value error	2\n");							  
												Status = NDIS_STATUS_FAILURE;
												break;
											}
										}							 
											//	TODO:
											// Getting RxTSC from Rx descriptor
									}

									// check if	DA is another associted	WSTA reachable via wireless	bridging,
									// if it is, then no need to indicate to LLC
									if (RTMPBridgeToWirelessSta(pAdapter, pAdapter->FragFrame.Header802_3, LENGTH_802_3, pAdapter->FragFrame.Buffer, pAdapter->FragFrame.RxSize))
										break;
					
									// Acknolwdge upper	layer the received frame
									if ((skb = dev_alloc_skb(pAdapter->FragFrame.RxSize +	LENGTH_802_3 + 2)) != NULL)	{
										skb->dev = net_dev;
										skb_reserve(skb, 2);	// 16 byte align the IP	header
										memcpy(skb_put(skb,	LENGTH_802_3), pAdapter->FragFrame.Header802_3, LENGTH_802_3);
										memcpy(skb_put(skb,	pAdapter->FragFrame.RxSize), (PVOID)pAdapter->FragFrame.Buffer, pAdapter->FragFrame.RxSize);
										skb->protocol =	eth_type_trans(skb,	net_dev);
										netif_rx(skb);
										net_dev->last_rx = jiffies;
										pAdapter->stats.rx_packets++;
									}
									
									// Clear Fragment frame	contents
									NdisZeroMemory(&pAdapter->FragFrame, sizeof(FRAGMENT_FRAME));
									DBGPRINT(RT_DEBUG_INFO,	"!!! Frame with	Fragment Indicated !!!\n");
								}
							}
							break;
					}
					break;
				case BTYPE_MGMT:
					// Read	required regsiter for MLME engine
					// RTMP_IO_READ32(pAdapter,	CSR17, &High32TSF);		// TSF value
					// RTMP_IO_READ32(pAdapter,	CSR16, &Low32TSF);		// TSF vlaue
					if(pAdapter->PortCfg.BANClass3Data==TRUE)
					{
						// disallow	new	association	
						PMACFRAME	 pFr = (PMACFRAME)pManage;
						MACFRAME	 Fr	;

						*(PUSHORT)&Fr =	RTMP_LE16_TO_CPU( *(PUSHORT)pFr	);
						if ((Fr.Hdr.SubType	== SUBTYPE_ASSOC_REQ) ||(Fr.Hdr.SubType	== SUBTYPE_AUTH)) //s0
							break;
						DBGPRINT(RT_DEBUG_INFO,	"	Disallow new Assciation	\n");
					}
				
					// Enqueue this	frame to MLME engine
					MlmeEnqueueForRecv(
						pAdapter,
						&pAdapter->Mlme.Queue,	
						// High32TSF, 
						// Low32TSF,
						(UCHAR)pRxD->BBR1, 
						RxD.DataByteCnt, //w0
						pManage);					
					break;
		
				case BTYPE_CNTL:
					// handle PS-POLL here
					if ((RxD.U2M) && //w0 
						(Header.Controlhead.Frame.Subtype == SUBTYPE_PS_POLL)) //s0
					{	
						USHORT Aid = Header.Controlhead.Duration & 0x3fff; //s1
						PMACADDR pAddr = &pHeader->Controlhead.Addr2;
						
						DBGPRINT(RT_DEBUG_TRACE,"rcv PS-POLL (AID=%d) from %02x:%02x:%02x:%02x:%02x:%02x\n", 
							Aid, pAddr->Octet[0], pAddr->Octet[1], pAddr->Octet[2],	pAddr->Octet[3], pAddr->Octet[4], pAddr->Octet[5]);
						RTMPHandleRxPsPoll(pAdapter, pAddr,	Aid);
					}
					else
					{
						DBGPRINT(RT_DEBUG_TRACE,"ignore	CNTL (subtype=%d)\n", Header.Controlhead.Frame.Subtype); //s0
					}
					break;
	
				default	:
					break;
			}
		}
		pAdapter->CurDecryptIndex++;
		if (pAdapter->CurDecryptIndex >= RX_RING_SIZE)
		{
			pAdapter->CurDecryptIndex =	0;
		}
		Count++;
			
		pAdapter->RalinkCounters.DecryptCount ++;
			
		// Clear Cipherowner bit & Rx Owner	bit	for	all	drop & non-drop	frames
		RxD.CipherOwner	= DESC_OWN_HOST;//w0
		RxD.Owner		= DESC_OWN_NIC;	//w0
		
		*(PULONG)pRxD =	RTMP_CPU_TO_LE32( *(PULONG)&RxD	); //tt_lin_big
		*(((PULONG)pRxD)+10) = RTMP_CPU_TO_LE32( *(((PULONG)&RxD)+10) ); //tt_lin_big
	}
	//{} while (Count <	RX_RING_SIZE);
	//{} while (pAdapter->CurDecryptIndex != HwDecryptIndex);
		
	// Make	sure to	release	Rx ring	resource
	NdisReleaseSpinLock(&pAdapter->RxRingLock);
}

/*
	========================================================================

	Routine	Description:
		Process	Tx ring	EncryptionDone interrupt, running in DPC level

	Arguments:
		Adapter		Pointer	to our adapter

	Return Value:
		None

	Note:

	========================================================================
*/
VOID	RTMPHandleEncryptionDoneInterrupt(
	IN	PRTMP_ADAPTER	pAdapter)
{
	PTXD_STRUC		pTxD;
	TXD_STRUC		TxD; //tt_lin_big
	
	UCHAR			Count;
	ULONG			RegValue;
	ULONG			HwEncryptIndex;
	
	// Make	sure Prio ring resource	won't be used by other threads
	NdisAcquireSpinLock(&pAdapter->TxRingLock);	
	
	RTMP_IO_READ32(pAdapter, SECCSR1, &RegValue);
	HwEncryptIndex = (RegValue - pAdapter->TxRing[0].pa_addr) /	RING_DESCRIPTOR_SIZE;
	
	Count =	0;
	//do
	while (pAdapter->NextEncryptDoneIndex != HwEncryptIndex)
	{
		pTxD = (PTXD_STRUC)	(pAdapter->TxRing[pAdapter->NextEncryptDoneIndex].va_addr);

		*(PULONG)&TxD =	RTMP_LE32_TO_CPU( *(PULONG)pTxD	);//tt_lin_big
		*(((PULONG)&TxD)+2)	= RTMP_LE32_TO_CPU(	*(((PULONG)pTxD)+2)	);//tt_lin_big
		
		// Check for the descriptor	cipher ownership
		if ((TxD.CipherOwn == DESC_OWN_NIC)	|| (TxD.Owner == DESC_OWN_NIC))	//w0
		{
			pAdapter->RalinkCounters.TxRingErrCount++;
			break;
		}

#ifdef	WDS
		if (TxD.IvOffset ==	LENGTH_802_11_WITH_ADDR4)//w2
		{
			UCHAR	Iv_Tmp[4];
			PUCHAR	pTmp;
			//Bug for ACSII
			NdisMoveMemory(Iv_Tmp, &pTxD->Iv, 4); //w??
			pTmp		= (PUCHAR) &pTxD->Iv;  //w??
			*pTmp		= Iv_Tmp[3];
			*(pTmp + 1)	= Iv_Tmp[2];
			*(pTmp + 2)	= Iv_Tmp[1];
			*(pTmp + 3)	= Iv_Tmp[0];			

//#error  "add WDS	by tt_lin"			
		}
#endif

		if (TxD.CipherAlg == CIPHER_TKIP) //w0
		{
			UCHAR	Eiv_Tmp[4];
			PUCHAR	pTmp;

			NdisMoveMemory(Eiv_Tmp,	&pTxD->Eiv,	4);	
			pTmp		= (PUCHAR) &pTxD->Eiv;	  
			*pTmp		= Eiv_Tmp[3];
			*(pTmp + 1)	= Eiv_Tmp[2];
			*(pTmp + 2)	= Eiv_Tmp[1];
			*(pTmp + 3)	= Eiv_Tmp[0];
			DBGPRINT(RT_DEBUG_WARN,	"--TxD.CipherAlg ==	CIPHER_TKIP(ERROR)\n");
		}
		// Sanity Check, CurTxIndex	should equal to	NextEncryptDoneIndex
		// ASSERT(pAdapter->CurTxIndex == pAdapter->NextEncryptDoneIndex);
		
		TxD.Valid =	TRUE; //w0
		TxD.Owner =	DESC_OWN_NIC; //w0
		*(PULONG)pTxD =	RTMP_CPU_TO_LE32( *(PULONG)&TxD	); //tt_lin_big
		
		pAdapter->NextEncryptDoneIndex++;
		if (pAdapter->NextEncryptDoneIndex >= TX_RING_SIZE)
		{
			pAdapter->NextEncryptDoneIndex = 0;
		}
		pAdapter->CurTxIndex = pAdapter->NextEncryptDoneIndex;
		pAdapter->RalinkCounters.KickTxCount++;

		if (pAdapter->CurTxIndex ==	pAdapter->CurEncryptIndex)
			break;
	}
	//{} while (++Count	< MAX_TX_PROCESS);
	//{} while (pAdapter->NextEncryptDoneIndex != HwEncryptIndex);

	// Kick	Tx Control Register	at the end of all ring buffer preparation
	RTMP_IO_WRITE32(pAdapter, TXCSR0, 0x1);
	
	// Make	sure to	release	Tx ring	resource
	NdisReleaseSpinLock(&pAdapter->TxRingLock);	
}

/*
	========================================================================
	Routine	Description:
	Arguments:
		Adapter		Pointer	to our adapter
	========================================================================
*/
VOID	RTMPHandleTbcnInterrupt(IN PRTMP_ADAPTER pAdapter)
{
	UpdateBeaconFrame(pAdapter);
}

/*
	========================================================================
	Routine	Description:
		Process	all	transmit ring Tx Done interrupt, running	in DPC level

	Arguments:
		Adapter		Pointer	to our adapter
	========================================================================
*/
VOID	RTMPHardTransmitDone(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PTXD_STRUC		pTxD,
	IN	PMACADDR		pAddr,
	IN	UCHAR			FrameType)
{
	MAC_TABLE_ENTRY	 *pMacEntry;
	TXD_STRUC  TxD;
	
	//0,2,10
	*(PULONG)&TxD =	RTMP_LE32_TO_CPU( *(PULONG)pTxD	);	//w0
	*(((PULONG)&TxD)+2)	= RTMP_LE32_TO_CPU(	*(((PULONG)pTxD)+2)	);	//w2
	*(((PULONG)&TxD)+10) = RTMP_LE32_TO_CPU( *(((PULONG)pTxD)+10) ); //w10
	
	switch (TxD.TxResult) //w0
	{
		case SUCCESS_WITHOUT_RETRY:			// Success without any retry
			// Return send complete	status
//			DBGPRINT(RT_DEBUG_INFO,	("TX %02x:%02x:%02x:%02x:%02x:%02x Success without retry<<<\n",
//				pAddr->Octet[0],pAddr->Octet[1],pAddr->Octet[2],pAddr->Octet[3],pAddr->Octet[4],pAddr->Octet[5]));
			if (TxD.RTS)//w10
			{
				// Increase	802.11 counters
				INC_COUNTER(pAdapter->WlanCounters.RTSSuccessCount);
				TxD.RTS	= 0; //w10(write back)
			}
			
			// Increase	general	counters
			pAdapter->Counters.GoodTransmits++;
			INC_COUNTER(pAdapter->WlanCounters.TransmittedFragmentCount);

			// update DRS related counters
			if (TxD.ACK	&& (FrameType == BTYPE_DATA)) //w0
			{
				pMacEntry =	MacTableLookup(pAdapter, pAddr);
				if (pMacEntry)
					pMacEntry->OneSecTxOkCount ++;
#ifdef	WDS
				else
				{
					INT	i;

					for(i =	0; i < pAdapter->WdsTab.Num; i++)
					{
						if (MAC_ADDR_EQUAL(&pAdapter->WdsTab.WdsEntry[i].WdsAddr, pAddr))
						{
							pAdapter->WdsTab.WdsEntry[i].OneSecTxOkCount ++;
							break;
						}
					}
				}
#endif
			}
							
			break;
			  
		case SUCCESS_WITH_RETRY:			// Success with	some retry
			// Return send complete	status
			DBGPRINT(RT_DEBUG_INFO,	"TX	Success	with retry(=%d)<<<\n",TxD.RetryCount);//w0
			
			// Increase	802.11 counters
			INC_COUNTER(pAdapter->WlanCounters.RetryCount);
			INC_COUNTER(pAdapter->WlanCounters.ACKFailureCount);
			INC_COUNTER(pAdapter->WlanCounters.TransmittedFragmentCount);
			
			// Increase	general	counters
			pAdapter->Counters.GoodTransmits++;
			
			if (TxD.RetryCount > 1)	//w0
			{
				// Increase	802.11 counters
				INC_COUNTER(pAdapter->WlanCounters.MultipleRetryCount);
				
				// Increase	general	counters
				pAdapter->Counters.MoreCollisions++;
			}
			else
			{
				// Increase	general	counters
				pAdapter->Counters.OneCollision++;
			}
			
			if (TxD.RTS)//w10
			{
				INC_COUNTER(pAdapter->WlanCounters.RTSSuccessCount);
				TxD.RTS	= 0;//w10
			}

			// update DRS related counters
			if (TxD.ACK	&& (FrameType == BTYPE_DATA)) //w0
			{
				pMacEntry =	MacTableLookup(pAdapter, pAddr);
				if (pMacEntry)
				{
					if (TxD.TxRate > pMacEntry->CurrTxRate)//w10
					{
						// must	be NULL	frame retried @	UpRate;	downgrade TxQuality[UpRate]
						// so that rate	upgrade	won't happen
						pMacEntry->TxQuality[TxD.TxRate] +=	3;	//w10
						if (pMacEntry->TxQuality[TxD.TxRate] > DRS_TX_QUALITY_WORST_BOUND) //w10
							pMacEntry->TxQuality[TxD.TxRate] = DRS_TX_QUALITY_WORST_BOUND; //w10
					}
					else if	(TxD.TxRate	== pMacEntry->CurrTxRate)//w10
						pMacEntry->OneSecTxRetryOkCount	++;
				}
#ifdef	WDS
				else
				{
					INT	i;

					for(i =	0; i < pAdapter->WdsTab.Num; i++)
					{
						if (MAC_ADDR_EQUAL(&pAdapter->WdsTab.WdsEntry[i].WdsAddr, pAddr))
						{
							if (TxD.TxRate > pAdapter->WdsTab.WdsEntry[i].CurrTxRate)//w10
							{
								// must	be NULL	frame retried @	UpRate;	downgrade TxQuality[UpRate]
								// so that rate	upgrade	won't happen
										pAdapter->WdsTab.WdsEntry[i].TxQuality[TxD.TxRate] += 3;
								if (pAdapter->WdsTab.WdsEntry[i].TxQuality[TxD.TxRate] > DRS_TX_QUALITY_WORST_BOUND) //w10
									pAdapter->WdsTab.WdsEntry[i].TxQuality[TxD.TxRate] = DRS_TX_QUALITY_WORST_BOUND; //w10
							}
							else
								pAdapter->WdsTab.WdsEntry[i].OneSecTxRetryOkCount ++;
							break;
						}
					}
				}
#endif
			}
							
			break;

		case FAIL_RETRY_LIMIT:				// Fail	on hitting retry count limit
			DBGPRINT(RT_DEBUG_TRACE, "TX %02x:%02x:%02x:%02x:%02x:%02x @ %d	Mbps Failed(RETRY LIMIT)<<<\n",
				pAddr->Octet[0],pAddr->Octet[1],pAddr->Octet[2],pAddr->Octet[3],
				pAddr->Octet[4],pAddr->Octet[5], RateIdToMbps[TxD.TxRate]);	//w10

			// Increase	802.11 counters
			INC_COUNTER(pAdapter->WlanCounters.FailedCount);
			INC_COUNTER(pAdapter->WlanCounters.ACKFailureCount);
			
			// Increase	general	counters
			pAdapter->Counters.TxErrors++;
			
			if (TxD.RTS)//w10
			{
				INC_COUNTER(pAdapter->WlanCounters.RTSFailureCount);
				TxD.RTS	= 0; //w10(write back)
			}

			// update DRS related counters
			if (TxD.ACK	&& (FrameType == BTYPE_DATA))//w0
			{
				pMacEntry =	MacTableLookup(pAdapter, pAddr);
				if (pMacEntry)
				{
					if (TxD.TxRate > pMacEntry->CurrTxRate)//w10
					{
						// must	be NULL	frame retried @	UpRate;	downgrade TxQuality[UpRate]
						// so that rate	upgrade	won't happen
						pMacEntry->TxQuality[TxD.TxRate] +=	4; //w10
						if (pMacEntry->TxQuality[TxD.TxRate] > DRS_TX_QUALITY_WORST_BOUND) //w10
							pMacEntry->TxQuality[TxD.TxRate] = DRS_TX_QUALITY_WORST_BOUND; //w10
					}
					else if	(TxD.TxRate	== pMacEntry->CurrTxRate) //w10
						pMacEntry->OneSecTxFailCount ++;
				}
#ifdef	WDS
				else
				{
					INT	i;

					for(i =	0; i < pAdapter->WdsTab.Num; i++)
					{
						if (MAC_ADDR_EQUAL(&pAdapter->WdsTab.WdsEntry[i].WdsAddr, pAddr))
						{
							if (TxD.TxRate > pAdapter->WdsTab.WdsEntry[i].CurrTxRate)//w10
							{
								// must	be NULL	frame retried @	UpRate;	downgrade TxQuality[UpRate]
								// so that rate	upgrade	won't happen
										pAdapter->WdsTab.WdsEntry[i].TxQuality[TxD.TxRate] += 4; //w10
								if (pAdapter->WdsTab.WdsEntry[i].TxQuality[TxD.TxRate] > DRS_TX_QUALITY_WORST_BOUND) //w10
									pAdapter->WdsTab.WdsEntry[i].TxQuality[TxD.TxRate] = DRS_TX_QUALITY_WORST_BOUND; //w10
							}
							else
								pAdapter->WdsTab.WdsEntry[i].OneSecTxFailCount ++;
								break;
						}
					}
				}
#endif
			}
							
			break;
			
		case FAIL_INVALID:
		  DBGPRINT(RT_DEBUG_WARN, "TX Failed (INVALID)<<<\n");
			
			// Increase	general	counters
			pAdapter->Counters.TxErrors++;
			
			if (TxD.RTS)//w10
			{
				INC_COUNTER(pAdapter->WlanCounters.RTSFailureCount);
				TxD.RTS	= 0;//w10(write	back)
			}
			break;			
			
		case FAIL_OTHER:
		default:
		  DBGPRINT(RT_DEBUG_ERROR, "TX Failed (other=%d)<<<\n",TxD.TxResult); //
			
			// Increase	802.11 counters
			INC_COUNTER(pAdapter->WlanCounters.FailedCount);
			INC_COUNTER(pAdapter->WlanCounters.ACKFailureCount);
			
			// Increase	general	counters
			pAdapter->Counters.TxErrors++;
			
			if (TxD.RTS)//w10
			{
				INC_COUNTER(pAdapter->WlanCounters.RTSFailureCount);
				TxD.RTS	= 0;//w10(write	back)
			}
			break;			
	}

		//write	back 0,2,10
	*(PULONG)pTxD =	RTMP_CPU_TO_LE32( *(PULONG)&TxD	);
	*(((PULONG)pTxD)+2)	= RTMP_CPU_TO_LE32(	*(((PULONG)&TxD)+2)	);
	*(((PULONG)pTxD)+10) = RTMP_CPU_TO_LE32( *(((PULONG)&TxD)+10) );

}

/*
	========================================================================
	Routine	Description:
		API	for	MLME to	transmit management	frame to AP	(BSS Mode)
	or station (IBSS Mode)
	
	Arguments:
		pAdapter	Pointer	to our adapter
		Buffer		Pointer	to	memory of outgoing frame
		Length		Size of	outgoing management	frame
		
	Return Value:
		NDIS_STATUS_FAILURE
		NDIS_STATUS_PENDING
		NDIS_STATUS_SUCCESS
	========================================================================
*/
NDIS_STATUS	MiniportMMRequest(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PVOID			pBuffer,
	IN	ULONG			Length)
{
	PMGMT_STRUC		pMgmt;
	NDIS_STATUS		Status = NDIS_STATUS_SUCCESS;	 

	DBGPRINT(RT_DEBUG_INFO,	"---> MiniportMMRequest\n");
	// Check management	ring free avaliability
	pMgmt =	(PMGMT_STRUC) &pAdapter->MgmtRing[pAdapter->PushMgmtIndex];
	
	// This	management cell	has	been occupied
	if (pMgmt->Valid ==	TRUE)	
	{
		// No Management ring buffer avaliable
		if (pBuffer)
		{
			MlmeConfirm((PVOID)pAdapter, pBuffer, 0);
		}
		Status = NDIS_STATUS_FAILURE; 
		DBGPRINT(RT_DEBUG_WARN,	"<--- MiniportMMRequest	(error:: MgmtRing full)\n");
		pAdapter->RalinkCounters.MgmtRingFullCount++;
		return (Status);
	}
	
	// Insert this request into	software managemnet	ring
	if (pBuffer)
	{
		pMgmt->pBuffer = pBuffer;		
		pMgmt->Length  = Length;
		pMgmt->Valid   = TRUE;
		pAdapter->PushMgmtIndex++;
		pAdapter->MgmtQueueSize++;
		if (pAdapter->PushMgmtIndex	>= MGMT_RING_SIZE)
		{
			pAdapter->PushMgmtIndex	= 0;
		}
	}	
	else
	{
		// Null	pBuffer, no	need to	free memory	buffer.
		// This	should not happen
		DBGPRINT(RT_DEBUG_WARN,	"<--- MiniportMMRequest	(error:: NULL msg)\n");
		Status = NDIS_STATUS_FAILURE; 
		return (Status);
	}
	
	// Check Free priority queue
	if (RTMPFreeDescriptorRequest(pAdapter,	PRIO_RING, 1) == NDIS_STATUS_SUCCESS)
	{
		pMgmt =	(PMGMT_STRUC) &pAdapter->MgmtRing[pAdapter->PopMgmtIndex];
		if (pMgmt->Valid ==	TRUE)
		{
			MlmeHardTransmit(pAdapter, pMgmt->pBuffer, pMgmt->Length);
			MlmeConfirm((PVOID)pAdapter, pMgmt->pBuffer, 0);
			pMgmt->Valid = FALSE;
			pAdapter->PopMgmtIndex++;
			pAdapter->MgmtQueueSize--;
			if (pAdapter->PopMgmtIndex >= MGMT_RING_SIZE)
			{
				pAdapter->PopMgmtIndex = 0;
			}
		}
	}
	else
	{
		DBGPRINT(RT_DEBUG_INFO,	"not enough	space in PrioRing\n");
	}

	DBGPRINT(RT_DEBUG_INFO,	"<--- MiniportMMRequest\n");
	return (Status);
}

/*
	========================================================================
	Routine	Description:
		Copy frame from	waiting	queue into relative	ring buffer	and	set	
	appropriate	ASIC register to kick hardware transmit	function
	
	Arguments:
		pAdapter	Pointer	to our adapter
		pBuffer		Pointer	to	memory of outgoing frame
		Length		Size of	outgoing management	frame
	========================================================================
*/
VOID	MlmeHardTransmit(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PVOID			pBuffer,
	IN	ULONG			Length)
{
	PTXD_STRUC		pTxD;
	
	TXD_STRUC		TxD; //tt_lin_big

	PUCHAR			pDest;	
	PHEADER_802_11	pHeader_802_11;
	HEADER_802_11	Header_802_11; //tt_lin_big

	BOOLEAN			AckRequired, InsertTimestamp;
	
	DBGPRINT(RT_DEBUG_INFO,	"-->MlmeHardTransmit\n");
	
	// Make	sure Prio ring resource	won't be used by other threads
	NdisAcquireSpinLock(&pAdapter->PrioRingLock);
	
	//Clear	Memory (tt_lin for CRC error)
	//NdisZeroMemory(Header_802_11,	sizeof(HEADER_802_11) );
	
	pDest =	(PUCHAR) pAdapter->PrioRing[pAdapter->CurPrioIndex].va_data_addr;			   
	pTxD  =	(PTXD_STRUC) pAdapter->PrioRing[pAdapter->CurPrioIndex].va_addr;
	
	*(PULONG)&TxD =	RTMP_LE32_TO_CPU( *(PULONG)pTxD	);	  
	
	if (TxD.Owner == DESC_OWN_NIC) //w0
	{
		// Descriptor owned	by NIC.	No descriptor avaliable
		// This	should not happen since	caller guaranteed.
		// Make	sure to	release	Prio ring resource
		NdisReleaseSpinLock(&pAdapter->PrioRingLock);
		return;
	}
	if (TxD.Valid == TRUE) //w0
	{
		// Ndis	packet of last round did not cleared.
		// This	should not happen since	caller guaranteed.
		// Make	sure to	release	Prio ring resource
		NdisReleaseSpinLock(&pAdapter->PrioRingLock);
		return;
	}
	
	pHeader_802_11			 = (PHEADER_802_11)	pBuffer;
	*(PUSHORT)&Header_802_11 = RTMP_LE16_TO_CPU( *(PUSHORT)pHeader_802_11 ); //tt_lin_big
	*(((PUSHORT)&Header_802_11)+1) = RTMP_LE16_TO_CPU( *(((PUSHORT)pHeader_802_11)+1) ); //tt_lin_big
	*(((PUSHORT)&Header_802_11)+11)	= RTMP_LE16_TO_CPU(	*(((PUSHORT)pHeader_802_11)+11)	); //tt_lin_big
	
	InsertTimestamp	= FALSE;
	if (Header_802_11.Controlhead.Frame.Type ==	BTYPE_CNTL)	// must	be PS-POLL	(s0)
	{
		AckRequired	= FALSE;
		pAdapter->PrioRing[pAdapter->CurPrioIndex].FrameType = BTYPE_CNTL;
	}
	else //	BTYPE_MGMT or BMGMT_DATA(must be NULL frame)
	{
		pAdapter->PrioRing[pAdapter->CurPrioIndex].FrameType = BTYPE_MGMT;
		pAdapter->Sequence		 = ((pAdapter->Sequence) + 1) &	(MAX_SEQ_NUMBER);
		Header_802_11.Sequence = pAdapter->Sequence;//s11 (write-back)

		if (pHeader_802_11->Controlhead.Addr1.Octet[0] & 0x01) // MULTICAST, BROADCAST
		{
			AckRequired	= FALSE;
			Header_802_11.Controlhead.Duration = 0;//s1	  (write back)
		}
		else
		{
			AckRequired	= TRUE;
			Header_802_11.Controlhead.Duration = RTMPCalcDuration(pAdapter,	RATE_2,	14);//s1 (write-back)
			if (Header_802_11.Controlhead.Frame.Subtype	== SUBTYPE_PROBE_RSP)//s0
			{
				InsertTimestamp	= TRUE;
			}
		}
	}
	//big-endian write back
	*(((PUSHORT)pHeader_802_11)+1) = RTMP_CPU_TO_LE16( *(((PUSHORT)&Header_802_11)+1) ); //tt_lin_big
	*(((PUSHORT)pHeader_802_11)+11)= RTMP_CPU_TO_LE16( *(((PUSHORT)&Header_802_11)+11) ); //tt_lin_big

	NdisMoveMemory(pDest, pBuffer, Length);
   
	// Initialize Priority Descriptor
	// For inter-frame gap,	the	number is for this frame and next frame
	// For MLME	rate, we will fix as 2Mb to	match other	vendor's implement
	RTMPWriteTxDescriptor(pTxD,	
						FALSE, 
						CIPHER_NONE, 
						AckRequired, 
						FALSE, 
						InsertTimestamp, 
						SHORT_RETRY, 
						IFS_BACKOFF, 
						pAdapter->PortCfg.MlmeRate,	
						4, 
						Length,	
						pAdapter->PortCfg.TxPreamble, 
						0);

	// Increase	& maintain Tx Ring Index
	pAdapter->CurPrioIndex++;
	if (pAdapter->CurPrioIndex >= PRIO_RING_SIZE)
	{
		pAdapter->CurPrioIndex = 0;
	}
		
	// Kick	priority ring transmit
	RTMP_IO_WRITE32(pAdapter,TXCSR0,0x4);
	
	// Make	sure to	release	Prio ring resource
	NdisReleaseSpinLock(&pAdapter->PrioRingLock);
}	

/*
	========================================================================
	Routine	Description:
		This routine is	used to	en-queue outgoing packets when
		there is no	enough shread memory
		
	Arguments:
		pAdapter	Pointer	to our adapter
		pPacket		Pointer	to send	packet
		
	Return Value:
		None
	========================================================================
*/
NDIS_STATUS	RTMPSendPacket(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	struct sk_buff	*skb)
{
	PVOID			pVirtualAddress;
	UINT			AllowFragSize;
	UCHAR			NumberOfFrag;
	UCHAR			RTSRequired;
	NDIS_STATUS		Status = NDIS_STATUS_FAILURE;

	SST				Sst;
	UCHAR			PsMode,	Rate;
	USHORT			Aid;
	MAC_TABLE_ENTRY	*pMacEntry = NULL;

	PQUEUE_HEADER			pTxQueue = NULL;
	ULONG					Priority;
	UCHAR					AccessCategory = 0;

	DBGPRINT(RT_DEBUG_INFO,	"--> RTMPSendPacket\n");

	// Init	priority value
	Priority = 0;
	
	if (skb)
	{
		Priority = skb->priority;
		// 802.11e/d4.4	June, 2003
		if (Priority <=2)
			AccessCategory = 0;
		else if	(Priority == 3)
			AccessCategory = 1;
		else if	(Priority <= 5)
			AccessCategory = 2;
		else
			AccessCategory = 3;
		DBGPRINT(RT_DEBUG_INFO,	"Priority =	%d,	AC = %d\n",	Priority, AccessCategory);
	}

	// For TKIP, MIC value is treated as payload, it might be fragmented through
	// different MPDUs.
	if (pAdapter->PortCfg.WepStatus	== Ndis802_11Encryption2Enabled)
	{
		skb->len +=	8;
	}

	pVirtualAddress	= (PVOID)skb->data;
	
	// Check for virtual address allocation, it	might fail !!!
	if (pVirtualAddress	== NULL)
	{
		// Resourece is	low, system	did	not	allocation virtual address
		// return NDIS_STATUS_FAILURE directly to upper	layer
		return (Status);
	}

	//
	// Check for multicast or broadcast	(First byte	of DA)
	//
	if ((*((PUCHAR)	pVirtualAddress) & 0x01) !=	0)
	{
		// For multicast & broadcast, there	is no fragment allowed
		NumberOfFrag = 1;
	}
	else
	{
		// Check for payload allowed for each fragment
		AllowFragSize =	(pAdapter->PortCfg.FragmentThreshold) -	LENGTH_802_11 -	LENGTH_CRC;

		// Calculate fragments required
		NumberOfFrag = ((skb->len -	LENGTH_802_3 + LENGTH_802_1_H) / AllowFragSize)	+ 1;
		// Minus 1 if the size just	match to allowable fragment	size
		if (((skb->len - LENGTH_802_3 +	LENGTH_802_1_H)	% AllowFragSize) ==	0)
		{
			NumberOfFrag--;
		}
	}

	// Check for requirement of	RTS	
	if (NumberOfFrag > 1)
	{
		// If multiple fragment	required, RTS is required only for the first fragment
		// if the fragment size	large than RTS threshold
		RTSRequired	= (pAdapter->PortCfg.FragmentThreshold > pAdapter->PortCfg.RtsThreshold) ? 1 : 0;
	}
	else
	{
		RTSRequired	= (skb->len	> pAdapter->PortCfg.RtsThreshold) ?	1 :	0;
	}
	DBGPRINT(RT_DEBUG_INFO,	"Number	of fragments include RTS :%d\n", NumberOfFrag +	RTSRequired);

	// check if	target STA is in power-saving mode.	care only those	associated STAs
#ifdef	WDS
	if (RTMP_GET_PACKET_NET_DEVICE(skb)	>= 0x10)
	{
		Rate = pAdapter->WdsTab.WdsEntry[RTMP_GET_PACKET_NET_DEVICE(skb) - 0x10].CurrTxRate;
	}
	else
#endif
	{
		pMacEntry =	SsPsInquiry(pAdapter, pVirtualAddress, &Sst, &Aid, &PsMode,	&Rate);
	}

	// CTS-to-self is required for OFDM	if USE_PROTECTION bit is ON
	// When	CTS-to-self	is used, RTS/CTS is	not	required
	if ((Rate >= RATE_FIRST_OFDM_RATE) && ERP_IS_USE_PROTECTION(pAdapter->Mlme.ErpIeContent))
		RTSRequired	= 2; //	use	CTS-to-self

	// use the CurrTxRate that this	client supported
	RTMP_SET_PACKET_TXRATE(skb,	Rate);
	
	// Save	fragment number	to Ndis	packet reserved	field
	RTMP_SET_PACKET_FRAGMENTS(skb, NumberOfFrag);

	// Save	RTS	requirement	to Ndis	packet reserved	field
	RTMP_SET_PACKET_RTS(skb, RTSRequired);

#if	1
	// 1. multicast/broadcast frames are put to	PSQ	as long	as there's any associated STA in power-save	mode
	// 2. if the associted STA in power-save mode, frame also goes to PSQ
	if ((*(CHAR	*)pVirtualAddress &	0x01) && pAdapter->MacTab.fAnyStationInPsm)
	{
		// 1. move outgoing	frame to power saving queue	
		NdisAcquireSpinLock(&pAdapter->MacTabLock);
		InsertTailQueue(&pAdapter->MacTab.McastPsQueue,	skb);
		NdisReleaseSpinLock(&pAdapter->MacTabLock);
		
		// 2. mark corresponding TIM bit in	outgoing BEACON	frame
		pAdapter->Mlme.TimBitmap |=	Bit[0];
		DBGPRINT(RT_DEBUG_TRACE, "at least 1 STA in	psm, move M/BCAST to PSQ, TIM bitmap=%08x\n", pAdapter->Mlme.TimBitmap);
	}
	else if	(pMacEntry && (Sst == SST_ASSOC) &&	(PsMode	== PWR_SAVE))
	{
		// 1. move outgoing	frame to power saving queue	
		NdisAcquireSpinLock(&pAdapter->MacTabLock);
		InsertTailQueue(&pMacEntry->PsQueue, skb);
		NdisReleaseSpinLock(&pAdapter->MacTabLock);
			
		// 2. mark corresponding TIM bit in	outgoing BEACON	frame
		pAdapter->Mlme.TimBitmap |=	Bit[Aid];
		DBGPRINT(RT_DEBUG_TRACE, "target (AID=%d) in psm, move to PSQ, TIM bitmap=%08x\n", Aid,	pAdapter->Mlme.TimBitmap);
	}
	// 3. otherwise, transmit the frame
	else //	(PsMode	== PWR_ACTIVE) || (PsMode == PWR_UNKNOWN)
#endif	
	{
		// Enqueue Ndis	packet to end of Tx	wait queue
		NdisAcquireSpinLock(&pAdapter->TxSwQueueLock);

		// Select the right	priority queue
		// There should	be no else statement since it should always	fall within	0-3
		if (AccessCategory== 0)
			pTxQueue = &pAdapter->TxSwQueue0;
		else if	(AccessCategory== 1)
			pTxQueue = &pAdapter->TxSwQueue1;
		else if	(AccessCategory== 2)
			pTxQueue = &pAdapter->TxSwQueue2;
		else if	(AccessCategory== 3)
			pTxQueue = &pAdapter->TxSwQueue3;
	
		InsertTailQueue(pTxQueue, skb);
		NdisReleaseSpinLock(&pAdapter->TxSwQueueLock);
	}
	
	Status = NDIS_STATUS_SUCCESS;
	return (Status);
}

/*
	========================================================================
	Routine	Description:
		To do the enqueue operation	and	extract	the	first item of waiting 
		list. If a number of available shared memory segments could	meet 
		the	request	of extracted item, the extracted item will be fragmented
		into shared	memory segments.
		
	Arguments:
		pAdapter	Pointer	to our adapter
		pQueue		Pointer	to Waiting Queue
	========================================================================
*/
VOID	RTMPDeQueuePacket(
	IN	PRTMP_ADAPTER	pAdapter)
{
	struct sk_buff	*skb;
	UCHAR			FragmentRequired;
	NDIS_STATUS		Status;
	UCHAR			Count =	0;
	PQUEUE_HEADER	pQueue;
	ULONG			Number;
	UCHAR			AccessCategory;
	
	// Make	sure TxSwQueue0..3 queue resource won't	be used	by other threads
	NdisAcquireSpinLock(&pAdapter->TxSwQueueLock);
	
	while (((pQueue	= RTMPCheckTxSwQueue(pAdapter, &Number,	&AccessCategory)) != NULL) && (Count <	MAX_TX_PROCESS))
	// Check queue before dequeue
	// while ((pQueue->Head	!= NULL) &&	(Count < MAX_TX_PROCESS)) 
	{
		// Reset is	in progress, stop immediately
		if (RTMP_TEST_FLAG(pAdapter, fRTMP_ADAPTER_RESET_IN_PROGRESS))
		{
			break;
		}
			
		// Dequeue the first entry from	head of	queue list
		skb	= (struct sk_buff*)RemoveHeadQueue(pQueue);

		// Total fragment required = number	of fragment	+ RST if required
		FragmentRequired = RTMP_GET_PACKET_FRAGMENTS(skb) +	(RTMP_GET_PACKET_RTS(skb)? 1:0);
		
		if (RTMPFreeDescriptorRequest(pAdapter,	TX_RING, FragmentRequired) == NDIS_STATUS_SUCCESS)
		{
			// Avaliable ring descriptors are enough for this frame
			// Call	hard transmit
			// Nitro mode /	Normal mode	selection
			if ((pAdapter->PortCfg.EnableTxBurst ==	1) && (Number >	1))
				Status = RTMPHardEncrypt(pAdapter, skb,	FragmentRequired, TRUE/*EnableTxBurst*/,	AccessCategory);
			else				
				Status = RTMPHardEncrypt(pAdapter, skb,	FragmentRequired, FALSE/*EnableTxBurst*/, AccessCategory);
			if (Status == NDIS_STATUS_FAILURE)
			{
				// Packet failed due to	various	Ndis Packet	error
				RTMPFreeSkbBuffer(skb);
				break;
			}
			else if	(Status	== NDIS_STATUS_RESOURCES)
			{
				// Not enough free tx ring,	it might happen	due	to free	descriptor inquery might be	not	correct
				// It also might change	to NDIS_STATUS_FAILURE to simply drop the frame
				// Put the frame back into head	of queue
				InsertHeadQueue(pQueue,	skb);
				break;
			}			
			Count++;
		}	
		else
		{
			InsertHeadQueue(pQueue,	skb);
			pAdapter->PrivateInfo.TxRingFullCnt++;
			DBGPRINT(RT_DEBUG_INFO,"RTMPDequeuePacket --> Not enough free Tx Ring descriptor !!!\n");
			break;
		}
	}

	// Release TxSwQueue0..3 resources
	NdisReleaseSpinLock(&pAdapter->TxSwQueueLock);
}	 

/*
	========================================================================
	Routine	Description:
		This subroutine	will scan through releative	ring descriptor	to find
		out	avaliable free ring	descriptor and compare with	request	size.
		
	Arguments:
		pAdapter	Pointer	to our adapter
		RingType	Selected Ring
		
	Return Value:
		NDIS_STATUS_FAILURE		Not	enough free	descriptor
		NDIS_STATUS_SUCCESS		Enough free	descriptor
	========================================================================
*/
NDIS_STATUS	RTMPFreeDescriptorRequest(
	IN		PRTMP_ADAPTER	pAdapter,
	IN		UCHAR			RingType,
	IN		UCHAR			NumberRequired)
{
	UCHAR			FreeNumber = 0;
	UINT			Index;
	PTXD_STRUC		pTxD;
	TXD_STRUC		TxD; //tt_lin_big

	NDIS_STATUS		Status = NDIS_STATUS_FAILURE;

	switch (RingType)
	{
		case TX_RING:
			NdisAcquireSpinLock(&pAdapter->TxRingLock);
			Index =	pAdapter->CurEncryptIndex;
			do
			{
				pTxD  =	(PTXD_STRUC) pAdapter->TxRing[Index].va_addr;
				*(PULONG)&TxD =	RTMP_LE32_TO_CPU( *(PULONG)pTxD	);//tt_lin_big

				// While Owner bit is NIC, obviously ASIC still	need it.
				// If valid	bit	is TRUE, indicate that TxDone has not process yet
				// We should not use it	until TxDone finish	cleanup	job
				if ((TxD.Owner == DESC_OWN_HOST) &&	(TxD.CipherOwn == DESC_OWN_HOST) &&	(TxD.Valid == FALSE) )
				{
					// This	one	is free
					FreeNumber++;
				}
				else
				{
					break;
				}
					
				Index++;
				if (Index >= TX_RING_SIZE)				// Wrap	around issue
				{
					Index =	0;
				}
				
			}	while (FreeNumber <	NumberRequired);	// Quit	here ! Free	number is enough !
			
			if (FreeNumber >= NumberRequired)
			{
				Status = NDIS_STATUS_SUCCESS;
			}
			
			// Make	sure to	release	Tx ring	resource
			NdisReleaseSpinLock(&pAdapter->TxRingLock);
			break;
			
		case PRIO_RING:
			NdisAcquireSpinLock(&pAdapter->PrioRingLock);
			Index =	pAdapter->CurPrioIndex;
			do
			{
				pTxD  =	(PTXD_STRUC) pAdapter->PrioRing[Index].va_addr;
				*(PULONG)&TxD =	RTMP_LE32_TO_CPU( *(PULONG)pTxD	);//tt_lin_big

				// While Owner bit is NIC, obviously ASIC still	need it.
				// If valid	bit	is TRUE, indicate that TxDone has not process yet
				// We should not use it	until TxDone finish	cleanup	job
				if ((TxD.Owner == DESC_OWN_HOST) &&	(TxD.Valid == FALSE))
				{
					// This	one	is free
					FreeNumber++;
				}
				else
				{
					break;
				}
					
				Index++;
				if (Index >= PRIO_RING_SIZE)			// Wrap	around issue
				{
					Index =	0;
				}
				
			}	while (FreeNumber <	NumberRequired);	// Quit	here ! Free	number is enough !
			
			if (FreeNumber >= NumberRequired)
			{
				Status = NDIS_STATUS_SUCCESS;
			}
			
			// Make	sure to	release	Prio ring resource
			NdisReleaseSpinLock(&pAdapter->PrioRingLock);
			break;

		default:
			break;
	}
	
	return (Status);
}

/*
	========================================================================
	Routine	Description:
		Copy frame from	waiting	queue into relative	ring buffer	and	set	
	appropriate	ASIC register to kick hardware encryption before really
	sent out to	air.
		
	Arguments:
		pAdapter		Pointer	to our adapter
		PNDIS_PACKET	Pointer	to outgoing	Ndis frame
		NumberOfFrag	Number of fragment required
		
	Return Value:
		None
	========================================================================
*/
NDIS_STATUS	RTMPHardEncrypt(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	struct sk_buff	*skb,
	IN	UCHAR			NumberRequired,
	IN	ULONG			EnableTxBurst,
	IN	UCHAR			AccessCategory)
{
	UINT			Length;
	UINT			BytesCopied;
	UINT			TxSize;
	UINT			FreeFragSize;
	UINT			RemainSize;
	UCHAR			ThisFrameKeyID = 0;
//	  UCHAR			  FragNumber;
	ULONG			Iv16;
	ULONG			Iv32;
	UCHAR			FrameGap;
	UCHAR			TxRate;
	UCHAR			RetryMode =	SHORT_RETRY;
	UCHAR			AckRate;
	UCHAR			CipherAlg;
	PVOID			pVirtualAddress;
	PUCHAR			pDest;
	PUCHAR			pSrc;
	PUCHAR			pEncap;
	USHORT			Protocol;
	USHORT			AckDuration;
	BOOLEAN			StartOfFrame;
	BOOLEAN			EAPOLFrame;	//for 802.1x
	BOOLEAN			Encapped;
	BOOLEAN			MICFrag;
	PTXD_STRUC		pTxD;
	TXD_STRUC		TxD; //tt_lin_big
	HEADER_802_11	Header_802_11;
	PWPA_KEY		pWpaKey	= (PWPA_KEY) NULL;
	MAC_TABLE_ENTRY	*pEntry;
#ifdef WDS
	BOOLEAN			bWdsPacket = FALSE;
#endif

	DBGPRINT(RT_DEBUG_INFO,	"-->RTMPHardEncrypt\n");
	// Make sure Tx ring resource won't be used by other threads
	NdisAcquireSpinLock(&pAdapter->TxRingLock);

	if(skb->data == NULL)
	{
		DBGPRINT(RT_DEBUG_ERROR, "Error, Null skb data buffer!!!\n");

		NdisReleaseSpinLock(&pAdapter->TxRingLock);
		return (NDIS_STATUS_FAILURE);
	}

#ifdef	WDS	
	if (RTMP_GET_PACKET_NET_DEVICE(skb)	>= 0x10)
	{
		bWdsPacket = TRUE;
	}
	else
	{
		bWdsPacket = FALSE;
	}
#endif

	if (EnableTxBurst == 1)
		FrameGap = IFS_SIFS;
	else
		FrameGap = IFS_BACKOFF;		// Default frame gap mode

	pVirtualAddress	= (PVOID)skb->data;
	Length = skb->len;
	
	// Sequence	Number is identical	for	all	fragments belonged to the same frame
	// Sequence	is 0 - 4095
	pAdapter->Sequence = ((pAdapter->Sequence) + 1)	& (MAX_SEQ_NUMBER);
	pAdapter->TxRing[pAdapter->CurEncryptIndex].FrameType =	BTYPE_DATA;

	TxRate = RTMP_GET_PACKET_TXRATE(skb);
	AckRate	= pAdapter->PortCfg.ExpectedACKRate[TxRate];
	AckDuration	= RTMPCalcDuration(pAdapter, AckRate, 14);

	// Initialize 802.11 header	for	each frame
	NdisZeroMemory(&Header_802_11, sizeof(HEADER_802_11));

	if ((*((PUCHAR)	pVirtualAddress) & 0x01) !=	0)	// Multicast or	Broadcast
	{
		INC_COUNTER(pAdapter->WlanCounters.MulticastTransmittedFrameCount);
	}

	if (Length < 14)
	{
		DBGPRINT(RT_DEBUG_ERROR,"RTMPHardTransmit --> Ndis Packet buffer error !!!\n");
		// Make	sure to	release	Tx ring	resource
		NdisReleaseSpinLock(&pAdapter->TxRingLock);
		return (NDIS_STATUS_FAILURE);
	}		
	//
	// Start making	802.11 frame header
	//
#ifdef	WDS
	if (bWdsPacket)
	{
//		char *pSrc = ((char	*)pVirtualAddress) + 6;	// SA
		// Addr1: RA, Addr2: TA, Addr3:	DA,	Addr4: SA
		Header_802_11.Controlhead.Frame.FrDs = 1; //S0
		Header_802_11.Controlhead.Frame.ToDs = 1; //S0
		NdisMoveMemory(&Header_802_11.Controlhead.Addr1, &pAdapter->WdsTab.WdsEntry[(RTMP_GET_PACKET_NET_DEVICE(skb) - 0x10)].WdsAddr, ETH_LENGTH_OF_ADDRESS);// RA
		NdisMoveMemory(&Header_802_11.Controlhead.Addr2, &pAdapter->CurrentAddress,	ETH_LENGTH_OF_ADDRESS);// TA
		NdisMoveMemory(&Header_802_11.Addr3, pVirtualAddress, ETH_LENGTH_OF_ADDRESS);//	DA
		DBGPRINT(RT_DEBUG_INFO,"WDS-DA=%02x:%02x:%02x:%02x:%02x:%02x, SA=%02x:%02x:%02x:%02x:%02x:%02x\n", 
			*((PUCHAR)pVirtualAddress+0),*((PUCHAR)pVirtualAddress+1),*((PUCHAR)pVirtualAddress+2),*((PUCHAR)pVirtualAddress+3),*((PUCHAR)pVirtualAddress+4),*((PUCHAR)pVirtualAddress+5),
			*((PUCHAR)pVirtualAddress+6),*((PUCHAR)pVirtualAddress+7),*((PUCHAR)pVirtualAddress+8),*((PUCHAR)pVirtualAddress+9),*((PUCHAR)pVirtualAddress+10),*((PUCHAR)pVirtualAddress+11));
	}
	else
#endif
	{
		char *pSrc = ((char	*)pVirtualAddress) + 6;	// SA
		// Addr1: DA, Addr2: BSSID,	Addr3: SA
		Header_802_11.Controlhead.Frame.FrDs = 1; //S0
		Header_802_11.Controlhead.Frame.ToDs = 0; //S0
		NdisMoveMemory(&Header_802_11.Controlhead.Addr1, pVirtualAddress, ETH_LENGTH_OF_ADDRESS);
		NdisMoveMemory(&Header_802_11.Controlhead.Addr2, &pAdapter->PortCfg.Bssid, ETH_LENGTH_OF_ADDRESS);
		NdisMoveMemory(&Header_802_11.Addr3, pSrc, ETH_LENGTH_OF_ADDRESS);
	}

	pEntry = MacTableLookup(pAdapter, &Header_802_11.Controlhead.Addr1);
	
	Header_802_11.Sequence = pAdapter->Sequence;		// Sequence	number S11
	Header_802_11.Controlhead.Frame.Type = BTYPE_DATA;	// Frame type //S0
	Header_802_11.Controlhead.Frame.PwrMgt = 0;						  //S0

	if (Header_802_11.Controlhead.Addr1.Octet[0] & 0x01)
	{
		// No ACK expected for multicast frame		
		Header_802_11.Controlhead.Duration = 0;//S0
	}
	else
	{
		// ACK size	is 14 include CRC, and its rate	is 2Mb
		Header_802_11.Controlhead.Duration = pAdapter->PortCfg.Dsifs + AckDuration;//S1	

		// record the last TX rate (unicast	DATA frame only) that this AP used.	for	UI to display only.
		// only	unicast	frames counts, because mcast/bcast frames always use basic rate
		pAdapter->PortCfg.TxRate = TxRate;
	
	}
	
	// For the purpose to calculate	duration for the second	last fragment
	RemainSize = skb->len -	LENGTH_802_3 + LENGTH_CRC;

	// Add 802.11x protocol check.
	// For non-WPA network,	802.1x message should not encrypt even
	// the privacy is on.
	if (RTMPEqualMemory(EAPOL, ((PUCHAR) pVirtualAddress) +	12,	2))
	{
		EAPOLFrame = TRUE;
		DBGPRINT(DEBUG_TEMP,"RTMPHardEncrypt --> EAPOLFrame = TRUE!!!\n");
		// patch for Lenght += 8; in SendPacket 
		if (pAdapter->PortCfg.WepStatus == Ndis802_11Encryption2Enabled)
		{
			skb->len -= 8;
			Length -= 8;            
		}
		DBGPRINT(DEBUG_TEMP, "   RTMPHardEncrypt ==>> skb->len=%d , Length = %d \n", skb->len, Length);
	}
	else
	{
		EAPOLFrame = FALSE;
	}

	// WPA 802.1x secured port control
	//	Don't send this	frame.
	//	Why? PortSecured in	PortCfg
#ifdef	WDS
	if(!bWdsPacket)
#endif
	{//tt_lin drop EAP frame for TX
		if (((pAdapter->PortCfg.AuthMode ==	Ndis802_11AuthModeWPA) || 
			(pAdapter->PortCfg.AuthMode	== Ndis802_11AuthModeWPAPSK)) &&
			(pAdapter->PortCfg.PortSecured == WPA_802_1X_PORT_NOT_SECURED) &&
			(EAPOLFrame	== FALSE))
		{
			DBGPRINT(RT_DEBUG_TRACE,"RTMPHardEncrypt --> Drop packet before	port secured !!!\n");
			// Make	sure to	release	Tx ring	resource
			NdisReleaseSpinLock(&pAdapter->TxRingLock);
			return (NDIS_STATUS_FAILURE);
		}		
	}

	MICFrag	= FALSE;	// Flag	to indicate	MIC	shall spread into two MPDUs
	Encapped = FALSE;
	pEncap = NULL;
	
	pSrc = (PUCHAR)	pVirtualAddress;
	Protocol = *(pSrc +	12)	* 256 +	*(pSrc + 13); 
	if (Protocol > 1500)	// CHeck for LLC encaped
	{
		pEncap = SNAP_802_1H;
		Encapped = TRUE;
		if (RTMPEqualMemory(IPX, pSrc +	12,	2))
		{
			pEncap = SNAP_BRIDGE_TUNNEL;
		}
		
		if (RTMPEqualMemory(APPLE_TALK,	pSrc + 12, 2))
		{
			pEncap = SNAP_BRIDGE_TUNNEL;
		}
	}

	//
	// Make	RTS	or CTS-to-self frame if	required
	//
	if (RTMP_GET_PACKET_RTS(skb))
	{
		PCONTROL_HEADER		pControlHeader;
		CONTROL_HEADER		ControlHeader; //tt_lin_big
		UINT				DATAFrameSize;
		
		pDest =	(PUCHAR) pAdapter->TxRing[pAdapter->CurEncryptIndex].va_data_addr;				
		pTxD  =	(PTXD_STRUC) pAdapter->TxRing[pAdapter->CurEncryptIndex].va_addr;
		
		*(PULONG)&TxD =	RTMP_LE32_TO_CPU( *(PULONG)pTxD	); //tt_lin_big
			
		if ((TxD.Owner == DESC_OWN_NIC)	|| (TxD.CipherOwn == DESC_OWN_NIC))
		{
			// Descriptor owned	by NIC.	No descriptor avaliable
			// This	should not happen since	caller guaranteed.
			// Make	sure to	release	Tx ring	resource
			NdisReleaseSpinLock(&pAdapter->TxRingLock);
			return (NDIS_STATUS_RESOURCES);
		}
		if (TxD.Valid == TRUE)//w0
		{
			// This	might happen when HardTransmit process faster than TxDone interrupt.
			// However,	Since we did call free descriptor number check before Tx HardTransmit.
			// This	case should	not	happened. We should	return to higher caller	and	requeue	this
			// acket until next	Tx hardtransmit. Hopefully this	situation is corrected then.
			// Ndis	packet of last round did not cleared.
			// This	should not happen since	caller guaranteed.
			// Make	sure to	release	Tx ring	resource
			TxD.Valid =	FALSE; //w0
			
			*(PULONG)pTxD =	RTMP_CPU_TO_LE32( *(PULONG)&TxD	); //tt_lin_big
				
			NdisReleaseSpinLock(&pAdapter->TxRingLock);
			return (NDIS_STATUS_RESOURCES);
		}
		
		pAdapter->TxRing[pAdapter->CurEncryptIndex].FrameType =	BTYPE_CNTL;
		
		pControlHeader = (PCONTROL_HEADER) pDest;
			
		NdisZeroMemory(pControlHeader, sizeof(CONTROL_HEADER));
		*(PUSHORT)&ControlHeader = 0; //tt_lin_big (clear Control frame) (s0)
		// Calculate duration
		if (RTMP_GET_PACKET_FRAGMENTS(skb) > 1)
		{
			// If fragment required, size is maximum fragment size
			DATAFrameSize =	pAdapter->PortCfg.FragmentThreshold;
		}
		else
		{
			// Size	should be frame	with 802.11	header & CRC
#ifdef	WDS
			if (bWdsPacket)
			{
				DATAFrameSize =	skb->len + LENGTH_802_11_WITH_ADDR4	+ LENGTH_802_1_H + LENGTH_CRC -	LENGTH_802_3;//	the	length of addr4
			}
			else
#endif
			{
				DATAFrameSize =	skb->len + LENGTH_802_11 + LENGTH_802_1_H +	LENGTH_CRC - LENGTH_802_3;
			}

			// Decrease	the	LLC	header size	if it's	already	encapped from protocol layer
			if (Encapped ==	FALSE)
			{
				DATAFrameSize -= LENGTH_802_11;
			}

			// Add for WPA support
			if ((pAdapter->PortCfg.WepStatus ==	Ndis802_11Encryption1Enabled) && 
				(pAdapter->PortCfg.SharedKey[pAdapter->PortCfg.DefaultKeyId].KeyLen	!= 0))
			{
				// WEP encryption
				DATAFrameSize += 8;
			}
			// The following statement might need change, because it might use peer	key
			// However,	it will	complicate the control sequence.
			// Therefore we	will simply	add	the	12 bytes into CTS duration no matter
			// the key exists or not.
			else if	(pAdapter->PortCfg.WepStatus ==	Ndis802_11Encryption2Enabled)
			{
				// TKIP	encryption
				DATAFrameSize += 12;		// IV +	EIV	+ ICV, MIC already added to	TotalPacketLength
			}
			else if	(pAdapter->PortCfg.WepStatus ==	Ndis802_11Encryption3Enabled)
			{
				// AES encryption
				DATAFrameSize += 16;		// IV +	EIV	+ Hardware MIC
			}
		}

		if (RTMP_GET_PACKET_RTS(skb) ==	1)
		{
			DBGPRINT(RT_DEBUG_TRACE,"Making	RTS	Frame\n");
			
			// FrameControl
			ControlHeader.Frame.Type	= BTYPE_CNTL; //s0 (write back)
			ControlHeader.Frame.Subtype	= SUBTYPE_RTS;//s0 (write back)		  

			// RTS Duration	= SIFS + CTS + SIFS	+ DATA + SIFS +	ACK
			ControlHeader.Duration = pAdapter->PortCfg.Dsifs   //s1	(write back)
				+ RTMPCalcDuration(pAdapter, pAdapter->PortCfg.RtsRate,	14)
				+ pAdapter->PortCfg.Dsifs
				+ RTMPCalcDuration(pAdapter, TxRate, DATAFrameSize)
				+ pAdapter->PortCfg.Dsifs
				+ AckDuration; 

			// RA &	TA
#ifdef	WDS
			if (bWdsPacket)
			{
				NdisMoveMemory(&pControlHeader->Addr1, &pAdapter->WdsTab.WdsEntry[(RTMP_GET_PACKET_NET_DEVICE(skb) - 0x10)].WdsAddr, ETH_LENGTH_OF_ADDRESS);
			}
			else
#endif
			{
				NdisMoveMemory(&pControlHeader->Addr1, (PUCHAR)	pVirtualAddress, ETH_LENGTH_OF_ADDRESS);
			}
			NdisMoveMemory(&pControlHeader->Addr2, pAdapter->CurrentAddress, ETH_LENGTH_OF_ADDRESS);

			// Write Tx	descriptor
			// Don't kick tx start until all frames	are	prepared
			// RTS has to set more fragment	bit	for	fragment burst
			// RTS did not encrypt
			
			RTMPWriteTxDescriptor(pTxD,	TRUE, CIPHER_NONE, TRUE, TRUE, FALSE, SHORT_RETRY, FrameGap, 
									pAdapter->PortCfg.RtsRate, 4, sizeof(CONTROL_HEADER),	
									pAdapter->PortCfg.TxPreamble, AccessCategory);

			*(((PULONG)&TxD)+10) = RTMP_LE32_TO_CPU( *(((PULONG)pTxD)+10) ); //tt_lin_big
			TxD.RTS	= 1;//w10
			*(((PULONG)pTxD)+10) = RTMP_CPU_TO_LE32( *(((PULONG)&TxD)+10) ); //tt_lin_big	
			// RTS-protected frames	should use LONG_RETRY (=4),	other frames use SHORT_RETRY(=7)
			RetryMode =	LONG_RETRY;
		
		}
		else //	CTS-to-self
		{
			DBGPRINT(RT_DEBUG_INFO,"Making	CTS-to-self	Frame\n");
			
			// FrameControl
			ControlHeader.Frame.Type	= BTYPE_CNTL;  //s0	(write back)
			ControlHeader.Frame.Subtype	= SUBTYPE_CTS; //s0	(writw back)	  

			// CTS-to-self duration	= SIFS + DATA +	SIFS + ACK
			ControlHeader.Duration = pAdapter->PortCfg.Dsifs //s1 (write back)
				+ RTMPCalcDuration(pAdapter, TxRate, DATAFrameSize)
				+ pAdapter->PortCfg.Dsifs
				+ RTMPCalcDuration(pAdapter, pAdapter->PortCfg.ExpectedACKRate[TxRate],	14); 

			NdisMoveMemory(&pControlHeader->Addr1, pAdapter->CurrentAddress, ETH_LENGTH_OF_ADDRESS);

			// Write Tx	descriptor
			// Don't kick tx start until all frames	are	prepared
			// CTS has to set more fragment	bit	for	fragment burst
			// CTS did not encrypt		
			// CTS-to-self will	never receive ACK
			RTMPWriteTxDescriptor(pTxD, TRUE, CIPHER_NONE, FALSE, TRUE, FALSE, SHORT_RETRY, FrameGap, 
						pAdapter->PortCfg.RtsRate, 4, 10, pAdapter->PortCfg.TxPreamble, AccessCategory);
		}
		///	tt_lin_big ////////////////////////////////////
		*(PUSHORT)pControlHeader = RTMP_CPU_TO_LE16( *(PUSHORT)&ControlHeader );//tt_lin_big (control-frame) (s0)
		*(((PUSHORT)pControlHeader)+1) = RTMP_CPU_TO_LE16( *(((PUSHORT)&ControlHeader)+1) ); //tt_lin_big (Duration) (s1)

		FrameGap = IFS_SIFS;		// Init	frame gap for coming data after	RTS
		NumberRequired--;
		
		// Increase	& maintain Tx Ring Index
		pAdapter->CurEncryptIndex++;
		if (pAdapter->CurEncryptIndex >= TX_RING_SIZE)
		{
			pAdapter->CurEncryptIndex =	0;
		}
		pAdapter->RalinkCounters.EncryptCount++;		
	}

	// Find	the	WPA	key, either	Group or Pairwise Key
	if (pAdapter->PortCfg.WepStatus	>= Ndis802_11Encryption2Enabled)
	{
		pWpaKey	= (PWPA_KEY) NULL;
		// First lookup	the	DA,	if it's	a group	address, use GROUP key
		if (Header_802_11.Controlhead.Addr1.Octet[0] & 0x01)
		{
			if (pAdapter->PortCfg.GroupKey[pAdapter->PortCfg.WPAGKeyID].KeyLen != 0)
			{
				pWpaKey	= (PWPA_KEY) &pAdapter->PortCfg.GroupKey[pAdapter->PortCfg.WPAGKeyID];
				DBGPRINT(RT_DEBUG_INFO,	"Tx	Use	Group Key\n");
			}
			ThisFrameKeyID = pAdapter->PortCfg.WPAGKeyID;
		}
		// Try to find the Pairwise	Key, key ID	is 0, then substitute DefaultKeyId for 3enable and 2enable case
		else
		{
			ThisFrameKeyID = 0;
			if ( (pEntry)  &&  (pEntry->PairwiseKey[0].KeyLen != 0))
			{
				pWpaKey	= (PWPA_KEY) &pEntry->PairwiseKey[0];
			}
			// Use default Group Key if	there is no	Pairwise key present
			if ((pAdapter->PortCfg.GroupKey[pAdapter->PortCfg.WPAGKeyID].KeyLen != 0) && (pWpaKey ==	NULL))
			{
				pWpaKey	= (PWPA_KEY) &pAdapter->PortCfg.GroupKey[pAdapter->PortCfg.WPAGKeyID];
				DBGPRINT(RT_DEBUG_INFO,	"Tx	Use	Group Key\n");
				ThisFrameKeyID = pAdapter->PortCfg.WPAGKeyID;
			}
		}

#ifdef	WDS
		if (bWdsPacket)
		{
			pWpaKey	= (PWPA_KEY) &pAdapter->WdsTab.Wpa_key;
		}
#endif
#if	0
		if (pWpaKey	!= NULL)
		{
			INT	i;
				
			DBGPRINT_RAW(RT_DEBUG_TRACE, ("RTMPHardEncrypt TKIP	Key	= "));
			for	(i = 0;	i <	16;	i++)
			{
				DBGPRINT_RAW(RT_DEBUG_TRACE, ("%02x:", pWpaKey->Key[i]));
			}
			DBGPRINT_RAW(RT_DEBUG_TRACE, ("\n"));						
		}
#endif		
	}

	StartOfFrame = TRUE;
	// Start Copy Ndis Packet into Ring	buffer.
	// For frame required more than	one	ring buffer	(fragment),	all	ring buffers
	// have	to be filled before	kicking	start tx bit.
	do
	{
		// Get the Tx Ring descriptor &	Dma	Buffer address
		pDest =	(PUCHAR) pAdapter->TxRing[pAdapter->CurEncryptIndex].va_data_addr;				
		pTxD  =	(PTXD_STRUC) pAdapter->TxRing[pAdapter->CurEncryptIndex].va_addr;
		
		*(PULONG)&TxD =	RTMP_LE32_TO_CPU( *(PULONG)pTxD	); //tt_lin_big
		*(((PULONG)&TxD)+2)	= RTMP_LE32_TO_CPU(	*(((PULONG)pTxD)+2)	);//tt_lin_big
		
		// Maximum allowable payload with one ring buffer, bound by	fragment size
		FreeFragSize = pAdapter->PortCfg.FragmentThreshold - LENGTH_CRC;
		
		if ((TxD.Owner == DESC_OWN_NIC)	|| (TxD.CipherOwn == DESC_OWN_NIC))//w0
		{
			// Descriptor owned	by NIC.	No descriptor avaliable
			// This	should not happen since	caller guaranteed.
			// Make	sure to	release	Tx ring	resource
			pAdapter->RalinkCounters.TxRingErrCount++;
			NdisReleaseSpinLock(&pAdapter->TxRingLock);
			return (NDIS_STATUS_RESOURCES);
		}
		if (TxD.Valid == TRUE) //w0
		{
			// Ndis	packet of last round did not cleared.
			// This	should not happen since	caller guaranteed.
			// Make	sure to	release	Tx ring	resource
			TxD.Valid =	FALSE; //w0
			
			*(PULONG)pTxD =	RTMP_CPU_TO_LE32( *(PULONG)&TxD	); //tt_lin_big
			
			pAdapter->RalinkCounters.TxRingErrCount++;
			NdisReleaseSpinLock(&pAdapter->TxRingLock);
			return (NDIS_STATUS_RESOURCES);
		}

		// Make	fragment number	& more fragment	bit	of 802.11 header
		if (StartOfFrame ==	TRUE)
		{  
			Header_802_11.Frag = 0;		 //s11	 //	Start of fragment burst	/ Single Frame 
		}
		else
		{
			Header_802_11.Frag++;	  //s11		 //	Rest of	fragmented frames.
		}
		
		// Turn	on with	no frames after	this one
		if (NumberRequired > 1)
		{
			ULONG FragSize;
			
			Header_802_11.Controlhead.Frame.MoreFrag = 1; //s0
			// Duration	should include next	fragment
			// Add stuff for WPA support
			if ((pAdapter->PortCfg.WepStatus ==	Ndis802_11Encryption1Enabled) && (EAPOLFrame ==	FALSE) &&
				(pAdapter->PortCfg.SharedKey[pAdapter->PortCfg.DefaultKeyId].KeyLen	!= 0))
				FragSize = pAdapter->PortCfg.FragmentThreshold + 8;
			else if	((pAdapter->PortCfg.WepStatus == Ndis802_11Encryption2Enabled) && 
				(pWpaKey->KeyLen != 0) &&
				((EAPOLFrame == FALSE) || (pEntry && (pEntry->PortSecured == WPA_802_1X_PORT_SECURED))))
				FragSize = pAdapter->PortCfg.FragmentThreshold + 12;
			else if	((pAdapter->PortCfg.WepStatus == Ndis802_11Encryption3Enabled) && 
				(pWpaKey->KeyLen != 0) &&
				((EAPOLFrame == FALSE) || (pEntry && (pEntry->PortSecured == WPA_802_1X_PORT_SECURED))))
				FragSize = pAdapter->PortCfg.FragmentThreshold + 16;
			else
				FragSize = pAdapter->PortCfg.FragmentThreshold;

			Header_802_11.Controlhead.Duration = 3 * pAdapter->PortCfg.Dsifs //s1
				+ 2	* AckDuration		
				+ RTMPCalcDuration(pAdapter, TxRate, FragSize);
		}
		else
		{
			Header_802_11.Controlhead.Frame.MoreFrag = 0; //s0
			// ACK size	is 14 include CRC, and its rate	is MaxBasicRate
			Header_802_11.Controlhead.Duration = pAdapter->PortCfg.Dsifs + AckDuration;	//s1
		}

		if (NumberRequired == 2)
		{
			ULONG FragSize;
			
#ifdef	WDS
			if (bWdsPacket)
			{
				RemainSize = RemainSize	- pAdapter->PortCfg.FragmentThreshold +	LENGTH_802_11_WITH_ADDR4 + LENGTH_802_11 + LENGTH_CRC;// the length	of addr4
			}
			else
#endif
			{
				RemainSize = RemainSize	- pAdapter->PortCfg.FragmentThreshold +	LENGTH_802_11 +	LENGTH_802_11 +	LENGTH_CRC;
			}

			// Add stuff for WPA support
			if ((pAdapter->PortCfg.WepStatus ==	Ndis802_11Encryption1Enabled) && (EAPOLFrame ==	FALSE) && 
				(pAdapter->PortCfg.SharedKey[pAdapter->PortCfg.DefaultKeyId].KeyLen	!= 0))
				FragSize = RemainSize +	8;
			else if ((pAdapter->PortCfg.WepStatus == Ndis802_11Encryption2Enabled) &&
				(pWpaKey->KeyLen != 0) &&
				((EAPOLFrame == FALSE) || (pEntry && (pEntry->PortSecured == WPA_802_1X_PORT_SECURED))))                
				FragSize = RemainSize +	12;
			else if ((pAdapter->PortCfg.WepStatus == Ndis802_11Encryption3Enabled) &&
				(pWpaKey->KeyLen != 0) &&
				((EAPOLFrame == FALSE) || (pEntry && (pEntry->PortSecured == WPA_802_1X_PORT_SECURED))))                
				FragSize = RemainSize +	16;
			else
				FragSize = RemainSize;
			
			Header_802_11.Controlhead.Duration = 3 * pAdapter->PortCfg.Dsifs //S1
				+ 2	* AckDuration		
				+ RTMPCalcDuration(pAdapter, TxRate, FragSize);
		}
#if	0
		// Support Nitro mode, add additional 100 us for all data frame	duration
		if (EnableTxBurst == 1)
		{
			Header_802_11.Controlhead.Duration += 100; //S1
		}
#endif
		// Check for WEP enable	bit	and	prepare	for	software WEP
		if ((pAdapter->PortCfg.WepStatus == Ndis802_11Encryption1Enabled) && 
			(pAdapter->PortCfg.SharedKey[pAdapter->PortCfg.DefaultKeyId/*i*/].KeyLen != 0) &&
			((EAPOLFrame ==	FALSE) || (pEntry && (pEntry->PortSecured == WPA_802_1X_PORT_SECURED))))
		{
			Header_802_11.Controlhead.Frame.Wep	= 1;
		}
		else if	((pAdapter->PortCfg.WepStatus == Ndis802_11Encryption2Enabled) 
			&& (pWpaKey != NULL) &&
	           ((EAPOLFrame == FALSE) || (pEntry && (pEntry->PortSecured == WPA_802_1X_PORT_SECURED))))        
		{
			Header_802_11.Controlhead.Frame.Wep	= 1;
		}
		else if	((pAdapter->PortCfg.WepStatus == Ndis802_11Encryption3Enabled) 
			&& (pWpaKey != NULL) &&
            ((EAPOLFrame == FALSE) || (pEntry && (pEntry->PortSecured == WPA_802_1X_PORT_SECURED))))        
		{
			Header_802_11.Controlhead.Frame.Wep	= 1;
		}
		
		// Copy	802.11 header to Tx	ring buffer
#ifdef	WDS
		if (bWdsPacket)
		{
			NdisMoveMemory(pDest, &Header_802_11, sizeof(Header_802_11));
			*(PUSHORT)pDest	= RTMP_CPU_TO_LE16(	*(PUSHORT)pDest	); //tt_lin_big
			*(((PUSHORT)pDest)+1) =	RTMP_CPU_TO_LE16( *(((PUSHORT)pDest)+1)	);//tt_lin_big
			*(((PUSHORT)pDest)+11) = RTMP_CPU_TO_LE16( *(((PUSHORT)pDest)+11) );//tt_lin_big

			NdisMoveMemory(pDest + sizeof(Header_802_11), (PUCHAR)pVirtualAddress +	ETH_LENGTH_OF_ADDRESS, ETH_LENGTH_OF_ADDRESS);// SA
			pDest		 +=	LENGTH_802_11_WITH_ADDR4;
			FreeFragSize -=	(sizeof(Header_802_11) + ETH_LENGTH_OF_ADDRESS);
		}
		else
#endif
		{
			NdisMoveMemory(pDest, &Header_802_11, sizeof(Header_802_11));
			*(PUSHORT)pDest	= RTMP_CPU_TO_LE16(	*(PUSHORT)pDest	); //tt_lin_big
			*(((PUSHORT)pDest)+1) =	RTMP_CPU_TO_LE16( *(((PUSHORT)pDest)+1)	);//tt_lin_big
			*(((PUSHORT)pDest)+11) = RTMP_CPU_TO_LE16( *(((PUSHORT)pDest)+11) );//tt_lin_big

			pDest		 +=	sizeof(Header_802_11);
			FreeFragSize -=	sizeof(Header_802_11);
		}

		if ((pAdapter->PortCfg.WepStatus ==	Ndis802_11Encryption1Enabled) && (EAPOLFrame ==	FALSE) &&
			(pAdapter->PortCfg.SharedKey[pAdapter->PortCfg.DefaultKeyId].KeyLen	!= 0))
		{
			// Prepare IV, IV offset, Key for Hardware encryption
			RTMPInitWepEngine(
				pAdapter,
				pAdapter->PortCfg.SharedKey[pAdapter->PortCfg.DefaultKeyId].Key,
				pAdapter->PortCfg.DefaultKeyId,
				pAdapter->PortCfg.SharedKey[pAdapter->PortCfg.DefaultKeyId].KeyLen,
				(PUCHAR) &pTxD->Iv); 
			if (pAdapter->PortCfg.SharedKey[pAdapter->PortCfg.DefaultKeyId].KeyLen == 5)
			{
				CipherAlg =	CIPHER_WEP64;
			}
			else
			{
				CipherAlg =	CIPHER_WEP128;
			}

			// Set Iv offset in	TxD
#ifdef	WDS
			if (bWdsPacket)
			{
				TxD.IvOffset = LENGTH_802_11_WITH_ADDR4;//w2
			}
			else
#endif
			{
				TxD.IvOffset = LENGTH_802_11;//w2 (write back)
			}

			// Copy	Encrypt	Key	to TxD
			NdisMoveMemory(
				pTxD->Key,
				pAdapter->PortCfg.SharedKey[pAdapter->PortCfg.DefaultKeyId].Key,
				pAdapter->PortCfg.SharedKey[pAdapter->PortCfg.DefaultKeyId].KeyLen);			
		}
		else if ((pAdapter->PortCfg.WepStatus == Ndis802_11Encryption2Enabled) 
		&& (pWpaKey != NULL) && ((EAPOLFrame == FALSE) || (pEntry && (pEntry->PortSecured == WPA_802_1X_PORT_SECURED))))
		{
			INT		i;
			UCHAR	Eiv_Tmp[4];
			PUCHAR	pTmp;

			i =	0;
			// Prepare IV, EIV,	IV offset, Key for hardware	encryption
			RTMPInitTkipEngine(
				pAdapter,
				pWpaKey->Key,
				ThisFrameKeyID,		// This	might cause	problem	when using peer	key
				Header_802_11.Controlhead.Addr2.Octet,
				pWpaKey->TxMic,
				pWpaKey->TxTsc,
				&Iv16,	//big-endian
				&Iv32);	//big-endian
			
			// Increase	TxTsc value	for	next transmission
			while (++pWpaKey->TxTsc[i] == 0x0)
			{
				i++;
				if (i == 6)
					break;
			}
			if (i == 6)
			{
				// TODO: TSC has done one full cycle, do re-keying stuff follow	specs
				// Should send a special event microsoft defined to	request	re-key
			}
			
			// Copy	IV
			NdisMoveMemory(&pTxD->Iv, &Iv16, 4); //Iv16	is big-endian
			pTxD->Iv = RTMP_CPU_TO_LE32( pTxD->Iv ); //tt_lin_big	
			
			// Swap	EIV	byte order,	due	to ASIC's bug.(endian-change)
			pTmp = (PUCHAR)	&Iv32;
			Eiv_Tmp[0] = *(pTmp	+ 3);
			Eiv_Tmp[1] = *(pTmp	+ 2);
			Eiv_Tmp[2] = *(pTmp	+ 1);
			Eiv_Tmp[3] = *(pTmp);								
			// Copy	EIV
			NdisMoveMemory(&pTxD->Eiv, Eiv_Tmp,	4);	//Iv32 is big-endian
			pTxD->Eiv =	RTMP_CPU_TO_LE32( pTxD->Eiv	); //tt_lin_big
			// Set IV offset
#ifdef	WDS
			if (bWdsPacket)
			{
				TxD.IvOffset = LENGTH_802_11_WITH_ADDR4; //w2(write	back)
			}
			else
#endif
			{
				TxD.IvOffset = LENGTH_802_11;//w2(write	back)
			}

			// Copy	TKey
			NdisMoveMemory(pTxD->Key, pWpaKey->Key,	16);
			
			// Set Cipher suite
			CipherAlg =	CIPHER_TKIP;
		}
		else if ((pAdapter->PortCfg.WepStatus == Ndis802_11Encryption3Enabled)  
			&& (pWpaKey != NULL) &&
			((EAPOLFrame == FALSE) || (pEntry && (pEntry->PortSecured == WPA_802_1X_PORT_SECURED))))                 
		{
			INT		i;
			PUCHAR	pTmp;

			i =	0;
			pTmp = (PUCHAR)	&Iv16;
			*pTmp		= pWpaKey->TxTsc[0];
			*(pTmp + 1)	= pWpaKey->TxTsc[1];
			*(pTmp + 2)	= 0;
			*(pTmp + 3)	= (ThisFrameKeyID << 6)	| 0x20;
			Iv32 = *(PULONG)(&pWpaKey->TxTsc[2]);//need	change to little-endian
			
			// Increase	TxTsc value	for	next transmission
			while (++pWpaKey->TxTsc[i] == 0x0)
			{
				i++;
				if (i == 6)
					break;
			}
			if (i == 6)
			{
				// TODO: TSC has done one full cycle, do re-keying stuff follow	specs
				// Should send a special event microsoft defined to	request	re-key
			}
			
			// Copy	IV
			NdisMoveMemory(&pTxD->Iv, &Iv16, 4); //Iv16ϥΦrഫ, So	Don't need Little-Exchange
//			  *(PULONG)&pTxD->Iv = RTMP_CPU_TO_LE32( *(PULONG)&pTxD->Iv	); //tt_lin_big	
			// Copy	EIV
			NdisMoveMemory(&pTxD->Eiv, &Iv32, 4); //
			//pTxD->Eiv	= RTMP_CPU_TO_LE32(	pTxD->Eiv ); //tt_lin_big
			// Set IV offset
#ifdef	WDS
			if (bWdsPacket)
			{
				TxD.IvOffset = LENGTH_802_11_WITH_ADDR4; //w2(write	back)
			}
			else
#endif
			{
				TxD.IvOffset = LENGTH_802_11; //w2(write back)
			}

			// Copy	TKey
			NdisMoveMemory(pTxD->Key, pWpaKey->Key,	16);

			// Set Cipher suite
			CipherAlg =	CIPHER_AES;
		}
		else
			CipherAlg =	CIPHER_NONE;

		//
		// Only	the	first fragment required	LLC-SNAP header	!!!
		//
		if ((StartOfFrame == TRUE) && (Encapped	== TRUE))
		{
			// For WEP & no	encryption required	frame, just	copy LLC header	into buffer,
			// Hardware	will do	the	encryption job.
			// For TKIP, we	have to	calculate MIC and store	it first
			if ((pAdapter->PortCfg.WepStatus == Ndis802_11Encryption2Enabled) 
				&& (pWpaKey != NULL) &&
				((EAPOLFrame == FALSE) || (pEntry && (pEntry->PortSecured == WPA_802_1X_PORT_SECURED)))) 
			{
				// Calculate MSDU MIC Value
				RTMPCalculateMICValue(pAdapter,	skb, pEncap, 6,	pWpaKey);
			}
			
			// Copy	LLC	header
			NdisMoveMemory(pDest, pEncap, 6);
			pDest += 6;

			// Copy	protocol type
			pSrc = (PUCHAR)	pVirtualAddress;
			NdisMoveMemory(pDest, pSrc + 12, 2);
			pDest += 2;
			
			// Exclude 802.3 header	size, we will recalculate the size at
			// the end of fragment preparation.
			Length -= 14;
			pSrc +=	14;
			FreeFragSize -=	LENGTH_802_1_H;
		}
		else if	((StartOfFrame == TRUE)	&& (Encapped ==	FALSE))
		{
			if ((pAdapter->PortCfg.WepStatus == Ndis802_11Encryption2Enabled)
				&& (pWpaKey != NULL) &&
				((EAPOLFrame == FALSE) || (pEntry && (pEntry->PortSecured == WPA_802_1X_PORT_SECURED)))) 
			{
				// Calculate MSDU MIC Value
				RTMPCalculateMICValue(pAdapter,	skb, pEncap, 0,	pWpaKey);
			}
			pSrc = (PUCHAR)	pVirtualAddress	+ 14;
			Length -= 14;
		}
		
		// Start copying payload
		BytesCopied	= 0;
		do
		{
			if (Length >= FreeFragSize)
			{
				// Copy	only the free fragment size, and save the pointer
				// of current buffer descriptor	for	next fragment buffer.
				NdisMoveMemory(pDest, pSrc,	FreeFragSize);
				BytesCopied	+= FreeFragSize;
				pSrc		+= FreeFragSize;
				pDest		+= FreeFragSize;
				Length		-= FreeFragSize;
				break;
			}
			else
			{
				// Copy	the	rest of	this buffer	descriptor pointed data
				// into	ring buffer.
				NdisMoveMemory(pDest, pSrc,	Length);
				BytesCopied	 +=	Length;
				pDest		 +=	Length;
				FreeFragSize -=	Length;
			}

			// No more buffer descriptor
			// Add MIC value if	needed
			if ((pAdapter->PortCfg.WepStatus ==	Ndis802_11Encryption2Enabled) 
				&& (MICFrag == FALSE) && (pWpaKey != NULL) &&
                ((EAPOLFrame == FALSE) || (pEntry && (pEntry->PortSecured == WPA_802_1X_PORT_SECURED))))         

			{
 				  INT i;

				Length = 8;		// Set length to MIC length

//				DBGPRINT(RT_DEBUG_INFO, "Calculated TX MIC value =");	 
//				for (i = 0; i	< 8; i++)
//                {
//                    DBGPRINT(RT_DEBUG_INFO, "%02x:", pAdapter->PrivateInfo.Tx.MIC[i]);  
//                }
//                DBGPRINT(RT_DEBUG_INFO, "\n"); 

//				DebugPrint(	"Calculated	TX MIC value =", pAdapter->PrivateInfo.Tx.MIC,8);

				if (FreeFragSize >=	Length)
				{
					NdisMoveMemory(pDest, pAdapter->PrivateInfo.Tx.MIC,	Length);
					BytesCopied	 +=	Length;
					pDest		 +=	Length;
					FreeFragSize -=	Length;
					Length = 0;
					RemainSize	 +=	8;	// Need	to add MIC as payload
				}
				else
				{
					NdisMoveMemory(pDest, pAdapter->PrivateInfo.Tx.MIC,	FreeFragSize);
					BytesCopied	 +=	FreeFragSize;
					pSrc		  =	pAdapter->PrivateInfo.Tx.MIC + FreeFragSize;
					pDest		 +=	FreeFragSize;
					Length		 -=	FreeFragSize;
					MICFrag		  =	TRUE;
					RemainSize	 +=	(8 - FreeFragSize);	// Need	to add MIC as payload
				}				 
			}
		}	while (FALSE);		 //	End	of copying payload
				
		// Real	packet size, No	802.1H header for fragments	except the first one.
		if ((StartOfFrame == TRUE) && (Encapped	== TRUE))
		{
#ifdef	WDS
			if (bWdsPacket)
			{
				TxSize = BytesCopied + LENGTH_802_11_WITH_ADDR4	+ LENGTH_802_1_H; // the length	of addr4
			}
			else
#endif
			{
				TxSize = BytesCopied + LENGTH_802_11 + LENGTH_802_1_H;
			}
		}
		else
		{
#ifdef	WDS
			if (bWdsPacket)
			{
				TxSize = BytesCopied + LENGTH_802_11_WITH_ADDR4; //	contain	the	length of addr4
			}
			else
#endif
			{
				TxSize = BytesCopied + LENGTH_802_11;
			}
		}

		RemainSize = RemainSize	- BytesCopied;
			
		if ((pAdapter->PortCfg.WepStatus ==	Ndis802_11Encryption1Enabled) && (Header_802_11.Controlhead.Frame.Wep ==	1))
		{
			// IV +	ICV	which ASIC added after encryption done
			TxSize += 8;
		}
		else if	((pAdapter->PortCfg.WepStatus == Ndis802_11Encryption2Enabled) 
		&& (pWpaKey !=	NULL) &&
        ((EAPOLFrame == FALSE) || (pEntry && (pEntry->PortSecured == WPA_802_1X_PORT_SECURED))))                 
		{
			// IV +	EIV	+ ICV which	ASIC added after encryption	done
			TxSize += 12;
		}
		else if	((pAdapter->PortCfg.WepStatus == Ndis802_11Encryption3Enabled) && (pWpaKey != NULL) && 
		        ((EAPOLFrame == FALSE) || (pEntry && (pEntry->PortSecured == WPA_802_1X_PORT_SECURED))))         

		{
			// IV +	EIV	+ HW MIC
			TxSize += 16;
		}
		
		//write	back Tx	descriptor
		*(PULONG)pTxD =	RTMP_CPU_TO_LE32( *(PULONG)&TxD	); //tt_lin_big	(w0)
		*(((PULONG)pTxD)+2)	= RTMP_CPU_TO_LE32(	*(((PULONG)&TxD)+2)	); //tt_lin_big(w2)

		// Prepare Tx descriptors before kicking tx.
		// The BBP register	index in Tx	descriptor has to be configured	too.
		if (Header_802_11.Controlhead.Addr1.Octet[0] & 0x01) 
		{
			// Multicast, retry	bit	is off
			RTMPWriteTxDescriptor(pTxD,	
									TRUE, 
									CipherAlg, 
									FALSE, 
									FALSE, 
									FALSE, 
									RetryMode, 
									FrameGap, 
									TxRate,	
									4, 
									TxSize,	
									pAdapter->PortCfg.TxPreamble, 
									AccessCategory);
		}
		else
		{
			RTMPWriteTxDescriptor(pTxD,	
									TRUE, 
									CipherAlg, 
									TRUE, 
									FALSE, 
									FALSE, 
									RetryMode, 
									FrameGap, 
									TxRate,	
									4, 
									TxSize,	
									pAdapter->PortCfg.TxPreamble, 
									AccessCategory);
		}

#if	0
		// debug print
		if (CipherAlg == CIPHER_WEP64)
		{
			PUCHAR ptr = (PUCHAR) pAdapter->TxRing[pAdapter->CurEncryptIndex].va_data_addr;
			int	i;
			DBGPRINT_RAW(RT_DEBUG_TRACE, ("RTMPHardEncrypt - Algo=%d, len=%d\n", CipherAlg,	TxSize));
			for	(i=0;i<3;i++)
			{
				DBGPRINT_RAW(RT_DEBUG_TRACE, ("%02x%02x%02x%02x-%02x%02x%02x%02x  %02x%02x%02x%02x-%02x%02x%02x%02x\n",	
					*ptr, *(ptr+1),	*(ptr+2), *(ptr+3),	*(ptr+4), *(ptr+5),	*(ptr+6), *(ptr+7),	
					*(ptr+8), *(ptr+9),	*(ptr+10), *(ptr+11), *(ptr+12), *(ptr+13),	*(ptr+14), *(ptr+15) ));
				ptr	+= 16;
			}
		}
#endif

		// Set frame gap for the rest of fragment burst.
		// It won't	matter if there	is only	one	fragment (single fragment frame).
		StartOfFrame = FALSE;
		FrameGap	 = IFS_SIFS;
		NumberRequired--;
		
		// Increase	& maintain Tx Ring Index
		pAdapter->CurEncryptIndex++;
		if (pAdapter->CurEncryptIndex >= TX_RING_SIZE)
		{
			pAdapter->CurEncryptIndex =	0;
		}
		
		pAdapter->RalinkCounters.EncryptCount++;
		
	}	while (NumberRequired >	0);

	
	// Kick	Encrypt	Control	Register at	the	end	of all ring	buffer preparation
	RTMP_IO_WRITE32(pAdapter, SECCSR1, 0x1);
	
	// Acknowledge protocol	send complete of pending packet.
	RTMPFreeSkbBuffer(skb);
	
	// Make	sure to	release	Tx ring	resource
	NdisReleaseSpinLock(&pAdapter->TxRingLock);

	return (NDIS_STATUS_SUCCESS);
}

/*
	========================================================================
	Routine	Description:
		Calculates the duration	which is required to transmit out frames 
	with given size	and	specified rate.
		
	Arguments:
		pAdapter		Pointer	to our adapter
		Rate			Transmit rate
		Size			Frame size in units	of byte
		
	Return Value:
		Duration number	in units of	usec
	========================================================================
*/
USHORT	RTMPCalcDuration(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	UCHAR			Rate,
	IN	ULONG			Size)
{
	ULONG	Duration = 0;

	if (Rate < RATE_FIRST_OFDM_RATE) //	CCK
	{
		if ((Rate >	RATE_1)	&& (pAdapter->PortCfg.TxPreamble ==	Rt802_11PreambleShort))
			Duration = 96;	// 72+24 preamble+plcp
		else
			Duration = 192;	// 144+48 preamble+plcp
			
		Duration +=	(USHORT)((Size << 4) / RateIdTo500Kbps[Rate]);
		if ((Size << 4)	% RateIdTo500Kbps[Rate])
			Duration ++;
	}
	else //	OFDM rates
	{
		Duration = 20 +	6;		// 16+4	preamble+plcp +	Signal Extension
		Duration +=	4 *	(USHORT)((11 + Size	* 4) / RateIdTo500Kbps[Rate]);
		if ((11	+ Size * 4)	% RateIdTo500Kbps[Rate])
			Duration +=	4;
	}
	
	return (USHORT)Duration;
	
}

/*
	========================================================================
	Routine	Description:
		Calculates the duration	which is required to transmit out frames 
	with given size	and	specified rate.
		
	Arguments:
		pTxD		Pointer	to transmit	descriptor
		Ack			Setting	for	Ack	requirement	bit
		Fragment	Setting	for	Fragment bit
		RetryMode	Setting	for	retry mode
		Ifs			Setting	for	IFS	gap
		Rate		Setting	for	transmit rate
		Service		Setting	for	service
		Length		Frame length
	========================================================================
*/
VOID	RTMPWriteTxDescriptor(
	IN	PTXD_STRUC	pTxD,
	IN	BOOLEAN		DoEncrypt,
	IN	UCHAR		CipherAlg,
	IN	BOOLEAN		Ack,
	IN	BOOLEAN		Fragment,
	IN	BOOLEAN		InsTimestamp,
	IN	UCHAR		RetryMode,
	IN	UCHAR		Ifs,
	IN	UINT		Rate,
	IN	UCHAR		Service,
	IN	UINT		Length,
	IN	USHORT		TxPreamble,
	IN	UCHAR		AccessCategory)
{
	UINT	Residual;
	
	TXD_STRUC TxD; //tt_lin_big

	//	No fill	the	fild: ulong->BufferAddressPa, ulong->Iv, ulong->Eiv, uchar->Key[16]
	*(PULONG)&TxD =	RTMP_LE32_TO_CPU( *(PULONG)pTxD	);				//w0
	*(((PULONG)&TxD)+2)	= RTMP_LE32_TO_CPU(	*(((PULONG)pTxD)+2)	);	//w2
	*(((PULONG)&TxD)+3)	= RTMP_LE32_TO_CPU(	*(((PULONG)pTxD)+3)	);	//w3
	*(((PULONG)&TxD)+10) = RTMP_LE32_TO_CPU( *(((PULONG)pTxD)+10) ); //w10

	//word 0
	TxD.MoreFrag	= Fragment;	//w0
	TxD.ACK			= Ack;	//w0
	TxD.Timestamp	= InsTimestamp;	//w0
	TxD.RetryMd		= RetryMode;  //w0
	TxD.IFS			= Ifs;	//w0
	TxD.DataByteCnt	= Length; //w0
	TxD.TxRate		= Rate;	//w10

	switch (AccessCategory)	// 802.11e/d4.4	June/2003
	{
		case 3:	// TC3,	<AIFSN,	CwMin, CwMax> =	<1,	aCwMin/4, aCwMin/2>
			TxD.CWmin		= CW_MIN_IN_BITS - 2;  //w2
			TxD.CWmax		= CW_MIN_IN_BITS - 1;  //w2
			TxD.Aifs		= 1; //w2
			break;
		case 2:	// TC2,	<AIFSN,	CwMin, CwMax> =	<1,	aCwMin/2, aCwMin>
			TxD.CWmin		= CW_MIN_IN_BITS - 1;  //w2
			TxD.CWmax		= CW_MIN_IN_BITS;	   //w2
			TxD.Aifs		= 1;				   //w2
			break;
		case 1:	// TC1,	<AIFSN,	CwMin, CwMax> =	<1,	aCwMin,	aCwMax>
			TxD.CWmin		= CW_MIN_IN_BITS; //w2
			TxD.CWmax		= CW_MAX_IN_BITS; //w2
			TxD.Aifs		= 1;			  //w2
			break;
		case 0:	// TC0,	<AIFSN,	CwMin, CwMax> =	<2,	aCwMin,	aCwMax>
		default:
			TxD.CWmin		= CW_MIN_IN_BITS; //w2
			TxD.CWmax		= CW_MAX_IN_BITS; //w2
			TxD.Aifs		= 2;			  //w2
			break;
	}
		
	if (Rate < RATE_FIRST_OFDM_RATE)
		TxD.Ofdm = 0; //w0
	else
		TxD.Ofdm = 1; //w0

	// fill	up PLCP	SIGNAL field
	TxD.PlcpSignal = PlcpSignal[Rate]; //w3
	if (((Rate == RATE_2)||(Rate == RATE_5_5)||(Rate ==	RATE_11))&& (TxPreamble	== Rt802_11PreambleShort)) // no short preamble	for	RATE_1
	{
		TxD.PlcpSignal |= 0x0008;  //w3
	}

	// fill	up PLCP	SERVICE	field, not used	for	OFDM rates
	TxD.PlcpService	= Service;	   //w3


	// word	3, file	up PLCP	LENGTH_LOW and LENGTH_HIGH fields
	Length += 4;
	if (Rate < RATE_FIRST_OFDM_RATE)	// 11b - RATE_1, RATE_2, RATE_5_5, RATE_11
	{
		if ((Rate == RATE_1) ||	( Rate == RATE_2))
		{
			Length = Length	* 8	/ (Rate	+ 1);
		}
		else
		{
			Residual = ((Length	* 16) %	(11	* (1 + Rate	- RATE_5_5)));
			Length = Length	* 16 / (11 * (1	+ Rate - RATE_5_5));
			if (Residual !=	0)
			{
				Length++;
			}
			if ((Residual <= (3	* (1 + Rate	- RATE_5_5))) && (Residual != 0))
			{
				TxD.PlcpService	|= 0x80; //	11b's PLCP Length extension	bit	 w3
			}
		}

		TxD.PlcpLengthHigh = Length	/ 256; //w3
		TxD.PlcpLengthLow =	Length % 256;  //w3
	}
	else	// OFDM	- RATE_6, RATE_9, RATE_12, RATE_18,	RATE_24, RATE_36, RATE_48, RATE_54
	{
		TxD.PlcpLengthHigh = Length	/ 64;  // high 6-bit of	total byte count  w3
		TxD.PlcpLengthLow =	Length % 64;   // low 6-bit	of total byte count	  w3
	}

	if (DoEncrypt == TRUE)		// Do encryption only
	{
		TxD.Owner	  =	DESC_OWN_HOST; //w0
		TxD.Valid	  =	FALSE;	//w0
		TxD.CipherAlg =	CipherAlg; //w0
		TxD.CipherOwn =	DESC_OWN_NIC; //w0
	}
	else	// Hard	transmit
	{
		TxD.Owner	  =	DESC_OWN_NIC;//w0
		TxD.Valid	  =	TRUE;//w0
		TxD.CipherAlg =	CIPHER_NONE;//w0
		TxD.CipherOwn =	DESC_OWN_HOST;//w0
	}

	//writr	back Little-endian 
	//word 0, 2, 3,	10	
	*(PULONG)pTxD =	RTMP_CPU_TO_LE32( *(PULONG)&TxD	); //w0
	*(((PULONG)pTxD)+2)	= RTMP_CPU_TO_LE32(	*(((PULONG)&TxD)+2)	); //w2
	*(((PULONG)pTxD)+3)	= RTMP_CPU_TO_LE32(	*(((PULONG)&TxD)+3)	); //w3
	*(((PULONG)pTxD)+10) = RTMP_CPU_TO_LE32( *(((PULONG)&TxD)+10) ); //w10
	/////////////////////
}

/*
	========================================================================
	Routine	Description:
		Search tuple cache for receive duplicate frame from	unicast	frames.
		
	Arguments:
		pAdapter		Pointer	to our adapter
		pHeader			802.11 header of receiving frame
		
	Return Value:
		TRUE			found matched tuple	cache
		FALSE			no matched found
	========================================================================
*/
BOOLEAN	RTMPSearchTupleCache(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PHEADER_802_11	pHeader)
{
	INT	Index;

	HEADER_802_11  Header; //tt_lin_big
	//Frag,	Sequence
	*(((PUSHORT)&Header)+11) = RTMP_LE16_TO_CPU( *(((PUSHORT)pHeader)+11) ); //tt_lin_big

	for	(Index = 0;	Index <	MAX_CLIENT;	Index++)
	{
		// Tuple cache filled sequencially.	If not valid, the rest following this entry
		// are invalid too.
		if (pAdapter->TupleCache[Index].Valid == FALSE)
			continue;
				
		if (RTMPEqualMemory(&pAdapter->TupleCache[Index].MAC, &pHeader->Controlhead.Addr2, 6) &&
			(pAdapter->TupleCache[Index].Sequence == Header.Sequence) && //s11
			(pAdapter->TupleCache[Index].Frag == Header.Frag)) //s11
		{
			return (TRUE);
		}
	}
	return (FALSE);
}

/*
	========================================================================
	Routine	Description:
		Update tuple cache for new received	unicast	frames.
		
	Arguments:
		pAdapter		Pointer	to our adapter
		pHeader			802.11 header of receiving frame
	========================================================================
*/
VOID	RTMPUpdateTupleCache(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PHEADER_802_11	pHeader)
{
	UCHAR Index;
	HEADER_802_11	Header;

	//*(PUSHORT)&Header	= RTMP_LE16_TO_CPU(	*(PUSHORT)pHeader );

	*(((PUSHORT)&Header)+11) = RTMP_LE16_TO_CPU( *(((PUSHORT)pHeader)+11) );

	for	(Index = 0;	Index <	MAX_CLIENT;	Index++)
	{
		if (pAdapter->TupleCache[Index].Valid == FALSE)
		{
			// Add new entry
			NdisMoveMemory(&pAdapter->TupleCache[Index].MAC, &pHeader->Controlhead.Addr2, 6);
			pAdapter->TupleCache[Index].Sequence = Header.Sequence;
			pAdapter->TupleCache[Index].Frag	 = Header.Frag;
			pAdapter->TupleCache[Index].Valid	 = TRUE;
			return;
		}
		else if	(RTMPEqualMemory(&pAdapter->TupleCache[Index].MAC, &pHeader->Controlhead.Addr2,	6))
		{
			// Update old entry
			pAdapter->TupleCache[Index].Sequence = Header.Sequence;	
			pAdapter->TupleCache[Index].Frag	 = Header.Frag;	
			return;
		}
	}
	// tuple cache full, replace the first inserted	one	(even though it	may	not	be
	// least referenced	one)
	if (Index == MAX_CLIENT)
	{
		pAdapter->TupleCacheLastUpdateIndex	++;
		if (pAdapter->TupleCacheLastUpdateIndex	>= MAX_CLIENT)
			pAdapter->TupleCacheLastUpdateIndex	= 0;
		Index =	pAdapter->TupleCacheLastUpdateIndex;

		// replace with	new	entry
		NdisMoveMemory(&pAdapter->TupleCache[Index].MAC, &pHeader->Controlhead.Addr2, 6);
		pAdapter->TupleCache[Index].Sequence = Header.Sequence;	//s11
		pAdapter->TupleCache[Index].Frag	 = Header.Frag;	 //s11
		pAdapter->TupleCache[Index].Valid	 = TRUE;
//		DBGPRINT(RT_DEBUG_INFO,"DUPCHECK - replace Entry %d, MAC=%02x:%02x:%02x:%02x:%02x:%02x\n", 
//			Index, pAdapter->TupleCache[Index].MAC.Octet[0], pAdapter->TupleCache[Index].MAC.Octet[1],
//			pAdapter->TupleCache[Index].MAC.Octet[2], pAdapter->TupleCache[Index].MAC.Octet[3],
//			pAdapter->TupleCache[Index].MAC.Octet[4], pAdapter->TupleCache[Index].MAC.Octet[5]);
	}
}

/*
	========================================================================
	Routine	Description:
		Check Rx descriptor, return	NDIS_STATUS_FAILURE	if any error found
	========================================================================
*/
NDIS_STATUS	RTMPCheckRxDescriptor(
	IN	PRXD_STRUC	pRxD)
{
	RXD_STRUC  RxD;

	*(PULONG)&RxD =	RTMP_LE32_TO_CPU( *(PULONG)pRxD	);

	if (RxD.PhyErr)	//w0
	{
		DBGPRINT( RT_DEBUG_WARN, "RTMPCheckRxDescriptor-PhyErr\n" );
		return NDIS_STATUS_FAILURE;
	}else if (RxD.Crc) //w0
	{	
		DBGPRINT( RT_DEBUG_WARN, "RTMPCheckRxDescriptor-Crc\n" );
		return NDIS_STATUS_FAILURE;
	}else
		return NDIS_STATUS_SUCCESS;
}

/*
  ========================================================================
  Return:
	NDIS_STATUS_SUCCESS	- This received	unicast	frame is NOT a duplicate
	NDIS_STATUS_FAILURE	- received frame is	duplicated and should be dropped
  ========================================================================
*/
NDIS_STATUS	RTMPCheckDuplicateFrame(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PHEADER_802_11	pHeader)
{
	HEADER_802_11	Header;
	
	*(PUSHORT)&Header =	RTMP_LE16_TO_CPU( *(PUSHORT)pHeader	);

	if (Header.Controlhead.Frame.Retry)//s0
	{
		if (RTMPSearchTupleCache(pAdapter, pHeader)	== TRUE)
		{
			// Found retry frame in	tuple cache, Discard this frame	/ fragment
			// Increase	802.11 counters
			INC_COUNTER(pAdapter->WlanCounters.FrameDuplicateCount);
			return NDIS_STATUS_FAILURE;
		}
	}
	RTMPUpdateTupleCache(pAdapter, pHeader);
	return NDIS_STATUS_SUCCESS;
}

/*
  ========================================================================
  Description:
	This routine checks	if a received frame	causes class 2 or class	3
	error, and perform error action	(DEAUTH	or DISASSOC) accordingly
  ========================================================================
*/
BOOLEAN	RTMPCheckClass2Class3Error(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PHEADER_802_11	pHeader)
{
	SST	Sst;
	UCHAR PsMode, Rate;
	USHORT Aid;
						
	SsPsInquiry(pAdapter, &pHeader->Controlhead.Addr2, &Sst, &Aid, &PsMode,	&Rate);
	if (Sst	== SST_ASSOC)
		; // okay to receive this DATA frame
	else if	(Sst ==	SST_AUTH)
	{
		Cls3errAction(pAdapter,	&pHeader->Controlhead.Addr2);
		return TRUE; 
	}
	else
	{
		Cls2errAction(pAdapter,	&pHeader->Controlhead.Addr2);
		return TRUE; 
	}
	return FALSE;
}

/*
  ========================================================================
  Description:
	This routine frees all packets in PSQ that's destined to a specific	DA.
	BCAST/MCAST	in DTIMCount=0 case	is also	handled	here, just like	a PS-POLL 
	is received	from a WSTA	which has MAC address FF:FF:FF:FF:FF:FF
  ========================================================================
*/
VOID RTMPHandleRxPsPoll(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PMACADDR		pAddr,
	IN	USHORT			Aid)
{
	PQUEUE_ENTRY	  pEntry;
	PMAC_TABLE_ENTRY  pMacEntry;
	
	//DBGPRINT(RT_DEBUG_TRACE,("rcv	PS-POLL	(AID=%d) from %02x:%02x:%02x:%02x:%02x:%02x\n",	
	//	  Aid, pAddr->Octet[0],	pAddr->Octet[1], pAddr->Octet[2], pAddr->Octet[3], pAddr->Octet[4],	pAddr->Octet[5]));

	pMacEntry =	MacTableLookup(pAdapter, pAddr);
	
	if (pMacEntry)
	{
		Aid	= pMacEntry->Aid;
		NdisAcquireSpinLock(&pAdapter->MacTabLock);
		NdisAcquireSpinLock(&pAdapter->TxSwQueueLock);
		// cleanup all backlogged frames in	PSQ
		while (pMacEntry->PsQueue.Head)
		{
			pEntry = RemoveHeadQueue(&pMacEntry->PsQueue);
			InsertTailQueue(&pAdapter->TxSwQueue0, pEntry);
			DBGPRINT(RT_DEBUG_TRACE, "rx PSPOLL, tx	frame out...\n");
		}
		NdisReleaseSpinLock(&pAdapter->TxSwQueueLock);
		NdisReleaseSpinLock(&pAdapter->MacTabLock);
		if ((Aid > 0) && (Aid <	MAX_LEN_OF_MAC_TABLE))
			pAdapter->Mlme.TimBitmap &=	(~Bit[Aid]);  
		pMacEntry->PsQIdleCount	= 0;

		// Dequeue one frame from TxSwQueue0..3	queue and process it
		// There are two place calling dequeue for TX ring.
		// 1. Here,	right after	queueing the frame.
		// 2. At the end of	TxRingTxDone service routine.
		// 3. Within RTMPBridgeToWirelessSta() service routine
		if ((!RTMP_TEST_FLAG(pAdapter, fRTMP_ADAPTER_BSS_SCAN_IN_PROGRESS))	&& (!RTMP_TEST_FLAG(pAdapter, fRTMP_ADAPTER_RESET_IN_PROGRESS)))
		{
			RTMPDeQueuePacket(pAdapter);
		}	
	}
}

/*
	========================================================================
	Routine	Description:
		This function checks if	the	received frames	should be sent out to the 
		wireless media based on	DA look-up in the wirelss MAC table.
		
	Arguments:
		pRxD		Pointer	to the Rx descriptor
		
	Return Value:
		TRUE -	the	input frame	is destined	to a known wireless	STA	
				and	had	being sent out to the wireless media. It's not 
				necessary to make another copy up to LLC nor Portal	function.
		FALSE -	the	input frame	still need to deliver to the upper LLC
	========================================================================
*/
BOOLEAN	RTMPBridgeToWirelessSta(
	IN	PRTMP_ADAPTER	pAdapter,
	IN	PUCHAR			pHeader802_3,
	IN	UINT			HdrLen,
	IN	PUCHAR			pData,
	IN	UINT			DataLen)
{
	SST				Sst;
	USHORT			Aid;
	UCHAR			PsMode,	Rate;
	MAC_TABLE_ENTRY	*pEntry;
	BOOLEAN			result = FALSE;
	struct sk_buff *skb;
	
	DBGPRINT( RT_DEBUG_INFO, "-->RTMPBridgeToWirelessSta\n"	);

	// decide the return value.	TRUE if	no need	to indicate	to LLC,	FALSE otherwise
	pEntry = SsPsInquiry(pAdapter, (MACADDR	*)pHeader802_3,	&Sst, &Aid,	&PsMode, &Rate);
	if (pHeader802_3[0]	& 0x01)
		result = FALSE;
	else if	(pEntry	&& (Sst	== SST_ASSOC)) 
		result = TRUE;
	else
		result = FALSE;
	
	if ((pAdapter->PortCfg.IsolateInterStaTraffic == 0)	&& ((pHeader802_3[0] & 0x01) ||	(pEntry	&& (Sst	== SST_ASSOC))))
	{
		NDIS_STATUS		Status;
//		  UCHAR			  *pVirtualAddress;

		do {
			// 1. build	a NDIS packet and call RTMPSendPacket();
			//	  be careful about how/when	to release this	internal allocated NDIS	PACKET buffer
			if ((skb = dev_alloc_skb(HdrLen	+ DataLen +	2))	!= NULL)
			{
				skb->len = HdrLen +	DataLen;
				memcpy((skb->data), pHeader802_3, HdrLen);
				memcpy((skb->data + HdrLen), pData, DataLen);
			}
			else
			{
				break;
			}
			// 2. send out the packet
			DBGPRINT(RT_DEBUG_INFO,"WBRG - len=%d, DA=%02x:%02x:%02x:%02x:%02x:%02x, SA=%02x:%02x:%02x:%02x:%02x:%02x\n", 
				HdrLen+DataLen,pHeader802_3[0],pHeader802_3[1],pHeader802_3[2],pHeader802_3[3],pHeader802_3[4],pHeader802_3[5],
				pHeader802_3[6],pHeader802_3[7],pHeader802_3[8],pHeader802_3[9],pHeader802_3[10],pHeader802_3[11]);

			Status = RTMPSendPacket(pAdapter, skb);
			if (Status == NDIS_STATUS_SUCCESS)
			{
				// Dequeue one frame from TxSwQueue0..3	queue and process it
				// There are three place calling dequeue for TX	ring.
				// 1. Here,	right after	queueing the frame.
				// 2. At the end of	TxRingTxDone service routine.
				// 3. Upon NDIS	call RTMPSendPackets
				if ((!RTMP_TEST_FLAG(pAdapter, fRTMP_ADAPTER_BSS_SCAN_IN_PROGRESS))	&& (!RTMP_TEST_FLAG(pAdapter, fRTMP_ADAPTER_RESET_IN_PROGRESS)))
				{
					RTMPDeQueuePacket(pAdapter);
				}	
			}
			else //	free this packet space
			{
				RTMPFreeSkbBuffer(skb);
			}

		} while	(FALSE);
	}

	return result;
}

/*
  ========================================================================
	Routine	Description:
		Check and fine the packet waiting in SW	queue with highest priority
		
	Arguments:
		pAdapter	Pointer	to our adapter
		
	Return Value:
		pQueue		Pointer	to Waiting Queue

	Note:
	
	========================================================================
*/
PQUEUE_HEADER	RTMPCheckTxSwQueue(
	IN	PRTMP_ADAPTER	pAdapter,
	OUT	ULONG			*Number,
	OUT	UCHAR			*AccessCategory)
{
	// Calculate total number of packets waiting in	queues for Nitro mode 
	*Number	= pAdapter->TxSwQueue3.Number +	pAdapter->TxSwQueue2.Number	+ pAdapter->TxSwQueue1.Number +
		pAdapter->TxSwQueue0.Number;
	
	if (pAdapter->TxSwQueue3.Head != NULL)
	{
		*AccessCategory	= 3;
		return (&pAdapter->TxSwQueue3);
	}
	else if	(pAdapter->TxSwQueue2.Head != NULL)
	{
		*AccessCategory	= 2;
		return (&pAdapter->TxSwQueue2);
	}
	else if	(pAdapter->TxSwQueue1.Head != NULL)
	{
		*AccessCategory	= 1;
		return (&pAdapter->TxSwQueue1);
	}
	else if	(pAdapter->TxSwQueue0.Head != NULL)
	{
		*AccessCategory	= 0;
		return (&pAdapter->TxSwQueue0);
	}

	// No packet pending in	Tx Sw queue
	*AccessCategory	= 0;
	return (NULL);
}


