#ifndef	MD5_H
#define	MD5_H

#define	MD5_MAC_LEN	16

struct MD5Context {
	UINT buf[4];
	UINT bits[2];
	UCHAR in[64];
};

void MD5Init(struct	MD5Context *context);
void MD5Update(struct MD5Context *context, unsigned	char const *buf,
		   unsigned	len);
void MD5Final( OUT unsigned	char digest[16], IN	OUT	struct MD5Context *context);
void MD5Transform( IN OUT UINT buf[4], IN UINT const in[16]);

typedef	struct MD5Context MD5_CTX;


void md5_mac(IN	UCHAR *key,	IN size_t key_len, IN UCHAR	*data, IN size_t data_len, OUT UCHAR *mac);
void hmac_md5(IN UCHAR *key, IN	size_t key_len,	IN UCHAR *data,	IN size_t data_len,	OUT	UCHAR *mac);

#endif /* MD5_H	*/

#ifndef	_AES_H
#define	_AES_H

typedef	struct
{
	UINT erk[64];	  /* encryption	round keys */
	UINT drk[64];	  /* decryption	round keys */
	INT	nr;				/* number of rounds	*/
}
aes_context;

INT	 aes_set_key( aes_context *ctx,	UCHAR *key,	INT	nbits );
VOID aes_encrypt( aes_context *ctx,	UCHAR input[16], UCHAR output[16] );
VOID aes_decrypt( aes_context *ctx,	UCHAR input[16], UCHAR output[16] );

#endif /* aes.h	*/
