/****************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 * (c) Copyright 2002, Ralink Technology, Inc.
 *
 * All rights reserved. Ralink's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Ralink Technology, Inc. is obtained.
 ****************************************************************************

	Module Name:
	auth.c
 
	Abstract:
	Handle de-auth request from local MLME
 
	Revision History:
	Who         When          What
	--------    ----------    ----------------------------------------------
	John Chang  08-04-2003    created for 11g soft-AP
 */

#include "rt_config.h"

/*
	==========================================================================
	Description:
		authenticate state machine init, including state transition and timer init
	Parameters:
		Sm - pointer to the auth state machine
	Note:
		The state machine looks like this
		
									AUTH_REQ_IDLE           
		MT2_MLME_DEAUTH_REQ     mlme_deauth_req_action  
	==========================================================================
 */
void AuthStateMachineInit(
	IN PRTMP_ADAPTER pAd, 
	IN STATE_MACHINE *Sm, 
	OUT STATE_MACHINE_FUNC Trans[]) 
{
	StateMachineInit(Sm, (STATE_MACHINE_FUNC*)Trans, MAX_AUTH_STATE, MAX_AUTH_MSG, (STATE_MACHINE_FUNC)Drop, AUTH_REQ_IDLE, AUTH_MACHINE_BASE);
	 
	// the first column
	StateMachineSetAction(Sm, AUTH_REQ_IDLE, MT2_MLME_DEAUTH_REQ, (STATE_MACHINE_FUNC)MlmeDeauthReqAction);
}//end of AuthStateMachineInit()

/*
	==========================================================================
	Description:
		Upper Layer request to kick out a STA
	==========================================================================
 */
VOID MlmeDeauthReqAction(
	IN PRTMP_ADAPTER pAd, 
	IN MLME_QUEUE_ELEM *Elem) 
{
	MLME_DEAUTH_REQ_STRUCT *pInfo;
	MACHDR        Hdr;
	UCHAR        *OutBuffer = NULL;
	ULONG         FrameLen = 0;
	MAC_TABLE_ENTRY *pEntry;


	pInfo = (MLME_DEAUTH_REQ_STRUCT *)Elem->pMsg;

	pEntry = MacTableLookup(pAd, &pInfo->Addr);

	if (pEntry)
	{
		if(pEntry->RetryTimerRunning==TRUE)
		{
			del_timer_sync(&pEntry->RetryTimer);
		}
		// 1. remove this STA from MAC table
		ApLogEvent(pAd, &pInfo->Addr, EVENT_DISASSOCIATED);
		MacTableDeleteEntry(pAd, &pInfo->Addr);

		// 2. send out DE-AUTH request frame
		OutBuffer = kmalloc(MAX_LEN_OF_MLME_BUFFER, GFP_KERNEL);
		if(OutBuffer == NULL)
			return;
		
		DBGPRINT(RT_DEBUG_TRACE, "AUTH - Send DE-AUTH req to %02x:%02x:%02x:%02x:%02x:%02x\n",
			pInfo->Addr.Octet[0],pInfo->Addr.Octet[1],pInfo->Addr.Octet[2],
			pInfo->Addr.Octet[3],pInfo->Addr.Octet[4],pInfo->Addr.Octet[5]);
		
		MgtMacHeaderInit(pAd, &Hdr, SUBTYPE_DEAUTH, 0, &pInfo->Addr, &pAd->PortCfg.Bssid);
		
		//Reason = RTMP_CPU_TO_LE16(pInfo->Reason); //tt_lin_big, Reason is Little-endian
		
		MakeOutgoingFrame(OutBuffer,            &FrameLen, 
						  sizeof(MACHDR),       &Hdr, 
						  2,                    &pInfo->Reason,
						  END_OF_ARGS);
		
		MiniportMMRequest(pAd, OutBuffer, FrameLen);
	}
}//end of MlmeDeauthReqAction()

/*
	==========================================================================
	Description:
		Some STA/AP
	Note:
		This action should never trigger AUTH state transition, therefore we
		separate it from AUTH state machine, and make it as a standalone service
	==========================================================================
 */
VOID Cls2errAction(
	IN PRTMP_ADAPTER pAd, 
	IN PMACADDR pAddr) 
{
	MACHDR        Hdr;
	UCHAR        *OutBuffer = NULL;
	ULONG         FrameLen = 0;
	USHORT        Reason = REASON_CLS2ERR;
	MAC_TABLE_ENTRY *pEntry;

	pEntry = MacTableLookup(pAd, pAddr);
	if (pEntry)
	{
		//ApLogEvent(pAd, pAddr, EVENT_DISASSOCIATED);
		MacTableDeleteEntry(pAd, pAddr);
	}

	// send out DEAUTH request frame 
	OutBuffer = kmalloc(MAX_LEN_OF_MLME_BUFFER, GFP_KERNEL);
	if(OutBuffer == NULL)
		return;

	DBGPRINT(RT_DEBUG_TRACE, 
		"AUTH - Class 2 error, Send DEAUTH frame to %02x:%02x:%02x:%02x:%02x:%02x\n",
		pAddr->Octet[0],pAddr->Octet[1],pAddr->Octet[2],pAddr->Octet[3],
		pAddr->Octet[4],pAddr->Octet[5]);
	
	MgtMacHeaderInit(pAd, &Hdr, SUBTYPE_DEAUTH, 0, pAddr, &pAd->PortCfg.Bssid);
	
	Reason = RTMP_CPU_TO_LE16(Reason); //tt_lin_big 
	MakeOutgoingFrame(OutBuffer,            &FrameLen, 
					  sizeof(MACHDR),       &Hdr, 
					  2,                    &Reason, 
					  END_OF_ARGS);

	MiniportMMRequest(pAd, OutBuffer, FrameLen);
}//end of Cls2errAction()


